/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.mdc.filterbar.p13n.FilterGroupLayout.
sap.ui.define(['sap/ui/core/Control'], (Control) => {
	"use strict";

	/**
	 * Constructor for a new filterBar/p13n/FilterGroupLayout.
	 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] Initial settings for the new control
	 * @class Represents a filter item on the UI and displays the label above the FilterField
	 * @extends sap.ui.core.Control
	 * @constructor
	 * @private
	 * @since 1.82.0
	 * @alias sap.ui.mdc.filterbar.p13n.FilterGroupLayout
	 */
	const FilterGroupLayout = Control.extend("sap.ui.mdc.filterbar.p13n.FilterGroupLayout", {
		metadata: {
			library: "sap.ui.mdc"
		},
		renderer: {
			apiVersion: 2,
			render: function(oRm, oControl) {
				oRm.openStart("div", oControl);
				oRm.style("height", "100%");
				oRm.openEnd();
				oRm.renderControl(oControl.getItems()[0]);
				oRm.close("div");
			}
		}
	});

	FilterGroupLayout.prototype._getFieldPath = function() {
		return this._oFilterField ? this._oFilterField.getPropertyKey() : null;
	};

	FilterGroupLayout.prototype.setFilterField = function(oFilterField) {
		this._oFilterField = oFilterField;
	};

	FilterGroupLayout.prototype.getIdForLabel = function() {
		return this._oFilterField && this._oFilterField.getIdForLabel();
	};

	FilterGroupLayout.prototype.getAccessibilityInfo = function() {
		return {
			children: this.getItems()
		};
	};

	FilterGroupLayout.prototype.getItems = function() {
		const aContent = [];
		aContent.push(this._oFilterField);
		return aContent;
	};

	FilterGroupLayout.prototype.exit = function() {
		Control.prototype.exit.apply(this, arguments);
		this._oFilterField = null;
	};

	return FilterGroupLayout;

});