/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.mdc.filterbar.vh.CollectiveSearchSelect.
sap.ui.define([
	"sap/ui/mdc/valuehelp/CollectiveSearchSelect"
], (ValueHelpCollectiveSearchSelect) => {
	"use strict";
	/**
	 * Constructor for a new <code>CollectiveSearchSelect</code>.
	 * @param {string} [sId] - ID for the new control, generated automatically if no ID is given
	 * @param {object} [mSettings] - Initial settings for the new control
	 * @class Can be used to manage the <code>CollectiveSearchSelect</code> control search items.
	 * @extends sap.ui.mdc.valuehelp.CollectiveSearchSelect
	 * @constructor
	 * @private
	 * @ui5-restricted sap.ui.mdc
	 * @since 1.87
	 * @alias sap.ui.mdc.filterbar.vh.CollectiveSearchSelect
	 * @deprecated since 1.124.0 - Please use the <code>sap.ui.mdc.valuehelp.CollectiveSearchSelect</code> control instead.
	 */
	const CollectiveSearchSelect = ValueHelpCollectiveSearchSelect.extend("sap.ui.mdc.filterbar.vh.CollectiveSearchSelect", /** @lends sap.ui.mdc.valuehelp.CollectiveSearchSelect.prototype */ {
		metadata: {
			library: "sap.ui.mdc"
		},
		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 * @param {sap.ui.core.RenderManager} oRm - <code>RenderManager</code> that can be used for writing to the render output buffer
		 * @param {sap.ui.core.Control} oControl - Object representation of the control that is rendered
		 */
		renderer: ValueHelpCollectiveSearchSelect.getMetadata().getRenderer()
	});

	return CollectiveSearchSelect;
});