/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define([
	"sap/ui/mdc/valuehelp/FilterBar"
], (ValueHelpFilterBar) => {
	"use strict";
		/**
		 * Modules for value help dialog {@link sap.ui.mdc.filterbar.vh.FilterBar FilterBar}
		 * @namespace
		 * @name sap.ui.mdc.filterbar.vh
		 * @since 1.84.0
		 * @public
		 */

		/**
		 * Constructor for a new <code>FilterBar</code> for a value help dialog.
		 * @param {string} [sId] ID for the new control, generated automatically if no ID is given
		 * @param {object} [mSettings] initial settings for the new control
		 * @class The <code>FilterBar</code> control is used to display filter properties in a user-friendly manner to populate values for a query.
		 * The filters are arranged in a logical row that is divided depending on the space available and the width of the filters.
		 * The Go button triggers the search event, and the Show Filters button shows the additional filter field.<br>
		 * The <code>FilterBar</code> control creates and handles the filters based on the provided metadata information.
		 * The metadata information is provided via the {@link module:sap/ui/mdc/FilterBarDelegate FilterBarDelegate} implementation. This implementation has to be provided by the application.<br>
		 * <b>Note:</b> The <code>FilterBar</code> can only be used for a {@link sap.ui.mdc.valuehelp.Dialog Dialog} and not on its own.
		 * @extends sap.ui.mdc.valuehelp.FilterBar
		 * @author SAP SE
		 * @version 1.136.0
		 * @constructor
		 * @public
		 * @since 1.84.0
		 * @alias sap.ui.mdc.filterbar.vh.FilterBar
		 * @deprecated since 1.124.0 - Please use the <code>sap.ui.mdc.valuehelp.FilterBar</code> control instead.
		 */
		const FilterBar = ValueHelpFilterBar.extend("sap.ui.mdc.filterbar.vh.FilterBar",{
			metadata: {
				library: "sap.ui.mdc"
			},
			renderer: ValueHelpFilterBar.getMetadata().getRenderer()
		});

		return FilterBar;
	}
);