/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/link/SemanticObjectMapping","sap/ui/mdc/link/SemanticObjectMappingItem","sap/ui/mdc/link/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],(e,t,n,i,a,c,o,r,s,l,u,f)=>{"use strict";const m=Object.assign({},n);m.fetchLinkItems=function(e,t,n){const i=e.getPayload();const a=t?t.getObject(t.getPath()):undefined;const o=[];if(n){n.initialize(m._getSemanticObjects(i));o.forEach(e=>{n.addIntent(c.IntentType.API,{text:e.getText(),intent:e.getHref()})})}const r=m._calculateSemanticAttributes(a,i,n);return m._retrieveNavigationTargets("",r,i,n).then((e,t)=>Promise.resolve(e))};m.fetchLinkType=function(e){const t={};let n=null;const i=e.getPayload();const c=function(e){return e.filter(e=>!t[e]).length===0};const r=function(e){return e.some(e=>t[e]&&t[e].exists===true)};const s=async function(){if(!n){const{promise:e,resolve:i}=Promise.withResolvers();n=e;const c=await a.getServiceAsync("CrossApplicationNavigation");if(!c){o.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");i({});return}c.getDistinctSemanticObjects().then(e=>{e.forEach(e=>{t[e]={exists:true}});n=null;return i(t)},()=>{o.error("FlpLinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return i({})})}return n};const l=function(e){if(c(e)){return Promise.resolve(r(e))}return s().then(()=>r(e))};if(i&&i.semanticObjects){return l(i.semanticObjects).then(e=>Promise.resolve({type:e?f.Popover:f.Text,directLink:undefined}))}else{throw new Error("no payload or semanticObjects found")}};m._calculateSemanticAttributes=function(e,t,n){const i=m._getSemanticObjects(t);const a=m._convertSemanticObjectMapping(m._getSemanticObjectMappings(t));if(!i.length){i.push("")}const c={};i.forEach(t=>{if(n){n.addContextObject(t,e)}c[t]={};for(const i in e){let s=null,l=null;if(n){s=n.getSemanticObjectAttribute(t,i);if(!s){s=n.createAttributeStructure();n.addSemanticObjectAttribute(t,i,s)}}if(e[i]===undefined||e[i]===null){if(s){s.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in FlpLinkDelegate."})}continue}if(r(e[i])){if(s){s.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in FlpLinkDelegate."})}continue}const u=a&&a[t]&&a[t][i]?a[t][i]:i;if(s&&i!==u){l={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+u+" in FlpLinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+t+" with source attribute "+i+" and target attribute "+u+". You can modify the annotation if the mapping result is not what you expected."}}if(c[t][u]){o.error("FlpLinkDelegate: The attribute "+i+" can not be renamed to the attribute "+u+" due to a clash situation. This can lead to wrong navigation later on.")}c[t][u]=e[i];if(s){if(l){s.transformations.push(l);const a=n.createAttributeStructure();a.transformations.push({value:e[i],description:"ℹ The attribute "+u+" with the value "+e[i]+" has been added due to a mapping rule regarding the attribute "+i+" in FlpLinkDelegate."});n.addSemanticObjectAttribute(t,u,a)}}}});return c};m._retrieveNavigationTargets=function(n,c,r,s){if(!r.semanticObjects){return new Promise(e=>{e([])})}const l=r.semanticObjects;const u=r.sourceControl;const f={ownNavigation:undefined,availableActions:[]};return t.load({name:"sap.ui.fl"}).then(()=>new Promise(t=>{sap.ui.require(["sap/ui/fl/Utils"],p=>{const b=a.getService("CrossApplicationNavigation");const g=a.getService("URLParsing");if(!b||!g){o.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return t(f.availableActions,f.ownNavigation)}const d=e.getElementById(u);const h=p.getAppComponentForControl(d);const v=l.map(e=>[{semanticObject:e,params:c?c[e]:undefined,appStateKey:n,ui5Component:h,sortResultsBy:"text"}]);return new Promise(()=>{b.getLinks(v).then(e=>{if(!e||!e.length){return t(f.availableActions,f.ownNavigation)}const n=m._getSemanticObjectUnavailableActions(r);const a=m._convertSemanticObjectUnavailableAction(n);let c=b.hrefForExternal();if(c&&c.indexOf("?")!==-1){c=c.split("?")[0]}if(c){c+="?"}const o=function(e,t){return!!a&&!!a[e]&&a[e].indexOf(t)>-1};const u=function(e){const t=g.parseShellHash(e.intent);if(o(t.semanticObject,t.action)){return}const n=b.hrefForExternal({target:{shellHash:e.intent}},h);if(e.intent&&e.intent.indexOf(c)===0){f.ownNavigation=new i({href:n,text:e.text,internalHref:e.intent});return}const a=new i({key:t.semanticObject&&t.action?t.semanticObject+"-"+t.action:undefined,text:e.text,description:undefined,href:n,internalHref:e.intent,icon:undefined,initiallyVisible:e.tags&&e.tags.indexOf("superiorAction")>-1});f.availableActions.push(a);if(s){s.addSemanticObjectIntent(t.semanticObject,{intent:a.getHref(),text:a.getText()})}};for(let t=0;t<l.length;t++){e[t][0].forEach(u)}return t(f.availableActions,f.ownNavigation)},()=>{o.error("FlpLinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return t(f.availableActions,f.ownNavigation)})})})}))};m._getSemanticObjects=function(e){return e.semanticObjects?e.semanticObjects:[]};m._getSemanticObjectUnavailableActions=function(e){const t=[];if(e.semanticObjectUnavailableActions){e.semanticObjectUnavailableActions.forEach(e=>{t.push(new u({semanticObject:e.semanticObject,actions:e.actions}))})}return t};m._getSemanticObjectMappings=function(e){const t=[];let n=[];if(e.semanticObjectMappings){e.semanticObjectMappings.forEach(e=>{n=[];if(e.items){e.items.forEach(e=>{n.push(new l({key:e.key,value:e.value}))})}t.push(new s({semanticObject:e.semanticObject,items:n}))})}return t};m._convertSemanticObjectMapping=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getItems().reduce((e,t)=>{e[t.getKey()]=t.getValue();return e},{})});return t};m._convertSemanticObjectUnavailableAction=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getActions()});return t};return m});
//# sourceMappingURL=FlpLinkDelegate.js.map