//@ui5-bundle sap/ui/mdc/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ActionToolbar", ["sap/ui/core/Element","sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator","sap/m/library","sap/ui/mdc/enums/ActionToolbarActionAlignment","sap/ui/mdc/p13n/subcontroller/ActionToolbarController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin"],(t,e,o,n,i,r,s,a,g,p)=>{"use strict";const{OverflowToolbarPriority:l}=r;const c=e.extend("sap.ui.mdc.ActionToolbar",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbar.designtime",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true},_endOrder:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.mdc.actiontoolbar.ActionToolbarAction",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},renderer:o});const d=["begin","between","actions","end"];const u=function(){const t={canOverflow:true,getCustomImportance:function(){return l.NeverOverflow}};return t};c.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oBeginSeparator=new i({visible:false});this._oBeginSeparator.getOverflowToolbarConfig=u;this._oEndActionsBeginSeparator=new i({visible:false});this._oEndActionsBeginSeparator.getOverflowToolbarConfig=u;this._oEndActionsEndSeparator=new i({visible:false});this._oEndActionsEndSeparator.getOverflowToolbarConfig=u;this._oSpacer=new n;this.setUseAsHeader(true);g.getInstance().register(this,{controller:{actionsKey:new a({control:this})}})};c.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oBeginSeparator){this._oBeginSeparator.destroy()}if(this._oEndActionsBeginSeparator){this._oEndActionsBeginSeparator.destroy()}if(this._oEndActionsEndSeparator){this._oEndActionsEndSeparator.destroy()}if(this._oSpacer){this._oSpacer.destroy()}};c.prototype.setProperty=function(t){if(t==="_endOrder"){this._bEnforceEndOrder=true}return e.prototype.setProperty.apply(this,arguments)};c.prototype.addAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}const n=arguments;if(d.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("addAggregation",n);this._updateSeparators();return t}return e.prototype.addAggregation.apply(this,arguments)};c.prototype.destroyAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(d.includes(t)){const e=this.removeAllAggregation(t);for(let t=0;t<e.length;t++){e[t].destroy()}this._updateSeparators();return this}return e.prototype.destroyAggregation.apply(this,arguments)};c.prototype.insertAggregation=function(t,o,n){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}if(d.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("insertAggregation",arguments);this._updateSeparators();return t}return e.prototype.insertAggregation.apply(this,arguments)};c.prototype.removeAllAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}return e.prototype.removeAllAggregation.apply(this,arguments)};c.prototype.removeAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(d.includes(t)){const t=this._callToolbarMethod("removeAggregation",arguments);if(t){this._getPopover().removeAssociatedContent(t.getId())}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(t);this._removeContentFromControlsCollections(t);this._updateSeparators();return t}return e.prototype.removeAggregation.apply(this,arguments)};c.prototype.setUseAsHeader=function(t){this.setProperty("useAsHeader",t,true);this.toggleStyleClass("sapMTBHeader-CTX",!!t);return this};c.prototype.getEndActionsBegin=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.Begin})};c.prototype.getEndActionsEnd=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.End})};c.prototype.getActionsWithLayoutInformation=function(t){return this.getActions().filter(e=>{const o=e.getLayoutInformation();return o.aggregationName===t.aggregationName&&o.alignment===t.alignment})};c.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this._bEnforceEndOrder){this.getProperty("_endOrder").reduce((e,o)=>{const n=t.getElementById(o);if(!n){return e}const i=this.indexOfEnd(n);if(i!=e){this.insertEnd(this.removeEnd(n),e)}return e+1},0);this._bEnforceEndOrder=false}};c.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._updateSeparators()};c.prototype._onContentPropertyChangedOverflowToolbar=function(t){if(this._bIsBeingDestroyed){return}e.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(t.getParameter("name")==="visible"||t.getParameter("name")==="width"&&t.getSource()!=this._oBeginSeparator){this._updateSeparators()}};c.prototype._hasVisible=function(t){const e=this.getAggregation("_popover")?this.getAggregation("_popover")._getAllContent():[];const o=t.filter(t=>e.indexOf(t)===-1);return o.some(t=>{const e=t.getWidth?t.getWidth()!=="0px":true;if(t.isA("sap.ui.mdc.actiontoolbar.ActionToolbarAction")){return t.getVisible()&&e&&t.getAction()?.getVisible()}return t.getVisible()&&e})};c.prototype._updateSeparators=function(){const t=this._hasVisible(this.getEnd());const e=(t,e)=>{if(t.getVisible()!==e){t.setVisible(e);t.invalidate()}};if(this._oBeginSeparator){const t=this._hasVisible(this.getBegin());const o=this._hasVisible(this.getBetween());e(this._oBeginSeparator,t&&o)}if(this._oEndActionsBeginSeparator){const o=this._hasVisible(this.getEndActionsBegin());e(this._oEndActionsBeginSeparator,t&&o)}if(this._oEndActionsEndSeparator){const o=this._hasVisible(this.getEndActionsEnd());e(this._oEndActionsEndSeparator,t&&o)}};c.prototype.indexOfContent=function(t){return this.getContent().indexOf(t)};c.prototype.getContent=function(){let t=this.getBegin();t.push(this._oBeginSeparator);t=t.concat(this.getBetween());t.push(this._oSpacer);t=t.concat(this.getEndActionsBegin());t.push(this._oEndActionsBeginSeparator);t=t.concat(this.getEnd());t.push(this._oEndActionsEndSeparator);t=t.concat(this.getEndActionsEnd());return t};c.prototype.getCurrentState=function(){const t=[];let e;this.getActions().forEach((o,n)=>{e=o&&o.getId();if(o.getVisible()){t.push({key:e,name:e,alignment:o.getLayoutInformation().alignment})}});return{items:t}};c.prototype.initPropertyHelper=async function(){const t=await Promise.all(this.getActions().map(async t=>{const e=await t.getAction().getMetadata().loadDesignTime(t);const o=this._getEnabledFromDesignTime(e);return{name:t.getId(),alignment:t.getLayoutInformation().alignment,label:t.getLabel(),visible:true,enabled:o}}));return Promise.resolve({getProperties:()=>t})};c.prototype._getEnabledFromDesignTime=function(t){if(!t||!("actions"in t)){return true}if(t.actions==="not-adaptable"){return false}if(t.actions.reveal===null){return false}if(t.actions.remove===null){return false}return true};p.call(c.prototype);return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/AggregationBaseDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/core/message/MessageType","sap/ui/mdc/enums/FilterBarValidationStatus"],(e,t,n)=>{"use strict";const i=Object.assign({},e);i.fetchProperties=function(e){return Promise.resolve([])};i.addItem=function(e,t,n){return Promise.resolve()};i.removeItem=function(e,t,n){return Promise.resolve(true)};i.validateState=function(e,n){const i=t.None;return{validation:i,message:undefined}};i.onAfterXMLChangeProcessing=function(e,t){};i.determineValidationState=function(e){return n.NoError};i.visualizeValidationState=function(e,t){};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/BaseDelegate", ["sap/ui/mdc/enums/BaseType","sap/ui/mdc/DefaultTypeMap","sap/base/Log"],(e,t,i)=>{"use strict";const p={};p.getTypeUtil=function(e){return this.getTypeMap(e)};p.getTypeMap=function(e){if(this.getTypeUtil&&this.getTypeUtil!==p.getTypeUtil){return this.getTypeUtil(e)}return t};return p});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/mdc/Chart", ["sap/ui/core/Lib","sap/ui/mdc/Control","./ChartRenderer","sap/base/Log","./chart/ToolbarControlFactory","sap/ui/mdc/ActionToolbar","./chart/PropertyHelper","sap/ui/mdc/mixin/FilterIntegrationMixin","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/p13n/subcontroller/ChartItemController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/ChartTypeController","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/util/InfoBar","sap/ui/core/format/ListFormat","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/enums/ChartP13nMode","sap/ui/mdc/enums/ChartToolbarActionType","sap/ui/mdc/chart/SelectionButtonItem","sap/ui/core/InvisibleMessage","sap/m/library","sap/ui/core/theming/Parameters"],(t,e,i,o,n,r,s,a,l,h,c,p,g,d,u,f,y,m,b,C,_,I,T,D,S,A)=>{"use strict";const{TitleLevel:v}=f;const B=e.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/chart/Chart.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate",payload:{}}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string",defaultValue:"No data"},p13nMode:{type:"sap.ui.mdc.enums.ChartP13nMode[]",defaultValue:[]},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.enums.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},showChartTooltip:{type:"boolean",group:"Misc",defaultValue:true},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},chartType:{type:"string",group:"Misc",defaultValue:"column"},showSelectionDetails:{type:"boolean",group:"Misc",defaultValue:true},propertyInfo:{type:"object",defaultValue:[]},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:v.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"actions"}},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false},_toolbar:{type:"sap.ui.mdc.ActionToolbar",multiple:false,visibility:"hidden"},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},_innerChart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_infoToolbar:{type:"sap.ui.mdc.util.InfoBar",multiple:false,visibility:"hidden"},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}}}},renderer:i});const P=t.getResourceBundleFor("sap.ui.mdc");const{ToolbarDesign:M}=S;a.call(B.prototype);B.prototype.init=function(){this._oManagedObjectModel=new l(this);this.setModel(this._oManagedObjectModel,"$mdcChart");e.prototype.init.apply(this,arguments);this._setPropertyHelperClass(s);this._setupPropertyInfoStore("propertyInfo")};B.prototype.setP13nMode=function(t){let e=null;if(t&&t.length>=1){e=[];const i=t.reduce((t,e,i)=>{t[e]=true;return t},{});if(i.Item){e.push(_.Item)}if(i.Sort){e.push(_.Sort)}if(i.Filter){e.push(_.Filter)}if(i.Type){this._typeBtnActive=true;e.push(_.Type)}else{this._typeBtnActive=false}}else{e=t}this.setProperty("p13nMode",e,true);this._updateAdaptation(this.getP13nMode());return this};B.prototype._updateAdaptation=function(t){const e={controller:{}};const i={Item:new h({control:this}),Sort:new p({control:this}),Filter:new c({control:this}),Type:new g({control:this})};if(t&&t.length>0){t.forEach(t=>{const o=t;const n=i[t];if(n){e.controller[o]=n}});this.getEngine().register(this,e)}};B.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);const e=this.getInbuiltFilter();if(e){e.setFilterConditions(t)}this._updateInfoToolbar();return this};B.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};B.prototype._registerInnerFilter=function(t){t.attachSearch(function(){this._rebind()},this)};B.prototype.applySettings=function(t,i){e.prototype.applySettings.apply(this,arguments);this.initializedPromise=new Promise((t,e)=>{this._fnResolveInitialized=t;this._fnRejectInitialized=e});this.innerChartBoundPromise=new Promise((t,e)=>{this._fnResolveInnerChartBound=t;this._fnRejectInnerChartBound=e});const o=this.initControlDelegate();const n=[o];if(this.isFilteringEnabled()){n.push(this.retrieveInbuiltFilter())}Promise.all(n).then(()=>{if(!this.isDestroyed()){this._initInnerControls()}})};B.prototype._initInnerControls=function(){this.getControlDelegate().initializeInnerChart(this).then(t=>{this.setBusyIndicatorDelay(0);this.getControlDelegate().createInitialChartContent(this);this._renderOverlay(true);if(this.getAutoBindOnInit()){this.setBusy(true);this._createContentfromPropertyInfos(t)}this.setAggregation("_innerChart",t);if(this.getP13nMode().includes("Filter")){this._initInfoToolbar()}this._bInnerChartReady=true;this._fnResolveInitialized();this.invalidate()}).catch(t=>{this._fnRejectInitialized(t)});this._createToolbarContent()};B.prototype._createToolbarContent=function(){const t=this.getP13nMode()||[];const e=this.getIgnoreToolbarActions();const i=this.getShowSelectionDetails();const o=t.includes("Item")&&!(e.length&&e.includes(I.DrillDownUp));const r=!(e.length&&e.includes(I.Legend));const s=!(e.length&&e.includes(I.ZoomInOut));const a=t.includes("Sort")||t.includes("Item")||t.includes("Filter");const l=this._getTypeBtnActive();const h=this.getHeader();const c=this.getHeaderStyle();const p=this.getHeaderLevel();const g=this.getHeaderVisible();const d=function(t){const e=t.getSource();e.removeAllItems();e.setSelectedItemKey("");const i=function(t){const e=t.getControlDelegate().getDrillStack(t);const i=[];e.forEach(t=>{t.dimension.forEach(t=>{if(t!=null&&t!=""&&i.indexOf(t)==-1){i.push(t)}})});return i};const o=this.getControlDelegate().getSortedDimensions(this);return o.then(t=>{const o=i(this);t=t.filter(t=>o.indexOf(t.key)<0);t.forEach(t=>{e.addItem(new T({key:t.key,text:t.label}))});e.setSearchEnabled(t.length>=7);e._openPopover()})}.bind(this);const u=function(t){const e=t.getParameter("item").key;this._bDrillDown=true;this.getEngine().createChanges({control:this,key:"Item",state:[{name:e,position:this.getItems().length}]})}.bind(this);const f=function(){const t=this.getP13nMode();const e=t.indexOf("Type");if(e>-1){t.splice(e,1)}if(this.isPropertyHelperFinal()){this.getEngine().show(this,t)}else{this.finalizePropertyHelper().then(()=>{this.getEngine().show(this,t)})}}.bind(this);const y=this.getChartType();const m=function(t){const e=t.getSource();const i=this.getAvailableChartTypes();e.removeAllItems();i.forEach(t=>{e.addItem(new T({key:t.key,text:t.text,icon:t.icon}))});e.setSearchEnabled(i.length>=7)}.bind(this);const b=function(t){const e=t.getSource();const i=t.getParameter("item").key;const o=this.getChartTypeInfo();const n=this.getAvailableChartTypes();const[r]=n.filter(t=>t.key===i);e.setText(r.text);e.setTooltip(o.text);e.setIcon(r.icon);sap.ui.require(["sap/ui/mdc/flexibility/Chart.flexibility"],t=>{this.getEngine().createChanges({control:this,key:"Type",state:{properties:{chartType:i}}}).then(t=>{if(this.getControlDelegate().requestToolbarUpdate){this.getControlDelegate().requestToolbarUpdate(this)}else{this._updateToolbar()}})})}.bind(this);const C=this.getId();const _=this._getToolbar();this._oTitle=n.createTitle(C,{header:h,headerStyle:c,headerLevel:p,headerVisible:g},_);_.addBegin(this._oTitle);const D=this.getAggregation("variant");if(D&&_){const t=this.getVariant();if(t){_.removeBetween(t)}_.addBetween(D);this._updateVariantManagementStyle()}if(i){this._oSelectionDetailsBtn=this._createSelectionDetails(C);_.addEnd(this._oSelectionDetailsBtn)}if(o){this._oDrillDownBtn=n.createDrillDownBtn(C,{beforeOpen:d,itemSelected:u});_.addEnd(this._oDrillDownBtn)}if(r){this._oLegendBtn=n.createLegendBtn(C,{pressed:"{$mdcChart>/legendVisible}"});_.addEnd(this._oLegendBtn)}if(s){this._oZoomInBtn=n.createZoomInBtn(C,{press:this.zoomIn.bind(this)});_.addEnd(this._oZoomInBtn);this._oZoomOutBtn=n.createZoomOutBtn(C,{press:this.zoomOut.bind(this)});_.addEnd(this._oZoomOutBtn)}if(a){this._oSettingsBtn=n.createSettingsBtn(C,{press:f});_.addEnd(this._oSettingsBtn)}if(l){this._oChartTypeBtn=n.createChartTypeBtn(C,{selectedItemKey:y,beforeOpen:m,itemSelected:b});_.addEnd(this._oChartTypeBtn)}this._updateVariantManagementStyle()};B.prototype._createSelectionDetails=function(t){const e=function(t){const e=[];t.getParameter("items").forEach(t=>{e.push(t.getBindingContext())});this.fireSelectionDetailsActionPressed({id:t.getParameter("id"),action:t.getParameter("action"),itemContexts:e,level:t.getParameter("level")})}.bind(this);const i=n.createSelectionDetailsBtn(t,{actionPress:e,getSelectionDetailsActions:this.getSelectionDetailsActions.bind(this),enableNavCallback:(t,e)=>this.getControlDelegate().determineEnableNavForDetailsItem(this,t,e),fetchFieldInfosCallback:(t,e)=>this.getControlDelegate().fetchFieldInfos(this,t,e)});return i};B.prototype._initInfoToolbar=function(){this.setAggregation("_infoToolbar",new m(this.getId()+"--infoToolbar",{infoText:this._getFilterInfoText(),press:function(){this.finalizePropertyHelper().then(()=>this.getEngine().show(this,"Filter")).then(t=>{t.attachEventOnce("close",()=>{const t=this.getFilterConditions();const e=!Object.keys(t).find(e=>t[e]&&t[e].length>0);if(e&&this.getAggregation("_toolbar")){}})})}.bind(this),removeAllFilters:function(t){this.getEngine().createChanges({control:this,key:"Filter",state:{},applyAbsolute:C.FullReplace})}.bind(this)}));if(this.getDomRef()){this.getDomRef().setAttribute("aria-labelledby",this.getAggregation("_infoToolbar").getACCTextId())}};B.prototype._updateInfoToolbar=function(){if(this.getP13nMode().includes("Filter")&&this.getAggregation("_infoToolbar")){this.getAggregation("_infoToolbar").setInfoText(this._getFilterInfoText())}};B.prototype._getFilterInfoText=function(){if(this.getInbuiltFilter()){let t;const e=this._getLabelsFromFilterConditions();const i=b.getInstance();if(e.length>0){if(e.length>1){t=P.getText("chart.MULTIPLE_FILTERS_ACTIVE",[e.length,i.format(e)])}else{t=P.getText("chart.ONE_FILTER_ACTIVE",[e[0]])}}return t}return undefined};B.prototype.checkAndUpdateItems=function(){return new Promise((t,e)=>{const i=[];const n=function(t,e,i,n){const r=t.getProperty(i);if(!r||r!==e){if(r!==e){o.error("sap.ui.mdc.Chart",`the propertyInfo.${i} for Item '${t.getId()}' has a different value! new value = ${e||n}`)}t.setProperty(i,e||n)}};this.getItems().forEach(t=>{i.push(this._getPropertyByNameAsync(t.getPropertyKey()).then(e=>{if(e){n(t,e.label,"label");n(t,e.groupable?"groupable":"aggregatable","type");n(t,e.role,"role",e.groupable?"category":"axis1")}}))});Promise.all(i).then(()=>{t()})})};B.prototype._createContentfromPropertyInfos=function(t){this.checkAndUpdateItems().then(()=>{if(!this._oInnerChartContentPromise){this._oInnerChartContentPromise=this.getControlDelegate().createInnerChartContent(this,this._innerChartDataLoadComplete.bind(this));this._oInnerChartContentPromise.then(()=>{this._createBreadcrumbs();this._oObserver?.disconnect();this._oObserver?.destroy();this._oObserver=new d(this._propagateItemChangeToInnerChart.bind(this));this._oObserver.observe(this,{aggregations:["items"]});this._propagatePropertiesToInnerChart();this._fnResolveInnerChartBound()})}})};B.prototype._createBreadcrumbs=function(){let t=this.getAggregation("_breadcrumbs");if(!t&&!this._bIsDestroyed){t=n.createDrillBreadcrumbs(this.getId(),{linkPressed:function(t){const e=t.getParameter("index")+1;const i=this.getControlDelegate().getDrillableItems(this);const o=i.slice(e);const n=o.map(t=>({name:t.getPropertyKey(),visible:false}));this._iDrillUpIndex=e;this.getEngine().createChanges({control:this,key:"Item",state:n})}.bind(this)});const e=this.getControlDelegate().getDrillableItems(this).map(t=>({key:t.getPropertyKey(),text:t.getLabel()}));t.update(e);this.setAggregation("_breadcrumbs",t)}};B.prototype._loadDelegate=function(){return new Promise(t=>{const e=[this.getDelegate().name];function i(e){t(e)}sap.ui.require(e,i)})};B.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1};B.prototype.getAdaptationUI=function(){return this.getControlDelegate().getAdaptionUI(this)};B.prototype._propagateItemChangeToInnerChart=function(t){if(this._bIsDestroyed){return}this.setBusy(true);let e;switch(t.mutation){case"insert":if(t.child&&t.child.getType()){e=this.getItems().filter(e=>e.getType()===t.child.getType()).indexOf(t.child)}else{e=this.getItems().indexOf(t.child)}this.getControlDelegate().insertItemToInnerChart(this,t.child,e);break;case"remove":this.getControlDelegate().removeItemFromInnerChart(this,t.child);break;default:o.error("Unknown mutation on MDC Chart Item Aggregation. This will not sync to inner chart!");break}const i=this.getControlDelegate().getDrillableItems(this).map(t=>({key:t.getPropertyKey(),text:t.getLabel()}));this.getAggregation("_breadcrumbs").update(i)};B.prototype._rebind=async function(t){if(!this._bInnerChartReady){await this.initialized()}this.setBusy(true);if(!this.getControlDelegate().getInnerChartBound(this)){this._createContentfromPropertyInfos();return}const e=this.getControlDelegate();let i;if(e._getBindingInfo){i=e._getBindingInfo(this);o.warning("mdc Chart","calling the private delegate._getBindingInfo. Please make the function public!")}else{i=e.getBindingInfo(this)}e.updateBindingInfo(this,i);e.rebind(this,i)};B.prototype._onFilterSearch=function(t){this._bAnnounceUpdate=true};B.prototype._announceUpdate=function(t,e,i,o){if(!this._bAnnounceUpdate){return}this._bAnnounceUpdate=false;const n=D.getInstance();if(n){const r=P;const s=this.getAvailableChartTypes();const[a]=s.filter(e=>e.key===t);t=a?.text||t;let l=r.getText("chart.ANNOUNCEMENT_UPDATED",[e,t]);let h;if(i&&o){if(i===1&&o===1){h="chart.ANNOUNCEMENT_DIMMEA_11_UPDATED"}else if(i>1&&o===1){h="chart.ANNOUNCEMENT_DIMMEA_N1_UPDATED"}else if(i===1&&o>1){h="chart.ANNOUNCEMENT_DIMMEA_1N_UPDATED"}else{h="chart.ANNOUNCEMENT_DIMMEA_NN_UPDATED"}l+=" "+r.getText(h,[i,o])}n.announce(l)}};B.prototype._getToolbar=function(){if(this.getAggregation("_toolbar")){return this.getAggregation("_toolbar")}else if(!this._bIsDestroyed){const t=new r(this.getId()+"--toolbar",{design:M[A.get({name:"_sap_ui_mdc_Chart_ToolbarDesign"})],enabled:false});this.setAggregation("_toolbar",t);return t}};B.prototype.onThemeChanged=function(){const t=this._getToolbar();if(t){const e=M[A.get({name:"_sap_ui_mdc_Chart_ToolbarDesign"})];t.setDesign(e)}};B.prototype._updateToolbar=function(){const t=this.getAggregation("_toolbar");if(t){if(!t.getEnabled()){t.setEnabled(true)}this._updateZoomButtons();this._initSelectionDetails()}else{o.warning("Trying to update Chart Toolbar, but toolbar is not yet initialized. This will not work!")}};B.prototype._updateZoomButtons=function(){const t=this._oZoomInBtn;const e=this._oZoomOutBtn;if(!t||!e){return}const i=this.getControlDelegate().getZoomState(this);if(i?.enabled){const o=document.activeElement===t.getDomRef();const n=document.activeElement===e.getDomRef();t.setEnabled(i.enabledZoomIn);e.setEnabled(i.enabledZoomOut);if(!i.enabledZoomIn&&o){e.focus()}if(!i.enabledZoomOut&&n){t.focus()}}else{t.setEnabled(false);e.setEnabled(false)}};B.prototype._initSelectionDetails=function(){const t=this._oSelectionDetailsBtn;if(t&&!t._oChangeHandler){const e=this.getSelectionHandler();if(e){t.attachSelectionHandler(e.eventId,e.listener)}}};B.prototype._getInnerChart=function(){if(this._bInnerChartReady){return this.getControlDelegate().getInnerChart(this)}else{o.error("Trying to acces inner chart while inner chart is not yet initialized!")}};B.prototype.initialized=function(){return this.initializedPromise};B.prototype.innerChartBound=function(){return this.innerChartBoundPromise};B.prototype.zoomIn=function(){this.getControlDelegate().zoomIn(this);this._updateZoomButtons()};B.prototype.zoomOut=function(){this.getControlDelegate().zoomOut(this);this._updateZoomButtons()};B.prototype.getSelectionHandler=function(){return this.getControlDelegate().getInnerChartSelectionHandler(this)};B.prototype.getChartTypeLayoutConfig=function(){return this.getControlDelegate().getChartTypeLayoutConfig()};B.prototype.getAllowedRolesForKinds=function(){return this.getControlDelegate().getAllowedRolesForKinds()};B.prototype.setLegendVisible=function(t){this.setProperty("legendVisible",t);try{this.getControlDelegate().setLegendVisible(this,t)}catch(t){o.info("Trying to set legend visiblity for Chart before delegate was initialized")}return this};B.prototype.setShowChartTooltip=function(t){this.setProperty("showChartTooltip",t);try{this.getControlDelegate().setChartTooltipVisibility(this,t)}catch(t){o.info("Trying to set tooltip visibility before delegate was initialized")}return this};B.prototype.destroy=function(){this._bIsDestroyed=true;e.prototype.destroy.apply(this,arguments)};B.prototype._propagatePropertiesToInnerChart=function(){this.setLegendVisible(this.getLegendVisible());this.setShowChartTooltip(this.getShowChartTooltip());this.setChartType(this.getChartType())};B.prototype.getChartTypeInfo=function(){return this.getControlDelegate().getChartTypeInfo(this)};B.prototype.getAvailableChartTypes=function(){return this.getControlDelegate().getAvailableChartTypes(this)};B.prototype.setChartType=function(t){this.setProperty("chartType",t);const e=this._oChartTypeBtn;if(e){e.setSelectedItemKey(t);const i=this.getChartTypeInfo();e.setTooltip(i.text);e.setIcon(i.icon)}try{this.getControlDelegate().setChartType(this,t)}catch(t){o.info("Trying to set chart type for Chart before delegate was initialized")}return this};B.prototype.setNoData=function(t){this.setAggregation("noData",t);try{this.getControlDelegate().changedNoDataStruct(this,t)}catch(t){}return this};B.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel};B.prototype._innerChartDataLoadComplete=function(){this._checkStyleClassesForDimensions();this.setBusy(false);this._renderOverlay(false);if(this.getControlDelegate().requestToolbarUpdate){this.getControlDelegate().requestToolbarUpdate(this)}else{this._updateToolbar()}};B.prototype._checkStyleClassesForDimensions=function(){const t=this.getAggregation("_breadcrumbs");const e=t?.getVisible()&&this.getItems().some(t=>t.getType()==="groupable");if(!e&&this.hasStyleClass("sapUiMDCChartGrid")){this.removeStyleClass("sapUiMDCChartGrid");this.addStyleClass("sapUiMDCChartGridNoBreadcrumbs")}else if(e&&this.hasStyleClass("sapUiMDCChartGridNoBreadcrumbs")){this.removeStyleClass("sapUiMDCChartGridNoBreadcrumbs");this.addStyleClass("sapUiMDCChartGrid")}};B.prototype.getCurrentState=function(){const t={};const e=this.getP13nMode();if(e){if(e.indexOf("Item")>-1){t.items=this._getVisibleProperties()}if(e.indexOf("Sort")>-1){t.sorters=this._getSortedProperties()}if(e.indexOf("Filter")>-1){t.filter=this.getFilterConditions()}if(e.indexOf("Type")>-1){t.chartType=this.getChartType()}}return t};B.prototype._getVisibleProperties=function(){const t=[];this.getItems().forEach(e=>{const i=e.getPropertyKey();t.push({key:i,name:i,role:e.getRole()})});return t};B.prototype._getSortedProperties=function(){const t=this.getSortConditions();return t?t.sorters:[]};B.prototype._getTypeBtnActive=function(){return!!this._typeBtnActive};B.prototype.setNoDataText=function(t){this.setProperty("noDataText",t);try{this.getControlDelegate().setNoDataText(this,t)}catch(t){}return this};B.prototype._onFiltersChanged=function(t){if(this._bInnerChartReady&&this.getControlDelegate()&&this.getControlDelegate().getInnerChartBound(this)&&t.getParameter("conditionsBased")){this._renderOverlay(true)}};const E=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Item")>-1||t.indexOf("Filter")>-1)){e=true}return e};B.prototype._onModifications=async function(t){if(E(t)){await this.rebind()}};B.prototype.setVariant=function(t){this.setAggregation("variant",t);const e=this.getAggregation("_toolbar");if(t&&e){const i=this.getVariant();if(i){e.removeBetween(i)}e.addBetween(t);this._updateVariantManagementStyle()}return this};B.prototype.getVariant=function(){let t;const e=this.getAggregation("_toolbar");if(e){[t]=e.getBetween().filter(t=>t.isA("sap.ui.fl.variants.VariantManagement"))}else{t=this.getAggregation("variant")}return t};B.prototype._renderOverlay=function(t){try{this.getControlDelegate().showOverlay(this,t)}catch(t){o.error("sap.ui.mdc.Chart: Tried to render overlay on not initiailized chart. This will not work!")}};B.prototype.addAction=function(t){if(t.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){t=new u(t.getId()+"-action",{action:t})}return e.prototype.addAggregation.apply(this,["actions",t])};B.prototype.setHeader=function(t){this.setProperty("header",t);const e=this.getAggregation("_toolbar");this._oTitle?.setText(t);e?._oInvTitle?.setText(t);return this};B.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);this._oTitle?.setLevel(t);this._updateVariantManagementStyle();return this};B.prototype.setHeaderStyle=function(t){this.setProperty("headerStyle",t);this._oTitle?.setTitleStyle(t);this._updateVariantManagementStyle();return this};B.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);this._oTitle?.setVisible(t);this._updateVariantManagementStyle();return this};B.prototype._updateVariantManagementStyle=function(){const t=this.getVariant();if(t){t.setShowAsText(this.getHeaderVisible());t.setTitleStyle(this.getHeaderStyle());t.setHeaderLevel(this.getHeaderLevel())}};B.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.which===y.COMMA){const e=this._oSettingsBtn;if(e&&e.getVisible()&&e.getEnabled()){e.firePress();t.setMarked();t.preventDefault()}}};B.prototype.exit=function(){delete this._oTitle;delete this._oSelectionDetailsBtn;delete this._oDrillDownBtn;delete this._oLegendBtn;delete this._oZoomInBtn;delete this._oZoomOutBtn;delete this._oSettingsBtn;delete this._oChartTypeBtn;delete this.innerChartBoundPromise;delete this._fnResolveInnerChartBound;delete this._fnRejectInnerChartBound;delete this.initializedPromise;delete this._fnResolveInitialized;delete this._fnRejectInitialized;delete this._oInnerChartContentPromise;const t=this.getAggregation("_toolbar");t?._oInvTitle?.destroy();e.prototype.exit.apply(this,arguments);this._oObserver?.destroy();delete this._oObserver};return B});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ChartDelegate", ["sap/ui/mdc/AggregationBaseDelegate","sap/ui/mdc/mixin/delegate/FilterIntegrationDefault"],(e,n)=>{"use strict";const t=Object.assign({},e,n);t.zoomIn=function(e){};t.zoomOut=function(e){};t.getZoomState=function(e){};t.getFilterDelegate=function(){return{addItem:function(e,n){return Promise.resolve()},addCondition:function(e,n,t){return Promise.resolve()},removeCondition:function(e,n,t){return Promise.resolve()}}};t.addItem=function(e,n,t,i){return Promise.resolve()};t.removeItem=function(e,n,t){return Promise.resolve(true)};t.getInnerChartSelectionHandler=function(e){};t.setLegendVisible=function(e,n){};t.insertItemToInnerChart=function(e,n,t){};t.removeItemFromInnerChart=function(e,n){};t.initializeInnerChart=function(e){return Promise.reject()};t.createInitialChartContent=function(e){};t.getInnerChart=function(e){};t.getChartTypeInfo=function(e){};t.getAvailableChartTypes=function(e){};t.getChartTypeLayoutConfig=function(){};t.getDrillStack=function(e){};t.getSortedDimensions=function(e){};t.getDrillableItems=function(e){};t.setChartType=function(e){};t.changedNoDataStruct=function(e,n){};t.setNoDataText=function(e,n){};t.createInnerChartContent=function(e,n){return Promise.resolve()};t.rebind=function(e,n){};t.getInnerChartBound=function(e){};t.getBindingInfo=function(e){};t.updateBindingInfo=function(e,n){n.filters=this.getFilters(e)};t.setChartTooltipVisibility=function(e,n){};t.getInternalChartNameFromPropertyNameAndKind=function(e,n,t){};t.getPropertyFromNameAndKind=function(e,n,t){};t.fetchProperties=function(e){return Promise.resolve([])};t.showOverlay=function(e,n){};t.determineEnableNavForDetailsItem=(e,n,t)=>false;t.fetchFieldInfos=(e,n,t)=>({});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ChartRenderer", ["./library"],r=>{"use strict";const e={apiVersion:2};e.CSS_CLASS="sapUiMDCChart";e.render=function(r,t){r.openStart("div",t);r.class(e.CSS_CLASS);r.style("height",t.getHeight());r.style("width",t.getWidth());r.style("min-height",t.getMinHeight());r.style("min-width",t.getMinWidth());r.openEnd();this.renderToolbar(r,t.getAggregation("_toolbar"));this.renderInfoToolbar(r,t.getAggregation("_infoToolbar"));this.renderBreadcrumbs(r,t.getAggregation("_breadcrumbs"));this.renderInnerStructure(r,t.getAggregation("_innerChart"));r.close("div")};e.renderNoDataStruct=function(r,e){if(e){}};e.renderToolbar=function(r,e){if(e){r.renderControl(e)}};e.renderBreadcrumbs=function(r,e){if(e){r.renderControl(e)}};e.renderInfoToolbar=function(r,e){if(e){r.renderControl(e)}};e.renderInnerStructure=function(r,e){r.renderControl(e)};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Control", ["sap/ui/core/Control","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/PropertyHelperMixin","sap/ui/mdc/mixin/AdaptationMixin"],(e,i,t,r)=>{"use strict";const a=e.extend("sap.ui.mdc.Control",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},renderer:e.renderer});i.call(a.prototype);r.call(a.prototype);t.call(a.prototype);return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/DefaultTypeMap", ["sap/ui/mdc/util/TypeMap","sap/ui/mdc/enums/BaseType"],(e,t)=>{"use strict";const s=Object.assign({},e);s.getUnitBaseType=function(e,s){if(!e||(!e.hasOwnProperty("showMeasure")||e.showMeasure)&&(!e.hasOwnProperty("showNumber")||e.showNumber)){return t.Unit}else if(!e.hasOwnProperty("showNumber")||e.showNumber){return t.Numeric}else{return t.String}};s.getUnitOptions=function(e,t,s){if(s){e=Object.assign({},e,{strictParsing:true,showNumber:!!s.showNumber,showMeasure:!!s.showMeasure})}if(e&&e.hasOwnProperty("unitOptional")){delete e.unitOptional}return[e,t]};s.set("sap.ui.model.type.Boolean",t.Boolean);s.set("sap.ui.model.type.Currency",s.getUnitBaseType,s.getUnitOptions);s.set("sap.ui.model.type.Date",t.Date);s.set("sap.ui.model.type.DateTime",t.DateTime);s.set("sap.ui.model.type.Float",t.Numeric);s.set("sap.ui.model.type.Integer",t.Numeric);s.set("sap.ui.model.type.String",t.String);s.set("sap.ui.model.type.Time",t.Time);s.set("sap.ui.model.type.Unit",s.getUnitBaseType,s.getUnitOptions);s.setAlias("Boolean","sap.ui.model.type.Boolean");s.setAlias("Currency","sap.ui.model.type.Currency");s.setAlias("Date","sap.ui.model.type.Date");s.setAlias("DateTime","sap.ui.model.type.DateTime");s.setAlias("Float","sap.ui.model.type.Float");s.setAlias("Integer","sap.ui.model.type.Integer");s.setAlias("String","sap.ui.model.type.String");s.setAlias("Time","sap.ui.model.type.Time");s.setAlias("Unit","sap.ui.model.type.Unit");s.freeze();return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Element", ["sap/ui/core/Element","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/PropertyHelperMixin","sap/ui/mdc/mixin/AdaptationMixin"],(e,i,t,r)=>{"use strict";const a=e.extend("sap.ui.mdc.Element",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},renderer:e.renderer});i.call(a.prototype);r.call(a.prototype);t.call(a.prototype);return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Field", ["sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/Condition","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/model/BindingMode","sap/ui/model/Context"],(t,e,i,n,a,o,s,l,r,p)=>{"use strict";const d=t.extend("sap.ui.mdc.Field",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/Field.designtime",properties:{value:{type:"any",defaultValue:null,bindable:"bindable"},additionalValue:{type:"any",defaultValue:null,bindable:"bindable"}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},promise:{type:"Promise"}}}},defaultProperty:"value"},renderer:e});d.prototype.init=function(){this._vValue=null;this._vAdditionalValue=null;t.prototype.init.apply(this,arguments);this.setMaxConditions(1);this.setProperty("_operators",[a.EQ],true);this._oObserver.observe(this,{properties:["value","additionalValue","valueState"]})};d.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;delete this._bPendingConditionUpdate}this._oBindingContext=undefined};d.prototype.bindProperty=function(e,i){let n;let a;let o=0;const l=typeof i.type==="string"?i.type:i.type?.getMetadata().getName();const r=typeof i.type==="string"?i.formatOptions:i.type?.getFormatOptions();const p=typeof i.type==="string"?i.constraints:i.type?.getConstraints();if(e==="value"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getDataType();if(i.type&&(!n||n.getMetadata().getName()!==l||!s(n.getFormatOptions(),r)||!s(n.getConstraints(),p)||n._bCreatedByOperator!==i.type._bCreatedByOperator)){if(typeof i.type==="string"){this.setDataType(l);this.setDataTypeFormatOptions(r);this.setDataTypeConstraints(p)}else{this.getContentFactory().setDataType(i.type)}this.getContentFactory().setDateOriginalType(undefined);this.getContentFactory().setUnitOriginalType(undefined);this.getContentFactory().setIsMeasure(false);if(i.parts&&i.type.isA("sap.ui.model.CompositeType")){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}else if(e==="additionalValue"&&!i.formatter){i.targetType="raw";n=this.getContentFactory().getAdditionalDataType();if(i.type&&(!n||n.getMetadata().getName()!==l||!s(n.getFormatOptions(),r)||!s(n.getConstraints(),p)||n._bCreatedByOperator!==i.type._bCreatedByOperator)){if(typeof i.type!=="string"){this.getContentFactory().setAdditionalDataType(i.type)}if(i.parts&&i.type.isA("sap.ui.model.CompositeType")){a=[];for(o=0;o<i.parts.length;o++){a.push(i.parts[o].type)}this.getContentFactory().setAdditionalCompositeTypes(a)}this.getContentFactory().updateConditionType();this.invalidate()}}t.prototype.bindProperty.apply(this,arguments)};d.prototype.handleModelContextChange=function(e){t.prototype.handleModelContextChange.apply(this,arguments);const i=this.getBinding("value");if(i){const t=i.isA("sap.ui.model.CompositeBinding")?i.getBindings()[0].getContext():i.getContext();if(p.hasChanged(this._oBindingContext,t)){this._oBindingContext=t;this.getContentFactory().updateConditionType();if(this.isInvalidInput()||this._getValueHelp()){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}}if(!this.getContentFactory().getDataType()){this.getContentFactory().setDataType(i.getType());this.invalidate()}}};d.prototype.initDataType=function(){t.prototype.initDataType.apply(this,arguments);const e=this.getBinding("value");if(e){this.getContentFactory().setDataType(e.getType())}};d.prototype.setProperty=function(e,i,n){if(e==="value"&&this.isInvalidInput()&&s(this.getValue(),this.validateProperty(e,i))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return t.prototype.setProperty.apply(this,arguments)};d.prototype.setMaxConditions=function(t){if(t!==1){throw new Error("Only one condition allowed for Field "+this)}return this.setProperty("maxConditions",t,true)};d.prototype.observeChanges=function(e){t.prototype.observeChanges.apply(this,arguments);if(e.name==="value"){const t=c.call(this,e.current,e.old);if(this._vAdditionalValue!==null&&F.call(this)&&!f.call(this,t,this._vValue,true)){this._vAdditionalValue=this.getAdditionalValue()}this._vValue=t;T.call(this,e.current);y.call(this)}if(e.name==="additionalValue"){this._vAdditionalValue=e.current;y.call(this)}if(e.name==="valueState"){if(this._bPendingConditionUpdate){this._bKeepValueState=true}}if(e.name==="conditions"){if(this.getCurrentContent().length<=1){m.call(this,e.current)}}};function h(){return this._vValue}function u(){return this._vAdditionalValue}function y(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.isFieldDestroyed()){y.call(this)}});this._bPendingConditionUpdate=true;return}if(this.getDisplay()===i.Value){g.call(this,h.call(this),u.call(this))}else if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(()=>{g.call(this,h.call(this),u.call(this));this._iConditionUpdateTimer=undefined},0);this._bPendingConditionUpdate=true}}function g(t,e){const i=this.getConditions();if(_.call(this,t,e)){if(i.length>0){this.setConditions([])}}else{const n=i[0];const s=n&&n.values[0];const l=n&&n.values[1]?n.values[1]:null;if(!n||n.operator!==a.EQ||!f.call(this,s,t)||!C.call(this,e,l)){const i=this.getControlDelegate();const a=i.createCondition(this,this,[t,e],n);if(!o.compareConditions(n,a)){this.setConditions(a?[a]:[])}}}this._bPendingConditionUpdate=false;this._bKeepValueState=false}function c(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(t&&e&&(i==="sap.ui.model.odata.type.Unit"||i==="sap.ui.model.odata.type.Currency")&&!t[2]&&e[2]!==undefined){t=l([],t);t[2]=e[2];if(this._bPendingChange){const i=this.getConditions()[0];if(i){if(t[0]===e[0]&&t[0]!==i.values[0][0]){t[0]=i.values[0][0]}if(t[1]===e[1]&&t[1]!==i.values[0][1]){t[1]=i.values[0][1]}}}}return t}function f(t,e,i){let a=t===e;const o=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(!a&&this.getTypeMap().getBaseType(o)===n.Unit&&Array.isArray(t)&&Array.isArray(e)){const n=t[0];const o=t[1];const l=t.length>=3?t[2]:null;const r=e[0];const p=e[1];const d=e.length>=3?e[2]:null;if(n===r&&o===p&&((this._bUnitSet||i)&&(!l||!d)||s(l,d))){a=true}if((l||d)&&!i){this._bUnitSet=true}}return a}function C(t,e,i){let n=t===e;if(!n&&(t===null||t===undefined||t==="")&&(e===null||e===undefined||e==="")){n=true}return n}function T(t){if(!this._oTypeInitialization){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.isFieldDestroyed()){T.call(this,t)}});return}const e=this.getBinding("value");const i=e?e.getType():this.getContentFactory().getDataType();if(i){this._oTypeInitialization=this.getTypeMap().initializeTypeFromValue(i,t);if(this._oTypeInitialization&&this.getContentFactory().getUnitOriginalType()){this.getTypeMap().initializeInternalType(this.getContentFactory().getDataType(),this._oTypeInitialization);this.getTypeMap().initializeInternalType(this.getContentFactory().getUnitType(),this._oTypeInitialization)}}}}d.prototype.fireChangeEvent=function(t,e,i,n){let a;if(t){if(e){a=this.getResultForChangePromise(t)}else{a=i}}if(this.getCurrentContent().length>1){if(t){m.call(this,this.getConditions())}else if(n){n=n.then(t=>{m.call(this,this.getConditions());return t})}}this.fireChange({value:a,valid:e,promise:n})};d.prototype.getResultForChangePromise=function(t){let e;if(t.length===0&&this.getContentFactory().getDataType()){e=this.getContentFactory().getDataType().parseValue("","string",[])}else if(t.length===1){e=t[0].values[0]}return e};function m(t){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.isFieldDestroyed()){m.call(this,t)}});return}let e=null;let i=null;const n=this.getValue();const a=this.getAdditionalValue();if(t.length===0&&_.call(this,n,a)){return}e=this.getResultForChangePromise(t);e=v.call(this,e,n);if(t.length===0||t[0].values.length===1){if(a){const t=this.getContentFactory().getAdditionalDataType();if(t){i=t.parseValue("","string")}}else{i=a}}else if(t.length===1&&t[0].values.length>1){i=t[0].values[1]}this._vValue=e;this._vAdditionalValue=i;if(!f.call(this,e,n,true)){this.setProperty("value",e,true)}if(!C.call(this,i,a,true)&&!F.call(this)){this.setProperty("additionalValue",i,true)}}function v(t,e){const i=this.getContentFactory().getDataType()?this.getContentFactory().getDataType().getMetadata().getName():this.getDataType();if(this.getTypeMap().getBaseType(i)===n.Unit&&Array.isArray(t)&&Array.isArray(e)&&!this.checkValueInitial(t)&&this.checkValueInitial(e)){for(let i=0;i<t.length;i++){if(t[i]===null&&e[i]!==undefined){t[i]=e[i]}}}return t}d.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};function F(){const t=this.getBinding("additionalValue");if(t&&t.getBindingMode()===r.OneWay){return true}return false}d.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getContentFactory().getDataType()&&!this.isFieldPropertyInitial("editMode")&&!this.isFieldPropertyInitial("multipleLines")){t.prototype.checkCreateInternalContent.apply(this,arguments)}};d.prototype.getOverflowToolbarConfig=function(){const e=t.prototype.getOverflowToolbarConfig.apply(this,arguments);e.propsUnrelatedToSize.push("value");e.propsUnrelatedToSize.push("additionalValue");return e};d.prototype.isSearchField=function(){return false};function _(t,e){return this.checkValueInitial(t)&&!e}d.prototype.getAdditionalDataTypeConfiguration=function(){const t=this.getBinding("additionalValue");if(t){return t.getType()}else{const t=this.getBindingInfo("additionalValue");if(t?.type){if(typeof t.type==="string"){return{name:t.type,formatOptions:t.formatOptions,constraints:t.constraints}}else{return t.type}}}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterBar", ["sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/m/library","sap/m/Button","sap/base/util/merge","sap/base/Log","sap/ui/mdc/enums/FilterBarP13nMode"],(t,e,i,r,s,o,n,l,d,a,h)=>{"use strict";const p=s.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showClearButton:{type:"boolean",defaultValue:false},p13nMode:{type:"sap.ui.mdc.enums.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:o});const{ButtonType:u}=n;p.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new i;this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons()};p.prototype.setP13nMode=function(i){this.setProperty("p13nMode",i||[],false);const r={helper:this.getPropertyHelper(),controller:{}};let s=false;i&&i.forEach(t=>{if(t=="Item"){s=true;r.controller["Item"]=new e({control:this})}});this._setP13nModeItem(s);r.controller["Filter"]=new t({control:this});this.getEngine().register(this,r);return this};p.prototype.setFilterConditions=function(e,i){t.checkConditionOperatorSanity(e);if(this._oP13nFB){this._oP13nFB.setFilterConditions(d({},e))}this.setProperty("filterConditions",e,i);return this};p.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem")};p.prototype._setP13nModeItem=function(t){this._oModel.setProperty("/_p13nModeItem",t,true)};p.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new l(this.getId()+"-btnAdapt",{type:u.Transparent,text:"{"+s.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setModel(this._oModel,s.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:"/showAdaptFiltersButton",model:s.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:s.INNER_MODEL_NAME}],formatter:function(t,e){return t&&e}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,s.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:"/showGoButton",model:s.INNER_MODEL_NAME},{path:"/liveMode",model:s.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._btnClear=new l(this.getId()+"-btnClear",{type:u.Transparent,visible:"{"+s.INNER_MODEL_NAME+">/showClearButton}",text:this._oRb.getText("filterbar.CLEAR"),press:function(t){this.onClear()}.bind(this)});this._btnClear.setModel(this._oModel,s.INNER_MODEL_NAME);this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnClear);this._oFilterBarLayout.addButton(this._btnAdapt)}};p.prototype.onClear=function(){this._btnClear.setEnabled(false);this.awaitControlDelegate().then(t=>{t.clearFilters(this).catch(t=>{a.error(t)}).finally(()=>{this._btnClear.setEnabled(true)})})};p.prototype.retrieveInbuiltFilter=function(){const t=s.prototype.retrieveInbuiltFilter.apply(this,arguments);return t.then(t=>t)};p.prototype.onAdaptFilters=function(t){return this._retrieveMetadata().then(()=>this.getEngine().show(this,"Item",{reset:function(){this.getEngine().reset(this);this._getConditionModel().checkUpdate(true)}.bind(this)}).then(t=>{this._aAddedFilterFields=[];this._aRemovedFilterFields=[];t.attachEventOnce("close",this._determineFilterFieldOnFocus.bind(this));return t}))};p.prototype._determineFilterFieldOnFocus=function(){let t=null;const e=this.getFilterItems();if(this._aAddedFilterFields&&this._aAddedFilterFields.length>0){[t]=this._aAddedFilterFields;for(let i=1;i<this._aAddedFilterFields.length;i++){if(e.indexOf(t)>e.indexOf(this._aAddedFilterFields[i])){t=this._aAddedFilterFields[i]}}}else if(this._aRemovedFilterFields&&this._aRemovedFilterFields.length>0){[t]=e}if(t){this._setFocusOnFilterField(t)}this._aAddedFilterFields=undefined;this._aRemovedFilterFields=undefined};p.prototype._handleAddedFilterField=function(t){if(this._aAddedFilterFields&&this._aRemovedFilterFields){const e=this._aRemovedFilterFields.indexOf(t);if(e<0){this._aAddedFilterFields.push(t)}else{this._aRemovedFilterFields.splice(e,1)}}};p.prototype._handleRemovedFilterField=function(t){if(this._aRemovedFilterFields){this._aRemovedFilterFields.push(t)}};p.prototype._setFocusOnFilterField=function(t){if(t){t.focus()}};p.prototype.getCurrentState=function(){const t=s.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete t.items}return t};p.prototype.exit=function(){s.prototype.exit.apply(this,arguments);this._btnClear=undefined};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterBarDelegate", ["sap/ui/mdc/AggregationBaseDelegate","sap/ui/mdc/enums/FilterBarValidationStatus"],(e,t)=>{"use strict";const r=Object.assign({},e);r.addItem=function(t,r,s){return e.addItem(t,r,s)};r.removeItem=function(t,r,s){return e.removeItem(t,r,s)};r.addCondition=function(e,t,r){return Promise.resolve()};r.removeCondition=function(e,t,r){return Promise.resolve()};r.fetchProperties=function(t){return e.fetchProperties(t)};r.clearFilters=function(e){return Promise.resolve()};r.determineValidationState=function(e){return e.checkFilters()};r.visualizeValidationState=function(e,r){let s;if(r.status===t.NoError){return}if(r.status===t.RequiredHasNoValue){s=e.getResourceFileText("filterbar.REQUIRED_CONDITION_MISSING")}else if(r.status===t.FieldInErrorState){s=e.getResourceFileText("filterbar.VALIDATION_ERROR")}if(e.getShowMessages()&&!e._hasOpenMessageBox){sap.ui.require(["sap/m/MessageBox","sap/base/Log"],(t,r)=>{try{if(e._bIsBeingDestroyed){return}e._hasOpenMessageBox=true;t.error(s,{styleClass:e.getDomRef()?.closest(".sapUiSizeCompact")?"sapUiSizeCompact":"",onClose:function(){delete e._hasOpenMessageBox;e.setFocusOnFirstErroneousField()}})}catch(e){r.error(e.message)}})}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/FilterField", ["sap/ui/core/Element","sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/base/util/merge","sap/base/util/deepEqual"],(t,e,i,r,o,s)=>{"use strict";const n=e.extend("sap.ui.mdc.FilterField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/FilterField.designtime",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]},defaultOperator:{type:"string",group:"Data",defaultValue:null},propertyKey:{type:"string",group:"Data",defaultValue:""},additionalDataType:{type:"object",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},renderer:i});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["operators","propertyKey","additionalDataType"]});this._mDescriptionPromises=new Map;this._mDescriptions=new Map};n.prototype.exit=function(){this._mDescriptionPromises=null;this._mDescriptions=null;e.prototype.exit.apply(this,arguments)};(()=>{n.prototype.getPropertyKey=function(){let t=this.getProperty("propertyKey");if(!t){t=this.getFieldPath()}return t}})();n.prototype.setProperty=function(t,i,r){if(t==="conditions"&&this.isInvalidInput()&&s(this.getConditions(),this.validateProperty(t,i))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return e.prototype.setProperty.apply(this,arguments)};n.prototype.observeChanges=function(t){e.prototype.observeChanges.apply(this,arguments);if(t.name==="operators"){if(t.current.length===0){e.prototype.getSupportedOperators.apply(this,[])}else{this.setProperty("_operators",t.current,true)}this.updateInternalContent()}else if(t.name==="propertyKey"){this.updateInternalContent()}else if(t.name==="additionalDataType"){p.call(this,t.current)}};n.prototype.fireChangeEvent=function(t,e,i,r){let s;if(t){if(e){if(t.length==1){s=t[0].values[0]}}else{s=i}}this.fireChange({value:s,valid:e,conditions:o([],t),promise:r})};n.prototype.getSupportedOperators=function(){let t=this.getOperators();if(t.length===0){t=e.prototype.getSupportedOperators.apply(this,arguments)}else{this.setProperty("_operators",t,true)}return t};n.prototype.setOperators=function(t){const e=[];if(!Array.isArray(t)){t=t.split(",")}t.forEach(t=>{if(typeof t==="string"){e.push(t)}else{e.push(t.name)}});this.setProperty("operators",e);return this};n.prototype.addOperator=function(t){const e=this.getSupportedOperators();let i=t;if(typeof t!=="string"){i=t.name}if(e.indexOf(i)<0){e.push(i);this.setOperators(e)}return this};n.prototype.addOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(t=>{this.addOperator(t)});return this};n.prototype.removeOperator=function(t){const e=this.getSupportedOperators();let i=t;if(typeof t!=="string"){i=t.name}if(e.indexOf(i)>-1){e.splice(e.indexOf(i),1);this.setOperators(e)}};n.prototype.removeOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(t=>{this.removeOperator(t)})};n.prototype.removeAllOperators=function(){this.setOperators([])};n.prototype.setDefaultOperator=function(t){let e=t;if(t&&typeof t!=="string"){e=t.name}this.setProperty("defaultOperator",e);return this};n.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&!this.isPropertyInitial("dataType")){const i=this._getValueHelp();const o=t.getElementById(i);const s=this.getBindingInfo("conditions");const n=this.getBinding("conditions");if(this.getDisplay()!==r.Value&&i&&(!o||s&&!n)){return}e.prototype.checkCreateInternalContent.apply(this,arguments)}};n.prototype.handleModelContextChange=function(t){e.prototype.handleModelContextChange.apply(this,arguments);if(this.getCurrentContent().length===0){this.triggerCheckCreateInternalContent()}};n.prototype.isSearchField=function(){if(this.isPropertyInitial("propertyKey")){return e.prototype.isSearchField.apply(this,arguments)}else{const t=this.getPropertyKey();const e=new RegExp("^\\*(.*)\\*|\\$search$");return e.test(t)&&this.getMaxConditions()===1}};function p(t){if(!t){this.getContentFactory().setAdditionalDataType()}else if(t.isA&&t.isA("sap.ui.model.Type")){this.getContentFactory().setAdditionalDataType(t)}else if(t.name){this.getContentFactory().setAdditionalDataType()}else{throw new Error("invalid type configuration")}}n.prototype.getAdditionalDataTypeConfiguration=function(){return this.getAdditionalDataType()};const a=(t,e)=>[...t.entries()].find(t=>s(t[0],e));n.prototype.getFormattingPromise=function(){if(this._mDescriptionPromises){const t=[...this._mDescriptionPromises.values()];if(t?.length){return Promise.allSettled(t)}}return undefined};n.prototype._persistFormatConditions=function(){if(!this.getFormattingPromise()){const t=this.getConditions();const e=t.map(t=>{const e=a(this._mDescriptions,t);return e?e[1]:t});this.setProperty("conditions",e,true);this._mDescriptionPromises.clear();this._mDescriptions.clear()}};n.prototype.getFormatOptions=function(){const t=this;return{...e.prototype.getFormatOptions.apply(this,arguments),awaitFormatCondition:function(e,i){const r=i.then(i=>{if(i){t._mDescriptions.set(e,i)}return i}).finally(()=>{t._mDescriptionPromises.delete(e);t._persistFormatConditions()});t._mDescriptionPromises.set(e,r);return r}}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Link", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library","sap/ui/mdc/enums/LinkType"],(e,t,i,jQuery,n,o,r,s,a,l,d,c,p,u)=>{"use strict";const{ResponsiveGridLayout:g}=p.form.SimpleFormLayout;const h=i.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});h.prototype.applySettings=function(){i.prototype.applySettings.apply(this,arguments);this.initControlDelegate()};h.prototype.init=function(){const e=new o({contentTitle:undefined,linkItems:[]});e.setDefaultBindingMode(n.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._oLinkType=null;this._bLinkItemsFetched=false;this._aLinkItems=[];i.prototype.init.apply(this,arguments)};h.prototype.exit=function(){this._bLinkItemsFetched=undefined;this._oLinkType=undefined;this._oUseDelegateItemsPromise=undefined;this._oUseDelegateAdditionalContentPromise=undefined;const e=t=>{if(Array.isArray(t)){t.forEach(e)}else{t.destroy()}};if(this._aLinkItems){this._aLinkItems.forEach(e);this._aLinkItems=undefined}if(this._aAdditionalContent){this._aAdditionalContent.forEach(e);this._aAdditionalContent=undefined}i.prototype.exit.apply(this,arguments)};h.prototype.isTriggerable=function(){return this.retrieveLinkType().then(e=>{if(!e){return false}const t=e.runtimeType;const i=e.initialType?e.initialType:e;if(t&&t instanceof Promise){t.then(e=>{if(!this._oLinkType||e.type!==this._oLinkType.type){this._oLinkType=e;this.fireDataUpdate()}})}return this._oLinkType?this._oLinkType.type===u.DirectLink||this._oLinkType.type===u.Popover:i.type===u.DirectLink||i.type===u.Popover})};h.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(e=>e?e.href:null)};h.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(e=>{if(this.isDestroyed()){return null}this.addDependent(e);return e?{target:e.getTarget(),href:e.getHref()}:null})};h.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(e=>{if(!e){return null}if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink}const t=e.initialType?e.initialType:e;if(this._linkTypeHasDirectLink(t)){return t.directLink}return null})};h.prototype._linkTypeHasDirectLink=function(e){return e&&e.type===u.DirectLink&&e.directLink};h.prototype.getContent=async function(e){const t=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();const[n,o]=await Promise.all([t,i]);this._setConvertedLinkItems(n);const r=this._getInternalModel().getProperty("/linkItems");const s=!o.length&&!r.length?this._getNoContent():o;return this._getContent(n,s,e,a)};h.prototype._getContent=async function(t,i,n,r){const s=await this.retrievePanelId();const a=this._getInternalModel().getProperty("/baselineLinkItems");const d=e.getElementById(s);if(d){if(d.getParent()&&d.getParent().close){d.getParent().close()}d.destroy()}const c=new r(s,{enablePersonalization:this.getEnablePersonalization(),items:a.map(e=>{const t=new l(e.key,{text:e.text,description:e.description,href:e.href,internalHref:e.internalHref,target:e.target,icon:e.icon,visible:true});t.setText(e.text);return t}),additionalContent:i,beforeSelectionDialogOpen:function(){if(n&&n()){n().setModal(true)}},afterSelectionDialogClose:function(){if(n&&n()){n().setModal(false)}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});c.setModel(new o({metadata:jQuery.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:jQuery.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");this._setAdditionalContent(undefined);return c};h.prototype.checkDirectNavigation=async function(e){const t=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();const[n,o]=await Promise.all([t,i]);this._setConvertedLinkItems(n);const r=this._getInternalModel().getProperty("/linkItems");const s=r.length===1&&!o.length;if(s){const t=await this._beforeNavigationCallback(e);if(t){a.navigate(r[0].href)}}return s};h.prototype._setConvertedLinkItems=function(e){const t=this._getInternalModel();const i=e.map(e=>{if(!e.getKey()){s.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+e.getId()+". The mandatory 'key' property should be defined due to personalization reasons.")}return{key:e.getKey(),text:e.getText(),description:e.getDescription(),href:e.getHref(),internalHref:e.getInternalHref(),target:e.getTarget(),icon:e.getIcon(),initiallyVisible:e.getInitiallyVisible(),visible:false}});t.setProperty("/linkItems/",i);const n=i.filter(e=>e.initiallyVisible);t.setProperty("/baselineLinkItems/",n)};h.prototype._getNoContent=function(){const e=new d({layout:g,content:[new c({text:t.getResourceBundleFor("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});e.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return e};h.retrieveAllMetadata=function(e){if(!e.getModel||!e.getModel("$sapuimdcLink")){return[]}const t=e.getModel("$sapuimdcLink");return t.getProperty("/metadata").map(e=>({id:e.key,text:e.text,description:e.description,href:e.href,internalHref:e.internalHref,target:e.target,visible:e.visible}))};h.retrieveBaseline=function(e){if(!e.getModel||!e.getModel("$sapuimdcLink")){return[]}const t=e.getModel("$sapuimdcLink");return t.getProperty("/baseline").map(e=>({id:e.key,visible:true}))};h.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog}if(s.getLevel()>=s.Level.INFO){this._oInfoLog=new r;this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog}}return undefined};h.prototype._getContextObject=function(e){return e?e.getObject(e.getPath()):undefined};h.prototype.retrievePopoverTitle=async function(e){const t=await this.awaitControlDelegate();return t.fetchPopoverTitle(this,e)};h.prototype.retrievePanelId=async function(){if(this.awaitControlDelegate()){await this.awaitControlDelegate();return this.getControlDelegate().getPanelId(this)}s.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve("idInfoPanel")};h.prototype.retrieveAdditionalContent=function(){if(this._aAdditionalContent){return Promise.resolve(this._aAdditionalContent)}else{this._oUseDelegateAdditionalContentPromise=this._useDelegateAdditionalContent();return this._oUseDelegateAdditionalContentPromise.then(()=>Promise.resolve(this._aAdditionalContent))}};h.prototype._useDelegateAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>new Promise(e=>{this.getControlDelegate().fetchAdditionalContent(this,this).then(t=>{this._setAdditionalContent(t===null?[]:t);e()})}))}s.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([])};h.prototype._setAdditionalContent=function(e){this._aAdditionalContent=e};h.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>this._bIsBeingDestroyed?Promise.resolve():this.getControlDelegate().fetchLinkType(this))}s.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null)};h.prototype.retrieveLinkItems=function(){const e=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(t=>this.getControlDelegate().modifyLinkItems(this,e,t).then(e=>e))};h.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems)}else{this._oUseDelegateItemsPromise=this._useDelegateItems();return this._oUseDelegateItemsPromise.then(()=>Promise.resolve(this._aLinkItems))}};h.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>{const e=this._getControlBindingContext();const t=this._getInfoLog();return new Promise(i=>{this.getControlDelegate().fetchLinkItems(this,e,t).then(e=>{this._setLinkItems(e===null?[]:e);this._bLinkItemsFetched=e!==null;i()})})})}s.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve()};h.prototype._setLinkItems=function(e){const t=e.filter(e=>e.getParent()===null);t.forEach(e=>{this.addDependent(e)});this._aLinkItems=e};h.prototype._beforeNavigationCallback=function(e){if(this.awaitControlDelegate()){return this.getControlDelegate().beforeNavigationCallback(this,e)}s.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve()};h.prototype._getControlBindingContext=function(){const e=this._getSourceControl();return e&&e.getBindingContext()||this.getBindingContext()};h.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink")};h.prototype._getSourceControl=function(){const t=this.getAssociation("sourceControl");const i=t&&typeof t==="string"?e.getElementById(t):t;return i??this.getSourceControl()};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/LinkDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/mdc/enums/LinkType","sap/ui/fl/Utils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],(e,t,n,o)=>{"use strict";const r=Object.assign({},e);r.fetchLinkItems=function(e,t){return Promise.resolve(null)};r.fetchLinkType=function(e){return Promise.resolve({initialType:{type:t.Popover,directLink:undefined},runtimeType:null})};r.fetchAdditionalContent=function(e){return Promise.resolve([])};r.modifyLinkItems=function(e,t,n){return Promise.resolve(n)};r.beforeNavigationCallback=function(e,t){return Promise.resolve(true)};r.getPanelId=function(e){let t;if(e.getParent()){t=e.getParent()}let r=e._getSourceControl();if(!r){e.setSourceControl(t);r=t}if(!o.isFlexSupported({element:e})||!o.isFlexSupported({element:r})){return e.getId()+"-idInfoPanel"}else{const e=n.getAppComponentForControl(r)||n.getAppComponentForControl(t);return e.createId("idInfoPanel")}};r.fetchPopoverTitle=function(e,t){if(!e){const e="";return Promise.resolve({sTitle:e,undefined:undefined})}const n=e.getParent()?.getValue();const o=r._getLabelledByControl(t);return Promise.resolve({sTitle:n,oLabelledByControl:o})};r._getLabelledByControl=function(e){const t=e._getAdditionalContentArea().getItems();let n=e._getPersonalizationButton();if(t.length>0){[n]=t}else{const t=e._getLinkControls();if(t.length>0){[n]=t}}return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/MultiValueField", ["sap/ui/mdc/library","sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName"],(t,e,i,n,o,s)=>{"use strict";const a=e.extend("sap.ui.mdc.MultiValueField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/MultiValueField.designtime",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/MultiValueFieldDelegate",payload:{}}}},aggregations:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem",multiple:true,singularName:"item",bindable:"bindable"}},defaultAggregation:"items",events:{change:{parameters:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem[]"},valid:{type:"boolean"},promise:{type:"Promise"}}}}},renderer:i});a.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setProperty("_operators",[s.EQ],true);this._oObserver.observe(this,{aggregations:["items"]})};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer}};a.prototype.bindAggregation=function(t,i){if(t==="items"&&!i.formatter){r.call(this,i)}e.prototype.bindAggregation.apply(this,arguments)};function r(t){if(t.template){let e;if(t.template.mBindingInfos.key){const i=t.template.mBindingInfos.key;e=this.getContentFactory().getDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setDataType(i.type);this.invalidate()}}if(t.template.mBindingInfos.description){const i=t.template.mBindingInfos.description;e=this.getContentFactory().getAdditionalDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setAdditionalDataType(i.type);this.invalidate()}}}}a.prototype.handleModelContextChange=function(t){e.prototype.handleModelContextChange.apply(this,arguments);if(!this._oDataType){const t=this.getBinding("items");if(t){r.call(this,t)}}};a.prototype.initDataType=function(){e.prototype.initDataType.apply(this,arguments);const t=this.getBindingInfo("items");if(t){r.call(this,t)}};a.prototype.setMaxConditions=function(t){if(t===1){throw new Error("Multiple Conditions needed on MultiValueField "+this)}return this.setProperty("maxConditions",t,true)};a.prototype.observeChanges=function(t){e.prototype.observeChanges.apply(this,arguments);if(t.name==="items"){p.call(this,t.child,t.mutation)}if(t.name==="key"){l.call(this)}if(t.name==="description"){l.call(this)}if(t.name==="conditions"){d.call(this,t.current)}};function p(t,e){if(e==="insert"){this._oObserver.observe(t,{properties:true})}else{this._oObserver.unobserve(t)}if(!this._bMyItemUpdate){l.call(this)}}function d(t){if(this._bConditionsUpdateFromItems){return}if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.bIsDestroyed){d.call(this.getConditions())}});return}this.getControlDelegate().updateItems(this.getPayload(),t,this)}function l(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.bIsDestroyed){l.call(this)}});return}if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(()=>{h.call(this);this._iConditionUpdateTimer=undefined},0)}}function h(){const t=this.getItems();const e=[];const i=this.getConditions();const o=this.getControlDelegate();let s=0;let a=t.length!==i.length;for(const r of t){const t=i[s];const p=o.createCondition(this,this,[m(r,"key"),m(r,"description")],t);e.push(p);if(!t||!n.compareConditions(t,p)){a=true}s++}if(a){this._bConditionsUpdateFromItems=true;this.setConditions(e);this._bConditionsUpdateFromItems=false}}function m(t,e){const i=t.getBinding(e);if(i){return i.getInternalValue()}else{return t.getProperty(e)}}a.prototype.fireChangeEvent=function(t,e,i,n){this.fireChange({items:this.getItems(),valid:e,promise:n})};a.prototype.getResultForChangePromise=function(t){return this.getItems()};a.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};a.prototype.checkCreateInternalContent=function(){if(!this.bIsDestroyed&&this._oContentFactory.getDataType()&&!this.isFieldPropertyInitial("editMode")){e.prototype.checkCreateInternalContent.apply(this,arguments)}};a.prototype.isSearchField=function(){return false};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/Table", ["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/TreeTableType","./table/ResponsiveTableType","./table/PropertyHelper","./table/utils/Personalization","./mixin/FilterIntegrationMixin","sap/m/Text","sap/m/ToolbarSpacer","sap/m/Button","sap/m/Title","sap/m/OverflowToolbar","sap/m/library","sap/m/table/Util","sap/m/table/columnmenu/Menu","sap/m/MessageBox","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/core/format/ListFormat","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/model/base/ManagedObjectModel","sap/ui/model/BindingMode","sap/base/strings/capitalize","sap/base/util/deepEqual","sap/base/util/Deferred","sap/ui/core/InvisibleText","sap/ui/mdc/p13n/subcontroller/ColumnController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/GroupController","sap/ui/mdc/p13n/subcontroller/AggregateController","sap/m/table/ColumnWidthController","sap/ui/mdc/p13n/subcontroller/ShowDetailsController","sap/ui/mdc/p13n/subcontroller/ColumnFreezeController","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/mdc/table/menu/QuickActionContainer","sap/ui/core/theming/Parameters","sap/base/Log","sap/ui/performance/trace/FESRHelper","sap/ui/mdc/enums/TableMultiSelectMode","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowCountMode"],(t,e,o,i,n,s,r,a,l,u,p,h,d,c,g,f,_,y,b,T,m,C,x,E,B,A,I,P,S,w,D,v,M,R,F,N,H,z,O,V,L,j,k,G,U,W,K)=>{"use strict";const{ToolbarDesign:q}=g;const{ToolbarStyle:Q}=g;const{IllustratedMessageType:X}=g;const{TitleLevel:$}=x;const{SortOrder:Y}=x;const J=new window.WeakMap;const Z=function(t){if(!J.has(t)){J.set(t,{oFilterInfoBar:null})}return J.get(t)};const tt={Table:i,TreeTable:n,ResponsiveTable:s,null:i};const et=t.extend("sap.ui.mdc.Table",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},p13nMode:{type:"sap.ui.mdc.enums.TableP13nMode[]",group:"Behavior",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:$.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},autoBindOnInit:{type:"boolean",group:"Behavior",defaultValue:true},header:{type:"string",group:"Appearance",defaultValue:null},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true},useColumnLabelsAsTooltips:{type:"boolean",defaultValue:false},selectionMode:{type:"sap.ui.mdc.enums.TableSelectionMode",group:"Behavior",defaultValue:U.None},showRowCount:{type:"boolean",group:"Appearance",defaultValue:true},threshold:{type:"int",group:"Behavior",defaultValue:-1},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},groupConditions:{type:"object"},aggregateConditions:{type:"object"},enableExport:{type:"boolean",group:"Behavior",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100},enableColumnResize:{type:"boolean",group:"Behavior",defaultValue:true},showPasteButton:{type:"boolean",group:"Appearance",defaultValue:false},enablePaste:{type:"boolean",group:"Behavior",defaultValue:true},multiSelectMode:{type:"sap.ui.mdc.enums.TableMultiSelectMode",group:"Behavior",defaultValue:G.Default},enableAutoColumnWidth:{type:"boolean",group:"Behavior",defaultValue:false},propertyInfo:{type:"object",defaultValue:[]},hideToolbar:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.enums.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false},dataStateIndicator:{type:"sap.m.plugins.DataStateIndicator",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false,altTypes:["string"]},copyProvider:{type:"sap.m.plugins.CopyProvider",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},cellSelector:{type:"sap.m.plugins.CellSelector",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{selectAll:{type:"boolean"}}},beforeExport:{allowPreventDefault:true,parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"},filterSettings:{type:"object[]"}}},paste:{parameters:{data:{type:"string[][]"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"},column:{type:"sap.ui.mdc.table.Column"}}}}},constructor:function(){this._createInitPromises();t.apply(this,arguments);this.bCreated=true;this._updateAdaptation();this._initializeContent()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.class("sapUiMdcTable");t.style("width",e.getWidth());e._getType().getTableStyleClasses().forEach(e=>{t.class(e)});t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("div")}}});l.call(et.prototype);const ot=["variant","quickFilter"];ot.forEach(t=>{const e=I(t),o="_o"+e,i="get"+e,n="set"+e,s="destroy"+e;et.prototype[i]=function(){return this[o]};et.prototype[s]=function(){const t=this[o];this[n]();if(t){t.destroy()}return this};et.prototype[n]=function(e){this.validateAggregation(t,e,false);const n=this._createToolbar(),s=e!==this[o];if(!e||s){n.removeBetween(this[i]());this[o]=e}if(s&&e){this._setToolbarBetween(n)}if(t==="variant"){this._updateVariantManagementStyle()}return this}});et.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mSkipPropagation={rowSettings:true};this._bForceRebind=true;this._setPropertyHelperClass(r);this._setupPropertyInfoStore("propertyInfo");this._oManagedObjectModel=new B(this,{hasGrandTotal:false,activeP13nModes:ft(this)});this._oManagedObjectModel.setDefaultBindingMode(A.OneWay);this.setModel(this._oManagedObjectModel,"$sap.ui.mdc.Table")};et.prototype.applySettings=function(e,o){if(e&&"type"in e){const i={type:e.type};if("delegate"in e){i.delegate=e.delegate;delete e.delegate}delete e.type;t.prototype.applySettings.call(this,i,o)}t.prototype.applySettings.call(this,e,o);this.initControlDelegate()};et.prototype._setToolbarBetween=function(t){[this._oVariant,this._oQuickFilter].forEach(e=>{if(e){t.addBetween(e)}})};et.prototype.initialized=function(){return this._oTableReady.promise};et.prototype._fullyInitialized=function(){return this._oFullInitialize.promise};["CopyProvider","CellSelector","DataStateIndicator","ContextMenuSetting"].forEach(t=>{et.prototype[`get${t}PluginOwner`]=function(){return this._oTable||this._oFullInitialize?.promise}});et.prototype.setCopyProvider=function(t){this.setAggregation("copyProvider",t,true);if(window.isSecureContext&&t&&!b.getElementById(this.getId()+"-copy")){this._oToolbar?.insertEnd(this._getCopyButton(),0)}return this};et.prototype.attachEvent=function(e){t.prototype.attachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().prepareRowPress()}return this};et.prototype.detachEvent=function(e){t.prototype.detachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().cleanupRowPress()}return this};et.prototype.getColumnClipboardSettings=function(t){return this.getPropertyHelper().getColumnClipboardSettings(t)};et.prototype.setDataStateIndicator=function(t){this._handleDataStateEvents(this.getDataStateIndicator(),"detach");this.setAggregation("dataStateIndicator",t,true);this._handleDataStateEvents(this.getDataStateIndicator(),"attach");return this};et.prototype._handleDataStateEvents=function(t,e){if(t){t[e+"ApplyFilter"](this._onApplyMessageFilter,this);t[e+"ClearFilter"](this._onClearMessageFilter,this);t[e+"Event"]("filterInfoPress",function(){a.openFilterDialog(this)},this)}};et.prototype._onApplyMessageFilter=function(t){this._oMessageFilter=t.getParameter("filter");t.preventDefault();if(this.isTableBound()){this.rebind()}};et.prototype._onClearMessageFilter=function(t){this._oMessageFilter=null;t.preventDefault();if(this.isTableBound()){this.rebind()}};et.prototype._isOfType=function(t,e){const o=this._getType();if(e){return o.isA(tt[t].getMetadata().getName())}else{return o.constructor===tt[t]}};et.prototype.setContextMenu=function(t){this._oContextMenu=this.validateAggregation("contextMenu",t,false);this._oTable?.setAggregation("contextMenu",t,true);return this};et.prototype.getContextMenu=function(){return this._oContextMenu&&!this._oContextMenu.isDestroyed()?this._oContextMenu:null};et.prototype.destroyContextMenu=function(){if(this._oTable){this._oTable.destroyContextMenu()}else if(this._oContextMenu){this._oContextMenu.destroy()}this._oContextMenu=null;return this};et.prototype._onBeforeOpenContextMenu=function(t){const e=t.contextMenu;let o=true;if(e.isA("sap.ui.mdc.table.menu.GroupHeaderRowContextMenu")){e.initContent(this,{groupLevel:t.groupLevel});o=e.isEmpty()}else{o=!this.fireBeforeOpenContextMenu({bindingContext:t.bindingContext,column:t.column})}if(o){t.event.preventDefault()}};et.prototype.scrollToIndex=function(t){if(typeof t!=="number"){return Promise.reject("The iIndex parameter has to be a number")}return this._getType().scrollToIndex(t)};et.prototype.focusRow=function(t,e){return this.scrollToIndex(t).then(()=>this._oTable._setFocus(t,e))};et.prototype.setType=function(t){if(!this.bCreated){return this.setAggregation("type",t,true)}this._resetContent();this.setAggregation("type",t);this._initializeContent();this._updateAdaptation();return this};et.prototype.destroyType=function(){if(!this.getType()){return this.destroyAggregation("type",true)}this._resetContent();this.destroyAggregation("type");this._initializeContent();return this};et.prototype._resetContent=function(){if(this._oTable){if(this._oToolbar){this._getType().removeToolbar()}const t=this.getNoData();this.setNoData();this._vNoData=t;const e=this.getContextMenu();this.setContextMenu();this._oContextMenu=e;this._oTable.destroy("KeepDom");this._oTable=null}else{this._onAfterInitialization("Type changed");this._onAfterFullInitialization("Type changed")}if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=null}this._destroyDefaultType();this._createInitPromises()};et.prototype._getType=function(){const t=this.getType();if(!this._oDefaultType&&(typeof t==="string"||t===null)){this._oDefaultType=new tt[t];this.addDependent(this._oDefaultType)}return this._oDefaultType||this.getType()};et.prototype._destroyDefaultType=function(){if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}};et.prototype.setRowSettings=function(t){this.setAggregation("rowSettings",t,true);this._getType().updateRowSettings();if(this.isTableBound()){this._bForceRebind=true;this.rebind()}return this};et.prototype.setHeaderLevel=function(t){if(this.getHeaderLevel()===t){return this}this.setProperty("headerLevel",t,true);this._oTitle?.setLevel(t);this._updateVariantManagementStyle();return this};et.prototype.setHeaderStyle=function(t){if(this.getHeaderStyle()===t){return this}this.setProperty("headerStyle",t,true);const e=this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})];this._oTitle?.setTitleStyle(e);this._updateVariantManagementStyle();return this};et.prototype.focus=function(t){if(this._oTable){this._oTable.focus(t)}};et.prototype.setBusy=function(t){this.setProperty("busy",t,true);if(this._oTable){this._oTable.setBusy(t)}return this};et.prototype.setBusyIndicatorDelay=function(t){this.setProperty("busyIndicatorDelay",t,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(t)}return this};et.prototype.setCreationRow=function(t){this.setAggregation("creationRow",t,true);if(t){t.update()}return this};et.prototype.setEnableColumnResize=function(t){const e=this.getEnableColumnResize();this.setProperty("enableColumnResize",t,true);if(this.getEnableColumnResize()!==e){this._updateColumnResize();this._updateAdaptation()}return this};const it=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Column")>-1||t.indexOf("Group")>-1||t.indexOf("Aggregate")>-1||t.indexOf("Filter")>-1)){e=true}return e};et.prototype._onModifications=async function(t){this.getColumns().forEach(t=>{t._onModifications()});this._getType().onModifications(t);if(it(t)&&this.isTableBound()){await this.finalizePropertyHelper();await this.rebind()}};et.prototype.setP13nMode=function(t){const e=this.getP13nMode();let o=[];if(t&&t.length>1){const e=t.reduce((t,e,o)=>{t[e]=true;return t},{});if(e.Column){o.push("Column")}if(e.Sort){o.push("Sort")}if(e.Filter){o.push("Filter")}if(e.Group){o.push("Group")}if(e.Aggregate){o.push("Aggregate")}}else{o=t}this.setProperty("p13nMode",o,true);this._updateAdaptation();this._oManagedObjectModel.setProperty("/@custom/activeP13nModes",ft(this));if(!P(e.sort(),this.getP13nMode().sort())){nt(this)}return this};et.prototype._updateAdaptation=function(){const t={controller:{}};const e=[];if(this.getColumns().length>0&&this._isOfType(K.TreeTable)){e.push(this.getColumns()[0].getPropertyKey())}const o={Column:new D({control:this,stableKeys:e}),Sort:new v({control:this}),Group:new R({control:this}),Filter:new M({control:this}),Aggregate:new F({control:this}),ColumnWidth:new N({control:this,exposeXConfig:true})};this.getActiveP13nModes().forEach(e=>{t.controller[e]=o[e]});if(this.getEnableColumnResize()){t.controller["ColumnWidth"]=o["ColumnWidth"]}if(this._isOfType(K.Table,true)&&this._getType().getEnableColumnFreeze()){o["ColumnFreeze"]=new z({control:this});t.controller["ColumnFreeze"]=o["ColumnFreeze"]}if(this._isOfType(K.ResponsiveTable)&&this._getType().getShowDetailsButton()){o["ShowDetails"]=new H({control:this});t.controller["ShowDetails"]=o["ShowDetails"]}this.getEngine().register(this,t)};function nt(t){t._updateP13nButton();if(t._oTable){const e=t._oTable.getDragDropConfig()[0];if(e){e.setEnabled(t.getActiveP13nModes().indexOf("Column")>-1)}}if(t.isFilteringEnabled()){rt(t)}st(t)}et.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);this.getInbuiltFilter()?.setFilterConditions(t);st(this);return this};function st(t){const e=ut(t);const o=pt(t);const i=ht(t);if(!e){return}if(i.length===0){const o=e.getDomRef();if(o&&o.contains(document.activeElement)){t.focus()}e.setVisible(false);at(t).setText("");return}t._fullyInitialized().then(()=>{const n=t.getPropertyHelper();const s=i.map(t=>n.hasProperty(t)?n.getProperty(t).label:"");const r=T.getResourceBundleFor("sap.ui.mdc");const a=C.getInstance();let l;if(s.length>1){l=r.getText("table.MULTIPLE_FILTERS_ACTIVE",[s.length,a.format(s)])}else{l=r.getText("table.ONE_FILTER_ACTIVE",s)}if(!e.getVisible()){e.setVisible(true)}o.setText(l);at(t).setText(l)})}function rt(t){if(!t._oTable){return}let e=ut(t);const o=at(t);if(!e){e=lt(t)}t._getType().insertFilterInfoBar(e,o.getId())}function at(t){if(!t._oFilterInfoBarInvisibleText){t._oFilterInfoBarInvisibleText=(new w).toStatic()}return t._oFilterInfoBarInvisibleText}function lt(t){const e=t.getId()+"-filterInfoBar";let o=Z(t).oFilterInfoBar;const i=T.getResourceBundleFor("sap.ui.mdc");if(o&&!o.isDestroyed()){o.destroy()}o=new c({id:e,active:true,design:q.Info,visible:false,ariaLabelledBy:e+"-text",content:[new u({id:e+"-text",wrapping:false}),new p,new h({type:g.ButtonType.Transparent,tooltip:i.getText("infobar.REMOVEALLFILTERS"),icon:"sap-icon://decline",press:function(){a.createClearFiltersChange(t);t.focus()}})],press:function(){a.openFilterDialog(t,()=>{if(ht(t).length===0){t.focus()}})}});Z(t).oFilterInfoBar=o;st(t);return o}function ut(t){const{oFilterInfoBar:e}=Z(t);if(e?.isDestroyStarted()){return null}return e}function pt(t){const e=ut(t);return e?e.getContent()[0]:null}et.prototype.setThreshold=function(t){return this.setProperty("threshold",t,true)};et.prototype._onFilterProvided=function(t){this._updateInnerTableNoData()};et.prototype._onFilterRemoved=function(t){this._updateInnerTableNoData()};et.prototype._onFiltersChanged=function(t){if(this.isTableBound()&&t.getParameter("conditionsBased")){this._oTable.setShowOverlay(true)}};et.prototype._onFilterSearch=function(t){this._bAnnounceTableUpdate=true};et.prototype.setNoData=function(t){this._vNoData=this.validateAggregation("noData",t,false);if(!this._oTable){return this}if(t&&t.isA&&t.isA("sap.m.IllustratedMessage")){this._sLastNoDataTitle="";t.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));let e=this._oTable.getAggregation("_noColumnsMessage");if(!e){e=f.getNoColumnsIllustratedMessage(()=>{a.openSettingsDialog(this)});e.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));this._oTable.setAggregation("_noColumnsMessage",e)}}this._oTable.setNoData(t);this._updateInnerTableNoData();return this};et.prototype.getNoData=function(){return this._vNoData&&!this._vNoData.isDestroyed?.()?this._vNoData:null};et.prototype.destroyNoData=function(){if(this._oTable){this._oTable.destroyNoData(true)}else if(this._vNoData){this._vNoData.destroy?.()}this._vNoData=null;return this};et.prototype._updateInnerTableNoData=function(){const t=this.getNoData();if(!t||typeof t=="string"){return this._updateInnerTableNoDataText()}if(!t.isA("sap.m.IllustratedMessage")||this._sLastNoDataTitle!=t.getTitle()){return}const e=T.getResourceBundleFor("sap.ui.mdc");if(!this.isTableBound()){t.setDescription(" ");if(this.getFilter()){t.setTitle(e.getText("table.NO_DATA_WITH_FILTERBAR"));t.setIllustrationType(X.BeforeSearch)}else{t.setIllustrationType(X.NoEntries);t.setTitle(e.getText("table.NO_DATA"))}}else if(ct(this)){t.setTitle(e.getText("table.NO_RESULTS_TITLE"));t.setDescription(e.getText("table.NO_RESULTS_DESCRIPTION"));t.setIllustrationType(X.NoFilterResults)}else{t.setTitle(e.getText("table.NO_DATA")).setDescription(" ");t.setIllustrationType(X.NoEntries)}this._sLastNoDataTitle=t.getTitle()};et.prototype._updateInnerTableNoDataText=function(){if(this._oTable){this._oTable.setNoData(this._getNoDataText())}};et.prototype._getNoDataText=function(){const t=this.getNoData();if(t&&typeof t=="string"){return t}const e=T.getResourceBundleFor("sap.ui.mdc");if(!this.isTableBound()){return e.getText(this.getFilter()?"table.NO_DATA_WITH_FILTERBAR":"table.NO_DATA")}if(ct(this)){return e.getText("table.NO_RESULTS")}return e.getText("table.NO_DATA")};et.prototype._updateRowActions=function(){this._getType().updateRowActions()};et.prototype._initializeContent=function(){const t=this._getType();const e=[this.awaitControlDelegate(),t.loadModules()];if(this.isFilteringEnabled()){e.push(this.retrieveInbuiltFilter())}Promise.all(e).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this._oManagedObjectModel.setProperty("/@custom/activeP13nModes",ft(this));this._updateAdaptation();if(this.getControlDelegate().preInit){this.getControlDelegate().preInit(this)}if(!this._oTable&&t.constructor===this._getType().constructor){return this._createContent()}else{return Promise.resolve()}}).catch(t=>{this._onAfterInitialization(t||"");this._onAfterFullInitialization(t||"")})};et.prototype._createInitPromises=function(){this._oTableReady=new S;this._oFullInitialize=new S;this._oFullInitialize.promise.catch(()=>{})};et.prototype._onAfterInitialization=function(t){if(this._oTableReady){if(t!=null){this._oTableReady.reject(t)}else{this._oTableReady.resolve(this)}}};et.prototype._onAfterFullInitialization=function(t){if(this._oFullInitialize){if(t!=null){this._oFullInitialize.reject(t)}else{this._oFullInitialize.resolve(this)}}};et.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateColumnResize();this._updateRowActions();this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();this.getColumns().forEach(this._insertInnerColumn,this);return this.getControlDelegate().initializeContent(this).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this.setAggregation("_content",this._oTable);this._onAfterInitialization();return Promise.all([this.getPropertyInfo().length===0?this.finalizePropertyHelper():this.awaitPropertyHelper(),this.initialized()])}).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}const t=this.getCreationRow();if(t){t.update()}if(this.getAutoBindOnInit()){const t=this.getEngine();t.isModificationSupported(this).then(e=>{if(e){t.waitForChanges(this).then(()=>{this.rebind()})}else{this.rebind()}})}this._onAfterFullInitialization()})};et.prototype.setHeader=function(t){this.setProperty("header",t,true);this._updateHeaderText();return this};et.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px")}this._updateInvisibleTitle();this._updateVariantManagementStyle();return this};et.prototype._updateInvisibleTitle=function(){if(this._oInvisibleTitle&&!this.getHideToolbar()){this._oInvisibleTitle.destroy();this._oInvisibleTitle=null;this._oTable.removeAriaLabelledBy(this.getId()+"-invisibleTitle")}else if(this._oTable&&!this._oInvisibleTitle&&this.getHideToolbar()){this._oInvisibleTitle=new w(this.getId()+"-invisibleTitle",{text:"{$sap.ui.mdc.Table>/header}"}).toStatic();this._oTable.addAriaLabelledBy(this.getId()+"-invisibleTitle")}else if(this._oInvisibleTitle&&!this._oTable.getAriaLabelledBy().includes(this.getId()+"-invisibleTitle")){this._oTable.addAriaLabelledBy(this.getId()+"-invisibleTitle")}};et.prototype.setShowRowCount=function(t){this.setProperty("showRowCount",t,true);this._updateHeaderText();return this};et.prototype.setEnableExport=function(t){this.setProperty("enableExport",t,true);this._updateExportButton();return this};et.prototype.setShowPasteButton=function(t){if((t=!!t)==this.getShowPasteButton()){return this}this.setProperty("showPasteButton",t,true);if(t&&!this._oPasteButton&&this._oToolbar){this._oToolbar.insertEnd(this._getPasteButton(),0);this._oPasteButton.setEnabled(this.getEnablePaste())}else if(this._oPasteButton){this._oPasteButton.setVisible(t);this._oPasteButton.setEnabled(this.getEnablePaste())}return this};et.prototype.setEnablePaste=function(t){this.setProperty("enablePaste",t,true);if(this._oPasteButton){this._oPasteButton.setEnabled(this.getEnablePaste())}return this};et.prototype._setShowP13nButton=function(t){this._bHideP13nButton=!t;this._updateP13nButton()};et.prototype._isP13nButtonHidden=function(){return this._bHideP13nButton};et.prototype._createToolbar=function(){if(this.isDestroyStarted()){return}if(!this._oToolbar){this._oTitle=new d(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel(),titleStyle:this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})]});this._oToolbar=new e(this.getId()+"-toolbar",{design:q[L.get({name:"_sap_ui_mdc_Table_ToolbarDesign"})],begin:[this._oTitle],end:[this._getCopyButton(),this._getPasteButton(),this._getP13nButton()],visible:"{= !${$sap.ui.mdc.Table>/hideToolbar} }"});this._oToolbar.setProperty("_endOrder",["copy","paste","showHideDetails","collapseAll","expandAll","settings","export"].map(t=>this.getId()+"-"+t));this._updateInvisibleTitle()}this._oToolbar.setStyle(this._isOfType(K.ResponsiveTable)?Q.Standard:Q.Clear);return this._oToolbar};et.prototype._getVisibleProperties=function(){const t=[];let e;this.getColumns().forEach((o,i)=>{e=o&&o.getPropertyKey();if(e){t.push({key:e,name:e})}});return t};et.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};et.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[]};et.prototype._getGroupedProperties=function(){return this.getGroupConditions()?this.getGroupConditions().groupLevels:[]};et.prototype._getAggregatedProperties=function(){return this.getAggregateConditions()?this.getAggregateConditions():{}};et.prototype._getXConfig=function(){return this.getEngine().readXConfig(this)};function ht(t){return t.isFilteringEnabled()?gt(t.getFilterConditions()):[]}function dt(t){const e=b.getElementById(t.getFilter());return e?gt(e.getConditions()):[]}function ct(t){const e=b.getElementById(t.getFilter());return ht(t).length>0||dt(t).length>0||e&&e.getSearch()!==""}function gt(t){return Object.keys(t||{}).filter(e=>t[e].length>0)}et.prototype.getCurrentState=function(){const t={};const e=this.getActiveP13nModes();if(e.indexOf("Column")>-1){t.items=this._getVisibleProperties()}if(this.isSortingEnabled()){t.sorters=this._getSortedProperties()}if(this.isFilteringEnabled()){t.filter=this.getFilterConditions()}if(this.isGroupingEnabled()){t.groupLevels=this._getGroupedProperties()}if(this.isAggregationEnabled()){t.aggregations=this._getAggregatedProperties()}if(this.getEnableColumnResize()||this._getType().showXConfigState()){t.xConfig=this._getXConfig()}return t};et.prototype.isFilteringEnabled=function(){return this.getActiveP13nModes().includes(W.Filter)};et.prototype.isSortingEnabled=function(){return this.getActiveP13nModes().includes(W.Sort)};et.prototype.isGroupingEnabled=function(){return this.getActiveP13nModes().includes(W.Group)};et.prototype.isAggregationEnabled=function(){return this.getActiveP13nModes().includes(W.Aggregate)};et.prototype.getSupportedP13nModes=function(){let t=Object.keys(W);if(this.isControlDelegateInitialized()){t=_t(t,this.getControlDelegate().getSupportedFeatures(this).p13nModes)}return t};function ft(t){const e=new Set(Object.keys(W));const o=new Set(t.getP13nMode());const i=new Set(t.isControlDelegateInitialized()?t.getControlDelegate().getSupportedFeatures(t).p13nModes:[]);const n=o.intersection(i);return Array.from(e).reduce((t,e)=>{t[e]=n.has(e);return t},{})}et.prototype.getActiveP13nModes=function(){return _t(this.getP13nMode(),this.getSupportedP13nModes())};function _t(t,e){return t.filter(t=>e.includes(t))}et.prototype._getP13nButton=function(){if(!this._oP13nButton){this._oP13nButton=o.createSettingsButton(this.getId(),[function(){a.openSettingsDialog(this)},this])}this._updateP13nButton();return this._oP13nButton};et.prototype._updateP13nButton=function(){if(this._oP13nButton){const t=this.getActiveP13nModes();const e=t.length===1&&t[0]==="Aggregate";this._oP13nButton.setVisible(t.length>0&&!e&&!this._bHideP13nButton)}};et.prototype._getCopyButton=function(){if(window.isSecureContext){return this.getCopyProvider()?.getCopyButton({id:this.getId()+"-copy"})}};et.prototype._getPasteButton=function(){if(this.getShowPasteButton()){if(!this._oPasteButton){this._oPasteButton=o.createPasteButton(this.getId())}return this._oPasteButton}};et.prototype._isExportEnabled=function(){return this.getEnableExport()&&this.isControlDelegateInitialized()&&this.getControlDelegate().getSupportedFeatures(this).export};et.prototype._updateExportButton=function(){const t=this._oToolbar!=null&&this._isExportEnabled();if(t&&!this._oExportButton){this._oExportButton=this._createExportButton()}if(!this._oExportButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExportButton)){this._oToolbar.addEnd(this._oExportButton)}this._oExportButton.setEnabled(f.isExportable(this.getRowBinding()));this._oExportButton.setVisible(this._isExportEnabled())};et.prototype._createExportButton=function(){return o.createExportButton(this.getId(),{default:[function(){this._onExport()},this],exportAs:[function(){this._onExport(true)},this]})};et.prototype._createExportColumnConfiguration=function(){const t=this.getColumns();return this._fullyInitialized().then(()=>this.finalizePropertyHelper()).then(()=>{const e=this.getPropertyHelper();let o=[];t.forEach(t=>{const i=e.getColumnExportSettings(t);o=o.concat(i)},this);return o})};et.prototype.setSelectionMode=function(t){const e=this.getSelectionMode();this.setProperty("selectionMode",t,true);if(e!==t){this._updateExpandAllButton(true);this._updateCollapseAllButton(true)}return this};et.prototype._isCollapseEnabled=async function(){if(!this.isControlDelegateInitialized()){return false}const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);let e=false;if("collapseAll"in t){if(typeof t.collapseAll!=="function"){throw new Error("TableDelegate#collapseAll: collapseAll needs to be a function")}e=true}if("collapseAllFromNode"in t&&"isNodeExpanded"in t){if(typeof t.collapseAllFromNode!=="function"){throw new Error("TableDelegate#fetchExpandAndCollapseConfiguration: collapseAllFromNode needs to be a function")}if(typeof t.isNodeExpanded!=="function"){throw new Error("TableDelegate#isNodeExpanded: isNodeExpanded needs to be a function")}e=true}return e};et.prototype._updateCollapseAllButton=async function(t){const e=await this._isCollapseEnabled();const o=this._oToolbar!=null&&e;if(o&&(!this._oCollapseAllButton||t)){if(this._oCollapseAllButton){if(this._oToolbar&&this._oToolbar.getEnd().includes(this._oCollapseAllButton)){this._oToolbar.removeEnd(this._oCollapseAllButton)}this._oCollapseAllButton.destroy();this._oCollapseAllButton=null}this._oCollapseAllButton=await this._createCollapseButton()}if(!this._oCollapseAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oCollapseAllButton)){this._oToolbar.insertEnd(this._oCollapseAllButton,0)}this._oCollapseAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oCollapseAllButton.setVisible(e)};et.prototype._isExpandEnabled=async function(){if(!this.isControlDelegateInitialized()){return false}const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);let e=false;if("expandAll"in t){if(typeof t.expandAll!=="function"){throw new Error("TableDelegate#expandAll: expandAll needs to be a function")}e=true}if("expandAllFromNode"in t&&"isNodeExpanded"in t){if(typeof t.expandAllFromNode!=="function"){throw new Error("TableDelegate#fetchExpandAndCollapseConfiguration: expandAllFromNode needs to be a function")}if(typeof t.isNodeExpanded!=="function"){throw new Error("TableDelegate#isNodeExpanded: isNodeExpanded needs to be a function")}e=true}return e};et.prototype._updateExpandAllButton=async function(t){const e=await this._isExpandEnabled();const o=this._oToolbar!=null&&e;if(o&&(!this._oExpandAllButton||t)){if(this._oExpandAllButton){if(this._oToolbar&&this._oToolbar.getEnd().includes(this._oExpandAllButton)){this._oToolbar.removeEnd(this._oExpandAllButton)}this._oExpandAllButton.destroy();this._oExpandAllButton=null}this._oExpandAllButton=await this._createExpandButton()}if(!this._oExpandAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExpandAllButton)){this._oToolbar.insertEnd(this._oExpandAllButton,0)}this._oExpandAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oExpandAllButton.setVisible(e)};et.prototype._createExpandButton=async function(){const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);return this._createExpandCollapseButton(true,{tree:t.expandAll,node:t.expandAllFromNode,isExpanded:t.isNodeExpanded})};et.prototype._createCollapseButton=async function(){const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);return this._createExpandCollapseButton(false,{tree:t.collapseAll,node:t.collapseAllFromNode,isExpanded:t.isNodeExpanded})};et.prototype._createExpandCollapseButton=function(t,e){const{tree:i,node:n,isExpanded:s}=e;if(this.getSelectionMode()==="None"||typeof n!=="function"||typeof s!=="function"){return o.createExpandCollapseButton(this.getId(),t,()=>i(this))}const r=o.createExpandCollapseMenuButton(this.getId(),t,{tree:()=>i(this),node:()=>{const t=this.getSelectedContexts();return t.length===1&&n(this,t[0])}});r.attachBeforeMenuOpen(()=>{const e=this.getSelectedContexts();const o=e.length===1&&s(this,e[0])===!t;r.getMenu().getItems()[0].setEnabled(i!=undefined);r.getMenu().getItems()[1].setEnabled(o)});return r};et.prototype._getColumnLabel=function(t){const e=this.getPropertyHelper();const o=e.getProperty(t);return o&&o.label};et.prototype.triggerExport=function(){if(!this._isExportEnabled()){return Promise.reject("Export is not enabled for this table.")}return this._onExport()};et.prototype._onExport=function(t){const e=this;return this._createExportColumnConfiguration().then(o=>{if(!o||!o.length){const t=T.getResourceBundleFor("sap.ui.mdc").getText("table.NO_COLS_EXPORT");sap.ui.require(["sap/m/MessageBox"],function(e){e.error(t,{styleClass:this.$()&&this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}.bind(e));throw new Error(t)}const i=e.getRowBinding();const n=e._getColumnLabel.bind(e);const s=t?"exportAs":"export";const r={workbook:{columns:o,context:{title:e.getHeader()}},dataSource:i,fileName:e.getHeader()};return e._getExportHandler().then(t=>{t[s](r,n)})})};et.prototype._getExportHandler=function(){const t=this;if(this._oExportHandler){return Promise.resolve(this._oExportHandler)}return new Promise((e,o)=>{Promise.all([t.getControlDelegate().fetchExportCapabilities(t),T.load({name:"sap.ui.export"})]).then(o=>{const[i]=o;sap.ui.require(["sap/ui/export/ExportHandler"],o=>{t._oExportHandler=new o(i);t._oExportHandler.attachBeforeExport(t._onBeforeExport,t);e(t._oExportHandler)})}).catch(t=>{if(!T.all().hasOwnProperty("sap.ui.export")){y.error(T.getResourceBundleFor("sap.ui.mdc").getText("ERROR_MISSING_EXPORT_LIBRARY"))}o(t)})})};et.prototype._onBeforeExport=function(t){const e=t.getParameter("filterSettings");const o=this.getPropertyHelper();e.forEach(t=>{const e=o.getProperties().find(e=>e.path===t.getProperty());if(e){t.setLabel(e.label);t.setType(e.typeConfig.typeInstance)}});const i=this.fireBeforeExport({exportSettings:t.getParameter("exportSettings"),userExportSettings:t.getParameter("userExportSettings"),filterSettings:e});if(!i){t.preventDefault()}};et.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.shiftKey&&t.which===E.E){if(this._oExportButton&&this._oExportButton.getEnabled()&&this._isExportEnabled()){this._onExport(true);t.setMarked();t.preventDefault()}}if((t.metaKey||t.ctrlKey)&&t.which===E.COMMA){if(this._oP13nButton&&this._oP13nButton.getVisible()){this._oP13nButton.firePress();t.setMarked();t.preventDefault()}}};et.prototype._createTable=function(){const t=this._getType();this._oTable=t.createTable(this.getId()+"-innerTable");this._oRowTemplate=t.createRowTemplate(this.getId()+"-innerTableRow");t.updateTable();if(this.getNoData()){this.setNoData(this.getNoData())}if(this.getContextMenu()){this.setContextMenu(this.getContextMenu())}if(this.isFilteringEnabled()){rt(this)}if(!this._oColumnHeaderMenu){this._oQuickActionContainer=new V({table:this});this._oColumnHeaderMenu=new _({id:this.getId()+"-columnHeaderMenu",showTableSettingsButton:true});this._oColumnHeaderMenu.addAggregation("_quickActions",this._oQuickActionContainer);this.addDependent(this._oColumnHeaderMenu);k.setSemanticStepname(this._oColumnHeaderMenu,"beforeOpen","mdc:tbl:p13n:col");this._oColumnHeaderMenu.attachBeforeOpen(this._createColumnMenuContent,this)}this._updateInvisibleTitle()};et.prototype._createColumnMenuContent=function(t){const e=t.getParameter("openBy");const o=this.getColumns()[e.getParent().indexOfColumn(e)];t.preventDefault();this._oQuickActionContainer.setColumn(o);this._fullyInitialized().then(()=>this.finalizePropertyHelper()).then(()=>{this._oQuickActionContainer.initializeQuickActions();this._oColumnHeaderMenu.detachTableSettingsPressed(this._showTableP13nDialog,this);this._oColumnHeaderMenu.attachTableSettingsPressed(o,this._showTableP13nDialog,this);this._oColumnHeaderMenu.openBy(e,true);a.detectUserPersonalizationCompletion(this,this._oColumnHeaderMenu)})};et.prototype._showTableP13nDialog=function(t,e){a.openSettingsDialog(this,e)};et.prototype._updateColumnResize=function(){const t=this._getType();if(this.getEnableColumnResize()){t.enableColumnResize()}else{t.disableColumnResize()}};et.prototype._onColumnMove=function(t){a.createColumnReorderChange(this,{column:t.column,index:t.newIndex})};et.prototype._onRowPress=function(t){if(this.getSelectionMode()!==U.SingleMaster){this.fireRowPress({bindingContext:t.bindingContext})}};et.prototype._onSelectionChange=function(t){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({selectAll:t.selectAll})}};et.prototype._onColumnResize=function(t){a.createColumnWidthChange(this,{column:t.column,width:t.width})};et.prototype._insertInnerColumn=function(t,e){if(!this._oTable){return}const o=t.getInnerColumn();this._setMobileColumnTemplate(t,e);this._bForceRebind=true;if(e===undefined){this._oTable.addColumn(o)}else{this._oTable.insertColumn(o,e)}this._getType()._onColumnInsert(t)};et.prototype.moveColumn=function(t,e){t._bIsBeingMoved=true;this.removeAggregation("columns",t,true);this.insertAggregation("columns",t,e,true);delete t._bIsBeingMoved;if(this._oTable){const o=t.getInnerColumn();this._oTable.removeColumn(o);this._oTable.insertColumn(o,e);this._updateMobileColumnTemplate(t,e)}};et.prototype.removeColumn=function(t){t=this.removeAggregation("columns",t,true);this._updateMobileColumnTemplate(t,-1);return t};et.prototype.addColumn=function(t){this.addAggregation("columns",t,true);this._insertInnerColumn(t);return this};et.prototype.insertColumn=function(t,e){this.insertAggregation("columns",t,e,true);this._insertInnerColumn(t,e);return this};et.prototype._setMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}const o=t.getTemplateClone();if(e>=0){this._oRowTemplate.insertCell(o,e);this._oTable.getItems().forEach(t=>{if(t.isA("sap.m.GroupHeaderListItem")){return}t.insertAggregation("cells",new w,e,true)})}else{this._oRowTemplate.addCell(o)}};et.prototype._updateMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}let o,i;if(this._oRowTemplate){o=t.getTemplateClone();i=this._oRowTemplate.indexOfCell(o);yt(this._oRowTemplate,i,e)}if(i>-1){this._oTable.getItems().forEach(t=>{if(t.removeCell){yt(t,i,e)}})}};function yt(t,e,o){const i=t.removeCell(e);if(i){if(o>-1){t.insertCell(i,o)}else{i.destroy()}}}et.prototype.getSelectedContexts=function(){if(this.isControlDelegateInitialized()){return this.getControlDelegate().getSelectedContexts(this)}return[]};et.prototype.clearSelection=function(){if(this.isControlDelegateInitialized()){this._bSelectionChangedByAPI=true;this.getControlDelegate().clearSelection(this);this._bSelectionChangedByAPI=false}};et.prototype._registerInnerFilter=function(t){t.attachSearch(this._rebind,this)};et.prototype.isTableBound=function(){return this._getType().isTableBound()};et.prototype._onDataRequested=function(){this._bIgnoreChange=true};et.prototype._onDataReceived=function(){this._bIgnoreChange=false;this._updateTableHeaderState()};et.prototype._onCreateActivate=function(){Promise.resolve().then(()=>{this._updateTableHeaderState()})};et.prototype._onBindingChange=function(){this.fireEvent("_bindingChange");this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();if(this._bIgnoreChange){return}this._updateTableHeaderState()};et.prototype._updateTableHeaderState=function(){this._updateHeaderText()};et.prototype._updateHeaderText=function(){let t,e;if(!this._oNumberFormatInstance){this._oNumberFormatInstance=m.getFloatInstance()}if(this._oTitle&&this.getHeader()){t=this.getHeader();if(this.getShowRowCount()){e=this.getRowBinding()?this.getRowBinding().getCount():0;if(e>0){const o=this._oNumberFormatInstance.format(e);t+=" ("+o+")"}}this._oTitle.setText(t)}if(!this._bIgnoreChange&&this._bAnnounceTableUpdate){this._bAnnounceTableUpdate=false;f.announceTableUpdate(this.getHeader(),e)}};et.prototype._updateColumnsBeforeBinding=function(){const t=this.getColumns();const e=this.getPropertyHelper();t.forEach(function(t){const o=e.getProperty(t.getPropertyKey());const i=o?.getSortableProperties().map(t=>t.name)??[];const n=this._getSortedProperties().find(t=>i.includes(t.name));let s=Y.None;if(n){s=n.descending?Y.Descending:Y.Ascending}this._getType().updateSortIndicator(t,s)},this)};et.prototype.getRowBinding=function(){return this._getType().getRowBinding()};et.prototype._getRowBinding=function(){j.error(this+": The method '_getRowBinding' must not be used will be deleted soon. Use 'getRowBinding' instead.");return this.getRowBinding()};et._addBindingListener=function(t,e,o){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=o}else{const i=t.events[e];t.events[e]=function(){o.apply(this,arguments);i.apply(this,arguments)}}};et.prototype._rebind=async function(t=false){const e={};await this._fullyInitialized();this.getControlDelegate().updateBindingInfo(this,e);this._finalizeBindingInfo(e);this._oTable.setShowOverlay(false);this._updateColumnsBeforeBinding();this.getControlDelegate().updateBinding(this,e,this._bForceRebind?null:this.getRowBinding(),{forceRefresh:t});this._updateInnerTableNoData();this._bForceRebind=false};et.prototype._finalizeBindingInfo=function(t){if(this._oRowTemplate){t.template=this._oRowTemplate;t.templateShareable=true}else{delete t.template}et._addBindingListener(t,"dataRequested",this._onDataRequested.bind(this));et._addBindingListener(t,"dataReceived",this._onDataReceived.bind(this));et._addBindingListener(t,"createActivate",this._onCreateActivate.bind(this));et._addBindingListener(t,"change",this._onBindingChange.bind(this))};et.prototype._onPaste=function(t){if(this.getEnablePaste()){this.firePaste({data:t.data})}};et.prototype.exit=function(){this._onAfterInitialization("Destroyed");this._onAfterFullInitialization("Destroyed");["_oTable","_oTitle","_vNoData","_oContextMenu","_oNumberFormatInstance","_oTableReady","_oFullInitialize","_oPasteButton","_oP13nButton","_oRowTemplate","_oToolbar","_oFilterInfoBarInvisibleText","_oColumnHeaderMenu","_oManagedObjectModel","_oDefaultType","_oInvisibleTitle"].concat((()=>ot.map(t=>"_o"+I(t)))()).forEach(t=>{this[t]?.destroy?.();delete this[t]});t.prototype.exit.apply(this,arguments)};et.prototype.addAction=function(e){if(e.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){e=new O(e.getId()+"-action",{action:e})}return t.prototype.addAggregation.apply(this,["actions",e])};et.prototype.onThemeChanged=function(){if(this._oExportButton){const t=g.ButtonType[L.get({name:"_sap_ui_mdc_Table_ExportButtonType"})];this._oExportButton.setType(t)}if(this._oToolbar){const t=q[L.get({name:"_sap_ui_mdc_Table_ToolbarDesign"})];this._oToolbar.setDesign(t)}if(!this.getHeaderStyle()){const t=$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})];this._oTitle?.setTitleStyle(t);this.getVariant()?.setTitleStyle(t)}};et.prototype._setSelectedContexts=function(t){this.getControlDelegate().setSelectedContexts(this,t)};et.prototype._updateVariantManagementStyle=function(){const t=this.getVariant();if(t){t.setShowAsText(this.getHeaderVisible());t.setHeaderLevel(this.getHeaderLevel());t.setTitleStyle(this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})])}};return et});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/TableDelegate", ["./AggregationBaseDelegate","sap/ui/mdc/mixin/delegate/FilterIntegrationDefault","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/util/loadModules","sap/m/plugins/PluginBase","sap/ui/model/Sorter","sap/ui/core/Lib","sap/ui/core/message/MessageType"],(e,t,n,r,o,i,s,l,a,u)=>{"use strict";const c=Object.assign({},e,t);c.updateBindingInfo=function(e,t){t.parameters={};t.sorter=[];if(e._oMessageFilter){t.filters=[e._oMessageFilter]}else{t.filters=this.getFilters(e)}const n=this.getGroupSorter(e);if(n){t.sorter.push(n)}const r=this.getSorters(e);t.sorter=t.sorter.concat(t.sorter.length===1?r.filter(e=>e.sPath!==t.sorter[0].sPath):r)};c.getGroupSorter=function(e){const t=e._getGroupedProperties()[0];if(!t||!e._isOfType(r.ResponsiveTable)){return undefined}const n=e._getSortedProperties().find(e=>e.name===t.name);const o=e.getPropertyHelper().getProperty(t.name).path;const i=n?n.descending:false;if(!e._mFormatGroupHeaderInfo||e._mFormatGroupHeaderInfo.propertyKey!==t.name){e._mFormatGroupHeaderInfo={propertyKey:t.name,formatter:function(n){return this.formatGroupHeader(e,n,t.name)}.bind(this)}}return new l(o,i,e._mFormatGroupHeaderInfo.formatter)};c.formatGroupHeader=function(e,t,n){const r=e.getPropertyHelper();const o=r.getProperty(n);const i=r.getProperty(o.text);const s=a.getResourceBundleFor("sap.ui.mdc");let l="table.ROW_GROUP_TITLE";const u=[o.label,t.getProperty(o.path,true)];if(i){l="table.ROW_GROUP_TITLE_FULL";u.push(t.getProperty(i.path,true))}return s.getText(l,u)};c.getSorters=function(e){const t=e._getSortedProperties();const n=e.getPropertyHelper();const r=[];t.forEach(e=>{if(n.hasProperty(e.name)){const t=n.getProperty(e.name).path;r.push(new l(t,e.descending))}});return r};c.updateBinding=function(e,t,n,r){this.rebind(e,t)};c.rebind=function(e,t){e._getType().bindRows(t)};c.getFilterDelegate=function(){return{addItem:function(e,t){return Promise.resolve(null)},addCondition:function(e,t,n){return Promise.resolve()},removeCondition:function(e,t,n){return Promise.resolve()}}};c.fetchExportCapabilities=function(e){return Promise.resolve({XLSX:{}})};c.fetchExpandAndCollapseConfiguration=function(e){return Promise.resolve({})};c.getSupportedFeatures=function(e){const t=[n.Column,n.Sort,n.Filter];if(e._isOfType(r.ResponsiveTable)){t.push(n.Group)}return{p13nModes:t,export:true}};c.validateState=function(t,n,r){if(r=="Filter"&&t._oMessageFilter){const e=a.getResourceBundleFor("sap.ui.mdc");return{validation:u.Information,message:e.getText("table.PERSONALIZATION_DIALOG_FILTER_MESSAGESTRIP")}}return e.validateState.apply(this,arguments)};c.initializeContent=function(e){return this.initializeSelection(e)};c.initializeSelection=function(e){if(e._isOfType(r.Table,true)){return p(e)}else if(e._isOfType(r.ResponsiveTable)){return d(e)}else{return Promise.resolve()}};function p(e){const t={Single:"Single",SingleMaster:"Single",Multi:"MultiToggle"};return i("sap/ui/table/plugins/MultiSelectionPlugin").then(n=>{const r=n[0];if(e.isDestroyed()){return Promise.reject("Destroyed")}e._oTable.addDependent(new r({limit:"{$sap.ui.mdc.Table#type>/selectionLimit}",enableNotification:true,showHeaderSelector:"{$sap.ui.mdc.Table#type>/showHeaderSelector}",selectionMode:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return t[e]}},enabled:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return e in t}},selectionChange:function(t){e._onSelectionChange({selectAll:t.getParameter("selectAll")})}}))})}function d(e){const t={Single:"SingleSelectLeft",SingleMaster:"SingleSelectMaster",Multi:"MultiSelect"};const n={Default:"SelectAll",ClearAll:"ClearAll"};e._oTable.bindProperty("mode",{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return t[e]}});e._oTable.bindProperty("multiSelectMode",{path:"$sap.ui.mdc.Table>/multiSelectMode",formatter:function(e){return n[e]||"SelectAll"}});e._oTable.attachSelectionChange(t=>{e._onSelectionChange({selectAll:t.getParameter("selectAll")})});return Promise.resolve()}c.setSelectedContexts=function(e,t){if(e._isOfType(r.ResponsiveTable)){const n=e.getSelectionMode();if(n===o.None||(n===o.Single||n===o.SingleMaster)&&t.length>1){throw Error("Unsupported operation: Cannot select the given number of contexts in the current selection mode")}const r=t.map(e=>e.getPath());e.clearSelection();e._oTable.setSelectedContextPaths(r);e._oTable.getItems().forEach(e=>{const t=e.getBindingContextPath();if(t&&r.indexOf(t)>-1){e.setSelected(true)}})}else{throw Error("Unsupported operation: Not supported for the current table type")}};c.getSelectedContexts=function(e){if(!e._oTable){return[]}if(e._isOfType(r.Table,true)){const t=s.getPlugin(e._oTable,"sap.ui.table.plugins.MultiSelectionPlugin");if(!t){return[]}return t.getSelectedIndices().map(t=>e._oTable.getContextByIndex(t),this)}if(e._isOfType(r.ResponsiveTable)){return e._oTable.getSelectedContexts(true)}return[]};c.clearSelection=function(e){if(!e._oTable){return}if(e._isOfType(r.Table,true)){const t=s.getPlugin(e._oTable,"sap.ui.table.plugins.SelectionPlugin");if(t){t.clearSelection()}}if(e._isOfType(r.ResponsiveTable)){e._oTable.removeSelections(true)}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ValueHelp", ["sap/ui/mdc/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/enums/ValueHelpPropagationReason","sap/ui/mdc/enums/RequestShowContainerReason","sap/ui/Device","sap/ui/mdc/enums/FieldDisplay"],(e,t,i,o,n,s,a,r,l,c,p)=>{"use strict";const u=e.extend("sap.ui.mdc.ValueHelp",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{}}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true},_config:{type:"object",defaultValue:{},visibility:"hidden"},_valid:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"}},aggregations:{dialog:{type:"sap.ui.mdc.valuehelp.base.IDialogContainer",multiple:false},typeahead:{type:"sap.ui.mdc.valuehelp.base.ITypeaheadContainer",multiple:false}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},disconnect:{},closed:{},open:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"}}},opened:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"},itemId:{type:"string"},items:{type:"int"}}},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},switchToValueHelp:{},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}},defaultProperty:"filterValue"}});u.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new a(P.bind(this));this._oObserver.observe(this,{aggregations:["typeahead","dialog"]});this.setBindingContext(null);this._oConditions={}};u.prototype.exit=function(){delete this._oConditions;this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver;if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}};u.prototype.invalidate=function(e){return};u.prototype.connect=function(e,t){const i=this.getTypeahead();const o=this.getDialog();if(this._oControl&&this._oControl!==e){this.close(true);this.setFilterValue("");this.setConditions([]);if(i){i.onConnectionChange()}if(o){o.onConnectionChange()}this.fireDisconnect()}this._oControl=e;this.setProperty("_config",t,true);S.call(this);if(i){D.call(this,i,!!this._oControl)}if(o){D.call(this,o,!!this._oControl)}this._getControlDelegatePromise().then(i=>{i.onControlConnect(this,e,t)});return this};u.prototype.getControl=function(){return this._oControl};u.prototype.getDomRef=function(){const e=this.getTypeahead();const t=this.getDialog();if((e?.isOpen()||e?.isOpening())&&!e?.isClosing()){return e.getDomRef()}else if((t?.isOpen()||t?.isOpening())&&!t?.isClosing()){return t.getDomRef()}};u.prototype.getAriaAttributes=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!i&&t&&t.getUseAsValueHelp()){i=t}const o=t&&t.isOpen();const n=i&&i.isOpen();const s=t&&t.getAriaAttributes(e);const a=i&&i.getAriaAttributes(e);let r;if(o){r=s.contentId}else if(n){r=a.contentId}const l=t&&s.ariaHasPopup||i&&a.ariaHasPopup;const c=t&&s.role||i&&a.role;const p=t&&s.roleDescription||i&&a.roleDescription;const u=!!i&&a.valueHelpEnabled;const h=t&&s.autocomplete||i&&a.autocomplete;return{contentId:r,ariaHasPopup:l,role:c,roleDescription:p,valueHelpEnabled:u,autocomplete:h}};u.prototype.retrieveDelegateContent=function(e,t){let i;if(!t){const i=e.getSelectedContent();t=i&&i.getId()}i=this._retrievePromise("delegateContent");const o=this.isOpen();if(!i||i&&o||i&&i.aggregation!==e.sParentAggregationName){const o=function(){return this._getControlDelegatePromise().then(i=>i.retrieveContent(this,e,t))}.bind(this);const n=i&&i.isPending();i=this._addPromise("delegateContent",n?i.getInternalPromise().then(o):o);i.aggregation=e.sParentAggregationName}return i.getInternalPromise()};u.prototype._getControlDelegatePromise=function(e){return this._retrievePromise("delegate",this.initControlDelegate.bind(this))};u.prototype.open=function(e){const t=e?this.getTypeahead():V.call(this);const i=e?this.getDialog():this.getTypeahead();if(i&&t!==i&&(i.isOpen()||i.isOpening())){i.close()}if(t&&!t.isOpen()&&!t.isOpening()){t.open(this.retrieveDelegateContent(t),e);this.fireOpen({container:t})}};function h(e){const t=e.getSource();this.retrieveDelegateContent(t,e.getParameter("contentId"))}function g(e){this.fireSwitchToValueHelp()}u.prototype.close=function(e){const t=this.getTypeahead();const i=this.getDialog();if(t&&t.isOpen()){t.close(e)}if(i&&i.isOpen()){i.close(e)}};u.prototype.toggleOpen=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!e&&!i&&t&&t.getUseAsValueHelp()){i=t}const o=t&&t.isOpen();const n=i&&i.isOpen();if(e&&o||!e&&n){this.close()}else if(e&&t||!e&&i){this.open(e)}};u.prototype.isOpen=function(){const e=this.getTypeahead();const t=this.getDialog();const i=e?.isOpen()||e?.isOpening();const o=t?.isOpen()||t?.isOpening();return i||o};u.prototype.skipOpening=function(){const e=this.getTypeahead();const t=this.getDialog();if(e&&e.isOpening()){e.close()}if(t&&t.isOpening()){t.close()}};u.prototype.isTypeaheadSupported=function(){const e=this.getTypeahead();if(e){return this.retrieveDelegateContent(e).then(()=>!!e&&e.isTypeaheadSupported())}else{return Promise.resolve(false)}};u.prototype.requestShowTypeahead=async function(e){const t=this.getTypeahead();if(t){return await this._requestShowContainer(t,e)}return false};u.prototype.requestShowValueHelp=async function(){const e=V.call(this);if(e){return await this._requestShowContainer(e,l.ValueHelpRequest)}return false};u.prototype._requestShowContainer=async function(e,t){const i=await this._getControlDelegatePromise();return i.requestShowContainer(this,e,t)};u.prototype.shouldOpenOnFocus=function(){const e=V.call(this,true);return this._getControlDelegatePromise().then(t=>e?e.shouldOpenOnFocus():Promise.resolve(false))};u.prototype.shouldOpenOnClick=function(){const e=V.call(this,true);return this._getControlDelegatePromise().then(t=>e?e.shouldOpenOnClick():Promise.resolve(false))};u.prototype.isFocusInHelp=function(){const e=V.call(this);return e&&e.isFocusInHelp()};u.prototype.removeVisualFocus=function(){const e=this.getTypeahead();if(e){e.removeVisualFocus()}};u.prototype.setVisualFocus=function(){const e=this.getTypeahead();if(e){e.setVisualFocus()}};u.prototype.navigate=function(e){const t=this.getTypeahead();if(t){const t=()=>{const t=this.getTypeahead();return t?.navigate(e)};const i=this._retrievePromise("navigate");const o=i&&!i.isSettled()&&i.getInternalPromise();this._addPromise("navigate",o?o.then(t):t)}};u.prototype.isNavigationEnabled=function(e){const t=this.getTypeahead();if(t){const i=this.getDialog();const o=t.isOpen();if(o||!i){return t.isNavigationEnabled(e)}}return false};u.prototype.getItemForValue=function(e){const t=this.getTypeahead();if(t){return this.retrieveDelegateContent(t).then(()=>{e.caseSensitive=e.hasOwnProperty("caseSensitive")?e.caseSensitive:false;const i=t.getItemForValue(e);return i})}else{return Promise.reject("No Typeahead")}};u.prototype.isValidationSupported=function(){const e=this.getTypeahead();return e&&e.isValidationSupported()};u.prototype.onControlChange=function(){if(this.isDestroyed()){return}d.call(this,r.ControlChange);S.call(this)};u.prototype.getIcon=function(){const e=this.getTypeahead();const t=this.getDialog();if(t){return t.getValueHelpIcon()}else if(e){return e.getValueHelpIcon()}};u.prototype.getMaxConditions=function(){const e=this.getProperty("_config");return e&&e.maxConditions||-1};u.prototype.getDisplay=function(){return this.getProperty("_config")?.display||p.Value};u.prototype.getDataType=function(){};function d(e,t){const i=this.bDelegateInitialized&&this.getControlDelegate();if(i){i.onConditionPropagation(this,e,t||this.getProperty("_config"))}}function f(e){const t=e.getParameter("condition");this.fireNavigated({condition:t,itemId:e.getParameter("itemId"),leaveFocus:e.getParameter("leaveFocus"),caseSensitive:e.getParameter("caseSensitive")})}function y(e){this.fireVisualFocusSet()}function m(e){const t=e.getParameter("condition");const i=e.getParameter("filterValue");const o=e.getParameter("itemId");const n=e.getParameter("items");const s=e.getParameter("caseSensitive");this.fireTypeaheadSuggested({condition:t,filterValue:i,itemId:o,items:n,caseSensitive:s})}function C(e){const t=e.getParameter("type");const i=e.getParameter("conditions")||[];const o=this.getControlDelegate();const s=(e,t)=>t.findIndex(t=>o.compareConditions(this,e,t));let a;const r=this.getMaxConditions()===1;if(r){a=t===n.Remove?[]:i.slice(0,1)}if(t===n.Set){a=[].concat(r?i.slice(0,1):i)}if(t===n.Add){if(r){a=i.slice(0,1)}else{a=this.getConditions();for(let e=0;e<i.length;e++){if(s(i[e],a)===-1){a.push(i[e])}}}}if(t===n.Remove){if(r){a=[]}else{a=this.getConditions();for(let e=0;e<i.length;e++){const t=s(i[e],a);if(t!==-1){a.splice(t,1)}}}}if(a){this.setProperty("conditions",a,true)}}function v(e){if(this.getProperty("_valid")){const t=this.getMaxConditions()===1;const n=e.getParameter("close");const s=typeof n!=="undefined"?n:t;let a=this.getConditions();const l=!t&&!e.getSource().isMultiSelect();if(s){this.close()}a=i._removeEmptyConditions(a);a=i._removeInitialFlags(a);o.updateConditionsValues(a);this.fireSelect({conditions:a,add:l,close:s});d.call(this,r.Select)}}function b(e){this.close()}function O(e){this.fireOpened({container:e.getSource(),itemId:e.getParameter("itemId"),items:e.getParameter("items")})}function _(e){this._removePromise("delegateContent");this._removePromise("navigate");if(!this.isOpen()){this.fireClosed()}}function P(e){if(["typeahead","dialog"].indexOf(e.name)!==-1){const t=e.child;const i=e.mutation==="insert";if(this._oControl||!i){D.call(this,t,i)}if(i){if(!this._oManagedObjectModel){this._oManagedObjectModel=new s(this)}t.setModel(this._oManagedObjectModel,"$valueHelp")}}}function D(e,t){if(e._bAttached===t){return}const i=t?e.attachEvent.bind(e):e.detachEvent.bind(e);i("select",C,this);i("requestDelegateContent",h,this);i("confirm",v,this);i("cancel",b,this);i("opened",O,this);i("closed",_,this);if(e.attachRequestSwitchToDialog){i("requestSwitchToDialog",g,this)}if(e.attachNavigated){i("navigated",f,this)}if(e.attachVisualFocusSet){i("visualFocusSet",y,this)}if(e.attachTypeaheadSuggested){i("typeaheadSuggested",m,this)}e._bAttached=t}function S(){const e=this._oControl?this._oControl.getBindingContext():null;this.setBindingContext(e)}function V(e){const t=this.getTypeahead();const i=!!t&&t.getUseAsValueHelp();const o=this.getDialog();if(e){return(i||o||c.system.phone)&&t||o}else{return o||i&&t}}u.prototype._getFieldGroupIds=function(){const t=this.getControl();if(t){return t.getFieldGroupIds()}else{return e.prototype._getFieldGroupIds.apply(this,arguments)}};u.prototype.setHighlightId=function(e){this.getTypeahead()?.setHighlightId(e)};u.prototype.clone=function(t,i){const o=this.getTypeahead();const n=o?._bAttached;const s=this.getDialog();const a=s?._bAttached;if(n){D.call(this,o,false)}if(a){D.call(this,s,false)}const r=e.prototype.clone.apply(this,arguments);if(n){D.call(this,o,true)}if(a){D.call(this,s,true)}return r};t.call(u.prototype);return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ValueHelpDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/model/FilterType","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/Condition","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/Device","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/RequestShowContainerReason","sap/ui/mdc/util/loadModules"],(e,t,i,n,o,s,r,a,u,l,c,d,p,f,g)=>{"use strict";const h=function(e,t,i,n){const o=n.getConditions();const s=u.apply(e,t,(e,t)=>e&&e.getProperty(t));if(n.isSingleSelect()&&o.length>0){return s[0]}else{return s.find(e=>!this.findConditionsForContext(i,n,e,o).length)}};const C=Object.assign({},e);C.retrieveContent=function(e,t,i){return Promise.resolve()};C.isSearchSupported=function(e,t,i){return false};C.showTypeahead=function(e,t){if(d.system.phone){return true}if(!t||t.isA("sap.ui.mdc.valuehelp.base.FilterableListContent")&&!t.getFilterValue()){return false}else if(t.isA("sap.ui.mdc.valuehelp.base.ListContent")){const e=t.getListBinding();const i=e&&e.getCurrentContexts().length;return i>0}return true};C.updateBindingInfo=function(e,t,i){i.parameters={};i.filters=this.getFilters(e,t)};C.getFilters=function(e,t){const i=t.getActiveFilterBar();const r=i?i.getConditions():t._oInitialFilterConditions||{};if(!t.isPropertyInitial("filterFields")){const e=t.getFilterFields();const a=t.getSearch();if(!i&&a&&e&&e!=="$search"){const t=s.createCondition(o.Contains,[a],undefined,undefined,n.NotValidated);r[e]=[t]}}const a=r&&this.getTypesForConditions(e,t,r);const u=r&&l.createFilters(r,a,undefined,t.getCaseSensitive());return u?[u]:[]};C.updateBinding=function(e,i,n,o){i.filter(n.filters,t.Application);if(i.isSuspended()){i.resume()}};C.adjustSearch=function(e,t,i){return i};C.executeFilter=function(e,t,i){return Promise.resolve(t)};C.checkListBindingPending=function(e,t,i){if(!t||t.isSuspended()){return false}return Promise.resolve(t.getContexts(0,i)).then(e=>e.length===0)};C.onConditionPropagation=function(e,t,i){};C.getInitialFilterConditions=function(e,t,i){const n={};return n};C.findConditionsForContext=function(e,t,i,n){const o=t.getItemFromContext(i);const s=o&&t.createCondition(o.key,o.description,o.payload);return n.filter(t=>this.compareConditions(e,s,t))};C.compareConditions=function(e,t,i){if(t.operator===i.operator){if(t.validated===n.Validated&&t.validated===i.validated){return t.values[0]===i.values[0]}return c.getOperator(t.operator)?.compareConditions(t,i)}return false};C.modifySelectionBehaviour=function(e,t,i){return i};C.createConditionPayload=function(e,t,i,n){return undefined};C.getTypesForConditions=function(e,t,n){const o={};const s=t&&t.getListBindingInfo();if(s&&s.template){const e=this.getTypeMap();s.template.mAggregations.cells.forEach(t=>{Object.values(t.mBindingInfos).forEach(t=>{t.parts.forEach(t=>{o[t.path]={type:t.type||null,baseType:t.type?e.getBaseTypeForType(t.type):i.String}})})},{})}return o};C.getFilterConditions=function(e,t,i){if(this.getInitialFilterConditions){return this.getInitialFilterConditions(e,t,i&&i.control||t&&t.getControl())}return{}};C.getFirstMatch=function(e,t,i){let n;const o=t.getListBinding(i)?.getCurrentContexts();const s=i.value;if(s&&o?.length){const u=i.hasOwnProperty("caseSensitive")?i.caseSensitive:t.getCaseSensitive();const l=t.getKeyPath();const c=i.checkDescription&&t.getDescriptionPath();let d;switch(e.getDisplay()){case p.Description:d=[c];break;case p.DescriptionValue:d=[c,l];break;case p.ValueDescription:d=[l,c];break;default:d=[l];break}d=d.filter(e=>!!e);for(const i of d){const l=[new r({path:i,operator:a.EQ,value1:s,caseSensitive:u}),new r({path:i,operator:a.StartsWith,value1:s,caseSensitive:u})];for(const i of l){n=h.call(this,o,i,e,t);if(n){return n}}}}return n};C.isFilteringCaseSensitive=function(e,t){return t.getCaseSensitive()};C.requestShowContainer=async function(e,t,i){if(i===f.Tap){return!!await(this.shouldOpenOnClick?.(e,t))}if(i===f.Typing){await e.retrieveDelegateContent(t);return!!await t.isTypeaheadSupported()}if(i===f.Filter){const[i]=t?.getContent()||[];return!!await(this.showTypeahead?.(e,i))}if(i===f.Focus){return!!await(this.shouldOpenOnFocus?.(e,t))}if(i===f.Navigate){await e.retrieveDelegateContent(t);return!!await t.shouldOpenOnNavigate()}if(i===f.ValueHelpRequest){return t.isDialog()}return false};C.shouldOpenOnFocus=function(e,t){let i=false;if(t.isA("sap.ui.mdc.valuehelp.Popover")){i=t.getOpensOnFocus()}return Promise.resolve(i)};C.shouldOpenOnClick=function(e,t){let i=false;if(t.isA("sap.ui.mdc.valuehelp.Popover")){if(d.system.phone&&(!t.isSingleSelect()||!t.isDialog())){i=true}else{let e=true;if(!t.isPropertyInitial("opensOnClick")){e=false;i=t.getOpensOnClick()}if(e){const e=t._getContent();i=!!e&&e.shouldOpenOnClick()}}}return Promise.resolve(i)};C.onControlConnect=function(e,t,i){};return C});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/actiontoolbar/ActionToolbarAction", ["sap/ui/core/Control","sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer","sap/ui/mdc/enums/ActionToolbarActionAlignment","sap/ui/base/ManagedObjectObserver"],(t,e,o,n)=>{"use strict";const i=t.extend("sap.ui.mdc.actiontoolbar.ActionToolbarAction",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbarAction.designtime",interfaces:["sap.m.IOverflowToolbarContent"],properties:{layoutInformation:{type:"object",defaultValue:{aggregationName:"end",alignment:o.Begin}},label:{type:"string"}},defaultAggregation:"action",aggregations:{action:{type:"sap.ui.core.Control",multiple:false}}},renderer:e});i.prototype.init=function(){this._oObserver=new n(this.observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["action"]})};i.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};i.prototype.observeChanges=function(t){if(t.name==="action"){const e=t.child;if(t.mutation==="insert"){this._oObserver.observe(e,{properties:["visible"]});r(this.getParent())}if(t.mutation==="remove"){this._oObserver.unobserve(e);r(this.getParent())}}if(t.name==="visible"){r(this.getParent())}};i.prototype.getDomRef=function(){return this.getAction()&&this.getAction().getDomRef()};i.prototype.getLayoutData=function(){const e=t.prototype.getLayoutData.apply(this);return e?e:this.getAction()&&this.getAction().getLayoutData()};i.prototype.getOverflowToolbarConfig=function(){const t=this.getAction()&&this.getAction().getOverflowToolbarConfig?this.getAction().getOverflowToolbarConfig():{canOverflow:true};t.onBeforeEnterOverflow=this._getOnBeforeEnterOverflow(t);t.onAfterExitOverflow=this._getOnAfterExitOverflow(t);return t};i.prototype._getOnBeforeEnterOverflow=function(t){const e=t.onBeforeEnterOverflow;return function(t){if(e){e(t.getAction())}r(t.getParent())}};i.prototype._getOnAfterExitOverflow=function(t){const e=t.onAfterExitOverflow;return function(t){if(e){e(t.getAction())}r(t.getParent())}};i.prototype.getLabel=function(){const t=this.getProperty("label");if(t){return t}const e=this.getAction();return e&&e.getText?e.getText():this.getId()};function r(t){if(t?._updateSeparators){t._updateSeparators()}}return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer", [],()=>{"use strict";const e={apiVersion:2};e.render=function(e,s){const r=s.getAction();if(r){if(s.hasStyleClass("sapMBarChild")){r.addStyleClass("sapMBarChild")}e.renderControl(r)}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartImplementationContainer", ["sap/ui/core/Control","./ChartImplementationContainerRenderer","sap/ui/core/Element","sap/ui/thirdparty/jquery"],(t,e,i,jQuery)=>{"use strict";const o=t.extend("sap.ui.mdc.chart.ChartImplementationContainer",{metadata:{library:"sap.ui.mdc",interfaces:[],properties:{showNoDataStruct:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},noDataContent:{type:"sap.ui.core.Control",multiple:false}},associations:{chartNoDataContent:{type:"sap.ui.core.Control",multiple:false}},events:{}},renderer:e});o.prototype.init=function(){this._updateVisibilities()};o.prototype.setShowNoDataStruct=function(t){this.setProperty("showNoDataStruct",t);this._updateVisibilities();return this};o.prototype.setContent=function(t){this.setAggregation("content",t);this._updateVisibilities();return this};o.prototype.setNoDataContent=function(t){this.setAggregation("noDataContent",t);this._updateVisibilities();return this};o.prototype.setChartNoDataContent=function(t){this.setAssociation("chartNoDataContent",t);this._updateVisibilities();return this};o.prototype.showOverlay=function(t){const e=this.$();let i=e.find(".sapUiMdcChartOverlay");if(t&&i.length===0){i=jQuery("<div>").addClass("sapUiOverlay sapUiMdcChartOverlay").css("z-index","1");e.append(i)}else if(!t){i.remove()}};o.prototype._getChartNoDataForRenderer=function(){return i.getElementById(this.getChartNoDataContent())};o.prototype._updateVisibilities=function(){const t=this.getShowNoDataStruct();if(this.getContent()){this.getContent().setVisible(!t)}if(this.getChartNoDataContent()){if(this.getNoDataContent()){this.getNoDataContent().setVisible(false)}i.getElementById(this.getChartNoDataContent()).setVisible(t)}else if(this.getNoDataContent()){this.getNoDataContent().setVisible(t)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartImplementationContainerRenderer", [],()=>{"use strict";const e={apiVersion:2};e.CSS_CLASS="sapUiMDCChart";e.render=function(e,t){e.openStart("div",t);e.style("height","100%");e.style("width","100%");e.style("min-height","200px");e.openEnd();e.renderControl(t.getContent());e.renderControl(t.getNoDataContent());e.renderControl(t._getChartNoDataForRenderer());e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ChartSelectionDetails", ["sap/m/SelectionDetails","sap/m/SelectionDetailsItem","sap/m/SelectionDetailsItemLine","sap/m/SelectionDetailsRenderer","sap/m/List","sap/m/StandardListItem","sap/m/library","sap/ui/core/Lib"],(t,e,a,i,n,s,o,r)=>{"use strict";const{ListMode:l,ListType:c}=o;const p=r.getResourceBundleFor("sap.ui.mdc");const g=t.extend("sap.ui.mdc.chart.ChartSelectionDetails",{metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{enableNavCallback:{type:"function"},fetchFieldInfosCallback:{type:"function"}},aggregations:{},associations:{},events:{}},renderer:i});g.prototype.init=function(){t.prototype.init.apply(this,arguments);this.registerSelectionDetailsItemFactory({},this._selectionDetailsItemFactory.bind(this));this.attachNavigate(this._navigate.bind(this))};g.prototype._selectionDetailsItemFactory=function(t,i,n){const s=this.getEnableNavCallback();const o=[];const r=function(t){if(t){return t instanceof Object?t:t.toString()}else{return t}};for(let e=0;e<t.length;e++){o.push(new a({label:t[e].label,value:r(t[e].value),unit:t[e].unit}))}return new e({enableNav:s?.(i,n)??false,lines:o}).setBindingContext(n)};g.prototype._navigate=function(t){if(t.getParameter("direction")==="back"){t.getParameter("content").destroy()}else{this._navigateToDetails(t)}};g.prototype._navigateToDetails=async t=>{const e=t.getSource();const a=e.getFetchFieldInfosCallback();if(!a){throw new Error("sap.ui.mdc.chart.ChartSelectionDetails._navigateToDetails: 'fetchFieldInfosCallback' is not set! This is required to determine navigation.")}const i=t.getParameter("item");const n=i.getBindingContext();let s,o="";const r=await a(e,n);if(Object.keys(r).length===0){throw new Error("sap.ui.mdc.chart.ChartSelectionDetails._navigateToDetails: 'fetchFieldInfosCallback' returned an empty map! Could not determine navigation.")}if(Object.keys(r).length===1){s=await Object.values(r)[0].getContent(()=>e)}else{s=e._getDetailsList(e,r,n);o=p.getText("chart.SELECTION_DETAILS_BTN")}e.navTo(o,s)};g.prototype._getDetailsList=(t,e,a)=>{const i=Object.keys(e).map(t=>{const i=e[t];const n=new s({title:t,type:c.Navigation});n.data("fieldInfo",i);n.setBindingContext(a);return n});return new n({mode:l.SingleSelectMaster,rememberSelections:false,items:i,itemPress:async e=>{const a=e.getParameter("listItem");if(a){const e=a.data("fieldInfo");const i=await e.getContent(()=>t);t.navTo(a.getTitle(),i)}}})};g.prototype.setModal=function(t){this.setPopoverModal(t)};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/DrillBreadcrumbs", ["sap/m/Breadcrumbs","sap/m/Link"],(t,e)=>{"use strict";const i=t.extend("sap.ui.mdc.chart.DrillBreadcrumbs",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{},associations:{},events:{linkPressed:{parameters:{key:{type:"string"},index:{type:"int"}}}}},renderer:{apiVersion:2}});i.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCChartBreadcrumbs")};i.prototype.update=function(t){const e=[];this.setVisible(t?.length>0);if(t?.length>0){t.reverse();t.forEach(function(t,i){if(i==0){this.setCurrentLocationText(t.text)}else{e.push(this._createLink(t.key,t.text))}},this)}else{this.setCurrentLocationText("")}const i=this.getLinks();e.reverse();let s=false;if(i.length!==e.length){s=true}else{for(let t=0;t<e.length;t++){if(e[t].getText()!=i[t].getText()){s=true;break}}}if(s){if(this.getLinks()){this.destroyLinks()}for(let t=0;t<e.length;t++){this.addLink(e[t])}}return this};i.prototype.onAfterRendering=function(e){t.prototype.onAfterRendering.apply(this,arguments);if(this._bSetFocus){delete this._bSetFocus;const t=this.getLinks()[0]||this;t.focus()}};i.prototype._createLink=function(t,i){const s=new e({text:i,press:function(t){const e=t.getSource();const i=this.indexOfLink(e);this.fireLinkPressed({key:e.data().key,index:i});this._bSetFocus=true}.bind(this)});s.data("key",t);return s};return i});
/*
 * !OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/Item", ["sap/ui/core/Element","sap/base/Log"],(t,e)=>{"use strict";const r=t.extend("sap.ui.mdc.chart.Item",{metadata:{abstract:false,library:"sap.ui.mdc",properties:{name:{type:"string"},propertyKey:{type:"string"},label:{type:"string"},type:{type:"string"},role:{type:"string"}}}});r.prototype.getPropertyKey=function(){const t=this.getProperty("propertyKey");return t||this.getName()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/PropertyHelper", ["../util/PropertyHelper","sap/ui/core/Lib"],(t,e)=>{"use strict";const r=t.extend("sap.ui.mdc.chart.PropertyHelper",{constructor:function(e,r){t.call(this,e,r,{filterable:true,sortable:true,propertyInfos:true,groupable:{type:"boolean"},aggregatable:{type:"boolean"},propertyPath:{type:"string"},aggregationMethod:{type:"string"},role:{type:"string"},datapoint:{type:"object"},criticality:{type:"object"},textProperty:{type:"string"},textFormatter:{type:"object"},unitPath:{type:"string"},timeUnitType:{type:"string"}})}});r.prototype.prepareProperty=function(e,r){if(!e.path&&e.propertyPath){e.path=e.propertyPath}if(!e.typeConfig&&e.dataType){const t=e.formatOptions?e.formatOptions:null;const r=e.constraints?e.constraints:{};e.typeConfig=this.getParent().getTypeMap().getTypeConfig(e.dataType,t,r)}t.prototype.prepareProperty.apply(this,arguments);e.isAggregatable=function(){if(e){return e.isComplex()?false:e.aggregatable}}};r.prototype.getAllAggregatableProperties=function(){return this.getProperties().filter(t=>t.isAggregatable())};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/SelectionButton", ["sap/m/OverflowToolbarButton","sap/m/Button","sap/m/ButtonRenderer","sap/m/library","sap/m/IllustratedMessage","sap/ui/core/Lib","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/json/JSONModel","sap/ui/Device","sap/ui/mdc/chart/SelectionButtonDisplay"],(e,t,o,i,s,n,r,a,p,l,c)=>{"use strict";const{PlacementType:d}=i;let h,u,g,m,y,f,b,v;const S=e.extend("sap.ui.mdc.chart.SelectionButton",{metadata:{library:"sap.ui.mdc",properties:{display:{type:"sap.ui.mdc.enums.SelectionButtonDisplay",defaultValue:c.Icon},canOverflow:{type:"boolean",defaultValue:true},selectedItemKey:{type:"string"},title:{type:"string"},searchPlaceholder:{type:"string"},searchEnabled:{type:"boolean"},sortEnabled:{type:"boolean",defaultValue:false},sorted:{type:"string",defaultValue:"none"},noDataTitle:{type:"string"},noDataDescription:{type:"string"},noDataType:{type:"string"}},aggregations:{items:{type:"sap.ui.mdc.chart.SelectionButtonItem",multiple:true}},associations:{},events:{itemSelected:{parameters:{item:{type:"sap.ui.mdc.chart.SelectionButtonItem"}}},beforeOpen:{}}},renderer:o});S.prototype.init=function(){e.prototype.init.apply(this,arguments);this.attachPress(this.openPopover.bind(this))};S.prototype.setSearchEnabled=function(e){this.setProperty("searchEnabled",e);this._updateHeader();return this};S.prototype.setSortEnabled=function(e){this.setProperty("sortEnabled",e);this._updateHeader();return this};S.prototype.openPopover=function(e){if(!this.oReadyPromise){this.oReadyPromise=new Promise(e=>{if(h){e(true)}else{sap.ui.require(["sap/m/ResponsivePopover","sap/m/List","sap/m/SearchField","sap/m/ToggleButton","sap/m/Bar","sap/m/StandardListItem","sap/ui/core/InvisibleText"],(t,o,i,s,r,a,p)=>{h=t;u=o;g=i;m=s;y=r;f=a;b=p;if(!v){n.load({name:"sap.ui.mdc"}).then(()=>{v=n.getResourceBundleFor("sap.ui.mdc");e(true)})}else{e(true)}})}})}this.oReadyPromise.then(()=>{if(!this.oPopover||!this.oPopover?.isOpen()){this.fireBeforeOpen();if(this.getItems().length===0){return}this._openPopover()}else if(this.oPopover?.isOpen()){this.oPopover.close()}})};S.prototype._openPopover=function(){if(!this.oPopover){this.oPopover=this._createPopover();this.oPopover.attachAfterOpen(function(){const e=this.oPopover.getContent()[1];const t=e.getItems().filter(e=>e.getSelected())[0];t?.focus()}.bind(this))}this._createModel();this.oPopover.openBy(this)};S.prototype._createPopover=function(){const e=new f({title:"{$items>text}",icon:"{$items>icon}",selected:"{$items>selected}"});let t=null;if(this.getSorted()!=="none"){t=new a({path:"text",descending:this.getSorted()==="descending"})}const o=new u({mode:"SingleSelectMaster",noData:new s({title:this.getNoDataTitle(),description:this.getNoDataDescription(),illustrationType:this.getNoDataType()}),items:{path:"$items>/AvailableItems",sorter:t,template:e,templateShareable:false},selectionChange:function(e){if(e&&e.mParameters&&e.mParameters.listItem){const t=e.mParameters.listItem.getBinding("title");if(t){const e=t.getContext();if(e){const t=e.getObject();if(t&&t.key){this.fireItemSelected({item:t});this.setSelectedItemKey(t.key)}}}}r.close()}.bind(this)});const i=new g({placeholder:this.getSearchPlaceholder(),liveChange:function(e){this._triggerSearch(e,o)}.bind(this)});const n=new m({icon:"sap-icon://sort",press:function(e){this._triggerSort(e,o)}.bind(this)});const r=new h({id:this.getId()+"-btnSelectionButtonPopover",placement:d.VerticalPreferredBottom,contentWidth:"25rem"});r.addStyleClass("sapUiMDCSelectionButton");const p=new y({contentMiddle:[i,n]});if(!l.system.phone){r.setSubHeader(p)}else{r.addContent(p)}if(l.system.desktop){const e=new b({text:this.getTitle()});r.setShowHeader(false);r.addContent(e);r.addAriaLabelledBy(e)}else{r.setTitle(this.getTitle())}r.addContent(o);this._updateHeader(r);return r};S.prototype._updateHeader=function(e){e=e||this.oPopover;let t=e?.getSubHeader();if(!t&&l.system.phone){t=e?.getContent()}if(!t){return}const[o,i]=t.getContentMiddle();o.setVisible(this.getSearchEnabled());o.setValue("");i.setVisible(this.getSortEnabled());t.setVisible(this.getSearchEnabled()||this.getSortEnabled())};S.prototype._createModel=function(){const e=new p;e.setSizeLimit(1e3);const t=this.getItems()||[];const o=this.getSelectedItemKey()||"";const i=[];t.forEach(e=>{i.push({key:e.getKey(),text:e.getText(),tooltip:e.getTooltip()||e.getText(),icon:e.getIcon(),selected:e.getKey()===o})});e.setProperty("/AvailableItems",i);this.oPopover.setModel(e,"$items")};S.prototype._triggerSearch=function(e,t){const o=e.getParameter("newValue");let i=[];if(o){i=new r("text","Contains",o)}t.getBinding("items").filter(i)};S.prototype._triggerSort=function(e,t){this._updateSort(t,e.getSource().getPressed())};S.prototype._updateSort=function(e,t){const o=new a({path:"text",descending:t});const i=e.getBinding("items");if(i){i.sort(o);return}};S.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oPopover){this.oPopover.destroy();this.oPopover=null}if(this._oObserver){this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver}};S.prototype._getAppliedIcon=function(){if(this._bInOverflow||this.getDisplay()===c.Icon||this.getDisplay()===c.Both){return this.getIcon()||this._sTypeIconURI}return undefined};S.prototype._getText=function(){if(this._bInOverflow||this.getDisplay()===c.Text||this.getDisplay()===c.Both){return t.prototype._getText.call(this)}return""};S.prototype.getOverflowToolbarConfig=function(){const t=e.prototype.getOverflowToolbarConfig.apply(this);t.canOverflow=this.getCanOverflow();return t};return S});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/SelectionButtonDisplay", ["sap/ui/base/DataType"],e=>{"use strict";const t={Icon:"Icon",Text:"Text",Both:"Both"};e.registerEnum("sap.ui.mdc.enums.SelectionButtonDisplay",t);return t},true);
/*
 * !OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/SelectionButtonItem", ["sap/ui/core/Element"],t=>{"use strict";const e=t.extend("sap.ui.mdc.chart.SelectionButtonItem",{metadata:{abstract:false,library:"sap.ui.mdc",properties:{key:{type:"string"},tooltip:{type:"string"},text:{type:"string"},icon:{type:"string",defaultValue:""}}}});return e});
/*
 * !OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/SelectionDetailsActions", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.chart.SelectionDetailsActions",{metadata:{library:"sap.ui.mdc",aggregations:{detailsItemActions:{type:"sap.ui.core.Item",multiple:true},detailsActions:{type:"sap.ui.core.Item",multiple:true},actionGroups:{type:"sap.ui.core.Item",multiple:true}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/ToolbarControlFactory", ["sap/ui/core/Lib","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/m/Title","sap/m/IllustratedMessageType","sap/ui/mdc/chart/SelectionButton","sap/ui/mdc/chart/SelectionButtonDisplay","sap/ui/mdc/chart/DrillBreadcrumbs","./ChartSelectionDetails","sap/ui/core/InvisibleText","sap/m/OverflowToolbarLayoutData","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/base/util/merge"],(t,e,n,a,o,c,r,i,s,l,T,u,p,d,O)=>{"use strict";const h=u.aria.HasPopup;const A={};const g=t.getResourceBundleFor("sap.ui.mdc");A.createDrillBreadcrumbs=function(t,e){e=O({},e);const n=new i(t+"--breadcrumbs",e);return n};A.createTitle=function(t,e,n){const o=e.header;n._oInvTitle=new l(t+"-invTitle",{text:o});n._oInvTitle.toStatic();n.addAriaLabelledBy(n._oInvTitle);const c=new a(t+"-title",{text:o,level:e.headerLevel,titleStyle:e.headerStyle,visible:e.headerVisible});return c};A.createSelectionDetailsBtn=function(t,e){const n=e.getSelectionDetailsActions;delete e.getSelectionDetailsActions;const a=new s(t+"-selectionDetails",e);a.attachBeforeOpen(t=>{const e=t.getSource();const a=n();let o;if(a){const t=e.getItems();t.forEach(t=>{const e=a?.getDetailsItemActions()||[];e.forEach(e=>{o=e.clone();t.addAction(o)})});const n=a?.getDetailsActions()||[];e.removeAllActions();n.forEach(t=>{o=t.clone();e.addAction(o)});const c=a?.getActionGroups()||[];e.removeAllActionGroups();c.forEach(t=>{o=t.clone();e.addActionGroup(o)})}});return a};A.createDrillDownBtn=function(t,e){e=O({display:r.Text,text:g.getText("chart.CHART_DRILLDOWN_TITLE"),title:g.getText("chart.CHART_DRILLDOWN_TITLE"),icon:"sap-icon://drill-down",noDataTitle:g.getText("chart.NO_DRILLABLE_DIMENSION"),noDataDescription:g.getText("chart.NO_DRILLABLE_DIMENSION_DESC"),noDataType:o.NoChartData,searchPlaceholder:g.getText("chart.CHART_DRILLDOWN_SEARCH"),searchEnabled:true,sortEnabled:false,sorted:"ascending",type:"Transparent",ariaHasPopup:h.Dialog,layoutData:new T({closeOverflowOnInteraction:false})},e);const n=new c(t+"-drillDown",e);return n};A.createLegendBtn=function(t,e){e=O({type:"Transparent",text:g.getText("chart.LEGENDBTN_TEXT"),tooltip:g.getText("chart.LEGENDBTN_TOOLTIP"),icon:"sap-icon://legend"},e);const a=new n(t+"btnLegend",e);return a};A.createZoomInBtn=function(t,n){n=O({icon:"sap-icon://zoom-in",tooltip:g.getText("chart.TOOLBAR_ZOOM_IN"),text:g.getText("chart.TOOLBAR_ZOOM_IN")},n);const a=new e(t+"btnZoomIn",n);return a};A.createZoomOutBtn=function(t,n){n=O({icon:"sap-icon://zoom-out",tooltip:g.getText("chart.TOOLBAR_ZOOM_OUT"),text:g.getText("chart.TOOLBAR_ZOOM_OUT")},n);const a=new e(t+"btnZoomOut",n);return a};A.createSettingsBtn=function(t,n){n=O({icon:"sap-icon://action-settings",tooltip:g.getText("chart.SETTINGS"),text:g.getText("chart.SETTINGS")},n);const a=new e(t+"-chart_settings",n);d.addConfig(a,{addAccessibilityLabel:true,message:g.getText(p.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT")},this);return a};A.createChartTypeBtn=function(t,e){e=O({text:g.getText("chart.CHART_TYPELIST_TEXT"),title:g.getText("chart.CHART_TYPELIST_TEXT"),noDataTitle:g.getText("chart.NO_CHART_TYPES_AVAILABLE"),noDataDescription:g.getText("chart.NO_CHART_TYPES_AVAILABLE_ACTION"),noDataType:o.AddDimensions,searchPlaceholder:g.getText("chart.CHART_TYPE_SEARCH"),searchEnabled:true,sortEnabled:false,type:"Transparent",ariaHasPopup:h.ListBox,layoutData:new T({closeOverflowOnInteraction:false})},e);const n=new c(t+"-btnChartType",e);return n};return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/chart/Util", ["sap/ui/core/Lib","sap/ui/mdc/enums/ChartItemRoleType"],(e,t)=>{"use strict";const a={};a.getLayoutOptionsForType=function(e){switch(e.toLowerCase()){case"dimension":case"groupable":return[{key:t.category,text:a.getLayoutOptionTextForTypeAndRole(e,t.category)},{key:t.category2,text:a.getLayoutOptionTextForTypeAndRole(e,t.category2)},{key:t.series,text:a.getLayoutOptionTextForTypeAndRole(e,t.series)}];case"measure":case"aggregatable":return[{key:t.axis1,text:a.getLayoutOptionTextForTypeAndRole(e,t.axis1)},{key:t.axis2,text:a.getLayoutOptionTextForTypeAndRole(e,t.axis2)},{key:t.axis3,text:a.getLayoutOptionTextForTypeAndRole(e,t.axis3)}];default:break}return[]};a.getLayoutOptionTextForTypeAndRole=function(a,r){const o=e.getResourceBundleFor("sap.ui.mdc");switch(a.toLowerCase()){case"dimension":case"groupable":switch(r){case t.category:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY");case t.category2:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2");case t.series:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES");default:return undefined}case"measure":case"aggregatable":switch(r){case t.axis1:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1");case t.axis2:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2");case t.axis3:return o.getText("chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3");default:return undefined}default:return undefined}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/Condition", ["sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName"],(n,t)=>{"use strict";const e=function(n){return JSON.stringify(Object.assign({},n,{isEmpty:undefined}),(n,t)=>t===undefined?"[undefined]":t)};const i={createItemCondition:function(e,i,o,r,a){let s=n.NotValidated;const u=[e,i];if(i===null||i===undefined){u.pop()}else{s=n.Validated}return this.createCondition(t.EQ,u,o,r,s,a)},createCondition:function(n,t,e,i,o,r){const a={operator:n,values:t,isEmpty:null,validated:o};if(e){a.inParameters=e}if(i){a.outParameters=i}if(r){a.payload=r}return a},compareConditions:function(n,t){const i=e(n);const o=e(t);return i===o},_removeEmptyConditions:function(n){for(let t=n.length-1;t>-1;t--){if(n[t].isEmpty){n.splice(parseInt(t),1)}}return n},_removeInitialFlags:function(n){for(let t=n.length-1;t>-1;t--){if(n[t].isInitial){delete n[t].isInitial}}return n}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionConverter", ["sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/util/merge"],(e,t,a,n,r)=>{"use strict";const o={toString:function(t,a,o){const u=n.getOperator(t.operator);const c=a.typeInstance?a.typeInstance:a;const l=s(t.values,i(c,u),u,o);let p;let d;let f;if(t.inParameters){p=r({},t.inParameters)}if(t.outParameters){d=r({},t.outParameters)}if(t.payload){f=r({},t.payload)}const y=e.createCondition(t.operator,l,p,d,t.validated,f);return y},toType:function(a,o,s){const c=n.getOperator(a.operator);const l=o.typeInstance?o.typeInstance:o;const p=u(a.values,i(l,c),s);let d;let f;let y;if(a.inParameters){d=r({},a.inParameters)}if(a.outParameters){f=r({},a.outParameters)}if(a.payload){y=r({},a.payload)}const m=e.createCondition(a.operator,p,d,f,a.validated,y);if(m.validated!==t.Validated&&c.validateInput){c.checkValidated(m)}return m}};function i(e,t){if(t&&t.valueTypes[0]&&(t.valueTypes[0]!==a.Self&&t.valueTypes[0]!==a.Static)){return t._createLocalType(t.valueTypes[0],e)}return e}function s(e,t,n,r){const o=[];for(let i=0;i<e.length;i++){if(!n||n.valueTypes[i]&&n.valueTypes[i]!==a.Static){const a=e[i];o.push(r.externalizeValue(a,t))}}return o}function u(e,t,a){const n=[];for(const r of e){n.push(a.internalizeValue(r,t))}return n}return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionModel", ["sap/ui/mdc/condition/ConditionModelPropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/ChangeReason","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/util/merge","sap/base/Log","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterConverter","sap/ui/core/date/UI5Date"],(t,e,i,n,o,s,r,d,c)=>{"use strict";const h=e.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){e.apply(this,arguments);this.setSizeLimit(1e3);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{})}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{})}}});h.prototype.bindProperty=function(e,i,n){let o=e;if(e.startsWith("/conditions/")){let t=e.slice(12);this._getFieldPathProperty(t);t=l.call(this,t);o="/conditions/"+t}const s=new t(this,o,i,n);s._sOriginapPath=e;return s};h.prototype.getContext=function(t){if(t.startsWith("/conditions/")){let e=t.slice(12);e=l.call(this,e);t="/conditions/"+e}return e.prototype.getContext.apply(this,[t])};h.prototype.bindList=function(t,i,n,o,s){const r=e.prototype.bindList.apply(this,arguments);r.enableExtendedChangeDetection(true);return r};h.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments)};h.prototype.clone=function(t){const e=new h;e._sName=this._sName+"_clone";let i={};if(typeof t==="string"){const e=this.getConditions(t);for(const n of e){const e=l.call(this,t);if(!i[e]){i[e]=[]}i[e].push(o({},n))}}else{i=o({},this.getAllConditions())}e.setConditions(i);return e};h.prototype.merge=function(t,e,i){this.removeAllConditions(t);const n=o({},e.getAllConditions());for(const t in n){if(!(typeof i==="string")||t===i){const e=r._removeEmptyConditions(n[t]);for(const i of e){this.addCondition(t,i)}}}this.checkUpdate(true,true)};h.prototype.getConditions=function(t){return p.call(this,t)};function p(t,e){const i=this.getProperty("/conditions");let n;if(typeof t=="string"){t=l.call(this,t);if(!i[t]&&e){i[t]=[]}n=i[t]||[]}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!")}return n}h.prototype.getAllConditions=function(t){const e=this.getProperty("/conditions");const i={};for(const n in e){const s=this.getProperty("/fieldPath");const r=s[n];const d=r?r.fieldPath:n;if(t&&[].concat(t).indexOf(d)===-1){continue}i[d]=o([],e[n])}return i};h.prototype.indexOf=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}const o=this.getConditions(t);const s=i?[i(e),o.map(i)]:[e,o];const r=n.indexOfCondition(...s);return r};h.prototype.exist=function(t,e){if(typeof e==="string"){return this.indexOf(e,t)>=0}else{throw new Error("sFieldPath must be provided "+this)}};h.prototype.setConditions=function(t){let e=0;let s;if(Array.isArray(t)){throw new Error("setConditions with an Array of condition is not supported! "+this)}else{this._bNoSingleEvent=true;let r=false;let d;let c;const h=o({},this.getProperty("/conditions"));for(d in t){this._getFieldPathProperty(d);c=l.call(this,d);const o=h[c]||[];const p=t[d]||[];if(!n.compareConditionsArray(o,p)){r=true;this.removeAllConditions(d);for(e=0;e<t[d].length;e++){s=t[d][e];this.insertCondition(d,-1,s,true)}this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:t[d]})}delete h[c]}const p=this.getProperty("/fieldPath");for(c in h){if(h[c].length>0){r=true;d=p[c].fieldPath;this.removeAllConditions(d);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:[]})}}if(r){this.checkUpdate(false,true)}this._bNoSingleEvent=false}return this};h.prototype.addCondition=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}return this.insertCondition(t,-1,e,i)};h.prototype.insertCondition=function(t,e,o,s){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}if(!o){return this}n.checkConditionsEmpty(o);n.updateConditionsValues(o);this._getFieldPathProperty(t);if(!s){const e=this.indexOf(t,o);if(e>=0){return this}}const r=p.call(this,t,true);if(e==-1){r.push(o)}else{r.splice(e,0,o)}if(!this._bNoSingleEvent){this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:r})}return this};h.prototype.createItemCondition=function(t,e,i){s.error("ConditionModel","createItemCondition is deprecated");return r.createItemCondition(e,i)};h.prototype.createCondition=function(t,e,i){s.error("ConditionModel","createCondition is deprecated");return r.createCondition(e,i)};h.prototype.removeCondition=function(t,e){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}let n=-1;if(typeof e==="object"){n=this.indexOf(t,e)}else if(typeof e==="number"){n=e}if(n>=0){const e=this.getConditions(t);if(e.length>n){e.splice(n,1);this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e});return true}}return false};h.prototype.removeAllConditions=function(t){const e=this.getProperty("/conditions");if(typeof t==="string"){const n=l.call(this,t);if(e[n]&&e[n].length>0){e[n]=[];if(!this._bNoSingleEvent){this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e[n]})}}}else{for(const t in e){if(e[t]&&e[t].length>0){e[t]=[];if(!this._bNoSingleEvent){const n=this.getProperty("/fieldPath");const o=n[t].fieldPath;this.firePropertyChange({reason:i.Binding,path:"/conditions/"+o,context:undefined,value:e[t]})}}}}if(!this._bNoSingleEvent){this.checkUpdate(false,true)}return this};h.prototype._getFieldPathProperty=function(t){const e=l.call(this,t);const i=this.getProperty("/fieldPath");if(!i[e]){i[e]={fieldPath:t}}const n=this.getProperty("/conditions");if(!n[e]){n[e]=[]}return i[e]};h.prototype.getFilters=function(t){s.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return d.createFilters(this.getAllConditions(),{})};h.prototype.serialize=function(){const t=o({},this.getAllConditions());for(const e in t){const i=t[e];i.forEach(t=>{delete t.isEmpty},this);if(i.length===0){delete t[e]}}return'{"conditions":'+JSON.stringify(t)+"}"};h.prototype.parse=function(t){const e=function(t,e){let i;if(!isNaN(parseInt(t))&&typeof e==="string"){i=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(e);if(i){return c.getInstance(e)}}return e};this.setConditions(JSON.parse(t,e).conditions)};function l(t){if(t){const e=t.split("/");if(e.length>1){t="";e.forEach((i,n)=>{if(n>0){if(!isNaN(i)||!isNaN(e[n-1])){t=t+"/"}else{t=t+"\\"}}t=t+i})}}return t}return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionModelPropertyBinding", ["sap/ui/model/ChangeReason","sap/ui/model/json/JSONPropertyBinding","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/core/date/UI5Date","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/condition/FilterOperatorUtil"],(t,e,a,i,s,o,n,r)=>{"use strict";const l=t=>t.operator===r.getEQOperator([t.operator])?.name&&t.validated===n.Validated;const u=t=>t.map(t=>({...t,values:l(t)?[t.values[0]]:t.values}));const h=(t,e)=>Array.isArray(t)&&Array.isArray(e)&&t?.length&&e?.length&&i(u(e),u(t));const p=e.extend("sap.ui.mdc.condition.ConditionModelPropertyBinding",{constructor:function(t,a,i,s){e.apply(this,arguments);this.oValue=c.call(this,this._getValue())}});p.prototype.getValue=function(){return c.call(this,this.oValue)};p.prototype.setValue=function(e){if(this.bSuspended){return}const a=this.oValue;if(!i(a,e)){if(this.oModel.setProperty(this.sPath,e,this.oContext,true)){this.oValue=c.call(this,e);this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:t.Binding,path:this._sOriginapPath,context:this.oContext,value:e,_descriptionOnly:h(e,a)})}}};p.prototype.checkUpdate=function(e){if(this.bSuspended&&!e){return}const a=this._getValue();if(!i(a,this.oValue)||e){this.oValue=c.call(this,a);this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:t.Change})}};function c(t){let e;if(!t){e=t}else if(Array.isArray(t)){e=a([],t)}else if(t instanceof Date){e=s.getInstance(t)}else if(typeof t==="object"){e=a({},t)}else{e=t}return e}return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/ConditionValidateException", ["sap/ui/model/ValidateException"],t=>{"use strict";const o=function(o,i,n,e){t.call(this,o,i);this.condition=n;this.conditions=e};o.prototype=Object.create(t.prototype);o.prototype.getCondition=function(){return this.condition};o.prototype.setCondition=function(t){this.condition=t};o.prototype.getConditions=function(){return this.conditions};o.prototype.setConditions=function(t){this.conditions=t};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/FilterConverter", ["sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/BaseType","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],(e,t,r,i,n)=>{"use strict";const l={createConditionTypesMapFromFilterBar:function(e,t){const r={};for(const i in e){if(t){const e=t._getPropertyByName(i);let n;if(e&&e.typeConfig){n=e.typeConfig.typeInstance}else{const e=t._getFilterField(i);if(e){const t=e.getFormatOptions();if(t.originalDateType){n=t.originalDateType}else{n=t.valueType}}}r[i]={type:n}}}return r},createFilters:function(s,o,a,f){let u,p,c,h,g,y,F;const d=[];const A=function(e,t,n){if([i.Any,i.All].includes(e.getOperator())){return{filter:null,anyAllFilters:[e]}}else if(!e.getPath()&&e.getFilters()){const i=[];let l=[];e.getFilters().forEach(e=>{const r=A(e,t,n);if(r.filter){i.push(r.filter)}if(r.anyAllFilters.length>0){l=l.concat(r.anyAllFilters)}});let s;if(i.length===1){[s]=i}else if(i.length>1){s=new r({filters:i,and:e.isAnd()})}return{filter:s,anyAllFilters:l}}else if(e.getPath()===t){e.sPath=n;return{filter:e,anyAllFilters:[]}}return e};const w=function(e,t,n){const[l,s,o,a]=t.split(/([\*\+]\/)/);if(s&&e.length>0){let f;if(e.length===1){[f]=e}else if(e.length>1){f=new r({filters:e,and:n})}if(f){const e="L1";if(!a){const a=A(f,t,e+"/"+o);let u;if(a.filter){u=new r({path:l,operator:s==="*/"&&!n?i.Any:i.All,variable:e,condition:a.filter})}if(a.anyAllFilters.length>0){if(u){a.anyAllFilters.push(u);u=new r({filters:a.anyAllFilters,and:n})}else if(a.anyAllFilters.length===1){[u]=a.anyAllFilters}else{u=new r({filters:a.anyAllFilters,and:n})}}return[u]}else{throw new Error("FilterConverter: not supported binding "+t)}}}return e};for(const i in s){p=[];c=[];const l=s[i];if(i==="$search"){continue}let a;let A=true;let v=t.String;if(o){if(o[i]){a=o[i].type;A=o[i].caseSensitive;v=o[i].baseType||t.String;if(!a){n.warning("FilterConverter","Not able to retrieve the type of path '"+i+"!")}}}for(u=0;u<l.length;u++){F=l[u];h=e.getOperator(F.operator);if(!h){continue}try{g=h.getModelFilter(F,i,a,A,v)}catch(e){if(e){n.error("FilterConverter",e)}else{n.error("FilterConverter","Not able to convert the condition for path '"+i+"' into a filter! The type is missing!")}continue}if(!h.exclude){if(g.sPath==="$search"){continue}const e=/^\*(.+)\*$/.exec(g.sPath);if(e){const t=e[1].split(",");for(let e=0;e<t.length;e++){p.push(new r({path:t[e],operator:g.sOperator,value1:g.oValue1,caseSensitive:f}))}continue}p.push(g)}else{c.push(g)}}p=w(p,i,false);c=w(c,i,true);g=undefined;if(p.length===1){g=p[0]}else if(p.length>1){g=new r({filters:p,and:false})}if(g){c.unshift(g)}y=undefined;if(c.length===1){y=c[0]}else if(c.length>1){y=new r({filters:c,and:true})}if(y){d.push(y)}}if(d.length===1){g=d[0]}else if(d.length>1){g=new r({filters:d,and:true})}else{g=null}n.info("FilterConverter",l.prettyPrintFilters(g));return g},prettyPrintFilters:function(e){let t;if(!e){return"no filters set"}if(e._bMultiFilter){t="";const{bAnd:r}=e;e.aFilters.forEach((e,i,n)=>{t+=l.prettyPrintFilters(e);if(n.length-1!=i){t+=r?" and ":" or "}},this);return"("+t+")"}else{if(e.sOperator===i.Any||e.sOperator===i.All){t=e.sVariable?e.sVariable+":":"";t=t+e.sPath+" "+e.sOperator+" "+l.prettyPrintFilters(e.oCondition)}else{if(e.bCaseSensitive===false){t="tolower("+e.sPath+") "+e.sOperator+" tolower('"+e.oValue1+"')"}else{t=e.sPath+" "+e.sOperator+" '"+e.oValue1+"'"}if([i.BT,i.NB].indexOf(e.sOperator)>=0){t+="...'"+e.oValue2+"'"}}return t}}};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/FilterOperatorUtil", ["sap/ui/core/Lib","sap/ui/model/FilterOperator","sap/ui/model/Filter","sap/ui/model/ValidateException","sap/base/Log","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","./Operator","./RangeOperator","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/loadModules","sap/ui/core/date/UniversalDate","sap/ui/core/date/UniversalDateUtils","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/core/StaticArea","sap/ui/model/json/JSONModel","sap/ui/model/type/Integer","sap/ui/model/BindingMode","sap/base/i18n/Localization"],(e,t,n,a,r,o,s,u,i,l,T,p,m,c,d,f,g,_,O,E,A,D)=>{"use strict";let y=e.getResourceBundleFor("sap.ui.mdc");let I=e.getResourceBundleFor("sap.m");D.attachChange(()=>{y=e.getResourceBundleFor("sap.ui.mdc");I=e.getResourceBundleFor("sap.m")});const x={_mOperators:{equal:new u({name:s.EQ,alias:{Date:"DATE",DateTime:"DATETIME"},filterOperator:t.EQ,tokenTest:"^=(.+)?$",tokenParse:"^=?(.+)?$",tokenFormat:"{1} ({0})",longText:k(s.EQ,true),valueTypes:[p.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(e,t,n,a,r,s,u){n=n||o.DescriptionValue;let i=this.valueTypes.length;const l=e.values;const p=e&&e.validated===T.Validated||l.length===2||a?"":"=";let m=p+this.displayFormats[n];if(!l[1]){m=p+this.displayFormats["Value"];i=1}for(let e=0;e<i;e++){let n,a=l[e];if(a===null||a===undefined){a=""}if(e===0){n=this._formatValue(a,t,r)}else{n=this._formatValue(a,s,u)}if(n===null){m=null;break}if(typeof n==="string"){n=n.replace(/\$/g,"$$$")}m=m.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),n)}return m},parse:function(e,t,n,a,r,s,i,l){n=n||o.DescriptionValue;let T=u.prototype.parse.apply(this,[e,t,n,a,r,s,i,l]);if(a&&(!T||T[0]===null||T[0]===undefined)&&n!==o.Value){n=o.Value;T=u.prototype.parse.apply(this,[e,t,n,a,r,s,i,l])}if(T&&(T[1]===null||T[1]===undefined)&&n===o.Value){T=[T[0]]}return T},getValues:function(e,t,n,a){const r=a?this.hiddenOperatorRegExp:this.tokenParseRegExp;const o=e.match(r);let s;if(o&&o.length>1&&o[1]!==undefined){const e=o[1];const n=this.displayFormats[t];const a=n.indexOf("{0}");const r=n.indexOf("{1}");let u;let i;if(a>=0&&r>=0){const t=a<r;let o=t?n.substring(a+3,r):n.substring(r+3,a);const s=t?n.slice(r+3):n.slice(a+3);let l=t?e.indexOf(o):e.lastIndexOf(o);if(l===-1){o="(";l=t?e.indexOf(o):e.lastIndexOf(o)}if(l>0&&(e.lastIndexOf(s)===e.length-s.length||e.lastIndexOf(s)<l)){let n=e.length;if(e.slice(n-s.length)===s){n=n-s.length}const a=e.substring(0,l);const r=e.substring(l+o.length,n);if(t){u=a;i=r}else{u=r;i=a}}else if(t){u=e}else{i=e}}else if(a>=0){u=e}else{i=e}s=[u];if(r>=0){s.push(i)}}return s},isEmpty:function(e,t){let n=false;const a=e.values[0];if((a===null||a===undefined||a==="")&&!e.values[1]){n=true}return n},getCheckValue:function(e){return{value:e.values[0]}},checkValidated:function(e){if(e.values.length===2&&e.values[0]!==undefined&&e.values[1]!==null&&e.values[1]!==undefined){e.validated=T.Validated}else{e.validated=T.NotValidated}},validateInput:true,getTextForCopy:function(e,t,n,a,r,o,s){if(e.validated!==T.Validated){return u.prototype.getTextForCopy.apply(this,arguments)}else{const[n,a]=e.values;const u=this._formatValue(n,t,r);const i=a===undefined?"":this._formatValue(a,o,s);return u+"\t"+i}}}),between:new u({name:s.BT,alias:{Date:"DATERANGE",DateTime:"DATETIMERANGE"},filterOperator:t.BT,tokenTest:"^([^!].*)\\.\\.\\.(.+)$",tokenParse:"^(.*)\\.\\.\\.(.*)$|^(.+)$",tokenFormat:"{0}...{1}",longText:k(s.BT,true),valueTypes:[p.Self,p.Self],validate:function(e,t){if(e.length===2){if(h(e[0])&&h(e[1])){return}else if(h(e[0])||h(e[1])){throw new a(y.getText("operator.between.validate.missingValue"))}else if(e[0]===e[1]){throw new a(y.getText("operator.between.validate.sameValues"))}}u.prototype.validate.apply(this,[e,t])}}),notBetween:new u({name:s.NOTBT,filterOperator:t.NB,tokenTest:["^!\\((.+)\\.\\.\\.(.+)\\)$","^!(.+)\\.\\.\\.(.+)$"].join("|"),tokenParse:["^!\\((.*)\\.\\.\\.(.*)\\)$","^!(.*)\\.\\.\\.(.*)$","^(.+)$"].join("|"),tokenFormat:"!({0}...{1})",longText:k(s.NOTBT,true),valueTypes:[p.Self,p.Self],exclude:true,validate:function(e,t){x._mOperators.between.validate(e,t)}}),lessThan:new u({name:s.LT,filterOperator:t.LT,tokenTest:"^<([^=].*)?$",tokenParse:"^<?(.+)?$",tokenFormat:"<{0}",longText:k(s.LT,true),longTextForTypes:C(s.LT,[l.Date]),valueTypes:[p.Self]}),notLessThan:new u({name:s.NOTLT,filterOperator:t.GE,tokenTest:["^!\\(<([^=].*)?\\)$","^!<([^=].*)?$"].join("|"),tokenParse:["^!\\(<?(.+)?\\)$","^(!<)?(.+)?$"].join("|"),tokenFormat:"!(<{0})",longText:k(s.NOTLT,true),longTextForTypes:C(s.NOTLT,[l.Date]),valueTypes:[p.Self],exclude:true}),greaterThan:new u({name:s.GT,filterOperator:t.GT,tokenTest:"^>([^=].*)?$",tokenParse:"^>?(.+)?$",tokenFormat:">{0}",longText:k(s.GT,true),longTextForTypes:C(s.GT,[l.Date]),valueTypes:[p.Self]}),notGreaterThan:new u({name:s.NOTGT,filterOperator:t.LE,tokenTest:["^!\\(>([^=].*)?\\)$","^!>([^=].*)?$"].join("|"),tokenParse:["^!\\(>(.+)?\\)$","^(!>)?(.+)?$"].join("|"),tokenFormat:"!(>{0})",longText:k(s.NOTGT,true),longTextForTypes:C(s.NOTGT,[l.Date]),valueTypes:[p.Self],exclude:true}),lessEqual:new u({name:s.LE,alias:{Date:"TO",DateTime:"TODATETIME"},filterOperator:t.LE,tokenTest:"^<=(.+)?$",tokenParse:"^(<=)?(.+)?$",tokenFormat:"<={0}",longText:k(s.LE,true),longTextForTypes:C(s.LE,[l.Date]),valueTypes:[p.Self]}),notLessEqual:new u({name:s.NOTLE,filterOperator:t.GT,tokenTest:["^!\\(<=(.+)?\\)$","^!<=(.+)?$"].join("|"),tokenParse:["^!\\(<=(.+)?\\)$","^(!<=)?(.+)?$"].join("|"),tokenFormat:"!(<={0})",longText:k(s.NOTLE,true),longTextForTypes:C(s.NOTLE,[l.Date]),valueTypes:[p.Self],exclude:true}),greaterEqual:new u({name:s.GE,alias:{Date:"FROM",DateTime:"FROMDATETIME"},filterOperator:t.GE,tokenTest:"^>=(.+)?$",tokenParse:"^(>=)?(.+)?$",tokenFormat:">={0}",longText:k(s.GE,true),longTextForTypes:C(s.GE,[l.Date]),valueTypes:[p.Self]}),notGreaterEqual:new u({name:s.NOTGE,filterOperator:t.LT,tokenTest:["^!\\(>=(.+)?\\)$","^!>=(.+)?$"].join("|"),tokenParse:["^!\\(>=(.+)?\\)$","^(!>=)?(.+)?$"].join("|"),tokenFormat:"!(>={0})",longText:k(s.NOTGE,true),longTextForTypes:C(s.NOTGE,[l.Date]),valueTypes:[p.Self],exclude:true}),startsWith:new u({name:s.StartsWith,filterOperator:t.StartsWith,tokenTest:"^([^!\\*]+.*)\\*$",tokenParse:"^(.+)\\*$|^(.*[^\\*])$",tokenFormat:"{0}*",longText:k(s.StartsWith,true),valueTypes:[p.SelfNoParse]}),notStartsWith:new u({name:s.NotStartsWith,filterOperator:t.NotStartsWith,tokenTest:["^!\\(([^\\*].*)\\*\\)$","^!([^\\*].*)\\*$"].join("|"),tokenParse:["^!\\((.+)\\*\\)$","^!?(.+)\\*$","^(.*[^\\*])$"].join("|"),tokenFormat:"!({0}*)",longText:k(s.NotStartsWith,true),valueTypes:[p.SelfNoParse],exclude:true}),endsWith:new u({name:s.EndsWith,filterOperator:t.EndsWith,tokenTest:"^\\*(.*[^\\*])$",tokenParse:"^\\*?(.+)?$",tokenFormat:"*{0}",longText:k(s.EndsWith,true),valueTypes:[p.SelfNoParse]}),notEndsWith:new u({name:s.NotEndsWith,filterOperator:t.NotEndsWith,tokenTest:["^!\\(\\*(.*[^\\*])\\)$","^!\\*(.*[^\\*])$"].join("|"),tokenParse:["^!\\(\\*(.+)?\\)$","^(!\\*)?(.+)?$"].join("|"),tokenFormat:"!(*{0})",longText:k(s.NotEndsWith,true),valueTypes:[p.SelfNoParse],exclude:true}),contains:new u({name:s.Contains,filterOperator:t.Contains,tokenTest:"^\\*(.*)\\*$",tokenParse:"^\\*(.+)?\\*$|^([^\\*]?.*[^\\*]?)$",tokenFormat:"*{0}*",longText:k(s.Contains,true),valueTypes:[p.SelfNoParse]}),notContains:new u({name:s.NotContains,filterOperator:t.NotContains,tokenTest:["^!\\(\\*(.*)\\*\\)$","^!\\*(.*)\\*$"].join("|"),tokenParse:["^!\\(\\*(.+)?\\*\\)$","^!\\*(.+)?\\*$","^!?(.+)$"].join("|"),tokenFormat:"!(*{0}*)",longText:k(s.NotContains,true),valueTypes:[p.SelfNoParse],exclude:true}),notEqual:new u({name:s.NE,filterOperator:t.NE,tokenTest:["^!\\(=(.+)?\\)$","^!=(.+)?$"].join("|"),tokenParse:["^!\\(=(.+)?\\)$","^(!=)?(.+)?$"].join("|"),tokenFormat:"!(={0})",longText:k(s.NE,true),valueTypes:[p.Self],exclude:true}),empty:new u({name:s.Empty,filterOperator:t.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",longText:k(s.Empty,true),tokenText:k(s.Empty,false),valueTypes:[],getModelFilter:function(e,a,r,o,s){const u=L(a);if(u){return new n({path:u.navPath,operator:t.All,variable:"L1",condition:new n({filters:[new n({path:"L1/"+u.propertyPath,operator:t.EQ,value1:null}),new n({path:"L1/"+u.propertyPath,operator:t.NE,value1:null})],and:true})})}else if(s===l.String){let e=false;if(r){const t=r.parseValue("","string");try{r.validateValue(t);e=t===null}catch(t){e=false}}if(e){return new n({filters:[new n({path:a,operator:t.EQ,value1:""}),new n({path:a,operator:t.EQ,value1:null})],and:false})}else{return new n({path:a,operator:this.filterOperator,value1:""})}}else{return new n({path:a,operator:this.filterOperator,value1:null})}}}),notEmpty:new u({name:s.NotEmpty,filterOperator:t.NE,tokenParse:["^!\\(<#tokenText#>\\)$","^!<#tokenText#>$"].join("|"),tokenFormat:"!(<#tokenText#>)",longText:k(s.NotEmpty,true),tokenText:k(s.NotEmpty,false),valueTypes:[],exclude:true,getModelFilter:function(e,a,r,o,s){const u=L(a);if(u){return new n({path:u.navPath,operator:t.Any})}else if(s===l.String){let e=false;if(r){const t=r.parseValue("","string");try{r.validateValue(t);e=t===null}catch(t){e=false}}if(e){return new n({filters:[new n({path:a,operator:t.NE,value1:""}),new n({path:a,operator:t.NE,value1:null})],and:true})}else{return new n({path:a,operator:this.filterOperator,value1:""})}}else{return new n({path:a,operator:this.filterOperator,value1:null})}}}),yesterday:new i({name:s.YESTERDAY,longText:I.getText("DYNAMIC_DATE_YESTERDAY_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_YESTERDAY_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.yesterday()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),today:new i({name:s.TODAY,longText:I.getText("DYNAMIC_DATE_TODAY_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TODAY_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.today()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),tomorrow:new i({name:s.TOMORROW,longText:I.getText("DYNAMIC_DATE_TOMORROW_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TOMORROW_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.tomorrow()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDays:new i({name:s.LASTDAYS,tokenText:I.getText("DYNAMIC_DATE_LASTDAYS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastDays(e)}}),firstDayWeek:new i({name:s.FIRSTDAYWEEK,longText:I.getText("DYNAMIC_DATE_FIRSTDAYWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayWeek:new i({name:s.LASTDAYWEEK,longText:I.getText("DYNAMIC_DATE_LASTDAYWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayMonth:new i({name:s.FIRSTDAYMONTH,longText:I.getText("DYNAMIC_DATE_FIRSTDAYMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayMonth:new i({name:s.LASTDAYMONTH,longText:I.getText("DYNAMIC_DATE_LASTDAYMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayQuarter:new i({name:s.FIRSTDAYQUARTER,longText:I.getText("DYNAMIC_DATE_FIRSTDAYQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayQuarter:new i({name:s.LASTDAYQUARTER,longText:I.getText("DYNAMIC_DATE_LASTDAYQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayYear:new i({name:s.FIRSTDAYYEAR,longText:I.getText("DYNAMIC_DATE_FIRSTDAYYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayYear:new i({name:s.LASTDAYYEAR,longText:I.getText("DYNAMIC_DATE_LASTDAYYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),todayFromTo:new i({name:s.TODAYFROMTO,longText:I.getText("DYNAMIC_DATE_TODAYFROMTO_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TODAYFROMTO_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",format:function(e,t,n,a,r,o,s,u){let i=u||this.tokenFormat;const l=(e.values[0]||0)*-1;const T=e.values[1]||0;let p=l<0?"":"+";p=p+this._formatValue(l,this._createLocalType(this.valueTypes[0],t));let m=T<0?"":"+";m=m+this._formatValue(T,this._createLocalType(this.valueTypes[1],t));if(l<=T){i=i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),p);i=i.replace(new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g"),m)}else{i=i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),m);i=i.replace(new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g"),p)}return i},parse:function(e,t,n,a,r,o,s,u){const i=this.getValues(e,n,a,u);let l=this._parseValue(i[0],this._createLocalType(this.valueTypes[0],t));let T=this._parseValue(i[1],this._createLocalType(this.valueTypes[1],t));if(l>T){const e=l;l=T;T=e}l=l*-1;return[l,T]},calcRange:function(e,t){let n=e>=0?d.ranges.lastDays(e)[0]:d.ranges.nextDays(-e)[1];let a=t>=0?d.ranges.nextDays(t)[1]:d.ranges.lastDays(-t)[0];if(n.oDate.getTime()>a.oDate.getTime()){a=[n,n=a][0]}return[d.resetStartTime(n),d.resetEndTime(a)]}}),nextDays:new i({name:s.NEXTDAYS,tokenText:I.getText("DYNAMIC_DATE_NEXTDAYS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextDays(e)}}),lastWeek:new i({name:s.LASTWEEK,longText:I.getText("DYNAMIC_DATE_LASTWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastWeek()}}),thisWeek:new i({name:s.THISWEEK,longText:I.getText("DYNAMIC_DATE_THISWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentWeek()}}),nextWeek:new i({name:s.NEXTWEEK,longText:I.getText("DYNAMIC_DATE_NEXTWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextWeek()}}),lastWeeks:new i({name:s.LASTWEEKS,tokenText:I.getText("DYNAMIC_DATE_LASTWEEKS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastWeeks(e)}}),nextWeeks:new i({name:s.NEXTWEEKS,tokenText:I.getText("DYNAMIC_DATE_NEXTWEEKS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextWeeks(e)}}),lastMonth:new i({name:s.LASTMONTH,longText:I.getText("DYNAMIC_DATE_LASTMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastMonth()}}),thisMonth:new i({name:s.THISMONTH,longText:I.getText("DYNAMIC_DATE_THISMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentMonth()}}),nextMonth:new i({name:s.NEXTMONTH,longText:I.getText("DYNAMIC_DATE_NEXTMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextMonth()}}),lastMonths:new i({name:s.LASTMONTHS,tokenText:I.getText("DYNAMIC_DATE_LASTMONTHS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastMonths(e)}}),nextMonths:new i({name:s.NEXTMONTHS,tokenText:I.getText("DYNAMIC_DATE_NEXTMONTHS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextMonths(e)}}),lastQuarter:new i({name:s.LASTQUARTER,longText:I.getText("DYNAMIC_DATE_LASTQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastQuarter()}}),thisQuarter:new i({name:s.THISQUARTER,longText:I.getText("DYNAMIC_DATE_THISQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentQuarter()}}),nextQuarter:new i({name:s.NEXTQUARTER,longText:I.getText("DYNAMIC_DATE_NEXTQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextQuarter()}}),lastQuarters:new i({name:s.LASTQUARTERS,tokenText:I.getText("DYNAMIC_DATE_LASTQUARTERS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastQuarters(e)}}),nextQuarters:new i({name:s.NEXTQUARTERS,tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTERS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextQuarters(e)}}),quarter1:new i({name:s.QUARTER1,longText:I.getText("DYNAMIC_DATE_QUARTER1_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER1_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(1)}}),quarter2:new i({name:s.QUARTER2,longText:I.getText("DYNAMIC_DATE_QUARTER2_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER2_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(2)}}),quarter3:new i({name:s.QUARTER3,longText:I.getText("DYNAMIC_DATE_QUARTER3_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER3_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(3)}}),quarter4:new i({name:s.QUARTER4,longText:I.getText("DYNAMIC_DATE_QUARTER4_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER4_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(4)}}),lastYear:new i({name:s.LASTYEAR,longText:I.getText("DYNAMIC_DATE_LASTYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastYear()}}),thisYear:new i({name:s.THISYEAR,longText:I.getText("DYNAMIC_DATE_THISYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentYear()}}),nextYear:new i({name:s.NEXTYEAR,longText:I.getText("DYNAMIC_DATE_NEXTYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextYear()}}),lastYears:new i({name:s.LASTYEARS,tokenText:I.getText("DYNAMIC_DATE_LASTYEARS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastYears(e)}}),nextYears:new i({name:s.NEXTYEARS,tokenText:I.getText("DYNAMIC_DATE_NEXTYEARS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextYears(e)}}),specificMonth:new i({name:s.SPECIFICMONTH,longText:I.getText("DYNAMIC_DATE_SPECIFICMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_SPECIFICMONTH_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:[S.call(this)],additionalInfo:"",label:[y.getText("operators.SPECIFICMONTH_MONTH.label")],defaultValues:function(){const e=new c;return[e.getMonth()]},calcRange:function(e){let t=new c;t.setMonth(e);t=d.getMonthStartDate(t);return d.getRange(0,"MONTH",t)},format:function(e,t,n,a,r,o,s){const[u]=e.values;const i=this.tokenFormat;const l=R.apply(this)[u];if(a){return l}else{return l==null?null:i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),l)}},getValues:function(e,t,n,a){const r=u.prototype.getValues.apply(this,arguments);if(r){return[N.call(this,r[0])]}return null},createControl:function(e,t,n,a){const s=sap.ui.require("sap/ui/mdc/Field");const u=F.call(this);if(s&&u){const n=new s(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},display:o.Description,width:"100%",valueHelp:u});return n}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}}}),specificMonthInYear:new i({name:s.SPECIFICMONTHINYEAR,longText:I.getText("DYNAMIC_DATE_SPECIFICMONTHINYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_SPECIFICMONTHINYEAR_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}},{name:"sap.ui.model.type.Integer",constraints:{minimum:1,maximum:9999}}],paramTypes:[S.call(this),"(.+)"],additionalInfo:"",label:[y.getText("operators.SPECIFICMONTHINYEAR_MONTH.label"),y.getText("operators.SPECIFICMONTHINYEAR_YEAR.label")],defaultValues:function(){const e=new c;return[e.getMonth(),e.getFullYear()]},calcRange:function(e,t){let n=new c;n.setMonth(e);n.setYear(t);n=d.getMonthStartDate(n);return d.getRange(0,"MONTH",n)},format:function(e,t,n,a,r,o,s){const[u,i]=e.values;let l=this.tokenFormat;const T=R.apply(this)[u];if(a){return T+" "+i}else{const e=new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g");const t=new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g");l=T==null?null:l.replace(e,T);return l.replace(t,i)}},getValues:function(e,t,n,a){const r=u.prototype.getValues.apply(this,arguments);if(r){return[N.call(this,r[0]),r[1]]}return null},createControl:function(e,t,n,a){let s;const u=sap.ui.require("sap/ui/mdc/Field");if(!u){r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}if(n==0){const n=F.call(this);if(n){s=new u(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},display:o.Description,width:"100%",valueHelp:n})}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name)}}if(n==1){s=new u(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},width:"100%"})}return s}}),yearToDate:new i({name:s.YEARTODATE,longText:I.getText("DYNAMIC_DATE_YEARTODATE_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_YEARTODATE_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.yearToDate()}}),dateToYear:new i({name:s.DATETOYEAR,longText:I.getText("DYNAMIC_DATE_DATETOYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_DATETOYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.dateToYear()}}),lastMinutes:new i({name:s.LASTMINUTES,tokenText:I.getText("DYNAMIC_DATE_LASTMINUTES_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastMinutes(e)}}),nextMinutes:new i({name:s.NEXTMINUTES,tokenText:I.getText("DYNAMIC_DATE_NEXTMINUTES_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextMinutes(e)}}),lastHours:new i({name:s.LASTHOURS,tokenText:I.getText("DYNAMIC_DATE_LASTHOURS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastHours(e)}}),nextHours:new i({name:s.NEXTHOURS,tokenText:I.getText("DYNAMIC_DATE_NEXTHOURS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextHours(e)}}),lastMinutesIncluded:new i({name:s.LASTMINUTESINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTMINUTESINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastMinutes(e-1);t[0].setSeconds(0);return t}}),nextMinutesIncluded:new i({name:s.NEXTMINUTESINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTMINUTESINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextMinutes(e-1);t[1].setSeconds(59);return t}}),lastHoursIncluded:new i({name:s.LASTHOURSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTHOURSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastHours(e-1);t[0].setMinutes(0,0);return t}}),nextHoursIncluded:new i({name:s.NEXTHOURSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTHOURSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextHours(e-1);t[1].setMinutes(59,59);return t}}),lastDaysIncluded:new i({name:s.LASTDAYSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTDAYSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastDays(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextDaysIncluded:new i({name:s.NEXTDAYSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTDAYSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextDays(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastWeeksIncluded:new i({name:s.LASTWEEKSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTWEEKSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastWeeks(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextWeeksIncluded:new i({name:s.NEXTWEEKSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTWEEKSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextWeeks(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastMonthsIncluded:new i({name:s.LASTMONTHSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTMONTHSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastMonths(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextMonthsIncluded:new i({name:s.NEXTMONTHSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTMONTHSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextMonths(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastQuartersIncluded:new i({name:s.LASTQUARTERSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTQUARTERSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastQuarters(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextQuartersIncluded:new i({name:s.NEXTQUARTERSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTERSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextQuarters(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastYearsIncluded:new i({name:s.LASTYEARSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTYEARSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastYears(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextYearsIncluded:new i({name:s.NEXTYEARSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTYEARSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextYears(e-1);t[0]=c.getInstance(f.getInstance());return t}})},_mDefaultOpsForType:{},addOperator:function(e){x._mOperators[e.name]=e},addOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{x.addOperator(e)})},removeOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{x.removeOperator(e)})},removeOperator:function(e){if(typeof e==="string"){delete x._mOperators[e]}else{delete x._mOperators[e.name]}},setOperatorsForType:function(e,t,n){if(!Array.isArray(t)){t=[t]}if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={}}x._mDefaultOpsForType[e].operators=[];t.forEach(t=>{x.addOperatorForType(e,t)});if(n){x.setDefaultOperatorForType(e,n)}},setDefaultOperatorForType:function(e,t){if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={}}if(typeof t==="string"){t=x.getOperator(t)}x._mDefaultOpsForType[e].defaultOperator=t},addOperatorForType:function(e,t){x.insertOperatorForType(e,t)},insertOperatorForType:function(e,t,n){if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={operators:[]}}n=n===undefined?x._mDefaultOpsForType[e].operators.length:n;if(typeof t==="string"){t=x.getOperator(t)}x._mDefaultOpsForType[e].operators.splice(n,0,t)},removeOperatorForType:function(e,t){let n;if(typeof t==="string"){n=t}else{n=t.name}for(let t=0;t<x._mDefaultOpsForType[e].operators.length;t++){if(x._mDefaultOpsForType[e].operators[t].name===n){x._mDefaultOpsForType[e].operators.splice(t,1);return}}},getOperatorsForType:function(e){const t=[];for(let n=0;n<x._mDefaultOpsForType[e].operators.length;n++){t.push(x._mDefaultOpsForType[e].operators[n].name)}return t},getDefaultOperator:function(e){return x._mDefaultOpsForType[e].defaultOperator||x._mOperators.equal},getMatchingOperators:function(e,t){const n=[];for(let t=0;t<e.length;t++){const a=this.getOperator(e[t]);if(a){n.push(a)}}return M.call(this,n,t)},getOperator:function(e){for(const t in x._mOperators){const n=x._mOperators[t];if(n.name===e){return n}}return undefined},getEQOperator:function(e){if(e){for(let t=0;t<e.length;t++){const n=this.getOperator(e[t]);if(n&&n.validateInput&&!n.exclude&&n.valueTypes[0]&&n.valueTypes[0]!==p.Static){return n}}}return x._mOperators.equal},onlyEQ:function(e){if(e.length===1&&e[0]===s.EQ){return true}else{return false}},checkConditionsEmpty:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{const t=this.getOperator(e.operator);if(t){e.isEmpty=t.isEmpty(e)}})},updateConditionsValues:function(e){if(!Array.isArray(e)){e=[e]}for(let t=0;t<e.length;t++){this.updateConditionValues(e[t])}},updateConditionValues:function(e){const t=this.getOperator(e.operator);if(t&&e.validated!==T.Validated){let n=t.valueTypes.length;if(t.valueTypes.length===2&&t.valueTypes[1]===null&&(e.values.length<2||e.values[1]===null||e.values[1]===undefined)){n=n-1}if(t.valueTypes[0]===p.Static){e.values=[]}else{while(e.values.length!=n){if(e.values.length<n){e.values.push(null)}if(e.values.length>n){e.values=e.values.slice(0,e.values.length-1)}}}}},indexOfCondition:function(e,t){let n=-1;for(let a=0;a<t.length;a++){if(this.compareConditions(e,t[a])){n=a;break}}return n},compareConditions:function(e,t){let n=false;if(e.operator===t.operator){const a=this.getOperator(e.operator);if(a){n=a.compareConditions(e,t)}}return n},compareConditionsArray:function(e,t){let n=false;if(e.length===t.length){n=true;for(let a=0;a<e.length;a++){if(!this.compareConditions(e[a],t[a])){n=false;break}}}return n},checkConditionValidated:function(e){const t=this.getOperator(e.operator);if(!e.validated&&t&&t.checkValidated){t.checkValidated(e)}},getOperatorForDynamicDateOption:function(e,t){let n;if(t&&e.startsWith(t)){n=this.getOperator(e.slice(t.length+1))}else{n=this.getOperator(e)}if(!n&&t){for(const a in x._mOperators){const r=x._mOperators[a];if(r.alias&&r.alias[t]===e){n=r;break}}}return n},getDynamicDateOptionForOperator:function(e,t,n){let a;if(e){if(t[e.name]){a=e.name}else if(e.alias&&t[e.alias[n]]){a=e.alias[n]}}return a},getCustomDynamicDateOptionForOperator:function(e,t){return t+"-"+e.name}};x.setOperatorsForType(l.String,[x._mOperators.contains,x._mOperators.equal,x._mOperators.between,x._mOperators.startsWith,x._mOperators.endsWith,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notContains,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notStartsWith,x._mOperators.notEndsWith,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty],x._mOperators.equal);x.setOperatorsForType(l.Date,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty,x._mOperators.today,x._mOperators.yesterday,x._mOperators.tomorrow,x._mOperators.firstDayWeek,x._mOperators.lastDayWeek,x._mOperators.firstDayMonth,x._mOperators.lastDayMonth,x._mOperators.firstDayQuarter,x._mOperators.lastDayQuarter,x._mOperators.firstDayYear,x._mOperators.lastDayYear,x._mOperators.todayFromTo,x._mOperators.lastDays,x._mOperators.lastDaysIncluded,x._mOperators.nextDays,x._mOperators.nextDaysIncluded,x._mOperators.thisWeek,x._mOperators.lastWeek,x._mOperators.lastWeeks,x._mOperators.lastWeeksIncluded,x._mOperators.nextWeek,x._mOperators.nextWeeks,x._mOperators.nextWeeksIncluded,x._mOperators.specificMonth,x._mOperators.specificMonthInYear,x._mOperators.thisMonth,x._mOperators.lastMonth,x._mOperators.lastMonths,x._mOperators.lastMonthsIncluded,x._mOperators.nextMonth,x._mOperators.nextMonths,x._mOperators.nextMonthsIncluded,x._mOperators.thisQuarter,x._mOperators.lastQuarter,x._mOperators.lastQuarters,x._mOperators.lastQuartersIncluded,x._mOperators.nextQuarter,x._mOperators.nextQuarters,x._mOperators.nextQuartersIncluded,x._mOperators.quarter1,x._mOperators.quarter2,x._mOperators.quarter3,x._mOperators.quarter4,x._mOperators.thisYear,x._mOperators.lastYear,x._mOperators.lastYears,x._mOperators.lastYearsIncluded,x._mOperators.nextYear,x._mOperators.nextYears,x._mOperators.nextYearsIncluded,x._mOperators.yearToDate,x._mOperators.dateToYear]);x.setOperatorsForType(l.DateTime,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty,x._mOperators.lastMinutes,x._mOperators.lastMinutesIncluded,x._mOperators.nextMinutes,x._mOperators.nextMinutesIncluded,x._mOperators.lastHours,x._mOperators.lastHoursIncluded,x._mOperators.nextHours,x._mOperators.nextHoursIncluded,x._mOperators.today,x._mOperators.yesterday,x._mOperators.tomorrow,x._mOperators.firstDayWeek,x._mOperators.lastDayWeek,x._mOperators.firstDayMonth,x._mOperators.lastDayMonth,x._mOperators.firstDayQuarter,x._mOperators.lastDayQuarter,x._mOperators.firstDayYear,x._mOperators.lastDayYear,x._mOperators.todayFromTo,x._mOperators.lastDays,x._mOperators.lastDaysIncluded,x._mOperators.nextDays,x._mOperators.nextDaysIncluded,x._mOperators.thisWeek,x._mOperators.lastWeek,x._mOperators.lastWeeks,x._mOperators.lastWeeksIncluded,x._mOperators.nextWeek,x._mOperators.nextWeeks,x._mOperators.nextWeeksIncluded,x._mOperators.specificMonth,x._mOperators.specificMonthInYear,x._mOperators.thisMonth,x._mOperators.lastMonth,x._mOperators.lastMonths,x._mOperators.lastMonthsIncluded,x._mOperators.nextMonth,x._mOperators.nextMonths,x._mOperators.nextMonthsIncluded,x._mOperators.thisQuarter,x._mOperators.lastQuarter,x._mOperators.lastQuarters,x._mOperators.lastQuartersIncluded,x._mOperators.nextQuarter,x._mOperators.nextQuarters,x._mOperators.nextQuartersIncluded,x._mOperators.quarter1,x._mOperators.quarter2,x._mOperators.quarter3,x._mOperators.quarter4,x._mOperators.thisYear,x._mOperators.lastYear,x._mOperators.lastYears,x._mOperators.lastYearsIncluded,x._mOperators.nextYear,x._mOperators.nextYears,x._mOperators.nextYearsIncluded,x._mOperators.yearToDate,x._mOperators.dateToYear]);x.setOperatorsForType(l.Numeric,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual]);x.setOperatorsForType(l.Time,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual]);x.setOperatorsForType(l.Boolean,[x._mOperators.equal,x._mOperators.notEqual]);function M(e,t){const n=[];for(const a of e){if(a&&a.test&&a.test(t)){n.push(a)}}return n}function h(e){return e===null||e===undefined||e===""}function R(){if(!this._aMonths){const e=new c,t=g.getDateInstance({pattern:"LLLL"});e.setDate(15);e.setMonth(0);const n=[];for(let a=0;a<12;a++){n.push(t.format(e));e.setMonth(e.getMonth()+1)}this._aMonths=n}return this._aMonths}function N(e){const t=e.toLowerCase();const n=R.apply(this);let a=-1;n.some((n,r)=>{if(n.toLowerCase()===t||Number.parseInt(e)===r+1){a=r;return true}});return a}function S(){if(!this._sMonthRegExp){const e=R.apply(this);this._sMonthRegExp="("+e.join("|")+"|[1-9]|1[0-2])"}return this._sMonthRegExp}let Y=false;function F(){const e="LFHForSpecificMonth";if(!Y){Y=true;m(["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/core/Control"]).then(t=>{const n=t[0];const a=t[1];const o=t[2];const s=t[3];const u=t[4];const i=function(){if(!this._aMonthsItems){const e=R.apply(this);this._aMonthsItems=[];for(let t=0;t<12;t++){this._aMonthsItems.push({text:e[t],key:t})}}return this._aMonthsItems}.bind(this);const l=new o(e,{typeahead:new s(e+"-pop",{content:[new n(e+"-FL",{filterList:false,useFirstMatch:true,items:{path:"$items>/",template:new a({text:"{$items>text}",key:"{$items>key}"}),templateShareable:false}})]})}).setModel(new O(i()),"$items");try{const t=_.getUIArea();const n=new u(e+"-parent",{dependents:[l]});t.addContent(n,true)}catch(e){r.error(e);throw new Error("MonthValueHelp cannot be assigned because static UIArea cannot be determined.")}})}return e}function k(e,t){const n="operators."+e+(t?".longText":".tokenText");return y.getText(n,undefined,true)}function C(e,t){const n="operators."+e+".longText";const a={};for(let e=0;e<t.length;e++){a[t[e]]=y.getText(n+"."+t[e].toLowerCase(),undefined,true)}return a}function L(e){const[t,n,a,r]=e.split(/([\*\+]\/)/);if(n){if(!r){return{navPath:t,propertyPath:a}}else{throw new Error("FilterOperatorUtil: not supported binding "+e)}}}return x},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/Operator", ["sap/ui/base/Object","sap/ui/core/Lib","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/ParseException","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/i18n/Localization","sap/base/strings/escapeRegExp","./Condition","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorOverwrite","sap/ui/mdc/enums/OperatorValueType"],(e,t,s,i,a,r,o,n,l,p,u,f,h,d,c,y)=>{"use strict";let g=t.getResourceBundleFor("sap.ui.mdc");l.attachChange(()=>{g=t.getResourceBundleFor("sap.ui.mdc")});const T=e.extend("sap.ui.mdc.condition.Operator",{constructor:function(t){e.apply(this,arguments);if(!t){throw new Error("Operator configuration missing")}if(!t.name){r.warning("Operator configuration expects a name property")}if(!t.filterOperator&&!t.getModelFilter){throw new Error("Operator configuration for "+t.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter")}this._enableOverwrites(t);this.name=t.name;if(t.alias){this.alias=t.alias}this.filterOperator=t.filterOperator;this.valueTypes=t.valueTypes;this.paramTypes=t.paramTypes;this.displayFormats=t.displayFormats;this.longText=t.longText||"";this.tokenText=t.tokenText||"";this.longTextForTypes=t.longTextForTypes||{};if(!this.longText){if(this.tokenText){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y")}else{this.longText=this.name}}let s;const i=this.tokenText&&p(this.tokenText);if(t.tokenParse){this.tokenParse=t.tokenParse.replace(/#tokenText#/g,i);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:"(.+)";this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}s=this.tokenParse}else{s=i}this.tokenParseRegExp=new RegExp(s,"i");if(t.tokenTest){this.tokenTest=t.tokenTest.replace(/#tokenText#/g,i);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:"(.+)";this.tokenTest=this.tokenTest.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}this.tokenTestRegExp=new RegExp(this.tokenTest,"i")}else{this.tokenTestRegExp=this.tokenParseRegExp}this.hiddenOperatorRegExp=new RegExp("^(.+)$","is");if(t.tokenFormat){this.tokenFormat=t.tokenFormat.replace(/\#tokenText\#/g,this.tokenText)}else{this.tokenFormat=this.tokenText||this.longText}if(t.additionalInfo!==undefined){this.additionalInfo=t.additionalInfo}this.exclude=!!t.exclude;this.validateInput=!!t.validateInput;if(t.group){this.group=t.group}else{this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=g.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id)}}this.symbol=t.symbol},destroy:function(){this._oMethodOverwrites=null;e.prototype.destroy.apply(this,arguments)}});T.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};T.prototype.getLongText=function(e){if(e===f.Time||e===f.DateTime){e=f.Date}let t=this.longTextForTypes[e];if(!t){t=this.longText}return t};T.prototype.getModelFilter=function(e,t,a,r,o){let n=e.values[0];let l;let p;const u=t.split(",");if(Array.isArray(n)&&u.length>1){n=n[0];t=u[0];p=new s({path:u[1],operator:i.EQ,value1:e.values[0][1]})}if(p&&n===undefined){l=p;p=undefined}else if(!this.valueTypes[1]){if(!r&&e.validated===h.Validated){r=true}l=new s({path:t,operator:this.filterOperator,value1:n,caseSensitive:r===false?false:undefined})}else{let i=e.values[1];if(Array.isArray(i)&&u.length>1){i=i[0]}l=new s({path:t,operator:this.filterOperator,value1:n,value2:i,caseSensitive:r===false?false:undefined})}if(p){l=new s({filters:[l,p],and:true})}if(e.inParameters){const t=[l];for(const a in e.inParameters){if(a.startsWith("conditions/")){t.push(new s({path:a.slice(11),operator:i.EQ,value1:e.inParameters[a]}))}}if(t.length>1){l=new s({filters:t,and:true})}}return l};T.prototype.isEmpty=function(e,t){let s=false;if(e){for(let t=0;t<this.valueTypes.length;t++){if(this.valueTypes[t]!==y.Static){const i=e.values[t];if(i===null||i===undefined||i===""){s=true;break}}}}return s};T.prototype.format=function(e,t,s,i,a,r,o,n){const l=e.values;const p=this.valueTypes.length;const u=n||this.tokenFormat;let f=i&&p===1?"{0}":u;for(let e=0;e<p;e++){let s;let i;if(this.valueTypes[e]!==y.Static){if(this.valueTypes[e]===y.Self){s=t;i=a}else if(this.valueTypes[e]===null){s=r;i=o}else{s=this._createLocalType(this.valueTypes[e],t)}let n=l[e];if(n===undefined||n===null){n=s?s.parseValue("","string"):""}let p=this._formatValue(n,s,i);if(typeof p==="string"){p=p.replace(/\$/g,"$$$")}f=f.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),p)}}return f};T.prototype._formatValue=function(e,t,s){let i;if(t){if(t.isA("sap.ui.model.CompositeType")&&t.getUseInternalValues()&&Array.isArray(e)&&s){e=o([],e);for(let t=0;t<e.length;t++){if(s[t]){const i=s[t].getModelFormat();if(i&&typeof i.parse==="function"){e[t]=i.parse(e[t])}}}}i=t.formatValue(e,"string")}else{i=e}return i};T.prototype.parse=function(e,t,s,i,a,o,n,l){const p=this.getValues(e,s,i,l);let u;if(p){u=[];for(let e=0;e<this.valueTypes.length;e++){let s;let i;if(this.valueTypes[e]===y.Self){s=t;i=a}else if(this.valueTypes[e]===null){s=o;i=n}else if(this.valueTypes[e]&&this.valueTypes[e]!==y.Static){s=this._createLocalType(this.valueTypes[e],t)}try{if(this.valueTypes[e]!==y.Static&&p.length>e){let t;if(s&&p[e]!==undefined){t=this._parseValue(p[e],s,i)}else{t=p[e]}u.push(t)}}catch(e){r.warning(e.message);throw e}}}return u};T.prototype._parseValue=function(e,t,s){if(e===undefined){return e}let i;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){i=t._aCurrentValue}const a=t?t.parseValue(e,"string",i):e;if(t&&t.isA("sap.ui.model.CompositeType")&&Array.isArray(a)&&(t._aCurrentValue||t.getUseInternalValues()&&s)){for(let e=0;e<a.length;e++){if(a[e]===undefined&&t._aCurrentValue){a[e]=t._aCurrentValue[e]===undefined?null:t._aCurrentValue[e]}else if(t.getUseInternalValues()&&s&&s[e]){const t=s[e].getModelFormat();if(t&&typeof t.format==="function"){a[e]=t.format(a[e])}}}}return a};T.prototype.validate=function(e,t,s,i,a,r){const n=this.valueTypes.length;for(let l=0;l<n;l++){if((this.valueTypes[l]||this.valueTypes[l]===null)&&this.valueTypes[l]!==y.Static){let n;let p;if(this.valueTypes[l]===y.Self){n=t;p=s}else if(this.valueTypes[l]===null){n=a;p=r}else{n=this._createLocalType(this.valueTypes[l],t)}if(e.length<l+1&&this.valueTypes[l]){throw new Error("value "+l+" for operator "+this.name+" missing")}if(n&&e.length>l){let t=e[l];if(t===undefined||t===null){t=n?n.parseValue("","string"):""}let s=t;if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&p&&n.getUseInternalValues()){s=o([],t);for(let e=0;e<s.length;e++){if(p[e]){const t=p[e].getModelFormat();if(t&&typeof t.parse==="function"){s[e]=t.parse(s[e])}}}}n.validateValue(s);if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&p){for(let e=0;e<t.length;e++){if(p[e]){if(i===undefined||e===i){p[e].validateValue(t[e])}}}}}}}};T.prototype.getTextForCopy=function(e,t,s,i,a,r,o){return"\t"+this.format(e,t,s,i,a,r,o)};T.prototype._createLocalType=function(e,t){if(!this._aTypes){this._aTypes=[]}let s;let i;let a;let r;if(e===y.SelfNoParse){s=t.getMetadata().getName();i=o({},t.getFormatOptions());a=o(t.getConstraints())}else if(typeof e==="string"){s=e}else if(e&&typeof e==="object"){s=e.name;i=e.formatOptions;a=e.constraints}for(const e of this._aTypes){if(e.name===s&&n(e.formatOptions,i)&&n(e.constraints,a)){r=e.type;break}}if(!r){const t=sap.ui.require(s.replace(/\./g,"/"));r=new t(i,a);r._bCreatedByOperator=true;if(e===y.SelfNoParse){r.parseValue=function(e,s){t.prototype.parseValue.apply(this,arguments);return e};r.validateValue=function(e){const s=t.prototype.parseValue.apply(this,[e,"string"]);t.prototype.validateValue.apply(this,[s])};r.formatValue=function(e,s){t.prototype.formatValue.apply(this,arguments);return e}}this._aTypes.push({name:s,formatOptions:i,constraints:a,type:r})}return r};T.prototype.test=function(e){return this.tokenTestRegExp.test(e)};T.prototype.getValues=function(e,t,s,i){const a=i?this.hiddenOperatorRegExp:this.tokenParseRegExp;let r=e.match(a);let o;if(r){r.splice(0,1);r=r.filter(e=>e!==undefined);o=[];for(let e=0;e<this.valueTypes.length;e++){const t=r.length-this.valueTypes.length+e;if(r.length>=e){const e=r[t];o.push(e)}}}return o};T.prototype.getCondition=function(e,t,s,i,r,o,n,l){if(this.test(e)||(i||l)&&e&&this.hasRequiredValues()){const p=this.parse(e,t,s,i,r,o,n,l);if(p&&p.length===this.valueTypes.length||this.valueTypes[0]===y.Static||p&&p.length===1&&this.valueTypes.length===2&&!this.valueTypes[1]){const e=u.createCondition(this.name,p);this.checkValidated(e);return e}else if(p&&p.length>0){throw new a("Parsed value don't meet operator")}}return null};T.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false}return true};T.prototype.getCheckValue=function(e){if(this.valueTypes[0]&&this.valueTypes[0]===y.Static){return{}}else{return{values:e.values}}};T.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==y.Static){return true}else{return false}};T.prototype.compareConditions=function(e,t){let s=false;if(e.operator===this.name&&e.operator===t.operator){const i=this.getCheckValue(e);const a=this.getCheckValue(t);if(e.inParameters&&t.inParameters){i.inParameters=e.inParameters;a.inParameters=t.inParameters}if(e.outParameters&&t.outParameters){i.outParameters=e.outParameters;a.outParameters=t.outParameters}if(e.payload||t.payload){i.payload=e.payload;a.payload=t.payload}if(e.validated&&t.validated){i.validated=e.validated;a.validated=t.validated}if(n(i,a)){s=true}}return s};T.prototype.checkValidated=function(e){e.validated=h.NotValidated};T.prototype._enableOverwrites=function(e){this._oMethodOverwrites={};["format","parse","validate","getModelFilter","isEmpty","createControl","getCheckValue","getValues","checkValidated","getLongText","getTextForCopy"].forEach(t=>{Object.defineProperty(this,t,{get:function(){return this._oMethodOverwrites&&this._oMethodOverwrites[t]||Object.getPrototypeOf(this)[t]}});if(e&&e[t]){this._oMethodOverwrites[t]=e[t]}})};const m=Object.values(c);T.prototype.overwrite=function(e,t){if(m.indexOf(e)>=0){const s=this[e];this._oMethodOverwrites[e]=t;return s.bind(this)}throw"Operator: Illegal overwrite detected. Please see sap.ui.mdc.enums.OperatorOverwrite"};return T});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/OperatorDynamicDateOption", ["sap/m/DynamicDateOption","sap/m/DynamicDateValueHelpUIType","sap/m/Input","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/mdc/util/loadModules","sap/ui/model/json/JSONModel","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/core/library"],(e,t,o,s,a,r,i,p,n,l,u,y,c)=>{"use strict";const{ValueState:f}=c;let h;let d;const g=e.extend("sap.ui.mdc.condition.OperatorDynamicDateOption",{metadata:{library:"sap.ui.mdc",properties:{operator:{type:"object"},type:{type:"object"},baseType:{type:"sap.ui.mdc.enums.BaseType"}}}});g.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oModel){this._oModel.destroy();this._oModel=undefined;this._mChangeHandler=undefined}if(this._aUITypes){for(let e=0;e<this._aUITypes.length;e++){this._aUITypes[e].destroy()}this._aUITypes=undefined}};g.prototype.applySettings=function(){e.prototype.applySettings.apply(this,arguments);const t=[];const o=this.getBaseType();if(o===s.DateTime){if(!d){t.push("sap/m/DateTimePicker")}}else if(!h){t.push("sap/m/DatePicker")}if(t.length>0){return p(t).then(e=>{if(o===s.DateTime){d=e[0]}else{h=e[0]}})}};g.prototype.validateProperty=function(t,o){if(t==="operator"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.mdc.condition.Operator"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.mdc.condition.Operator for property "'+t+'" of '+this)}else if(t==="type"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.model.Type"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.model.Type for property "'+t+'" of '+this)}return e.prototype.validateProperty.apply(this,arguments)};g.prototype.isRange=function(){const e=this.getOperator();return e.isA("sap.ui.mdc.condition.RangeOperator")};g.prototype.getText=function(e){const t=this.getOperator();const o=this.getBaseType();return t.getLongText(o)};g.prototype.getValueHelpUITypes=function(e){if(!this._aUITypes){const e=this.getOperator();let o=this.getType();const a=this.getBaseType();this._aUITypes=[];for(const i of e.valueTypes){if(i===r.Self){let e;if(a===s.DateTime){e="datetime"}else{e="date"}this._aUITypes.push(new t({type:e}))}else if(!i||i===r.Static){continue}else{o=e._createLocalType(i,o);if(o.isA("sap.ui.model.type.Integer")||o.isA("sap.ui.model.odata.type.Int")){this._aUITypes.push(new t({type:"int"}))}else{this._aUITypes.push(new t({type:"custom"}))}}}}return this._aUITypes};g.prototype.createValueHelpUI=function(e,t){let a=e.getValue();const p=this.getOperator();let l=this.getType();const u=this.getKey();const y=e.getId();if(!a||a.operator!==u){a={operator:u,values:[]};if(p.valueDefaults){a.values=p.valueDefaults}}m.call(this,e);if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[u]=[];let c=function(e){t(this)}.bind(this);for(let f=0;f<p.valueTypes.length;f++){const g=p.valueTypes[f];const m=this.getBaseType();let T;if(!g){continue}if(!e.aControlsByParameters[u][f]){if(p.createControl){if(!this._oModel){c=function(e){const t=e.getParameter("path");const o=t.split("/");const s=o[0]||o[1];if(this._mChangeHandler&&this._mChangeHandler[s]){this._mChangeHandler[s](this)}}.bind(this);this._oModel=new n;this._oModel.attachPropertyChange({},c,this);this._mChangeHandler={}}const o=this._oModel.getData();o[y]={value0:a&&a.values[0],value1:a&&a.values[1]};this._mChangeHandler[y]=t;if(g!==r.Self){l=p._createLocalType(g,l)}const s=p.createControl(l,"internal>/"+y+"/value"+f,f,y+"-"+f);s.setModel(this._oModel,"internal");e.aControlsByParameters[u].push(s)}else if(g===r.Self){if(a&&a.values[f]){T=i.typeToDate(a.values[f],l,m)}const t=l.getFormatOptions();let o;if(m===s.DateTime){o=d}else{o=h}const r=new o(y+"-"+f,{dateValue:T,displayFormat:t.style||t.pattern,displayFormatType:t.calendarType,change:c});e.aControlsByParameters[u].push(r)}else if(typeof g==="object"){l=p._createLocalType(p.valueTypes[f],l);const t=l.formatValue(a&&a.values[f],"string");const s=new o(y+"-"+f,{value:t,change:c});e.aControlsByParameters[u].push(s)}}}return e.aControlsByParameters[u]};g.prototype.validateValueHelpUI=function(e){const t=this.getKey();const o=this.getOperator();const s=this.getType();let a;let r=true;let i=f.None;let p;let n=0;try{a=this.getValueHelpOutput(e);for(n=0;n<a.values.length;n++){const e=a.values[n];if(e===undefined||e===null){r=false}}o.validate(a.values,s)}catch(e){r=false;i=f.Error;p=e.message;if(e&&!(e instanceof u)&&!(e instanceof y)){throw e}}if(!o.createControl){for(n=0;n<e.aControlsByParameters[t].length;n++){const o=e.aControlsByParameters[t][n];if(o.setValueState){o.setValueState(i);o.setValueStateText(p)}}}return r};g.prototype.getValueHelpOutput=function(e){const t=this.getKey();const o={operator:t,values:[]};const s=this.getOperator();let a=this.getType();const p=this.getBaseType();const n=e.getId();for(let l=0;l<s.valueTypes.length;l++){if(!s.valueTypes[l]||s.valueTypes[l]===r.Static){continue}const y=e.aControlsByParameters[t][l];if(y){let e;if(s.createControl){e=this._oModel?this._oModel.getProperty("/"+n+"/value"+l):null}else if(s.valueTypes[l]===r.Self){if(!y.isValidValue()){throw new u}e=y.getDateValue();if(e){e=i.dateToType(e,a,p)}}else{e=y.getValue();a=s._createLocalType(s.valueTypes[l],a);e=a.parseValue(e,"string")}o.values.push(e)}}return o};g.prototype.getGroupHeader=function(){const t=this.getOperator();if(t.group&&t.group.text){return t.group.text}return e.prototype.getGroupHeader.apply(this,arguments)};g.prototype.getGroup=function(){const t=this.getOperator();if(t.group){return t.group.id}return e.prototype.getGroup.apply(this,arguments)};g.prototype.toDates=function(e){const t=this.getOperator();const o=this.getType();const s=this.getBaseType();let a;let p=0;if(t.isA("sap.ui.mdc.condition.RangeOperator")){a=t._getRange(e&&e.values,o,s);for(p=0;p<a.length;p++){a[p]=i.typeToDate(a[p],o,s)}}else if(t.valueTypes.length===0){a=[]}else if(t.valueTypes[0]===r.Self){a=[];for(p=0;p<e.values.length;p++){a.push(e.values[p]?i.typeToDate(e.values[p],o,s):e.values[p])}if(a.length===1){a.push(a[0])}}else if([r.Self,r.Static].indexOf(t.valueTypes[0])===-1){throw new Error("Cannot convert to date, use RangeOperator")}return a};g.prototype.format=function(e){const t=this.getOperator();const o=this.getType();return t.format(e,o,a.Value)};g.prototype.parse=function(e){const t=this.getOperator();const o=this.getType();if(e&&t.test(e)){const s={};s.operator=this.getKey();s.values=t.parse(e,o,a.Value);return s}};g.prototype.enhanceFormattedValue=function(e,t){return false};function m(e){const t=this.getKey();if(e&&e.aControlsByParameters&&e.aControlsByParameters[t]){for(const o of e.aControlsByParameters[t]){if(!o.bIsDestroyed){o.destroy()}}delete e.aControlsByParameters[t]}}return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/condition/RangeOperator", ["sap/ui/mdc/condition/Operator","sap/ui/mdc/util/DateUtil","sap/ui/mdc/enums/OperatorValueType","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/strings/escapeRegExp"],(e,t,a,n,s,o)=>{"use strict";const i=e.extend("sap.ui.mdc.condition.RangeOperator",{constructor:function(t){t.filterOperator=t.filterOperator||s.BT;if(t.valueTypes&&t.valueTypes.length>0){if(t.valueTypes[0]===a.Static){const e=t.longText&&o(t.longText);if(t.longText&&t.longText!==t.tokenText&&t.tokenText){t.tokenTest=t.tokenTest||"^"+e+"$|^#tokenText#$"}else if(t.longText&&!t.tokenText){t.tokenTest=t.tokenTest||"^"+e+"$"}else{t.tokenTest=t.tokenTest||"^#tokenText#$"}t.tokenParse=t.tokenParse||"^(.+)?$"}else{t.tokenTest=t.tokenTest||"^#tokenText#$";t.tokenParse=t.tokenParse||"^#tokenText#$|^(.+)?$"}}else{t.tokenParse=t.tokenParse||"^#tokenText#$"}t.tokenFormat=t.tokenFormat||!!t.tokenText&&"#tokenText#";e.apply(this,arguments);if(this.paramTypes){if(t.defaultValues!==undefined){if(Array.isArray(t.defaultValues)){this.valueDefaults=t.defaultValues}else{this.valueDefaults=t.defaultValues()}}else{this.paramTypes.forEach(e=>{if(!this.valueDefaults){this.valueDefaults=[]}this.valueDefaults.push(1)})}}if(t.label!==undefined){this.aLabels=t.label}if(t.calcRange){this.calcRange=t.calcRange}if(t.formatRange){this.formatRange=t.formatRange}else if(this.calcRange){this.formatRange=function(e,t){return t.formatValue(e[0],"string")+(e[1]?" - "+t.formatValue(e[1],"string"):"")}}}});i.prototype.getModelFilter=function(e,t,a,s,o){const i=this._getRange(e.values,a,o);return new n({path:t,operator:this.filterOperator,value1:i[0],value2:i[1]})};i.prototype._getRange=function(e,a,n){let s;if(e){if(e.length===2){s=this.calcRange(e[0],e[1])}else{s=this.calcRange(e[0])}}else{s=this.calcRange()}for(let e=0;e<s.length;e++){s[e]=t.dateToType(s[e].getJSDate(),a,n)}return s};i.prototype.getStaticText=function(e){const t=this._getRange(null,e);return this.formatRange(t,e)};i.prototype.format=function(t,n,s,o,i,l,r,u){const f=u||this.tokenFormat;if(this.valueTypes.length===1&&this.valueTypes[0]===a.Static&&f.indexOf("{0}")>=0){const e=this.getStaticText(n);return f.replace(new RegExp("\\{"+0+"\\}","g"),e)}return e.prototype.format.apply(this,arguments)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ActionToolbarActionAlignment", ["sap/ui/base/DataType"],e=>{"use strict";const n={Begin:"Begin",End:"End"};e.registerEnum("sap.ui.mdc.enum.ActionToolbarActionAlignment",n);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/BaseType", ["sap/ui/base/DataType"],e=>{"use strict";const i={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};e.registerEnum("sap.ui.mdc.enum.BaseType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ConditionValidated", ()=>{"use strict";const t={NotValidated:"NotValidated",Validated:"Validated"};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ContentMode", ["sap/ui/base/DataType"],i=>{"use strict";const t={Display:"Display",DisplayMultiValue:"DisplayMultiValue",DisplayMultiLine:"DisplayMultiLine",Edit:"Edit",EditMultiValue:"EditMultiValue",EditMultiLine:"EditMultiLine",EditOperator:"EditOperator",EditForHelp:"EditForHelp"};i.registerEnum("sap.ui.mdc.enum.ContentMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/EditMode", ["sap/ui/base/DataType"],e=>{"use strict";const a={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};e.registerEnum("sap.ui.mdc.enum.EditMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/FieldDisplay", ["sap/ui/base/DataType"],e=>{"use strict";const i={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};e.registerEnum("sap.ui.mdc.enum.FieldDisplay",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/FilterBarValidationStatus", ()=>{"use strict";const e={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2,OngoingChangeAppliance:3};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/LinkType", ["sap/ui/base/DataType"],e=>{"use strict";const i={Text:0,DirectLink:1,Popover:2};e.registerEnum("sap.ui.mdc.enum.LinkType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/OperatorOverwrite", ()=>{"use strict";const e={getModelFilter:"getModelFilter",getLongText:"getLongText"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/OperatorValueType", ()=>{"use strict";const e={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ProcessingStrategy", ()=>{"use strict";const e={Add:false,PartialReplace:true,FullReplace:"FullReplace"};return e},true);
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/PropagationReason", ()=>{"use strict";const e={ControlChange:"ControlChange",Select:"Select",Info:"Info"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/ReasonMode", ["sap/ui/base/DataType"],e=>{"use strict";const a={Variant:"Variant",Enter:"Enter",Go:"Go",Unclear:""};e.registerEnum("sap.ui.mdc.enum.ReasonMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enum/SelectType", ["sap/ui/base/DataType"],e=>{"use strict";const t={Set:"Set",Add:"Add",Remove:"Remove"};e.registerEnum("sap.ui.mdc.enum.SelectType",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ActionToolbarActionAlignment", ["sap/ui/base/DataType"],e=>{"use strict";const n={Begin:"Begin",End:"End"};e.registerEnum("sap.ui.mdc.enums.ActionToolbarActionAlignment",n);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/BaseType", ["sap/ui/base/DataType"],e=>{"use strict";const i={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};e.registerEnum("sap.ui.mdc.enums.BaseType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartItemRoleType", ["sap/ui/base/DataType"],e=>{"use strict";const s={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};e.registerEnum("sap.ui.mdc.enums.ChartItemRoleType",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartItemType", ["sap/ui/base/DataType"],e=>{"use strict";const s={Dimension:"Dimension",Measure:"Measure"};e.registerEnum("sap.ui.mdc.enums.ChartItemType",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartP13nMode", ["sap/ui/base/DataType"],e=>{"use strict";const t={Item:"Item",Sort:"Sort",Type:"Type",Filter:"Filter"};e.registerEnum("sap.ui.mdc.enums.ChartP13nMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ChartToolbarActionType", ["sap/ui/base/DataType"],e=>{"use strict";const n={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend"};e.registerEnum("sap.ui.mdc.enums.ChartToolbarActionType",n);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ConditionValidated", ()=>{"use strict";const t={NotValidated:"NotValidated",Validated:"Validated"};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ContentMode", ["sap/ui/base/DataType"],i=>{"use strict";const t={Display:"Display",DisplayMultiValue:"DisplayMultiValue",DisplayMultiLine:"DisplayMultiLine",Edit:"Edit",EditMultiValue:"EditMultiValue",EditMultiLine:"EditMultiLine",EditOperator:"EditOperator",EditForHelp:"EditForHelp"};i.registerEnum("sap.ui.mdc.enums.ContentMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FieldDisplay", ["sap/ui/base/DataType"],e=>{"use strict";const i={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};e.registerEnum("sap.ui.mdc.enums.FieldDisplay",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FieldEditMode", ["sap/ui/base/DataType"],e=>{"use strict";const a={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};e.registerEnum("sap.ui.mdc.enums.FieldEditMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FilterBarP13nMode", ["sap/ui/base/DataType"],e=>{"use strict";const t={Item:"Item",Value:"Value"};e.registerEnum("sap.ui.mdc.enums.FilterBarP13nMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/FilterBarValidationStatus", ()=>{"use strict";const e={NoError:"NoError",RequiredHasNoValue:"RequiredHasNoValue",FieldInErrorState:"FieldInErrorState",AsyncValidation:"AsyncValidation",OngoingChangeAppliance:"OngoingChangeAppliance"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/LinkType", ["sap/ui/base/DataType"],e=>{"use strict";const i={Text:"Text",DirectLink:"DirectLink",Popover:"Popover"};e.registerEnum("sap.ui.mdc.enums.LinkType",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorName", ()=>{"use strict";const T={EQ:"EQ",NE:"NE",BT:"BT",NOTBT:"NOTBT",LT:"LT",NOTLT:"NOTLT",GT:"GT",NOTGT:"NOTGT",LE:"LE",NOTLE:"NOTLE",GE:"GE",NOTGE:"NOTGE",StartsWith:"StartsWith",NotStartsWith:"NotStartsWith",EndsWith:"EndsWith",NotEndsWith:"NotEndsWith",Contains:"Contains",NotContains:"NotContains",Empty:"Empty",NotEmpty:"NotEmpty",YESTERDAY:"YESTERDAY",TODAY:"TODAY",TOMORROW:"TOMORROW",LASTDAYS:"LASTDAYS",FIRSTDAYWEEK:"FIRSTDAYWEEK",LASTDAYWEEK:"LASTDAYWEEK",FIRSTDAYMONTH:"FIRSTDAYMONTH",LASTDAYMONTH:"LASTDAYMONTH",FIRSTDAYQUARTER:"FIRSTDAYQUARTER",LASTDAYQUARTER:"LASTDAYQUARTER",FIRSTDAYYEAR:"FIRSTDAYYEAR",LASTDAYYEAR:"LASTDAYYEAR",TODAYFROMTO:"TODAYFROMTO",NEXTDAYS:"NEXTDAYS",LASTWEEK:"LASTWEEK",THISWEEK:"THISWEEK",NEXTWEEK:"NEXTWEEK",LASTWEEKS:"LASTWEEKS",NEXTWEEKS:"NEXTWEEKS",LASTMONTH:"LASTMONTH",THISMONTH:"THISMONTH",NEXTMONTH:"NEXTMONTH",LASTMONTHS:"LASTMONTHS",NEXTMONTHS:"NEXTMONTHS",LASTQUARTER:"LASTQUARTER",THISQUARTER:"THISQUARTER",NEXTQUARTER:"NEXTQUARTER",LASTQUARTERS:"LASTQUARTERS",NEXTQUARTERS:"NEXTQUARTERS",QUARTER1:"QUARTER1",QUARTER2:"QUARTER2",QUARTER3:"QUARTER3",QUARTER4:"QUARTER4",LASTYEAR:"LASTYEAR",THISYEAR:"THISYEAR",NEXTYEAR:"NEXTYEAR",LASTYEARS:"LASTYEARS",NEXTYEARS:"NEXTYEARS",SPECIFICMONTH:"SPECIFICMONTH",SPECIFICMONTHINYEAR:"SPECIFICMONTHINYEAR",YEARTODATE:"YEARTODATE",DATETOYEAR:"DATETOYEAR",LASTMINUTES:"LASTMINUTES",NEXTMINUTES:"NEXTMINUTES",LASTHOURS:"LASTHOURS",NEXTHOURS:"NEXTHOURS",LASTMINUTESINCLUDED:"LASTMINUTESINCLUDED",NEXTMINUTESINCLUDED:"NEXTMINUTESINCLUDED",LASTHOURSINCLUDED:"LASTHOURSINCLUDED",NEXTHOURSINCLUDED:"NEXTHOURSINCLUDED",LASTDAYSINCLUDED:"LASTDAYSINCLUDED",NEXTDAYSINCLUDED:"NEXTDAYSINCLUDED",LASTWEEKSINCLUDED:"LASTWEEKSINCLUDED",NEXTWEEKSINCLUDED:"NEXTWEEKSINCLUDED",LASTMONTHSINCLUDED:"LASTMONTHSINCLUDED",NEXTMONTHSINCLUDED:"NEXTMONTHSINCLUDED",LASTQUARTERSINCLUDED:"LASTQUARTERSINCLUDED",NEXTQUARTERSINCLUDED:"NEXTQUARTERSINCLUDED",LASTYEARSINCLUDED:"LASTYEARSINCLUDED",NEXTYEARSINCLUDED:"NEXTYEARSINCLUDED"};return T},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorOverwrite", ()=>{"use strict";const e={getModelFilter:"getModelFilter",getLongText:"getLongText"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/OperatorValueType", ["sap/ui/base/DataType"],e=>{"use strict";const a={Self:"Self",Static:"Static",SelfNoParse:"SelfNoParse"};e.registerEnum("sap.ui.mdc.enums.OperatorValueType",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ProcessingStrategy", ()=>{"use strict";const e={Add:false,PartialReplace:true,FullReplace:"FullReplace"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ReasonMode", ["sap/ui/base/DataType"],e=>{"use strict";const a={Variant:"Variant",Enter:"Enter",Go:"Go",Unclear:"Unclear"};e.registerEnum("sap.ui.mdc.enums.ReasonMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/RequestShowContainerReason", ["sap/ui/base/DataType"],e=>{"use strict";const a={Typing:"Typing",Filter:"Filter",Tap:"Tap",Tab:"Tab",ValueHelpRequest:"ValueHelpRequest",Focus:"Focus",Navigate:"Navigate"};e.registerEnum("sap.ui.mdc.enums.RequestShowContainerReason",a);return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableGrowingMode", ["sap/ui/base/DataType"],e=>{"use strict";const s={None:"None",Basic:"Basic",Scroll:"Scroll"};e.registerEnum("sap.ui.mdc.enums.TableGrowingMode",s);return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableMultiSelectMode", ["sap/ui/base/DataType"],e=>{"use strict";const a={Default:"Default",ClearAll:"ClearAll"};e.registerEnum("sap.ui.mdc.enums.TableMultiSelectMode",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableP13nMode", ["sap/ui/base/DataType"],e=>{"use strict";const r={Column:"Column",Sort:"Sort",Filter:"Filter",Group:"Group",Aggregate:"Aggregate"};e.registerEnum("sap.ui.mdc.enums.TableP13nMode",r);return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableRowActionType", ["sap/ui/base/DataType"],e=>{"use strict";const a={Navigation:"Navigation"};e.registerEnum("sap.ui.mdc.enums.TableRowActionType",a);return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableRowCountMode", ["sap/ui/base/DataType"],e=>{"use strict";const t={Auto:"Auto",Fixed:"Fixed",Interactive:"Interactive"};e.registerEnum("sap.ui.mdc.enums.TableRowCountMode",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableSelectionMode", ["sap/ui/base/DataType"],e=>{"use strict";const i={None:"None",Single:"Single",SingleMaster:"SingleMaster",Multi:"Multi"};e.registerEnum("sap.ui.mdc.enums.TableSelectionMode",i);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/TableType", ["sap/ui/base/DataType"],e=>{"use strict";const a={Table:"Table",TreeTable:"TreeTable",ResponsiveTable:"ResponsiveTable"};e.registerEnum("sap.ui.mdc.enums.TableType",a);return a},true);
/*
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ValueHelpPropagationReason", ()=>{"use strict";const e={ControlChange:"ControlChange",Select:"Select",Info:"Info"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/enums/ValueHelpSelectionType", ["sap/ui/base/DataType"],e=>{"use strict";const t={Set:"Set",Add:"Add",Remove:"Remove"};e.registerEnum("sap.ui.mdc.enums.ValueHelpSelectionType",t);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ConditionType", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/mdc/field/ConditionTypeMixin","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/base/util/merge","sap/base/strings/whitespaceReplacer","sap/ui/base/SyncPromise","sap/base/util/Deferred"],(t,e,i,n,s,o,a,l,r,u,c,p,d,f,h,g,_,y,m)=>{"use strict";const C="sap.ui.mdc.raw";const v="sap.ui.mdc.raw:";const V=i.extend("sap.ui.mdc.field.ConditionType",{constructor:function(t,n){i.apply(this,arguments);this.sName="Condition";this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}});V.prototype.destroy=function(){i.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._bDestroyed=true};V.prototype.getPrimitiveType=function(t){if(t===C||I(t)>=0){return t}else{return i.prototype.getPrimitiveType.apply(this,arguments)}};V.prototype.formatValue=function(t,e){let i=this._getValueType();if(t==undefined||t==null||this._bDestroyed){A.call(this,t,i);return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new n("No valid condition provided")}if(!e){e="string"}const s=this._getAdditionalValueType();const o=this._isUnit(i);const a=this.oFormatOptions.preventGetDescription;A.call(this,t,i);let r,u,p,d,f;switch(this.getPrimitiveType(e)){case"string":case"any":r=this._getDisplay();u=this._getOperators();p=c.getEQOperator(u);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++}d=this._oCalls.last;if(!a&&r!==l.Value&&t.validated===h.Validated&&(o||t.operator===p.name&&!t.values[1])){const e=this.oFormatOptions.bindingContext;const a=o?t.values[0][1]:t.values[0];const l=this.oFormatOptions.awaitFormatCondition;const r=l&&new m;l?.(t,r.promise);return y.resolve().then(()=>U.call(this,a,t,i,s,e)).then(e=>{const n=g({},t);if(e){t=g({},t);if(o){i=this._getDefaultType();t.operator=p.name;if(typeof e!=="object"){e={key:a,description:e}}}const s=typeof e==="object"?e.description:e;n.values[1]=s;r?.resolve(n)}else{r?.reject(null)}return w.call(this,n,undefined,d,true,i,s)}).catch(e=>{let o;if(!(e instanceof n)||!N.call(this)){o=e}r?.reject(e);return w.call(this,t,o,d,true,i,s)}).unwrap()}return w.call(this,t,undefined,d,true,i,s);default:f=I(e);if(f>=0){if(this._isCompositeType(i)){return t.values.length>=1?t.values[0][f]:null}}else if(e===C){return t.values.length>=1?t.values[0]:null}else if(i&&t.values.length>=1){return i.formatValue(t.values[0],e)}throw new n("Don't know how to format Condition to "+e)}};function T(t,e,i){const s=this._getDisplay();const o=this._isUnit(e);if(o&&t.values.length>1&&t.values[0][1]===t.values[1][1]){t=g({},t);t.operator=r.EQ;t.values.splice(1)}const a=this._getHideOperator()&&t.values.length===1||o;const u=c.getOperator(t.operator);const p=this._getCompositeTypes();const d=this._getAdditionalCompositeTypes();if(!u){throw new n("No valid condition provided, Operator wrong.")}let h=u.format(t,e,s,a,p,i,d);const y=this.oFormatOptions.convertWhitespaces;if(y&&(this._getBaseType(e)===f.String||s!==l.Value)){h=_(h)}return h}function w(t,e,i,n,s,o){if(this._oCalls.active>0){this._oCalls.active--}if(i<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){t=this._oCalls.condition;e=this._oCalls.exception}if(i===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=g({},t);this._oCalls.exception=e}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}if(e){throw e}let a;if(n){a=T.call(this,t,s,o)}else{a=O.call(this,t,s)}return a}V.prototype.getTextForCopy=function(t){const e=c.getOperator(t.operator);const i=this._getValueType();const n=this._getDisplay();const s=this._isUnit(i);const o=this._getHideOperator()&&t.values.length===1||s;const a=this._getCompositeTypes();const l=this._getAdditionalValueType();const r=this._getAdditionalCompositeTypes();return e.getTextForCopy(t,i,n,o,a,l,r)};V.prototype.parseValue=function(t,e){const i=F.call(this);if(!e){e="string"}else if(e==="any"&&typeof t==="string"){e="string"}return this._parseValue(t,e,i)};V.prototype._parseValue=function(t,e,i,n){if(this._bDestroyed){return null}let o;const a=this.oFormatOptions.navigateCondition;if(a){let i;if(a.hasOwnProperty("output")){i=a.output}else{i=this.formatValue(a,e)}if(i===t){o=g({},a);delete o.output;delete o.itemId;return o}}const l=n?n:this._getDisplay();const r=this._getValueType();const u=this._getOriginalType();const d=this._getOperators();const f=this._isUnit(r);let _;if(t===null||t===undefined||t===""&&!i){if(!this._isCompositeType(r)){return null}}E.call(this,r);let y,m,v;let V=this._getHideOperator();switch(this.getPrimitiveType(e)){case"string":m=false;v=false;if(d.length===1){y=c.getOperator(d[0]);v=true}else{const e=c.getMatchingOperators(d,t);if(e.length===0){y=this._getDefaultOperator(d,r);if(i&&!this._isCompositeType(r)){const t=c.getEQOperator(d);if(d.indexOf(t.name)>=0){m=!!y&&y.name!==t.name;y=t}}v=true}else{const t=e.filter(t=>t.valueTypes.length===0);if(t.length>=1){y=t[0]}else{y=e[0]}V=false}}if(y){if(f&&y!==c.getEQOperator(d)){throw new s("unsupported operator")}const e=this._isCompositeType(r);const n=this._getCompositeTypes();const a=this._getAdditionalValueType();const g=this._getAdditionalCompositeTypes();this._oCalls.active++;this._oCalls.last++;const _=this._oCalls.last;if((!e||f)&&y.validateInput&&i){o=D.call(this,y,t,r,a,v,V,m,d,l,true);return this._fnReturnPromise(o)}else{try{if(t===""&&e&&v){o=p.createCondition(y.name,[r.parseValue(t,"string",r._aCurrentValue)],undefined,undefined,h.NotValidated)}else{o=y.getCondition(t,r,l,v,n,a,g,V)}}catch(i){let n=i;if(n instanceof s&&u&&!e){try{u.parseValue(t,"string",u._aCurrentValue)}catch(t){n=t}}return w.call(this,undefined,n,_,false,r)}}if(o){return w.call(this,o,undefined,_,false,r)}}if(o!==null){throw new s("Cannot parse value "+t)}break;default:if(r){if(d.length===1){_=d[0]}else{_=this._getDefaultOperator(d,r).name;if(d.indexOf(_)<0){_=undefined}}if(_){const i=I(e);if(i>=0){if(this._isCompositeType(r)){const e=g([],r._aCurrentValue);e[i]=t;return p.createCondition(_,[e],undefined,undefined,h.NotValidated)}}else if(e===C){return p.createCondition(_,[t],undefined,undefined,h.NotValidated)}else{return p.createCondition(_,[r.parseValue(t,e)],undefined,undefined,h.NotValidated)}}}throw new s("Don't know how to parse Condition from "+e)}};function O(t,e){const i=this._isUnit(e);const n=this._isCompositeType(e);if(t&&!i&&n){const i=this._getOriginalType()||e;const n=i.getMetadata().getName();const s=i.getFormatOptions();const o=i.getConstraints();const a=this._getDelegate();const l=this.oFormatOptions.control;const u=a.getTypeMap(l).getBaseType(n,s,o);if((u===f.Unit||u===f.DateTime)&&!t.values[0][1]&&e._aCurrentValue){const i=e._aCurrentValue[1]===undefined?null:e._aCurrentValue[1];t.values[0][1]=i;if(t.operator===r.BT){t.values[1][1]=i}}}A.call(this,t,e);return t}function D(t,e,i,a,c,d,f,g,_,m){let C;let v;let V=true;let T=false;let O;let A;const E=this.oFormatOptions.bindingContext;const F=d?false:t.test(e);let U=e!==""&&t.getValues(e,_,c,d);let I=true;if(!U){U=[];C="";O=""}else{I=F;C=m?U[0]:U[1];v=m?U[1]:U[0];T=_!==l.Value;O=C||v}const Q=function(o){if(o&&!(o instanceof s)&&!(o instanceof n)){throw o}if(!o._bNotUnique){if(O===""){return null}if(m&&U[0]&&U[1]){return D.call(this,t,e,i,a,c,d,f,g,_,false)}if(f){return x.call(this,i,a,g,e,_,d)}}if(F||N.call(this)){return b.call(this,i,a,g,e,_,d)}throw new s(o.message)};const S=function(i){if(i){const e=[i.key];if(t.valueTypes.length>1&&t.valueTypes[1]!==u.Static){e.push(i.description)}return p.createCondition(t.name,e,i.inParameters,i.outParameters,h.Validated,i.payload)}else if(e===""){return null}else{return Q.call(this,new s(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[e])))}};const B=this._oCalls.last;const j=function(n,o){let a;let l;try{a=o.call(this,n);if(this._isUnit(i)){if(a){if(a.operator!==r.EQ){throw new s("unsupported operator")}const t=i._aCurrentValue&&i._aCurrentValue[0]!==undefined?i._aCurrentValue[0]:null;const e=a.values[0];a.values=[[t,e]]}else if(e===""){a=p.createCondition(t.name,[i.parseValue(e,"string",i._aCurrentValue)],undefined,undefined,h.NotValidated)}}}catch(t){l=t}return w.call(this,a,l,B,false,i)};const k=function(t,e,i,n){let a;try{if(this._isUnit(t)){const t=e&&e.length>1&&e[1]?e[1]:this._getDefaultType();a=t.parseValue(i,"string");t.validateValue(a)}else{a=t.parseValue(i,"string");t.validateValue(a)}}catch(t){if(t&&!(n&&(t instanceof s||t instanceof o))&&i!==""){throw t}a=undefined}return a}.bind(this);const H=k(i,this._getCompositeTypes(),C||O,T);V=H!==undefined;if(T){A=k(a,this._getAdditionalCompositeTypes(),v||O,V);T=A!==undefined}if(!V&&!T){return null}return y.resolve().then(()=>P.call(this,O,H,A,i,a,E,V,T,I)).then(t=>j.call(this,t,S)).catch(t=>j.call(this,t,Q)).unwrap()}function x(t,e,i,n,s,o){const a=this._getDefaultOperator(i,t);let r;if(a&&i.indexOf(a.name)>=0){r=a.getCondition(n,t,l.Value,true,undefined,e,undefined,o);r.validated=h.NotValidated}return r}function b(t,e,i,n,o,a){let r;if(this._isUnit(t)){r=c.getEQOperator()}else if(i.length===1){r=c.getOperator(i[0])}else{r=c.getEQOperator(i);if(i.indexOf(r.name)<0){r=undefined}}if(!r){throw new s("Cannot parse value "+n)}const u=r.getCondition(n,t,l.Value,true,undefined,e,undefined,a);if(u){u.validated=h.NotValidated;if(this._isUnit(t)&&Array.isArray(u.values[0])){u.values[0]=u.values[0][1]}}return u}V.prototype.validateValue=function(t){const e=this._getValueType();const i=this._getOriginalType();const n=this._getOperators();const s=this._isUnit(e);const a=this._isCompositeType(e);const l=this._getCompositeTypes();let r=0;const u=this._getAdditionalValueType();const p=this._getAdditionalCompositeTypes();if(t===undefined||this._bDestroyed){return null}else if(t===null){if(c.onlyEQ(n)){let t=null;try{if(e.hasOwnProperty("_sParsedEmptyString")&&e._sParsedEmptyString!==null){t=e._sParsedEmptyString}e.validateValue(t)}catch(e){if(e instanceof o){try{if(i&&!a){i.validateValue(t)}throw e}catch(t){if(t instanceof o){throw new d(t.message,t.violatedConstraints,null)}throw t}}else{return null}}}return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new d(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof t==="object"?g({},t):t)}let f=c.getOperator(t.operator);if(s){f=c.getEQOperator();r=1}if(!f||n.indexOf(f.name)===-1){throw new d("No valid condition provided, Operator wrong.",undefined,g({},t))}try{f.validate(t.values,e,l,r,u,p)}catch(e){try{if(e instanceof o&&i&&!a){f.validate(t.values,i,l,r,u,p)}throw e}catch(e){if(e instanceof o){throw new d(e.message,e.violatedConstraints,g({},t))}throw e}}};function A(t,e){if(this._isCompositeType(e)){let i;if(t&&t.values[0]){i=t.values[0]}else{i=[]}e._aCurrentValue=g([],i);const n=this._getAdditionalType();if(this._isCompositeType(n)){n._aCurrentValue=g([],i)}const s=this._getOriginalType();if(this._isCompositeType(s)){s._aCurrentValue=g([],i)}}}function E(t){if(this._isCompositeType(t)){const e=this._getAdditionalType();if(this._isCompositeType(e)){if(!e._aCurrentValue){e._aCurrentValue=[]}t._aCurrentValue=e._aCurrentValue}}}function F(){const t=this._getValueHelp();const e=this._getDelegate();return e.isInputValidationEnabled(this.oFormatOptions.control,t)}function N(){const t=this._getValueHelp();const e=this._getDelegate();return e.isInvalidInputAllowed(this,t)}function P(t,e,i,n,o,a,l,r,u){const c=this._getValueHelp();const p=this._getDelegate();const d=this.oFormatOptions.control;const f={value:t,parsedValue:e,parsedDescription:i,dataType:n,bindingContext:a,checkKey:l,checkDescription:r,caseSensitive:u?true:undefined,exception:s,exactMatch:u,control:d};return p.getItemForValue(d,c,f)}function U(t,e,i,n,s){const o=this._getValueHelp();const a=this._getDelegate();const l=this.oFormatOptions.control;return a.getDescription(l,o,t,e.inParameters,e.outParameters,s,undefined,undefined,e.payload,l,i)}function I(t){let e=-1;if(t.startsWith(v)){e=parseInt(t[v.length])}return e}a.call(V.prototype);return V});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ConditionTypeMixin", ["sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/FieldBaseDelegate","sap/ui/model/type/String","sap/ui/core/Element"],(t,e,i,o,s,n)=>{"use strict";return function(){this._sDefaultBaseType=t.String;this._getValueType=function(){let e=this.oFormatOptions.valueType;if(!e){if(this._sDefaultBaseType===t.String){e=this._getDefaultType()}else{throw new Error("Type missing")}}return e};this._getAdditionalValueType=function(){let t=this.oFormatOptions.additionalValueType;if(!t){t=this._getDefaultType()}return t};this._getOriginalType=function(){return this.oFormatOptions.originalDateType};this._getAdditionalType=function(){return this.oFormatOptions.additionalType};this._getDefaultType=function(){if(!this._oDefaultType){this._oDefaultType=new s}return this._oDefaultType};this._getBaseType=function(t){const e=t.getMetadata().getName();const i=t.getFormatOptions();const o=t.getConstraints();return this._getBaseTypeForValueType({name:e,formatOptions:i,constraints:o})};this._getBaseTypeForValueType=function(e){const i=this._getDelegate();const o=this.oFormatOptions.control;let s=i.getTypeMap(o).getBaseType(e.name,e.formatOptions,e.constraints);if(s===t.Unit){s=t.Numeric}return s};this._getMaxConditions=function(){let t=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){t=this.oFormatOptions.maxConditions}return t};this._getMultipleLines=function(){if(this.oFormatOptions.hasOwnProperty("multipleLines")){return this.oFormatOptions.multipleLines}return false};this._getDisplay=function(){let t=this.oFormatOptions.display;if(!t){t=e.Value}return t};this._getKeepValue=function(){if(this.oFormatOptions.hasOwnProperty("keepValue")){return this.oFormatOptions.keepValue}return null};this._getNoFormatting=function(){let t=false;if(this.oFormatOptions.hasOwnProperty("noFormatting")){t=this.oFormatOptions.noFormatting}return t};this._isUnit=function(t){if(this._isCompositeType(t)){const e=t.getFormatOptions();const i=!e||!e.hasOwnProperty("showMeasure")||e.showMeasure;const o=!e||!e.hasOwnProperty("showNumber")||e.showNumber;const s=!e||!e.hasOwnProperty("showTimezone")||e.showTimezone;const n=!e||!e.hasOwnProperty("showDate")||e.showDate;const r=!e||!e.hasOwnProperty("showTime")||e.showTime;if(i&&!o||s&&!n&&!r){return true}}return false};this._isCompositeType=function(t){return t&&t.isA("sap.ui.model.CompositeType")};this._getCompositeTypes=function(){return this.oFormatOptions.compositeTypes};this._getAdditionalCompositeTypes=function(){return this.oFormatOptions.ASdditionalCompositeTypes};this._getOperators=function(){let t=this.oFormatOptions.operators;if(!t||t.length===0){t=i.getOperatorsForType(this._getBaseType(this._getValueType()))}return t};this._getDefaultOperator=function(t,e){const o=this.oFormatOptions.defaultOperatorName;let s;if(o){s=i.getOperator(o)}else{s=i.getDefaultOperator(this._getBaseType(e))}if(s&&t.indexOf(s.name)<0){for(let e=0;e<t.length;e++){s=i.getOperator(t[e]);if(s.exclude||!s.hasRequiredValues()){s=undefined}else{break}}}return s};this._getHideOperator=function(){if(this.oFormatOptions.hasOwnProperty("hideOperator")){return this.oFormatOptions.hideOperator}else{const t=this._getOperators();if(t.length===1){const e=i.getOperator(t[0]);return!e||e.isSingleValue()}else{return false}}};this._fnReturnPromise=function(t){if(t instanceof Promise&&this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(t)}return t};this._getDelegate=function(){let t=this.oFormatOptions.delegate;if(!t){t=o}return t};this._getValueHelp=function(){const t=this.oFormatOptions.valueHelpID;if(t){const e=n.getElementById(t);if(e&&e.isValidationSupported()){return e}}return null}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ConditionsType", ["sap/ui/core/Lib","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionTypeMixin","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/util/merge","sap/ui/base/SyncPromise","sap/ui/core/util/PasteHelper"],(t,e,i,n,o,s,r,a,l,u,p,d,h,c,f,y)=>{"use strict";const g=u.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(i,n){u.apply(this,arguments);this.sName="Conditions";i=m(i);this._oConditionType=new e(i,this.oConstraints);this._oResourceBundle=t.getResourceBundleFor("sap.ui.mdc")}});g.prototype.destroy=function(){u.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined}this._bDestroyed=true};g.prototype.setFormatOptions=function(t){u.prototype.setFormatOptions.apply(this,arguments);t=m(t);if(this._oConditionType){this._oConditionType.setFormatOptions(t)}};function m(t){t=c({},t);if(t.asyncParsing){delete t.asyncParsing}return t}g.prototype.setConstraints=function(t){u.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints)}};g.prototype.formatValue=function(t,e){if(t==undefined||t==null||this._bDestroyed){return null}if(!Array.isArray(t)){throw new p("No valid conditions provided")}let i;if(!e||e==="string"||e==="any"){i=""}else if(e==="float"||e==="int"){i=0}if(this._getNoFormatting()){return this._getKeepValue()||i}const n=this._getMaxConditions();const o=[];const s=function(t,e){return f.resolve().then(()=>this._oConditionType.formatValue(t,e))};if(t.length===0){o.push(s.call(this,null,e))}else{for(let i=0;i<t.length;i++){o.push(s.call(this,t[i],e));if(n>0&&i>=n-1){break}}}return f.all(o).then(t=>_.call(this,t,i)).unwrap()};function _(t,e){for(let i=0;i<t.length;i++){if(e){e=e+this._oResourceBundle.getText("field.SEPARATOR")+t[i]}else if(t[i]){e=t[i]}}return e}g.prototype.parseValue=function(t,e){if(this._bDestroyed){return null}if(this._getNoFormatting()&&t===""){return this.oFormatOptions.getConditions?this.oFormatOptions.getConditions():[]}return this._parseValueToIndex(t,e,-1)};g.prototype._parseValueToIndex=function(t,e,i){const n=this._getValueType();const o=this._getDefaultOperator(this._getOperators(),n);const s=o&&o.name===l.BT;const r=this._getMultipleLines();const u=r||e&&e!=="string"?[[t]]:y.getPastedDataAs2DArray(t);if(u.length>1||u.length===1&&u[0].length>1){const t=s?n:this._getDefaultType();const e=[{property:"value",type:n},{property:"additionalValue",type:t}];return this._fnReturnPromise(y.parse(u,e).then(e=>{if(e.errors){if(e.errors.length===1){throw new d(e.errors[0].message)}else{throw new d(this._oResourceBundle.getText("field.PASTE_ERROR"))}}return Promise.resolve(this._getDelegate().parsePasteDataToConditions(this.oFormatOptions.control,e.parsedData,{defaultOperator:o,valueType:n,additionalValueType:t})).then(t=>{const e=t.map(t=>typeof t==="string"?this._oConditionType._parseValue(t,"string",false,a.Value):t);let n=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();e.forEach((t,e)=>{n=v.call(this,t,n,i>=0?i+e:i,true)});return n})}))}else{return C.call(this,t,e,i)}};function C(t,e,i){const n=function(t,e){return this._oConditionType.parseValue(t,e)};const o=function(t){throw t};return T.call(this,[t],e,i,n,o)}function T(t,e,i,n,o){const s=[];for(let i=0;i<t.length;i++){s.push(n.call(this,t[i],e))}const r=f.all(s).then(t=>{let e=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();for(let n=0;n<t.length;n++){e=v.call(this,t[n],e,i,false);if(i>=0){i++}}return e}).catch(t=>{o.call(this,t)}).unwrap();return this._fnReturnPromise(r)}function v(t,e,i,n){const o=this._isUnit(this.oFormatOptions.valueType);const s=this._getMaxConditions();const r=this._getValueHelp();const a=this._getDelegate();const u=this.oFormatOptions.control;if(s!==1&&this.oFormatOptions.getConditions){if(t){if(this._isCompositeType(this.oFormatOptions.valueType)&&!o&&e.length===1&&(e[0].values[0][0]===null||e[0].values[0][0]===undefined||e[0].values[0][1]===null||e[0].values[0][1]===undefined)&&(t.values[0][0]!==null&&t.values[0][0]!==undefined&&t.values[0][1]!==null&&t.values[0][1]!==undefined)){e.splice(0,1)}if(a.indexOfCondition(u,r,t,e)===-1){if(i>=0&&e.length>i){e.splice(i,0,t)}else{e.push(t)}}else if(!n){throw new d(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[t.values[0]]))}if(s>0&&s<e.length){e.splice(0,e.length-s)}}return e}else if(o&&this.oFormatOptions.getConditions&&e.length>1){const i=t&&t.values[0][1];const n=t&&t.inParameters;const o=t&&t.outParameters;const s=t&&t.payload;for(let r=0;r<e.length;r++){e[r].values[0][1]=i;if(i===undefined){e[r].values[0][0]=t.values[0][0]}e[r].values[0].splice(2);if(e[r].operator===l.BT){e[r].values[1][1]=i;if(i===undefined){e[r].values[1][0]=t.values[0][0]}e[r].values[1].splice(2)}if(n||e[r].inParameters){e[r].inParameters=n}if(o||e[r].outParameters){e[r].outParameters=o}if(s||e[r].payload){e[r].payload=s}}if(e.length===0){e.push(t)}return e}else if(t){return[t]}else{return[]}}g.prototype.validateValue=function(t){if(t===undefined||t===null||this._bDestroyed){return}if(!Array.isArray(t)){throw new o("No valid conditions provided",undefined,undefined,t)}let e;try{for(let i=0;i<t.length;i++){e=t[i];this._oConditionType.validateValue(e)}const i=this._getMaxConditions();if(t.length===0&&i===1){this._oConditionType.validateValue(null)}}catch(i){if(i instanceof o){i.setConditions(t)}else if(i instanceof h){throw new o(i.message,i.violatedConstraints,c({},e))}throw i}};i.call(g.prototype);return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/CustomFieldInfo", ["sap/ui/mdc/field/FieldInfoBase","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver"],(e,t,o)=>{"use strict";const i=e.extend("sap.ui.mdc.field.CustomFieldInfo",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content"}});i._oBox=undefined;i.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new o(n.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oMyBox){this._oMyBox.destroy();this._oMyBox=undefined}};i.prototype.isTriggerable=function(){return Promise.resolve(!!this.getAggregation("content"))};i.prototype.getTriggerHref=function(){return Promise.resolve(null)};i.prototype.getDirectLinkHrefAndTarget=function(){return Promise.resolve(null)};i.prototype.getContent=function(){if(!i._oBox){i._oBox=t.extend("sap.ui.mdc.field.CustomFieldInfoBox",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2,render:function(e,t){const o=t._oInfo.getAggregation("content");e.openStart("div",t);e.openEnd();if(o){e.renderControl(o)}e.close("div")}}})}if(!this._oMyBox||this._oMyBox._bIsBeingDestroyed){this._oMyBox=new i._oBox(this.getId()+"-box");this._oMyBox._oInfo=this}return Promise.resolve(this._oMyBox)};i.prototype.checkDirectNavigation=function(){return Promise.resolve(false)};function n(e){if(e.object==this&&!this._bIsBeingDestroyed){if(e.name=="content"){this.fireDataUpdate()}}}return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/DynamicDateRangeConditionsType", ["sap/ui/core/Lib","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/m/library","sap/base/util/merge"],(e,t,o,i,a,s,n,r,p,u,l,d,c,y,f)=>{"use strict";const h=t.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(t,o){u.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")}});h.prototype.destroy=function(){u.prototype.destroy.apply(this,arguments);this._bDestroyed=true};h.prototype.formatValue=function(e,t){if(e==undefined||e==null||this._bDestroyed){return null}if(!Array.isArray(e)){throw new l("No valid conditions provided")}const o=this._getMaxConditions();let a;if(o!==1){throw new l("MaxConditions must be 1")}if(e.length===1){const t=e[0];const o=i.getOperator(t.operator);if(!t.operator||!o){throw new l("No valid condition provided, Operator wrong.")}const s=[];const u=this._getValueType();const d=this._getBaseType(u);let c=i.getDynamicDateOptionForOperator(o,y.StandardDynamicDateRangeKeys,d);for(let e=0;e<o.valueTypes.length;e++){if(o.valueTypes[e]&&o.valueTypes[e]!==r.Static){if(c){if(o.valueTypes[e]===r.Self){s.push(p.typeToDate(t.values[e],u,d))}else{const i=this._getBaseTypeForValueType(o.valueTypes[e]);if(i===n.Date||i===n.DateTime){s.push(p.typeToDate(t.values[e],T.call(this,o,e),i))}else{s.push(t.values[e])}}}else{s.push(t.values[e])}}}if(!c){c=i.getCustomDynamicDateOptionForOperator(o,d)}a={operator:c,values:s}}return a};h.prototype.parseValue=function(e,t){if(this._bDestroyed){return null}if(this._getMaxConditions()!==1){throw new d("Only one condition supported for parsing")}const o=this._getOperators();const u=[];if(e&&e.operator){if(e.operator==="PARSEERROR"){throw new d(e.values[0])}const t=this._getValueType();const l=e.operator;const c=i.getOperatorForDynamicDateOption(l,this._getBaseType(t));if(c){const d=this._getBaseType(t);const f=[];for(let o=0;o<c.valueTypes.length;o++){if(c.valueTypes[o]&&c.valueTypes[o]!==r.Static){if(y.StandardDynamicDateRangeKeys[l]){if(c.valueTypes[o]===r.Self){f.push(p.dateToType(e.values[o],t,d))}else{const t=c.valueTypes[o]===r.Self?d:this._getBaseTypeForValueType(c.valueTypes[o]);if(t===n.Date||t===n.DateTime){f.push(p.dateToType(e.values[o],T.call(this,c,o),t))}else{f.push(e.values[o])}}}else{f.push(e.values[o])}}}const h=a.createCondition(c.name,f,undefined,undefined,s.NotValidated);i.updateConditionValues(h);i.checkConditionsEmpty(h,o);u.push(h)}}return u};h.prototype.validateValue=function(e){if(e===undefined||e===null||this._bDestroyed){return}if(!Array.isArray(e)){throw new o("No valid conditions provided",undefined,undefined,e)}const t=this._getValueType();const a=this._getOperators();for(const s of e){if(typeof s!=="object"||!s.operator||!s.values||!Array.isArray(s.values)){throw new o(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof s==="object"?f({},s):s,e)}const n=i.getOperator(s.operator);if(!n||a.indexOf(n.name)===-1){throw new o("No valid condition provided, Operator wrong.",undefined,f({},s),e)}try{n.validate(s.values,t)}catch(t){if(t instanceof c){throw new o(t.message,t.violatedConstraints,f({},s),e)}throw t}}};function T(e,t){return e._createLocalType(e.valueTypes[t])}h.prototype._sDefaultBaseType=n.Date;return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBase", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/Control","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/field/content/ContentFactory","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/util/loadModules","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/core/message/MessageMixin","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/restricted/_debounce","sap/ui/dom/containsOrEquals","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/mdc/enums/RequestShowContainerReason"],(t,e,i,n,s,o,a,l,r,h,c,g,u,p,d,f,y,C,m,v,_,F,b,I,T,D,V,P,M,E,O,A,S)=>{"use strict";const{ValueState:H}=C;const{TextAlign:x}=C;const{TextDirection:w}=C;const N=i.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IOverflowToolbarContent","sap.ui.core.ILabelable"],designtime:"sap/ui/mdc/designtime/field/FieldBase.designtime",library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:"sap.ui.model.type.String"},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enums.FieldEditMode",group:"Data",defaultValue:s.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enums.FieldDisplay",defaultValue:o.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:x.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:w.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:H.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true,bindable:"bindable"},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_valueHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"},_operators:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},renderer:r,_oManagedObjectModel:null,_oInvalidInput:null});v.call(N.prototype);const B={onsapup:ht,onsapdown:ht,onsaphome:ht,onsapend:ht,onsappageup:ht,onsappagedown:ht,onsapbackspace:ht,onkeydown:ht,onsapenter:$,onchange:$t,onsapfocusleave:jt,onpaste:z};const L={onsapenter:G};N._init=function(){u._init()};N._init();N.prototype.init=function(){i.prototype.init.apply(this,arguments);this._oObserver=new E(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","valueHelp","ariaLabelledBy"]});this.attachEvent("modelContextChange",this.handleModelContextChange,this);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=this.getContentFactory();this._oCreateContentPromise=undefined;this._oValueHelpRequestPromise=undefined;this._sFilterValue=""};N.prototype.getContentFactory=function(){if(this.isFieldDestroyed()){return}if(!this._oContentFactory){this._oContentFactory=new u(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:bt.bind(this),handleContentChange:Ct.bind(this),handleContentLiveChange:vt.bind(this),handleValueHelpRequest:Dt.bind(this),handleEnter:G.bind(this),handleContentPress:Ft.bind(this)})}return this._oContentFactory};const k=function(t){const e=Vt.call(this);const i=this.getControlForSuggestion();if(this.getEditMode()===s.Editable&&e&&!this._iFocusTimer&&!e.isOpen()&&I(i.getDomRef(),t.target)){e.requestShowTypeahead(S.Focus).then(i=>{if(i){this._iFocusTimer=setTimeout(()=>{if(!this.isFieldDestroyed()&&!e.isOpen()&&Xt.call(this)){Et.call(this,t,true)}this._iFocusTimer=null},300)}})}};const R=function(){if(this._iFocusTimer){clearTimeout(this._iFocusTimer);this._iFocusTimer=null}};N.prototype.exit=function(){R.call(this);const t=this.getFieldInfo();if(t){t.detachEvent("dataUpdate",zt,this)}const e=this.getContent();if(e){st.call(this,e)}const i=this.getContentEdit();if(i){st.call(this,i)}const n=this.getContentDisplay();if(n){st.call(this,n)}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;this._oValueHelpRequestPromise=undefined;const s=Vt.call(this);if(s){if(this._bConnected){Ut.call(this,s);s.connect()}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined}_t.call(this);delete this._fnLiveChangeTimer};N.prototype.applySettings=function(){i.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate()}this.triggerCheckCreateInternalContent();this._bSettingsApplied=true;return this};N.prototype.setProperty=function(t,e,n){if(t==="editMode"){const t=this.getEditMode();if(t!==s.Display&&t!==s.EditableDisplay&&e!==s.Display&&e!==s.EditableDisplay){n=true}}else if(t!=="width"&&t!=="multipleLines"&&t!=="showEmptyIndicator"){n=true}return i.prototype.setProperty.apply(this,[t,e,n])};N.prototype.onBeforeRendering=function(){ot.call(this)};N.prototype.onAfterRendering=function(){};N.prototype.focus=function(t){this._oFocusInfo=t;i.prototype.focus.call(this,t);delete this._oFocusInfo};N.prototype.onfocusin=function(t){this._oFocusInHelp=undefined;qt.call(this);if(t.isMarked("doNotOpenOnFocus")){const t=Vt.call(this);t?.close()}else if(!this._oFocusInfo?.targetInfo?.silent){k.call(this,t)}};N.prototype.onsapfocusleave=function(t){R.call(this);_t.call(this);if(this._aAsyncChanges.length===0&&!this._bPendingChange){this._bDirty=false}};function U(t){const e=t.getParameter("fieldGroupIds");t.cancelBubble();t.preventDefault();const i=e.indexOf(this.getId());if(i>-1){if(this._bPendingChange){const t=Vt.call(this);if(!(t&&Xt.call(t))){const t=Wt.call(this);if(t){j.call(this,undefined,undefined,undefined,t)}else{j.call(this,this.getConditions(),!this.isInvalidInput())}}}if(e.length>1){e.splice(i,1);this.fireValidateFieldGroup({fieldGroupIds:e})}}else{this.fireValidateFieldGroup({fieldGroupIds:e})}}N.prototype.onsapup=function(t){this._handleNavigate(t,-1)};N.prototype.onsapdown=function(t){this._handleNavigate(t,1)};N.prototype.onsaphome=function(t){this._handleNavigate(t,-9999)};N.prototype.onsappageup=function(t){this._handleNavigate(t,-10)};N.prototype.onsappagedown=function(t){this._handleNavigate(t,10)};N.prototype.onsapend=function(t){this._handleNavigate(t,9999)};N.prototype._handleNavigate=async function(t,e){if(this.getEditMode()===s.Editable){const i=Vt.call(this);const n=t.srcControl;if(i){if(i.isNavigationEnabled(e)&&(!this.getContentFactory().isMeasure()||n.getShowValueHelp())){const n=this.getControlForSuggestion();const s=n.hasStyleClass("sapMFocus");const o=i.isOpen();t.preventDefault();t.stopPropagation();if(!o){i.setFilterValue(this._sFilterValue);const e=await i.requestShowTypeahead(S.Navigate);if(!this.isFieldDestroyed()&&!i.isOpen()&&e){await Et.call(this,t,true)}}i.navigate(o&&s&&e===1?0:e)}}}};N.prototype.onsapenter=function(t){const e=Vt.call(this);if(e&&e.isOpen()){e.close()}this._sFilterValue="";if(this._oNavigateCondition){const e=t.srcControl;this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(e.selectText&&e.getDOMValue){e.selectText(e.getDOMValue().length,e.getDOMValue().length)}}};N.prototype.onsapescape=function(t){this.onsapenter(t)};N.prototype._redirectFocus=function(t,e){const i=t.srcControl;if(!A.system.phone&&e.isOpen()&&(!this.getContentFactory().isMeasure()||i.getShowValueHelp&&i.getShowValueHelp())){Zt(i,e)}};N.prototype._requestShowTypeahead=function(t,e){const i=Vt.call(this);const n=this.getControlForSuggestion();if(this.getEditMode()===s.Editable&&i&&I(n.getDomRef(),t.target)){if(!this._bConnected){qt.call(this)}const s=!Xt.call(this);if(!i.isOpen()){i.requestShowTypeahead(e).then(e=>{if(e&&!this.isFieldDestroyed()&&(s||Xt.call(this))&&!i.isOpen()){if(s){n.focus()}Et.call(this,t,true)}})}this._redirectFocus(t,i)}};N.prototype.onkeyup=function(t){if(t.keyCode===O.TAB){this._requestShowTypeahead(t,S.Tab)}};N.prototype.ontap=function(t){if(t.isMarked("tokenTap")||t.getMark("tokenizerMoreIndicatorTap")||t.srcControl.isA("sap.ui.core.Icon")){return}this._requestShowTypeahead(t,S.Tap)};N.prototype.clone=function(t,e){this.detachEvent("modelContextChange",this.handleModelContextChange,this);const n=this.getContent();if(n){st.call(this,n)}const s=this.getContentEdit();if(s){st.call(this,s)}const o=this.getContentDisplay();if(o){st.call(this,o)}const a=this.getFieldInfo();if(a){a.detachEvent("dataUpdate",zt,this)}const l=i.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this.handleModelContextChange,this);if(n){nt.call(this,n)}if(s){nt.call(this,s)}if(o){nt.call(this,o)}if(a){a.attachEvent("dataUpdate",zt,this)}if(this._bTriggerable){l._bTriggerable=this._bTriggerable}return l};N.prototype.getFieldPath=function(){const t=this.getBindingPath("conditions");if(t&&t.startsWith("/conditions/")){return t.slice(12)}else{return""}};function q(t,e,i,n){if(this.getCurrentContent().length>1){this._bPendingChange=true}else{j.call(this,t,e,i,n)}}function j(t,e,i,n){if(!n){if(e){n=Promise.resolve(this.getResultForChangePromise(t))}else{const t=this._getInvalidInputException();if(t){n=Promise.reject(t)}else{n=Promise.reject(i)}}}if(this._aAsyncChanges.length===0){this._bDirty=false}this.fireChangeEvent(t,e,i,n);this._bPendingChange=false}N.prototype.fireChangeEvent=function(t,e,i,n){};function $(t){if(this._oNavigateCondition){t.setMarked("MDCNavigated")}}function G(t){const e=this.getEditMode();if(this._aAsyncChanges.length===0){this._bDirty=false}if(u._getEditable(e)&&(!t.isMarked||!t.isMarked("MDCNavigated"))&&(this.hasListeners("submit")||this._bPendingChange)){let t=Wt.call(this);let e=false;if(t){e=true}else if(this.isInvalidInput()){t=Promise.reject()}else{t=Promise.resolve(this.getResultForChangePromise(this.getConditions()))}if(this._bPendingChange){if(e){j.call(this,undefined,undefined,undefined,t)}else{j.call(this,this.getConditions(),!this.isInvalidInput(),undefined,t)}}this.fireSubmit({promise:t})}}function z(t){const e=this.getMaxConditions();if(e===1){return}const i=t.originalEvent.clipboardData.getData("text/plain");const n=g(i,true);if(n.length<=1){return}const s=t.srcControl;let o;for(const t in s.getMetadata().getAllProperties()){if(s.getBindingPath(t)==="/conditions"){o=t;break}}s.updateModelProperty(o,i,s.getProperty(o));t.stopImmediatePropagation(true);t.preventDefault();t.source=t.srcControl;t.parameters={};const a=this._aAsyncChanges.length;let l;let r;let h;if(a>0){this._aAsyncChanges[a-1].changeFired=true;this._aAsyncChanges[a-1].changeEvent=t;l=this._aAsyncChanges[a-1].promise}else{r=!this._bParseError;h=this.getConditions()}q.call(this,h,r,undefined,l)}N.prototype.initDataType=function(){if(this.getContentFactory().getDataType()){this.getContentFactory().getDataType().destroy();this.getContentFactory().setDataType(undefined)}if(this.getContentFactory().getDateOriginalType()){if(this.getContentFactory().getDateOriginalType()._bCreatedByField){this.getContentFactory().getDateOriginalType().destroy()}this.getContentFactory().setDateOriginalType(undefined)}if(this.getContentFactory().getUnitOriginalType()){if(this.getContentFactory().getUnitOriginalType()._bCreatedByField){this.getContentFactory().getUnitOriginalType().destroy()}this.getContentFactory().setUnitOriginalType(undefined)}this.getContentFactory().setIsMeasure(false)};function Q(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"){return t.getMetadata().getName()}else if(this.bDelegateInitialized){return this.getTypeMap().getDataTypeClassName(this.getDataType())}else{return this.getDataType()}}function W(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getConstraints()){return t.getConstraints()}else{return this.getDataTypeConstraints()}}function K(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getFormatOptions()){return t.getFormatOptions()}else{return this.getDataTypeFormatOptions()}}N.prototype.getBaseType=function(){const t=Q.call(this);const e=W.call(this);const i=K.call(this);const n=this.getTypeMap().getBaseType(t,i,e);return n};function Y(t,e){const i=Vt.call(this);if(i&&this._bConnected){Pt.call(this,t,i)}}N.prototype.getCurrentContent=function(){let t=this.getContent();if(!t){if(this.getEditMode()===s.Display){t=this.getContentDisplay()}else{t=this.getContentEdit()}}if(t){return[t]}else{return this.getAggregation("_content",[])}};N.prototype.handleModelContextChange=function(t){};function J(t){this.setValueState(H.Error);this.setValueStateText(t)}N.prototype._removeUIMessage=function(){this.setValueState(H.None);this.setValueStateText()};N.prototype.observeChanges=function(t){if(t.name==="dataType"){if(this.getContentFactory().getDataType()){const e=function(t){this.getContentFactory().checkDataTypeChanged(t).then(t=>{if(t&&!this.isFieldDestroyed()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}).catch(t=>{throw t})}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{e.call(this,t.current)});return}e.call(this,t.current)}}if(t.name==="dataTypeFormatOptions"||t.name==="dataTypeConstraints"){if(this.getContentFactory().getDataType()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}if(t.name==="maxConditions"){this.updateInternalContent()}if(t.name==="conditions"){this.resetInvalidInput(!this._bKeepValueState);Y.call(this,t.current,t.old);let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){const n=this._aAsyncChanges[i];if(n.waitForUpdate&&_(n.result,t.current)){mt.call(this,n);e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if((t.current.length===0||t.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===s.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate()}}if(t.name==="display"){this.destroyInternalContent();this.getContentFactory().updateConditionType()}if((t.name==="fieldHelp"||t.name==="valueHelp")&&t.ids){It.call(this,t.ids,t.mutation);this.getContentFactory().updateConditionType()}if(t.name==="fieldInfo"&&t.child){Gt.call(this,t.child,t.mutation)}if(t.name==="content"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="contentEdit"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="contentDisplay"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this)}if(t.name==="ariaLabelledBy"&&t.ids){X.call(this,t.ids,t.mutation)}if(t.name==="editMode"){tt.call(this);if(this._bSettingsApplied&&(t.old===s.Display||t.old===s.EditableDisplay||t.current===s.Display||t.current===s.EditableDisplay)){if(this._aCustomControlNames){this.destroyInternalContent()}this.triggerCheckCreateInternalContent()}}};N.prototype.updateInternalContent=function(){if(this.getAggregation("_content",[]).length>0){if(this._aCustomControlNames){this.destroyInternalContent()}ot.call(this);this.getContentFactory().updateConditionType()}};N.prototype.getFocusDomRef=function(){const t=this.getCurrentContent();if(t.length>0){return t[0].getFocusDomRef()}else{return this.getDomRef()}};N.prototype.getIdForLabel=function(){let t;const e=this.getCurrentContent();if(e.length>0){t=e[0].getIdForLabel()}else{t=lt.call(this)}return t};N.prototype.hasLabelableHTMLElement=function(){let t=false;const e=this.getCurrentContent();if(e.length>0&&e[0].hasLabelableHTMLElement){t=e[0].hasLabelableHTMLElement()}else{const e=this.getEditMode();t=e!==s.Display}return t};N.prototype.getEditable=function(){return u._getEditable(this.getEditMode())};N.prototype.getControlForSuggestion=function(){const t=this.getCurrentContent();if(t.length>0){if(this.getContentFactory().isMeasure()&&t.length>1){return t[1]}else{return t[0]}}else{return this}};N.prototype.getFocusElementForValueHelp=function(t){const e=this.getControlForSuggestion();const i=e&&e.getMetadata().getAllPrivateAggregations()._endIcon&&e.getAggregation("_endIcon",[]);let n;if(i){for(let t=0;t<i.length;t++){if(i[t].getVisible()){n=i[t];break}}}return t||!n?e:n};N.prototype.getMaxConditionsForHelp=function(){if(this.getContentFactory().isMeasure()){return 1}else{return this.getMaxConditions()}};N.prototype.getFormFormattedValue=function(){const t=this.getConditions();const i=this.getShowEmptyIndicator()&&t.length===0&&!this.getContent()&&!this.getContentDisplay();if(i){if(!this._oResourceBundleM){this._oResourceBundleM=e.getResourceBundleFor("sap.m")}return this._oResourceBundleM.getText("EMPTY_INDICATOR")}else if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitOriginalType(true)){const e=t.length>0?t[0].values[0]:[0,null];return this.getContentFactory().getUnitOriginalType().formatValue(e,"string")}else if(this.getContentFactory().getDateOriginalType(true)){const e=t.length>0?t[0].values[0]:null;return this.getContentFactory().getDateOriginalType().formatValue(e,"string")}else{const e=this.getContentFactory().getConditionsType();const i=e.getFormatOptions();const n=i.noFormatting;i.noFormatting=false;e.setFormatOptions(i);const s=e.formatValue(t);i.noFormatting=n;e.setFormatOptions(i);return s}};N.prototype.getFormValueProperty=function(){return"conditions"};N.prototype.getFormObservingProperties=function(){return["conditions","editMode"]};N.prototype.getFormRenderAsControl=function(){if(this.getEditMode()===s.Display){const t=this.getCurrentContent();if(t.length===1){if(t[0].getFormRenderAsControl){return t[0].getFormRenderAsControl()}else{return false}}else if(t.length>1){return false}else{return true}}else{return false}};N.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,invalidationEvents:[],propsUnrelatedToSize:["conditions","editMode","display","valueState","valueStateText"]}};N.prototype.enhanceAccessibilityState=function(t,e){const i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(t,e)}};N.prototype.getAccessibilityInfo=function(){const t=this.getCurrentContent();if(t.length===1&&t[0].getAccessibilityInfo){return t[0].getAccessibilityInfo()}else if(t.length>0){return{children:t}}else{return{}}};function X(t,e){const i=this.getAggregation("_content",[]);let n=this.getContent();if(n){i.push(n)}n=this.getContentDisplay();if(n){i.push(n)}n=this.getContentEdit();if(n){i.push(n)}for(let s=0;s<i.length;s++){n=i[s];if(n.getMetadata().getAllAssociations().ariaLabelledBy){if(e==="remove"){n.removeAriaLabelledBy(t)}else if(e==="insert"){n.addAriaLabelledBy(t)}}}}function Z(t,e){const i={aria:{}};const n=Vt.call(this);if(n){const s=n.getAriaAttributes(this.getMaxConditionsForHelp());const o=s.roleDescription;i["role"]=s.role;if(o){i.aria["roledescription"]=o}i.aria["haspopup"]="dialog";i["autocomplete"]="off";if(t){if(s.role){i.aria["expanded"]="true"}i.aria["controls"]=s.contentId;if(e){i.aria["activedescendant"]=e}}else if(s.role){i.aria["expanded"]="false"}i["valueHelpEnabled"]=s.valueHelpEnabled;if(s.autocomplete&&s.autocomplete!=="none"){i.aria["autocomplete"]=s.autocomplete}}this.setProperty("_ariaAttributes",i,true)}N.prototype.connectLabel=function(t){rt.call(this,t);t.bindProperty("text",{path:"$field>/label"});t.setLabelFor(this);return this};function tt(){const e=m.getReferencingLabels(this);for(let i=0;i<e.length;i++){const n=t.getElementById(e[i]);n.setLabelFor(n.getLabelFor());n.invalidate()}}function et(t,e,i){if(e==="remove"){st.call(this,t);gt.call(this,t);if(this.getContentFactory().getContentConditionTypes()){delete this.getContentFactory().getContentConditionTypes()[i]}t.setModel(null,"$field")}else if(e==="insert"){if(!t.isA("sap.ui.core.IFormContent")){throw new Error(t+" is not a valid content! Only use valid content in "+this)}ct.call(this,t,true);nt.call(this,t);if(this.getAggregation("_content",[]).length>0){this.destroyInternalContent()}this.getContentFactory().setNoFormatting(false);this.awaitControlDelegate().then(()=>{if(!this.isFieldDestroyed()){const t=pt.call(this,this.getSupportedOperators());if(t!==this.getContentFactory().getHideOperator()){this.getContentFactory().setHideOperator(t);this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}}});it.call(this,t,i)}}function it(t,e){if(!this.getContentFactory().getContentConditionTypes()){this.getContentFactory().setContentConditionTypes({})}if(!this.getContentFactory().getContentConditionTypes()[e]){this.getContentFactory().getContentConditionTypes()[e]={}}let i;let n;let s=false;for(n in t.getMetadata().getAllProperties()){if(t.getBindingPath(n)==="/conditions"){i=t.getBindingInfo(n);if(i&&i.type&&i.type instanceof c){this.getContentFactory().getContentConditionTypes()[e].oConditionsType=i.type}s=true}if(n==="editable"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getEditable})}if(n==="enabled"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getEnabled})}if(n==="displayOnly"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getDisplayOnly})}if(n==="required"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/required"})}if(n==="textAlign"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textAlign"})}if(n==="textDirection"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textDirection"})}if(n==="valueState"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueState"})}if(n==="valueStateText"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueStateText"})}if(n==="placeholder"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/placeholder"})}if(n==="showValueHelp"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/_valueHelpEnabled"})}if(n==="valueHelpIconSrc"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.setValueHelpIconSrc(this._getValueHelpIcon())}}for(const o in t.getMetadata().getAllAggregations()){if(t.getBindingPath(o)==="/conditions"){i=t.getBindingInfo(o);if(i&&i.template){for(n in i.template.getMetadata().getAllProperties()){const t=i.template.getBindingInfo(n);if(t&&t.type&&t.type instanceof h){this.getContentFactory().getContentConditionTypes()[e].oConditionType=t.type;if(s){this.getContentFactory().setNoFormatting(true)}break}}}}if(o==="tooltip"&&!t.getBindingPath(o)&&!t.getAggregation(o)){t.bindProperty(o,{path:"$field>/tooltip"})}}if(t.getMetadata().getAllAssociations().ariaLabelledBy){this.getContentFactory().setAriaLabelledBy(t)}}function nt(t){if(t.getMetadata().getAllEvents().change){t.attachEvent("change",Ct,this)}if(t.getMetadata().getAllEvents().liveChange){t.attachEvent("liveChange",vt,this)}if(t.getMetadata().getAllEvents().press){t.attachEvent("press",Ft,this)}if(t.getMetadata().getAllEvents().valueHelpRequest){t.attachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getAllEvents().tokenUpdate){t.attachEvent("tokenUpdate",bt,this)}if(t.getMetadata().getAllEvents().validateFieldGroup){t.attachEvent("validateFieldGroup",U,this)}}function st(t){if(t.getMetadata().getAllEvents().change){t.detachEvent("change",Ct,this)}if(t.getMetadata().getAllEvents().liveChange){t.detachEvent("liveChange",vt,this)}if(t.getMetadata().getAllEvents().press){t.detachEvent("press",Ft,this)}if(t.getMetadata().getAllEvents().valueHelpRequest){t.detachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getAllEvents().tokenUpdate){t.detachEvent("tokenUpdate",bt,this)}if(t.getMetadata().getAllEvents().validateFieldGroup){t.detachEvent("validateFieldGroup",U,this)}}function ot(){const t=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{ot.call(this)})}else{at.call(this)}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(()=>{ot.call(this)})}else{t.call(this)}}N.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getVisible()){ot.call(this)}};N.prototype.triggerCheckCreateInternalContent=function(){if(!this._oCheckCreateInternalContentPromise){this._oCheckCreateInternalContentPromise=this.awaitControlDelegate().then(()=>{delete this._oCheckCreateInternalContentPromise;this.checkCreateInternalContent()})}};function at(){if(this.isFieldDestroyed()){return}const t=this.getEditMode();const e=this.getContent();const i=this.getContentEdit();const n=this.getContentDisplay();this.getContentFactory()._setUsedConditionType(e,i,n,t);Tt.call(this,this._getValueHelp());Z.call(this,false);if(e||t===s.Display&&n||t!==s.Display&&i){this.destroyInternalContent();const t=this.getCurrentContent();if(t.length===1){rt.call(this,t[0])}return}const o=this.getMaxConditions();const a=this.getSupportedOperators();const l=this.getAggregation("_content",[]);const r=this.getMultipleLines();const h=this._bTriggerable;const c=this.getContentFactory().getContentType(this.getBaseType(),this.getMaxConditions(),h);const[g]=l;const u=g?.getMetadata().getName().replace(/\./g,"/");const p=this.getContentFactory().getContentMode(c,t,o,r,a);const d=this._aCustomControlNames||c.getControlNames(p,a[0]);const[f]=d;if(f!==u){this.getContentFactory().setHideOperator(pt.call(this,a));if(g){this.destroyInternalContent();if(g.isA("sap.m.DateTimeField")){this.initDataType()}this.getContentFactory().updateConditionType()}const i=!this._getValueHelp()&&this.getContentFactory().getProvideDefaultValueHelp(c,a,t,o,pt.call(this,a));if(!i&&this._sDefaultValueHelp){delete this._sDefaultValueHelp}const n=lt.call(this);const s=this.getControlDelegate();this._oCreateContentPromise=s.createContent(this,p,n,i);this._oCreateContentPromise.then(t=>{delete this._oCreateContentPromise;for(const i of t){if(i.isA("sap.ui.mdc.ValueHelp")){this._sDefaultValueHelp=i.getId();if(!i.getControl()){i.connect(this)}this.getContentFactory().updateConditionType();ut.call(this,this._sDefaultValueHelp);Z.call(this,false);continue}if(!i._bByContentFactory){if(!i.isA("sap.ui.core.IFormContent")){throw new Error(e+" is not a valid content! Only use valid content in "+this)}if(!this._aCustomControlNames){this._aCustomControlNames=[]}this._aCustomControlNames.push(i.getMetadata().getName().replace(/\./g,"/"));it.call(this,i,"_content");this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}i.attachEvent("parseError",dt,this);i.attachEvent("validationError",ft,this);i.attachEvent("validationSuccess",yt,this);i.attachEvent("validateFieldGroup",U,this);ct.call(this,i,c.getUseDefaultEnterHandler());rt.call(this,i);this.addAggregation("_content",i)}tt.call(this)}).catch(t=>{delete this._oCreateContentPromise;throw t})}}function lt(){return this.getId()+"-inner"}N.prototype.destroyInternalContent=function(){this.destroyAggregation("_content");if(this.getContentFactory().getDateOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getDateOriginalType());this.getContentFactory().setDateOriginalType(undefined)}else if(this.getContentFactory().getUnitOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getUnitOriginalType());this.getContentFactory().setUnitOriginalType(undefined)}if(this.isInvalidInput()){this.resetInvalidInput(true)}if(this.getContentFactory().isMeasure()){this.getContentFactory().setIsMeasure(false)}delete this._aCustomControlNames;if(this.getContentFactory().getContentConditionTypes()?.["_content"]){delete this.getContentFactory().getContentConditionTypes()["_content"]}};function rt(t){if(!this._oManagedObjectModel&&!this.isFieldDestroyed()){this._oManagedObjectModel=new M(this)}t.setModel(this._oManagedObjectModel,"$field")}function ht(t){let e=false;const i=Vt.call(this);if(!i){return}else{switch(t.type){case"sapup":e=i.isNavigationEnabled(-1);break;case"sapdown":e=i.isNavigationEnabled(1);break;case"saphome":e=i.isNavigationEnabled(-9999);break;case"sapend":e=i.isNavigationEnabled(9999);break;case"sappageup":e=i.isNavigationEnabled(-10);break;case"sappagedown":e=i.isNavigationEnabled(10);break;case"sapbackspace":this._bPreventAutocomplete=true;break;case"keydown":if(t.which!==O.BACKSPACE&&t.which!==O.DELETE){this._bPreventAutocomplete=false}break;default:e=i.isOpen();break}}if(e){t.stopPropagation();t.stopImmediatePropagation(true);switch(t.type){case"sapup":this.onsapup(t);break;case"sapdown":this.onsapdown(t);break;case"saphome":this.onsaphome(t);break;case"sapend":this.onsapend(t);break;case"sappageup":this.onsappageup(t);break;case"sappagedown":this.onsappagedown(t);break;default:break}}}function ct(t,e){t.addDelegate(B,true,this);if(e){t.addDelegate(L,false,this)}}function gt(t){t.removeDelegate(B);t.removeDelegate(L)}function ut(t){It.call(this,t,"insert")}function pt(t){if(t.length===1){const e=p.getOperator(t[0]);return!e||e.isSingleValue()}else{return false}}N.prototype._setInvalidInput=function(t,e,i,n){const s=n?n.getId():this.getId();if(!this._oInvalidInput){this._oInvalidInput={}}this._oInvalidInput[s]={exception:t,value:e,reason:i}};N.prototype._getInvalidInputException=function(t){let e;if(this._oInvalidInput){if(t){if(this._oInvalidInput[t.getId()]){return this._oInvalidInput[t.getId()].exception}else if(this._oInvalidInput[this.getId()]){return this._oInvalidInput[this.getId()].exception}}else{for(const t in this._oInvalidInput){e=this._oInvalidInput[t].exception;if(e){break}}}}return e};N.prototype.resetInvalidInput=function(t){if(this._oInvalidInput){this._oInvalidInput=null;if(t){this._removeUIMessage()}}};N.prototype.isInvalidInput=function(){return!!this._oInvalidInput};N.prototype._isInvalidInputForContent=function(t){return this._oInvalidInput&&(this._oInvalidInput[t.getId()]||this._oInvalidInput[this.getId()])};function dt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ParseError",n);this._sFilterValue="";const s=n.getBinding("valueState");if(s&&s.getBindingMode()===T.OneWay){J.call(this,t.getParameter("message"))}}function ft(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ValidationError",n);this._sFilterValue="";const s=i&&i instanceof f&&i.getConditions();let o=false;let a=0;for(a=0;a<this._aAsyncChanges.length;a++){const n=this._aAsyncChanges[a];if(n.waitForUpdate&&Array.isArray(n.result)){if(n.result.length===0&&e===""){n.reject(t.getParameter("exception"));o=true;break}else if(_(n.result,s)){n.reject(i);o=true;break}}}if(o){this._aAsyncChanges.splice(a,1)}const l=n.getBinding("valueState");if(l&&l.getBindingMode()===T.OneWay){J.call(this,t.getParameter("message"))}}function yt(t){const e=t.getSource();if(this._isInvalidInputForContent(e)){const t=e.getBinding("valueState");let i=false;if(t&&t.getBindingMode()===T.OneWay){i=true}this.resetInvalidInput(i)}}function Ct(t){const e={parameters:F({},t.getParameters()),source:t.getSource()};const i=this._aAsyncChanges.length;if(i>0&&!this._aAsyncChanges[i-1].changeFired){this._aAsyncChanges[i-1].changeFired=true;this._aAsyncChanges[i-1].changeEvent=e;q.call(this,undefined,undefined,undefined,this._aAsyncChanges[i-1].promise);return}const n={changeEvent:e};mt.call(this,n)}function mt(e){const i=this.getConditions();let n=true;let s;const o=e.changeEvent.source;if(e.changeEvent.parameters.hasOwnProperty("valid")){n=e.changeEvent.parameters["valid"]}else if(this.isInvalidInput()){n=false}if(!n&&e.changeEvent.parameters.hasOwnProperty("value")){s=e.changeEvent.parameters["value"]}const a=Vt.call(this);if(a&&this._bConnected){if(t.getActiveElement()===o){a.close()}this._sFilterValue="";if(n){Pt.call(this,i,a);a.onControlChange()}_t.call(this)}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();const t=o.getDOMValue?.();if(o.selectText&&t){o.selectText(t.length,t.length)}}if(e.resolve){Kt.call(this,e)}else{q.call(this,i,n,s)}}function vt(t){let e;let i;let n=false;const s=t.getSource();if("value"in t.getParameters()){e=t.getParameter("value")}else if("newValue"in t.getParameters()){e=t.getParameter("newValue")}if("escPressed"in t.getParameters()){n=t.getParameter("escPressed")}const o=Vt.call(this);if(this._oNavigateCondition){o.setHighlightId();this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(this.getMaxConditionsForHelp()===1){o.setConditions([])}}if("previousValue"in t.getParameters()){i=t.getParameter("previousValue")}else{const t=this.getConditions();i=t[0]&&t[0].values[0]}if(o&&(!this.getContentFactory().isMeasure()||s.getShowValueHelp())){if(n){Pt.call(this,this.getConditions(),o);if(o.isOpen()){o.close();_t.call(this);this._sFilterValue=""}}else{const t=this.getSupportedOperators();let i=false;for(let e=0;e<t.length;e++){const n=p.getOperator(t[e]);if(n.validateInput){i=true;break}}if(i){this._bIgnoreInputValue=false;this._vLiveChangeValue=e;if(!this._fnLiveChangeTimer){R.call(this);this._fnLiveChangeTimer=b(()=>{const e=this.getDisplay();if(typeof this._vLiveChangeValue!=="undefined"){this._sFilterValue=""}if(this._vLiveChangeValue){const i=p.getEQOperator(t);const n=this.getContentFactory().getHideOperator();const s=n?false:i.test(this._vLiveChangeValue);const o=i.getValues(this._vLiveChangeValue,e,true,n);if(o){if(o[0]){this._sFilterValue=o[0]}else if(o[1]){this._sFilterValue=o[1]}}else{this._sFilterValue=""}if(s){this._bPreventAutocomplete=true}}const i=function(){if(Xt.call(this)){const t=o.isOpen();if(this.getMaxConditionsForHelp()===1&&o.getConditions().length>0){o.setConditions([])}o.setFilterValue(this._sFilterValue);if(!t){o.open(true)}else{Ot.call(this,false)}delete this._vLiveChangeValue}}.bind(this);if(this._bConnected&&this.getCurrentContent()[0]){o.requestShowTypeahead(S.Typing).then(t=>!!t&&i());delete this._vLiveChangeValue}},300,{leading:false,trailing:true})}o.requestShowTypeahead(S.Typing).then(t=>{if(Xt.call(this)&&this._fnLiveChangeTimer){this._fnLiveChangeTimer()}});this._fnLiveChangeTimer()}}}this._bDirty=true;this.fireLiveChange({value:e,escPressed:n,previousValue:i})}function _t(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue}}function Ft(t){const e=this.getFieldInfo();if(e){e.getTriggerHref().then(i=>{if(!i){e.open(this.getCurrentContent()[0],t);Z.call(this,true)}})}this.firePress()}function bt(t){if(t.getParameter("type")==="removed"){const e=t.getParameter("removedTokens");let i=this.getConditions();let n;let s;let o;for(o=0;o<e.length;o++){const t=e[o];const{sPath:n}=t.getBindingContext("$field");const s=parseInt(n.slice(n.lastIndexOf("/")+1));i[s].delete=true}for(o=i.length-1;o>=0;o--){if(i[o].delete){if(this.getContentFactory().isMeasure()){n=i[o].values[0][1];s=i[o].payload}i.splice(o,1)}}if(this.getContentFactory().isMeasure()&&n&&i.length===0){i=[d.createItemCondition([undefined,n],undefined,undefined,undefined,s)]}const a=Vt.call(this);let l;if(a?.isOpen()){l=new Promise((t,e)=>{setTimeout(()=>{this.setProperty("conditions",i,true);t(this.getResultForChangePromise(i))},0)})}else{this.setProperty("conditions",i,true)}j.call(this,i,true,undefined,l);t.preventDefault(true)}}function It(e,i){let n;if(i==="remove"){n=t.getElementById(e);if(n){Ut.call(this,n)}this.resetProperty("_valueHelpEnabled")}else if(i==="insert"){if(this._sDefaultValueHelp&&e!==this._sDefaultValueHelp){It.call(this,this._sDefaultValueHelp,"remove");delete this._sDefaultValueHelp}Tt.call(this,e);const t=this.getCurrentContent()[0];if(t&&t.setValueHelpIconSrc){t.setValueHelpIconSrc(this._getValueHelpIcon())}}Y.call(this,this.getConditions())}function Tt(e){if(e&&this.isPropertyInitial("_valueHelpEnabled")){const i=t.getElementById(e);if(i){if(i.getIcon()){this.setProperty("_valueHelpEnabled",true,true)}}}}async function Dt(t){if(await(Vt.call(this)?.requestShowValueHelp())){Et.call(this,t,false)}}N.prototype._getValueHelp=function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()};function Vt(){let e=this._getValueHelp();let i;if(!e&&this._sDefaultValueHelp){e=this._sDefaultValueHelp}if(e){i=t.getElementById(e)}return i}function Pt(t,e){if(!e){e=Vt.call(this)}let i;if(this.isInvalidInput()&&this.getMaxConditionsForHelp()===1){i=[]}else if(this.getContentFactory().isMeasure()){i=[];for(const e of t){if(e.values[0]&&e.values[0][1]){const t=d.createItemCondition(e.values[0][1],undefined,e.inParameters,e.outParameters,e.payload);i.push(t)}}}else{i=t}e.setConditions(i)}function Mt(){const t=this.getFormattingPromise();const e=t&&!this.getBusy();if(e){this.setBusy(true)}return t?.finally(()=>{if(e){this.setBusy(false)}})}async function Et(t,e){const i=Vt.call(this);if(i&&!this._oValueHelpRequestPromise){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.flush()}this._oValueHelpRequestPromise=Mt.call(this);await this._oValueHelpRequestPromise;if(!this.isFieldDestroyed()){if(!i.isOpen()){const e=t.getParameter?.("fromKeyboard");const n=i.isFocusInHelp();const s=this.getMaxConditionsForHelp();const o=t.srcControl||t.getSource();i.setFilterValue(this._sFilterValue);let a;if(this._oNavigateCondition&&s===1){a=[this._oNavigateCondition]}else if(this._bDirty&&s===1){a=[]}else{a=this.getConditions()}if(e&&this._sFilterValue&&!n){this._sFilterValue="";const t=o.getDOMValue?.();if(o.selectText&&t){o.selectText(0,t.length)}}Pt.call(this,a,i);this._bFocusOnValueHelp=e&&!n;if(!n){if(o.bValueHelpRequested){o.bValueHelpRequested=false}}}i.toggleOpen(!!e);this._oValueHelpRequestPromise=undefined}}}function Ot(t){this.getCurrentContent().forEach(e=>{if(e.closeValueStateMessage&&!t){e.closeValueStateMessage()}if(e.setShowValueStateMessage){e.setShowValueStateMessage(t)}})}function At(t){let e=this.getConditions();const i=t.getParameter("conditions");const n=t.getParameter("add");const s=t.getParameter("close");const o=t.oSource;const r=this.getMaxConditions();let h;const c=this.getControlForSuggestion();let g;let u=0;const f=this.getControlDelegate();if(this.getContentFactory().isMeasure()){if(i.length>1){throw new Error("Only one item must be selected! "+this)}if(i[0].operator!==l.EQ){throw new Error("Only EQ allowed! "+this)}if(e.length>0){for(u=0;u<e.length;u++){e[u].values[0][1]=i[0].values[0];if(e[u].operator===l.BT){e[u].values[1][1]=i[0].values[0]}if(i[0].inParameters){e[u].inParameters=i[0].inParameters}if(i[0].outParameters){e[u].outParameters=i[0].outParameters}if(i[0].payload){e[u].payload=i[0].payload}}}else{const t=p.getEQOperator(this.getSupportedOperators());const n=[null,i[0].values[0]];h=d.createCondition(t.name,[n],i[0].inParameters,i[0].outParameters,a.NotValidated,i[0].payload);e.push(h);const s=this.getContentFactory().getConditionType(true);const o=this.getContentFactory().getUnitConditionsType(true);if(s){g=s.formatValue(h)}else if(o){g=o.formatValue(e)}}}else{if(!n){e=[]}for(u=0;u<i.length;u++){h=i[u];if(!Jt.call(this,h.operator)){continue}const t=f.indexOfCondition(this,o,h,e);if(t===-1){e.push(h)}else if(h.validated===a.Validated&&h.values.length>1&&(e[t].values.length===1||h.values[1]!==e[t].values[1])){e[t].values=h.values}}}if(r>0&&r<e.length){e.splice(0,e.length-r)}let y=false;if(c&&c.setDOMValue){if(this.getMaxConditionsForHelp()===1&&e.length>0){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)){g=this.getContentFactory().getUnitConditionsType().formatValue(e)}else if(this.getContentFactory().getConditionType(true)){g=this.getContentFactory().getConditionType().formatValue(e[0])}else if(this.getContentFactory().getConditionsType(true)){g=this.getContentFactory().getConditionsType().formatValue(e)}const t=function(t){const i=c.getDOMValue();c.setDOMValue("");c.setDOMValue(t);if(i!==t&&r===1){this.fireLiveChange({value:e[0].values[0]})}}.bind(this);if(g instanceof Promise){g.then(e=>{t(e)})}else{t(g)}this._sFilterValue=""}else if(s){c.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false;this._oFocusInHelp=undefined}else{this._bIgnoreInputValue=true}if(this.isInvalidInput()){this.resetInvalidInput(true);y=true}}const C=this.getConditions();if(!_(e,C)){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();this.setProperty("conditions",e,true);if(!p.compareConditionsArray(e,C)){o.onControlChange();q.call(this,e,true)}}else if(y){q.call(this,e,true)}}function St(t){let e=t.getParameter("value");let i=t.getParameter("key");let n=t.getParameter("condition");let s=t.getParameter("itemId");const a=t.getParameter("leaveFocus");const l=t.getParameter("caseSensitive");if(!n&&i){n=d.createItemCondition(i,e)}let r;const h=this.getControlForSuggestion();const c=Vt.call(this);const g=c.isOpen();const u=this._vLiveChangeValue||this._sFilterValue;if(a){Zt(h,c);h.focus();if(u&&this._oNavigateCondition&&h.getDOMValue&&h.getDOMValue()!==this._oNavigateCondition.output){wt.call(this,this._oNavigateCondition,u,h,l);s=this._oNavigateCondition.itemId;this.fireLiveChange({value:this._oNavigateCondition.output})}Z.call(this,g,s);return}this._oNavigateCondition=xt.call(this,n,s);if(this._oNavigateCondition&&this.getMaxConditionsForHelp()===1){[i,e]=this._oNavigateCondition.values;c.setConditions([n])}this._bPreventGetDescription=true;this.getContentFactory().updateConditionType();if(this.getDisplay()!==o.Value){r=i}else if(e){r=e}else{r=i}if(h&&h.setDOMValue){let t;if(u&&this._oNavigateCondition){t=wt.call(this,this._oNavigateCondition,u,h,l);if(t){this._oNavigateCondition.output=t}}if(!t){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)&&this._oNavigateCondition){t=this.getContentFactory().getUnitConditionsType().formatValue([this._oNavigateCondition])}else if(this.getContentFactory().getConditionType(true)&&this._oNavigateCondition){t=this.getContentFactory().getConditionType().formatValue(this._oNavigateCondition)}else if(this.getContentFactory().getConditionsType(true)&&this._oNavigateCondition){t=this.getContentFactory().getConditionsType().formatValue([this._oNavigateCondition])}else{t=e||i}h.setDOMValue(t);if(h._doSelect){h._doSelect()}}if(c.isOpen()&&h.hasStyleClass("sapMFocus")){te(h,c)}}this._bPreventGetDescription=false;this.getContentFactory().updateConditionType();Z.call(this,g,s);this._bIgnoreInputValue=false;this._bDirty=true;this._oFocusInHelp=undefined;this.fireLiveChange({value:r})}function Ht(t){const e=t.getParameter("condition");const i=t.getParameter("filterValue");const n=t.getParameter("itemId");const s=t.getParameter("items");const o=t.getParameter("caseSensitive");const a=this.getControlForSuggestion();const l=this._vLiveChangeValue||this._sFilterValue;if(Xt.call(this)&&!this._bPreventAutocomplete&&e&&l===i&&a&&a.setDOMValue&&a.selectText&&(!a.isComposingCharacter||!a.isComposingCharacter())){const t=this.getContentFactory();const s=wt.call(this,e,i,a,o);if(s){const i=Vt.call(this);if(i?.isOpen()){Zt(a,i);i.setHighlightId(!this._bPreventAutocomplete&&n)}this._oNavigateCondition=xt.call(this,e,n);this._oNavigateCondition.output=s;t.updateConditionType();Z.call(this,true,null)}}if(a?._applySuggestionAcc){a._applySuggestionAcc(s)}}function xt(t,e){const i=p.getEQOperator(this.getSupportedOperators());let n;if(t){n=F({},t);n.operator=i.name;const s=t.values[0];if(this.getContentFactory().isMeasure()){const t=this.getConditions();if(t.length>0){n.operator=t[0].operator;n.values[0]=[t[0].values[0][0],s];if(t[0].operator===l.BT){n.values[1]=[t[0].values[1][0],n.values[0][1]]}else if(n.values.length>1){n.values.splice(1)}}else{n.values=[[null,s]]}}n.itemId=e}return n}function wt(t,e,i,n){const s=this.getContentFactory();const o=s.isMeasure();const a=this.getControlDelegate();let l;const r=s.getAdditionalDataType();if(o){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){l=t[1]}}else{l=s.getDataType()}let h;let c;if(l){h=l.formatValue(t.values[0],"string")}else{h=t.values[0]}if(t.values.length>1){if(r){c=r.formatValue(t.values[1],"string")}else{c=t.values[1]}}const g=!!h&&a.isInputMatchingText(this,e,h,false,n);const u=!!c&&a.isInputMatchingText(this,e,c,true,n);let p=a.getAutocompleteOutput(this,t,h,c,g,u);if(p){p=typeof p==="string"?e+p.substr(e.length):e;i.setDOMValue(p);i.focus();i.selectText(e.length,p.length)}return p}function Nt(t){const e=this.getControlForSuggestion();if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;e.setDOMValue("");this._sFilterValue="";this.getContentFactory().updateConditionType();if(this.getMaxConditions()!==1){this._oManagedObjectModel.checkUpdate(true)}}Ot.call(this,true);Z.call(this,false);const i=t.getSource();if(!this._oNavigateCondition){const t=this.getConditions();Pt.call(this,t,i)}if(Xt.call(this)){Zt(e,i)}else if(this._oFocusInHelp){e.onsapfocusleave(this._oFocusInHelp)}delete this._bFocusOnValueHelp}function Bt(t){let e;const i=this.getControlForSuggestion();if(this._bFocusOnValueHelp){const n=t.getSource();te(i,n);if(this.getMaxConditionsForHelp()===1||this._sFilterValue){e=t.getParameter("itemId")}if(!this._sFilterValue&&!this._oNavigateCondition&&(this._bDirty||this.getConditions().length===0)){n.navigate(0)}}Z.call(this,true,e);Ot.call(this,false);delete this._bFocusOnValueHelp;const n=t.getParameter("items");if(n&&i?._applySuggestionAcc){i._applySuggestionAcc(n)}}function Lt(t){const e=this.getControlForSuggestion();te(e)}function kt(t){const e=this.getControlForSuggestion();e.focus();if(e.fireValueHelpRequest){e.bValueHelpRequested=true;e.fireValueHelpRequest()}}function Rt(t){const e=Vt.call(this);Ut.call(this,e)}function Ut(t){if(this._bConnected){t.detachEvent("select",At,this);t.detachEvent("navigated",St,this);t.detachEvent("disconnect",Rt,this);t.detachEvent("afterClose",Nt,this);t.detachEvent("switchToValueHelp",kt,this);t.detachEvent("closed",Nt,this);t.detachEvent("opened",Bt,this);t.detachEvent("typeaheadSuggested",Ht,this);t.detachEvent("visualFocusSet",Lt,this);this._bConnected=false}}function qt(){const t=Vt.call(this);if(t){let e;const i=this.getContentFactory().isMeasure();if(i){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){e=t[1]}}else{e=this.getContentFactory().getDataType()}const n={maxConditions:this.getMaxConditions(),dataType:e,additionalDataType:this.getContentFactory().getAdditionalDataType(),operators:this.getSupportedOperators(),display:i?o.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};t.connect(this,n);if(!this._bConnected){this._bConnected=true;t.attachEvent("select",At,this);t.attachEvent("navigated",St,this);t.attachEvent("disconnect",Rt,this);t.attachEvent("afterClose",Nt,this);t.attachEvent("switchToValueHelp",kt,this);t.attachEvent("closed",Nt,this);t.attachEvent("opened",Bt,this);t.attachEvent("typeaheadSuggested",Ht,this);t.attachEvent("visualFocusSet",Lt,this);const e=this.getConditions();Pt.call(this,e,t);if(t._bIsDefaultHelp){this.getContentFactory().updateDefaultValueHelpTitle(t,this.getLabel())}}}}function jt(e){const i=Vt.call(this);const n=this.getCurrentContent();const s=this.getControlForSuggestion();const o=e.srcControl;if(n.length>1||i&&s===o){const a=t.getElementById(e.relatedControlId);if(a){if(n.indexOf(a)>=0){e.stopPropagation();R.call(this);_t.call(this)}else if(i&&s===o){if(I(i.getDomRef(),a.getFocusDomRef())){e.stopPropagation();e.stopImmediatePropagation(true);if(s.bValueHelpRequested){s.bValueHelpRequested=false}if(this._sFilterValue){s.setDOMValue(this._sFilterValue)}this._oFocusInHelp=e}else{i.skipOpening()}}}}}function $t(t){if(Vt.call(this)){t.stopImmediatePropagation(true)}}N.prototype._getValueHelpIcon=function(){const t=Vt.call(this);if(t){return t.getIcon()}};function Gt(t,e){if(e==="remove"){t.detachEvent("dataUpdate",zt,this)}else if(e==="insert"){t.attachEvent("dataUpdate",zt,this);zt.call(this)}}function zt(){const t=this.getFieldInfo();const e=this;t.isTriggerable().then(i=>{e._bTriggerable=i;let n=e.getAggregation("_content",[]);if(n.length>0&&e.getEditMode()===s.Display){ot.call(e);if(e._bTriggerable){n=e.getAggregation("_content",[]);const i=n[0];t.getDirectLinkHrefAndTarget().then(t=>{u._updateLink(i,t)})}}})}N.prototype.getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Qt.bind(this)}return{valueType:this.getContentFactory().retrieveDataType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().getUnitType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getContentFactory().isMeasure()?o.Value:this.getDisplay(),valueHelpID:this.getContentFactory().isMeasure()?undefined:this._getValueHelp()||this._sDefaultValueHelp,operators:this.getSupportedOperators(),hideOperator:this.getContentFactory().getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===s.Display||this.getMaxConditions()!==1,control:this,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null,getConditions:this.getConditions.bind(this),noFormatting:this.getContentFactory().getNoFormatting(),keepValue:this._bIgnoreInputValue?this._sFilterValue:null,multipleLines:this.getMultipleLines()}};N.prototype.checkValueInitial=function(t){if(t===null||t===undefined){return true}if(t===""||typeof t==="string"&&t.match(/^0+$/)){const e=this.getContentFactory().retrieveDataType();const i=e.parseValue("","string");if(i===t){return true}else{try{e.validateValue(i)}catch(t){return true}}}else{const e=Q.call(this);if(this.getTypeMap().getBaseType(e)===n.Unit&&Array.isArray(t)&&t.length>1&&(t[0]===undefined||t[0]===null)&&!t[1]){return true}}return false};N.prototype.getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Qt.bind(this)}return{valueType:this.getContentFactory().getUnitType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().retrieveDataType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getDisplay(),valueHelpID:this._getValueHelp()||this._sDefaultValueHelp,operators:[l.EQ],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===s.Display||this.getEditMode()===s.EditableDisplay,control:this,getConditions:this.getConditions.bind(this),noFormatting:false,multipleLines:false}};function Qt(t){const e=Vt.call(this);if(e&&e.isOpen()&&(Xt.call(this)||Xt.call(e))){e.close()}const i={};const n=new Promise((e,n)=>{i.resolve=e;i.reject=n;t.then(t=>{i.result=t;this.resetInvalidInput();const e=this.getConditions();if(_(t,e)){Kt.call(this,i);Yt.call(this,i)}else{i.waitForUpdate=true}}).catch(t=>{if(t&&!(t instanceof V)&&!(t instanceof D)&&!(t instanceof P)){throw t}const e=this.getControlForSuggestion();this._setInvalidInput(t,undefined,"AsyncParsing",e);n(t);Yt.call(this,i)})});i.promise=n;this._aAsyncChanges.push(i)}function Wt(){const t=[];for(let e=0;e<this._aAsyncChanges.length;e++){t.push(this._aAsyncChanges[e].promise)}if(t.length>0){return Promise.all(t).then(()=>this.getResultForChangePromise(this.getConditions()))}return null}N.prototype.getResultForChangePromise=function(t){return t};function Kt(t){if(this._aAsyncChanges.length<=1){this._bDirty=false}t.resolve(this.getResultForChangePromise(t.result))}function Yt(t){let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(t===this._aAsyncChanges[i]){e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if(this._aAsyncChanges.length===0){this._bDirty=false}return e}N.prototype.getSupportedOperators=function(){let t;if(this.isSearchField()){t=[l.Contains]}else{let e=this.getBaseType();if(e===n.Unit){e=n.Numeric}t=p.getOperatorsForType(e)}this.setProperty("_operators",t,true);return t};N.prototype.isSearchField=function(){{let t=false;const e=this.getFieldPath();if(e){const i=new RegExp("^\\*(.*)\\*|\\$search$");t=i.test(e)&&this.getMaxConditions()===1}return t}};function Jt(t){const e=this.getSupportedOperators();for(let i=0;i<e.length;i++){if(t===e[i]){return true}}return false}N.prototype.isFieldPropertyInitial=function(t){if(this.isBound(t)&&!this.getBinding(t)){return!Object.hasOwn(this.mProperties,t)}else{return this.isPropertyInitial(t)}};N.prototype.isFieldDestroyed=function(){return this.isDestroyed()||this.isDestroyStarted()};N.prototype.hasPendingUserInput=function(){return!!this._bDirty};N.prototype.getAdditionalDataTypeConfiguration=function(){return null};N.prototype.getFormattingPromise=function(){return undefined};function Xt(){const t=document.activeElement;return t&&I(this.getDomRef(),t)}function Zt(t,e){t.addStyleClass("sapMFocus");e?.removeVisualFocus()}function te(t,e){t.removeStyleClass("sapMFocus");e?.setVisualFocus()}return N});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBaseDelegate", ["sap/ui/mdc/BaseDelegate","sap/ui/mdc/DefaultTypeMap","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay","sap/ui/model/FormatException","sap/ui/mdc/enums/OperatorName"],(e,t,n,i,a,o,r,u)=>{"use strict";const s=Object.assign({},e);s.createContent=function(e,t,n,i){const a=e.getContentFactory().getContentType(e.getBaseType(),e.getMaxConditions(),e._bTriggerable);return e.getContentFactory().createContent(a,t,n,i)};s.getTypeMap=function(){return t};s.createConditionPayload=function(e,t,n){return undefined};s.createCondition=function(e,t,i,o){const r=n.createItemCondition(i[0],i[1],undefined,undefined,this.createConditionPayload(e,t,i));r.validated=a.Validated;return r};s.parsePasteDataToConditions=function(e,t,i){const{defaultOperator:o}=i;const r=[];const s=o?.name===u.BT;for(let e=0;e<t.length;e++){const i=t[e];if(i.value||s){r.push(n.createCondition(o.name,s?[i.value,i.additionalValue]:[i.value],undefined,undefined,a.NotValidated,undefined))}else if(i.additionalValue){r.push(i.additionalValue)}}return r};s.isInputValidationEnabled=function(e,t){if(t&&t.isValidationSupported()){return true}else{return false}};s.isInvalidInputAllowed=function(e,t){if(t){return!t.getValidateInput()}else{return true}};s.getItemForValue=function(e,t,n){if(t){return t.getItemForValue(n)}};s.getDescription=function(e,t,n,i,a,o,u,s,d,l,c){const f={value:n,parsedValue:n,parsedDescription:undefined,dataType:c,context:{inParameters:i,outParameters:a,payload:d},bindingContext:o,checkKey:true,checkDescription:false,caseSensitive:true,exception:r,exactMatch:true,control:l};return t&&t.getItemForValue(f)};s.isInputMatchingText=function(e,t,n,i,a){if(a){return n.normalize().startsWith(t.normalize())}return n.normalize().toLowerCase().startsWith(t.normalize().toLowerCase())};s.getAutocompleteOutput=function(e,t,n,i,a,r){const u=e.getDisplay();let s;if(u===o.Value){if(a){s=n}}else if(u===o.Description){if(r){s=i}}else if(u===o.ValueDescription){if(a){s=n}else if(r){s=i}}else if(u===o.DescriptionValue){if(r){s=i}else if(a){s=n}}return s};s.indexOfCondition=function(e,t,n,a){if(t&&t.bDelegateInitialized){const e=t.getControlDelegate();let i=-1;for(let o=0;o<a.length;o++){if(e.compareConditions(t,n,a[o])){i=o;break}}return i}else{return i.indexOfCondition(n,a)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldBaseRenderer", ["sap/ui/core/Renderer","sap/ui/mdc/enums/FieldEditMode"],(e,t)=>{"use strict";let n=e.extend("sap.ui.mdc.field.FieldBaseRenderer");n=Object.assign(n,{apiVersion:2});n.render=function(e,n){const s=n.getCurrentContent();const i=n.getWidth();const d=n.getConditions();const o=n.getEditMode();const a=n.getShowEmptyIndicator()&&d.length===0&&o===t.Display&&!n.getContent()&&!n.getContentDisplay();e.openStart("div",n);e.class("sapUiMdcFieldBase");if(s.length===0&&o!==t.Display){e.attr("tabindex","-1")}if(s.length>1){e.class("sapUiMdcFieldBaseMoreFields")}if(a){e.class("sapMShowEmpty-CTX")}e.style("width",i);e.openEnd();for(const t of s){e.renderControl(t)}e.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInfoBase", ["sap/ui/Device","sap/ui/mdc/Element","sap/m/library","sap/m/ResponsivePopover","sap/base/Log"],(e,t,o,r,i)=>{"use strict";const{PlacementType:n}=o;const s=t.extend("sap.ui.mdc.field.FieldInfoBase",{metadata:{library:"sap.ui.mdc",events:{dataUpdate:{},popoverAfterOpen:{}}}});s.prototype.isTriggerable=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method isTriggerable must be redefined")};s.prototype.getTriggerHref=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getTriggerHref must be redefined")};s.prototype.getDirectLinkHrefAndTarget=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getDirectLinkHrefAndTarget must be redefined")};s.prototype.open=async function(e,t){e=e?e:this.getParent();if(!e){throw new Error("sap.ui.mdc.field.FieldInfoBase: popover can not be open because the control is undefined")}const o=this.getPopover();if(o&&o.isOpen()){return Promise.resolve()}const r=await this.checkDirectNavigation(t);if(r===false){const t=await this.createPopover();if(t&&!this.isDestroyed()&&!e.isDestroyed()){t.openBy(e);t.attachAfterOpen(()=>{this.firePopoverAfterOpen()})}}return Promise.resolve()};s.prototype.getContent=function(e){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getContent must be redefined")};s.prototype.checkDirectNavigation=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method checkDirectNavigation must be redefined")};s.prototype.getSourceControl=function(){return this.getParent()};s.prototype.createPopover=async function(){try{const e=await this.getContent(()=>this.getPopover());return this._createPopover(e)}catch(e){i.error(e);return this._createPopover(undefined)}};s.prototype._createPopover=function(t){const o=new r(this.getPopoverId(),{contentWidth:"380px",horizontalScrolling:false,showHeader:e.system.phone,placement:n.Auto,content:[t],afterClose:function(e){if(e.getSource()){e.getSource().destroy()}}});this.addDependent(o);return new Promise((e,r)=>{sap.ui.require(["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],async r=>{if(r.isFlexSupported({element:t})){await r.waitForChanges({element:t})}if(this.retrievePopoverTitle){const{sTitle:e,oLabelledByControl:r}=await this.retrievePopoverTitle(t);o.setTitle(e);o.addAriaLabelledBy(r)}e(o)})})};s.prototype.getPopover=function(){return this.getDependents().find(e=>e.isA("sap.m.ResponsivePopover")&&e.getId()===this.getPopoverId())};s.prototype.getPopoverId=function(){return this.getId()+"-popover"};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInput", ["sap/m/Input","sap/ui/mdc/field/FieldInputRenderer","sap/ui/base/ManagedObjectObserver"],(e,t,i)=>{"use strict";const r=e.extend("sap.ui.mdc.field.FieldInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},renderer:t});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new i(a.bind(this));this._oObserver.observe(this,{properties:["ariaAttributes"]})};r.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined};function a(e){if(e.name==="ariaAttributes"){if(e.current.aria?.activedescendant!==e.old.aria?.activedescendant){const t=this.getFocusDomRef();if(!e.current.aria?.activedescendant){t.removeAttribute("aria-activedescendant")}else{t.setAttribute("aria-activedescendant",e.current.aria.activedescendant)}}}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInputRenderUtil", ["sap/ui/core/InvisibleText"],t=>{"use strict";const e={getAriaRole:function(t,e){const i=t.getAriaAttributes();if(i.role){return i.role}else{return e.getAriaRole.apply(this,arguments)}},getAccessibilityState:function(e,i){const r=e.getAriaAttributes();const s=i.getAccessibilityState.apply(this,arguments);if(r.aria){for(const t in r.aria){s[t]=r.aria[t]}}if(!r.valueHelpEnabled&&s.describedby){const e=t.getStaticId("sap.m","INPUT_VALUEHELP");const i=s.describedby.value.split(" ");let r="";for(const t of i){if(t!==e){r=r?r+" "+t:t}}if(r){s.describedby.value=r}else{delete s.describedby}}return s},writeInnerAttributes:function(t,e,i){i.writeInnerAttributes.apply(this,arguments);const r=e.getAriaAttributes();for(const e in r){if(e!=="aria"&&e!=="role"&&e!=="valueHelpEnabled"){t.attr(e,r[e])}}}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldInputRenderer", ["sap/ui/core/Renderer","sap/m/InputRenderer","sap/ui/mdc/field/FieldInputRenderUtil"],(e,t,i)=>{"use strict";const s=e.extend(t);s.apiVersion=2;s.addOuterClasses=function(e,i){t.addOuterClasses.apply(this,arguments);e.class("sapUiMdcFieldInput")};s.getAriaRole=function(e){return i.getAriaRole.call(this,e,t)};s.getAccessibilityState=function(e){return i.getAccessibilityState.call(this,e,t)};s.writeInnerAttributes=function(e,s){return i.writeInnerAttributes.call(this,e,s,t)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldMultiInput", ["sap/ui/core/Element","sap/m/MultiInput","sap/m/Tokenizer","sap/ui/mdc/field/FieldMultiInputRenderer","sap/ui/Device","sap/ui/base/ManagedObjectObserver"],(e,t,i,n,o,s)=>{"use strict";const r=t.extend("sap.ui.mdc.field.FieldMultiInput",{metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},renderer:n});r.prototype.init=function(){t.prototype.init.apply(this,arguments);const e=this.getAggregation("tokenizer");e._fillClipboard=d;e._handleNMoreIndicator=function(e){const t=this.getBinding("tokens");const n=t.getLength();const o=this.getTokens().length;const s=n-o;return i.prototype._handleNMoreIndicator.apply(this,[e+s])};e._handleNMoreIndicatorPress=function(){const e=this.getParent();c.call(e);return i.prototype._handleNMoreIndicatorPress.apply(this,arguments)};this._oObserver=new s(l.bind(this));this._oObserver.observe(this,{properties:["ariaAttributes"]})};r.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined};r.prototype.onfocusin=function(e){if(e.srcControl.isA("sap.m.Token")){const t=this.indexOfToken(e.srcControl);if(t>=0){this._iRestoreTokenFocus=this.getTokens().length-t}if(this._oUpdateBindingTimer||this._bUpdateBinding){this.bDeletePressed=false;this.iFocusedIndexBeforeUpdate=0}c.call(this,true);e.setMark("doNotOpenOnFocus",true)}else{delete this._iRestoreTokenFocus;c.call(this,false)}t.prototype.onfocusin.apply(this,arguments)};r.prototype.ontap=function(e){if(e.target.classList.contains("sapMTokenizerIndicator")){e.setMark("tokenizerMoreIndicatorTap")}t.prototype.ontap.apply(this,arguments)};r.prototype.onAfterRendering=function(){const{bDeletePressed:e,bTokensUpdated:i}=this;const n=this.iFocusedIndexBeforeUpdate;let o=false;if(this._oUpdateBindingTimer){this.bTokensUpdated=false;this.bDeletePressed=false;o=true}else if(this._bUpdateBinding&&this._iRestoreTokenFocus!==undefined){this.iFocusedIndexBeforeUpdate=this.getTokens().length-this._iRestoreTokenFocus;delete this._iRestoreTokenFocus;delete this._bUpdateBinding;this.bDeletePressed=true;const e=this.getAggregation("tokenizer");if(e._oSelectionOrigin){e._oSelectionOrigin=e.getTokens()[this.iFocusedIndexBeforeUpdate]}o=true}t.prototype.onAfterRendering.apply(this,arguments);if(o){this.bDeletePressed=e;this.iFocusedIndexBeforeUpdate=n;this.bTokensUpdated=i}};r.prototype.shouldSuggetionsPopoverOpenOnMobile=function(i){const n=this.getParent();const o=n?.getValueHelp?.();const s=o&&e.getElementById(o);if(s?.getTypeahead()){return false}else{return t.prototype.shouldSuggetionsPopoverOpenOnMobile.apply(this,arguments)}};let a=false;async function d(e){if(!navigator.clipboard){throw new Error(this+" requires a secure context in order to access the clipboard API.")}if(!a){const e=this.getSelectedTokens();if(e.length===0){return}a=true;const t=this.getBindingInfo("tokens").model;const i=e.map(e=>{const i=e.getBinding("text").getType();const n=e.getBindingContext(t).getObject();return i.getTextForCopy(n)}).join("\r\n");const n="<table><tr>"+e.map(e=>"<td>"+e.getText()+"</td>").join("</tr><tr>")+"</tr></table>";if(p()){const e="text/html";const t="text/plain";const o=new ClipboardItem({[t]:new Blob([i],{type:t}),[e]:new Blob([n],{type:e})});await navigator.clipboard.write([o])}else{await navigator.clipboard.writeText(i)}if(a){a=false}}}function p(){return Boolean(o.system.desktop&&window.ClipboardItem&&navigator.clipboard?.write)}function c(e){const t=this.getBindingInfo("tokens");if(!this._oUpdateBindingTimer&&(t.length||t.startIndex)){const i=()=>{let e=t.template;if(t.hasOwnProperty("templateShareable")&&!t.templateShareable){e=e.clone()}this._bUpdateBinding=true;this.bindAggregation("tokens",{path:t.path,model:t.model,template:e})};if(e){const e=this.getBinding("tokens");const n=e.getLength();if(n>=t.length){this._oUpdateBindingTimer=setTimeout(()=>{delete this._oUpdateBindingTimer;i()},200)}}else{i()}}}function l(e){if(e.name==="ariaAttributes"){if(e.current.aria?.activedescendant!==e.old.aria?.activedescendant){const t=this.getFocusDomRef();if(!e.current.aria?.activedescendant){t.removeAttribute("aria-activedescendant")}else{t.setAttribute("aria-activedescendant",e.current.aria.activedescendant)}}}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/FieldMultiInputRenderer", ["sap/ui/core/Renderer","sap/m/MultiInputRenderer","sap/ui/mdc/field/FieldInputRenderUtil"],(e,t,i)=>{"use strict";const s=e.extend(t);s.apiVersion=2;s.addOuterClasses=function(e,i){t.addOuterClasses.apply(this,arguments);e.class("sapUiMdcFieldMultiInput")};s.getAriaRole=function(e){return i.getAriaRole.call(this,e,t)};s.getAccessibilityState=function(e){return i.getAccessibilityState.call(this,e,t)};s.writeInnerAttributes=function(e,s){return i.writeInnerAttributes.call(this,e,s,t)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/ListFieldHelpItem", ["sap/ui/mdc/valuehelp/content/FixedListItem"],e=>{"use strict";const t=e.extend("sap.ui.mdc.field.ListFieldHelpItem",{metadata:{library:"sap.ui.mdc"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/MultiValueFieldDelegate", ["sap/ui/mdc/field/FieldBaseDelegate"],e=>{"use strict";const s=Object.assign({},e);s.updateItems=function(e,s,t){};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/MultiValueFieldItem", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.field.MultiValueFieldItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"any",byValue:true},description:{type:"string"}},defaultProperty:"key"}});t.prototype.bindProperty=function(t,r){if(t==="key"&&!r.formatter){r.targetType="raw"}e.prototype.bindProperty.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenDisplay", ["sap/m/Token","sap/ui/core/Lib","sap/ui/mdc/field/TokenDisplayRenderer"],(e,t,i)=>{"use strict";const r=e.extend("sap.ui.mdc.field.TokenDisplay",{metadata:{library:"sap.ui.mdc",properties:{_delimiter:{type:"string",defaultValue:"·",visibility:"hidden"}}},renderer:i});r.prototype.init=function(){e.prototype.init.apply(this,arguments);if(!this._oResourceBundle){this._oResourceBundle=t.getResourceBundleFor("sap.ui.mdc")}this.setProperty("_delimiter",this._oResourceBundle.getText("field.SEPARATOR").trim())};r.prototype.getSelected=function(){return false};r.prototype.focus=function(){return};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenDisplayRenderer", ["sap/ui/core/Renderer","sap/m/TokenRenderer"],(e,t)=>{"use strict";const r=e.extend(t);r.apiVersion=2;r._setAttributes=function(e,r){t._setAttributes(e,r);e.attr("delimiter",r.getProperty("_delimiter"))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenizerDisplay", ["sap/m/Tokenizer","sap/ui/mdc/field/TokenizerDisplayRenderer","sap/ui/events/KeyCodes","sap/m/library"],(t,e,o,n)=>{"use strict";const{EmptyIndicatorMode:i,TokenizerRenderMode:r}=n;const s=t.extend("sap.ui.mdc.field.TokenizerDisplay",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.core.ILabelable"],properties:{emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:i.Off}}},renderer:e});s.prototype.init=function(){t.prototype.init.apply(this,arguments);this.setShouldRenderTabIndex(false);this.allowTextSelection(true);this.addStyleClass("sapUiMdcTokenizerDisplay")};s.prototype.onkeydown=function(e){t.prototype.onkeydown.call(this,e);if(!this.getEnabled()){return}if(e.which===o.ENTER){if(this.getHiddenTokensCount()>0){this._handleNMoreIndicatorPress()}}};s.prototype.ontouchstart=function(e){if(!this.hasOneTruncatedToken()&&!e.target.classList.contains("sapMTokenizerIndicator")){return}t.prototype.ontouchstart.apply(this,arguments)};s.prototype.ontap=function(e){const o=e.getMark("tokenTap");if(o&&!this.hasOneTruncatedToken()){return}if(e.target.classList.contains("sapMTokenizerIndicator")){e.setMark("tokenizerMoreIndicatorTap")}t.prototype.ontap.apply(this,arguments)};s.prototype.onfocusin=function(t){};s.prototype.getTokensPopup=function(){const e=!this._oPopup;const o=t.prototype.getTokensPopup.apply(this,arguments);if(e){const t=t=>{this.setRenderMode(r.Narrow);this.fireRenderModeChange({renderMode:r.Narrow})};o.attachAfterOpen(t,this)}return o};s.prototype.afterPopupClose=function(){if(this.checkFocus()){this._oIndicator.focus()}};s.prototype.getFocusDomRef=function(){if(this.getHiddenTokensCount()===0||!this._oIndicator){return t.prototype.getFocusDomRef.apply(this,arguments)}else{return this._oIndicator[0]}};s.prototype.getAccessibilityInfo=function(){const t=this.getTokens().map(t=>t.getText()).join(" ");return{description:t}};s.prototype.hasLabelableHTMLElement=function(){return false};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/TokenizerDisplayRenderer", ["sap/ui/core/Lib","sap/ui/core/Renderer","sap/m/TokenizerRenderer","sap/m/library"],(e,t,n,r)=>{"use strict";const{EmptyIndicatorMode:a}=r;const o=e.getResourceBundleFor("sap.m");const s=t.extend(n);s.apiVersion=2;s._renderIndicator=function(e,t){n._renderIndicator.apply(this,arguments);if(t.getEmptyIndicatorMode()!==a.Off&&t.getTokens().length==0){this._renderEmptyIndicator(e,t)}};s._renderIndicatorTabIndex=function(e,t){e.attr("tabindex","0");e.attr("role","button")};s._renderEmptyIndicator=function(e,t){e.openStart("span");e.class("sapMEmptyIndicator");if(t.getEmptyIndicatorMode()===a.Auto){e.class("sapMEmptyIndicatorAuto")}e.openEnd();e.openStart("span");e.attr("aria-hidden",true);e.openEnd();e.text(o.getText("EMPTY_INDICATOR"));e.close("span");e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(o.getText("EMPTY_INDICATOR_TEXT"));e.close("span");e.close("span")};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/BooleanContent", ["sap/ui/mdc/field/content/DefaultContent"],e=>{"use strict";const t=Object.assign({},e,{getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return[null]},getEditMultiValue:function(){return[null]},getEditMultiLine:function(){return[null]},getUseDefaultValueHelp:function(){return{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true,single:true,multi:true}},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiValue not defined!")},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiLine not defined!")},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiLine not defined!")}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/ContentFactory", ["sap/ui/base/Object","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/ContentMode","sap/ui/mdc/util/loadModules","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/SearchContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/field/content/TimeContent","sap/ui/mdc/field/content/DateTimeContent","sap/ui/mdc/field/content/LinkContent","sap/ui/mdc/field/content/BooleanContent","sap/ui/mdc/field/content/UnitContent","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/base/SyncPromise"],(t,e,n,i,o,s,a,r,p,d,l,y,u,c,f)=>{"use strict";const h=t.extend("sap.ui.mdc.field.content.ContentFactory",{metadata:{library:"sap.ui.mdc"},constructor:function(e,n){this.init();this._oField=n?n.field:null;this._fnHandleTokenUpdate=n?n.handleTokenUpdate:null;this._fnHandleContentChange=n?n.handleContentChange:null;this._fnHandleContentLiveChange=n?n.handleContentLiveChange:null;this._fnHandleValueHelpRequest=n?n.handleValueHelpRequest:null;this._fnHandleEnter=n?n.handleEnter:null;this._fnHandleContentPress=n?n.handleContentPress:null;t.prototype.constructor.apply(this,arguments)}});const C={Default:o,Search:s,Date:a,Time:r,DateTime:p,Link:d,Boolean:l,Unit:y};let g;h._init=function(){if(g&&g.bool&&g.bool.control){g.bool.control.destroy()}if(g&&g.defineConditions&&g.defineConditions.control){g.defineConditions.control.destroy()}g={bool:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/Bool"],id:"BoolDefaultHelp",contentProperties:{},dialog:false,control:undefined,updateTitle:function(t,e){t.getTypeahead().setTitle(e)}},defineConditions:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Dialog","sap/ui/mdc/valuehelp/content/Conditions"],id:"Field-DefineConditions-Help",contentProperties:{},dialog:true,control:undefined,updateTitle:function(t,e){t.getDialog().setTitle(e);t.getDialog().getContent()[0].setLabel(e)}}}};h._init();h.prototype.init=function(){this._oContentTypeClass=undefined;this._sOperator=undefined;this._bNoFormatting=false;this._bHideOperator=false};h.prototype.exit=function(){this._oField=undefined;this._fnHandleTokenUpdate=undefined;this._fnHandleContentChange=undefined;this._fnHandleContentLiveChange=undefined;this._fnHandleValueHelpRequest=undefined;this._fnHandleEnter=undefined;this._fnHandleContentPress=undefined;this._oContentTypeClass=undefined;this._sOperator=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined}};h.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this.exit()};h.prototype.createContent=function(t,e,n,o){const s=this._sOperator;let a=t.getControlNames(e,s);const r=o&&t.getUseDefaultValueHelp().name;const p=r&&g[r];let d;this.setNoFormatting(t.getNoFormatting(e));if(a.every(t=>!t)){return Promise.resolve([])}if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);a.push(t.replaceAll(".","/"))}}if(p){if(p.control&&p.control.isDestroyed()){p.control=undefined}if(!p.control){a=a.concat(p.modules)}}try{d=i(a).catch(t=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:createContent function call - could not load data type "+JSON.stringify(a))}).then(i=>{if(this.getField()&&!this.getField().isFieldDestroyed()){const o=_.call(this,p,i);this.updateConditionType();const a=t.create(this,e,s,i,n);if(o){a.push(o)}for(const t of a){t._bByContentFactory=true}return a}else{return[]}}).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")}if(d.then){d.catch(t=>{throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")});return d}return f.resolve(d)};h.prototype.getContentMode=function(t,i,o,s,a){let r=n.Edit;if(i===e.Display){if(o!==1){r=n.DisplayMultiValue}else if(s){r=n.DisplayMultiLine}else{r=n.Display}}else if(o!==1){r=n.EditMultiValue}else if(s){r=n.EditMultiLine}else if(this.getField()._getValueHelp()){r=n.EditForHelp}else if(a.length===1&&t.getEditOperator()&&t.getEditOperator()[a[0]]){this._sOperator=a[0];r=n.EditOperator}return r};h.prototype.getContentType=function(t,e,n){const i=this.getField();let o=C[t]?C[t]:null;if(!o){if(i.isSearchField()){o=C.Search}else{o=C.Default}}if(i.getFieldInfo()&&n){o=C.Link.extendBaseContent(o)}return o};h._updateLink=function(t,e){if(e){t.setHref(e.href);t.setTarget(e.target)}};h._getEnabled=function(t){return t&&t!==e.Disabled};h._getEditable=function(t){return t===e.Editable||t===e.EditableReadOnly||t===e.EditableDisplay};h._getDisplayOnly=function(t){return t&&t!==e.Editable};h._getEditableUnit=function(t){return t===e.Editable};h.prototype.getField=function(){return this._oField};h.prototype.getValueHelpIcon=function(){return this.getField()._getValueHelpIcon()};h.prototype.getHandleTokenUpdate=function(){return this._fnHandleTokenUpdate};h.prototype.getHandleContentChange=function(){return this._fnHandleContentChange};h.prototype.getHandleContentLiveChange=function(){return this._fnHandleContentLiveChange};h.prototype.getHandleValueHelpRequest=function(){return this._fnHandleValueHelpRequest};h.prototype.getHandleEnter=function(){return this._fnHandleEnter};h.prototype.getHandleContentPress=function(){return this._fnHandleContentPress};h.prototype.setAriaLabelledBy=function(t){if(t.addAriaLabelledBy){const e=this.getField().getAriaLabelledBy();for(const n of e){t.addAriaLabelledBy(n)}}};h.prototype.setHideOperator=function(t){this._bHideOperator=t};h.prototype.getHideOperator=function(){return this._bHideOperator};function T(t,e,n,i){if(!i){if(this[t]&&this[t].getMetadata().getName()!==e.getMetadata().getName()){this[t].destroy();this[t]=undefined}if(!this[t]){const i=n();this[t]=new e(i);this[t]._bCreatedByField=true}}return this[t]}h.prototype.getConditionType=function(t){return T.call(this,"_oConditionType",u,this.getField().getFormatOptions.bind(this.getField()),t)};h.prototype.setConditionType=function(t){this._oConditionType=t};h.prototype.getConditionsType=function(t,e){const n=e||c;return T.call(this,"_oConditionsType",n,this.getField().getFormatOptions.bind(this.getField()),t)};h.prototype.setConditionsType=function(t){this._oConditionsType=t};h.prototype.getUnitConditionsType=function(t){return T.call(this,"_oUnitConditionsType",c,this.getField().getUnitFormatOptions.bind(this.getField()),t)};h.prototype.getContentConditionTypes=function(){return this._oContentConditionTypes};h.prototype.setContentConditionTypes=function(t){this._oContentConditionTypes=t};h.prototype._setUsedConditionType=function(t,n,o,s){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined}let a;let r;if(t){if(this._oContentConditionTypes.content){a=this._oContentConditionTypes.content.oConditionType;r=this._oContentConditionTypes.content.oConditionsType}}else if(s===e.Display&&o){if(this._oContentConditionTypes.contentDisplay){a=this._oContentConditionTypes.contentDisplay.oConditionType;r=this._oContentConditionTypes.contentDisplay.oConditionsType}}else if(s!==e.Display&&n){if(this._oContentConditionTypes.contentEdit){a=this._oContentConditionTypes.contentEdit.oConditionType;r=this._oContentConditionTypes.contentEdit.oConditionsType}}else if(this._oContentConditionTypes?._content){a=this._oContentConditionTypes._content.oConditionType;r=this._oContentConditionTypes._content.oConditionsType}if(a){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy()}this._oConditionType=a}if(r){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy()}this._oConditionsType=r}if(a||r){if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);t=t.replaceAll(".","/");try{i([t]).catch(e=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call - could not load controls "+t)}).then(t=>{if(this.getField()&&!this.getField().isFieldDestroyed()){this.updateConditionType()}}).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call ErrorMessage: '"+t.message+"'")}}}else{this.updateConditionType()}}};h.prototype.getDataType=function(){return this._oDataType};h.prototype.setDataType=function(t){this._oDataType=t};h.prototype.checkDataTypeChanged=function(t){t=this.getField().getTypeMap().getDataTypeClassName(t);try{return i([t.replaceAll(".","/")]).catch(e=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call - could not load data type "+t)}).then(e=>!this._oDataType||this._oDataType.getMetadata().getName()!==t)}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call ErrorMessage: '"+t.message+"'")}};h.prototype.retrieveDataType=function(){if(!this._oDataType){const t=this.getField().getDataType();if(typeof t==="string"){this._oDataType=this.getField().getTypeMap().getDataTypeInstance(t,this.getField().getDataTypeFormatOptions(),this.getField().getDataTypeConstraints());this._oDataType._bCreatedByField=true}}return this._oDataType};h.prototype.getAdditionalDataType=function(){return this._oAdditionalDataType};h.prototype.setAdditionalDataType=function(t){this._oAdditionalDataType=t};h.prototype.retrieveAdditionalDataType=function(){if(!this._oAdditionalDataType){const t=this.getField().getAdditionalDataTypeConfiguration();if(t){if(t.isA&&t.isA("sap.ui.model.Type")){this._oAdditionalDataType=t}else if(t.name){this._oAdditionalDataType=this.getField().getTypeMap().getDataTypeInstance(t.name,t.formatOptions,t.constraints);this._oAdditionalDataType._bCreatedByField=true}}}return this._oAdditionalDataType};h.prototype.getDateOriginalType=function(){return this._oDateOriginalType};h.prototype.setDateOriginalType=function(t){this._oDateOriginalType=t};h.prototype.getUnitOriginalType=function(){return this._oUnitOriginalType};h.prototype.setUnitOriginalType=function(t){this._oUnitOriginalType=t};h.prototype.getUnitType=function(){return this._oUnitType};h.prototype.setUnitType=function(t){this._oUnitType=t};h.prototype.getCompositeTypes=function(){return this._aCompositeTypes};h.prototype.setCompositeTypes=function(t){this._aCompositeTypes=t};h.prototype.getAdditionalCompositeTypes=function(){return this._aAdditionalCompositeTypes};h.prototype.setAdditionalCompositeTypes=function(t){this._aAdditionalCompositeTypes=t};h.prototype.isMeasure=function(){return this._bIsMeasure};h.prototype.setIsMeasure=function(t){this._bIsMeasure=t};h.prototype.getDisplayFormat=function(){return this._sDisplayFormat};h.prototype.setDisplayFormat=function(t){this._sDisplayFormat=t};h.prototype.getValueFormat=function(){return this._sValueFormat};h.prototype.setValueFormat=function(t){this._sValueFormat=t};h.prototype.getCalendarType=function(){return this._sCalendarType};h.prototype.setCalendarType=function(t){this._sCalendarType=t};h.prototype.getSecondaryCalendarType=function(){return this._sSecondaryCalendarType};h.prototype.setSecondaryCalendarType=function(t){this._sSecondaryCalendarType=t};h.prototype.getFieldTypeInitialization=function(){return this.getField()._oTypeInitialization};h.prototype.updateConditionType=function(){const t=this._oConditionType;const e=this._oConditionsType;if(t||e){let n=this.getField().getFormatOptions();if(t){t.setFormatOptions(n)}if(e){e.setFormatOptions(n)}if(this._oUnitConditionsType){n=this.getField().getUnitFormatOptions();this._oUnitConditionsType.setFormatOptions(n)}}};h.prototype.setNoFormatting=function(t){this._bNoFormatting=t};h.prototype.getNoFormatting=function(){return this._bNoFormatting};h.prototype.getProvideDefaultValueHelp=function(t,n,i,o,s){const a=t.getUseDefaultValueHelp();if(a&&i!==e.Display){if(o===1&&a.single||o!==1&&a.multi){if(n.length===1){if(o===1){if(!(t.getEditOperator()&&t.getEditOperator()[n[0]])&&(a.oneOperatorSingle||!s)){return true}}else if(a.oneOperatorMulti||!s){return true}}else{return true}}}return false};h.prototype.updateDefaultValueHelpTitle=function(t,e){for(const n in g){if(g[n].control===t){g[n].updateTitle(t,e);break}}};function _(t,e){if(t&&!t.control){const n=e[e.length-3];const i=e[e.length-2];const o=e[e.length-1];const s=new n(t.id,{delegate:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{isDefaultHelp:true}}});const a=new i(t.id+"-container",{content:[new o(t.id+"-content",t.contentProperties)]});s._bIsDefaultHelp=true;t.control=s;if(t.dialog){s.setDialog(a)}else{s.setTypeahead(a)}}return t?.control}return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DateContent", ["sap/base/i18n/date/CalendarType","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/DateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/model/Filter"],(e,t,a,n,i,r,o,l)=>{"use strict";let s;let d;const p=Object.assign({},t,{getEditMultiLine:function(){return[null]},getEdit:function(){return["sap/m/DynamicDateRange","sap/ui/mdc/condition/OperatorDynamicDateOption","sap/ui/mdc/field/DynamicDateRangeConditionsType","sap/m/library","sap/m/DynamicDateFormat"]},getEditOperator:function(){return{[i.EQ]:{name:"sap/m/DatePicker",create:this._createDatePickerControl},[i.BT]:{name:"sap/m/DateRangeSelection",create:this._createDateRangePickerControl}}},getEditForHelp:function(){return t.getEdit.apply(this,arguments)},getUseDefaultValueHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true,single:false,multi:true}},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateContent - createEditMultiLine not defined!")},_createDatePickerControl:function(e,t,a){const n=t[0];const i=e.getConditionsType();e.setHideOperator(true);this._adjustDataTypeForDate(e);const r=new n(a,{value:{path:"$field>/conditions",type:i},displayFormat:e.getDisplayFormat(),valueFormat:e.getValueFormat(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",liveChange:e.getHandleContentLiveChange(),change:e.getHandleContentChange()});if(r.setDisplayFormatType){r.setDisplayFormatType(e.getCalendarType())}if(r.setSecondaryCalendarType){r.setSecondaryCalendarType(e.getSecondaryCalendarType())}r.setPreferUserInteraction(true);e.setAriaLabelledBy(r);return[r]},_createDateRangePickerControl:function(e,t,a){const n=t[0];const i=e.getConditionsType();this._adjustDataTypeForDate(e);const r=new n(a,{value:{path:"$field>/conditions",type:i},displayFormat:e.getDisplayFormat(),valueFormat:e.getValueFormat(),delimiter:"...",displayFormatType:e.getCalendarType(),secondaryCalendarType:e.getSecondaryCalendarType(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",liveChange:e.getHandleContentLiveChange(),change:e.getHandleContentChange()});r.setPreferUserInteraction(true);e.setAriaLabelledBy(r);return[r]},_adjustDataTypeForDate:function(t){const a=t.retrieveDataType();const n=a.getFormatOptions();this._getDatePattern(t,n);if(!n||n.style||!n.pattern||n.pattern!==t.getValueFormat()||!n.calendarType||n.calendarType!==e.Gregorian){t.setDateOriginalType(t.getDataType());t.setDataType(r.createInternalType(a,t.getValueFormat()));t.updateConditionType()}},_getDatePattern:function(e,t){const n=e.getField().getBaseType();switch(n){case a.Date:e.setValueFormat("yyyy-MM-dd");break;case a.DateTime:e.setValueFormat("yyyy-MM-dd'T'HH:mm:ss");break;case a.Time:e.setValueFormat("HH:mm:ss");break;default:return}e.setDisplayFormat("medium");if(t){if(t.style){e.setDisplayFormat(t.style)}else if(t.pattern){e.setDisplayFormat(t.pattern)}if(t.calendarType){e.setCalendarType(t.calendarType)}if(t.secondaryCalendarType){e.setSecondaryCalendarType(t.secondaryCalendarType)}}},createEdit:function(e,t,a){const n=t[0];const i=t[1];const r=t[2];const o=t[3];if(!s||!d){s=o.StandardDynamicDateRangeKeys;d=t[4]}const p=e.getConditionsType(false,r);const c=function(t){return this._getDateRangeStandardOptions(t,e)}.bind(this);const u=new l({path:"/",test:function(t){const a=e.getField().getBaseType();return!this._getDateRangeStandardOption(t,a)}.bind(this)});const y=function(t,n){const r=e.getField().getBaseType();const o=n.getObject();return this._createOperatorDynamicDateOption(o,e,i,r,a)}.bind(this);const g=new n(a,{value:{path:"$field>/conditions",type:p},formatter:this._getDateRangeFormatter(e),placeholder:"{$field>/placeholder}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",standardOptions:{path:"$field>/_operators",formatter:c},customOptions:{path:"$field>/_operators",filters:u,factory:y},change:e.getHandleContentChange()});e.setAriaLabelledBy(g);return[g]},createEditForHelp:function(e,a,n){if(e.getDataType()&&e.getDataType().isA("sap.ui.model.CompositeType")){e.setIsMeasure(true)}return t.createEdit.apply(this,arguments)},_getDateRangeStandardOptions:function(e,t){if(!e||e.length===0){e=t.getField().getSupportedOperators()}const a=[];const n=t.getField().getBaseType();for(const t of e){const e=this._getDateRangeStandardOption(t,n);if(e){a.push(e)}}return a},_getDateRangeStandardOption:function(e,t){const a=o.getOperator(e);return o.getDynamicDateOptionForOperator(a,s,t)},_createOperatorDynamicDateOption:function(e,t,a,i,r){const l=o.getOperator(e);let s;if(l){const e=o.getCustomDynamicDateOptionForOperator(l,i);const d=t.retrieveDataType();const p=[];for(let e=0;e<l.valueTypes.length;e++){if(l.valueTypes[e]&&l.valueTypes[e]!==n.Static){p.push("custom")}}s=new a(r+"--"+e,{key:e,operator:l,type:d,baseType:i,valueTypes:p})}return s},_getDateRangeFormatter:function(e){const t=e.retrieveDataType();const n=e.getField().getBaseType();const i=t.getFormatOptions();const r={};const o={};if(i.style){r.style=i.style}else if(i.pattern){r.pattern=i.pattern}if(n===a.DateTime){o.datetime=r}o.date=r;return d.getInstance(o)}});return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DateTimeContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/DateUtil","sap/base/util/merge"],(e,t,a,n,i)=>{"use strict";const o=Object.assign({},t,{getEditOperator:function(){return{[a.EQ]:{name:"sap/m/DateTimePicker",create:this._createDatePickerControl}}},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateTimeContent - createEditMultiLine not defined!")},_createDatePickerControl:function(e,a,i){const o=t._createDatePickerControl.apply(this,arguments);const r=e.getDateOriginalType()||e.getDataType();if(n.showTimezone(r)){const t=e.getUnitConditionsType();o[0].bindProperty("timezone",{path:"$field>/conditions",type:t,targetType:"sap.ui.mdc.raw:1"});o[0].setShowTimezone(true)}return o},_adjustDataTypeForDate:function(e){const a=e.retrieveDataType();let o=a.getFormatOptions();if(n.showTimezone(a)){this._getDatePattern(e,o);e.setDateOriginalType(e.getDataType());e.setDataType(n.createInternalType(a,e.getValueFormat()));e.updateConditionType();o=i({},o);delete o.pattern;o.showDate=false;o.showTime=false;o.showTimezone=true;const t=a.getConstraints();const r=a.getMetadata().getClass();e.setUnitType(new r(o,t))}else{t._adjustDataTypeForDate.apply(this,arguments)}}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/DefaultContent", ["sap/m/library","sap/ui/mdc/enums/ContentMode"],(e,t)=>{"use strict";const{EmptyIndicatorMode:i}=e;const{TokenizerRenderMode:a}=e;const l={getDisplay:function(){return["sap/m/Text"]},getDisplayMultiValue:function(){return["sap/ui/mdc/field/TokenizerDisplay","sap/ui/mdc/field/TokenDisplay"]},getDisplayMultiLine:function(){return["sap/m/ExpandableText"]},getEdit:function(){return["sap/ui/mdc/field/FieldInput"]},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"]},getEditMultiLine:function(){return["sap/m/TextArea"]},getEditOperator:function(){return[null]},getEditForHelp:function(){return this.getEdit()},getUseDefaultEnterHandler:function(){return true},getUseDefaultValueHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false,single:true,multi:true}},getControlNames:function(e,i){let a;switch(e){case t.Display:a=this.getDisplay();break;case t.DisplayMultiValue:a=this.getDisplayMultiValue();break;case t.DisplayMultiLine:a=this.getDisplayMultiLine();break;case t.EditMultiValue:a=this.getEditMultiValue();break;case t.EditMultiLine:a=this.getEditMultiLine();break;case t.EditOperator:if(this.getEditOperator()){a=this.getEditOperator()[i]?this.getEditOperator()[i].name:[null]}else{a=[null]}break;case t.EditForHelp:a=this.getEditForHelp();break;default:a=this.getEdit()}if(a){return Array.isArray(a)?a:[a]}throw new Error("No control defined for content mode "+e)},getNoFormatting:function(e){if(e===t.EditMultiValue){return true}else{return false}},create:function(e,i,a,l,n){switch(i){case t.Display:return this.createDisplay(e,l,n);case t.DisplayMultiValue:return this.createDisplayMultiValue(e,l,n);case t.DisplayMultiLine:return this.createDisplayMultiLine(e,l,n);case t.EditMultiValue:return this.createEditMultiValue(e,l,n);case t.EditMultiLine:return this.createEditMultiLine(e,l,n);case t.EditOperator:if(this.getEditOperator()){return this.getEditOperator()[a]?this.getEditOperator()[a].create.call(this,e,l,n):[null]}return[null];case t.EditForHelp:return this.createEditForHelp(e,l,n);default:return this.createEdit(e,l,n)}},createEdit:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:e.getValueHelpIcon(),showValueHelp:"{$field>/_valueHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",autocomplete:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),valueHelpRequest:e.getHandleValueHelpRequest()});n.setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createEditMultiValue:function(e,t,i){const a=t[0];const l=t[1];const n=e.getConditionType();const r=e.getConditionsType();const o=new l(i+"-token",{text:{path:"$field>",type:n}});const d=new a(i,{value:{path:"$field>/conditions",type:r},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_valueHelpEnabled}",valueHelpIconSrc:e.getValueHelpIcon(),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:o,length:10,startIndex:-10},dependents:[o],autocomplete:false,showSuggestion:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),tokenUpdate:e.getHandleTokenUpdate(),valueHelpRequest:e.getHandleValueHelpRequest()});d.setPreferUserInteraction(true);e.setAriaLabelledBy(d);return[d]},createEditMultiLine:function(e,t,i){const a=t[0];const l=e.getConditionsType();const n=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange()});n.setPreferUserInteraction(true);e.setAriaLabelledBy(n);return[n]},createDisplay:function(e,t,a){const l=t[0];const n=e.getConditionsType();const r=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[r]},createDisplayMultiLine:function(e,t,a){const l=t[0];const n=e.getConditionsType();const r=new l(a,{text:{path:"$field>/conditions",type:n},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",emptyIndicatorMode:i.Auto});return[r]},createDisplayMultiValue:function(e,t,l){const n=t[0];const r=t[1];const o=e.getConditionType();const d=new r(l+"-token",{text:{path:"$field>",type:o}});const s=new n(l,{editable:false,emptyIndicatorMode:i.Auto,renderMode:a.Narrow,width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:d},dependents:[d]});return[s]},createEditForHelp:function(e,t,i){if(e.getDataType()&&e.getDataType().isA("sap.ui.model.CompositeType")){e.setIsMeasure(true)}return this.createEdit(e,t,i)}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/LinkContent", ["sap/m/library"],t=>{"use strict";const{EmptyIndicatorMode:e}=t;const n=new WeakMap;const i={getDisplay:function(){return["sap/m/Link"]},getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return["sap/m/Link"]},getUseDefaultValueHelp:function(){return false},createDisplay:function(t,n,i){const a=n[0];const s=t.getConditionsType();const l=new a(i,{text:{path:"$field>/conditions",type:s},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:t.getHandleContentPress(),wrapping:"{$field>/multipleLines}",emptyIndicatorMode:e.Auto});const o=t.getField().getFieldInfo();if(o){o.getDirectLinkHrefAndTarget().then(e=>{t.getMetadata()._oClass._updateLink(l,e)})}t.setAriaLabelledBy(l);return[l]},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.LinkContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(t,e,n){return this.createDisplay(t,e,n)}};const a={extendBaseContent:function(t){let e=n.get(t);if(!e){const a=Object.assign({},t);e=Object.assign(a,i);n.set(t,e)}return e}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/SearchContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/model/BindingMode","sap/ui/model/ParseException","sap/ui/model/ValidateException"],(e,t,n,i)=>{"use strict";const r=Object.assign({},e,{getDisplayMultiValue:function(){return[null]},getDisplayMultiLine:function(){return[null]},getEdit:function(){return["sap/m/SearchField"]},getEditMultiValue:function(){return[null]},getEditMultiLine:function(){return[null]},getEditForHelp:function(){return[null]},getUseDefaultEnterHandler:function(){return false},getUseDefaultValueHelp:function(){return false},createEdit:function(e,r,a){const l=r[0];const o=e.getConditionsType();e.setHideOperator(true);e.updateConditionType();const u=new l(a,{value:{path:"$field>/conditions",type:o,mode:t.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:function(t){if(t.getParameters().clearButtonPressed||t.getParameters().escPressed){return}e.getHandleEnter().call(this,t)},change:function(t){const r=t.getSource();const a=t.getParameter("value");const l=r.getBinding("value");try{l.setExternalValue(a);const e={element:r,property:"value",type:l.getType(),newValue:a,oldValue:""};r.fireValidationSuccess(e,false,true)}catch(e){const t={element:r,property:"value",type:l.getType(),newValue:a,oldValue:"",exception:e,message:e.message};if(e instanceof n){r.fireParseError(t,false,true)}else if(e instanceof i){r.fireValidationError(t,false,true)}else{throw e}}e.getHandleContentChange().call(this,t)},liveChange:e.getHandleContentLiveChange()});e.setAriaLabelledBy(u);return[u]},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiValue not defined!")},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiLine not defined!")},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiValue not defined!")},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiLine not defined!")},createEditForHelp:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditForHelp not defined!")}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/TimeContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/enums/OperatorName"],(t,e,n)=>{"use strict";const i=Object.assign({},e,{getEditOperator:function(){return{[n.EQ]:{name:"sap/m/TimePicker",create:this._createDatePickerControl}}},getEdit:function(){return t.getEdit.apply(this,arguments)},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.TimeContent - createEditMultiLine not defined!")},createEdit:function(e,n,i){return t.createEdit.apply(this,arguments)}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/content/UnitContent", ["sap/ui/mdc/field/content/DefaultContent","sap/ui/core/library","sap/ui/model/Filter","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/mdc/enums/FieldEditMode"],(e,t,i,a,n,l)=>{"use strict";const{ValueState:o}=t;const d=function(e,t,i,a,n,l){return e.getUnitTypeInstance?e.getUnitTypeInstance(t,n,l):e.getDataTypeInstance(t.getMetadata().getName(),i,a,{showNumber:n,showMeasure:l})};const s=Object.assign({},e,{getEdit:function(){return["sap/ui/mdc/field/FieldInput","sap/ui/core/InvisibleText"]},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token","sap/ui/core/InvisibleText"]},getEditMultiLine:function(){return[null]},getUseDefaultValueHelp:function(){return false},createEdit:function(e,t,i){e.setIsMeasure(true);const a=t[0];const n=t[1];const l=e.getConditionsType();this._adjustDataTypeForUnit(e);const o=n.getStaticId("sap.ui.mdc","field.NUMBER");let d=[];const s=new a(i,{value:{path:"$field>/conditions",type:l},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",valueHelpIconSrc:"sap-icon://slim-arrow-down",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[o],change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange()});s.setPreferUserInteraction(true);e.setAriaLabelledBy(s);d.push(s);d=this._addUnitControl(e,d,i,a,n);return d},createEditMultiValue:function(e,t,a){e.setIsMeasure(true);const n=t[0];const l=t[2];const o=t[1];const d=t[3];const s=e.getConditionType();const c=e.getConditionsType();this._adjustDataTypeForUnit(e);let f=[];const g=new l(a+"-token",{text:{path:"$field>",type:s}});const h=new i({path:"values",test:function(e){if(!Array.isArray(e[0])||e[0][0]){return true}else{return false}}});const I=d.getStaticId("sap.ui.mdc","field.NUMBER");const m=new n(a,{value:{path:"$field>/conditions",type:c},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[I],tokens:{path:"$field>/conditions",template:g,filters:[h]},dependents:[g],autocomplete:false,showSuggestion:false,change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),tokenUpdate:e.getHandleTokenUpdate()});m.setPreferUserInteraction(true);e.setAriaLabelledBy(m);f.push(m);f=this._addUnitControl(e,f,a,o,d);return f},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.UnitContent - createEditMultiLine not defined!")},_addUnitControl:function(e,t,i,a,n){const o=e.getUnitConditionsType();if(e.getField().getEditMode()===l.EditableDisplay){t[0].bindProperty("description",{path:"$field>/conditions",type:o});t[0].setWidth("100%");t[0].setFieldWidth("70%")}else{let l;const d=e.getUnitOriginalType();const s=d&&d.getMetadata().getName();if(s&&s.indexOf("Currency")>=0){l=n.getStaticId("sap.ui.mdc","field.CURRENCY")}else{l=n.getStaticId("sap.ui.mdc","field.UNIT")}const c=new a(i+"-unit",{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEditableUnit},enabled:{path:"$field>/editMode",formatter:e.getMetadata()._oClass._getEnabled},valueState:{path:"$field>/valueState",formatter:r},valueStateText:{path:"$field>/valueStateText",formatter:u},valueHelpIconSrc:e.getValueHelpIcon(),showValueHelp:"{$field>/_valueHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:{path:"$field>/fieldGroupIds",formatter:p},ariaDescribedBy:[l],change:e.getHandleContentChange(),liveChange:e.getHandleContentLiveChange(),valueHelpRequest:e.getHandleValueHelpRequest()});c.setPreferUserInteraction(true);e.setAriaLabelledBy(c);t.push(c)}return t},_adjustDataTypeForUnit:function(e){const t=e.getField();const i=t.getTypeMap();const l=e.retrieveDataType();const o=l.getFormatOptions();const s=l.getConstraints();const r=!o||!o.hasOwnProperty("showMeasure")||o.showMeasure;const u=!o||!o.hasOwnProperty("showNumber")||o.showNumber;if(r&&u){const t=n({},o);const r=a(s)?undefined:n({},s);let u=d(i,l,t,r,true,false);e.setUnitOriginalType(e.getDataType());i.initializeInternalType(u,e.getFieldTypeInitialization());e.setDataType(u);u=d(i,l,t,r,false,true);i.initializeInternalType(u,e.getFieldTypeInitialization());e.setUnitType(u);e.updateConditionType()}}});function r(e){const t=this.getParent();if(!t||!t.isInvalidInput()||t._isInvalidInputForContent(this)){return e}else{return o.None}}function u(e){const t=this.getParent();if(!t||!t.isInvalidInput()){return e}else if(t._isInvalidInputForContent(this)){const e=t._getInvalidInputException(this);return e.message}else{return""}}function p(e){const t=this.getParent();if(t){e.push(t.getId())}else{let t=this.getId();const i=t.lastIndexOf("-inner");t=t.slice(0,i);e.push(t)}return e}return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/field/splitValue", [],()=>{"use strict";const n=function(n,t){let e;if(typeof n==="string"){if(n.length&&n.endsWith("\r\n")){n=n.substring(0,n.lastIndexOf("\r\n"))}if(t){e=n.split(/\r\n|\r|\n|\t/g)}else{e=n.split(/\r\n|\r|\n/g)}}else{e=[n]}return e};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/FilterBarBase", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/core/library","sap/ui/core/ShortcutHintsMixin","sap/ui/Device","sap/ui/mdc/Control","sap/base/Log","sap/base/util/merge","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/ConditionModel","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionConverter","sap/ui/mdc/util/IdentifierUtil","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/mdc/enums/ReasonMode","sap/ui/mdc/enums/FilterBarValidationStatus","sap/ui/mdc/enums/OperatorName","sap/m/library","sap/m/Button","./FilterBarBaseRenderer","sap/ui/mdc/FilterField","sap/ui/mdc/filterbar/PropertyInfoValidator"],(e,t,i,r,n,o,s,a,l,h,d,p,c,u,g,f,_,y,m,F,C,I,b,S,P)=>{"use strict";let A;const{ValueState:v}=r;const M="$search";const E=s.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},propertyInfo:{type:"object",defaultValue:[]},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{parameters:{reason:{type:"sap.ui.mdc.enums.ReasonMode"}}},filtersChanged:{parameters:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}},renderer:b});const{ButtonType:N}=C;E.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";E.CONDITION_MODEL_NAME="$filters";E.prototype.init=function(){s.prototype.init.apply(this,arguments);this._oRb=t.getResourceBundleFor("sap.ui.mdc");this._createInnerModel();this._oObserver=new d(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this.getEngine().register(this,{controller:{Filter:new i({control:this})}});this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(e=>{this._fResolveInitialFiltersApplied=e});this._bIgnoreChanges=false;this._aOngoingChangeAppliance=[];this._bSearchTriggered=false;this._bIgnoreQueuing=false};E.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true)};E.prototype._isPhone=function(){return o.system.phone?true:false};E.prototype._isLiveMode=function(){if(this._isPhone()){return false}return this.getLiveMode()};E.prototype._getConditionModel=function(){return this._oConditionModel};E.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new I(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:N.Emphasized});n.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this)}return this._btnSearch};E.prototype.getConditionModelName=function(){return this._getConditionModelName()};E.prototype._getConditionModelName=function(){return E.CONDITION_MODEL_NAME};E.prototype._createConditionModel=function(){this._oConditionModel=new p;this.setModel(this._oConditionModel,this._getConditionModelName())};E.prototype.applySettings=function(e,t){this._setPropertyHelperClass(_);this._setupPropertyInfoStore("propertyInfo");if(e?.propertyInfo&&e?.filterItems&&Array.isArray(e.filterItems)){this._validatePropertyInfos(e.propertyInfo,e.filterItems)}this._applySettings(e,t);Promise.all([this.awaitPropertyHelper()]).then(()=>{if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions();this.getFilterItems().forEach(e=>{this._enhanceFilterField(e)});const e=this.getBasicSearchField();if(e){this._enhanceBasicSearchField(e)}}})};E.prototype._validatePropertyInfos=function(e,t){t.forEach(t=>{const i=t.getPropertyKey();const r=e=>e.name===i;if(i&&e.some(r)){const i=e.find(r);P.comparePropertyInfoWithControl(t,i)}})};E.prototype._applySettings=function(e,t){s.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this)};E.prototype._waitForMetadata=function(){return this._retrieveMetadata().then(()=>{this._applyInitialFilterConditions()})};E.prototype.setIgnoreQueuing=function(e){this._bIgnoreQueuing=e};E.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing};E.prototype.setSuspendSelection=function(e){this.setProperty("suspendSelection",e);if(!e){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch()}this._bSearchTriggered=false;this.setIgnoreQueuing(false)}return this};E.prototype._createInnerModel=function(){this._oModel=new h(this);this.setModel(this._oModel,E.INNER_MODEL_NAME);return this};E.prototype.getCurrentState=function(){const e={};e.filter=l({},this.getFilterConditions());const t=this.getFilterItems();const i=[];t.forEach(e=>{const t=e.getPropertyKey();i.push({key:t,name:t})});e.items=i;return e};E.prototype.getAssignedFilterNames=function(){let e,t=null;const i=this._getConditionModel();if(i){t=[];const r=i.getConditions(M);if(r&&r.length>0){t.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"))}this._getNonHiddenPropertyInfoSet().forEach(r=>{e=g.getPropertyKey(r);const n=i.getConditions(e);if(n&&n.length>0){t.push(r.label||e)}})}return t};E.prototype._getAssignedFiltersText=function(){const e={};e.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());e.filtersTextExpanded=this._getAssignedFiltersExpandedText();return e};E.prototype._getAssignedFiltersExpandedText=function(){let e=0,t=0;const i=this._getConditionModel();if(i){const r=i.getAllConditions();for(const i in r){const n=this._getPropertyByName(i);if(n&&!n.hiddenFilter&&r[i].length>0){++e;if(!(i===M&&this.getAggregation("basicSearchField")||this._getFilterField(i))){++t}}}}if(!e&&!t){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")}if(!t){if(e===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[e])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[e])}if(e===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[e,t])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[e,t])};E.prototype._getAssignedFiltersCollapsedText=function(e){let t;e=e||[];if(e.length){t=Object.keys(e).map(t=>e[t]).join(", ");if(e.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[e.length,t])}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[e.length,t])}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")};E.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText()};E.prototype._reportModelChange=function(e){if(e.triggerFilterUpdate){this._handleAssignedFilterNames(false)}if(this.getLiveMode()||e.triggerSearch||this._bExecuteOnSelect){this._bExecuteOnSelect=false;this.triggerSearch()}else if(e.recheckMissingRequired){this._recheckMissingRequiredFields()}};E.prototype.getPropertyInfoSet=function(){return this.getPropertyHelper()?this.getPropertyHelper().getProperties():[]};E.prototype._addConditionChange=function(e){this._aOngoingChangeAppliance.push(this.getEngine().createChanges({control:this,applySequentially:true,applyAbsolute:true,key:"Filter",state:e}))};E.prototype._handleConditionModelPropertyChange=function(e){let t;const i=function(e,t){const i={};i[e]=this._stringifyConditions(e,l([],t));this._cleanupConditions(i[e]);return i}.bind(this);if(!this._bIgnoreChanges&&!e.getParameter("_descriptionOnly")){const r=e.getParameter("path");if(r.indexOf("/conditions/")===0){const n=r.substring("/conditions/".length);const o=e.getParameter("value");if(this._getPropertyByName(n)){t=i(n,o)}else{t=this._retrieveMetadata().then(()=>i(n,o))}}}if(t){this._addConditionChange(t)}};E.prototype._toExternal=function(e,t){let i=l({},t);i=u.toString(i,e.typeConfig.typeInstance,this.getTypeMap());this._cleanupCondition(i);this._convertInOutParameters(t,i,"inParameters",u.toString);this._convertInOutParameters(t,i,"outParameters",u.toString);return i};E.prototype._toInternal=function(e,t){let i=l({},t);i=u.toType(i,e.typeConfig.typeInstance,this.getTypeMap());this._convertInOutParameters(t,i,"inParameters",u.toType);this._convertInOutParameters(t,i,"outParameters",u.toType);return i};E.prototype._convertInOutParameters=function(e,t,i,r){if(e[i]&&Object.keys(e[i]).length>0){Object.keys(e[i]).forEach(n=>{const o=n.startsWith("conditions/")?n.slice(11):n;const s=this._getPropertyByName(o);if(s){const a=c.createCondition(F.EQ,[e[i][n]]);const l=r(a,s.typeConfig.typeInstance,this.getTypeMap());if(!t[i]){t[i]={}}if(!n.startsWith("conditions/")){delete t[i][n];n="conditions/"+o}t[i][n]=l.values[0]}else{a.error("mdc.FilterBar._convertInOutParameters: could not find property for '"+o+"'")}})}};E.prototype._cleanupCondition=function(e){if(e){if(e.hasOwnProperty("isEmpty")){delete e.isEmpty}}};E.prototype._cleanupConditions=function(e){if(e){e.forEach(function(e){this._cleanupCondition(e)},this)}};E.prototype._stringifyCondition=function(e,t){let i=t;if(t&&t.values){if(t.values.length>0){i=this._toExternal(e,t)}else{i=l({},t);this._cleanupCondition(i)}}return i};E.prototype._stringifyConditions=function(e,t){const i=this._getPropertyByName(e);let r=t;if(i&&t){r=[];t.forEach(function(e){r.push(this._stringifyCondition(i,e))},this)}return r};E.prototype._internalizeConditions=function(e){const t=l({},e);Object.keys(t).forEach(function(e){t[e].forEach(function(i,r){const n=this._getPropertyByName(e);if(n){try{t[e][r]=this._toInternal(n,i)}catch(e){a.error(e.message)}}else{a.error("Property '"+e+"' does not exist")}},this)},this);return t};E.prototype._handleAssignedFilterNames=function(e){if(this._bIsBeingDestroyed){return}if(!e){if(this._btnAdapt){const e=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(e.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",[e.length]),false)}}const t=this._getAssignedFiltersText();const i={conditionsBased:!e&&!this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch,filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;this.fireFiltersChanged(i)};E.prototype.onSearch=function(e){if(!this._bSearchPressed){this._bSearchPressed=true;this._sReason=y.Go;this.triggerSearch().then(()=>{this._bSearchPressed=false},()=>{this._bSearchPressed=false})}};E.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve()}this._bFireSearch=true;return this.validate()};E.prototype._hasRetrieveMetadataToBeCalled=function(){return this.getPropertyHelper()===null||this.getPropertyHelper().getProperties().length===0&&!this.isPropertyHelperFinal()};E.prototype.validate=function(e){const t=!e;this._bFireSearch=this._bFireSearch||t;const i=function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise((e,t)=>{this._fResolvedSearchPromise=e;this._fRejectedSearchPromise=t});const e=function(){this._validate(t)};setTimeout(e.bind(this),0)}return this._oValidationPromise}.bind(this);return this.waitForInitialization().then(()=>{if(this._hasRetrieveMetadataToBeCalled()){return this._retrieveMetadata().then(()=>i())}else{return i()}})};E.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null}};E.prototype._checkAsyncValidation=function(){let e=m.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){e=m.AsyncValidation}return e};E.prototype._checkOngoingChangeAppliance=function(){let e=m.NoError;if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){e=m.OngoingChangeAppliance}return e};E.prototype._getRequiredFilterFieldValueText=function(e){if(e){return this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING",[e.getLabel()])}else{return""}};E.prototype._recheckMissingRequiredFields=function(){this.getFilterItems().forEach(e=>{let t;if(e){if(e.getValueState()!==v.None&&e.getValueStateText()===this._getRequiredFilterFieldValueText(e)){if(!t){t=f.getRequiredFieldNamesWithoutValues(this)}if(t.indexOf(e.getPropertyKey())<0){e.setValueState(v.None)}}}})};E.prototype._checkRequiredFields=function(){let e=m.NoError;const t=f.getRequiredFieldNamesWithoutValues(this);t.forEach(t=>{const i=this._getFilterField(t);if(i){if(i.getValueState()===v.None){i.setValueState(v.Error);i.setValueStateText(this._getRequiredFilterFieldValueText(i))}}else{a.error("Mandatory filter field '"+t+"' not visible on FilterBarBase has no value.")}e=m.RequiredHasNoValue});return e};E.prototype._checkFieldsInErrorState=function(){let e=m.NoError;if(this._bFieldInErrorState){return m.FieldInErrorState}this.getFilterItems().some(t=>{if(t&&t.getValueState()!==v.None){if(t.getValueStateText()!==this._getRequiredFilterFieldValueText(t)){e=m.FieldInErrorState}}return e!==m.NoError});return e};E.prototype._hasAppliancePromises=function(){return this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0?this._aOngoingChangeAppliance.slice():null};E.prototype._handleFilterItemSubmit=function(e){const t=e.getParameter("promise");if(t){this._sReason=y.Enter;t.then(()=>{const e=this._hasAppliancePromises();if(!e){this.triggerSearch()}else{Promise.all(e).then(()=>{if(!this.getLiveMode()){this.triggerSearch()}})}}).catch(e=>{a.error(e);this.triggerSearch().catch(e=>{})})}};E.prototype._handleFilterItemChanges=function(e){if(this._bIgnoreChanges){return}const t=e.oSource;if(t.getRequired()&&t.getValueState()===v.Error&&e.getParameter("valid")){t.setValueState(v.None);return}if(!this._aFIChanges){this._aFIChanges=[]}const i=t.getPropertyKey();this._aFIChanges.some((e,t)=>{if(e.name===i){this._aFIChanges.splice(t,1);return true}return false});this._aFIChanges.push({name:i,promise:e.getParameter("promise")})};E.prototype.checkFilters=function(){let e=this._checkAsyncValidation();if(e!==m.NoError){return e}e=this._checkOngoingChangeAppliance();if(e!==m.NoError){return e}e=this._checkFieldsInErrorState();if(e!==m.NoError){return e}e=this._checkRequiredFields();if(e!==m.NoError){return e}return e};E.prototype._setFocusOnFirstErroneousField=function(){let e=null;this.getFilterItems().some(t=>{if(t.getValueState()!==v.None){e=t;setTimeout(t["focus"].bind(t),0)}return e!=null});return e};E.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField()};E.prototype._handleAsyncValidation=function(e,t){if(!t){t=this._validate.bind(this)}if(this._aFIChanges&&this._aFIChanges.length>0){const i=this._aFIChanges.slice();this._aFIChanges=null;const r=[];i.forEach(e=>{r.push(e.promise)});Promise.all(r).then(r=>{r.forEach(function(e,t){const r=this._getFilterField(i[t].name);if(r&&r.getRequired()&&r.getValueState()===v.Error){r.setValueState(v.None)}},this);t(e)},()=>{this._bFieldInErrorState=true;t(e)}).catch(i=>{this._bFieldInErrorState=true;t(e)})}};E.prototype._handleOngoingChangeAppliance=function(e,t){if(!t){t=this._validate.bind(this)}if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){const i=this._aOngoingChangeAppliance.slice();this._aOngoingChangeAppliance=[];Promise.all(i).then(()=>{const i=this._oApplyingChanges?this._oApplyingChanges:Promise.resolve();i.then(()=>t(e))},()=>{this._bFieldInErrorState=true;t(e)}).catch(i=>{this._bFieldInErrorState=true;t(e)})}};E.prototype._determineValidationState=function(){return this.awaitControlDelegate().then(e=>e.determineValidationState(this,this.checkFilters()))};E.prototype._visualizeValidationState=function(e){if(this._oDelegate){this._oDelegate.visualizeValidationState(this,{status:e})}};E.prototype.getResourceFileText=function(e,t){return e?this._oRb.getText(e,t):""};E.prototype._restartCheckAndNotify=function(e){const t=this.checkFilters();this._checkAndNotify(e,t)};E.prototype._checkAndNotify=function(e,t){const i=function(){if(e||this._bFireSearch){const e={reason:this._sReason?this._sReason:y.Unclear};this._sReason=y.Unclear;this.fireSearch(e)}}.bind(this);const r=function(){this._bFieldInErrorState=false;this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;this._bFireSearch=false}.bind(this);if(t===m.AsyncValidation){this._handleAsyncValidation(e,this._restartCheckAndNotify.bind(this));return}if(t===m.OngoingChangeAppliance){this._handleOngoingChangeAppliance(e,this._restartCheckAndNotify.bind(this));return}if(t===m.NoError){if(this._fResolvedSearchPromise){i();this._fResolvedSearchPromise()}}else if(this._fRejectedSearchPromise){this._setFocusOnFirstErroneousField();this._fRejectedSearchPromise()}this._visualizeValidationState(t);r()};E.prototype._validate=function(e){const t=function(){this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null}.bind(this);if(this.bIsDestroyed){t();return}this._determineValidationState().then(t=>{this._checkAndNotify(e,t)})};E.prototype.setInternalConditions=function(e){const t=this._getConditionModel();if(t){t.setConditions(e)}};E.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true)};E.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise])};E.prototype.initialized=function(){return this.waitForInitialization()};E.prototype.initializedWithMetadata=function(){if(!this._oMetadataAppliedPromise){this._retrieveMetadata()}return this.waitForInitialization()};E.prototype._getModelConditions=function(e,t,i){const r={};if(e){const n=l({},e.getAllConditions());for(const e in n){if(n[e]&&(i||n[e].length>0)){r[e]=n[e];if(!t){this._cleanupConditions(r[e]);const t=this._stringifyConditions(e,r[e]);r[e]=t}}}}return r};E.prototype._isPathKnown=function(e,t){let i,r;if(!this._getPropertyByName(e)){return false}for(i in t["inParameters"]){r=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(r)){return false}}for(i in t["outParameters"]){r=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(r)){return false}}return true};E.prototype._onModifications=function(e){if(e&&e.indexOf("Filter")===-1){return Promise.resolve()}let t;if(!this._oApplyingChanges){this._oApplyingChanges=new Promise(e=>{t=e})}return this._setXConditions(this.getFilterConditions()).then(()=>{this._reportModelChange({triggerSearch:false,triggerFilterUpdate:true,recheckMissingRequired:true});t();this._oApplyingChanges=null})};E.prototype._setXConditions=function(e){if(e){let t=true;for(const i in e){const r=e[i];if(!this._isPathKnown(i,r)){t=false;break}}const i=t?Promise.resolve():this._retrieveMetadata();const r=this._getConditionModel();return i.then(()=>{const t=this._internalizeConditions(e);const i=this._getModelConditions(r,true);r.detachPropertyChange(this._handleConditionModelPropertyChange,this);try{return this.getEngine().diffState(this,{Filter:i},{Filter:t}).then(e=>{Object.keys(e.Filter).forEach(t=>{e.Filter[t].forEach(e=>{if(e.filtered!==false){r.addCondition(t,e)}else{r.removeCondition(t,e)}})});r.attachPropertyChange(this._handleConditionModelPropertyChange,this)})}catch(e){a.error(e.message);r.attachPropertyChange(this._handleConditionModelPropertyChange,this)}})}else{return Promise.resolve()}};E.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false)};E.prototype._getRequiredPropertyNames=function(){const e=[];this._getNonHiddenPropertyInfoSet().forEach(t=>{if(t.required){e.push(g.getPropertyKey(t))}});return e};E.prototype._getNonRequiredPropertyNames=function(){const e=[];this._getNonHiddenPropertyInfoSet().forEach(t=>{if(!t.required){e.push(g.getPropertyKey(t))}});return e};E.prototype._insertFilterFieldtoContent=function(e,t){if(!this._cLayoutItem){return}const i=this._cLayoutItem;const r=new i;r.setFilterField(e);this._oFilterBarLayout.insertFilterField(r,t)};E.prototype._filterItemInserted=function(e){if(!e.getVisible()){return}if(e.setWidth){e.setWidth("")}this._applyFilterItemInserted(e);this._handleAssignedFilterNames(true)};E.prototype._applyFilterItemInserted=function(e){let t;t=this.indexOfAggregation("filterItems",e);if(this.getAggregation("basicSearchField")){t++}const i=t;const r=this.getFilterItems();for(let e=0;e<i;e++){if(!r[e].getVisible()){t--}}this._handleAddedFilterField(e);this._insertFilterFieldtoContent(e,t);if(!this._oObserver.isObserved(e,{properties:["visible"]})){this._oObserver.observe(e,{properties:["visible"]})}};E.prototype._filterItemRemoved=function(e){this._handleRemovedFilterField(e);this._applyFilterItemRemoved(e.getPropertyKey());this._handleAssignedFilterNames(true)};E.prototype._applyFilterItemRemoved=function(e){this._removeFilterFieldFromContentByName(e)};E.prototype._removeFilterFieldFromContent=function(e){this._removeFilterFieldFromContentByName(e.getPropertyKey())};E.prototype._removeFilterFieldFromContentByName=function(e){const t=this._getFilterItemLayoutByName(e);if(t){this._oFilterBarLayout.removeFilterField(t);t.destroy()}};E.prototype._handleAddedFilterField=function(e){};E.prototype._handleRemovedFilterField=function(e){};E.prototype._observeChanges=function(e){let t;if(e.type==="aggregation"){if(e.name==="filterItems"){switch(e.mutation){case"insert":t=e.child;t=this._enhanceFilterField(t);t.attachChange(this._handleFilterItemChanges,this);t.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(t);break;case"remove":e.child.detachChange(this._handleFilterItemChanges,this);e.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(e.child);break;default:a.error("operation "+e.mutation+" not yet implemented")}}else if(e.name==="basicSearchField"){switch(e.mutation){case"insert":e.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(e.child,0);break;case"remove":e.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(e.child);break;default:a.error("operation "+e.mutation+" not yet implemented")}}}else if(e.type==="property"){if(e.object.isA&&e.object.isA("sap.ui.mdc.FilterField")){t=e.object;if(t){if(e.current){this._filterItemInserted(t)}else{this._filterItemRemoved(t)}this._oFilterBarLayout.invalidate()}}}};E.prototype._getFilterItemLayout=function(e){return this._getFilterItemLayoutByName(e.getPropertyKey())};E.prototype._getFilterItemLayoutByName=function(e){let t=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(i=>{if(i._getFieldPath()===e){t=i}return t!==null})}return t};E.prototype._getFilterField=function(e){let t=null;this.getFilterItems().some(i=>{if(i&&i.getPropertyKey()===e){t=i}return t!==null});return t};E.prototype._retrieveMetadata=function(){if(this.isPropertyHelperFinal()){return Promise.resolve()}if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise((e,t)=>{this._fResolveMetadataApplied=e;this._fRejectMetadataApplied=t});this.initControlDelegate().then(()=>{if(!this._bIsBeingDestroyed){const e=function(e){e?this._fResolveMetadataApplied():this._fRejectMetadataApplied();this._fResolveMetadataApplied=null;this._fRejectMetadataApplied=null}.bind(this);if(this.isControlDelegateInitialized()){this.finalizePropertyHelper().then(()=>{e(true)})}else{a.error("Delegate not initialized.");e(false)}}});return this._oMetadataAppliedPromise};E.prototype._enhanceFilterField=function(e){if(e){const t=e.getPropertyKey();if(!t){a.error("filter field with the id = '"+e.getId()+"' should have an assigned 'propertyKey'");return e}if(!e.getBindingInfo("conditions")){e.bindProperty("conditions",{path:`/conditions/${t}`,model:"$filters"})}let i=this._getPropertyByName(t);const r=this.getPropertyInfo();if(!i&&r.length>0){i=r.find(e=>e.key===t||e.name===t)}if(!i){if(!this.isA("sap.ui.mdc.valuehelp.FilterBar")){a.warning("Property '"+t+"' does not exist for filter field with the id = '"+e.getId()+"' on filter bar='"+this.getId()+"'")}P.checkMandatoryProperties(e);return e}P.compareControlWithPropertyInfo(e,i);e.triggerCheckCreateInternalContent()}return e};E.prototype.setBasicSearchField=function(e){const t=this.getAggregation("basicSearchField");if(t){this.removeAggregation("basicSearchField",t)}this.setAggregation("basicSearchField",e);if(e){this._enhanceBasicSearchField(e);if(!this._oObserver.isObserved(e,{properties:["visible"]})){this._oObserver.observe(e,{properties:["visible"]})}}return this};E.prototype._enhanceBasicSearchField=function(e){const t=e.getPropertyKey();if(t!==M){if(t||t===""){a.warning(`sap.ui.mdc.FilterBar: BasicSearchField has incorrect 'propertyKey' '${t}'. Overriding to default '${M}'`)}e.setPropertyKey(M)}this._enhanceFilterField(e)};E.prototype._getNonHiddenPropertyInfoSet=function(){const e=[];this.getPropertyInfoSet().every(t=>{if(!t.hiddenFilter){if(g.getPropertyKey(t)!==M){e.push(t)}}return true});return e};E.prototype._getNonHiddenPropertyByName=function(e){let t=null;this._getNonHiddenPropertyInfoSet().some(i=>{if(g.getPropertyKey(i)===e){t=i}return t!=null});return t};E.prototype._cleanUpFilterFieldInErrorStateByName=function(e){let t=null;const i=this.getFilterItems();i.some(i=>{if(i.getPropertyKey()===e){t=i}return t!=null});if(t){this._cleanUpFilterFieldInErrorState(t)}};E.prototype.cleanUpAllFilterFieldsInErrorState=function(){this._getConditionModel().checkUpdate(true);const e=this.getFilterItems();e.forEach(e=>{this._cleanUpFilterFieldInErrorState(e)})};E.prototype._cleanUpFilterFieldInErrorState=function(e){if(e&&e.getValueState()!==v.None){e.setValueState(v.None)}};E.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges().then(()=>{this._bIgnoreChanges=false;this._reportModelChange({triggerFilterUpdate:true,triggerSearch:false});this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null})};E.prototype._applyFilterConditionsChanges=function(){let e;const t=this.getProperty("filterConditions");if(Object.keys(t).length>0){e=l({},t);return this._setXConditions(e)}return Promise.resolve()};E.prototype._loadFlex=function(){return new Promise(e=>{t.load({name:"sap.ui.fl"}).then(()=>{sap.ui.require(["sap/ui/fl/apply/api/ControlVariantApplyAPI"],t=>{e(t)})}).catch(t=>{a.error(t);e(null)})})};E.prototype.setVariantBackreference=function(e){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",e);this._loadFlex().then(e=>{A=e;A.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true})})}else{a.error("the association 'variantBackreference' may only be assigned once and may not change afterwards.")}return this};E.prototype._handleVariantSwitch=function(e){this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(e);this._sReason=this._bExecuteOnSelect?y.Variant:y.Unclear;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;if(e.hasOwnProperty("createScenario")&&e.createScenario==="saveAs"){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true}return this.awaitPendingModification().then(e=>{this.cleanUpAllFilterFieldsInErrorState();if(this._bInitialFiltersApplied&&e.indexOf("Filter")===-1){this._reportModelChange({triggerFilterUpdate:false,triggerSearch:this._bExecuteOnSelect})}})};E.prototype._getExecuteOnSelectionOnVariant=function(e){let t=false;const i=this._getAssignedVariantManagement();if(i){t=i.getApplyAutomaticallyOnVariant(e)}return t};E.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false};E.prototype._getAssignedVariantManagement=function(){const t=this.getVariantBackreference();if(t){const i=e.getElementById(t);if(i&&i.isA("sap.ui.fl.variants.VariantManagement")){return i}}return null};E.prototype._getView=function(){return g.getView(this)};E.prototype.getConditions=function(){const e=this.getCurrentState().filter;if(e&&e[M]){delete e[M]}return e};E.prototype.getSearch=function(){const e=this._getConditionModel()?this._getConditionModel().getConditions(M):[];return e[0]?e[0].values[0]:""};E.prototype.exit=function(){if(this._hasAssignedVariantManagement()&&A){A.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});A=undefined}if(this.isControlDelegateInitialized()&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this)}s.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null}this._oObserver.disconnect();this._oObserver=undefined;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aOngoingChangeAppliance=null};return E});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/FilterBarBaseRenderer", [],()=>{"use strict";const e={apiVersion:2};e.CSS_CLASS="sapUiMdcFilterBarBase";e.render=function(t,i){t.openStart("div",i);t.class(e.CSS_CLASS);if(i.isA("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar")&&i.getProperty("_useFixedWidth")){t.style("width",i.getWidth())}t.openEnd();const r=i.getAggregation("layout")?i.getAggregation("layout").getInner():null;t.renderControl(r);t.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/IFilterContainer", ["sap/ui/core/Element"],t=>{"use strict";const e=t.extend("sap.ui.mdc.filterbar.IFilterContainer",{metadata:{library:"sap.ui.mdc"}});e.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oLayout=null};e.prototype.getInner=function(){return this.oLayout};e.prototype.insertFilterField=function(t,e){};e.prototype.removeFilterField=function(t){};e.prototype.getFilterFields=function(){};e.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this.oLayout){this.oLayout.destroy();this.oLayout=null}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/PropertyHelper", ["../util/PropertyHelper"],e=>{"use strict";const t=e.extend("sap.ui.mdc.filterbar.PropertyHelper",{constructor:function(t,r){e.call(this,t,r,{required:{type:"boolean"},hiddenFilter:{type:"boolean"}})}});t.prototype.prepareProperty=function(t,r){if(!t.typeConfig){const e=this.getParent();if(e&&e._oDelegate){const r=e._oDelegate.getTypeMap(e);try{t.typeConfig=r.getTypeConfig(t.dataType,t.formatOptions,t.constraints)}catch(e){}}}e.prototype.prepareProperty.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/PropertyInfoValidator", ["sap/base/Log","sap/base/util/deepEqual"],(r,t)=>{"use strict";const e={dataType:"dataType",dataTypeConstraints:"constraints",dataTypeFormatOptions:"formatOptions",label:"label",maxConditions:"maxConditions"};const o={};o._getPropertyInfoPropertyName=function(r){return e[r]??r};o._getPropertyNameFromPropertyInfo=function(r){const t=Object.entries(e).filter(([t,e])=>e===r);if(t.length===0){return r}const[o]=t;const[n]=o;return n};o.checkMandatoryProperty=(t,e)=>{if(!t||!e){r.warning(`sap.ui.mdc.util.PropertyInfoValidator:checkMandatoryProperty either Control or property name are not defined.`);return false}if(t.isPropertyInitial(e)){return false}const o=t.getProperty(e);if(o===undefined||o===null||o===""){r.error(`sap.ui.mdc.util.PropertyInfoValidator: Control '${t.getId()}' is missing mandatory property '${e}'`);return false}return true};o.checkMandatoryProperties=r=>{const t=Object.keys(e);let n=true;for(const e of t){if(!o.checkMandatoryProperty(r,e)){n=false}}return n};o.comparePropertyInfoWithControl=(t,e)=>{if(!t||!e){return}const n=["name","key","group","groupLabel"];const a=Object.keys(e).filter(r=>!n.includes(r));if(!a.length){return}const i=a.filter(r=>{const e=o._getPropertyNameFromPropertyInfo(r)??r;return!t.isPropertyInitial(e)});if(a.length>i.length){r.error(`sap.ui.mdc.util.PropertyInfoValidator: the propertyInfo for Control '${t.getId()}' contains more information than the control itself!`)}};o.compareControlWithPropertyInfo=(n,a)=>{if(!n||!a){return}const i=[...Object.keys(e),"required"];for(const e of i){const i=o.checkMandatoryProperty(n,e);const s=o._getPropertyInfoPropertyName(e)??e;if(!i){if(a.hasOwnProperty(s)&&(typeof a[s]==="boolean"||a[s])){n.setProperty(e,a[s])}continue}if(i&&a.hasOwnProperty(s)){const o=a[s],i=n.getProperty(e);const p=o===i||t(o,i);if(!p){r.error(`sap.ui.mdc.util.PropertyInfoValidator: Control '${n.getId()}' with mandatory property '${e}' has a different value for property '${s}' in given 'propertyInfo'!`)}}}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/aligned/FilterContainer", ["sap/base/i18n/Localization","sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/m/Text"],(t,o,i,e,a,n)=>{"use strict";const s=o.extend("sap.ui.mdc.filterbar.aligned.FilterContainer",{metadata:{library:"sap.ui.mdc"}});s.prototype.init=function(){o.prototype.init.apply(this,arguments);this.oLayout=new i};s.prototype.exit=function(){o.prototype.exit.apply(this,arguments);if(this._oButtonsLayout){this._oButtonsLayout=null}};s.prototype.addButton=function(o){if(!this._oButtonsLayout){this._oButtonsLayout=new e;if(t.getRTL()){this._oButtonsLayout.addStyleClass("sapUiMdcFilterBarBaseFloatLeft")}else{this._oButtonsLayout.addStyleClass("sapUiMdcFilterBarBaseFloatRight")}this._oButtonsLayout.addContent(new n);this._oButtonsLayout.addContent(new a);this.oLayout.addEndContent(this._oButtonsLayout)}this._oButtonsLayout.getContent()[1].addContent(o)};s.prototype.insertFilterField=function(t,o){this.oLayout.insertContent(t,o)};s.prototype.removeFilterField=function(t){this.oLayout.removeContent(t)};s.prototype.getFilterFields=function(){return this.oLayout.getContent()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/aligned/FilterItemLayout", ["sap/ui/layout/VerticalLayout","sap/ui/layout/VerticalLayoutRenderer","sap/m/Label"],(e,t,i)=>{"use strict";const l=e.extend("sap.ui.mdc.filterbar.aligned.FilterItemLayout",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2,render:t.render}});l.prototype._setLabel=function(e){this._oLabel=new i(e.getId()+"-label",{required:e.getRequired()});this._oLabel.setParent(this);e.connectLabel(this._oLabel);if(this._getFieldPath()==="$search"){this._oLabel.setText(" ")}else{this._oLabel.addStyleClass("sapUiMdcFilterBarBaseLabel")}};l.prototype._getFilterField=function(){return this._oFilterField};l.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};l.prototype.setFilterField=function(e){this._oFilterField=e;this._setLabel(e)};l.prototype.getContent=function(){const e=[];e.push(this._oLabel);e.push(this._oFilterField);return e};l.prototype.exit=function(){this._oFilterField=null;if(this._oLabel&&!this._oLabel.bIsDestroyed){this._oLabel.destroy();this._oLabel=undefined}e.prototype.exit.apply(this,arguments)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/AdaptationFilterBar", ["sap/ui/core/Element","sap/ui/core/library","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/base/util/merge","sap/m/p13n/enums/PersistenceMode"],(t,e,i,o,n,r,a,s,l,p,h,c)=>{"use strict";const{ValueState:d}=e;const u=l.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{metadata:{library:"sap.ui.mdc",properties:{_useFixedWidth:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{adaptationControl:{type:"sap.ui.mdc.Control",multiple:false}},events:{change:{}}},renderer:p});u.prototype.WIDTH="30rem";u.prototype.getVerticalScrolling=function(){return this._oFilterBarLayout.getInner().getVerticalScrolling instanceof Function?this._oFilterBarLayout.getInner().getVerticalScrolling():false};u.prototype.init=function(){l.prototype.init.apply(this,arguments);this.addStyleClass("sapUIAdaptationFilterBar");this.getEngine().defaultProviderRegistry.attach(this,c.Transient);this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=new Promise((t,e)=>{this._fnResolveAdaptationControlPromise=t})};u.prototype.keepAlive=function(){return true};u.prototype._onModifications=function(){const t=l.prototype._onModifications.apply(this,arguments);if(this._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.FilterPanel")){const t=this._oFilterBarLayout.getInner().getP13nData();this._updateActiveStatus(t);this._oFilterBarLayout.setP13nData({items:t})}return t};u.prototype.getInitialFocusedControl=function(){return this._oFilterBarLayout.getInitialFocusedControl()};u.prototype.getWidth=function(){return this.WIDTH};u.prototype.applySettings=function(){l.prototype._applySettings.apply(this,arguments);this._waitForAdaptControlAndPropertyHelper().then(()=>{this._initControlDelegate()})};u.prototype.setVisibleFields=function(t){const e=this._getAdaptationControlInstance();if(this._checkAdvancedParent(e)){throw new Error("Only supported for simple parents")}this._aVisibleKeys=t};u.prototype._getPropertyByName=function(t){let e=l.prototype._getPropertyByName.apply(this,arguments);const i=this.getPropertyHelper();if(!e||e.filterable===false){e=i.getProperties().find(e=>e.path===t&&e.filterable)}return e};u.prototype._waitForAdaptControlAndPropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitPropertyHelper().then(t=>{this._oPropertyHelper=t}))};u.prototype._initControlDelegate=function(){return this.initControlDelegate().then(()=>{if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions()}})};u.prototype.getControlDelegate=function(){return this._getAdaptationControlInstance().getControlDelegate()};u.prototype.initControlDelegate=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().initControlDelegate())};u.prototype.awaitControlDelegate=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitControlDelegate())};u.prototype.initPropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().initPropertyHelper())};u.prototype.finalizePropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().finalizePropertyHelper())};u.prototype.getTypeUtil=function(){return this.getTypeMap()};u.prototype.getTypeMap=function(){if(!this._getAdaptationControlInstance()){throw new Error("No adaptation control assigned yet.")}return this._getAdaptationControlInstance().getTypeMap()};u.prototype.setMessageStrip=function(t){this._oFilterBarLayout.setMessageStrip(t)};u.prototype.setLiveMode=function(t,e){l.prototype.setLiveMode.apply(this,arguments);this._oConditionModel.attachPropertyChange(t=>{const e=t.getParameter("path").substring(12);if(this.oAdaptationData){const t=this.oAdaptationData.items;const i=t.find(t=>t.name==e);if(i&&this._checkAdvancedParent(this._getAdaptationControlInstance())){i.active=this._getConditionModel().getConditions(e).length>0?true:false}}});return this};u.prototype._retrieveMetadata=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){if(!this._getAdaptationControlInstance().isPropertyHelperFinal()){return this.finalizePropertyHelper()}return l.prototype._retrieveMetadata.apply(this,arguments)}.bind(this)))};u.prototype.isControlDelegateInitialized=function(){return this._getAdaptationControlInstance().isControlDelegateInitialized()};u.prototype.createConditionChanges=function(){return Promise.all([this._oAdaptationControlPromise,this.awaitControlDelegate()]).then(()=>{const t=this._getModelConditions(this._getConditionModel(),false,true);return this.getEngine().createChanges({control:this._getAdaptationControlInstance(),applyAbsolute:true,key:"Filter",state:t,suppressAppliance:true})})};u.prototype.setP13nData=function(t){this.oAdaptationData=t;this._getConditionModel().checkUpdate(true);this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.update(t)};u.prototype._updateActiveStatus=function(t){const e=this.getFilterConditions();t.forEach(t=>{const i=this.mFilterFields&&this.mFilterFields[t.name];if(i){const o=i.getPropertyKey();if(e[o]&&e[o].length>0){t.active=true}}})};u.prototype.getP13nData=function(){if(this._aVisibleKeys&&this._aVisibleKeys.length>0){this.oAdaptationData.items.forEach(function(t){if(this._aVisibleKeys.indexOf(t.name)>-1){t.active=true}},this)}return this.oAdaptationData};u.prototype._handleFilterItemSubmit=function(){return};u.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this._getAdaptationControlInstance())};u.prototype.createFilterFields=function(){return this.initializedWithMetadata().then(()=>{const t=this._getAdaptationControlInstance().getFilterConditions();this.setFilterConditions(t);const e=this._setXConditions(t);if(this._bFilterFieldsCreated){return e.then(()=>{this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.setP13nData(this.getP13nData());return this})}const i=this._getAdaptationControlInstance();const o=i.getControlDelegate();const n=this._checkAdvancedParent(i)?o:o.getFilterDelegate();this._mOriginalsForClone={};this.mFilterFields={};const r=[];this.getP13nData().items.forEach((t,e)=>{const o=this._checkExisting(t,n);o.then(e=>{let n;if(this._checkAdvancedParent(i)){if(e._bTemporaryOriginal){delete o._bTemporaryOriginal;this._mOriginalsForClone[e.getPropertyKey()]=e}n=e.clone();if(i._handleFilterItemChanges){n.detachChange(i._handleFilterItemChanges,i)}if(i._handleFilterItemSubmit){n.detachSubmit(i._handleFilterItemSubmit,i)}if(n.getValueState()!==d.None){n.setValueState(d.None);n.setValueStateText()}}else{n=e}this.mFilterFields[t.name]=n});r.push(o)});return Promise.all(r).then(()=>{const t=this.getP13nData();t.items.forEach(t=>{this.addAggregation("filterItems",this.mFilterFields[t.name])});this._attachFields();this._updateActiveStatus(t.items);this._oFilterBarLayout.setP13nData(t);this._bFilterFieldsCreated=true;return this})})};u.prototype._attachFields=function(){this.getFilterItems().forEach(t=>{t.attachChange(t=>{this.fireChange()})})};u.prototype._checkExisting=function(t,e){let i;const o=this._getAdaptationControlInstance();const n=this._checkAdvancedParent(o)?o.getFilterItems():[];const r=n.reduce((t,e)=>{t[e.getPropertyKey()]=e;return t},{});if(r[t.name]){i=Promise.resolve(r[t.name])}else{i=e.addItem(this._getAdaptationControlInstance(),t.name);i=i.then(e=>{if(!e){throw new Error("No FilterField could be created for property: '"+t.name+"'.")}e._bTemporaryOriginal=true;return e})}return i};u.prototype.executeRemoves=function(){const t=this._oFilterBarLayout.getInner().getSelectedFields();const e=[];Object.keys(this._mOriginalsForClone).forEach(i=>{const o=this._getAdaptationControlInstance().getControlDelegate();if(t.indexOf(i)<0){const t=o.removeItem.call(o,this._getAdaptationControlInstance(),i).then(t=>{if(t&&this._mOriginalsForClone[i]){this._mOriginalsForClone[i].destroy();delete this._mOriginalsForClone[i]}});e.push(t)}});return Promise.all(e)};u.prototype._checkAdvancedParent=function(t){if(!t.isA("sap.ui.mdc.IFilterSource")&&!t.isA("sap.ui.mdc.IFilter")){throw new Error("The 'adaptationControl' needs to implement the IFilterSource or IFilter interface")}return t.isA("sap.ui.mdc.IFilter")};u.prototype.setAdaptationControl=function(t,e){if(this._fnResolveAdaptationControlPromise){this._fnResolveAdaptationControlPromise();this._fnResolveAdaptationControlPromise=null}this.setAssociation("adaptationControl",t,e);this._cLayoutItem=a;this._oFilterBarLayout=this._checkAdvancedParent(t)?new n:new s;this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(t=>{if(t.getParameter("reason")==="Remove"){const e=t.getParameter("item");const i={};i[this.mFilterFields[e.name].getPropertyKey()]=[];return this.getEngine().createChanges({control:this,applyAbsolute:true,key:"Filter",state:i})}this.fireChange()})}return this};u.prototype._getAdaptationControlInstance=function(){const e=this.getAdaptationControl();return e&&t.getElementById(e)};u.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);l.prototype.exit.apply(this,arguments);for(const t in this._mOriginalsForClone){this._mOriginalsForClone[t].destroy()}this._mOriginalsForClone=null;this.oAdaptationData=null;this.mFilterFields=null;this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=null};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/FilterColumnLayout", ["sap/m/ColumnListItem","sap/m/ColumnListItemRenderer","sap/m/Label"],(t,e,i)=>{"use strict";const r=t.extend("sap.ui.mdc.filterbar.p13n.FilterColumnLayout",{metadata:{library:"sap.ui.mdc"},renderer:e});r.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};r.prototype.setFilterField=function(t){this._oFilterField=t;this._sLabel=t.getLabel()};r.prototype.getCells=function(){const t=[];const e=new i({text:this._sLabel});e.setParent(this);t.push(e);t.push(this._oFilterField);return t};r.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oFilterField=null};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/FilterGroupLayout", ["sap/ui/core/Control"],t=>{"use strict";const e=t.extend("sap.ui.mdc.filterbar.p13n.FilterGroupLayout",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("height","100%");t.openEnd();t.renderControl(e.getItems()[0]);t.close("div")}}});e.prototype._getFieldPath=function(){return this._oFilterField?this._oFilterField.getPropertyKey():null};e.prototype.setFilterField=function(t){this._oFilterField=t};e.prototype.getIdForLabel=function(){return this._oFilterField&&this._oFilterField.getIdForLabel()};e.prototype.getAccessibilityInfo=function(){return{children:this.getItems()}};e.prototype.getItems=function(){const t=[];t.push(this._oFilterField);return t};e.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oFilterField=null};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/GroupContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/mdc/p13n/panels/AdaptFiltersPanel"],(t,e)=>{"use strict";const i=t.extend("sap.ui.mdc.filterbar.p13n.GroupContainer",{metadata:{library:"sap.ui.mdc"}});i.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mFilterItems={};this.oLayout=new e;this.oLayout.setItemFactory(t=>{const e=t.getProperty(t.sPath).name;const i=this.mFilterItems[e];return i})};i.prototype.setMessageStrip=function(t){this.oLayout.getCurrentViewContent().setMessageStrip(t)};i.prototype.insertFilterField=function(t,e){this.mFilterItems[t._getFieldPath()]=t};i.prototype.removeFilterField=function(t){this.oLayout.removeItem(t)};i.prototype.getFilterFields=function(){const t=[];Object.keys(this.mFilterItems).forEach(e=>{t.push(this.mFilterItems[e])});return t};i.prototype.update=function(t){this.oLayout.restoreDefaults()};i.prototype.setP13nData=function(t){this.oLayout.setP13nData(t)};i.prototype.exit=function(){this.mFilterItems=null;this.mFilterFields=null;t.prototype.exit.apply(this,arguments)};i.prototype.getInitialFocusedControl=function(){return this.oLayout.getInitialFocusedControl&&this.oLayout.getInitialFocusedControl()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/p13n/TableContainer", ["sap/ui/core/Lib","sap/ui/mdc/filterbar/IFilterContainer","sap/m/Table","sap/m/Column","sap/m/Text","sap/m/VBox","sap/ui/mdc/p13n/panels/FilterPanel"],(t,e,i,o,n,r,a)=>{"use strict";const s=e.extend("sap.ui.mdc.filterbar.p13n.TableContainer",{metadata:{library:"sap.ui.mdc"}});s.prototype.init=function(){e.prototype.init.apply(this,arguments);const r=t.getResourceBundleFor("sap.ui.mdc");this._oTable=new i({sticky:["ColumnHeaders"],growing:true,columns:[new o({header:new n({text:r.getText("filter.AdaptationFilterBar_FIELD_COLUMN")})}),new o({header:new n({text:r.getText("filter.AdaptationFilterBar_FIELD_VALUE_COLUMN")})})]});this.oLayout=new a({enableReorder:false,itemFactory:function(t){const e=t.name;const i=this.mFilterItems[e];return i}.bind(this)});this.mFilterItems={}};s.prototype.insertFilterField=function(t,e){const i=t._oFilterField.getParent();const o=i._getPropertyByName(t._getFieldPath());if(o){this.mFilterItems[o.name]=t}};s.prototype.setP13nData=function(t){this.oLayout.setP13nData(t.items)};s.prototype.removeFilterField=function(t){this._oTable.removeItem(t)};s.prototype.setMessageStrip=function(t){this.oLayout.setMessageStrip(t)};s.prototype.getFilterFields=function(){return this._oTable.getItems()};s.prototype.update=function(t){};s.prototype.exit=function(){this._oTable=null};s.prototype.getInitialFocusedControl=function(){return this.oLayout.getInitialFocusedControl&&this.oLayout.getInitialFocusedControl()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/CollectiveSearchSelect", ["sap/ui/mdc/valuehelp/CollectiveSearchSelect"],e=>{"use strict";const t=e.extend("sap.ui.mdc.filterbar.vh.CollectiveSearchSelect",{metadata:{library:"sap.ui.mdc"},renderer:e.getMetadata().getRenderer()});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterBar", ["sap/ui/mdc/valuehelp/FilterBar"],e=>{"use strict";const r=e.extend("sap.ui.mdc.filterbar.vh.FilterBar",{metadata:{library:"sap.ui.mdc"},renderer:e.getMetadata().getRenderer()});return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterBarDelegate", ["sap/ui/mdc/valuehelp/FilterBarDelegate"],e=>{"use strict";return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/filterbar/vh/FilterContainer", ["sap/ui/mdc/valuehelp/FilterContainer"],e=>{"use strict";const a=e.extend("sap.ui.mdc.filterbar.vh.FilterContainer",{metadata:{library:"sap.ui.mdc"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ActionToolbar.flexibility", ["./ItemBaseFlex","./Util","sap/ui/fl/changeHandler/common/ChangeCategories","./actiontoolbar/CombineAction","./actiontoolbar/SplitAction"],(e,t,n,i,a)=>{"use strict";const o=Object.assign({},e);o.findItem=function(e,t,n){return t.find(t=>e.getId(t)===n)};o.determineAggregation=function(e,t){return e.getAggregation(t,"actions").then(e=>({name:"actions",items:e}))};o._applyMove=function(e,n,i,a){const o=a===t.REVERT?true:false;const r=i.modifier;if(r.getParent(n)){const e=r.getParent(n);if(r.getControlType(e)==="sap.ui.mdc.Chart"){n=e}else if(r.getParent(e)&&r.getControlType(r.getParent(e))==="sap.ui.mdc.Table"){n=r.getParent(e)}}this.beforeApply(e.getChangeType(),n,o);if(this._bSupressFlickering){this._delayInvalidate(n)}const g=o?e.getRevertData():e.getContent();let s;let c;let d;let l;const u=this.determineAggregation(r,n).then(e=>{c=e;return this._getExistingAggregationItem(g,i,n)}).then(e=>{s=e}).then(()=>{if(!s){throw new Error("No corresponding item in "+c.name+" found. Change to move item cannot be "+this._getOperationText(o)+"at this moment")}l=r.getId(s);return r.findIndexInParentAggregation(s)}).then(e=>{d=e;return r.removeAggregation(n,c.name,s).then(()=>r.insertAggregation(n,c.name,s,g.index))}).then(()=>{if(o){e.resetRevertData()}else{e.setRevertData({name:g.name,index:d,item:l})}this.afterApply(e.getChangeType(),n,o)});return u};o.getChangeVisualizationInfo=function(e,i){const a=e.getContent();const o=i.byId(e.getSelector().id);let r;const g=[a.name];const s={descriptionPayload:{}};if(e.getChangeType()==="moveAction"){s.descriptionPayload.category=n.MOVE;r="actiontoolbar.ITEM_MOVE_CHANGE";g.push(e.getRevertData().index);g.push(a.index)}if(o){const e=i.byId(a.name);if(e){g.splice(0,1,e.getLabel())}}return t.getMdcResourceText(r,g).then(e=>{s.descriptionPayload.description=e;s.updateRequired=true;return s})};return{moveAction:o.createMoveChangeHandler(),combineButtons:{changeHandler:i},splitMenuButton:{changeHandler:a}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ActionToolbarAction.flexibility", [],()=>{"use strict";return{unhideControl:{changeHandler:"default"},hideControl:{changeHandler:"default"}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/AggregateFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],(e,t,n)=>{"use strict";const o=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const r=function(e,n,r,a){return new Promise((s,i)=>{const g=a===t.REVERT;const c=r.modifier;const d=g?e.getRevertData():e.getContent();Promise.resolve().then(c.getProperty.bind(c,n,"aggregateConditions")).then(t=>{const r=t?t:{};r[d.name]={};const a={name:d.name};c.setProperty(n,"aggregateConditions",r);o(e,n,a,g);s()}).catch(e=>{i(e)})})};const a=function(e,n,r,a){return new Promise((s,i)=>{const g=a===t.REVERT;const c=r.modifier;const d=g?e.getRevertData():e.getContent();Promise.resolve().then(c.getProperty.bind(c,n,"aggregateConditions")).then(t=>{const r=t?t:{};if(!r){i()}delete r[d.name];c.setProperty(n,"aggregateConditions",r);o(e,n,d,g);s()}).catch(e=>{i(e)})})};const s={};const i=function(e,t){const o=e.getContent();return{classification:n.Reverse,affectedControl:e.getSelector(),uniqueKey:"aggregate"+"_"+o.name}};s.addAggregate=t.createChangeHandler({apply:r,revert:a,getCondenserInfo:i});s.removeAggregate=t.createChangeHandler({apply:a,revert:r,getCondenserInfo:i});return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Chart.flexibility", ["./SortFlex","./ChartItemFlex","./ConditionFlex","./ChartTypeFlex"],(e,t,o,r)=>{"use strict";return{addItem:t.addItem,removeItem:t.removeItem,moveItem:t.moveItem,setChartType:r.setChartType,removeSort:e.removeSort,addSort:e.addSort,moveSort:e.moveSort,addCondition:o.addCondition,removeCondition:o.removeCondition}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ChartItemFlex", ["./ItemBaseFlex","./Util","sap/ui/fl/changeHandler/common/ChangeCategories","sap/ui/mdc/chart/Util"],(e,t,r,a)=>{"use strict";const n=Object.assign({},e);n.beforeAddItem=function(e,t,r,a,n){return e.addItem.call(e,r,t,a,n.role)};n.findItem=function(e,t,r){return t.reduce((t,a)=>t.then(t=>{if(!t){return Promise.all([e.getProperty(a,"propertyKey"),e.getProperty(a,"key")]).then(e=>{if(e[0]===r||e[1]===r){return a}})}return t}),Promise.resolve())};n.getChangeVisualizationInfo=function(e,n){const o=e.getContent();const i=n.byId(e.getSelector().id);let d;const c=[o.name];const l={descriptionPayload:{}};if(e.getChangeType()==="addItem"){l.descriptionPayload.category=r.ADD;d="chart.ITEM_ADD_CHANGE";c.push(o.index);c.push(o.role)}else if(e.getChangeType()==="removeItem"){l.descriptionPayload.category=r.REMOVE;d="chart.ITEM_DEL_CHANGE"}else if(e.getChangeType()==="moveItem"){l.descriptionPayload.category=r.MOVE;d="chart.ITEM_MOVE_CHANGE";c.push(e.getRevertData().index);c.push(o.index)}const s=i?.getPropertyHelper();if(s){let t;const r=s.getProperty(o.name);if(r){if(r.isAggregatable()){t="aggregatable";d+="_MEAS"}else if(r.groupable){t="groupable";d+="_DIM"}c.splice(0,1,r.label)}if(e.getChangeType()==="addItem"&&t){const e=a.getLayoutOptionTextForTypeAndRole(t,o.role);if(e){c.splice(2,1,e)}}}return t.getMdcResourceText(d,c).then(e=>{l.descriptionPayload.description=e;l.updateRequired=true;return l})};n.addItem=n.createAddChangeHandler();n.removeItem=n.createRemoveChangeHandler();n.moveItem=n.createMoveChangeHandler();return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ChartTypeFlex", ["sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],(e,t)=>{"use strict";const r={};const n=function(e,t,r){const n=r.modifier;return Promise.resolve().then(n.getProperty.bind(n,t,"chartType")).then(r=>{e.setRevertData(r);n.setProperty(t,"chartType",e.getContent().chartType)})};const a=function(e,t,r){r.modifier.setProperty(t,"chartType",e.getRevertData());e.resetRevertData();return Promise.resolve()};const i=function(e,r){return{classification:t.LastOneWins,affectedControl:e.getSelector(),uniqueKey:"chartType"}};r.setChartType=e.createChangeHandler({apply:n,revert:a,getCondenserInfo:i});return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ColumnFlex", ["./ItemBaseFlex","./Util","sap/ui/fl/changeHandler/common/ChangeCategories"],(e,t,n)=>{"use strict";const r=Object.assign({},e);r.findItem=function(e,t,n){return t.reduce((t,r)=>t.then(t=>{if(!t){return Promise.all([e.getProperty(r,"propertyKey"),e.getProperty(r,"dataProperty")]).then(e=>{if(e[0]===n||e[1]===n){return r}})}return t}),Promise.resolve())};r.getChangeVisualizationInfo=function(e,r){const o=e.getContent();const a=r.byId(e.getSelector().id);let i;const d=[o.name];const l={descriptionPayload:{}};if(e.getChangeType()==="addColumn"){l.descriptionPayload.category=n.ADD;i="table.ITEM_ADD_CHANGE";d.push(o.index)}else if(e.getChangeType()==="removeColumn"){l.descriptionPayload.category=n.REMOVE;i="table.ITEM_DEL_CHANGE"}else if(e.getChangeType()==="moveColumn"){l.descriptionPayload.category=n.MOVE;i="table.ITEM_MOVE_CHANGE";d.push(e.getRevertData().index);d.push(o.index)}if(a){const e=a.getPropertyHelper()?.getProperty(o.name);if(e){d.splice(0,1,e.label)}}return t.getMdcResourceText(i,d).then(e=>{l.descriptionPayload.description=e;l.updateRequired=true;return l})};r.addColumn=r.createAddChangeHandler();r.removeColumn=r.createRemoveChangeHandler();r.moveColumn=r.createMoveChangeHandler();return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ConditionFlex", ["sap/base/util/merge","sap/base/Log","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/common/ChangeCategories"],(e,t,n,i,o,r)=>{"use strict";const a=function(e,t){const n=function(t){if(e._pQueue===t){delete e._pQueue}};e._pQueue=e._pQueue instanceof Promise?e._pQueue.then(t):t();e._pQueue.then(n.bind(null,e._pQueue));return e._pQueue};const l=function(o,r,l,c){const s=c===i.REVERT;const d=s?o.getRevertData():o.getContent();let u,g=null;const f=l.modifier;return a(r,()=>f.getProperty(r,"filterConditions").then(a=>{u=e({},a);if(u){for(const e in u){if(e===d.name){g=u[e];break}}}if(!g){u[d.name]=[];g=u[d.name]}if(!s){o.setRevertData({name:d.name,condition:d.condition})}const c=n.indexOfCondition(d.condition,g);if(c<0){g.push(d.condition);f.setProperty(r,"filterConditions",u);return f.getProperty(r,"delegate").then(e=>i.getModule(e.name)).then(e=>{const n=e&&(e.getFilterDelegate?e.getFilterDelegate().addCondition:e.addCondition);if(n){return n(r,d.name,l).catch(e=>{t.error("Error during Delegate.addCondition call: "+e)})}}).finally(()=>{if(s){o.resetRevertData()}})}}))};const c=function(o,r,l,c){const s=c===i.REVERT;const d=s?o.getRevertData():o.getContent();let u,g,f=-1;const p=l.modifier;return a(r,()=>p.getProperty(r,"filterConditions").then(a=>{u=e({},a);if(u){for(const e in u){if(e===d.name){g=u[e];break}}}if(!s){o.setRevertData({name:d.name,condition:d.condition})}if(g&&g.length>0){f=n.indexOfCondition(d.condition,g);if(f>=0){g.splice(f,1);p.setProperty(r,"filterConditions",u);return p.getProperty(r,"delegate").then(e=>i.getModule(e.name)).then(e=>{const n=e&&(e.getFilterDelegate?e.getFilterDelegate().removeCondition:e.removeCondition);if(n){return n(r,d.name,l).catch(e=>{t.error("Error during Delegate.removeCondition call: "+e)})}}).finally(()=>{if(s){o.resetRevertData()}})}}}))};const s=function(e,t){const n=e.getContent();return{classification:o.Reverse,affectedControl:e.getSelector(),uniqueKey:n.name+"_"+JSON.stringify(n.condition)}};const d=function(e,t){const o=e.getContent();const a=t.byId(e.getSelector().id);const l={descriptionPayload:{}};let c;let s=[o.name,o.condition.operator];let d;if(e.getChangeType()==="addCondition"){l.descriptionPayload.category=r.ADD;c="filterbar.COND_ADD_CHANGE"}else{l.descriptionPayload.category=r.REMOVE;c="filterbar.COND_DEL_CHANGE"}const u=a?.getPropertyHelper()?.getProperty(o.name);if(u){s.splice(0,1,u.label);const e=n.getOperator(o.condition.operator);if(e){const t=e.getLongText(u.dataType);if(t){s.splice(1,1,t)}let n=null;if(a.getInternalConditions){n=a.getInternalConditions()}else if(a.getInbuiltFilter&&a.getInbuiltFilter()&&a.getInbuiltFilter().getInternalConditions){n=a.getInbuiltFilter().getInternalConditions()}if(o.condition.values.length>0&&n){const t=n[o.name];const i=t?.find(e=>e.values[0]===o.condition.values[0]);if(i){d=e.format(i,u.typeConfig.typeInstance,u.display,true);if(d){s.push(d)}}}}}if(!d){if(o.condition.values.length===2){c+="_2";s=s.concat(o.condition.values)}else if(o.condition.values.length>2){c+="_3";s=s.concat(o.condition.values)}else if(o.condition.values.length===0){c+="_0"}}s=s.concat(d?d:o.condition.values);return i.getMdcResourceText(c,s).then(e=>{l.descriptionPayload.description=e;l.updateRequired=true;return l})};const u={};u.addCondition=i.createChangeHandler({apply:l,revert:c,getCondenserInfo:s,getChangeVisualizationInfo:d});u.removeCondition=i.createChangeHandler({apply:c,revert:l,getCondenserInfo:s,getChangeVisualizationInfo:d});return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/FilterBar.flexibility", ["./FilterItemFlex","./ConditionFlex","./PropertyInfoFlex"],(e,r,o)=>{"use strict";return{addFilter:e.createAddChangeHandler(),removeFilter:e.createRemoveChangeHandler(),moveFilter:e.createMoveChangeHandler(),addCondition:r.addCondition,removeCondition:r.removeCondition,addPropertyInfo:o.addPropertyInfo}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/FilterItemFlex", ["./ItemBaseFlex","./Util","sap/ui/fl/changeHandler/common/ChangeCategories"],(e,t,r)=>{"use strict";const n=Object.assign({},e);n.findItem=function(e,t,r){return t.reduce((t,n)=>t.then(t=>{if(!t){return e.getProperty(n,"propertyKey").then(e=>{if(e===r){return n}})}return t}),Promise.resolve())};n.beforeApply=function(e){if(e.applyConditionsAfterChangesApplied){e.applyConditionsAfterChangesApplied()}};n.getChangeVisualizationInfo=function(e,n){const i=e.getContent();const a=n.byId(e.getSelector().id);let o;const d=[i.name];const l={descriptionPayload:{}};if(e.getChangeType()==="addFilter"){l.descriptionPayload.category=r.ADD;o="filterbar.ITEM_ADD_CHANGE";d.push(i.index)}else if(e.getChangeType()==="removeFilter"){l.descriptionPayload.category=r.REMOVE;o="filterbar.ITEM_DEL_CHANGE"}else if(e.getChangeType()==="moveFilter"){l.descriptionPayload.category=r.MOVE;o="filterbar.ITEM_MOVE_CHANGE";d.push(e.getRevertData().index);d.push(i.index)}const s=a?.getPropertyHelper()?.getProperty(i.name);if(s){d.splice(0,1,s.label)}return t.getMdcResourceText(o,d).then(e=>{l.descriptionPayload.description=e;l.updateRequired=true;return l})};n.addFilter=n.createAddChangeHandler();n.removeFilter=n.createRemoveChangeHandler();n.moveFilter=n.createMoveChangeHandler();return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/GroupFlex", ["./Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/common/ChangeCategories","./helpers/addKeyOrName"],(e,t,n,o,r)=>{"use strict";const i=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const a=function(t,n,o,a){return new Promise((s,g)=>{const c=a===e.REVERT;const d=o.modifier;const p=r(c?t.getRevertData():t.getContent());Promise.resolve().then(d.getProperty.bind(d,n,"groupConditions")).then(e=>{const o=e?e.groupLevels:[];const r={key:p.key,name:p.key};o.splice(p.index,0,r);e={groupLevels:o};d.setProperty(n,"groupConditions",e);i(t,n,r,c);s()}).catch(e=>{g(e)})})};const s=function(n,o,a,s){return new Promise((g,c)=>{const d=s===e.REVERT;const p=a.modifier;const l=r(d?n.getRevertData():n.getContent());Promise.resolve().then(p.getProperty.bind(p,o,"groupConditions")).then(e=>{const a=e?e.groupLevels:[];if(!a){c()}const s=a.filter(e=>r(e).key===l.key);const u=a.indexOf(s[0]);if(u>-1){a.splice(u,1)}else{return t.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}e={groupLevels:a};p.setProperty(o,"groupConditions",e);i(n,o,l,d);g()}).catch(e=>{c(e)})})};const g=function(t,n,o,a){return new Promise((s,g)=>{const c=a===e.REVERT;const d=o.modifier;const p=r(c?t.getRevertData():t.getContent());Promise.resolve().then(d.getProperty.bind(d,n,"groupConditions")).then(e=>{const o=e?e.groupLevels:[];const a=o.filter(e=>r(e).key===p.key);const g=o.indexOf(a[0]);o.splice(p.index,0,o.splice(g,1)[0]);e={groupLevels:o};d.setProperty(n,"groupConditions",e);i(t,n,p,c);s()}).catch(e=>{g(e)})})};const c=function(t,n){const i=r(t.getContent());const a=n.byId(t.getSelector().id);let s;const g=[i.key];const c={descriptionPayload:{}};if(t.getChangeType()==="addGroup"){c.descriptionPayload.category=o.ADD;s="table.GROUP_ITEM_ADD_CHANGE";g.push(i.index)}else if(t.getChangeType()==="removeGroup"){c.descriptionPayload.category=o.REMOVE;s="table.GROUP_ITEM_DEL_CHANGE"}else if(t.getChangeType()==="moveGroup"){c.descriptionPayload.category=o.MOVE;s="table.GROUP_ITEM_MOVE_CHANGE";g.push(t.getRevertData().index);g.push(i.index)}if(a){const e=a.getPropertyHelper()?.getProperty(i.key);if(e){g.splice(0,1,e.label)}}return e.getMdcResourceText(s,g).then(e=>{c.descriptionPayload.description=e;c.updateRequired=true;return c})};const d={};d.addGroup=e.createChangeHandler({apply:a,revert:s,getCondenserInfo:function(e,t){const o=r(e.getContent());return{affectedControl:{id:o.key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,classification:n.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}},getChangeVisualizationInfo:c});d.removeGroup=e.createChangeHandler({apply:s,revert:a,getCondenserInfo:function(e,t){const o=r(e.getContent());return{affectedControl:{id:o.key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,classification:n.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}},getChangeVisualizationInfo:c});d.moveGroup=e.createChangeHandler({apply:g,revert:g,getCondenserInfo:function(e,t){const o=r(e.getContent());return{affectedControl:{id:o.key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"groupLevels",classification:n.Move,sourceIndex:e.getRevertData().index,customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getGroupConditions().groupLevels,sourceContainer:e.getSelector(),sourceAggregation:"groupLevels",setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}},getChangeVisualizationInfo:c});return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/ItemBaseFlex", ["sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/common/ChangeCategories"],(e,t,n,i)=>{"use strict";const r={beforeAddItem:function(e,t,n,i){return e.addItem(n,t,i)},afterRemoveItem:function(e,t,n,i){return e.removeItem(n,t,i)},findItem:function(e,t,n){return Promise.resolve()},beforeApply:function(e,t,n){return},afterApply:function(e,t,n){return},determineAggregation:function(e,t){let n;return Promise.resolve().then(e.getControlMetadata.bind(e,t)).then(i=>{n=i.getDefaultAggregation().name;return e.getAggregation(t,n)}).then(e=>({name:n,items:e}))},getChangeVisualizationInfo:function(e,t){return{}},_getExistingAggregationItem:function(e,t,n){const i=t.modifier;return this.determineAggregation(i,n).then(t=>{let n;const r=t.items;if(r){n=this.findItem(i,r,e.name)}return n})},_getOperationText:function(e){return e?"reverted ":"applied "},_getChangeTypeText:function(e){return e?"add":"remove"},_applyAdd:function(n,i,r,a){const o=a===e.REVERT;this.beforeApply(n.getChangeType(),i,o);const g=r.modifier,s=o?n.getRevertData():n.getContent();const d=s.name;let l;let h;let c;let f;const m=this.determineAggregation(g,i).then(e=>{c=e;h=c.items;l=s.index>-1?s.index:h.length;return this._getExistingAggregationItem(s,r,i)}).then(t=>{if(t){return t}else{return g.getProperty(i,"delegate").then(t=>e.getModule(t.name)).then(e=>this.beforeAddItem(e,d,i,r,s)).then(e=>e)}}).then(e=>{if(!e){throw new Error("No item in"+c.name+"  created. Change to "+this._getChangeTypeText(!o)+"cannot be "+this._getOperationText(o)+"at this moment")}if(h.indexOf(e)<0){g.insertAggregation(i,c.name,e,l)}else{return t.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}f=e.getId?e.getId():e.id;return e}).then(()=>{if(o){n.resetRevertData()}else{n.setRevertData({name:s.name,index:l,item:f})}this.afterApply(n.getChangeType(),i,o)});return m},_applyRemove:function(n,i,r,a){const o=a===e.REVERT;this.beforeApply(n.getChangeType(),i,o);const g=r.modifier,s=o?n.getRevertData():n.getContent();let d;let l;let h;let c;const f=this.determineAggregation(g,i).then(e=>{d=e;return this._getExistingAggregationItem(s,r,i)}).then(e=>{h=e;if(!h){return t.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}else{return g.findIndexInParentAggregation(h)}}).then(e=>{l=e;return g.removeAggregation(i,d.name,h)}).then(()=>g.getProperty(i,"delegate").then(t=>e.getModule(t.name)).then(e=>this.afterRemoveItem(e,h,i,r).then(e=>{if(e&&h){c=g.getId(h);g.destroy(h,"KeepDom")}this.afterApply(n.getChangeType(),i,o)}))).then(()=>{if(o){n.resetRevertData()}else{n.setRevertData({name:s.name,index:l,item:c})}});return f},_applyMove:function(n,i,r,a){let o;const g=a===e.REVERT;this.beforeApply(n.getChangeType(),i,g);if(this._bSupressFlickering){this._delayInvalidate(i)}const s=r.modifier;const d=g?n.getRevertData():n.getContent();let l;let h;let c;const f=this.determineAggregation(s,i).then(e=>{h=e;return this._getExistingAggregationItem(d,r,i)}).then(e=>{l=e}).then(()=>{if(!l){return t.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}else{o=l.getId?l.getId():l.id;return s.findIndexInParentAggregation(l)}}).then(e=>{c=e;if(i.moveColumn){return i.moveColumn(l,d.index)}else{return s.removeAggregation(i,h.name,l).then(()=>s.insertAggregation(i,h.name,l,d.index))}}).then(()=>{if(g){n.resetRevertData()}else{n.setRevertData({name:d.name,index:c,item:o})}this.afterApply(n.getChangeType(),i,g)});return f},_removeIndexFromChange:function(e){const t=e.getContent();delete t.index;e.setContent(t)},createAddChangeHandler:function(){return e.createChangeHandler({apply:this._applyAdd.bind(this),revert:this._applyRemove.bind(this),getCondenserInfo:function(e,t){const i=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,i).then(t=>({affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:n.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}))}.bind(this),getChangeVisualizationInfo:this.getChangeVisualizationInfo.bind(this)})},createRemoveChangeHandler:function(t){return e.createChangeHandler({apply:this._applyRemove.bind(this),complete:this._removeIndexFromChange.bind(this),revert:this._applyAdd.bind(this),getCondenserInfo:function(e,t){const i=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,i).then(t=>({affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:n.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}))}.bind(this),getChangeVisualizationInfo:this.getChangeVisualizationInfo.bind(this)})},createMoveChangeHandler:function(t){return e.createChangeHandler({apply:this._applyMove.bind(this),revert:this._applyMove.bind(this),getCondenserInfo:function(e,t){const i=t.modifier.bySelector(e.getSelector(),t.appComponent);return this.determineAggregation(t.modifier,i).then(t=>({affectedControl:{idIsLocal:false,id:e.getRevertData().item},targetContainer:e.getSelector(),targetAggregation:t.name,classification:n.Move,sourceIndex:e.getRevertData().index,sourceContainer:e.getSelector(),sourceAggregation:t.name,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}))}.bind(this),getChangeVisualizationInfo:this.getChangeVisualizationInfo.bind(this)})}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Panel.flexibility", ["sap/ui/core/Element","sap/ui/fl/changeHandler/Base","./Util"],(e,t,n)=>{"use strict";return{createChanges:function(t,n){const r=n.filter(t=>!e.getElementById(t.id));const i={};return r.reduce((e,t)=>{if(!i[t.id]){i[t.id]=true;e.push(t)}return e},[]).map(e=>({selectorElement:t,changeSpecificData:{changeType:"createItem",content:{selector:e.id}}}))},createItem:n.createChangeHandler({apply:(e,t,n)=>{const r=e.getContent().selector;return Promise.resolve().then(()=>{t.getModel();return n.modifier.getProperty(t,"metadataHelperPath")}).then(e=>new Promise((t,n)=>{sap.ui.require(["sap/ui/mdc/link/PanelItem",e],(e,n)=>{t(n)},e=>{n(e)})})).then(e=>{const i=n.modifier;if(i.bySelector(r,n.appComponent,n.view)){return undefined}const o=e.retrieveAllMetadata(t);let a;const c=function(e,t){let n=-1;t.some((t,r)=>{if(t.getId()===e){n=r;return true}});return n};const s=i.getControlIdBySelector(r,n.appComponent);return Promise.resolve().then(i.getAggregation.bind(i,t,"items")).then(e=>{a=-1;let t=null;o.some(n=>{const r=c(n.id,e);if(r>-1){a=r}if(n.id===s){t=n;return true}});if(!t){return undefined}return i.createControl("sap.ui.mdc.link.PanelItem",n.appComponent,n.view,t.id,{text:t.text,description:t.description,href:t.href,internalHref:t.internalHref,target:t.target,icon:t.icon,visible:false})}).then(e=>i.insertAggregation(t,"items",e,a+1))})},revert:(e,n,r)=>{const i=r.modifier;if(e.getContent()&&e.getContent().selector){const o=e.getContent().selector.id;const a=i.bySelector(o,r.appComponent,r.view);if(!a){return t.markAsNotApplicable("revertChange of createItem: the item with id "+o+" is not existing and therefore can not be removed.",true)}return Promise.resolve().then(i.removeAggregation.bind(i,n,"items",a))}return undefined},complete:(e,t,n)=>{if(t.content){const r=n.modifier.getSelector(t.content.selector,n.appComponent);e.setContent({selector:r})}}})}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/PanelItem.flexibility", ["sap/ui/core/Element","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl"],(e,n,r)=>{"use strict";return{createChanges:function(n){return n.map(n=>{const r=e.getElementById(n.id);if(!r){throw new Error("Invalid 'id'. For the id "+n.id+" no existing control could be found")}return{selectorElement:r,changeSpecificData:{changeType:n.visible?"revealItem":"hideItem"}}})},revealItem:{layers:{USER:true},changeHandler:r},hideItem:{layers:{USER:true},changeHandler:n}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/PropertyInfoFlex", [],()=>{"use strict";const e={};e.addPropertyInfo={changeHandler:{applyChange:function(e,n,t){},completeChangeContent:function(e,n,t){},revertChange:function(e,n,t){}},layers:{USER:true}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/SortFlex", ["sap/base/util/merge","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/changeHandler/common/ChangeCategories","./helpers/addKeyOrName"],(e,t,n,o,r,i)=>{"use strict";const s=function(e,t,n,o){if(o){e.resetRevertData()}else{e.setRevertData(n)}};const a=function(e,n,o,r){return new Promise((a,c)=>{const g=r===t.REVERT;const d=o.modifier;const l=i(g?e.getRevertData():e.getContent());Promise.resolve().then(d.getProperty.bind(d,n,"sortConditions")).then(t=>{const o=t?t.sorters:[];const r={key:l.key,name:l.key,descending:l.descending};o.splice(l.index,0,r);t={sorters:o};d.setProperty(n,"sortConditions",t);s(e,n,r,g);a()}).catch(e=>{c(e)})})};const c=function(e,o,r,a){return new Promise((c,g)=>{const d=r.modifier;const l=a===t.REVERT;const f=i(l?e.getRevertData():e.getContent());Promise.resolve().then(d.getProperty.bind(d,o,"sortConditions")).then(t=>{const r=t?t.sorters:[];if(!r){g()}const a=r.filter(e=>i(e).key===f.key);const p=r.indexOf(a[0]);if(p>-1){r.splice(p,1)}else{return n.markAsNotApplicable("The specified change is already existing - change appliance ignored",true)}t={sorters:r};d.setProperty(o,"sortConditions",t);s(e,o,f,l);c()}).catch(e=>{g(e)})})};const g=function(n,o,r,a){return new Promise((c,g)=>{const d=a===t.REVERT;const l=r.modifier;const f=i(d?n.getRevertData():n.getContent());Promise.resolve().then(l.getProperty.bind(l,o,"sortConditions")).then(t=>{const r=t?t.sorters:[];const a=r.filter(e=>i(e).key===f.key);const g=r.indexOf(a[0]);r.splice(f.index,0,r.splice(g,1)[0]);t={sorters:r};l.setProperty(o,"sortConditions",t);const p=e({},f);p.index=g;s(n,o,p,d);c()}).catch(e=>{g(e)})})};const d=function(e,n){const o=i(e.getContent());const s=n.byId(e.getSelector().id);const a={descriptionPayload:{}};let c;const g=[o.key];if(e.getChangeType()==="addSort"){a.descriptionPayload.category=r.ADD;if(o.descending){c="chart.SORT_ADD_CHANGE_DESC"}else{c="chart.SORT_ADD_CHANGE_ASC"}g.push(o.index)}else if(e.getChangeType()==="removeSort"){a.descriptionPayload.category=r.REMOVE;c="chart.SORT_DEL_CHANGE"}else{a.descriptionPayload.category=r.MOVE;c="chart.SORT_MOVE_CHANGE";g.push(e.getRevertData().index);g.push(o.index)}const d=s?.getPropertyHelper()?.getProperty(o.key);if(d){g.splice(0,1,d.label)}return t.getMdcResourceText(c,g).then(e=>{a.descriptionPayload.description=e;a.updateRequired=true;return a})};const l={};l.addSort=t.createChangeHandler({apply:a,revert:c,getCondenserInfo:function(e,t){return{affectedControl:{id:i(e.getContent()).key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,classification:o.Create,setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index}}},getChangeVisualizationInfo:d});l.removeSort=t.createChangeHandler({apply:c,revert:a,getCondenserInfo:function(e,t){return{affectedControl:{id:i(e.getContent()).key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,classification:o.Destroy,sourceIndex:e.getRevertData().index,setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}},getChangeVisualizationInfo:d});l.moveSort=t.createChangeHandler({apply:g,revert:g,getCondenserInfo:function(e,t){return{affectedControl:{id:i(e.getContent()).key},affectedControlIdProperty:"name",targetContainer:e.getSelector(),targetAggregation:"sorters",classification:o.Move,sourceIndex:e.getRevertData().index,customAggregation:t.modifier.bySelector(e.getSelector(),t.appComponent).getSortConditions().sorters,sourceContainer:e.getSelector(),sourceAggregation:"sorters",setTargetIndex:function(e,t){e.getContent().index=t},getTargetIndex:function(e){return e.getContent().index},setIndexInRevertData:function(e,t){const n=e.getRevertData();n.index=t;e.setRevertData(n)}}},getChangeVisualizationInfo:d});return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Table.flexibility", ["./SortFlex","./ColumnFlex","./ConditionFlex","./GroupFlex","./AggregateFlex","./xConfigFlex","sap/ui/fl/changeHandler/condenser/Classification"],(e,o,r,t,a,n,d)=>{"use strict";return{hideControl:"default",unhideControl:"default",addColumn:o.createAddChangeHandler(),removeColumn:o.createRemoveChangeHandler(),moveColumn:o.createMoveChangeHandler(),removeSort:e.removeSort,addSort:e.addSort,moveSort:e.moveSort,addCondition:r.addCondition,removeCondition:r.removeCondition,removeGroup:t.removeGroup,addGroup:t.addGroup,moveGroup:t.moveGroup,removeAggregate:a.removeAggregate,addAggregate:a.addAggregate,setColumnWidth:n.createSetChangeHandler({aggregation:"columns",property:"width"}),setShowDetails:n.createSetChangeHandler({aggregation:"type",property:"showDetails"}),setFixedColumnCount:n.createSetChangeHandler({aggregation:"type",property:"fixedColumnCount"})}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/Util", ["sap/ui/mdc/util/loadModules","sap/m/p13n/Engine","sap/base/Log"],(e,n,t)=>{"use strict";const i={};i.APPLY="apply";i.REVERT="revert";function a(e){const n=e&&e.getUIArea&&e.getUIArea();if(n&&!e._bInvalidationSuppressed){e._bInvalidationSuppressed=n.suppressInvalidationFor(e)}}function o(e){const n=e&&e.getUIArea&&e.getUIArea();if(n&&e._bInvalidationSuppressed){n.resumeInvalidationFor(e);delete e._bInvalidationSuppressed}}function r(e,i){if(e.isA){n.getInstance().trace(e,{selectorElement:e,changeSpecificData:{changeType:i.getChangeType(),content:i.getContent()}});if(!e._pPendingModification&&e._onModifications instanceof Function){e._pPendingModification=n.getInstance().waitForChanges(e).then(async()=>{const t=n.getInstance().getTrace(e);n.getInstance().clearTrace(e);delete e._pPendingModification;n.getInstance().fireStateChange(e);await e._onModifications(t);o(e)}).catch(n=>{t.error(`Error during mdc flex handling: ${n}`);o(e)})}}}i.getModule=function(e){return new Promise((n,t)=>{sap.ui.require([e],n,t)}).then(e=>e)};i.getMdcResourceText=function(e,n){return i.getModule("sap/ui/core/Lib").then(t=>t.getResourceBundleFor("sap.ui.mdc").getText(e,n))};i.createChangeHandler=function(n){const t=n.apply instanceof Function&&n.apply;const o=n.revert instanceof Function&&n.revert;const c=n.complete instanceof Function&&n.complete;if(!t||!o){throw new Error("Please provide atleast an apply and revert function!")}return{changeHandler:{applyChange:function(e,n,o){a(n);return t(e,n,o,i.APPLY).then(()=>{r(n,e)})},completeChangeContent:function(e,n,t){if(c){c(e,n,t)}},revertChange:function(e,n,t){a(n);return o(e,n,t,i.REVERT).then(()=>{r(n,e)})},onAfterXMLChangeProcessing:function(n,t){return t.modifier.getProperty(n,"delegate").then(i=>{if(i){return e(i.name).then(e=>{const i=e[0];if(i.onAfterXMLChangeProcessing instanceof Function){i.onAfterXMLChangeProcessing(n,t)}})}})},getCondenserInfo:n.getCondenserInfo,getChangeVisualizationInfo:n.getChangeVisualizationInfo},layers:{USER:true}}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/actiontoolbar/CombineAction", ["sap/base/i18n/Localization","sap/m/changeHandler/CombineButtons"],(t,e)=>{"use strict";const n={...e};const a="$sap.m.flexibility.CombineButtonsModel";function o(e){const{buttons:n,modifier:o,appComponent:r,menu:i,actionToolbar:s,actionToolbarAggregation:c,view:g,changeContent:l,revertData:u}=e;let d="";let m="";let p="";const b=[];const w=t.getRTL();const y=[];return n.reduce(async(t,e,n)=>{const v=n;const P=l.buttonsIdForSave[v];const C="$sap.m.flexibility.MenuButtonModel"+v;const A=o.getParent(e);await t;const f=await o.getProperty(e,"text");const B=await o.createControl("sap.m.MenuItem",r,g,P);const I=await o.findIndexInParentAggregation(A);u.insertIndexes[v]=I;const M=await o.createControl("sap.ui.fl.util.ManagedObjectModel",r,g,Object.assign({},P,{id:P.id+"-managedObjectModel"}),{object:e,name:a});await o.insertAggregation(B,"dependents",M,0,g);const h=await o.createControl("sap.ui.core.CustomData",r,g,Object.assign({},P,{id:P.id+"-customData"}),{key:"{ path: '"+a+">key' }",value:"{ path: '"+a+">value' }"});o.bindProperty(B,"text",a+">/text");o.bindProperty(B,"icon",a+">/icon");o.bindProperty(B,"enabled",a+">/enabled");o.bindProperty(B,"visible",a+">/visible");await o.bindAggregation(B,"customData",{path:a+">/customData",template:h,templateShareable:false},g);if(f){if(w){y.unshift(f)}else{y.push(f)}}const S=Object.assign({},P,{id:P.id+"-originalButtonId"});const j=await o.createControl("sap.ui.core.CustomData",r,g,S);o.setProperty(j,"key","originalButtonId");o.setProperty(j,"value",o.getId(e));await o.removeAggregation(s,c,A);await o.insertAggregation(s,"dependents",A,0,g);await o.insertAggregation(e,"customData",j,0,g);await o.insertAggregation(i,"items",B,v,g);b[v]=await o.createControl("sap.ui.fl.util.ManagedObjectModel",r,g,Object.assign({},P,{id:P.id+"-managedObjectModelMenuItem"}),{object:B,name:C});d=d+p+"${"+C+">/enabled}";m=m+p+"${"+C+">/visible}";p=" || ";return{menuButtonModels:b,menuButtonName:y,propertyEnabled:d,propertyVisible:m}},Promise.resolve())}n.applyChange=async function(t,n,a){if(a.modifier.targets!=="jsControlTree"){return Promise.reject(new Error("Combine buttons change can't be applied on XML tree"))}const r=t.getContent();const i=a.modifier;const s=a.view;const c=a.appComponent;const g={parentAggregation:"",insertIndexes:[]};const l=await Promise.all(r.combineButtonSelectors.map(t=>i.bySelector(t,c,s)));const u=await i.getParentAggregationName(l[0],i.getParent(l[0]));const d=await i.bySelector(r.combineButtonSelectors[0],c,s);const m=i.getParent(d);const p=i.getParent(m);const b=await i.getParentAggregationName(m,p);g.parentAggregation=b;const w=await i.findIndexInParentAggregation(m);const y=await i.createControl("sap.m.Menu",c,s,r.menuIdSelector);y.attachEvent("itemSelected","sap.m.changeHandler.CombineButtons.pressHandler",e.pressHandler);const v=await o({buttons:l,modifier:i,appComponent:c,menu:y,actionToolbar:p,actionToolbarAggregation:b,view:s,changeContent:r,revertData:g});const P=v.menuButtonModels;const C=v.menuButtonName;const A=v.propertyVisible;const f=v.propertyEnabled;const B=await i.createControl("sap.m.MenuButton",c,s,r.menuButtonIdSelector,{visible:"{= "+A+"}",enabled:"{= "+f+"}"});await P.reduce(async(t,e)=>{await t;return i.insertAggregation(B,"dependents",e,0,s)},Promise.resolve());i.setProperty(B,"text",C.join("/"));await i.insertAggregation(B,"menu",y,0,s);const I=await i.createControl("sap.ui.mdc.actiontoolbar.ActionToolbarAction",c,s,{...r.menuButtonIdSelector,id:r.menuButtonIdSelector.id+"--action"});await i.insertAggregation(I,u,B,0,s);await i.insertAggregation(p,b,I,w,s);t.setRevertData(g);return Promise.resolve()};function r(t,e){return t.reduce(async(t,n)=>{await t;const a=await e.getProperty(n,"key");if(a==="originalButtonId"){return e.destroy(n)}return undefined},Promise.resolve())}n.revertChange=async function(t,e,n){const a=n.modifier;const o=n.view;const i=t.getRevertData();const s=t.getContent();const c=i.parentAggregation;const g=await a.bySelector(s.menuButtonIdSelector,n.appComponent,o);const l=a.getParent(g);const u=a.getParent(l);const d=s.combineButtonSelectors.slice().reverse();await a.removeAggregation(u,c,l);await a.destroy(l);const m=d.length;await d.reduce(async(t,e,s)=>{const g=s;await t;const l=a.bySelector(e,n.appComponent,o);const d=await a.getAggregation(l,"customData");await r(d,a);const p=a.getParent(l);return a.insertAggregation(u,c,p,i.insertIndexes[m-g-1],o)},Promise.resolve());t.resetRevertData()};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/actiontoolbar/SplitAction", ["sap/m/changeHandler/SplitMenuButton"],t=>{"use strict";const e="sourceControl";const n={...t,applyChange:async function(n,a,o){if(o.modifier.targets!=="jsControlTree"){return Promise.reject(new Error("Split change can't be applied on XML tree"))}const r=n.getContent();const i=o.modifier;const s=o.view;const c=o.appComponent;const g=n.getDependentControl(e,o);const d=await i.getAggregation(g,"menu");const p=await i.getAggregation(d,"items");const l=i.getParent(g);const u=i.getParent(l);const m=await i.getParentAggregationName(l,u);const w=await i.findIndexInParentAggregation(l);const b={parentAggregation:m,insertIndex:w,insertedActions:[]};const A=r.newElementIds;await p.reduce(async(e,n,a)=>{await e;const o=a;const r=A[o];const g=await i.createControl("sap.ui.mdc.actiontoolbar.ActionToolbarAction",c,s,r);const p=await i.createControl("sap.m.Button",c,s,{...r,id:r.id+"--button"});await i.insertAggregation(g,"action",p,0);b.insertedActions.push(r);const l="$sap.m.flexibility.SplitButtonsModel";const v=await i.createControl("sap.ui.fl.util.ManagedObjectModel",c,s,Object.assign({},r,{id:r.id+"-managedObjectModel"}),{object:n,name:l});await i.insertAggregation(p,"dependents",v,0,s);i.bindProperty(p,"text",l+">/text");i.bindProperty(p,"icon",l+">/icon");i.bindProperty(p,"enabled",l+">/enabled");i.bindProperty(p,"visible",l+">/visible");const C=await i.createControl("sap.ui.core.CustomData",c,s,Object.assign({},r,{id:r.id+"-customData"}),{key:{path:l+">key"},value:{path:l+">value"}});await i.bindAggregation(p,"customData",{path:l+">/customData",template:C,templateShareable:false});p.attachEvent("press",{selector:i.getSelector(n,c),appComponentId:c.getId(),menu:d},t.pressHandler);return i.insertAggregation(u,m,g,w+o,s)},Promise.resolve());await i.removeAggregation(u,m,l);await i.insertAggregation(u,"dependents",l,0,s);n.setRevertData(b);return Promise.resolve()},revertChange:async function(t,n,a){const o=a.modifier;const r=t.getRevertData();const i=t.getDependentControl(e,a);const s=a.appComponent;const c=a.view;const g=o.getParent(i);const d=o.getParent(g);const p=r.parentAggregation;const l=r.insertIndex;const u=[];r.insertedActions.forEach(t=>{u.push(o.bySelector(t,s,c))});await u.reduce(async(t,e)=>{await t;await o.removeAggregation(d,p,e);return o.destroy(e)},Promise.resolve());await o.insertAggregation(d,p,g,l,c);t.resetRevertData()}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/helpers/addKeyOrName", [],()=>{"use strict";const e=e=>{if("key"in e&&"name"in e&&e.key!==e.name){throw new Error(`The values of legacy-attribute 'name' and it's replacement 'key' must be identical.`,e)}const n=e.key||e.name;e.key=n;e.name=n;return e};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flexibility/xConfigFlex", ["sap/m/p13n/Engine","sap/ui/mdc/flexibility/Util","sap/ui/fl/changeHandler/condenser/Classification"],(e,n,t)=>{"use strict";const a={};const r=function(e,n){const t=function(n){if(e._pQueue===n){delete e._pQueue}};e._pQueue=e._pQueue instanceof Promise?e._pQueue.then(n):n();e._pQueue.then(t.bind(null,e._pQueue));return e._pQueue};a.createSetChangeHandler=function(a){if(!a||!a.hasOwnProperty("aggregation")||!a.hasOwnProperty("property")){throw new Error("Please provide a map containing the affected aggregation and property name!")}const o=a.aggregation;const g=a.property;const i=function(n,t,a){return r(t,()=>e.getInstance().readXConfig(t,{propertyBag:a}).then(r=>{let i=null;if(r&&r.aggregations&&r.aggregations[o]&&r.aggregations[o][n.getContent().name]&&r.aggregations[o][n.getContent().name][g]){i=r.aggregations[o][n.getContent().name][g]}n.setRevertData({name:n.getContent().name,value:i});return e.getInstance().enhanceXConfig(t,{controlMeta:{aggregation:o},property:g,name:n.getContent().name,value:n.getContent().value,propertyBag:a})}))};const u=function(n,t,a){return e.getInstance().enhanceXConfig(t,{controlMeta:{aggregation:o},property:g,name:n.getRevertData().name,value:n.getRevertData().value,propertyBag:a}).then(()=>{n.resetRevertData()})};return n.createChangeHandler({apply:i,revert:u,getCondenserInfo:function(e,n){return{classification:a.classification??t.LastOneWins,affectedControl:e.getSelector(),uniqueKey:e.getContent().name+"_"+a.aggregation+"_"+a.property}}})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/flp/FlpLinkDelegate", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/link/SemanticObjectMapping","sap/ui/mdc/link/SemanticObjectMappingItem","sap/ui/mdc/link/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],(e,t,n,i,a,c,o,r,s,l,u,f)=>{"use strict";const m=Object.assign({},n);m.fetchLinkItems=function(e,t,n){const i=e.getPayload();const a=t?t.getObject(t.getPath()):undefined;const o=[];if(n){n.initialize(m._getSemanticObjects(i));o.forEach(e=>{n.addIntent(c.IntentType.API,{text:e.getText(),intent:e.getHref()})})}const r=m._calculateSemanticAttributes(a,i,n);return m._retrieveNavigationTargets("",r,i,n).then((e,t)=>Promise.resolve(e))};m.fetchLinkType=function(e){const t={};let n=null;const i=e.getPayload();const c=function(e){return e.filter(e=>!t[e]).length===0};const r=function(e){return e.some(e=>t[e]&&t[e].exists===true)};const s=async function(){if(!n){const{promise:e,resolve:i}=Promise.withResolvers();n=e;const c=await a.getServiceAsync("CrossApplicationNavigation");if(!c){o.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");i({});return}c.getDistinctSemanticObjects().then(e=>{e.forEach(e=>{t[e]={exists:true}});n=null;return i(t)},()=>{o.error("FlpLinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return i({})})}return n};const l=function(e){if(c(e)){return Promise.resolve(r(e))}return s().then(()=>r(e))};if(i&&i.semanticObjects){return l(i.semanticObjects).then(e=>Promise.resolve({type:e?f.Popover:f.Text,directLink:undefined}))}else{throw new Error("no payload or semanticObjects found")}};m._calculateSemanticAttributes=function(e,t,n){const i=m._getSemanticObjects(t);const a=m._convertSemanticObjectMapping(m._getSemanticObjectMappings(t));if(!i.length){i.push("")}const c={};i.forEach(t=>{if(n){n.addContextObject(t,e)}c[t]={};for(const i in e){let s=null,l=null;if(n){s=n.getSemanticObjectAttribute(t,i);if(!s){s=n.createAttributeStructure();n.addSemanticObjectAttribute(t,i,s)}}if(e[i]===undefined||e[i]===null){if(s){s.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in FlpLinkDelegate."})}continue}if(r(e[i])){if(s){s.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in FlpLinkDelegate."})}continue}const u=a&&a[t]&&a[t][i]?a[t][i]:i;if(s&&i!==u){l={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+u+" in FlpLinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+t+" with source attribute "+i+" and target attribute "+u+". You can modify the annotation if the mapping result is not what you expected."}}if(c[t][u]){o.error("FlpLinkDelegate: The attribute "+i+" can not be renamed to the attribute "+u+" due to a clash situation. This can lead to wrong navigation later on.")}c[t][u]=e[i];if(s){if(l){s.transformations.push(l);const a=n.createAttributeStructure();a.transformations.push({value:e[i],description:"ℹ The attribute "+u+" with the value "+e[i]+" has been added due to a mapping rule regarding the attribute "+i+" in FlpLinkDelegate."});n.addSemanticObjectAttribute(t,u,a)}}}});return c};m._retrieveNavigationTargets=function(n,c,r,s){if(!r.semanticObjects){return new Promise(e=>{e([])})}const l=r.semanticObjects;const u=r.sourceControl;const f={ownNavigation:undefined,availableActions:[]};return t.load({name:"sap.ui.fl"}).then(()=>new Promise(t=>{sap.ui.require(["sap/ui/fl/Utils"],p=>{const b=a.getService("CrossApplicationNavigation");const g=a.getService("URLParsing");if(!b||!g){o.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return t(f.availableActions,f.ownNavigation)}const d=e.getElementById(u);const h=p.getAppComponentForControl(d);const v=l.map(e=>[{semanticObject:e,params:c?c[e]:undefined,appStateKey:n,ui5Component:h,sortResultsBy:"text"}]);return new Promise(()=>{b.getLinks(v).then(e=>{if(!e||!e.length){return t(f.availableActions,f.ownNavigation)}const n=m._getSemanticObjectUnavailableActions(r);const a=m._convertSemanticObjectUnavailableAction(n);let c=b.hrefForExternal();if(c&&c.indexOf("?")!==-1){c=c.split("?")[0]}if(c){c+="?"}const o=function(e,t){return!!a&&!!a[e]&&a[e].indexOf(t)>-1};const u=function(e){const t=g.parseShellHash(e.intent);if(o(t.semanticObject,t.action)){return}const n=b.hrefForExternal({target:{shellHash:e.intent}},h);if(e.intent&&e.intent.indexOf(c)===0){f.ownNavigation=new i({href:n,text:e.text,internalHref:e.intent});return}const a=new i({key:t.semanticObject&&t.action?t.semanticObject+"-"+t.action:undefined,text:e.text,description:undefined,href:n,internalHref:e.intent,icon:undefined,initiallyVisible:e.tags&&e.tags.indexOf("superiorAction")>-1});f.availableActions.push(a);if(s){s.addSemanticObjectIntent(t.semanticObject,{intent:a.getHref(),text:a.getText()})}};for(let t=0;t<l.length;t++){e[t][0].forEach(u)}return t(f.availableActions,f.ownNavigation)},()=>{o.error("FlpLinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return t(f.availableActions,f.ownNavigation)})})})}))};m._getSemanticObjects=function(e){return e.semanticObjects?e.semanticObjects:[]};m._getSemanticObjectUnavailableActions=function(e){const t=[];if(e.semanticObjectUnavailableActions){e.semanticObjectUnavailableActions.forEach(e=>{t.push(new u({semanticObject:e.semanticObject,actions:e.actions}))})}return t};m._getSemanticObjectMappings=function(e){const t=[];let n=[];if(e.semanticObjectMappings){e.semanticObjectMappings.forEach(e=>{n=[];if(e.items){e.items.forEach(e=>{n.push(new l({key:e.key,value:e.value}))})}t.push(new s({semanticObject:e.semanticObject,items:n}))})}return t};m._convertSemanticObjectMapping=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getItems().reduce((e,t)=>{e[t.getKey()]=t.getValue();return e},{})});return t};m._convertSemanticObjectUnavailableAction=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getActions()});return t};return m});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/library", ["sap/ui/base/DataType","sap/ui/core/Lib","sap/ui/core/library","sap/m/library"],(e,i)=>{"use strict";const a=i.init({apiVersion:2,version:"1.136.0",name:"sap.ui.mdc",dependencies:["sap.ui.core","sap.m"],...{interactionDocumentation:true},designtime:"sap/ui/mdc/designtime/library.designtime",types:["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowAction","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent","sap.ui.mdc.valuehelp.base.ITypeaheadContainer","sap.ui.mdc.valuehelp.base.IDialogContainer"],controls:["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.valuehelp.base.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],elements:["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.DragDropConfig","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.SelectionButton","sap.ui.mdc.chart.SelectionButtonItem","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.Link","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.ushell.SemanticObjectUnavailableAction","sap.ui.mdc.ushell.SemanticObjectMapping","sap.ui.mdc.ushell.SemanticObjectMappingItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.FixedListItem","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],extensions:{flChangeHandlers:{"sap.ui.mdc.Table":"sap/ui/mdc/flexibility/Table","sap.ui.mdc.Chart":"sap/ui/mdc/flexibility/Chart","sap.ui.mdc.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.p13n.AdaptationFilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.vh.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.valuehelp.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.link.PanelItem":"sap/ui/mdc/flexibility/PanelItem","sap.ui.mdc.link.Panel":"sap/ui/mdc/flexibility/Panel","sap.ui.mdc.ActionToolbar":"sap/ui/mdc/flexibility/ActionToolbar","sap.ui.mdc.actiontoolbar.ActionToolbarAction":"sap/ui/mdc/flexibility/ActionToolbarAction"},"sap.ui.support":{publicRules:true}},noLibraryCSS:false});a.FilterBarP13nMode={Item:"Item",Value:"Value"};e.registerEnum("sap.ui.mdc.FilterBarP13nMode",a.FilterBarP13nMode);a.TableType={Table:"Table",TreeTable:"TreeTable",ResponsiveTable:"ResponsiveTable"};e.registerEnum("sap.ui.mdc.TableType",a.TableType);a.TableP13nMode={Column:"Column",Sort:"Sort",Filter:"Filter",Group:"Group",Aggregate:"Aggregate"};e.registerEnum("sap.ui.mdc.TableP13nMode",a.TableP13nMode);a.GrowingMode={None:"None",Basic:"Basic",Scroll:"Scroll"};e.registerEnum("sap.ui.mdc.GrowingMode",a.GrowingMode);a.RowCountMode={Auto:"Auto",Fixed:"Fixed"};e.registerEnum("sap.ui.mdc.RowCountMode",a.RowCountMode);a.ChartToolbarActionType={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend"};e.registerEnum("sap.ui.mdc.ChartToolbarActionType",a.ChartToolbarActionType);a.ChartP13nMode={Item:"Item",Sort:"Sort",Type:"Type",Filter:"Filter"};e.registerEnum("sap.ui.mdc.ChartP13nMode",a.ChartP13nMode);a.SelectionMode={None:"None",Single:"Single",SingleMaster:"SingleMaster",Multi:"Multi"};e.registerEnum("sap.ui.mdc.SelectionMode",a.SelectionMode);a.RowAction={Navigation:"Navigation"};e.registerEnum("sap.ui.mdc.RowAction",a.RowAction);a.FilterExpression={Interval:"Interval",Single:"Single",Multi:"Multi"};e.registerEnum("sap.ui.mdc.FilterExpression",a.FilterExpression);a.ChartItemType={Dimension:"Dimension",Measure:"Measure"};e.registerEnum("sap.ui.mdc.ChartItemType",a.ChartItemType);a.ChartItemRoleType={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};e.registerEnum("sap.ui.mdc.ChartItemRoleType",a.ChartItemRoleType);a.MultiSelectMode={Default:"Default",ClearAll:"ClearAll"};e.registerEnum("sap.ui.mdc.MultiSelectMode",a.MultiSelectMode);return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Factory", ["sap/base/Log"],e=>{"use strict";return{getUShellContainer:function(){return sap.ui.require("sap/ushell/Container")},getServiceAsync:function(i){const r=this.getUShellContainer();if(!r){return Promise.resolve(null)}switch(i){case"CrossApplicationNavigation":e.error("sap.ui.mdc.link.Factory: tried to retrieve deprecated service 'CrossApplicationNavigation', please use 'Navigation' instead!");return r.getServiceAsync("CrossApplicationNavigation");case"Navigation":return r.getServiceAsync("Navigation");case"URLParsing":return r.getServiceAsync("URLParsing");default:return Promise.resolve(null)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/LinkItem", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.link.LinkItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string",defaultValue:undefined},text:{type:"string",defaultValue:null},description:{type:"string",defaultValue:undefined},href:{type:"string",defaultValue:null},internalHref:{type:"string",defaultValue:null},target:{type:"string",defaultValue:"_self"},icon:{type:"sap.ui.core.URI"},initiallyVisible:{type:"boolean",defaultValue:false},press:{type:"object",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Log", ["sap/base/i18n/Localization","sap/ui/base/Object","sap/base/util/isEmptyObject","sap/ui/core/Locale"],(t,e,n,i)=>{"use strict";const o=e.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset()}});o.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this};o.prototype.isEmpty=function(){return!(!n(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length)};o.prototype.initialize=function(t){this.reset();t.forEach(t=>{this.createSemanticObjectStructure(t)})};o.prototype.addContextObject=function(t,e){for(const n in e){const i=this.createAttributeStructure();this.addSemanticObjectAttribute(t,n,i);i.transformations.push({value:e[n],description:"ℹ The attribute "+n+" with the value "+e[n]+" is initially taken from the binding context."})}};o.prototype.createSemanticObjectStructure=function(t){this._oLog.semanticObjects[t]={attributes:{},intents:[]}};o.prototype.createAttributeStructure=function(){return{transformations:[]}};o.prototype.addSemanticObjectIntent=function(t,e){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].intents.push(e);return this};o.prototype.addSemanticObjectAttribute=function(t,e,n){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].attributes[e]=n;return this};o.prototype.getSemanticObjectAttribute=function(t,e){return this._oLog.semanticObjects[t]&&this._oLog.semanticObjects[t].attributes[e]?this._oLog.semanticObjects[t].attributes[e]:undefined};o.prototype.addIntent=function(t,e){switch(t){case o.IntentType.API:this._oLog.intents.api.push(e);break;case o.IntentType.BREAKOUT:this._oLog.intents.breakout.push(e);break;default:throw"Intent type "+t+" is not supported yet."}return this};o.prototype.getFormattedText=function(){const e=function(t){return typeof t==="string"?"'"+t+"'":t};const o=function(t,n){const i={value:"• "+n+" : ",description:""};t.forEach((t,n)=>{i.value=i.value+(n>0?"  ➜  ":"")+e(t["value"]);i.description=i.description+"…   "+t["description"]+"\n";if(t["reason"]){i.description=i.description+"…   "+t["reason"]+"\n"}});return i};const s=function(t){let e="";t.forEach(t=>{e+="• '"+t.text+"' : "+t.intent+"\n"});return e};const a=function(e){try{const n=new i(t.getLanguageTag()).toString();if(typeof window.Intl!=="undefined"){const t=window.Intl.Collator(n,{numeric:true});e.sort((e,n)=>t.compare(e,n))}else{e.sort((t,e)=>t.localeCompare(e,n,{numeric:true}))}}catch(t){}};let r="";for(const t in this._oLog.semanticObjects){r=r+"\n⬤"+" "+t+"\n";if(n(this._oLog.semanticObjects[t].attributes)){r+="……  🔴 No semantic attributes available for semantic object "+t+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n"}else{const e=Object.keys(this._oLog.semanticObjects[t].attributes);a(e);for(const n of e){const e=o(this._oLog.semanticObjects[t].attributes[n].transformations,n);r+=e.value+"\n";r+=e.description}}if(this._oLog.semanticObjects[t].intents.length){r+="\nIntents returned by FLP for semantic object "+t+":\n";r+=s(this._oLog.semanticObjects[t].intents)}}if(this._oLog.intents.api.length){r+="\nIntents defined in items aggregation:\n";r+=s(this._oLog.intents.api)}if(this._oLog.intents.breakout.length){r+="\nIntents returned by modifyItemsCallback callback:\n";r+=s(this._oLog.intents.breakout)}return r};o.prototype._getLogFormattedText=function(){return!this.isEmpty()?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available"};o.IntentType={BREAKOUT:"Breakout",API:"Api"};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/Panel", ["sap/ui/core/Control","./PanelRenderer","sap/ui/core/Lib","sap/ui/layout/VerticalLayout","sap/base/Log","sap/ui/layout/HorizontalLayout","sap/m/HBox","sap/m/VBox","sap/m/ImageContent","sap/m/Link","sap/m/Label","sap/m/Text","sap/m/Button","sap/m/FlexItemData","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem","sap/ui/core/CustomData","./Factory","sap/ui/core/library"],(t,e,n,i,o,r,a,s,l,c,p,u,g,m,d,h,f,y,P,I,b,k,_,v)=>{"use strict";const{HasPopup:C}=v.aria;const A=t.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true},_content:{type:"sap.ui.layout.VerticalLayout",visibility:"hidden",multiple:false}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}},renderer:e});A.prototype.init=function(){t.prototype.init.call(this);this._registerP13n();const e=new d({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,runtimeItems:[]});e.setDefaultBindingMode(h.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdclinkPanel");this._oObserver=new f(z.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]})};const L=n.getResourceBundleFor("sap.ui.mdc");A.prototype.applySettings=function(){this._createContent();t.prototype.applySettings.apply(this,arguments)};A.prototype.exit=function(t){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}if(this._oMetadataHelper){this._oMetadataHelper=null}};const w=0,M=1,S=2,x=3;A.prototype._registerP13n=function(){P.getInstance().register(this,{controller:{LinkItems:new y({control:this})}});I.call(A.prototype);P.getInstance().defaultProviderRegistry.attach(this,"Global")};A.prototype._createContent=function(){const t=[];t[w]=this._createAdditionalContentArea();t[M]=this._createSeparator();t[S]=this._createLinkArea();t[x]=this._createFooterArea();const e=new i({width:"100%",content:t});this.setAggregation("_content",e)};A.prototype._createAdditionalContentArea=function(){const t=new s({fitContainer:false,items:this.getAdditionalContent()});return t};A.prototype._createSeparator=function(){const t=new s({fitContainer:false,visible:{parts:[{path:"$sapuimdclinkPanel>/countAdditionalContent"},{path:"$sapuimdcLink>/metadata"}],formatter:function(t,e){return t>0&&e.length>0}}});t.addStyleClass("mdcbaseinfoPanelSeparator");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");t.setModel(this.getModel("$sapuimdcLink"),"$sapuimdcLink");return t};A.prototype._createLinkArea=function(){const t=new s({fitContainer:false,items:{path:"$sapuimdclinkPanel>/runtimeItems",templateShareable:false,factory:this._fnLinkItemFactory.bind(this)}});t.addStyleClass("mdcbaseinfoPanelSectionLinks");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");return t};A.prototype._fnLinkItemFactory=function(t,e){const n=new l({src:"{$sapuimdclinkPanel>icon}",visible:{path:"$sapuimdclinkPanel>icon",formatter:function(t){return!!t}}});const i=new c({text:"{$sapuimdclinkPanel>text}",href:"{$sapuimdclinkPanel>href}",target:"{$sapuimdclinkPanel>target}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!!t}},press:this.onPressLink.bind(this),wrapping:true,customData:new k({key:"internalHref",value:"{$sapuimdclinkPanel>internalHref}"})});const o=new p({text:"{$sapuimdclinkPanel>text}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!t}},wrapping:true});const g=new u({text:"{$sapuimdclinkPanel>description}",visible:{path:"$sapuimdclinkPanel>description",formatter:function(t){return!!t}},wrapping:true});const d=new s({items:[i,o,g]});const h=new a({layoutData:new m({styleClass:e.getProperty("description")?"mdcbaseinfoPanelItemsGroup":"mdcbaseinfoPanelItemsWithoutGroup"}),items:[n,d]});const f=new r({visible:"{$sapuimdclinkPanel>visible}",content:[h]});f.addStyleClass("mdcbaseinfoPanelListItem");return f};A.prototype._createFooterArea=function(){const t=new g(this.getId()+"--idSectionPersonalizationButton",{type:"Transparent",text:L.getText("info.POPOVER_DEFINE_LINKS"),press:this.onPressLinkPersonalization.bind(this)});t.setAriaHasPopup(C.Dialog);const e=new a({visible:{path:"$sapuimdcLink>/metadata",formatter:function(t){return t.length>0}},justifyContent:"End",items:[t]});e.addStyleClass("mdcbaseinfoPanelPersonalizationButton");return e};A.prototype.onPressLink=function(t){const e=t.getSource();const n=t.getParameters().ctrlKey||t.getParameters().metaKey;const i=e?.getTarget()==="_blank"||n;if(i){return}t.preventDefault();const r=this.getBeforeNavigationCallback();if(!r){o.error("sap.ui.mdc.link.Panel: beforeNavigationCallback not set");return}const a=e?.getCustomData()?.[0]?.getValue();const s=a?.length?a:e.getHref();r(t).then(t=>{if(t){A.navigate(s)}})};A.oNavigationPromise=undefined;A.navigate=function(t){const e=_.getUShellContainer();if(t.indexOf("#")===0&&e){if(!A.oNavigationPromise){A.oNavigationPromise=_.getServiceAsync("Navigation").then(e=>{e.navigate({target:{shellHash:t.substring(1)}});A.oNavigationPromise=undefined})}}else{window.location.href=t}};A.prototype.onPressLinkPersonalization=function(){this._openPersonalizationDialog()};A.prototype._openPersonalizationDialog=function(){return new Promise(t=>{const e=this.getParent();this.fireBeforeSelectionDialogOpen();if(e.isA("sap.m.Popover")){e.setModal(true)}P.getInstance().show(this,"LinkItems",{contentWidth:"28rem",contentHeight:"35rem",close:()=>this.fireAfterSelectionDialogClose()}).then(e=>{e.attachClose(()=>this.fireAfterSelectionDialogClose());t(e)})})};A._getVisibleItems=function(t){return t.filter(t=>t.id!==undefined&&t.visible)};A.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel")};A.prototype._propagateDefaultIcon=function(t){if(!t){return}const e=this._getInternalModel();e.getProperty("/runtimeItems").forEach((t,n)=>{if(t.icon){return}e.setProperty("/runtimeItems/"+n+"/icon","sap-icon://chain-link")})};let $,W,D,H,O;function z(t){const e=this._getInternalModel();if(t.object.isA("sap.ui.mdc.link.Panel")){switch(t.name){case"additionalContent":$=t.child?[t.child]:t.children;$.forEach(e=>{switch(t.mutation){case"insert":this._getAdditionalContentArea().addItem(e);break;case"remove":break;default:o.error("Mutation '"+t.mutation+"' is not supported yet.")}});e.setProperty("/countAdditionalContent",$.length);break;case"items":W=t.child?[t.child]:t.children;W.forEach(function(n){const i=e.getProperty("/runtimeItems/");switch(t.mutation){case"insert":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")+1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")+1);i.splice(this.indexOfItem(n),0,n.getJson());e.setProperty("/runtimeItems",i);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(n,{properties:["visible"]});break;case"remove":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")-1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")-1);D=i.find(t=>t.id===n.getId());i.splice(i.indexOf(D),1);e.setProperty("/runtimeItems",i);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(n);n.destroy();this.invalidate();break;default:o.error("Mutation '"+t.mutation+"' is not supported yet.")}},this);break;case"enablePersonalization":this._getPersonalizationButton().setVisible(t.current);break;default:o.error("The property or aggregation '"+t.name+"' has not been registered.")}}else if(t.object.isA("sap.ui.mdc.link.PanelItem")){switch(t.name){case"visible":H=t.object;O=this.indexOfItem(H);if(H.getVisibleChangedByUser()){e.setProperty("/runtimeItems/"+O+"/visible",H.getVisible())}else{e.setProperty("/baselineItems/"+O+"/visible",H.getVisible());e.setProperty("/runtimeItems/"+O+"/visible",H.getVisible())}break;default:o.error("The '"+t.name+"' of PanelItem is not supported yet.")}}}A.prototype.getCurrentState=function(){const t=[];let e;this.getItems().forEach((n,i)=>{e=n&&n.getId();if(n.getVisible()){t.push({key:e,name:e})}});return{items:t}};A.prototype.initPropertyHelper=async function(){await new Promise(t=>{sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],e=>{if(!this._oMetadataHelper){this._oMetadataHelper=e}t()})});const t=this._oMetadataHelper.retrieveAllMetadata(this);return{getProperties:function(){const e=[];t.forEach(t=>{e.push({name:t.id,getName:function(){return t.id},getLabel:function(){return t.text},text:t.text,href:t.href,internalHref:t.internalHref,description:t.description,target:t.target,visible:t.visible})});return e}}};A.prototype._getAdditionalContentArea=function(){return this.getAggregation("_content").getContent()[w]};A.prototype._getSeparator=function(){return this.getAggregation("_content").getContent()[M]};A.prototype._getLinkArea=function(){return this.getAggregation("_content").getContent()[S]};A.prototype._getLinkControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[0])};A.prototype._getLabelControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[1])};A.prototype._getDescriptionTextControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[2])};A.prototype._getFooterArea=function(){return this.getAggregation("_content").getContent()[x]};A.prototype._getPersonalizationButton=function(){return this._getFooterArea().getItems()[0]};return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/PanelItem", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.link.PanelItem",{metadata:{library:"sap.ui.mdc",properties:{text:{type:"string"},description:{type:"string"},href:{type:"string"},internalHref:{type:"string",defaultValue:null},target:{type:"string",defaultValue:undefined},icon:{type:"string"},visible:{type:"boolean",defaultValue:true},visibleChangedByUser:{type:"boolean"}}}});t.prototype.getJson=function(){return{id:this.getId(),text:this.getText(),description:this.getDescription(),href:this.getHref(),internalHref:this.getInternalHref(),icon:this.getIcon(),target:this.getTarget(),visible:this.getVisible(),visibleChangedByUser:this.getVisibleChangedByUser()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/PanelRenderer", [],()=>{"use strict";const n={apiVersion:2};n.render=function(n,e){const t=e.getAggregation("_content");n.openStart("div",e);n.class("mdcbaseinfoPanel");n.openEnd();n.renderControl(t);n.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectMapping", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectMappingItem", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/link/SemanticObjectUnavailableAction", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.link.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/AdaptationMixin", ["sap/m/p13n/Engine"],t=>{"use strict";const i={};i.getEngine=function(){return t.getInstance()};i._onModifications=function(){};i.awaitPendingModification=function(){const i=this._pPendingModification||Promise.resolve();const e=t.getInstance().getTrace(this);return i.then(()=>e)};i.retrieveInbuiltFilter=function(){if(!this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=new Promise((t,i)=>{sap.ui.require(["sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],e=>{if(this.bIsDestroyed){i("exit");return}if(!this._oP13nFilter){this._oP13nFilter=new e(this.getId()+"-p13nFilter",{adaptationControl:this,filterConditions:this.getFilterConditions()});if(this._registerInnerFilter){this._registerInnerFilter.call(this,this._oP13nFilter)}this.addDependent(this._oP13nFilter);t(this._oP13nFilter)}else{t(this._oP13nFilter)}})})}return this._oInbuiltFilterPromise};i.validateState=function(t,i){if(this.getControlDelegate().validateState instanceof Function){return this.getControlDelegate().validateState(this,t,i)}};i.getInbuiltFilter=function(){return this._oP13nFilter};i.exit=function(t){return function(){if(this._oP13nFilter){this._oP13nFilter.destroy();this._oP13nFilter=null}if(this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=null}if(t){t.apply(this,arguments)}}};i._getWaitForChangesPromise=function(){const t=this.getEngine&&this.getEngine();if(!t){throw"Engine instance not found."}return t.waitForChanges(this)};return function(){this.retrieveInbuiltFilter=i.retrieveInbuiltFilter;this.getInbuiltFilter=i.getInbuiltFilter;this.validateState=i.validateState;this._onModifications=i._onModifications;this.awaitPendingModification=i.awaitPendingModification;this._getWaitForChangesPromise=i._getWaitForChangesPromise;this.getEngine=i.getEngine;this.exit=i.exit(this.exit)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/DelegateMixin", ["sap/ui/mdc/util/loadModules","sap/base/Log","sap/ui/mdc/BaseDelegate"],(e,t,i)=>{"use strict";const a=function(e){if(!e||!e.name){throw new Error("Delegate configuration '"+(e&&JSON.stringify(e))+"' invalid")}};const n=function(e){if(!this.bIsDestroyed){if(e instanceof Error){this.fnRejectDelegate(e)}else{this._oDelegate=e[0];this.fnResolveDelegate(this._oDelegate);this.bDelegateInitialized=true}}this.bDelegateLoading=false;delete this.fnResolveDelegate;delete this.fnRejectDelegate};const l={};l.init=function(e){return function(){this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=new Promise((e,t)=>{this.fnResolveDelegate=e;this.fnRejectDelegate=t});if(e){e.apply(this,arguments)}}};l.applySettings=function(e){return function(t){e.apply(this,arguments);this._bDelegateLocked=true;return this}};l.setDelegate=function(e){return function(t){if(this._bDelegateLocked){throw new Error("Runtime delegate configuration is not permitted.")}a(t);e.call(this,t);this._oPayload=t&&t.payload;return this}};l.initControlDelegate=function(i){if(this.bIsDestroyed){t.warning("Delegate module initialization omitted as control is being destroyed.")}else if(!this._oDelegate&&!this.bDelegateLoading){if(i){n.call(this,[i])}else{const t=this.getDelegate();a(t);this.bDelegateLoading=true;e(t.name).then(n.bind(this)).catch(n.bind(this))}}return this._oDelegateInitialized};l.isControlDelegateInitialized=function(){return this.bDelegateInitialized};l.getPayload=function(){if(!this._oPayload){const e=this.getDelegate();this._oPayload=e&&e.payload}return this._oPayload};l.getTypeUtil=function(){return this.getTypeMap()};l.getTypeMap=function(){if(!this._oTypeMap){if(!this._oDelegate){throw new Error("A delegate instance providing a TypeMap is not (yet) available.")}this._oTypeMap=this._oDelegate.getTypeMap(this)}return this._oTypeMap};l.getControlDelegate=function(){if(!this._oDelegate){if(this.isDestroyed()){throw new Error("A delegate instance is not available. The object instance is destroyed.")}else{throw new Error("A delegate instance is not (yet) available. You must call initControlDelegate before calling getControlDelegate.")}}return this._oDelegate};l.awaitControlDelegate=function(){return this._oDelegateInitialized};l.exit=function(e){return function(){this.fnResolveDelegate=null;this.fnRejectDelegate=null;this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=null;this._oDelegate=null;this._oPayload=null;this._oTypeMap=null;if(e){e.apply(this,arguments)}}};return function(){this.applySettings=l.applySettings(this.applySettings);this.exit=l.exit(this.exit);this.init=l.init(this.init);this.setDelegate=l.setDelegate(this.setDelegate);this.awaitControlDelegate=l.awaitControlDelegate;this.isControlDelegateInitialized=l.isControlDelegateInitialized;this.getControlDelegate=l.getControlDelegate;this.getPayload=l.getPayload;this.getTypeUtil=l.getTypeUtil;this.getTypeMap=l.getTypeMap;this.initControlDelegate=l.initControlDelegate}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/FilterIntegrationMixin", ["sap/base/Log","sap/ui/core/Element","sap/ui/mdc/enums/ReasonMode"],(t,e,i)=>{"use strict";const n={};const r="sap.ui.mdc.IFilter";n.setFilter=function(t){const i=typeof t==="object"?t.getId():t;const n=this.getFilter();if(n!==i){this._validateFilter(t);const i=e.getElementById(this.getFilter());if(i){l(this,i)}this.setAssociation("filter",t,true);const n=e.getElementById(this.getFilter());if(n){a(this,n)}}return this};function o(t){const e=t.getParameter("reason");const n=t.getSource();const r=n.getLiveMode&&(n.getLiveMode()?e===i.Enter:e===i.Go);this._rebind(r);if(this._onFilterSearch){this._onFilterSearch(t)}}function s(t){if(this._onFiltersChanged){this._onFiltersChanged(t)}}function a(t,e){e.attachSearch(o,t);if(e.attachFiltersChanged instanceof Function){e.attachFiltersChanged(s,t)}if(t._onFilterProvided instanceof Function){t._onFilterProvided(e)}}function l(t,e){e.detachSearch(o,t);if(e.detachFiltersChanged instanceof Function){e.detachFiltersChanged(s,t)}if(t._onFilterRemoved instanceof Function){t._onFilterRemoved(e)}}function c(t){if(!(t&&t.getMetadata()&&t.getMetadata().hasAssociation("filter"))){throw new Error("Please add the 'filter' association to your control metadata"+t)}if(!(t.rebind instanceof Function)){throw new Error("Please implement the method 'rebind' for the control "+t)}if(!(t.isFilteringEnabled instanceof Function)){throw new Error("Please implement the method isFilteringEnabled for the control "+t)}}n._validateFilter=function(t){c(this);const i=typeof t==="object"?t:e.getElementById(t);if(i&&!i.isA(r)){throw new Error('"'+t+'" is not valid for association "filter".'+' Please use an object that implements the "'+r+'" interface')}};n.rebind=function(){if(this.bIsDestroyed){return Promise.reject("Destroyed")}let t;let i;const n=e.getElementById(this.getFilter()),r=this.isFilteringEnabled();if(r||n){if(n){t=n.validate(true)}if(r){i=this.retrieveInbuiltFilter().then(t=>t.validate(true))}return Promise.all([t,i]).then(()=>this._rebind())}else{return this._rebind()}};n._getLabelsFromFilterConditions=function(){const e=[];if(this.getFilterConditions){const i=this.getFilterConditions();Object.keys(i).forEach(n=>{if(!i[n]||i[n].length<1){return}const r=this.getPropertyHelper().getProperty(n)?this.getPropertyHelper().getProperty(n).label:n;if(r){e.push(r)}if(!r||r===n){t.error("No valid property found for filter with key "+n+". Check your metadata.")}})}return e};return function(){this.setFilter=n.setFilter;this._validateFilter=n._validateFilter;this.rebind=n.rebind;this._getLabelsFromFilterConditions=n._getLabelsFromFilterConditions}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/PromiseMixin", ["sap/ui/mdc/util/PromiseCache"],e=>{"use strict";const i={};i.addPromise=function(e,i){return this.promiseCache.add(e,i)};i.cancelPromise=function(e,i){return this.promiseCache.cancel(e,i)};i.retrievePromise=function(e,i){return this.promiseCache.retrieve(e,i)};i.retrievePromises=function(){return this.promiseCache.retrieveMany(...arguments)};i.removePromise=function(e){return this.promiseCache.remove(e)};i.resolvePromise=function(e,i){return this.promiseCache.resolve(e,i)};i.rejectPromise=function(e,i){return this.promiseCache.reject(e,i)};i.exit=function(e){return function(){if(this.promiseCache){this.promiseCache.destroy();this.promiseCache=null}if(e){e.apply(this,arguments)}}};return function(){const r=function(i){return function(){if(this.bIsDestroyed){return undefined}if(!this.promiseCache){this.promiseCache=new e}return i.apply(this,arguments)}};this._addPromise=r(i.addPromise);this._cancelPromise=r(i.cancelPromise);this._removePromise=r(i.removePromise);this._resolvePromise=r(i.resolvePromise);this._rejectPromise=r(i.rejectPromise);this._retrievePromise=r(i.retrievePromise);this._retrievePromises=r(i.retrievePromises);this.exit=i.exit(this.exit)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/PropertyHelperMixin", ["sap/base/util/Deferred","sap/ui/mdc/util/loadModules","sap/base/future","sap/ui/mdc/util/PropertyHelperUtil"],(e,r,t,i)=>{"use strict";const o={};o.init=function(r){return function(){this._oPropertyHelper=null;this._oPropertyHelperDeferred=new e;this._oApplySettingsDeferred=new e;this._bPropertyHelperFinal=false;this._oPropertiesFinalizedDeferred=new e;this._bPropertyHelperInitializing=false;this._sPropertyInfoStore=null;if(r){r.apply(this,arguments)}}};o.applySettings=function(e){return function(){if(e){e.apply(this,arguments)}if(!this._bPropertyHelperInitializing&&this._sPropertyInfoStore&&(!arguments[0]||!arguments[0].hasOwnProperty(this._sPropertyInfoStore))){s.call(this,[],false)}this._oApplySettingsDeferred.resolve(this);return this}};o.initPropertyHelper=function(e,r,t){if(e){this._setPropertyHelperClass(e)}return s.call(this,r,t)};o.updatePropertyHelper=function(e,r){return s.call(this,e,r)};o.finalizePropertyHelper=function(){this._pHelperFinalizationPromise=this._pHelperFinalizationPromise||l(this).then(e=>s.call(this,e,true));return this._pHelperFinalizationPromise};o.propertiesFinalized=function(){return this._oPropertiesFinalizedDeferred.promise};o.isPropertyHelperFinal=function(){return this._bPropertyHelperFinal};o.awaitPropertyHelper=function(){if(this._oPropertyHelperDeferred){return this._oPropertyHelperDeferred.promise}else{return Promise.resolve()}};o.getPropertyHelper=function(){return this._oPropertyHelper};o.exit=function(e){return function(){this._oPropertyHelper=null;this._oPropertyHelperDeferred=null;this._oApplySettingsDeferred=null;this._bPropertyHelperFinal=null;this._bPropertyHelperInitializing=null;this._pHelperFinalizationPromise=null;this._oPropertyHelperClass=null;this._sPropertyInfoStore=null;if(this._oPropertyInfoStoreMutatorOverride){this[this._oPropertyInfoStoreMutatorOverride.key]=this._oPropertyInfoStoreMutatorOverride.mutator;this._oPropertyInfoStoreMutatorOverride=null}if(e){e.apply(this,arguments)}}};o._setupPropertyInfoStore=function(e){const r=this.getMetadata().getAllProperties();const t=r&&r[e];if(!t){throw new Error("PropertyHelperMixin: Property '"+e+"' not found.")}const i=this.getMetadata().getJSONKeys()[e];this._oPropertyInfoStoreMutatorOverride={key:i._sMutator,mutator:this[i._sMutator]};this[i._sMutator]=function(){this._oPropertyInfoStoreMutatorOverride.mutator.apply(this,arguments);if(!this._bPropertyHelperFinal){s.call(this,this[i._sGetter](),false)}return this};this._sPropertyInfoStore=e};o._setPropertyHelperClass=function(e){if(this._oPropertyHelper||this._bPropertyHelperInitializing){throw new Error("PropertyHelper already initializing/ed.")}if(e&&(!e.getMetadata||!e.getMetadata().isA("sap.ui.mdc.util.PropertyHelper"))){throw new Error("The custom property helper class must be sap.ui.mdc.util.PropertyHelper or a subclass of it.")}this._oPropertyHelperClass=e};o._getPropertyByName=function(e){return this._oPropertyHelper&&this._oPropertyHelper.getProperty(e)};o._getPropertyByNameAsync=function(e){const r=this._getPropertyByName(e);if(!r){return this.finalizePropertyHelper().then(r=>this._getPropertyByName(e))}return Promise.resolve(r)};function s(e,r){if(!this.isDestroyed()){if(this._bPropertyHelperInitializing&&typeof e!=="undefined"){return this._oPropertyHelperDeferred.promise.then(()=>n.call(this,e,r))}if(this._oPropertyHelper&&typeof e!=="undefined"){return n.call(this,e,r).then(()=>this._oPropertyHelperDeferred?.promise)}if(!this._oPropertyHelper){p.call(this,e,r)}}return this._oPropertyHelperDeferred?.promise}function p(e,r){this._bPropertyHelperInitializing=true;if(r||!e){r=true;this._pHelperFinalizationPromise=this._oPropertyHelperDeferred.promise}let o;return this._oApplySettingsDeferred.promise.then(()=>this.initControlDelegate()).then(t=>{o=t;return r?l(this):e}).then(e=>{if(this.isDestroyed()){return[]}return h.call(this,e).then(()=>e)}).then(e=>{if(this.isDestroyed()){return[]}return a(this,o).then(r=>[e,r])}).then(e=>i.checkValidationExceptions().then(r=>e.concat(r))).then(e=>{if(this.isDestroyed()){return undefined}if(Array.isArray(e)===false){return undefined}const[i,o,s]=e;if(s){t.errorThrows(`PropertyInfo validation is disabled for control ${this.getId()}.`,{suffix:`Migrate this control's propertyInfo to avoid breaking changes in the future.`})}this._oPropertyHelper=new o(i,this,undefined);this._bPropertyHelperInitializing=false;if(r){this._bPropertyHelperFinal=true;this._oPropertiesFinalizedDeferred.resolve()}return this._oPropertyHelperDeferred.resolve(this._oPropertyHelper)}).catch(e=>this._oPropertyHelperDeferred&&this._oPropertyHelperDeferred.reject(e))}function n(e,r){if(this._bPropertyHelperFinal){throw new Error("This property helper is already final and cannot be updated further.")}return h.call(this,e).then(t=>{this._oPropertyHelper.setProperties(e);this._bPropertyHelperFinal=r||this._bPropertyHelperFinal;if(this._bPropertyHelperFinal){this._oPropertiesFinalizedDeferred.resolve()}return this._oPropertyHelper})}function l(e){return e.initControlDelegate().then(()=>{const r=e.getControlDelegate(e);return r.fetchProperties(e).then(r=>{if(e.isDestroyed()){return[]}return r})})}function a(e,t){if(t&&typeof t.getPropertyHelperClass==="function"){const r=t.getPropertyHelperClass();const i=e._oPropertyHelperClass?e._oPropertyHelperClass.getMetadata().getName():"sap.ui.mdc.util.PropertyHelper";if(!r||!r.getMetadata||!r.getMetadata().isA(i)){throw new Error("The property helper class must be "+i+" or a subclass of it.")}return Promise.resolve(r)}if(e._oPropertyHelperClass){return Promise.resolve(e._oPropertyHelperClass)}return r("sap/ui/mdc/util/PropertyHelper").then(e=>e[0])}function h(e){const r=[];e?.forEach(e=>{if(e.dataType&&r.indexOf(e.dataType)===-1){r.push(e.dataType)}});return this.getTypeMap().retrieveDataTypeClasses(r)}return function(){this.init=o.init(this.init);this.exit=o.exit(this.exit);this.applySettings=o.applySettings(this.applySettings);this.initPropertyHelper=o.initPropertyHelper;this.awaitPropertyHelper=o.awaitPropertyHelper;this.getPropertyHelper=o.getPropertyHelper;this.finalizePropertyHelper=o.finalizePropertyHelper;this.isPropertyHelperFinal=o.isPropertyHelperFinal;this.propertiesFinalized=o.propertiesFinalized;this._getPropertyByName=o._getPropertyByName;this._getPropertyByNameAsync=o._getPropertyByNameAsync;this._setPropertyHelperClass=o._setPropertyHelperClass;this._setupPropertyInfoStore=o._setupPropertyInfoStore}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/mixin/delegate/FilterIntegrationDefault", ["sap/ui/mdc/util/FilterUtil","sap/ui/core/Element","sap/ui/model/Filter"],(t,e,n)=>{"use strict";function r(e,n){return t.getFilterInfo(n,e?.getConditions()||{},e?.getPropertyHelper?.()?.getProperties()||[])?.filters}function i(t,e){return t.isFilteringEnabled()&&r(t,e)}function s(t,n){const i=t.getFilter();const s=i&&e.getElementById(i);return r(s,n)}const u={};u.getFilters=function(t){const e=this.getTypeMap(t);const r=i(t,e);const u=s(t,e);if(r&&u){return[new n([r,u],true)]}if(r||u){return[r||u]}return[]};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/TypeMap", ["../DefaultTypeMap","sap/ui/mdc/enums/BaseType"],(e,t)=>{"use strict";const a=Object.assign({},e);a.getDateTimeBaseType=function(e,a){if(a&&a.displayFormat==="Date"){return t.Date}else{return t.DateTime}};a.import(e);a.set("sap.ui.model.odata.type.Boolean",t.Boolean);a.set("sap.ui.model.odata.type.Byte",t.Numeric);a.set("sap.ui.model.odata.type.Currency",e.getUnitBaseType,e.getUnitOptions);a.set("sap.ui.model.odata.type.Date",t.Date);a.set("sap.ui.model.odata.type.DateTime",a.getDateTimeBaseType);a.set("sap.ui.model.odata.type.DateTimeOffset",t.DateTime);a.set("sap.ui.model.odata.type.DateTimeWithTimezone",t.DateTime);a.set("sap.ui.model.odata.type.Decimal",t.Numeric);a.set("sap.ui.model.odata.type.Double",t.Numeric);a.set("sap.ui.model.odata.type.Guid",t.String);a.set("sap.ui.model.odata.type.Int16",t.Numeric);a.set("sap.ui.model.odata.type.Int32",t.Numeric);a.set("sap.ui.model.odata.type.Int64",t.Numeric);a.set("sap.ui.model.odata.type.SByte",t.Numeric);a.set("sap.ui.model.odata.type.Single",t.Numeric);a.set("sap.ui.model.odata.type.Stream",t.String);a.set("sap.ui.model.odata.type.String",t.String);a.set("sap.ui.model.odata.type.Time",t.Time);a.set("sap.ui.model.odata.type.TimeOfDay",t.Time);a.set("sap.ui.model.odata.type.Unit",e.getUnitBaseType,e.getUnitOptions);a.setAlias("Edm.Binary","sap.ui.model.odata.type.Stream");a.setAlias("Edm.Boolean","sap.ui.model.odata.type.Boolean");a.setAlias("Edm.Byte","sap.ui.model.odata.type.Byte");a.setAlias("Edm.Date","sap.ui.model.odata.type.Date");a.setAlias("Edm.DateTime","sap.ui.model.odata.type.DateTime");a.setAlias("Edm.DateTimeOffset","sap.ui.model.odata.type.DateTimeOffset");a.setAlias("Edm.Decimal","sap.ui.model.odata.type.Decimal");a.setAlias("Edm.Double","sap.ui.model.odata.type.Double");a.setAlias("Edm.Float","sap.ui.model.odata.type.Single");a.setAlias("Edm.Guid","sap.ui.model.odata.type.Guid");a.setAlias("Edm.Int16","sap.ui.model.odata.type.Int16");a.setAlias("Edm.Int32","sap.ui.model.odata.type.Int32");a.setAlias("Edm.Int64","sap.ui.model.odata.type.Int64");a.setAlias("Edm.SByte","sap.ui.model.odata.type.SByte");a.setAlias("Edm.Single","sap.ui.model.odata.type.Single");a.setAlias("Edm.Stream","sap.ui.model.odata.type.Stream");a.setAlias("Edm.String","sap.ui.model.odata.type.String");a.setAlias("Edm.Time","sap.ui.model.odata.type.Time");a.setAlias("Edm.TimeOfDay","sap.ui.model.odata.type.TimeOfDay");a.initializeTypeFromValue=function(e,a){if(e&&this.getBaseType(e.getMetadata().getName())===t.Unit&&Array.isArray(a)&&a.length>2){if(a[2]!==undefined){const t={mCustomUnits:a[2]};this.initializeInternalType(e,t);return t}}else{return{}}return null};a.initializeInternalType=function(e,t){if(t&&t.mCustomUnits!==undefined){e.formatValue([null,null,t.mCustomUnits],"string")}};a.freeze();return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/TypeUtil", ["sap/ui/mdc/util/TypeUtil","sap/ui/mdc/enums/BaseType"],(e,t)=>{"use strict";const a=Object.assign({},e,{getPrimitiveType:function(e){const t={"Edm.Binary":"boolean","Edm.Boolean":"boolean","Edm.Byte":"boolean","Edm.Date":"date","Edm.DateTimeOffset":"dateTime","Edm.Decimal":"int","Edm.Double":"boolean","Edm.Duration":"float","Edm.Guid":"string","Edm.Int16":"int","Edm.Int32":"int","Edm.Int64":"int","Edm.SByte":"boolean","Edm.Single":"float","Edm.String":"string","Edm.TimeOfDay":"time"};return t[e]||"object"},getDataTypeClassName:function(t){const a={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};if(a[t]){t=a[t]}else if(t&&t.startsWith("Edm.")){throw new Error("Invalid data type "+t)}else{t=e.getDataTypeClassName.call(this,t)}return t},getBaseType:function(a,i,o){switch(a){case"sap.ui.model.odata.type.DateTime":if(o&&o.displayFormat==="Date"){return t.Date}else{return t.DateTime}case"sap.ui.model.odata.type.DateTimeOffset":case"sap.ui.model.odata.type.DateTimeWithTimezone":return t.DateTime;case"sap.ui.model.odata.type.Time":return t.Time;case"sap.ui.model.odata.type.Boolean":return t.Boolean;case"sap.ui.model.odata.type.Byte":case"sap.ui.model.odata.type.SByte":case"sap.ui.model.odata.type.Decimal":case"sap.ui.model.odata.type.Int16":case"sap.ui.model.odata.type.Int32":case"sap.ui.model.odata.type.Int64":case"sap.ui.model.odata.type.Single":case"sap.ui.model.odata.type.Double":return t.Numeric;default:return e.getBaseType.call(this,a,i,o)}},internalizeValue:function(a,i,o,d){const n=this._normalizeType(i,o,d);if(this.getBaseTypeForType(n)===t.Numeric){if(typeof a!=="string"&&(n.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||n.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return a.toString()}}return e.internalizeValue.call(this,a,i,o,d)},externalizeValue:function(a,i,o,d){const n=this._normalizeType(i,o,d);if(this.getBaseTypeForType(n)===t.Numeric){if(typeof a!=="string"&&(n.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||n.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return a.toString()}}return e.externalizeValue.call(this,a,i,o,d)},initializeTypeFromValue:function(e,a){if(e&&this.getBaseType(e.getMetadata().getName())===t.Unit&&Array.isArray(a)&&a.length>2){if(a[2]!==undefined){const t={mCustomUnits:a[2]};this.initializeInternalType(e,t);return t}}else{return{}}return null},initializeInternalType:function(e,t){if(t&&t.mCustomUnits!==undefined){e.formatValue([null,null,t.mCustomUnits],"string")}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ChartDelegate", ["../../ChartDelegate","sap/ui/mdc/odata/v4/TypeMap"],(e,t)=>{"use strict";const a=Object.assign({},e);a.getTypeMap=function(e){return t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ODataMetaModelUtil", [],()=>{"use strict";const e=function(){};e.fetchAllAnnotations=function(e,t){const r=e.getMetaContext(t);return e.requestObject("@",r).then(e=>e)};e.getAllCustomAggregates=function(e){const t={};let r;for(const i in e){if(i.startsWith("@Org.OData.Aggregation.V1.CustomAggregate")){r=i.replace("@Org.OData.Aggregation.V1.CustomAggregate#","");const a=r.split("@");if(a.length==2){if(a[1]=="Org.OData.Aggregation.V1.ContextDefiningProperties"){t[a[0]].contextDefiningProperties=e[i]}if(a[1]=="com.sap.vocabularies.Common.v1.Label"){t[a[0]].label=e[i]}}else if(a.length==1){t[a[0]]={name:a[0],propertyPath:a[0],label:"Custom Aggregate ("+r+")",sortable:true,sortOrder:"both",custom:true}}}}return t};e.getAllAggregatableProperties=function(e){const t={};let r,i;if(e["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"]){r=e["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"];for(let e=0;e<r.length;e++){i=r[e];t[i.Value]={name:i.Value,propertyPath:i.AggregatableProperty.$PropertyPath,aggregationMethod:i.AggregationMethod,label:i["@com.sap.vocabularies.Common.v1.Label"]||"Aggregatable property ("+i.Value+")",sortable:true,sortOrder:"both",custom:false}}}return t};e.getAllDataPoints=function(t){const r={};for(const i in t){if(i.startsWith("@com.sap.vocabularies.UI.v1.DataPoint")){const a=i.replace("@com.sap.vocabularies.UI.v1.DataPoint#","");const n=t[i].Value.$Path;r[n]=r[n]||{};r[n][a]=e.createDataPointProperty(t[i])}}return r};e.createDataPointProperty=function(t){const r={};if(t.TargetValue){r.targetValue=t.TargetValue.$Path}if(t.ForeCastValue){r.foreCastValue=t.ForeCastValue.$Path}let i=null;if(t.Criticality){if(t.Criticality.$Path){i={Calculated:t.Criticality.$Path}}else{i={Static:t.Criticality.$EnumMember.replace("com.sap.vocabularies.UI.v1.CriticalityType/","")}}}else if(t.CriticalityCalculation){const r={};const a=e._buildThresholds(r,t.CriticalityCalculation);if(a){i={ConstantThresholds:r}}else{i={DynamicThresholds:r}}}if(i){r.criticality=i}return r};e._buildThresholds=function(e,t){const r=["AcceptanceRangeLowValue","AcceptanceRangeHighValue","ToleranceRangeLowValue","ToleranceRangeHighValue","DeviationRangeLowValue","DeviationRangeHighValue"];let i=true,a;e.ImprovementDirection=t.ImprovementDirection.$EnumMember.replace("com.sap.vocabularies.UI.v1.ImprovementDirectionType/","");const n={oneSupplied:false,usedMeasures:[]};const s={oneSupplied:false};for(let e=0;e<r.length;e++){a=r[e];n[a]=t[a]?t[a].$Path:undefined;n.oneSupplied=n.oneSupplied||n[a];if(!n.oneSupplied){s[a]=t[a];s.oneSupplied=s.oneSupplied||s[a]}else if(n[a]){n.usedMeasures.push(n[a])}}if(n.oneSupplied){i=false;for(let t=0;t<r.length;t++){if(n[r[t]]){e[r[t]]=n[r[t]]}}e.usedMeasures=n.usedMeasures}else{let i;e.AggregationLevels=[];if(s.oneSupplied){i={VisibleDimensions:null};for(let e=0;e<r.length;e++){if(s[r[e]]){i[r[e]]=s[r[e]]}}e.AggregationLevels.push(i)}if(t.ConstantThresholds&&t.ConstantThresholds.length>0){for(const a of t.ConstantThresholds){const t=a.AggregationLevel?[]:null;if(a.AggregationLevel&&a.AggregationLevel.length>0){for(let e=0;e<a.AggregationLevel.length;e++){t.push(a.AggregationLevel[e].$PropertyPath)}}i={VisibleDimensions:t};for(let e=0;e<r.length;e++){const t=a[r[e]];if(t){i[r[e]]=t}}e.AggregationLevels.push(i)}}}return i};e.getSortRestrictionsInfo=function(e){let t,r;const i={sortable:true,propertyInfo:{}};if(e){i.sortable=e.Sortable!=null?e.Sortable:true;if(e.NonSortableProperties){for(t=0;t<e.NonSortableProperties.length;t++){r=e.NonSortableProperties[t].$PropertyPath;i[r]={sortable:false}}}if(e.AscendingOnlyProperties){for(t=0;t<e.AscendingOnlyProperties.length;t++){r=e.AscendingOnlyProperties[t].$PropertyPath;i[r]={sortable:true,sortDirection:"asc"}}}if(e.DescendingOnlyProperties){for(t=0;t<e.DescendingOnlyProperties.length;t++){r=e.DescendingOnlyProperties[t].$PropertyPath;i[r]={sortable:true,sortDirection:"desc"}}}}return i};e.addSortInfoForProperty=function(e,t){const r=t[e.name];e.sortable=t.sortable&&r?r.sortable:true;if(e.sortable){e.sortDirection=r?r.sortDirection:"both"}};e.getFilterRestrictionsInfo=function(e){let t,r;const i={filterable:true,propertyInfo:{}};if(e){i.filterable=e.Filterable!=null?e.Filterable:true;i.requiresFilter=e.RequiresFilter!=null?e.RequiresFilter:false;i.requiredProperties=[];if(i.RequiredProperties){for(t=0;t<e.NonFilterableProperties.length;t++){r=e.NonFilterableProperties[t].$PropertyPath;i.requiredProperties.push(r)}}if(e.NonFilterableProperties){for(t=0;t<e.NonFilterableProperties.length;t++){r=e.NonFilterableProperties[t].$PropertyPath;i[r]={filterable:false}}}if(e.FilterExpressionRestrictions){for(t=0;t<e.FilterExpressionRestrictions.length;t++){r=e.FilterExpressionRestrictions[t].$PropertyPath;i[r]={filterable:true,allowedExpressions:e.FilterExpressionRestrictions[t].AllowedExpressions}}}}return i};e.isMultiValueFilterExpression=function(e){let t=true;switch(e){case"SearchExpression":case"SingleRange":case"SingleValue":t=false;break;default:break}return t};e.addFilterInfoForProperty=function(e,t){const r=t[e.name];e.filterable=t.filterable&&r?r.filterable:true;if(e.filterable){e.allowedExpressions=r?r.allowedExpressions:null}};e.fetchCalendarTag=function(e,t){const r="@com.sap.vocabularies.Common.v1.";return Promise.all([e.requestObject(r+"IsCalendarYear",t),e.requestObject(r+"IsCalendarHalfyear",t),e.requestObject(r+"IsCalendarQuarter",t),e.requestObject(r+"IsCalendarMonth",t),e.requestObject(r+"IsCalendarWeek",t),e.requestObject(r+"IsDayOfCalendarMonth",t),e.requestObject(r+"IsDayOfCalendarYear",t),e.requestObject(r+"IsCalendarYearHalfyear",t),e.requestObject(r+"IsCalendarYearQuarter",t),e.requestObject(r+"IsCalendarYearMonth",t),e.requestObject(r+"IsCalendarYearWeek",t),e.requestObject(r+"IsCalendarDate",t)]).then(e=>{if(e[0]){return"year"}if(e[1]){return"halfYear"}if(e[2]){return"quarter"}if(e[3]){return"month"}if(e[4]){return"week"}if(e[5]){return"dayOfMonth"}if(e[6]){return"dayOfYear"}if(e[7]){return"yearHalfYear"}if(e[8]){return"yearQuarter"}if(e[9]){return"yearMonth"}if(e[10]){return"yearWeek"}if(e[11]){return"date"}return undefined})};e.fetchFiscalTag=function(e,t){const r="@com.sap.vocabularies.Common.v1.";return Promise.all([e.requestObject(r+"IsFiscalYear",t),e.requestObject(r+"IsFiscalPeriod",t),e.requestObject(r+"IsFiscalYearPeriod",t),e.requestObject(r+"IsFiscalQuarter",t),e.requestObject(r+"IsFiscalYearQuarter",t),e.requestObject(r+"IsFiscalWeek",t),e.requestObject(r+"IsFiscalYearWeek",t),e.requestObject(r+"IsDayOfFiscalYear",t),e.requestObject(r+"IsFiscalYearVariant",t)]).then(e=>{if(e[0]){return"year"}if(e[1]){return"period"}if(e[2]){return"yearPeriod"}if(e[3]){return"quarter"}if(e[4]){return"yearQuarter"}if(e[5]){return"week"}if(e[6]){return"yearWeek"}if(e[7]){return"dayOfYear"}if(e[8]){return"yearVariant"}return undefined})};e.fetchCriticality=function(e,t){const r="@com.sap.vocabularies.UI.v1";return e.requestObject(r+".ValueCriticality",t).then(e=>{let t,r;if(e){t={VeryPositive:[],Positive:[],Critical:[],VeryNegative:[],Negative:[],Neutral:[]};for(let i=0;i<e.length;i++){r=e[i];if(r.Criticality.$EnumMember.endsWith("VeryPositive")){t.VeryPositive.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Positive")){t.Positive.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Critical")){t.Critical.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("VeryNegative")){t.VeryNegative.push(r.Value)}else if(r.Criticality.$EnumMember.endsWith("Negative")){t.Negative.push(r.Value)}else{t.Neutral.push(r.Value)}}for(const e in t){if(t[e].length==0){delete t[e]}}}return t})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TableDelegate", ["../../TableDelegate","../../table/V4AnalyticsPropertyHelper","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/odata/v4/TypeMap","sap/ui/mdc/util/loadModules","sap/m/plugins/PluginBase","sap/ui/core/Lib","sap/ui/core/format/ListFormat","sap/ui/core/message/MessageType"],(e,t,n,r,o,i,a,s,l,g,p)=>{"use strict";const u=Object.assign({},e);u.getTypeMap=function(e){return i};u.getPropertyHelperClass=function(){return t};u.updateBindingInfo=function(t,n){const r=t.getRowBinding()?.getAggregation();e.updateBindingInfo.apply(this,arguments);if("expandTo"in(r??{})){n.parameters.$$aggregation={expandTo:r.expandTo}}if(!E(t)){const e=b(t);if(e.length>0){const r=t.getPropertyHelper();n.parameters.$select=e.map(e=>r.getProperty(e).path)}}};u.getGroupSorter=function(t){const n=t._getGroupedProperties()[0];if(!n||!t._isOfType(r.ResponsiveTable)){return undefined}if(!P(t).includes(n.name)){return undefined}return e.getGroupSorter.apply(this,arguments)};u.getSorters=function(t){let n=e.getSorters.apply(this,arguments);if(E(t)){const e=t.getPropertyHelper();const r=P(t).map(t=>e.getProperty(t).path);n=n.filter(e=>r.includes(e.sPath))}return n};u.updateBinding=function(e,t,n,r){if(E(e)){h(e,t)}if(!n||n.getPath()!=t.path){this.rebind(e,t);return}const o=n.getRootBinding();let i=o&&!o.isSuspended();try{if(i){o.suspend()}n.setAggregation(t.parameters?.$$aggregation);n.changeParameters((()=>{const e={...t.parameters};delete e.$$aggregation;return e})());n.filter(t.filters,"Application");n.sort(t.sorter);if(r&&r.forceRefresh){n.refresh()}}catch(r){this.rebind(e,t);if(o==n){i=false}}finally{if(i&&o.isSuspended()){o.resume()}}};u.fetchExpandAndCollapseConfiguration=function(e){if(!e._isOfType(r.TreeTable)){return Promise.resolve({})}return Promise.resolve({expandAll:function(e){c(e,Number.MAX_SAFE_INTEGER)},collapseAll:function(e){c(e,1)},expandAllFromNode:function(e,t){t.expand(Number.MAX_SAFE_INTEGER)},collapseAllFromNode:function(e,t){t.collapse(true)},isNodeExpanded:function(e,t){return t.getProperty("@$ui5.node.isExpanded")}})};function c(e,t){const n=e.getRowBinding();if(!n){return}const r=n.getAggregation()?.expandTo===t;if(r){n.refresh()}else{n.setAggregation({...n.getAggregation(),...{expandTo:t}})}}u.getInResultPropertyKeys=function(e){return[]};u.getSupportedFeatures=function(t){const o=e.getSupportedFeatures.apply(this,arguments);if(t._isOfType(r.Table)){const e=o.p13nModes;if(!e.includes(n.Group)){e.push(n.Group)}if(!e.includes(n.Aggregate)){e.push(n.Aggregate)}}return{...o}};u.validateState=function(t,n,r){const o=e.validateState.apply(this,arguments);let i;if(r=="Sort"){i=f(t,n)}else if(r=="Group"){i=d(t,n)}else if(r=="Column"){i=y(t,n)}return R(o,i)};function f(e,t){if(E(e)&&_(e,t.items,t.sorters)){return{validation:p.Information,message:l.getResourceBundleFor("sap.ui.mdc").getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION")}}return null}function d(e,t){const n=l.getResourceBundleFor("sap.ui.mdc");if(t.aggregations){const r=Object.keys(t.aggregations);const o=[];const i=g.getInstance();r.forEach(t=>{const n=e.getPropertyHelper().getProperty(t);if(n&&n.groupable){o.push(t)}});if(o.length>0){return{validation:p.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_TOTALS",[i.format(o)])}}}else if(e._isOfType(r.ResponsiveTable)){if(_(e,t.items,t.groupLevels)){return{validation:p.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_VISIBLE")}}}return null}function y(e,t){const n=l.getResourceBundleFor("sap.ui.mdc");const o=t.aggregations&&Object.keys(t.aggregations);let i;if(e._isOfType(r.ResponsiveTable)){if(_(e,t.items,t.groupLevels)){return{validation:p.Information,message:n.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION_VISIBLE")}}}if(_(e,t.items,o)){i=n.getText("table.PERSONALIZATION_DIALOG_TOTAL_RESTRICTION")}if(E(e)&&_(e,t.items,t.sorters)){const e=n.getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION");i=i?i+"\n"+e:e}if(i){return{validation:p.Information,message:i}}return null}u.preInit=function(){return Promise.resolve()};u.initializeContent=async function(t){await e.initializeContent.apply(this,arguments);if(t._isOfType(r.Table)){await m(t)}};async function m(e){const[t]=await a("sap/ui/table/plugins/V4Aggregation");e._oTable.addDependent(new t({enabled:{parts:[{path:"$sap.ui.mdc.Table>/p13nMode"},{path:"$sap.ui.mdc.Table>/groupConditions"},{path:"$sap.ui.mdc.Table>/aggregateConditions"}],formatter:function(t,n,r){return E(e)}},groupHeaderFormatter:function(t){const n=e._getGroupedProperties().map(e=>e.name);const r=n[t.getProperty("@$ui5.node.level")-1];return e.getControlDelegate().formatGroupHeader(e,t,r)}}))}u.initializeSelection=function(t){if(t._isOfType(r.Table,true)){return T(t)}else{return e.initializeSelection.apply(this,arguments)}};function T(e){const t={Single:"Single",SingleMaster:"Single",Multi:"MultiToggle"};return a("sap/ui/table/plugins/ODataV4Selection").then(n=>{const r=n[0];e._oTable.addDependent(new r({limit:"{$sap.ui.mdc.Table#type>/selectionLimit}",enableNotification:true,hideHeaderSelector:"{= !${$sap.ui.mdc.Table#type>/showHeaderSelector} }",selectionMode:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return t[e]}},enabled:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return e in t}},selectionChange:function(t){e._onSelectionChange({selectAll:t.getParameter("selectAll")})}}))})}u.setSelectedContexts=function(t,n){if(t._isOfType(r.Table,true)){const e=t.getSelectionMode();if(e===o.None||(e===o.Single||e===o.SingleMaster)&&n.length>1){throw Error("Unsupported operation: Cannot select the given number of contexts in the current selection mode")}t.clearSelection();for(const e of n){e.setSelected(true)}}else{e.setSelectedContexts.apply(this,arguments)}};u.getSelectedContexts=function(t){if(t._isOfType(r.Table,true)){return s.getPlugin(t._oTable,"sap.ui.table.plugins.ODataV4Selection")?.getSelectedContexts()??[]}return e.getSelectedContexts.apply(this,arguments)};function h(e,t){const n=x(e);const r=t.parameters.$search;if(n&&r){delete t.parameters.$search;n.search=r}t.parameters.$$aggregation=n;const o=Object.keys(n?.aggregate||{}).some(e=>n.aggregate[e].grandTotal);e.getModel("$sap.ui.mdc.Table").setProperty("/@custom/hasGrandTotal",o);const i=s.getPlugin(e._oTable,"sap.ui.table.plugins.V4Aggregation");i?.declareColumnsHavingTotals(S(e).map(e=>e.getInnerColumn()))}function P(e){return O(e,e.getColumns())}function b(e){return O(e,e.getControlDelegate().getInResultPropertyKeys(e))}function S(e){const t=Object.keys(e._getAggregatedProperties());const n=new Set;for(const r of e.getColumns()){const o=A(e,r).filter(e=>t.includes(e.key));const i=o.length>0;if(i){n.add(r);I(e,o).forEach(e=>{n.add(e)})}}return Array.from(n)}function O(e,t){const n=e.getPropertyHelper();const r=typeof t[0]==="object"?t.map(e=>e.getPropertyKey()):t;return Array.from(new Set(r.flatMap(e=>n.getProperty(e)?.getSimpleProperties().map(e=>e.key)||[])))}function A(e,t){const n=e.getPropertyHelper().getProperty(t.getPropertyKey());if(!n){return[]}else{return n.getSimpleProperties()}}function I(e,t){const n=[];t.forEach(e=>{if(e.unit){n.push(e.unit)}});return e.getColumns().filter(t=>A(e,t).some(e=>n.includes(e.key)))}function _(e,t,n){const r=[];if(t){t.forEach(t=>{e.getPropertyHelper().getProperty(t.name).getSimpleProperties().forEach(e=>{r.push(e.key)})})}const o=n?n.every(e=>r.find(t=>e.name?e.name===t:e===t)):true;return!o}function R(e,t){const n={Error:1,Warning:2,Information:3,None:4};if(!t||n[t.validation]-n[e.validation]>0){return e}else{return t}}function E(e){return e._isOfType(r.Table)&&(e._getGroupedProperties().length>0||e.isGroupingEnabled()||Object.keys(e._getAggregatedProperties()).length>0||e.isAggregationEnabled())}function x(e){const t=P(e);if(t.length===0){return undefined}const n={leafLevel:false,...e.getPayload()?.aggregationConfiguration};const r=e.getPropertyHelper();const o=e._getGroupedProperties().map(e=>e.name);const i=Object.keys(e._getAggregatedProperties());const a={group:{},groupLevels:[],aggregate:{},grandTotalAtBottomOnly:true,subtotalsAtBottomOnly:true};if(!n.leafLevel){C(a,e)}N(a,e);o.forEach(e=>{if(t.indexOf(e)<0){t.push(e)}});for(const n of t){const t=r.getProperty(n);if(t.extension.technicallyGroupable){v(a,e,t)}if(t.extension.technicallyAggregatable){G(a,e,t,{withTotals:i.includes(t.key)})}}o.forEach(e=>{const t=r.getProperty(e);if(t){a.groupLevels.push(t.path)}});if(!Object.keys(a.group).length&&!Object.keys(a.aggregate).length){return undefined}L(a);return a}function C(e,t){t.getPropertyHelper().getProperties().forEach(t=>{if(t.isKey){e.group[t.path]={}}})}function N(e,t){const n=t.getPropertyHelper();for(const r of b(t)){const t=n.getProperty(r);if(t.extension.technicallyGroupable){e.group[t.path]={}}else if(t.extension.technicallyAggregatable){e.aggregate[t.path]={}}}}function v(e,t,n){const r=t.getPropertyHelper();const o={};if(n.extension.additionalProperties.length===1){const o=r.getProperty(n.extension.additionalProperties[0]);if(o.text===n.key){v(e,t,o);return}}e.group[n.path]=o;const i=r.getProperty(n.text);if(i){o.additionally=[i.path]}const a=r.getProperty(n.unit);if(a){e.group[a.path]??={}}for(const t of n.extension.additionalProperties){const n=r.getProperty(t);e.group[n.path]??={}}}function G(e,t,n,r){const o=t.getPropertyHelper();const i={};e.aggregate[n.path]=i;if(r?.withTotals){i.grandTotal=true;i.subtotals=true}const a=o.getProperty(n.unit);if(a){i.unit=a.path}for(const t of n.extension.additionalProperties){const n=o.getProperty(t);e.group[n.path]??={}}}function L(e){$(e);M(e)}function $(e){for(const t in e.group){if(t in e.aggregate){if(e.aggregate[t].grandTotal||e.aggregate[t].subtotals){delete e.group[t]}else{delete e.aggregate[t]}}}}function M(e){const t=new Set;for(const n in e.group){e.group[n].additionally?.forEach(e=>t.add(e))}for(const n of t){if(n in e.group){delete e.group[n]}}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TypeMap", ["../TypeMap","sap/ui/mdc/enums/BaseType"],(e,t)=>{"use strict";const s=Object.assign({},e);s.addV4Constraint=function(e,t,s){return[e,Object.assign({},t,{V4:true})]};s.import(e);s.set("sap.ui.model.odata.type.DateTimeOffset",t.DateTime,s.addV4Constraint);s.freeze();return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/TypeUtil", ["sap/ui/mdc/odata/TypeUtil","sap/ui/mdc/enums/BaseType","sap/base/util/merge"],(e,t,a)=>{"use strict";const s=Object.assign({},e);s.getBaseType=function(a,s,i){switch(a){case"sap.ui.model.odata.type.Date":return t.Date;case"sap.ui.model.odata.type.TimeOfDay":return t.Time;case"sap.ui.model.odata.type.Unit":case"sap.ui.model.odata.type.Currency":if(!s||(!s.hasOwnProperty("showMeasure")||s.showMeasure)&&(!s.hasOwnProperty("showNumber")||s.showNumber)){return t.Unit}else if(!s.hasOwnProperty("showNumber")||s.showNumber){return t.Numeric}else{return t.String}default:return e.getBaseType.call(this,a,s,i)}};s.getDataTypeClassName=function(t){const a={"Edm.Date":"sap.ui.model.odata.type.Date","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};if(a[t]){t=a[t]}else{t=e.getDataTypeClassName.call(this,t)}return t};s.getDataTypeInstance=function(e,t,s){switch(e){case"sap.ui.model.odata.type.DateTimeOffset":case"Edm.DateTimeOffset":s=a({},s);s.V4=true;break;default:}const i=this.getDataTypeClass(e);return new i(t,s)};s._adjustUnitFormatOptions=function(t,a,s){e._adjustUnitFormatOptions.call(this,t,a,s);if(t.hasOwnProperty("unitOptional")){delete t.unitOptional}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/ValueHelpDelegate", ["../../ValueHelpDelegate","sap/base/Log","sap/ui/model/FilterType","sap/base/util/deepEqual","sap/ui/mdc/odata/v4/TypeMap"],(e,t,i,n,s)=>{"use strict";const r=Object.assign({},e);r.getTypeMap=function(e){return s};r.isSearchSupported=function(e,t,i){if(!t.isPropertyInitial("filterFields")){const e=t.getFilterFields();return e==="$search"?!!i?.changeParameters:!!e}return i?!!i.changeParameters:true};r.updateBindingInfo=function(t,i,n){e.updateBindingInfo(t,i,n);if(!i.isPropertyInitial("filterFields")){const e=i.getFilterFields();if(e&&e!=="$search"){return}}if(i.isSearchSupported()){const e=this.adjustSearch?this.adjustSearch(t,i.isTypeahead(),i.getSearch()):i.getSearch();n.parameters.$search=e||undefined}};r.updateBinding=function(e,t,n){const s=t.getRootBinding()||t;if(!s.isSuspended()){s.suspend()}t.changeParameters(n.parameters);t.filter(n.filters,i.Application);if(s.isSuspended()){s.resume()}};r.executeFilter=function(e,t,i){t.getContexts(0,i);return Promise.resolve(this.checkListBindingPending(e,t,i)).then(()=>t)};r.checkListBindingPending=function(e,t,i){if(!t||t.isSuspended()){return false}return t.requestContexts(0,i).then(e=>e.length===0)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/util/DelegateUtil", ["sap/ui/mdc/util/FilterUtil","sap/ui/mdc/condition/ConditionConverter","sap/base/Log","sap/base/util/merge","sap/ui/model/FilterOperator","sap/ui/model/odata/v4/ODataUtils"],(e,t,a,r,n,o)=>{"use strict";const i={_getParameters:function(e){let t=null;if(e&&e.getDelegate()&&e.getDelegate().payload&&e.getDelegate().payload.collectionName){const a=e.getDelegate().payload.collectionName;if(window[e.getId()+"->"+a+"-Parameters"]){t=window[e.getId()+"->"+a+"-Parameters"]}}return t},getParametersInfo:function(e){const t=i._getParameters(e);return i._getParameterPath(e,t)},_getParametersListUrl:function(t,a){const r=[];const i=e.getConditionsMap(t,a);const s=t.getPropertyInfoSet();a.forEach(t=>{const a=e.getPropertyByKey(s,t);if(a&&a.maxConditions===1){i[t].forEach(e=>{if(e.operator===n.EQ){r.push(t+"="+encodeURIComponent(o.formatLiteral(e.values[0],a.typeConfig.className)))}})}});return r},_getParameterPath:function(e,t){if(!e||!e.isA("sap.ui.mdc.FilterBar")){return null}if(!t||t.parameters.length<=0){return null}const a=e.getDelegate().payload.collectionName;const r=i._getParametersListUrl(e,t.parameters);return"/"+a+"("+r.toString()+")/"+t.parameterNavigationName},getParameterNames:function(e){let t=null;const a=i._getParameters(e);if(a){t=a.parameters}return t}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/odata/v4/vizChart/ChartDelegate", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/odata/v4/ChartDelegate","sap/m/Text","sap/base/Log","sap/ui/mdc/odata/v4/util/DelegateUtil","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/ui/mdc/chart/ChartImplementationContainer","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/p13n/MessageStrip","sap/ui/mdc/FilterBarDelegate","sap/ui/mdc/chart/PropertyHelper","sap/ui/thirdparty/jquery","sap/ui/mdc/enums/ChartItemRoleType","sap/base/util/merge"],(t,e,r,a,n,i,o,s,l,u,c,g,h,d,jQuery,p,m)=>{"use strict";const y=Object.assign({},r);const f=new window.WeakMap;let _;let C;let b;let I;let S;y._getState=function(t){if(f.has(t)){return f.get(t)}if(t){n.info("Couldn't get state for "+t.getId())}};y._setState=function(t,e){f.set(t,e)};y._deleteState=function(t){if(this._getState(t)){if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}if(this._getState(t).observer){this._getState(t).observer.disconnect();this._getState(t).observer=null}}return f.delete(t)};y._getChart=function(t){if(f.has(t)){return f.get(t).innerChart}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setChart=function(t,e){if(f.has(t)){f.get(t).innerChart=e}else{f.set(t,{innerChart:e})}};y._getInnerStructure=function(t){if(f.has(t)){return f.get(t).innerStructure}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setInnerStructure=function(t,e){if(f.has(t)){f.get(t).innerStructure=e}else{f.set(t,{innerStructure:e})}};y.getFilterDelegate=function(){return h};y.addCondition=function(t,e,r){return Promise.resolve()};y.removeCondition=function(t,e,r){return Promise.resolve()};y._getBindingInfoFromState=function(t){if(f.has(t)){const e=f.get(t).bindingInfo;if(e){delete e.events}return e}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setBindingInfoForState=function(t,e){if(f.has(t)){f.get(t).bindingInfo=e}else{f.set(t,{bindingInfo:e})}};y._setUpChartObserver=function(t){const e=this._getState(t);if(!e.observer){e.observer=new u(t=>{if(t.type==="destroy"){this.exit(t.object)}})}e.observer.observe(t,{destroy:true})};y.exit=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).destroy()}this._deleteState(t)};y.zoomIn=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"in"})}};y.zoomOut=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"out"})}};y.getZoomState=function(t){if(this._getChart(t)){const e=this._getChart(t).getZoomInfo();if(e&&e.hasOwnProperty("currentZoomLevel")&&e.currentZoomLevel!=null&&e.enabled){return{enabled:e.enabled,enabledZoomIn:e.currentZoomLevel<1,enabledZoomOut:e.currentZoomLevel>0}}}return{enabled:false}};y.getInnerChartSelectionHandler=function(t){return{eventId:"_selectionDetails",listener:this._getChart(t)}};y.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout}const t=[p.axis1,p.category,p.series];const e=[p.axis1,p.axis2,p.category,p.series];const r=[p.axis1,p.category,p.category2];const a=[p.axis1,p.axis2,p.axis3,p.category,p.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:t},{key:"bar",allowedLayoutOptions:t},{key:"line",allowedLayoutOptions:t},{key:"combination",allowedLayoutOptions:t},{key:"pie",allowedLayoutOptions:t},{key:"donut",allowedLayoutOptions:t},{key:"dual_column",allowedLayoutOptions:e},{key:"dual_bar",allowedLayoutOptions:e},{key:"dual_line",allowedLayoutOptions:e},{key:"stacked_bar",allowedLayoutOptions:t},{key:"scatter",allowedLayoutOptions:e},{key:"bubble",allowedLayoutOptions:a},{key:"heatmap",allowedLayoutOptions:r},{key:"bullet",allowedLayoutOptions:t},{key:"vertical_bullet",allowedLayoutOptions:t},{key:"dual_stacked_bar",allowedLayoutOptions:e},{key:"100_stacked_bar",allowedLayoutOptions:t},{key:"stacked_column",allowedLayoutOptions:t},{key:"dual_stacked_column",allowedLayoutOptions:e},{key:"100_stacked_column",allowedLayoutOptions:t},{key:"dual_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_stacked_combination",allowedLayoutOptions:e},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:e},{key:"stacked_combination",allowedLayoutOptions:t},{key:"100_dual_stacked_bar",allowedLayoutOptions:t},{key:"100_dual_stacked_column",allowedLayoutOptions:t},{key:"horizontal_stacked_combination",allowedLayoutOptions:t},{key:"waterfall",allowedLayoutOptions:r},{key:"horizontal_waterfall",allowedLayoutOptions:r}];return this._aChartTypeLayout};y.getAdaptionUI=function(t){return Promise.resolve(this._setupAdaptionUI(t))};y._setupAdaptionUI=function(t){let r=this.getChartTypeLayoutConfig().find(e=>e.key===t.getChartType());if(!r){const e=[p.axis1,p.axis2,p.axis3,p.category,p.category2,p.series];r={key:t.getChartType(),allowedLayoutOptions:e}}const a=[{kind:"Groupable"},{kind:"Aggregatable"}];r.templateConfig=a;const n={panelConfig:r};const i=new c(n);if(t.getChartType()==="heatmap"){const t=e.getResourceBundleFor("sap.ui.mdc");i.setMessageStrip(new g({text:t.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}))}return i};y.setLegendVisible=function(t,e){if(this._getChart(t)){this._getChart(t).setVizProperties({legend:{visible:e},sizeLegend:{visible:e}})}else{n.error("Could not set legend visibility since inner chart is not yet initialized!")}};y._getSorterForItem=function(t,e){if(t.getType()==="aggregatable"){return new s(this._getAggregatedMeasureNameForMDCItem(t),e.descending)}else if(t.getType()==="groupable"){return new s(this.getInternalChartNameFromPropertyNameAndKind(e.key,"groupable",t.getParent()),e.descending)}};y.insertItemToInnerChart=function(t,e,r){if(e.getType()==="groupable"){const a=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const n=this._getChart(t).getDimensionByName(a);if(!n){this.createInnerDimension(t,e)}else{n.setLabel(e.getLabel());n.setRole(e.getRole()?e.getRole():"category")}const i=t._bDrillDown;if(i&&n){this._getChart(t).drillDown(n);t._bDrillDown=false}else if(!i){const e=this._getChart(t).getVisibleDimensions();e.splice(r,0,a);this._getChart(t).setVisibleDimensions(e)}}else if(e.getType()==="aggregatable"){this.createInnerMeasure(t,e);const a=this._getChart(t).getVisibleMeasures();a.splice(r,0,this._getAggregatedMeasureNameForMDCItem(e));this._getChart(t).setVisibleMeasures(a)}this._prepareColoringForItem(t,e).then(()=>{this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures())});this._updateSemanticalPattern(t)};y.removeItemFromInnerChart=function(t,e){if(e.getType()==="groupable"&&this._getChart(t).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t))){if(this._getState(t).inResultDimensions.length>0){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}if(t._iDrillUpIndex){this._getChart(t).drillUp(t._iDrillUpIndex);t._iDrillUpIndex=0}else{let e=t.getItems().filter(t=>t.getType()==="groupable");e=e.map(function(e){return this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t)}.bind(this));this._getChart(t).setVisibleDimensions(e)}}else if(e.getType()==="aggregatable"&&this._getChart(t).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(e))){const r=[];t.getItems().filter(t=>t.getType()==="aggregatable").filter(t=>t!==e).forEach(t=>{r.push(this._getAggregatedMeasureNameForMDCItem(t))});this._getChart(t).setVisibleMeasures(r);this._getChart(t).removeMeasure(this._getChart(t).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(e)))}this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures());this._updateSemanticalPattern(t)};y.addItem=function(t,e,r,a){if(t.getModel){return Promise.resolve(this._createMDCChartItem(e,t,a))}};y.removeItem=function(t,e){return Promise.resolve(true)};y._createMDCChartItem=function(t,e,r){return this._getPropertyInfosByName(t,e).then(t=>{if(!t){return null}return this._createMDCItemFromProperty(t,e.getId(),r)})};y._createMDCItemFromProperty=function(t,e,r){if(t.groupable){return new o(e+"--GroupableItem--"+t.key,{propertyKey:t.key,label:t.label,type:"groupable",role:r?r:"category"})}if(t.aggregatable){return new o(e+"--AggregatableItem--"+t.key,{propertyKey:t.key,label:t.label,type:"aggregatable",role:r?r:"axis1"})}return null};y.initializeInnerChart=function(t){return new Promise((e,r)=>{this._loadChart().then(r=>{if(!t.isDestroyed()){let r;this._setInnerStructure(t,new l(t.getId()+"--implementationContainer",{}));t.addStyleClass("sapUiMDCChartTempTextOuter");if(t.getNoData()){this._getInnerStructure(t).setChartNoDataContent(t.getNoData())}else{r=new a({text:t.getNoDataText()});this._getInnerStructure(t).addStyleClass("sapUiMDCChartTempText");this._getInnerStructure(t).setNoDataContent(r)}this._setUpChartObserver(t);e(this._getInnerStructure(t))}})})};y.changedNoDataStruct=function(t,e){const r=this._getInnerStructure(t);if(r){r.setChartNoDataContent(e);r.invalidate()}};y._createContentFromItems=function(t){return new Promise((e,r)=>{const a=[];const i=[];const o=[];const s=[];t.getItems().forEach((e,r)=>{i.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{if(!r){n.error("sap.ui.mdc.Chart: Item "+e.getPropertyKey()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return}switch(e.getType()){case"groupable":o.push(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t));this._addInnerDimension(t,e,r);break;case"aggregatable":s.push(this._getAggregatedMeasureNameForMDCItem(e));this._addInnerMeasure(t,e,r);break;default:n.error("MDC Chart Item "+e.getId()+" with label "+e.getLabel()+' has no known type. Supported typed are: "groupable" & "aggregatable"')}a.push(this._prepareColoringForItem(t,e))}))});Promise.all(i).then(()=>{this._getState(t).aColMeasures.forEach(e=>{if(this._getState(t).aInSettings.indexOf(e)==-1){a.push(new Promise((r,a)=>{t._getPropertyByNameAsync(e).then(function(a){const n=this.getPropertyAttribute(t,a,"aggregationMethod");const i=this.getPropertyAttribute(t,a,"path");const o=this.getInternalChartNameFromPropertyNameAndKind(e,"aggregatable",t);const l={name:o,label:a.label,role:a.role||"axis1"};if(n&&i){l.analyticalInfo={propertyPath:i,with:n}}const u=this.getPropertyAttribute(t,a,"unitPath");if(u){l.unitBinding=u}const c=new I(l);s.push(c);this._getChart(t).addMeasure(c);r()})}))}});Promise.all(a).then(()=>{this._getChart(t).setVisibleDimensions(o);this._getChart(t).setVisibleMeasures(s);const r=t.getDelegate().inResultDimensions;if(r&&r instanceof Array&&r.length!=0){const e=[];r.forEach(r=>{e.push(this._getPropertyInfosByName(r,t).then(e=>{const r=y.innerDimensionFactory(t,undefined,e);this._getChart(t).addDimension(r);const a=this.getInternalChartNameFromPropertyNameAndKind(e.key,"groupable",t);this._getState(t).inResultDimensions.push(a)}))});Promise.all(e).then(()=>{this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)})}this._updateColoring(t,o,s);this._updateSemanticalPattern(t);e()})})})};y.getInnerChart=function(t){return this._getChart(t)};y._prepareColoringForItem=function(t,e){return this._addCriticality(t,e).then(()=>{this._getState(e.getParent()).aInSettings.push(e.getPropertyKey());if(e.getType()==="aggregatable"){this._getPropertyInfosByName(e.getPropertyKey(),e.getParent()).then(r=>{this._getAdditionalColoringMeasuresForItem(t,r).forEach(t=>{const r=this._getState(e.getParent());if(r.aColMeasures?.indexOf(t)==-1){r.aColMeasures.push(t)}})})}})};y._getAdditionalColoringMeasuresForItem=function(t,e){let r=[];const a=this.getPropertyAttribute(t,e,"datapoint");const n=a?.criticality||null;if(n?.DynamicThresholds){r=n.DynamicThresholds.usedMeasures}return r};y._addCriticality=function(t,e){return this._getPropertyInfosByName(e.getPropertyKey(),e.getParent()).then(r=>{const a=this.getPropertyAttribute(t,r,"datapoint");const n=this.getPropertyAttribute(t,r,"criticality");if(n||a?.criticality){const a=this._getState(e.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};const i={};if(e.getType()=="groupable"){const t=n||[];for(const e in t){i[e]={Values:t[e]}}const r=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",e.getParent());a.Criticality.DimensionValues[r]=i}else{const n=this.getPropertyAttribute(t,r,"datapoint");const o=n?.criticality||[];for(const t in o){i[t]=o[t]}const s=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"aggregatable",e.getParent());a.Criticality.MeasureValues[s]=i}const o=this._getState(e.getParent());o.oColorings=a;this._setState(e.getParent(),o)}})};y._updateColoring=function(t,e,r){const a=this._getChart(t);const n=this._getState(t);const i=jQuery.extend(true,{},n.oColorings);if(i&&i.Criticality){let t;for(let r=0;r<e.length;r++){const a=e[r];if(n.oColorings.Criticality.DimensionValues[a]){t={coloring:"Criticality",parameters:{dimension:a}};delete i.Criticality.MeasureValues;break}}if(!t){delete i.Criticality.DimensionValues;for(const t in i.Criticality.MeasureValues){if(r.indexOf(t)==-1){delete i.Criticality.MeasureValues[t]}}t={coloring:"Criticality",parameters:{measure:r}}}if(t){a.setColorings(i);a.setActiveColoring(t)}}};y._updateSemanticalPattern=function(t){const e=this._getChart(t).getVisibleMeasures();e.forEach(e=>{const r=this.getPropertyFromNameAndKind(e,"aggregatable",t);if(!r){return}const a=this.getPropertyAttribute(t,r,"datapoint");if(a){if(a.targetValue||a.foreCastValue){const r=this._getChart(t).getMeasureByName(e);r.setSemantics("actual");if(a.targetValue!=null){const e=this._getChart(t).getMeasureByName(a.targetValue);if(e){e.setSemantics("reference")}else{n.error("sap.ui.mdc.Chart: "+a.targetValue+" is not a valid measure")}}if(a.foreCastValue){const e=this._getChart(t).getMeasureByName(a.foreCastValue);if(e){e.setSemantics("projected")}else{n.error("sap.ui.comp.SmartChart: "+a.ForecastValue.Path+" is not a valid measure")}}r.setSemanticallyRelatedMeasures({referenceValueMeasure:a.targetValue,projectedValueMeasure:a.foreCastValue})}}})};y.mMatchingIcon={bar:"sap-icon://horizontal-bar-chart",bullet:"sap-icon://horizontal-bullet-chart",bubble:"sap-icon://bubble-chart",column:"sap-icon://vertical-bar-chart",combination:"sap-icon://business-objects-experience",dual_bar:"sap-icon://horizontal-bar-chart",dual_column:"sap-icon://vertical-bar-chart",dual_combination:"sap-icon://business-objects-experience",dual_horizontal_combination:"sap-icon://business-objects-experience",dual_horizontal_stacked_combination:"sap-icon://business-objects-experience",dual_line:"sap-icon://line-chart",dual_stacked_bar:"sap-icon://full-stacked-chart",dual_stacked_column:"sap-icon://vertical-stacked-chart",dual_stacked_combination:"sap-icon://business-objects-experience",donut:"sap-icon://donut-chart",heatmap:"sap-icon://heatmap-chart",horizontal_stacked_combination:"sap-icon://business-objects-experience",line:"sap-icon://line-chart",pie:"sap-icon://pie-chart",scatter:"sap-icon://scatter-chart",stacked_bar:"sap-icon://full-stacked-chart",stacked_column:"sap-icon://vertical-stacked-chart",stacked_combination:"sap-icon://business-objects-experience",treemap:"sap-icon://Chart-Tree-Map",vertical_bullet:"sap-icon://vertical-bullet-chart","100_dual_stacked_bar":"sap-icon://full-stacked-chart","100_dual_stacked_column":"sap-icon://vertical-stacked-chart","100_stacked_bar":"sap-icon://full-stacked-chart","100_stacked_column":"sap-icon://full-stacked-column-chart",waterfall:"sap-icon://vertical-waterfall-chart",horizontal_waterfall:"sap-icon://horizontal-waterfall-chart"};y.getChartTypeInfo=function(t){const r=t.getChartType(),a=e.getResourceBundleFor("sap.ui.mdc"),n=e.getResourceBundleFor("sap.chart");const i={icon:y.mMatchingIcon[r],text:a.getText("chart.CHART_TYPE_TOOLTIP",[n.getText("info/"+r)])};return i};y.getAvailableChartTypes=function(t){const r=[];if(this._getChart(t)){const a=this._getChart(t).getAvailableChartTypes().available;const n=e.getResourceBundleFor("sap.chart");for(let t=0;t<a.length;t++){const e=a[t].chart;r.push({key:e,icon:y.mMatchingIcon[e],text:n.getText("info/"+e)})}}return r};y.getDrillStack=function(t){const e=Object.assign([],this._getChart(t).getDrillStack());e.forEach(e=>{e.dimension=e.dimension.map(e=>{const r=this.getPropertyFromNameAndKind(e,"groupable",t);if(r){return r.key}else{n.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+e);return e}})});return e};y.getSortedDimensions=function(t){return new Promise((e,r)=>{if(t.isPropertyHelperFinal()){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}else{t.finalizePropertyHelper().then(()=>{e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))})}})};y._sortPropertyDimensions=function(t){const e=t.filter(t=>t.groupable);if(e){e.sort((t,e)=>{if(t.label&&e.label){return t.label.localeCompare(e.label)}})}return e};y.getDrillableItems=function(t){const e=t.getItems().filter(t=>t.getType()==="groupable");return e};y.setChartType=function(t,e){this._getChart(t).setChartType(e)};y.createInnerChartContent=function(t,e){return new Promise((r,a)=>{this._setChart(t,new _({id:t.getId()+"--innerChart",chartType:"column",height:"100%",width:"100%",isAnalytical:true,vizProperties:{plotArea:{scrollbar:{forceToShowInMobile:true}}}}));this._getChart(t).setCustomMessages({NO_DATA:t.getNoDataText()});this._getState(t).inResultDimensions=[];this._getInnerStructure(t).removeStyleClass("sapUiMDCChartTempText");t.removeStyleClass("sapUiMDCChartTempTextOuter");t.addStyleClass("sapUiMDCChartGrid");const i=this._getState(t);i.aColMeasures=[];i.aInSettings=[];this._setState(t,i);this._createContentFromItems(t).then(()=>{this._getChart(t).attachRenderComplete(()=>{if(this._getState(t).toolbarUpdateRequested){t._updateToolbar();this._getState(t).toolbarUpdateRequested=false}});this._getInnerStructure(t).setContent(this._getChart(t));this._getInnerStructure(t).setShowNoDataStruct(false);i.dataLoadedCallback=e;this._setState(t,i);let a;if(this._getBindingInfo){a=this._getBindingInfo(t);n.warning("mdc ChartDelegate","calling the private delegate._getBindingInfo. Please make the function public!")}else{a=this.getBindingInfo(t)}this.updateBindingInfo(t,a);this._performInitialBind(t,a);r()})})};y._performInitialBind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const r=this._getState(t);r.innerChartBound=true;this._checkForMeasureWarning(t)}};y.requestToolbarUpdate=function(t){if(t.getItems().length===0){t._updateToolbar();return}this._getState(t).toolbarUpdateRequested=true};y.createInnerDimension=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{this._addInnerDimension(t,e,r)})};y.createInnerMeasure=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{this._addInnerMeasure(t,e,r)})};y._addInnerDimension=function(t,e,r){const a=this.innerDimensionFactory(t,e,r);this._getChart(t).addDimension(a);if(t._bDrillDown){this._getChart(t).drillDown(a);t._bDrillDown=false}};y.innerDimensionFactory=function(t,e,r){let a;const n=this.getInternalChartNameFromPropertyNameAndKind(e?.getPropertyKey()||r.key,"groupable",t);let i={name:n,role:e?.getRole()||r.role,label:e?.getLabel()||r.label,textFormatter:this.formatText.bind(r)};const o=this.getPropertyAttribute(t,r,"timeUnitType");if(o){i=m(i,{timeUnit:o});a=new b(i)}else{a=new C(i)}const s=this.getPropertyAttribute(t,r,"textProperty");if(s){a.setTextProperty(s);a.setDisplayText(true)}return a};y._addInnerMeasure=function(t,e,r){const a=this.innerMeasureFactory(t,e,r);this._getChart(t).addMeasure(a)};y.fetchConfigurationForVizchart=function(t,e,r){return null};y.getPropertyAttribute=function(t,e,r){let a=e.hasOwnProperty(r)?e[r]:null;if(!a){a=this.fetchConfigurationForVizchart(t,e.key,r)}return a};y.innerMeasureFactory=function(t,e,r){const a=this.getPropertyAttribute(t,r,"aggregationMethod");const n=this.getPropertyAttribute(t,r,"path");const i={name:this._getAggregatedMeasureNameForMDCItem(e),label:e?.getLabel()||r.label,role:e?.getRole()||r.role||"axis1"};if(a&&n){i.analyticalInfo={propertyPath:n,with:a}}const o=this.getPropertyAttribute(t,r,"unitPath");if(o){i.unitBinding=o}return new I(i)};y.rebind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getInnerStructure(t).setShowNoDataStruct(false);if(e.binding){e.binding.bHasAnalyticalInfo=true}this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const r=this._getState(t);r.innerChartBound=true}};y._checkForMeasureWarning=function(t){if(!t.getNoData()){return}const e=t.getItems().filter(t=>t.getType()==="aggregatable");if(e.length===0){this._getInnerStructure(t).setShowNoDataStruct(true);t.setBusy(false)}else{this._getInnerStructure(t).setShowNoDataStruct(false)}};y.getBindingInfo=function(t){if(this._getBindingInfoFromState(t)){return this._getBindingInfoFromState(t)}const e=t.getDelegate().payload;const r="/"+e.collectionName;const a={path:r};return a};y.getInnerChartBound=function(t){const e=this._getState(t);return!!e?.innerChartBound};y.updateBindingInfo=function(t,e){P(t,e);e.filters=this.getFilters(t);e.sorter=this.getSorters(t)};function P(e,r){const a=t.getElementById(e.getFilter());if(!a){return}const n=a.getConditions();const o=a.getSearch instanceof Function?a.getSearch():"";if(n){const t=i.getParametersInfo(a,n);if(t){r.path=t}}if(!r.parameters){r.parameters={}}r.parameters["$search"]=o||undefined}y.getSorters=function(t){let e;const r=t.getSortConditions()?t.getSortConditions().sorters:[];r.forEach(r=>{const a=t.getItems().find(t=>t.getPropertyKey()===r.key);if(!a){return}const n=this._getSorterForItem(a,r);if(e){e.push(n)}else{e=[n]}});return e};y._getAggregatedMeasureNameForMDCItem=function(t){return this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent())};y.getInternalChartNameFromPropertyNameAndKind=function(t,e,r){return t};y.getPropertyFromNameAndKind=function(t,e,r){return r.getPropertyHelper().getProperty(t)};y.setChartTooltipVisibility=function(t,e){if(this._getChart(t)){if(e){if(!this._getState(t).vizTooltip){const e=this._getState(t);e.vizTooltip=new S;this._setState(t,e)}this._getState(t).vizTooltip.connect(this._getChart(t).getVizUid())}else if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}}else{n.error("Trying to set chart tooltip while inner chart was not yet initialized")}};y._loadChart=function(){return new Promise(t=>{const r=["sap/chart/Chart","sap/chart/data/Dimension","sap/chart/data/TimeDimension","sap/chart/data/Measure","sap/viz/ui5/controls/VizTooltip"];function a(e,r,a,n,i){_=e;C=r;b=a;I=n;S=i;t()}e.load({name:"sap.viz"}).then(()=>{sap.ui.require(r,a)})})};y.getPropertyHelperClass=function(){return d};y.formatText=function(t,e){return t};y.setNoDataText=function(t,e){this._getChart(t).setCustomMessages({NO_DATA:e})};y.showOverlay=function(t,e){if(this._getInnerStructure(t)){this._getInnerStructure(t).showOverlay(e)}};y._getPropertyInfosByName=function(t,e){return e._getPropertyByNameAsync(t)};y._getModel=function(t){const e=t.getDelegate().payload;return t.getModel(e.model)};y._addBindingListener=function(t,e,r){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=r}else{const a=t.events[e];t.events[e]=function(){r.apply(this,arguments);a.apply(this,arguments)}}};y._onDataLoadComplete=function(t){const e=this.getControlDelegate()._getInnerStructure(this);if(this.getNoData()){if(t.getSource()&&t.getSource().getCurrentContexts().length===0){e.setShowNoDataStruct(true)}else{e.setShowNoDataStruct(false)}}this._innerChartDataLoadComplete(t);const r=this.getControlDelegate()._getChart(this);this._announceUpdate(this.getChartType(),this.getHeader(),r.getVisibleDimensions().length,r.getVisibleMeasures().length)};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/P13nBuilder", ["./PropertyHelper","sap/base/i18n/Localization","sap/m/Button","sap/m/Bar","sap/m/Title","sap/base/util/merge","sap/m/MessageBox","sap/ui/Device","sap/ui/core/Lib","sap/ui/core/Locale","sap/ui/core/library"],(e,t,n,o,r,i,s,a,c,l,u)=>{"use strict";const p=c.getResourceBundleFor("sap.ui.mdc");const{TitleLevel:g}=u;const d={createP13nPopover:function(e,t){return new Promise((n,o)=>{sap.ui.require(["sap/m/ResponsivePopover"],r=>{d["_checkSettings"](e,t,o);const i=new r({title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:false,contentWidth:t.contentWidth?t.contentWidth:"24rem",resizable:t.hasOwnProperty("resizable")?t.resizable:true,contentHeight:t.contentHeight?t.contentHeight:"35rem",placement:t.placement?t.placement:"Bottom",content:e,afterClose:t.afterClose?t.afterClose:function(){}});if(t.reset){const e=d._createResetHeader({title:t.title,reset:t.reset.onExecute,idResetButton:t.reset.idButton,warningText:t.reset.warningText});i.setCustomHeader(e)}n(i)},o)})},createP13nDialog:function(e,t){return new Promise((n,o)=>{d["_checkSettings"](e,t,o);const r=t.id;sap.ui.require(["sap/m/Dialog","sap/m/Button"],(i,s)=>{const l=c.getResourceBundleFor("sap.ui.mdc");const u=new i(r,{title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:true,contentWidth:t.contentWidth?t.contentWidth:"40rem",contentHeight:t.contentHeight?t.contentHeight:"55rem",draggable:true,resizable:true,stretch:a.system.phone,content:e,afterClose:t.afterClose?t.afterClose:function(){},buttons:[new s(r?r+"-confirmBtn":undefined,{text:t.confirm&&t.confirm.text?t.confirm.text:l.getText("p13nDialog.OK"),type:"Emphasized",press:function(){if(t.confirm&&t.confirm.handler){t.confirm.handler.apply(u,arguments)}}}),new s(r?r+"-cancelBtn":undefined,{text:l.getText("p13nDialog.CANCEL"),press:function(){t.cancel.apply(u,arguments)}})]});if(t.reset){const e=d._createResetHeader({title:t.title,idResetButton:t.reset.idButton,reset:t.reset.onExecute,warningText:t.reset.warningText});u.setCustomHeader(e)}const p=t.additionalButtons;if(p instanceof Array){p.forEach(e=>{if(!e.isA("sap.m.Button")){o("Please only provide sap.m.Button instances as 'additionalButtons'")}u.addButton(e)})}n(u)},o)})},_createResetHeader:function(e){const t=new o({contentLeft:[new r({text:e.title,level:g.H1})]});if(e.reset){const o=e.idResetButton;t.addContentRight(new n(o,{text:c.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.RESET"),press:function(t){const n=t.getSource().getParent().getParent();const o=n.getParent();const r=e.warningText?e.warningText:c.getResourceBundleFor("sap.ui.mdc").getText("filterbar.ADAPT_RESET_WARNING");s.warning(r,{actions:[s.Action.OK,s.Action.CANCEL],emphasizedAction:s.Action.OK,onClose:function(t){if(t===s.Action.OK){n.getButtons()[0].focus();e.reset(o)}}})}}))}return t},prepareAdaptationData:function(t,n,o){const r=t&&t.getProperties instanceof Function?t:new e(t);const i=[];const s=o?{}:null;const a=n instanceof Function;r.getProperties().forEach(e=>{const t={};t.name=e.name;if(a){const o=n(t,e);if(!o){return}}t.label=e.label||e.name;t.tooltip=e.tooltip;if(s){t.group=e.group?e.group:"BASIC";t.groupLabel=e.groupLabel;s[t.group]=s[t.group]?s[t.group]:[];s[t.group].push(t)}i.push(t)});const c={items:i};if(s){c.itemsGrouped=this._buildGroupStructure(s)}return c},sortP13nData:function(e,n){const o=e;const r=o.position;const i=o.visible;const s=new l(t.getLanguageTag()).toString();const a=window.Intl.Collator(s,{});n.sort((e,t)=>{if(e[i]&&t[i]){return(e[r]||0)-(t[r]||0)}else if(e[i]){return-1}else if(t[i]){return 1}else if(!e[i]&&!t[i]){return a.compare(e.label,t.label)}})},_buildGroupStructure:function(e){const t=[];Object.keys(e).forEach(n=>{this.sortP13nData("generic",e[n]);t.push({group:n,groupLabel:e[n][0].groupLabel||p.getText("p13nDialog.FILTER_DEFAULT_GROUP"),groupVisible:true,items:e[n]})});return t},_isExcludeProperty:function(e,t){return t.some(t=>{const n=t.ignoreKey;const o=t.ignoreValue;return e[n]===o})},_checkSettings:function(e,t,n){if(!t){n("Please provide a settings object for p13n creation")}if(!t.title&&!t.customHeader){n("Please provide a title or customHeader in the settings object for p13n creation")}},arrayToMap:function(e){return e.reduce((e,t,n)=>{e[t.name]=t;e[t.name].position=n;return e},{})},addRTACustomFieldButton:function(e,t){let i=false,s=e.getParent();if(t&&t.isA("sap.ui.comp.smarttable.SmartTable")){s=t}return new Promise(t=>{sap.ui.require(["sap/ui/fl/write/api/FieldExtensibility","sap/ui/core/EventBus"],(a,l)=>{const u=s&&s.getModel();const p=u&&u.sServiceUrl?u.sServiceUrl:"";const d=Promise.all([a.onControlSelected(s),a.isServiceOutdated(p),a.isExtensibilityEnabled(s)]);return d.then(e=>{if(e[1]){a.setServiceValid(p);l.getInstance().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{})}i=!!e[2];return i}).then(i=>{let l=e.getCustomHeader();const u=s&&s.getId?s.getId():undefined,p=c.getResourceBundleFor("sap.ui.mdc");if(!l){const t=new o({contentLeft:[new r({text:e.getTitle(),level:g.H1})]});e.setCustomHeader(t);l=e.getCustomHeader()}if(i){l.addContentRight(new n(u+"-addCustomField",{icon:"sap-icon://add",enabled:i,tooltip:p.getText("p13nDialog.rtaAddTooltip"),press:function(e){const t="sapUiRTABorder",n=e.getSource().getParent().getParent();a.getExtensionData().then(e=>{a.onTriggerCreateExtensionData(e,t);n.close()})}}));e.setCustomHeader(l);t(e)}})})})}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/PersistenceProvider", ["sap/m/p13n/PersistenceProvider"],e=>{"use strict";return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/PropertyHelper", ["../util/PropertyHelper"],e=>{"use strict";const t=e.extend("sap.ui.mdc.p13n.PropertyHelper",{constructor:function(t,r){e.call(this,t,r,{filterable:true,sortable:true})}});t.prototype.validateProperties=function(){};t.prototype.prepareProperty=function(t){e.prototype.prepareProperty.apply(this,arguments);t.label=t.label||t.name};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/StateUtil", ["sap/m/p13n/Engine"],e=>{"use strict";const t={applyExternalState:function(t,n){const a=e.getInstance().internalizeKeys(t,n);return e.getInstance().applyState(t,a,false)},retrieveExternalState:function(t){return e.getInstance().retrieveState(t).then(n=>e.getInstance().externalizeKeys(t,n))},resetState:function(t){const n=e.getInstance().getRegisteredControllers(t);return e.getInstance().reset(t,n)},diffState:function(t,n,a){return e.getInstance().diffState(t,e.getInstance().internalizeKeys(t,n),e.getInstance().internalizeKeys(t,a)).then(n=>e.getInstance().externalizeKeys(t,n))},attachStateChange:function(t){e.getInstance().stateHandlerRegistry.attachChange(t)},detachStateChange:function(t){e.getInstance().stateHandlerRegistry.detachChange(t)}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/ActionToolbarPanel", ["sap/m/p13n/SelectionPanel","sap/ui/model/Sorter","sap/m/p13n/MessageStrip","sap/ui/core/message/MessageType"],(t,e,o,s)=>{"use strict";const n=t.extend("sap.ui.mdc.p13n.panels.ActionToolbarPanel",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2}});n.prototype._bindListItems=function(t){const o=this.getAggregation("_template");if(o){const o=function(t){return t.getProperty("alignment")};const s=new e({path:"alignment",descending:false,group:o});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",sorter:s,key:"name",templateShareable:false,template:this.getAggregation("_template").clone()},t))}};n.prototype._removeFactoryControl=function(){this._oListControl.getItems().filter(t=>!t._bGroupHeader).forEach(t=>{const e=t.getCells()[0];if(e.getItems().length>1){e.removeItem(e.getItems()[1])}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields};n.prototype._moveTableItem=function(t,e){const o=this._oListControl.getItems();const s=this._getP13nModel().getProperty("/items");const n=s.indexOf(this._getModelEntry(t));e=e<=0?0:Math.min(e,o.length-1);const i=s.indexOf(o[e].getBindingContext(this.P13N_MODEL).getObject());if(i==n){return}s.splice(i,0,s.splice(n,1)[0]);this._getP13nModel().setProperty("/items",s);this._oSelectedItem=this._oListControl.getItems()[e];this._updateEnableOfMoveButtons(this._oSelectedItem,true);this._handleActivated(this._oSelectedItem);this.fireChange({reason:"Move",item:this._getModelEntry(this._oSelectedItem)});this._updateItemEnableState()};n.prototype._onPressButtonMoveToTop=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(!this._oListControl.getItems()[t-1]._bGroupHeader){t--}this._moveSelectedItem(t)};n.prototype._onPressButtonMoveToBottom=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(t<this._oListControl.getItems().length-1&&!this._oListControl.getItems()[t+1]._bGroupHeader){t++}this._moveSelectedItem(t)};n.prototype._onItemPressed=function(t){const e=t.getParameter("srcControl");if(!this._isControlPartOfMoveButtons(e)){const e=t.getParameter("listItem");this._oSelectedItem=e;const o=e.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this.PRESENCE_ATTRIBUTE)){this._handleActivated(e);this._updateEnableOfMoveButtons(e,true)}}};n.prototype._isControlPartOfMoveButtons=function(t){const e=this._oSelectedItem?this._oSelectedItem.getCells()[1].getItems():[];let o=false;if(e.length>2){for(let s=2;s<e.length;s++){if(e[s]==t||e[s]==t.getParent()){o=true}}}return o};n.prototype._updateEnableOfMoveButtons=function(t,e){const o=this._oListControl.getItems().indexOf(t);const s=this._oListControl.getItems().length-1;let n=true,i=true;if(o==0){n=false}if(o==s){i=false}const r=this._oListControl.getItems().some(t=>t._bGroupHeader);if(r){if(o>0&&this._oListControl.getItems()[o-1]._bGroupHeader){n=false}if(o<s&&this._oListControl.getItems()[o+1]._bGroupHeader){i=false}}this._getMoveTopButton().setEnabled(n);this._getMoveUpButton().setEnabled(n);this._getMoveDownButton().setEnabled(i);this._getMoveBottomButton().setEnabled(i);if(e){t.focus()}};n.prototype._updateMessageStripForItemEnablement=function(){const t=this._getP13nModel().getProperty("/items");const e=t.find(t=>t.enabled==false);if(!e){this.setMessageStrip(null);return}const n=new o({text:this._getResourceText("p13n.MESSAGE_DISABLED_ITEMS"),type:s.Warning,showIcon:true});this.setMessageStrip(n)};n.prototype._updateItemEnableState=function(){this._oListControl.getItems().forEach(t=>{if(!t.isA("sap.m.ColumnListItem")){return}this._updateCheckboxEnablement(t)});this._updateMessageStripForItemEnablement();this._updateClearAllIcon()};n.prototype._updateCheckboxEnablement=function(t){t.onsapspace=()=>{};t.removeStyleClass("sapMLIBActive");const e=t.getMultiSelectControl(true);e.bindProperty("enabled",{path:`${this.P13N_MODEL}>enabled`,formatter:function(t){return t??true}})};n.prototype._createInnerListControl=function(){const e=t.prototype._createInnerListControl.apply(this,arguments);return e};n.prototype.setP13nData=function(e){t.prototype.setP13nData.apply(this,arguments);this._updateItemEnableState();return this};n.prototype._filterList=function(e,o,s){t.prototype._filterList.apply(this,arguments);this._updateItemEnableState()};n.prototype._updateClearAllIcon=function(){const t=this._getP13nModel().getProperty("/items");const e=t?.filter(t=>t.enabled===false);this._oListControl._getClearAllIcon()?.setVisible(e.length===0)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/AdaptFiltersPanel", ["sap/m/p13n/AbstractContainer","sap/m/p13n/AbstractContainerItem","sap/m/p13n/SelectionPanel","./GroupView","sap/ui/core/Lib","sap/ui/model/Filter","sap/m/Button","sap/m/Bar","sap/m/ToolbarSpacer","sap/m/Select","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/core/InvisibleText","sap/m/SearchField","sap/m/OverflowToolbarLayoutData","sap/ui/core/Item","sap/m/library","sap/ui/model/json/JSONModel"],(t,e,i,s,o,n,r,a,h,c,l,u,p,g,d,_,w,y)=>{"use strict";const{BarDesign:S}=w;const f=t.extend("sap.ui.mdc.p13n.panels.AdaptFiltersPanel",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"},enableReorder:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});f.prototype.GROUP_KEY="group";f.prototype.LIST_KEY="list";f.prototype.P13N_MODEL="$p13n";f.prototype.getVerticalScrolling=function(){return true};f.prototype.applySettings=function(o){this.addView(new e({key:this.LIST_KEY,content:new i(this.getId()+"-listView",{activeColumn:this._getResourceText("p13nDialog.LIST_VIEW_ACTIVE"),change:function(t){this.fireChange();this.getP13nModel().setProperty("/items",t.getSource().getP13nData())}.bind(this)})}));this.addView(new e({key:this.GROUP_KEY,content:new s(this.getId()+"-groupView",{change:function(t){this.fireChange();this.getP13nModel().setProperty("/itemsGrouped",t.getSource().getP13nData())}.bind(this)})}));t.prototype.applySettings.apply(this,arguments);this.getView(this.LIST_KEY).getContent().setEnableReorder(this.getEnableReorder());const n=this._getQuickFilter();const r=this._getViewSwitch();const c=this._getShowHideBtn();const l=new a({contentMiddle:[n,new h,c,r]});l.setDesign(S.SubHeader);this.setHeader(l);const u=new a({contentMiddle:[this._getSearchField()]});u.addStyleClass("sapUiMDCAdaptFiltersSearchBar");u.setDesign(S.SubHeader);this.setSubHeader(u);this.addStyleClass("sapUiMDCAdaptFiltersPanel")};f.prototype.setItemFactory=function(t){this.setProperty("itemFactory",t);this.getViews().forEach(e=>{const i=e.getContent();i.setItemFactory(t)});return this};f.prototype.switchView=function(e){const i=e;t.prototype.switchView.call(this,i);this._getShowHideBtn().setVisible(!this._isCustomView());this._getViewSwitch().setSelectedKey(this.getCurrentViewKey());if(!this._isCustomView(e)){this.showFactory(this.getCurrentViewContent()._getShowFactory())}this._filterByModeAndSearch()};f.prototype.addCustomView=function(t){const i=t.item;const s=i.getKey();const o=t.content;const n=t.search;const r=t.selectionChange;const a=t.filterSelect;if(!s){throw new Error("Please provide an item of type sap.m.SegmentedButtonItem with a key")}if(this._oViewSwitch){this._oViewSwitch.attachSelectionChange(t=>{if(r){r(t.getParameter("item").getKey())}if(this._isCustomView()){if(n instanceof Function){n(this._getSearchField().getValue())}if(a instanceof Function){a(this._getQuickFilter().getSelectedKey())}}})}if(n instanceof Function){this._getSearchField().attachLiveChange(t=>{if(this._isCustomView()){n(this._getSearchField().getValue())}})}if(a instanceof Function){this._getQuickFilter().attachChange(t=>{if(this._isCustomView()){a(this._getQuickFilter().getSelectedKey())}})}this.addView(new e({key:s,content:o.addStyleClass("sapUiMDCPanelPadding")}));const h=this._getViewSwitch();h.addItem(i)};f.prototype.showFactory=function(t){if(this.getCurrentViewContent().showFactory){this.getCurrentViewContent().showFactory(t)}};f.prototype.getSelectedFields=function(){return this.getCurrentViewContent().getSelectedFields()};f.prototype.setGroupExpanded=function(t,e){this.getView(this.GROUP_KEY).getContent().setGroupExpanded(t,e)};f.prototype.setP13nModel=function(t){this.setModel(t,this.P13N_MODEL);this.getView(this.LIST_KEY).getContent().setP13nData(t.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(t.getProperty("/itemsGrouped"));this._filterByModeAndSearch()};f.prototype.setP13nData=function(t){const e=this.getP13nModel();if(!e){this.setP13nModel(new y(t))}else{e.setData(t);this.getView(this.LIST_KEY).getContent().setP13nData(e.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(e.getProperty("/itemsGrouped"))}};f.prototype.restoreDefaults=function(){this._sModeKey="all";this._getQuickFilter().setSelectedKey(this._sModeKey);this._getSearchField().setValue("");this._filterByModeAndSearch();if(this.getCurrentViewKey()===this.LIST_KEY){this._getShowHideBtn().setText(this._getResourceText("filterbar.ADAPT_SHOW_VALUE"));this.showFactory(false)}};f.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL)};f.prototype._getShowHideBtn=function(){const t=this._getResourceText("filterbar.ADAPT_SHOW_VALUE");const e=this._getResourceText("filterbar.ADAPT_HIDE_VALUE");if(!this._oShowHideBtn){this._oShowHideBtn=new r({press:function(i){this.showFactory(!this.getCurrentViewContent()._getShowFactory());const s=i.oSource;const o=s.getText()===t?e:t;s.setText(o)}.bind(this)})}this._oShowHideBtn.setText(!this._isCustomView()&&this.getCurrentViewContent()._getShowFactory()?e:t);return this._oShowHideBtn};f.prototype._getQuickFilter=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new c({items:[new _({key:"all",text:this._getResourceText("p13nDialog.GROUPMODE_ALL")}),new _({key:"visible",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new _({key:"active",text:this._getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new _({key:"visibleactive",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")}),new _({key:"mandatory",text:this._getResourceText("p13nDialog.GROUPMODE_MANDATORY")})],tooltip:this._getResourceText("p13nDialog.QUICK_FILTER"),change:this._onGroupModeChange.bind(this)})}return this._oGroupModeSelect};f.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new g(this.getId()+"-searchField",{liveChange:[this._filterByModeAndSearch,this],width:"100%"});this._oSearchField.setPlaceholder(this._getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"))}return this._oSearchField};f.prototype.getInitialFocusedControl=function(){return this._getSearchField()};f.prototype._onGroupModeChange=function(t){this._sModeKey=t.getParameters().selectedItem.getKey();this._filterByModeAndSearch()};f.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new l({items:[new u({tooltip:this._getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new u({tooltip:this._getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(t){if(this.getCurrentViewKey()===this.LIST_KEY){this.getCurrentViewContent()._removeMoveButtons()}const e=t.getParameter("item").getKey();this.switchView(e)}.bind(this)});this._oInvText=new p({text:this._getResourceText("p13nDialog.VIEW_SWITCH")}).toStatic();this._oViewSwitch.addAriaLabelledBy(this._oInvText)}return this._oViewSwitch};f.prototype._isCustomView=function(){return this._sCurrentView!=this.GROUP_KEY&&this._sCurrentView!=this.LIST_KEY};f.prototype._filterByModeAndSearch=function(){if(this._isCustomView(this.getCurrentViewKey())){return}this._sSearchString=this._getSearchField().getValue();const t=this._createFilterQuery();this._getSearchField().setValue(this._sSearchString);this.getCurrentViewContent().filterContent(t);return t};f.prototype._getResourceText=function(t){return o.getResourceBundleFor("sap.ui.mdc").getText(t)};f.prototype._createFilterQuery=function(){let t=[],e=[],i=[];if(this._sSearchString){t=[new n("label","Contains",this._sSearchString),new n("tooltip","Contains",this._sSearchString)];i=new n(t,false)}switch(this._sModeKey){case"visible":e=new n("visible","EQ",true);break;case"active":e=new n("active","EQ",true);break;case"mandatory":e=new n("required","EQ",true);break;case"visibleactive":e=new n([new n("active","EQ",true),new n("visible","EQ",true)],true);break;default:}const s=new n("visibleInDialog","EQ",true);return new n([].concat(i,e,s),true)};f.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._sModeKey=null;this._sSearchString=null;if(this._oInvText){this._oInvText.destroy();this._oInvText=null}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/ChartItemPanel", ["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/m/Button","sap/m/Column","sap/m/Table","sap/ui/core/Lib","sap/ui/core/Element","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/enums/ChartItemRoleType","sap/ui/core/InvisibleMessage","sap/ui/mdc/chart/Util"],(e,t,o,n,i,s,r,a,l,h,p,g,u,c,m,d,_,f,M,I,y,b,jQuery,v,P,C,B,O)=>{"use strict";const{ValueState:D}=v;const{FlexJustifyContent:x}=M;const E=e.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},init:function(){this._bMobileMode=I.system.phone;e.prototype.init.apply(this,arguments);this._bindListItems()},renderer:{apiVersion:2}});E.prototype._setInnerLayout=function(){this._oInnerControl=new c({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){let e=null;const t=this.getParent();if(t&&t.$){e=t.$("cont");if(e.children().length>0){const e=this._oInnerControl.$()[0].clientWidth;const t=570;if(!this._bMobileMode&&e<=t){this._switchMobileMode(true)}else if(this._bMobileMode&&e>t){this._switchMobileMode(false)}}}}};if(I.system.desktop){this._sContainerResizeListener=y.register(this._oInnerControl,this._fnHandleResize.bind(this))}};E.prototype._switchMobileMode=function(e){if(this._bMobileMode==e){return}this._bMobileMode=e;if(this._sContainerResizeListener){y.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._setInnerLayout();this._bindListItems()};E.prototype._createInnerListControl=function(){const e=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";const t=new l(e,Object.assign(this._getListControlConfig(),{}));this.setEnableReorder(true);const o=t.onItemFocusIn;t.onItemFocusIn=function(e,n){if(this.getEnableReorder()){this._handleActivated(e)}o.apply(t,arguments)}.bind(this);t.addEventDelegate({onAfterRendering:this._onAfterTableRender.bind(this)});return t};E.prototype._onAfterTableRender=function(){if(this._oFocusInfo){if(this._oFocusInfo.oMoveButton){this._oFocusInfo.oMoveButton.focus()}this._oFocusInfo=null}this._mInvalidMap.forEach((e,t)=>{if(this._mNamesMap.has(t)){this._mNamesMap.get(t).setValueState(D.Error);this._mNamesMap.get(t).setValue(e)}})};E.prototype._bindListItems=function(e){let t;const o=h.getResourceBundleFor("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){t=this.getPanelConfig().sorter}else{const e={text:o.getText("chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER")};const n={text:o.getText("chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER")};const i={Aggregatable:e,Groupable:n,Measure:e,Dimension:n};const s=function(e){const t=e.getProperty("kind");return{key:t,text:i[t].text}};const r=function(e,t){if(e===t){return 0}if(e==="MEASURE"||e==="AGGREGATABLE"){return 1}return-1};t=new _("kind",false,s,r)}let n;this._mTemplatesMap=new Map;this._mNamesMap=new Map;this._mInvalidMap=new Map;if(this._bMobileMode){n=this._createListItemMobile}else{n=this._createListItem}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new g({filters:[new g("visible",u.EQ,true),new g("template",u.EQ,true)],and:false})],factory:n.bind(this),sorter:t},e))};E.prototype._getTemplateComboBox=function(e){const t=new g("visible",u.EQ,false);const o=new window.Intl.Collator;const n=function(e,t){return o.compare(e,t)};const i=new _("label",false,false,n);const r=new d({id:this.getId()+"-templateComboBox-"+e,width:"100%",placeholder:this._getPlaceholderTextForTemplate(e),items:{path:this.P13N_MODEL+">/items",template:new s({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[t,new g("kind",u.EQ,e)],sorter:i},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(e,r);return r};E.prototype._getPlaceholderTextForTemplate=function(e){const t=h.getResourceBundleFor("sap.ui.mdc");return t.getText("chart.PERSONALIZATION_DIALOG_TEMPLATE_PLACEHOLDER")};E.prototype._getRoleSelect=function(){return new n({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new s({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(e){if(!e){return false}return e.length>1}}})};E.prototype._getNameComboBox=function(e,t,o){const n=new window.Intl.Collator;const i=function(e,t){return n.compare(e,t)};const r=new _("label",false,false,i);const a=new g({filters:[new g("visible",u.EQ,false),new g("name",u.EQ,o)],and:false});return new d(e+"-combo",{width:"100%",items:{path:this.P13N_MODEL+">/items",factory:function(e,t){return new s({key:t.getObject().name,text:t.getObject().label})},templateShareable:false,filters:[a,new g("kind",u.EQ,t)],sorter:r},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new b({key:"prevName",value:o}),new b({key:"prevKind",value:t})]})};E.prototype._createListItem=function(e,t){let n;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{if(t.getObject().name!=t.getObject().tempName){t.getObject().tempName=t.getObject().name}const o=this._getNameComboBox(e,t.getObject().kind,t.getObject().name);i.push(o);i.push(this._getRoleSelect());n=this.getId()+t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(new m({justifyContent:x.End,items:[new r({id:n,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",tooltip:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY"),customData:[new b({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new b({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));this._mNamesMap.set(t.getObject().name,o)}let s;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;s=new o({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(t=>t.visible===false&&t.template===false&&t.kind===e);return t.length!=0}}})}else{s=new o({cells:i})}s.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return s};E.prototype._createListItemMobile=function(e,t){let n;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{const o=new c({items:[this._getNameComboBox(e,t.getObject().kind,t.getObject().name),this._getRoleSelect()]});n=t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(o)}const s=new m({justifyContent:x.End,items:[new r({id:n,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(e){return!e}},customData:[new b({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new b({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});i.push(s);let a;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;a=new o({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(t=>t.visible===false&&t.template===false&&t.kind===e);return t.length!=0}}})}else{a=new o({cells:i})}a.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return a};E.prototype._keydownHandler=function(t){if((t.metaKey||t.ctrlKey)&&t.keyCode===P.D){let e;const o=p.getElementById(t.currentTarget.id);if(this._bMobileMode){e=o.getCells()[1].getItems()[o.getCells()[1].getItems().length-1]}else{e=o.getCells()[2].getItems()[o.getCells()[2].getItems().length-1]}if(e){this._onPressHide(t,e);t.preventDefault()}}else{e.prototype._keydownHandler.apply(this,arguments)}};E.prototype._handleActivated=function(e){const t=this._getModelItemByTableItem(e);if(t&&t.template){this.removeMoveButtons()}this._oHoveredItem=e;this._updateEnableOfMoveButtons(e,false);this._addMoveButtons(e);this._setMoveButtonVisibility(true)};E.prototype.onChangeOfItemName=function(e){const t=e.getSource().data().prevName;const o=e.getSource().data().prevKind;const n=e.getSource().getSelectedKey();const i=this._getP13nModel().getProperty("/items").find(e=>e.name===t&&e.kind===o);const s=this._getP13nModel().getProperty("/items").find(e=>e.name===n&&e.kind===o);this.removeMoveButtons();if(i&&s){i.visible=false;s.visible=true;i.tempName=i.name;s.role=i.role;this._moveItemsByIndex(this._getItemIndex(s),this._getItemIndex(i),true);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes();this._mInvalidMap.delete(t);this._mInvalidMap.delete(n)}else if(e.getSource()&&e.getSource()instanceof d){this._mInvalidMap.set(e.getSource().data("prevName"),e.getSource().getValue());e.getSource().setValueState(D.Error)}};E.prototype._getItemIndexByNameAndKind=function(e,t){const o=this._getP13nModel().getProperty("/items");const n=o.find(o=>o.name===e&&o.kind===t&&!o.template);return this._getItemIndex(n)};E.prototype._getItemIndex=function(e){return this._getP13nModel().getProperty("/items").indexOf(e)};E.prototype.removeMoveButtons=function(){const e=this._getMoveButtonContainer();if(e){e.removeItem(this._getMoveBottomButton());e.removeItem(this._getMoveDownButton());e.removeItem(this._getMoveUpButton());e.removeItem(this._getMoveTopButton())}};E.prototype.getP13nData=function(){const e=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",e);return e};E.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent()}return undefined};E.prototype._addMoveButtons=function(e){const t=e;if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(t.getCells&&t.getCells()&&(t.getCells().length===2||t.getCells().length===3)&&!o){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0)}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0)}}};E.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();e.prototype._moveSelectedItem.apply(this,arguments)};E.prototype._updateAvailableRolesForItems=function(){const e=this._getP13nModel().getProperty("/items");let t=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){t=this.getPanelConfig().allowedLayoutOptions}else{f.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!")}e.forEach(e=>{if(!e.availableRoles){return}e.availableRoles=e.availableRoles.filter(e=>t.indexOf(e.key)!=-1)});this._getP13nModel().setProperty("/items",e);this._refreshP13nModel()};E.prototype._onPressHide=function(e,t){let o;if(t){o=t.data().propertyName}else{o=e.getSource().data().propertyName}const n=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);n.filter(e=>e.name===o).forEach(e=>{e.visible=false;if(this._mTemplatesMap.has(e.kind)&&this._mTemplatesMap.get(e.kind).getVisible()){this._mTemplatesMap.get(e.kind).focus()}});this._announce(this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY_ANNOUNCE"));this._getP13nModel().setProperty("/items",n);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes()};E.prototype._announce=function(e){const{InvisibleMessageMode:t}=v;const o=B.getInstance();o.announce(e,t.Assertive)};E.prototype.setP13nData=function(t){t=t.filter(e=>!e.template);e.prototype.setP13nData.apply(this,arguments);let o=[];const n=[];this.getP13nData().forEach((e,t)=>{if(!e.availableRoles){e.availableRoles=O.getLayoutOptionsForType(e.kind)}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){const t=this.getPanelConfig().allowedLayoutOptions;if(t?.length>=1){e.availableRoles=e.availableRoles.filter(e=>t.indexOf(e.key)!=-1);if(t.indexOf(e.role)===-1){e.role=t[0]}}}e.template=false;e.tempName=e.name;if(!e.visible){n.push(e)}if(!e.index){e.index=t}o.push(e)});o=o.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",o);this._updateVisibleIndexes()};E.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map;this._getP13nModel().getProperty("/items").forEach((e,t)=>{if(e.template||!e.visible){return}if(this._mVisibleIndexes.has(e.kind)){this._mVisibleIndexes.get(e.kind).push(t)}else{const o=[t];this._mVisibleIndexes.set(e.kind,o)}})};E.prototype.onChangeOfTemplateName=function(e){const t=e.getSource().getSelectedKey();const o=this._getCleanP13nItems().find(e=>e.name===t);if(o){o.visible=true;e.getSource().setSelectedKey(undefined);this._refreshP13nModel();const t=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];const n=this._getItemIndexByNameAndKind(o.name,o.kind);let i=t[t.length-1];if(n>i){i+=1}if(i&&n!=i){this._moveItemsByIndex(n,i,true)}else{this._fireChangeItems()}this._mInvalidMap.delete(e.getSource().getValue());this._updateVisibleIndexes()}else if(e.getSource()&&e.getSource()instanceof d){if(e.getSource().getValue()!=""){e.getSource().setValueState(D.Error)}else{e.getSource().setValueState(D.None)}}};E.prototype._refreshP13nModel=function(){this._getP13nModel().refresh(true)};E.prototype._getTemplateItems=function(){const e=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[]}this.getPanelConfig().templateConfig.forEach(t=>{const o={template:true,kind:t.kind};e.push(o)});return e};E.prototype._getListControlConfig=function(){const t=e.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){t.columns=[new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})}),new a]}else{const e=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});const o=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})});t.columns=[e,o,new a]}t.mode="None";return t};E.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(e=>!e.template)};E.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(e=>({columnKey:e.name,visible:e.visible,index:e.index,role:e.role}))});this.fireChange()};E.prototype.onChangeOfRole=function(e){const t=e.getParameter("selectedItem");if(t){let t;if(this._bMobileMode){t=e.getSource().getParent().getParent()}else{t=e.getSource().getParent()}this.fireChange();this._updateEnableOfMoveButtons(t)}this._fireChangeItems()};E.prototype._updateEnableOfMoveButtons=function(e,t){if(!e){return}const o=this._getModelItemByTableItem(e);const n=this._getP13nModel().getProperty("/items").indexOf(o);let i=true,s=true;if(!o||o.template){return}const r=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];if(n==0||r.indexOf(n)===0){i=false}if(r.indexOf(n)===r.length-1){s=false}this._getMoveTopButton().setEnabled(i);this._getMoveUpButton().setEnabled(i);this._getMoveDownButton().setEnabled(s);this._getMoveBottomButton().setEnabled(s);if(t&&(!s||!i)){this._oFocusInfo={oMoveButton:!s?this._getMoveUpButton():this._getMoveDownButton()}}};E.prototype._getListItemFromMoveButton=function(e){if(e&&e.getParent()&&e.getParent().getParent()){return e.getParent().getParent()}return undefined};E.prototype._onPressButtonMoveToTop=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind)[0];this._oSelectedItem=t;this._moveSelectedItem(n)};E.prototype._onPressButtonMoveUp=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind);const i=this._getP13nModel().getProperty("/items").indexOf(o);this._oSelectedItem=t;const s=n[n.indexOf(i)-1];this._moveSelectedItem(s)};E.prototype._onPressButtonMoveDown=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind);const i=this._getP13nModel().getProperty("/items").indexOf(o);this._oSelectedItem=t;const s=n[n.indexOf(i)+1];this._moveSelectedItem(s)};E.prototype._onPressButtonMoveToBottom=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind)[this._mVisibleIndexes.get(o.kind).length-1];this._oSelectedItem=t;this._moveSelectedItem(n)};E.prototype._moveTableItem=function(e,t){const o=this._getP13nModel().getProperty("/items");const n=o.indexOf(e.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(n,t)};E.prototype._moveItemsByIndex=function(e,t,o){const n=this._getP13nModel().getProperty("/items");t=t<=0?0:Math.min(t,n.length-1);if(t==e){return}n.splice(t,0,n.splice(e,1)[0]);n.forEach((e,t)=>{if(!e.template){e.index=t}});this._getP13nModel().setProperty("/items",n);if(!o){this._oSelectedItem=this._oListControl.getItems().find(e=>{const o=this._getModelItemByTableItem(e);return o&&o===n[t]});this._updateEnableOfMoveButtons(this._oSelectedItem,!o);this._handleActivated(this._oSelectedItem)}this._fireChangeItems()};E.prototype._getModelItemByTableItem=function(e){return this._getP13nModel().getProperty(e.getBindingContextPath())};E.prototype._getMoveConfigForTableItem=function(e){const t=this._getModelItemByTableItem(e);if(!t){return undefined}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(t),aggregationRole:t.kind,template:t.template}};E.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){const t=e.prototype._getDragDropConfig.apply(this,arguments);t.attachDragStart(this._checkDragStart.bind(this));t.attachDragEnter(this._checkDrag.bind(this));t.attachDragEnd(()=>{this._oDraggedItem=null});return t}return this._oDragDropInfo};E.prototype._checkDrag=function(e){const t=e.getParameter("target");const o=this._getMoveConfigForTableItem(t);const n=this._getMoveConfigForTableItem(this._oDraggedItem);if(!o||o.template||n.aggregationRole!=o.aggregationRole){e.preventDefault();return}};E.prototype._checkDragStart=function(e){this._oDraggedItem=e.getParameter("target");this._checkDrag(e)};E.prototype._onRearrange=function(e){const t=e.getParameter("draggedControl");const o=e.getParameter("droppedControl");const n=e.getParameter("dropPosition");const i=this._getMoveConfigForTableItem(t);const s=this._getMoveConfigForTableItem(o);if(!i||i.template||!s){e.preventDefault();return}const r=i.currentIndex;let a=s.currentIndex;if(s.template&&n=="After"){e.preventDefault();return}if(!s.template&&(i.aggregationRole!=undefined&&i.aggregationRole!=s.aggregationRole)){e.preventDefault();return}if(r<a){if(n=="Before"&&a!=0){a-=1}}else if(n=="After"){a+=1}this._moveItemsByIndex(r,a);this._refreshP13nModel();this._updateVisibleIndexes()};E.prototype._getMoveTopButton=function(){if(this._oMoveTopButton&&this._oMoveTopButton.isDestroyed()){this._oMoveTopButton=null}return e.prototype._getMoveTopButton.apply(this,arguments)};E.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null}return e.prototype._getMoveUpButton.apply(this,arguments)};E.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null}return e.prototype._getMoveDownButton.apply(this,arguments)};E.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null}return e.prototype._getMoveBottomButton.apply(this,arguments)};E.prototype._getResourceTextMDC=function(e,t){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:h.getResourceBundleFor("sap.ui.mdc");return e?this.oResourceBundleMDC.getText(e,t):this.oResourceBundleMDC};E.prototype.exit=function(){this._fnSort=null;this.oResourceBundleMDC=null;this._bMobileMode=null;return e.prototype.exit.apply(this,arguments)};E.prototype.onReset=function(){};return E});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/FilterPanel", ["sap/m/p13n/FilterPanel"],e=>{"use strict";return e.extend("sap.ui.mdc.p13n.panels.FilterPanel",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/GroupView", ["sap/m/p13n/BasePanel","sap/m/Label","sap/base/util/deepEqual","sap/m/CustomListItem","sap/m/List","sap/m/Panel","sap/m/Toolbar","sap/m/Text","sap/ui/core/Element","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/core/library","sap/m/HBox","sap/m/library","sap/base/util/merge","sap/m/Title"],(t,e,i,o,n,s,r,a,l,c,p,h,d,g,u,_)=>{"use strict";const{IconColor:f}=h;const{FlexJustifyContent:m}=g;const{ListKeyboardMode:C}=g;const y=t.extend("sap.ui.mdc.p13n.panels.GroupView",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"}}},renderer:{apiVersion:2}});y.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCGroupView");const e=new o({visible:"{"+this.P13N_MODEL+">groupVisible}",accDescription:{path:this.P13N_MODEL+">groupLabel",formatter:function(t){return p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.FILTER_GROUP_DESCRIPTION",[t])}},content:[this._createGroupPanelTemplate()]});this._bShowFactory=true;this.displayColumns();this._aInitializedLists=[];this._setTemplate(e);e.setType("Inactive");this._setMoveButtonVisibility(true)};y.prototype._getShowFactory=function(){return this._bShowFactory};y.prototype.getPanels=function(){const t=[];this._oListControl.getItems().forEach(e=>{t.push(e.getContent()[0])});return t};y.prototype._createGroupPanelTemplate=function(){const{P13N_MODEL:t}=this;return new s({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(t)){const e=this.getBindingContext(t).sPath.split("/")[2]==="0";return e}else{return false}}},expand:function(t){const e=t.getSource();const i=e.getContent()[0];this._addInitializedList(i);if(this._getShowFactory()){this._addFactoryControl(i);this.filterContent(this._aCurrentFilters)}}.bind(this),width:"100%",headerToolbar:[new r({content:[new _({wrapping:true,text:"{"+this.P13N_MODEL+">groupLabel}"})]})],content:[this._createGroupListTemplate()]})};y.prototype._createGroupListTemplate=function(){const t=new n({keyboardMode:C.Edit,selectionChange:function(t){const{sPath:e}=t.getParameter("listItem").getBindingContext(this.P13N_MODEL);const i=this._getP13nModel().getProperty(e);const o=this.getModel(this.P13N_MODEL);if(o&&i){o.setProperty(e+"/selected",i.visible)}const n=this._checkSpecialChangeReason(t.getParameter("selectAll"),t.getParameter("listItems"));this.fireChange({reason:n||(i.visible?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE),item:i})}.bind(this),showSeparators:"None",mode:"MultiSelect"});t.bindItems(this._getItemsBinding());return t};y.prototype._addFactoryControl=function(t){if(t.getItems().length==0||t.getItems()[0].getContent().length<2){t.getItems().forEach(t=>{const e=t.getBindingContext(this.P13N_MODEL);const i=this.getItemFactory().call(this,e);if(i){t.addContent(i);const e=t.getContent()[0].getItems()[0];e.setLabelFor(i)}if(t.getContent()[0].getItems().length>1){t.getContent()[0].removeItem(1)}})}this.addStyleClass("sapUiMDCAFLabelMarking")};y.prototype._createInnerListControl=function(){const t=new n(this.getId()+"-innerGroupViewList",Object.assign(this._getListControlConfig(),{keyboardMode:C.Edit,mode:"None",infoToolbar:new r,updateStarted:function(t){this._checkAllPanels()}.bind(this)}));return t};y.prototype._getItemsBinding=function(){const t=function(){const t=[new d({width:"100%",justifyContent:m.SpaceBetween,items:[new e({required:"{"+this.P13N_MODEL+">required}",text:"{"+this.P13N_MODEL+">label}"})]})];return new o({selected:"{"+this.P13N_MODEL+">visible}",tooltip:"{"+this.P13N_MODEL+">tooltip}",accDescription:"{"+this.P13N_MODEL+">label}",content:t})}.bind(this);return{path:this.P13N_MODEL+">items",templateShareable:false,template:t()}};y.prototype._getIconTemplate=function(){return new d({width:"18.5%",justifyContent:m.Center,items:[new c({src:"sap-icon://circle-task-2",size:"0.5rem",color:f.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(t){if(t){return true}else{return false}}}})]})};y.prototype._loopGroupList=function(t){this._oListControl.getItems().forEach(e=>{const i=e.getContent()[0];const o=i.getContent()[0];this._loopItems(o,(e,i)=>{t(e,i)})})};y.prototype._loopItems=function(t,e){t.getItems().forEach(t=>{const i=t.getBindingContextPath();const o=this._getP13nModel().getProperty(i).name;e.call(this,t,o)})};y.prototype._removeFactoryControl=function(){this._loopGroupList((t,e)=>{if(t.getContent()[1]){t.removeContent(t.getContent()[1]);const e=t.getParent();this._addInitializedList(e);const i=this._getIconTemplate();t.getContent()[0].addItem(i)}});this.removeStyleClass("sapUiMDCAFLabelMarking");return this._aInitializedLists||[]};y.prototype._addInitializedList=function(t){const e=t.getId();if(this._aInitializedLists.indexOf(e)<0){this._aInitializedLists.push(e)}};y.prototype._getInitializedLists=function(){const t=[];this._aInitializedLists.forEach(e=>{const i=l.getElementById(e);if(i){t.push(i)}});return t};y.prototype.getSelectedFields=function(){const t=[];this._oListControl.getItems().forEach(e=>{const i=e.getContent()[0];const o=i.getContent()[0];this._loopItems(o,(e,i)=>{if(e.getSelected()){t.push(i)}})});return t};y.prototype.filterContent=function(t){if(!this._bInitialized||i(t,this._aCurrentFilters)){return}const e=this._removeFactoryControl();this._oListControl.getItems().forEach(i=>{const o=i.getContent()[0];const n=o.getContent()[0];if(n.getBinding("items")){n.getBinding("items").filter(t,true);this._togglePanelVisibility(o)}if(this._getShowFactory()&&e.indexOf(n.getId())>-1){this._addFactoryControl(n)}});this._aCurrentFilters=t};y.prototype.showFactory=function(t){this._bShowFactory=t;this.displayColumns();if(t){this._getInitializedLists().forEach(t=>{this._addFactoryControl(t)})}else{this._removeFactoryControl()}};y.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(t=>{const e=t.getContent()[0];this._togglePanelVisibility(e)})};y.prototype.setGroupExpanded=function(t,e){this._oListControl.getItems().forEach(function(i){const o=i.getContent()[0];const n=o.getBindingContext(this.P13N_MODEL).sPath;const s=this._getP13nModel().getProperty(n);if(s.group===t){o.setExpanded(e)}},this)};y.prototype._togglePanelVisibility=function(t){const e=t.getContent()[0];const i=t.getBindingContext(this.P13N_MODEL);if(i){const t=i.sPath;const o=this._getP13nModel().getProperty(t);o.groupVisible=e.getVisibleItems().length<1?false:true;this._getP13nModel().setProperty(t,o)}};y.prototype.getItems=function(){return this._oListControl.getItems()};y.prototype._checkFirstGroup=function(){if(!this._bInitialized&&this._oListControl&&this._oListControl.getItems().length>0){this._bInitialized=true;const t=this._oListControl.getItems()[0].getContent()[0].getContent()[0];this._addFactoryControl(t);this._addInitializedList(t)}};y.prototype.displayColumns=function(){const t=this._oListControl.getInfoToolbar().removeAllContent();t.forEach(t=>{t.destroy()});this._oListControl.getInfoToolbar().addContent(new a({width:"75%",text:p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_COLUMN")}).addStyleClass("firstColumnPadding"));if(!this._bShowFactory){this._oListControl.getInfoToolbar().addContent(new a({textAlign:"Center",width:"25%",text:p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_ACTIVE")}).addStyleClass("firstColumnPadding"))}};y.prototype.setP13nData=function(t){this._getP13nModel().setProperty("/itemsGrouped",t);if(!this._bInitialized){this._bindListItems()}this._checkFirstGroup();this._checkAllPanels()};y.prototype.getP13nData=function(t){let e=this._getP13nModel().getProperty("/itemsGrouped");if(t){e=e.filter(t=>t[this.PRESENCE_ATTRIBUTE])}return e};y.prototype._bindListItems=function(){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/itemsGrouped",templateShareable:false,key:"group",template:this.getAggregation("_template").clone()}))};y.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._aInitializedLists=null;this._bShowFactory=false;this._bInitialized=false};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/panels/LinkSelectionPanel", ["sap/m/p13n/SelectionPanel","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/m/Link","sap/m/Text","sap/ui/core/Icon","sap/m/library","sap/m/OverflowToolbar","sap/ui/model/Filter","sap/ui/core/CustomData"],(t,e,i,s,n,o,r,a,p,l,c)=>{"use strict";const{ListType:u}=a;const{MultiSelectMode:d}=a;const h=t.extend("sap.ui.mdc.p13n.panels.LinkSelectionPanel",{metadata:{properties:{multiSelectMode:{type:"sap.m.MultiSelectMode",defaultValue:d.Default},linkPressed:{type:"object"}},library:"sap.ui.mdc"},renderer:{apiVersion:2}});h.prototype._getListTemplate=function(){const t=new n({tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">text}",href:"{"+this.P13N_MODEL+">href}",target:"{"+this.P13N_MODEL+">target}",customData:new c({key:"internalHref",value:"{"+this.P13N_MODEL+">internalHref}"}),wrapping:true});const r=this.getLinkPressed();if(r){t.attachPress(r)}return new e({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:u.Active,cells:[new i({items:[new s({items:[t,new o({text:"{"+this.P13N_MODEL+">description}",visible:"{= ${"+this.P13N_MODEL+">description} ? true:false}"})]})]})]})};h.prototype.setShowHeader=function(t){if(t){this._oListControl.setHeaderToolbar(new p({content:[this._getSearchField()]}))}this.setProperty("showHeader",t);return this};h.prototype._getSearchField=function(){const e=t.prototype._getSearchField.apply(this,arguments);e.getLayoutData().setMaxWidth(undefined);return e};h.prototype._filterList=function(t,e){let i=[],s=[];if(t){s=new l(this.PRESENCE_ATTRIBUTE,"EQ",true)}if(e){i=new l("text","Contains",e)}this._oListControl.getBinding("items").filter(new l([].concat(s,i),true))};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ActionToolbarController", ["./SelectionController","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/p13n/panels/ActionToolbarPanel","sap/m/Column","sap/ui/mdc/p13n/P13nBuilder"],(t,e,n,o,i,a)=>{"use strict";const r=n.getResourceBundleFor("sap.ui.mdc");const s=t.extend("saps.ui.mdc.p13n.subcontroller.ActionToolbarController");s.prototype.initAdaptationUI=function(t){const e=new o({title:r.getText("actiontoolbar.RTA_TITLE"),showHeader:true});e.setFieldColumn(r.getText("actiontoolbar.RTA_COLUMN_HEADER"));const n=this.mixInfoAndState(t);e.setP13nData(n.items);this._oPanel=e;return Promise.resolve(e)};s.prototype.getDelta=function(n){const o=t.prototype.getDelta.apply(this,arguments);o.forEach(t=>{const n=t.changeSpecificData.changeType;if(n==="hideControl"||n==="unhideControl"){t.selectorElement=e.getElementById(t.changeSpecificData.content.name);delete t.changeSpecificData.content}});return o};s.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=this.arrayToMap(e);const o=this.prepareAdaptationData(t,(t,e)=>{const o=n[e.name];t.visible=!!o;t.position=o?o.position:-1;t.alignment=e.alignment;t.enabled=!!e.enabled;return e.visible});this.sortP13nData({visible:"visible",position:"position"},o.items);o.items.forEach(t=>{delete t.position});return o};s.prototype.getChangeOperations=function(){return{add:"unhideControl",remove:"hideControl",move:"moveAction"}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/AdaptFiltersController", ["./SelectionController","sap/ui/core/Lib","sap/ui/mdc/p13n/P13nBuilder","sap/base/util/merge"],(t,e,n,o)=>{"use strict";const i=t.extend("sap.ui.mdc.p13n.subcontroller.AdaptFiltersController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});i.prototype.getUISettings=function(){return{verticalScrolling:false,title:e.getResourceBundleFor("sap.ui.mdc").getText("filterbar.ADAPT_TITLE"),afterClose:function(t){const e=t.getSource();if(e){e.getContent()[0].executeRemoves();e.removeAllContent();e.destroy()}}}};i.prototype.getBeforeApply=function(){const t=this.getAdaptationControl().getInbuiltFilter();const e=t?t.createConditionChanges():Promise.resolve([]);return e};i.prototype.getFilterControl=function(){return this.getAdaptationControl()};i.prototype.getChangeOperations=function(){return{add:"addFilter",remove:"removeFilter",move:"moveFilter",additional:["addCondition","removeCondition"]}};i.prototype.initAdaptationUI=function(t){return this.getAdaptationControl().retrieveInbuiltFilter().then(n=>{const o=this.mixInfoAndState(t);n.getTitle=function(){return e.getResourceBundleFor("sap.ui.mdc").getText("filterbar.ADAPT_TITLE")};this._oPanel=n;n.setP13nData(o);n.setLiveMode(false);return n.createFilterFields().then(()=>n)})};i.prototype.getP13nData=function(){return this._oPanel.getP13nData().items};i.prototype.update=function(t){if(this._oPanel){const e=this.mixInfoAndState(t);this._oPanel.setP13nData(e);this.getAdaptationControl().getInbuiltFilter().createFilterFields()}};i.prototype.mixInfoAndState=function(t){const e=this.getAdaptationControl().getCurrentState().filter||{};const o=this.getCurrentState();const i=n.arrayToMap(o);const r=this.prepareAdaptationData(t,(t,n)=>{const o=i[n.name];const r=e[n.name];t.visible=o?true:false;t.visibleInDialog=true;t.position=o?o.position:-1;t.isFiltered=r&&r.length>0?true:false;t.required=n.required;return!(n.hiddenFilter===true||n.name=="$search")},true);this.sortP13nData({visible:"visible",position:"position"},r.items);return r};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/AggregateController", ["./SelectionController","sap/ui/mdc/p13n/P13nBuilder","sap/base/util/merge"],(t,e,n)=>{"use strict";const r=t.extend("sap.ui.mdc.p13n.subcontroller.AggregateController");r.prototype.getStateKey=function(){return"aggregations"};r.prototype.getCurrentState=function(){return this.getAdaptationControl().getAggregateConditions()||{}};r.prototype.sanityCheck=function(t){const e=[];Object.keys({...t}).forEach(n=>{const r={name:n,key:n};if(t[n].hasOwnProperty("aggregated")){r["aggregated"]=t[n].aggregated}e.push(r)});return e};r.prototype.getDelta=function(e){e.existingState=this.sanityCheck(e.existingState);return t.prototype.getDelta.apply(this,arguments)};r.prototype.initAdaptationUI=function(t){return null};r.prototype.getChangeOperations=function(){return{add:"addAggregate",remove:"removeAggregate"}};r.prototype._getPresenceAttribute=function(){return"aggregated"};r.prototype.changesToState=function(t){const e={};t.forEach(t=>{const n=t.changeSpecificData.content.name;if(!e[n]){e[n]=[]}const r={};if(t.changeSpecificData.changeType===this.getChangeOperations()["remove"]){r.aggregated=false}e[n]=r});return e};r.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=this.prepareAdaptationData(t,(t,n)=>{const r=e[n.name];t.aggregated=!!r;return n.aggregatable});return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ChartItemController", ["./SelectionController","sap/ui/core/Lib","sap/ui/mdc/enums/ChartItemRoleType"],(t,e,o)=>{"use strict";const i=e.getResourceBundleFor("sap.ui.mdc");const n=t.extend("sap.ui.mdc.p13n.subcontroller.ChartItemController");n.prototype.initAdaptationUI=function(t){return this.getAdaptationControl().getAdaptationUI().then(e=>{this._oPanel=e;e.setTitle(i.getText("p13nDialog.TAB_Chart"));const o=this.mixInfoAndState(t);e.setP13nData(o.items);return e})};n.prototype.update=function(e){t.prototype.update.apply(this,arguments)};n.prototype.getDelta=function(e){e.deltaAttributes.push("role");return t.prototype.getDelta.apply(this,arguments)};n.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const o=this.arrayToMap(e);const i=this.prepareAdaptationData(t,(t,e)=>{const i=o[e.name];t.visible=!!i;t.position=i?i.position:-1;t.role=i?i.role:e.role;if(e.groupable){t.kind="Groupable"}else if(e.aggregatable){t.kind="Aggregatable"}return e.visible});this.sortP13nData({visible:"visible",position:"position"},i.items);i.items.forEach(t=>{delete t.position});return i};n.prototype.getChangeOperations=function(){return{add:"addItem",remove:"removeItem",move:"moveItem"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ChartTypeController", ["./SelectionController"],t=>{"use strict";const e=t.extend("sap.ui.mdc.p13n.subcontroller.ChartTypeController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});e.prototype.getCurrentState=function(){return{properties:{chartType:this.getAdaptationControl().getChartType()}}};e.prototype.getStateKey=function(){return"supplementaryConfig"};e.prototype.getDelta=function(t){let e;if(t.changedState&&t.changedState.properties){e=t.changedState.properties.chartType}const r=this.getAdaptationControl().getChartType();let n=[];if(e&&e!==r){n=[{selectorElement:t.control,changeSpecificData:{changeType:"setChartType",content:{chartType:e}}}]}return n};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ColumnController", ["./SelectionController","sap/m/p13n/SelectionPanel","sap/ui/core/Lib","sap/m/library"],(e,t,n,o)=>{"use strict";const{MultiSelectMode:r}=o;const l=n.getResourceBundleFor("sap.ui.mdc");const i=e.extend("sap.ui.mdc.p13n.subcontroller.ColumnController");i.prototype.getUISettings=function(){return{title:l.getText("table.SETTINGS_COLUMN"),tabText:l.getText("p13nDialog.TAB_Column")}};i.prototype.model2State=function(){const e=[];this._oPanel.getP13nData(true).forEach(t=>{if(t.visible){e.push({name:t.name})}});return e};i.prototype.createUI=function(e){const n=new t({showHeader:true,enableCount:true,title:l.getText("fieldsui.COLUMNS"),fieldColumn:l.getText("fieldsui.COLUMNS"),multiSelectMode:r.SelectAll});n.setEnableReorder(this._bReorderingEnabled);return n.setP13nData(e.items)};i.prototype.getChangeOperations=function(){return{add:"addColumn",remove:"removeColumn",move:"moveColumn"}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ColumnFreezeController", ["sap/m/p13n/SelectionController","sap/ui/mdc/enums/TableType","sap/m/p13n/modules/xConfigAPI","sap/base/util/merge"],(t,e,n,o)=>{"use strict";const r=t.extend("sap.ui.mdc.p13n.subcontroller.ColumnFreezeController",{constructor:function(n){t.apply(this,arguments);if(!n.control._isOfType(e.Table,true)){throw new Error("ColumnFreezeController is only applicable to GridTable")}}});r.prototype.getStateKey=function(){return"supplementaryConfig"};r.prototype.getChangeOperations=function(){return{set:"setFixedColumnCount"}};r.prototype.getCurrentState=function(){const t=this.getAdaptationControl().getCurrentState().xConfig;if(t.aggregations?.type?.GridTable){return{aggregations:{type:{GridTable:{fixedColumnCount:t.aggregations.type.GridTable.fixedColumnCount}}}}}return{}};r.prototype.formatToInternalState=function(t){if(t?.aggregations?.type?.GridTable){return{aggregations:{type:t.aggregations.type}}}return{}};r.prototype.changesToState=function(t){let e={};const r=t.length&&t[0].selectorElement;t.forEach(t=>{const a=o({},t.changeSpecificData.content);const i={name:a.name,controlMeta:{aggregation:"type"},property:"fixedColumnCount",value:a.value};e=n.createAggregationConfig(r,i,e)});return e};r.prototype.sanityCheck=function(t){const e=[];if(t?.aggregations?.type?.GridTable){e.push({name:"GridTable",fixedColumnCount:t.aggregations.type.GridTable.fixedColumnCount})}return e};r.prototype.getDelta=function(t){t.changedState=t.changedState instanceof Array?t.changedState:this.sanityCheck(t.changedState);t.deltaAttribute="fixedColumnCount";t.operation="setFixedColumnCount";t.existingState=this.sanityCheck(t.existingState);return this.getPropertySetterChanges(t)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/FilterController", ["sap/m/p13n/FilterController","sap/ui/core/Lib","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual"],(t,e,n,o,i,r)=>{"use strict";const a=t.extend("sap.ui.mdc.p13n.subcontroller.FilterController");a.prototype.getStateKey=function(){return"filter"};a.prototype.getUISettings=function(){return{title:e.getResourceBundleFor("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE"),tabText:e.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.TAB_Filter"),afterClose:function(t){const e=t.getSource();if(e){const t=e.getContent()[0];if(t.isA("sap.m.p13n.Container")){t.removeView("Filter")}else{e.removeAllContent()}}e.destroy()}}};a.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState()[this.getStateKey()]};a.prototype.getSelectorForReset=function(){const t=this.getAdaptationControl(),e=t.getInbuiltFilter();let n=[t];if(e){n=n.concat(e)}return n};a.prototype.getBeforeApply=function(){const t=this.getAdaptationControl().getInbuiltFilter();const e=t?t.createConditionChanges():Promise.resolve([]);return e};a.prototype.getFilterControl=function(){return this.getAdaptationControl().isA("sap.ui.mdc.IFilter")?this.getAdaptationControl():this.getAdaptationControl()._oP13nFilter};a.prototype.sanityCheck=function(t){a.checkConditionOperatorSanity(t);return t};a.prototype._indexOfCondition=function(t,e){return o.indexOfCondition(t,e)};a.checkConditionOperatorSanity=function(t){for(const e in t){const n=t[e];for(let r=0;r<n.length;r++){const a=n[r];const s=a.operator;if(!o.getOperator(s)){n.splice(r,1);if(t[e].length==0){delete t[e]}i.warning("The provided conditions for field '"+e+"' contain unsupported operators - these conditions will be neglected.")}}}};a.prototype.initAdaptationUI=function(t,n){const o=this.mixInfoAndState(t);return this.getAdaptationControl().retrieveInbuiltFilter().then(t=>{t.setP13nData(o);t.setLiveMode(false);t.setProperty("_useFixedWidth",false);t.getTitle=function(){return e.getResourceBundleFor("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE")};this._oAdaptationFB=t;return t.createFilterFields().then(()=>{this._oPanel=t;return t})})};a.prototype.update=function(t){if(this._oPanel){const e=this.mixInfoAndState(t);this._oPanel.setP13nData(e);const n=this.getAdaptationControl();const o=n&&n.getInbuiltFilter();if(o){o.createFilterFields()}}};a.prototype.getDelta=function(t){if(t.applyAbsolute===n.FullReplace){Object.keys(t.existingState).forEach(function(e){if(!t.changedState.hasOwnProperty(e)){t.changedState[e]=[]}})}return this.getConditionDeltaChanges(t)};a.prototype._createConditionChangeContent=function(t,e){return{name:t,condition:e}};a.prototype.model2State=function(){const t={},e=this.getCurrentState();this.getP13nData().items.forEach(n=>{if(n.active&&Object.keys(e).includes(n.name)){t[n.name]=e[n.name]}});return t};a.prototype.mixInfoAndState=function(t){const e=this.getCurrentState()||{};const n=this.prepareAdaptationData(t,(t,n)=>{const o=e[t.name];t.active=o&&o.length>0?true:false;return!(n.filterable===false)});this.sortP13nData({visible:"active",position:undefined},n.items);return n};a.prototype.changesToState=function(t,e,n){const o={};t.forEach(t=>{const e=r({},t.changeSpecificData.content);const n=e.name;if(!o[n]){o[n]=[]}if(t.changeSpecificData.changeType===this.getChangeOperations()["remove"]){e.condition.filtered=false}o[n].push(e.condition)});return o};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/GroupController", ["./SelectionController","sap/ui/core/Lib","sap/ui/mdc/p13n/P13nBuilder","sap/m/p13n/GroupPanel"],(t,e,o,n)=>{"use strict";const r=t.extend("sap.ui.mdc.p13n.subcontroller.GroupController");r.prototype.getStateKey=function(){return"groupLevels"};r.prototype.getUISettings=function(){return{tabText:e.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.TAB_Group"),title:e.getResourceBundleFor("sap.ui.mdc").getText("group.PERSONALIZATION_DIALOG_TITLE")}};r.prototype.getDelta=function(e){return t.prototype.getDelta.apply(this,arguments)};r.prototype.initAdaptationUI=function(t){const e=new n;const o=this.mixInfoAndState(t);const r=this.getAdaptationControl();if(r.isA("sap.ui.mdc.Table")&&r._isOfType("ResponsiveTable")){e.setQueryLimit(1)}e.setP13nData(o.items);this._oPanel=e;return Promise.resolve(e)};r.prototype.model2State=function(){const t=[];this._oPanel.getP13nData(true).forEach(e=>{if(e.grouped){t.push({name:e.name})}});return t};r.prototype.getChangeOperations=function(){return{add:"addGroup",remove:"removeGroup",move:"moveGroup"}};r.prototype._getPresenceAttribute=function(){return"grouped"};r.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=o.arrayToMap(e);const r=this.getAdaptationControl();const i=r.getAggregateConditions?r.getAggregateConditions()||{}:{};const p=this.prepareAdaptationData(t,(t,e)=>{const o=n[e.name];t.grouped=!!o;t.position=o?o.position:-1;return!(e.groupable===false||i[e.name])});o.sortP13nData({visible:"grouped",position:"position"},p.items);p.presenceAttribute=this._getPresenceAttribute();p.items.forEach(t=>{delete t.position});return p};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/LinkPanelController", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/p13n/P13nBuilder","./SelectionController","sap/ui/mdc/p13n/panels/LinkSelectionPanel","sap/m/MessageBox"],(e,t,n,o,r,i)=>{"use strict";const a=t.getResourceBundleFor("sap.ui.mdc");const s=o.extend("sap.ui.mdc.p13n.subcontroller.LinkPanelController",{constructor:function(){o.apply(this,arguments);this._bResetEnabled=true}});s.prototype.getUISettings=function(){return{contentWidth:"28rem",contentHeight:"35rem",reset:{warningText:a.getText("info.SELECTION_DIALOG_RESET_WARNING")},title:a.getText("info.SELECTION_DIALOG_ALIGNEDTITLE")}};s.prototype.getSelectorForReset=function(){return this.getAdaptationControl().getItems().concat(this.getAdaptationControl())};s.prototype.getSelectorsForHasChanges=function(){return this.getAdaptationControl().getItems()};s.prototype.initAdaptationUI=function(e){const t=this.getAdaptationControl();const n=new r({title:a.getText("info.SELECTION_DIALOG_ALIGNEDTITLE"),showHeader:true,fieldColumn:a.getText("info.SELECTION_DIALOG_COLUMNHEADER_WITHOUT_COUNT"),enableCount:true,enableReorder:false,linkPressed:t.onPressLink.bind(t)});const o=this.mixInfoAndState(e);n.setP13nData(o.items);this._oPanel=n;return Promise.resolve(n)};s.prototype._navigate=function(e){this.getAdaptationControl().getMetadata()._oClass.navigate(e)};s.prototype._createAddRemoveChanges=function(e,t,n,o){const r=[];for(let i=0;i<e.length;i++){if(Array.isArray(n)){n.forEach(n=>{r.push(this._createAddRemoveChange(t,n,this._getChangeContent(e[i],o)))})}else{r.push(this._createAddRemoveChange(t,n,this._getChangeContent(e[i],o)))}}return r.filter(e=>e!==undefined)};s.prototype._createAddRemoveChange=function(t,n,o){const r=o.name;const i=e.getElementById(r);if(n==="revealItem"||n==="hideItem"){return{selectorElement:i?i:r,changeSpecificData:{changeType:n,content:{}}}}if(!i){return{selectorElement:t,changeSpecificData:{changeType:"createItem",content:{selector:r}}}}return undefined};s.prototype.mixInfoAndState=function(e){const t=this.getCurrentState();const o=n.arrayToMap(t);const r=this.prepareAdaptationData(e,(e,t)=>{const n=o[t.name];e.visible=n?true:false;e.position=n?n.position:-1;e.href=t.href;e.internalHref=t.internalHref;e.description=t.description;e.target=t.target;e.text=t.text;return true});this.sortP13nData({visible:"visible",position:"position"},r.items);r.presenceAttribute=this._getPresenceAttribute();r.items.forEach(e=>{delete e.position});return r};s.prototype._createMoveChange=function(e,t,n,o){return{selectorElement:o,changeSpecificData:{changeType:n,content:{index:t,name:e}}}};s.prototype.getChangeOperations=function(){return{add:["createItem","revealItem"],remove:"hideItem",move:"moveItem"}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/SelectionController", ["sap/m/p13n/SelectionController","sap/base/util/merge"],(e,t)=>{"use strict";const n=e.extend("sap.ui.mdc.p13n.subcontroller.SelectionController");n.prototype._createAddRemoveChange=function(e,t,n){delete n.key;const a={selectorElement:e,changeSpecificData:{changeType:t,content:n}};return a};n.prototype.getCurrentState=function(e){let t=this.getAdaptationControl().getCurrentState()[this.getStateKey()];if(t instanceof Array&&!e){t=t.map(e=>{e.key=e.name;return e})}return t};n.prototype.getDelta=function(n){if(n.changedState instanceof Array){const e=t([],n.changedState);e.map(e=>{if(e.hasOwnProperty("name")&&!e.hasOwnProperty("key")){e.key=e.name}return e});n.changedState=e}if(n.existingState instanceof Array){const e=t([],n.existingState);e.map(e=>{e.key=e.name;return e});n.existingState=e}n.deltaAttributes.push("name");return e.prototype.getDelta.apply(this,arguments)};n.prototype._createMoveChange=function(e,t,n,a){const r={selectorElement:a,changeSpecificData:{changeType:n,content:{name:e,index:t}}};return r};n.prototype._getChangeContent=(e,t)=>{const n={};if(e.hasOwnProperty("index")&&e.index>=0){n.index=e.index}t.forEach(t=>{if(e.hasOwnProperty(t)){n[t=="key"?"name":t]=e[t]}});return n};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/ShowDetailsController", ["sap/m/p13n/SelectionController","sap/ui/mdc/enums/TableType","sap/m/p13n/modules/xConfigAPI","sap/base/util/merge"],(e,t,n,o)=>{"use strict";const a=e.extend("sap.ui.mdc.p13n.subcontroller.ShowDetailsController",{constructor:function(n){e.apply(this,arguments);if(!n.control._isOfType(t.ResponsiveTable)){throw new Error("ShowDetailsController is only applicable to ResponsiveTable")}}});a.prototype.getStateKey=function(){return"supplementaryConfig"};a.prototype.getChangeOperations=function(){return{set:"setShowDetails"}};a.prototype.getCurrentState=function(){const e=this.getAdaptationControl().getCurrentState().xConfig;if(e.aggregations?.type?.ResponsiveTable){return{aggregations:{type:{ResponsiveTable:{showDetails:e.aggregations.type.ResponsiveTable.showDetails}}}}}return{}};a.prototype.formatToInternalState=function(e){if(e?.aggregations?.type?.ResponsiveTable){return{aggregations:{type:e.aggregations.type}}}return{}};a.prototype.changesToState=function(e){let t={};const a=e.length&&e[0].selectorElement;e.forEach(e=>{const s=o({},e.changeSpecificData.content);const r={name:s.name,controlMeta:{aggregation:"type"},property:"showDetails",value:s.value};t=n.createAggregationConfig(a,r,t)});return t};a.prototype.sanityCheck=function(e){const t=[];if(e?.aggregations?.type?.ResponsiveTable){t.push({name:"ResponsiveTable",showDetails:e.aggregations.type.ResponsiveTable.showDetails})}return t};a.prototype.getDelta=function(e){e.changedState=e.changedState instanceof Array?e.changedState:this.sanityCheck(e.changedState);e.deltaAttribute="showDetails";e.operation="setShowDetails";e.existingState=this.sanityCheck(e.existingState);return this.getPropertySetterChanges(e)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/p13n/subcontroller/SortController", ["./SelectionController","sap/ui/core/Lib","sap/ui/mdc/p13n/P13nBuilder","sap/m/p13n/SortPanel"],(t,e,o,n)=>{"use strict";const r=t.extend("sap.ui.mdc.p13n.subcontroller.SortController",{constructor:function(){t.apply(this,arguments);this._bResetEnabled=true}});r.prototype.getStateKey=function(){return"sorters"};r.prototype.getUISettings=function(){return{tabText:e.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.TAB_Sort"),title:e.getResourceBundleFor("sap.ui.mdc").getText("sort.PERSONALIZATION_DIALOG_TITLE")}};r.prototype.getDelta=function(e){e.deltaAttributes.push("descending");return t.prototype.getDelta.apply(this,arguments)};r.prototype.initAdaptationUI=function(t){const e=new n;const o=this.mixInfoAndState(t);e.setP13nData(o.items);this._oPanel=e;return Promise.resolve(e)};r.prototype.model2State=function(){const t=[];if(this._oPanel){this._oPanel.getP13nData(true).forEach(e=>{if(e.sorted){t.push({name:e.name})}});return t}};r.prototype.getChangeOperations=function(){return{add:"addSort",remove:"removeSort",move:"moveSort"}};r.prototype._getPresenceAttribute=function(t){return"sorted"};r.prototype.mixInfoAndState=function(t){const e=this.getCurrentState();const n=o.arrayToMap(e);const r=this.prepareAdaptationData(t,(t,e)=>{const o=n[e.name];t.sorted=o?true:false;t.sortPosition=o?o.position:-1;t.descending=o?!!o.descending:false;return!(e.sortable===false)});this.sortP13nData({visible:"sorted",position:"sortPosition"},r.items);r.presenceAttribute=this._getPresenceAttribute();r.items.forEach(t=>{delete t.sortPosition});return r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/Column", ["./GridTableType","./ResponsiveTableType","sap/base/Log","sap/m/library","sap/m/Label","sap/ui/core/Element","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/ui/model/BindingMode","sap/ui/core/Control","sap/ui/mdc/enums/TableType","sap/m/plugins/PluginBase"],(e,t,n,i,o,a,s,l,r,p,u,h)=>{"use strict";const d=p.extend("sap.ui.mdc.table.Column",{metadata:{library:"sap.ui.mdc",defaultAggregation:"template",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"float",group:"Behavior",defaultValue:8},header:{type:"string",group:"Appearance"},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:"Begin"},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},dataProperty:{type:"string"},propertyKey:{type:"string"},required:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false},extendedSettings:{type:"sap.ui.mdc.table.ColumnSettings",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.openEnd();if(t._oColumnHeaderLabel){e.renderControl(t._oColumnHeaderLabel.getLabel())}e.close("div")}}});d.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};this._oManagedObjectModel=new l(this);this._oSettingsModel=new s({width:this.getWidth(),calculatedWidth:null,p13nWidth:null});this._oManagedObjectModel.setDefaultBindingMode(r.OneWay);this._oInnerColumnReady=Promise.withResolvers()};d.prototype.getColumnAIActionPluginOwner=function(){return this._oInnerColumn||this._oInnerColumnReady.promise};d.prototype.getInnerColumn=function(){const e=this.getTable();if(e&&(!this._oInnerColumn||this._oInnerColumn.isDestroyed())){this._oInnerColumn=this._createInnerColumn()}return this._oInnerColumn};d.prototype._createInnerColumn=function(){const n=this.getTable();let o;const a={parts:[{path:"$this>/width"},{path:"$columnSettings>/calculatedWidth"},{path:"$columnSettings>/p13nWidth"}],formatter:function(e,t,n){return n||t||e}};const s={parts:[{path:"$this>/tooltip"},{path:"$this>/header"},{path:"$this>/headerVisible"},{path:"$sap.ui.mdc.Table>/useColumnLabelsAsTooltips"}],formatter:function(e,t,n,i){if(e||!i){return e}return n?t:""}};this._readP13nValues();if(n._isOfType(u.ResponsiveTable)){o=t.createColumn(this.getId()+"-innerColumn",{width:a,autoPopinWidth:"{$this>/minWidth}",hAlign:"{$this>/hAlign}",header:this._getColumnHeaderLabel(s),importance:{parts:[{path:"$this>/importance"},{path:"$this>/extendedSettings/importance"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t,n){if(t&&n==="sap.ui.mdc.table.ResponsiveColumnSettings"){return t}else{return e}}},popinDisplay:"{= ${$this>/headerVisible} ? 'Inline' : 'WithoutHeader' }",mergeDuplicates:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){return e&&t==="sap.ui.mdc.table.ResponsiveColumnSettings"}},mergeFunctionName:{parts:[{path:"$this>/extendedSettings/mergeFunction"},{path:"$this>/extendedSettings/@className"}],formatter:function(e,t){if(t==="sap.ui.mdc.table.ResponsiveColumnSettings"){return e}}}})}else{o=e.createColumn(this.getId()+"-innerColumn",{width:a,minWidth:{path:"$this>/minWidth",formatter:function(e){return Math.round(e*parseFloat(i.BaseFontSize))}},hAlign:"{$this>/hAlign}",label:this._getColumnHeaderLabel(),resizable:"{$sap.ui.mdc.Table>/enableColumnResize}",autoResizable:"{$sap.ui.mdc.Table>/enableColumnResize}",tooltip:s,template:this.getTemplateClone()});o.setCreationTemplate(this.getCreationTemplateClone())}o.setModel(this._oManagedObjectModel,"$this");o.setModel(this._oSettingsModel,"$columnSettings");o.setHeaderMenu(n.getId()+"-columnHeaderMenu");this._oInnerColumnReady.resolve();return o};const c=p.extend("sap.ui.mdc.table.ColumnHeaderLabel",{metadata:{library:"sap.ui.mdc",final:true,aggregations:{label:{type:"sap.m.Label",multiple:false}},associations:{column:{type:"sap.ui.mdc.table.Column"}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.style("width","100%");e.openEnd();e.renderControl(a.getElementById(t.getColumn()));e.close("div")}},setIsInColumnHeaderContext:function(e){this.getLabel()?.setIsInColumnHeaderContext(e)},getText:function(){return this.getLabel().getText()},clone:function(){return this.getLabel().clone()},getRequired:function(){return this.getLabel().getRequired()},getAccessibilityInfo:function(){return this.getLabel().getAccessibilityInfo()}});d.prototype._getColumnHeaderLabel=function(e){const t=this.getTable();if(t&&(!this._oColumnHeaderLabel||this._oColumnHeaderLabel.isDestroyed())){this._oColumnHeaderLabel=new c({column:this,label:new o({width:"{= ${$this>/headerVisible} ? '100%' : '0px' }",text:"{$this>/header}",textAlign:"{$this>/hAlign}",tooltip:e?e:"",wrapping:{parts:[{path:"$this>/headerVisible"},{path:"$sap.ui.mdc.Table>/enableColumnResize"}],formatter:function(e,n){return t._isOfType(u.ResponsiveTable)&&e&&!n}},wrappingType:t._isOfType(u.ResponsiveTable)?"Hyphenated":null,required:"{$this>/required}"})})}return this._oColumnHeaderLabel};d.prototype.getTemplateClone=function(){const e=this.getTable();const t=this.getTemplate();if(e&&t&&(!this._oTemplateClone||this._oTemplateClone.isDestroyed())){this._oTemplateClone=t.clone();if(!e._isOfType(u.ResponsiveTable)){if(this._oTemplateClone.setWrapping){this._oTemplateClone.setWrapping(false)}if(this._oTemplateClone.setRenderWhitespace){this._oTemplateClone.setRenderWhitespace(false)}}}return this._oTemplateClone};d.prototype.getCreationTemplateClone=function(){const e=this.getTable();const t=this.getCreationTemplate();if(e&&t&&(!this._oCreationTemplateClone||this._oCreationTemplateClone.isDestroyed())){this._oCreationTemplateClone=t.clone();if(!e._isOfType(u.ResponsiveTable)){if(this._oCreationTemplateClone.setWrapping){this._oCreationTemplateClone.setWrapping(false)}if(this._oCreationTemplateClone.setRenderWhitespace){this._oCreationTemplateClone.setRenderWhitespace(false)}}}return this._oCreationTemplateClone};d.prototype.setHeader=function(e){this.setProperty("header",e,true);const t=this.getDomRef();if(t){t.textContent=this.getHeader()}return this};d.prototype.getPropertyKey=function(){const e=this.getProperty("propertyKey");return e||this.getDataProperty()};d.prototype.setTooltip=function(e){if(e&&e.isA&&e.isA("sap.ui.core.TooltipBase")){n.error("The control sap.ui.mdc.table.Column allows only strings as tooltip, but given is "+e);return this}return p.prototype.setTooltip.apply(this,arguments)};d.prototype.setParent=function(e){const t=this.getTable();p.prototype.setParent.apply(this,arguments);if(this._bIsBeingMoved){return}this._disconnectFromTable(t);this._connectToTable()};d.prototype._getAIAction=function(){return h.getPlugin(this,"sap.m.plugins.ColumnAIAction")};d.prototype._connectToTable=function(){const e=this.getTable();if(!e){return}this._getAIAction()?.setEnabled(true);this._calculateColumnWidth();this._readP13nValues()};d.prototype._disconnectFromTable=function(){this._getAIAction()?.setEnabled(false);this._oInnerColumn?.destroy();delete this._oInnerColumn};d.prototype._onModifications=function(){this._readP13nValues()};d.prototype._calculateColumnWidth=function(){const e=this.getTable();if(!e||!e.getEnableAutoColumnWidth()||!this.isPropertyInitial("width")){return}const t=e.getPropertyHelper();if(t){t.calculateColumnWidth(this).then(e=>{this._oSettingsModel.setProperty("/calculatedWidth",e)})}else{e._fullyInitialized().then(this._calculateColumnWidth.bind(this))}};d.prototype._readP13nValues=function(){const e=this.getTable();const t=this.getPropertyKey();const n=e._getXConfig();const i=n?.aggregations?.columns?.[t];this._oSettingsModel.setProperty("/p13nWidth",i?.width)};d.prototype.getTable=function(){const e=this.getParent();return e&&e.isA("sap.ui.mdc.Table")?e:null};d.prototype.exit=function(){this._disconnectFromTable();this._oInnerColumnReady=null;["_oManagedObjectModel","_oSettingsModel","_oInnerColumn","_oTemplateClone","_oCreationTemplateClone","_oColumnHeaderLabel"].forEach(function(e){if(this[e]){this[e].destroy();delete this[e]}},this)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ColumnSettings", ["sap/ui/core/Element"],t=>{"use strict";const e=t.extend("sap.ui.mdc.table.ColumnSettings",{metadata:{library:"sap.ui.mdc",abstract:true}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/CreationRow", ["sap/ui/core/Element","sap/ui/mdc/enums/TableType"],(e,t)=>{"use strict";const n=e.extend("sap.ui.mdc.table.CreationRow",{metadata:{library:"sap.ui.mdc",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true},busy:{type:"boolean",group:"Behavior",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{apply:{allowPreventDefault:true}}}});n.prototype.init=function(){this._oInnerCreationRow=null;this._mBindingContexts={}};n.prototype.exit=function(){if(this._oInnerCreationRow){this._oInnerCreationRow.destroy();this._oInnerCreationRow=null}this._mBindingContexts=null};n.prototype.setBusy=function(e){this.setProperty("busy",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setBusy(e)}return this};n.prototype.setBindingContext=function(t,n){e.prototype.setBindingContext.call(this,t,n);this._mBindingContexts[n]={context:t,modelName:n};if(this._oInnerCreationRow){this._oInnerCreationRow.setBindingContext(t,n)}return this};n.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setApplyEnabled(e)}return this};n.prototype.setVisible=function(e){this.setProperty("visible",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setVisible(e);this._getTable()._oTable.getRowMode().setHideEmptyRows?.(e)}return this};n.prototype._onInnerApply=function(e){if(!this.fireApply()){e.preventDefault()}};n.prototype.update=function(){return this._updateInnerCreationRow()};n.prototype._updateInnerCreationRow=function(){const e=this._getTable();let n;if(!e||!e._oTable){return Promise.resolve()}if(e._isOfType(t.Table,true)){if(!this._oInnerCreationRow||this._oInnerCreationRow.isDestroyed()){n=this._createGridTableCreationRow();e._oTable.getRowMode().setHideEmptyRows?.(this.getVisible())}else{n=Promise.resolve()}}else{n=this._createResponsiveTableCreationRow()}return n.then(t=>{i(e,t)})};function o(e){return new Promise((t,n)=>{sap.ui.require([e],e=>{t(e)},e=>{n(e)})})}n.prototype._createGridTableCreationRow=function(){return o("sap/ui/table/CreationRow").then(e=>{r(this);this._oInnerCreationRow=new e(this.getId()+"-inner",{visible:this.getVisible(),applyEnabled:this.getApplyEnabled(),apply:[this._onInnerApply,this]});this._getTable()._oTable.getRowMode().setHideEmptyRows?.(this.getVisible());for(const e in this._mBindingContexts){const t=this._mBindingContexts[e];this._oInnerCreationRow.setBindingContext(t.context,t.modelName)}return this._oInnerCreationRow})};n.prototype._createResponsiveTableCreationRow=function(){r(this);return Promise.resolve()};function i(e,t){if(e&&e._oTable&&t){e._oTable.setCreationRow(t)}}function r(e){if(e&&e._oInnerCreationRow){e._oInnerCreationRow.destroy();e._oInnerCreationRow=null}}n.prototype._getTable=function(){const e=this.getParent();return e&&e.isA("sap.ui.mdc.Table")?e:null};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/DragDropConfig", ["sap/ui/core/dnd/DragDropBase","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/base/ManagedObjectObserver"],(t,e,o,r)=>{"use strict";const n=t.extend("sap.ui.mdc.table.DragDropConfig",{metadata:{library:"sap.ui.mdc",properties:{draggable:{type:"boolean",defaultValue:false},droppable:{type:"boolean",defaultValue:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move"},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On"}},events:{dragStart:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"},browserEvent:{type:"DragEvent"}}},dragEnd:{parameters:{bindingContext:{type:"sap.ui.model.Context"},browserEvent:{type:"DragEvent"}}},dragEnter:{allowPreventDefault:true},dragOver:{allowPreventDefault:true},drop:{}}}});n.prototype.init=function(){this._oObserver=new r(this._observeChanges.bind(this))};n.prototype.exit=function(){this._oObserver.destroy();this._oObserver=null};n.prototype.setDraggable=function(t){this.setProperty("draggable",t,true);this.getDraggable()?this._addDragInfoToTable():this._removeDragInfoFromTable();return this};n.prototype.setDroppable=function(t){this.setProperty("droppable",t,true);this.getDroppable()?this._addDropInfoToTable():this._removeDropInfoFromTable();return this};n.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);this._oDragInfo?.setEnabled(t);this._oDropInfo?.setEnabled(t);return this};n.prototype.setGroupName=function(t){this.setProperty("groupName",t,true);this._oDragInfo?.setGroupName(t);this._oDropInfo?.setGroupName(t);return this};n.prototype.setKeyboardHandling=function(t){this.setProperty("keyboardHandling",t,true);this._oDragInfo?.setKeyboardHandling(t);this._oDropInfo?.setKeyboardHandling(t);return this};n.prototype.setDropEffect=function(t){this.setProperty("dropEffect",t,true);this._oDropInfo?.setDropEffect(t);return this};n.prototype.setDropPosition=function(t){this.setProperty("dropPosition",t,true);this._oDropInfo?.setDropPosition(t);return this};n.prototype.setParent=function(){const e=this.getParent();e&&this._disconnectFromParent(e);t.prototype.setParent.apply(this,arguments);const o=this.getParent();o&&this._connectToParent(o)};n.prototype._connectToParent=function(t){this._oObserver.observe(t,{aggregations:["_content"]});const e=t.getAggregation("_content");e&&this._connectToTable(e)};n.prototype._disconnectFromParent=function(t){this._oObserver?.unobserve(t,{aggregations:["_content"]});this._disconnectFromTable()};n.prototype._observeChanges=function(t){if(t.mutation=="insert"){this._connectToTable(t.child)}else{this._disconnectFromTable()}};n.prototype._connectToTable=function(t){this._oTable=t;this._addDragInfoToTable();this._addDropInfoToTable()};n.prototype._disconnectFromTable=function(){this._removeDragInfoFromTable();this._removeDropInfoFromTable();this._oTable=null};n.prototype._addDragInfoToTable=function(){if(this._oTable&&!this._oDragInfo&&this.getDraggable()){this._oDragInfo=new e({enabled:this.getEnabled(),groupName:this.getGroupName(),keyboardHandling:this.getKeyboardHandling(),sourceAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragStart:[this._onDragInfoEvent,this],dragEnd:[this._onDragInfoEvent,this]});this._oTable.addDragDropConfig(this._oDragInfo)}};n.prototype._removeDragInfoFromTable=function(){if(this._oTable&&this._oDragInfo){this._oTable.removeDragDropConfig(this._oDragInfo);this._oDragInfo.destroy();this._oDragInfo=null}};n.prototype._addDropInfoToTable=function(){if(this._oTable&&!this._oDropInfo&&this.getDroppable()){this._oDropInfo=new o({enabled:this.getEnabled(),groupName:this.getGroupName(),dropEffect:this.getDropEffect(),dropPosition:this.getDropPosition(),keyboardHandling:this.getKeyboardHandling(),targetAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragEnter:[this._onDropInfoEvent,this],dragOver:[this._onDropInfoEvent,this],drop:[this._onDropInfoEvent,this]});this._oTable.addDragDropConfig(this._oDropInfo)}};n.prototype._removeDropInfoFromTable=function(){if(this._oTable&&this._oDropInfo){this._oTable.removeDragDropConfig(this._oDropInfo);this._oDropInfo.destroy();this._oDropInfo=null}};function s(t){const e=t.isA("sap.m.ListItemBase")?"items":"rows";const o=t.getParent().getBindingInfo(e)||{};return t.getBindingContext(o.model)}function a(t){let e;const o=t.getDragControl();if(o?.isA("sap.m.ListItemBase")){e=s(o)}else if(o?.isA("sap.ui.table.Row")){e=t.getComplexData("sap.ui.table-"+o.getParent().getId()).draggedRowContext}return e||o}n.prototype._onDragInfoEvent=function(t){const e=t.getParameter("dragSession");const o=t.getId()=="dragStart";const r={bindingContext:a(e),browserEvent:t.getParameter("browserEvent")};const n=this.fireEvent(t.getId(),r,o);if(o&&!n){t.preventDefault()}};n.prototype._onDropInfoEvent=function(t){const e=t.getParameter("dragSession");const o=e.getDropControl();const r=t.getParameter("dropPosition");const n=t.getId().startsWith("drag");const i={bindingContext:s(o),dragSource:a(e),browserEvent:t.getParameter("browserEvent")};if(r){i.dropPosition=r}const p=this.fireEvent(t.getId(),i,n);if(n&&!p){t.preventDefault()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/GridTableType", ["./TableTypeBase","./menu/GroupHeaderRowContextMenu","../enums/TableRowCountMode","sap/m/table/Util","./utils/Personalization","sap/ui/model/json/JSONModel","sap/ui/core/Lib"],(e,t,o,n,i,s,a)=>{"use strict";let l,r,u,c,p,d;const g=e.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.enums.TableRowCountMode",group:"Behavior",defaultValue:o.Auto},rowCount:{type:"int",group:"Appearance",defaultValue:10},selectionLimit:{type:"int",group:"Behavior",defaultValue:200},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},scrollThreshold:{type:"int",group:"Behavior",defaultValue:-1}}}});g.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this.disableColumnResize()};g.prototype.updateTableByProperty=function(e,t){const n=this.getInnerTable();if(!n){return}if(e==="rowCountMode"){let e=n.getRowMode();let i=false;if(e&&(t===o.Fixed&&!e.isA("sap.ui.table.rowmodes.Fixed")||t===o.Auto&&!e.isA("sap.ui.table.rowmodes.Auto")||t===o.Interactive&&!e.isA("sap.ui.table.rowmodes.Interactive"))){const t=this.getTable().getCreationRow();if(t){i=t.getVisible()}e.destroy();e=null}if(!e){const e=p[t]??p[o.Auto];const s=new e({fixedBottomRowCount:"{= ${$sap.ui.mdc.Table>/@custom/hasGrandTotal} ? 1 : 0}"});n.setRowMode(s.setHideEmptyRows?.(i)??s)}this._updateTableRowCount()}else if(e==="rowCount"){this._updateTableRowCount()}};g.prototype._updateTableRowCount=function(){const e=this.getInnerTable();if(this.getRowCountMode()===o.Fixed||this.getRowCountMode()===o.Interactive){e.getRowMode().setRowCount(this.getRowCount())}else{e.getRowMode().setMinRowCount(this.getRowCount())}};g.prototype.loadUiTableLibrary=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=a.load({name:"sap.ui.table"})}return this._oGridTableLibLoaded};g.prototype.loadModules=function(){if(l){return Promise.resolve()}return this.loadUiTableLibrary().then(()=>new Promise((e,t)=>{sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/rowmodes/Fixed","sap/ui/table/rowmodes/Auto","sap/ui/table/rowmodes/Interactive","sap/ui/table/RowSettings"],(t,n,i,s,a,g,h,b)=>{l=t;r=n;u=i;c=s;p={[o.Fixed]:a,[o.Auto]:g,[o.Interactive]:h};d=b;e()},()=>{t("Failed to load some modules")})}))};g.prototype.createTable=function(e){const o=this.getTable();if(!o||!l){return null}const n=new l(e,this.getTableSettings());n.setAggregation("groupHeaderRowContextMenu",new t);return n};g.prototype.getTableSettings=function(){const t=this.getTable();const o={SingleMaster:"RowOnly"};const n=this.getRowSettingsConfig();const i={enableBusyIndicator:true,enableColumnReordering:false,threshold:{path:"$sap.ui.mdc.Table>/threshold",formatter:function(e){return e>-1?e:undefined}},scrollThreshold:"{$sap.ui.mdc.Table#type>/scrollThreshold}",noData:t._getNoDataText(),extension:[t._oToolbar],ariaLabelledBy:[t._oTitle],rowSettingsTemplate:n?new d(n):null,selectionMode:"None",selectionBehavior:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return o[e]}},enableColumnFreeze:"{$sap.ui.mdc.Table#type>/enableColumnFreeze}",fixedColumnCount:{parts:[{path:"$sap.ui.mdc.Table#type>/fixedColumnCount"},{path:"$typeSettings>/p13nFixedColumnCount"}],formatter:function(e,t){return t??e}},models:{$typeSettings:new s({p13nFixedColumnCount:null})},columnFreeze:[f,this],beforeOpenContextMenu:[b,this]};if(t.hasListeners("rowPress")){i.cellClick=[h,this]}return Object.assign({},e.prototype.getTableSettings.apply(this,arguments),i)};function h(e){this.callHook("RowPress",this.getTable(),{bindingContext:e.getParameter("rowBindingContext")})}function b(e){const t=e.getParameters();const o=this.getTable();const n=this.getInnerTable();const i=n.getRows().find(e=>e.getIndex()===t.rowIndex);this.callHook("BeforeOpenContextMenu",o,{bindingContext:n.getContextByIndex(t.rowIndex),column:o.getColumns()[t.columnIndex],contextMenu:t.contextMenu,event:e,groupLevel:t.contextMenu.isA("sap.ui.mdc.table.menu.GroupHeaderRowContextMenu")?i.getLevel():undefined})}g.createColumn=function(e,t){return new r(e,t)};g.prototype.enableColumnResize=function(){const e=this.getTable();const t=this.getInnerTable();if(!e||!t){return}t.getColumns().forEach(e=>{e.setResizable(true);e.setAutoResizable(true)});t.detachColumnResize(m,this);t.attachColumnResize(m,this)};g.prototype.disableColumnResize=function(){const e=this.getTable();const t=this.getInnerTable();if(!e||!t){return}t.getColumns().forEach(e=>{e.setResizable(false);e.setAutoResizable(false)});t.detachColumnResize(m,this)};function m(e){const t=this.getTable();const o=this.getInnerTable();const n=e.getParameter("column");const i=e.getParameter("width");const s=o.indexOfColumn(n);const a=t.getColumns()[s];this.callHook("ColumnResize",t,{column:a,width:i})}async function f(e){const t=this.getTable();await Promise.resolve();i.createFixedColumnCountChange(t,{fixedColumnCount:this.getInnerTable().getFixedColumnCount()})}g.prototype.updateRowSettings=function(){const e=this.getInnerTable();if(!e){return}e.destroyRowSettingsTemplate();e.setRowSettingsTemplate(new d(this.getRowSettingsConfig()));this.updateRowActions()};g.prototype.updateRowActions=function(){const e=this.getInnerTable();if(!e){return}const t=this.getTable().getRowSettings();this._removeRowActions();if(!t||!t.isBound("rowActions")&&(!t.getRowActions()||t.getRowActions().length==0)){return}const o=t.getAllActions();if("templateInfo"in o){const e=o.templateInfo;o.items.template=new c({type:e.type,visible:e.visible,icon:e.icon,text:e.text,press:[w,this]});delete o.templateInfo}else{o.items=o.items.map(function(e){const t=new c({type:e.isBound("type")?e.getBindingInfo("type"):e.getType(),visible:e.isBound("visible")?e.getBindingInfo("visible"):e.getVisible(),icon:e.isBound("icon")?e.getBindingInfo("icon"):e.getIcon(),text:e.isBound("text")?e.getBindingInfo("text"):e.getText(),press:[w,this]});t.data("rowAction",e);return t},this)}e.setRowActionTemplate(new u(o));e.setRowActionCount(t.getRowActionCount())};g.prototype._removeRowActions=function(){const e=this.getInnerTable();const t=e.getRowActionTemplate();if(t){t.destroy()}e.setRowActionTemplate();e.setRowActionCount()};function w(e){const t=this.getTable();const o=e.getParameter("item");const n=t.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const e=i.items.model;const t=o.getBindingContext(e);if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setBindingContext(t,i.items.model);this._oRowActionItem.setModel(this.getModel(e),e);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this.callHook("Press",this._oRowActionItem,{bindingContext:e.getParameter("row").getBindingContext(this.getInnerTable().getBindingInfo("rows").model)})}g.prototype.prepareRowPress=function(){const e=this.getInnerTable();if(e&&!e.hasListeners("cellClick")){e.attachEvent("cellClick",h,this)}};g.prototype.cleanupRowPress=function(){const e=this.getTable();if(!e.hasListeners("rowPress")){this.getInnerTable()?.detachEvent("cellClick",h,this)}};g.prototype.removeToolbar=function(){const e=this.getInnerTable();if(e){e.removeExtension(this.getTable()._oToolbar)}};g.prototype.scrollToIndex=function(e){const t=this.getTable();const o=this.getInnerTable();if(!o){return Promise.reject()}return new Promise(i=>{if(e===-1){e=n.isEmpty(t.getRowBinding())?0:t.getRowBinding().getLength()}if(o._setFirstVisibleRowIndex(e)){o.attachEventOnce("rowsUpdated",()=>{i()})}else{i()}})};g.prototype.getRowBinding=function(){const e=this.getInnerTable();return e?e.getBinding():undefined};g.prototype.bindRows=function(e){const t=this.getInnerTable();if(t){t.bindRows(e)}};g.prototype.isTableBound=function(){const e=this.getInnerTable();return e?e.isBound("rows"):false};g.prototype.insertFilterInfoBar=function(e,t){const o=this.getInnerTable();if(o){o.insertExtension(e,1);if(!o.getAriaLabelledBy().includes(t)){o.addAriaLabelledBy(t)}}};g.prototype.updateSortIndicator=function(e,t){e.getInnerColumn().setSorted(t!=="None");e.getInnerColumn().setSortOrder(t)};g.prototype.getTableStyleClasses=function(){const t=e.prototype.getTableStyleClasses.apply(this,arguments);if(this.getRowCountMode()===o.Auto){t.push("sapUiMdcTableFitContainer")}return t};g.prototype.setScrollThreshold=function(e){this.setProperty("scrollThreshold",e,true);return this};g.prototype.setEnableColumnFreeze=function(e){if(this.getEnableColumnFreeze()!==e){this.setProperty("enableColumnFreeze",e,true);this.getTable()?._updateAdaptation()}return this};g.prototype.onModifications=function(){const e=this.getTable();const t=this.getInnerTable();const o=e._getXConfig();const n=o?.aggregations?.type;t.getModel("$typeSettings").setProperty("/p13nFixedColumnCount",n?.GridTable?.fixedColumnCount??0)};g.prototype.showXConfigState=function(){return this.getEnableColumnFreeze()};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/PropertyHelper", ["../util/PropertyHelper","sap/m/table/Util","sap/ui/base/Object"],(e,t,r)=>{"use strict";const n=e.extend("sap.ui.mdc.table.PropertyHelper",{constructor:function(t,r,n){e.call(this,t,r,Object.assign({filterable:true,sortable:true,propertyInfos:true,groupable:{type:"boolean",inComplexProperty:{valueIfNotAllowed:false}},isKey:{type:"boolean",inComplexProperty:{valueIfNotAllowed:false}},unit:{type:"PropertyReference"},text:{type:"PropertyReference"},exportSettings:{type:"object",default:{value:{},ignoreIfNull:true},inComplexProperty:{allowed:true}},clipboardSettings:{type:{template:{type:"string"}},default:{value:{},ignoreIfNull:true},inComplexProperty:{allowed:true}},visualSettings:{type:{widthCalculation:{type:{minWidth:{type:"int",default:{value:2}},maxWidth:{type:"int",default:{value:19}},defaultWidth:{type:"int",default:{value:8}},gap:{type:"float",default:{value:0}},includeLabel:{type:"boolean",default:{value:true}},truncateLabel:{type:"boolean",default:{value:true}},verticalArrangement:{type:"boolean",default:{value:false}},excludeProperties:{type:"PropertyReference[]"}},default:{value:{},ignoreIfNull:true}}},default:{value:{}},inComplexProperty:{allowed:true}}},n?{extension:{type:n,default:{value:{}},inComplexProperty:{allowed:true,propagateAllowance:false}}}:{},this._bEnableAggregatableAttribute?{aggregatable:{type:"boolean",inComplexProperty:{valueIfNotAllowed:false}}}:{}))}});n.prototype.validateProperty=function(t,r,n){e.prototype.validateProperty.apply(this,arguments);if(t.text&&t.unit){e.throwInvalidPropertyError("A property must not have both a text and a unit.",t)}};n.prototype.prepareProperty=function(t,r){e.prototype.prepareProperty.apply(this,arguments);if(!t.isComplex()&&!t.typeConfig&&t.dataType&&this.getParent()){const e=this.getParent().getControlDelegate().getTypeMap();t.typeConfig=e.getTypeConfig(t.dataType,t.formatOptions,t.constraints)}Object.defineProperty(t,"getGroupableProperties",{value:function(){return t.getSimpleProperties().filter(e=>e.groupable)}})};n.prototype.getColumnClipboardSettings=function(e){const t=this.getProperty(e.getPropertyKey());if(!t||t.clipboardSettings===null){return null}const r=t.getSimpleProperties().map(e=>e.path);const n=t.getSimpleProperties().map(e=>e.typeConfig&&e.typeConfig.typeInstance);const o=t.clipboardSettings.template||Array.from(Array(r.length).keys(),e=>"{"+e+"}").join(" ");return{properties:r,template:o,types:n}};n.prototype.getColumnExportSettings=function(e){const t=[];if(!r.isObjectA(e,"sap.ui.mdc.table.Column")){return t}const n=this.getProperty(e.getPropertyKey());if(!n){return t}const o=n.exportSettings;if(o===null){return t}let i;if(!n.isComplex()){i=l(e,n,o);t.push(i);return t}const p=n.getSimpleProperties();if(Object.keys(o).length){i=l(e,n,o);t.push(i)}else{p.forEach((r,n)=>{if(!r.exportSettings){return}const o=l(e,r,r.exportSettings);if(n>0){o.columnId=e.getId()+"-additionalProperty"+n}if(r.exportSettings||o.property){t.push(o)}})}return t};function o(e){if(e.indexOf("em")>0){return Math.round(parseFloat(e))}if(e.indexOf("px")>0){return Math.round(parseInt(e)/16)}return""}function l(e,t,r){const n=[];if(t.isComplex()){t.getSimpleProperties().forEach(e=>{n.push(e.path)})}return Object.assign({columnId:e.getId(),label:t.label,width:o(e.getWidth()),textAlign:e.getHAlign(),type:"String",property:n.length?n:t.path},r)}n.prototype.calculateColumnWidth=function(e){const t=e.getPropertyKey();const r=e.getTable();return r._getPropertyByNameAsync(t).then(t=>{if(!t){return null}const r=t.visualSettings;if(r&&r.widthCalculation===null){return null}return this._calcColumnWidth(t,e)})};n.prototype._calcColumnWidth=function(e,r){const n=Object.assign({gap:0,includeLabel:true,truncateLabel:true,excludeProperties:[],required:r.getRequired(),hasAction:Boolean(r._getAIAction())},e.visualSettings&&e.visualSettings.widthCalculation);const o=r.getParent();if(o&&o._isOfType("TreeTable")&&o.indexOfColumn(r)==0){n.treeColumn=true}let l=[];if(e.isComplex()){l=e.getSimpleProperties().flatMap(e=>{const t=e.visualSettings?e.visualSettings.widthCalculation:undefined;return t===null||n.excludeProperties.includes(e.key)?[]:[[e.typeConfig.typeInstance,t]]})}else{l.push(e.typeConfig.typeInstance)}if(e.unit){n.gap+=2.5}const i=n.includeLabel?r.getHeader()||e.label:"";return t.calcColumnWidth(l,i,n)};n.prototype.getRedundantProperties=function(){const e=this.getProperties();const t=e.filter(e=>e.text).map(e=>this.getProperty(e.text));return[...new Set(t)]};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ResponsiveColumnSettings", ["./ColumnSettings"],e=>{"use strict";const t=e.extend("sap.ui.mdc.table.ResponsiveColumnSettings",{metadata:{library:"sap.ui.mdc",final:true,properties:{importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},mergeFunction:{type:"string",group:"Appearance"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/ResponsiveTableType", ["./TableTypeBase","./utils/Personalization","sap/m/plugins/ColumnResizer","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowActionType"],(t,e,o,n,i,s,a,r,l,u)=>{"use strict";let p,h,c;const g=t.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.enums.TableGrowingMode",group:"Behavior",defaultValue:l.Basic},showDetailsButton:{type:"boolean",group:"Behavior",defaultValue:false},detailsButtonSetting:{type:"sap.ui.core.Priority[]",group:"Behavior"},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:"Block"}}}});g.prototype.setDetailsButtonSetting=function(t){return this.setProperty("detailsButtonSetting",t,true)};g.prototype.setParent=function(){t.prototype.setParent.apply(this,arguments);this._oShowDetailsButton?.destroy();delete this._oShowDetailsButton;return this};g.prototype.updateTableByProperty=function(t,e){const o=this.getInnerTable();if(!o){return}if(t==="growingMode"){o.setGrowingScrollToLoad(e===l.Scroll);o.setGrowing(e!==l.None)}else if(t==="showDetailsButton"){this._updateShowDetailsButton(o,e)}else if(t==="popinLayout"){o.setPopinLayout(e)}};g.prototype._updateShowDetailsButton=function(t,e){if(e&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);t.attachEvent("popinChanged",w,this);t.setHiddenInPopin(this._getImportanceToHide())}else if(!e&&this._oShowDetailsButton){t.detachEvent("popinChanged",w,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton}};g.prototype.loadModules=function(){if(!p){return new Promise((t,e)=>{sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],(e,o,n)=>{p=e;h=o;c=n;t()},()=>{e("Failed to load some modules")})})}else{return Promise.resolve()}};g.prototype.createTable=function(t){const e=this.getTable();if(!e||!p){return null}return new p(t,this.getTableSettings())};g.prototype.getTableSettings=function(){const e=this.getTable();const o={autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","GroupHeaders","HeaderToolbar","InfoToolbar"],growingThreshold:{path:"$sap.ui.mdc.Table>/threshold",formatter:function(t){return t>-1?t:undefined}},noData:e._getNoDataText(),headerToolbar:e._oToolbar,ariaLabelledBy:[e._oTitle],beforeOpenContextMenu:[f,this]};if(e.hasListeners("rowPress")){o.itemPress=[d,this]}return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),o)};function d(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("listItem").getBindingContext(this.getInnerTable().getBindingInfo("items").model)});b.call(this,t)}function f(t){const e=t.getParameters();const o=this.getInnerTable();const n=a.getElementById(e.column?.getId().replace(/\-innerColumn$/,""));this.callHook("BeforeOpenContextMenu",this.getTable(),{bindingContext:e.listItem.getBindingContext(o.getBindingInfo("items").model),column:n,contextMenu:o.getContextMenu(),event:t,groupLevel:undefined})}g.createColumn=function(t,e){return new h(t,e)};g.prototype.createRowTemplate=function(t){return new c(t,this.getRowSettingsConfig())};g.prototype.prepareRowPress=function(){if(this._attachItemPress()){this.updateRowActions()}};g.prototype.cleanupRowPress=function(){if(this._detachItemPress()){this.updateRowActions()}};g.prototype.updateRowSettings=function(){const t=this.getTable();if(!t||!t._oRowTemplate){return}t._oRowTemplate.unbindProperty("navigated");t._oRowTemplate.unbindProperty("highlight");t._oRowTemplate.unbindProperty("highlightText");t._oRowTemplate.applySettings(this.getRowSettingsConfig());this.updateRowActions()};g.prototype.updateRowActions=function(){const t=this.getTable();const e=this.getRowActionsConfig();const o=t.hasListeners("rowPress")?"Active":"Inactive";t._oRowTemplate.unbindProperty("type");if(!t.getRowSettings()){t._oRowTemplate.setType(o);return}if(o==="Inactive"){this._detachItemPress()}let n,i,s;if("templateInfo"in e){const t=e.templateInfo;s=t.visible.formatter;i=typeof t.visible=="object";n=t.visible}else if(e&&e.items){if(e.items.length==0){t._oRowTemplate.setType(o);return}const a=e.items.find(t=>t.getType()=="Navigation");if(!a&&e.items.length>0){throw new Error("No row action of type 'Navigation' found. ResponsiveTableType only accepts row actions of type 'Navigation'.")}t._oRowTemplate.data("rowAction",a);i=a.isBound("visible");n=i?Object.assign({},a.getBindingInfo("visible")):a.getVisible();s=n.formatter}if(i){n.formatter=t=>{const e=s?s(t):t;const n=e===true?u.Navigation:o;if(n===u.Navigation){this._attachItemPress()}return n};t._oRowTemplate.bindProperty("type",n)}else{n=n?u.Navigation:o;t._oRowTemplate.setProperty("type",n);if(n===u.Navigation){this._attachItemPress()}}};g.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}let n=o.findOn(e);e.setFixedLayout("Strict");if(!n){n=new o;e.addDependent(n);n.attachColumnResize(m,this)}else{n.setEnabled(true);n.detachColumnResize(m,this);n.attachColumnResize(m,this)}};g.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}const n=o.findOn(e);if(n){n.setEnabled(false);n.detachColumnResize(m,this)}};function m(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const a=e.getColumns()[s];this.callHook("ColumnResize",e,{column:a,width:i})}g.prototype.createColumnResizeMenuItem=function(t,e){const n=o.findOn(this.getInnerTable());if(!n){return}if(e.isA("sap.m.table.columnmenu.Menu")){return n.getColumnResizeQuickAction(t.getInnerColumn(),e)}else{return n.getColumnResizeButton(t.getInnerColumn())}};g.prototype._attachItemPress=function(){const t=this.getInnerTable();if(t&&!t.hasListeners("itemPress")){t.attachEvent("itemPress",d,this);return true}return false};g.prototype._detachItemPress=function(){const t=this.getTable();const e=this.getInnerTable();if(!t.hasListeners("rowPress")&&e){e.detachEvent("itemPress",d,this);return true}return false};g.prototype.setShowDetailsButton=function(t){if(this.getShowDetailsButton()!==t){this.setProperty("showDetailsButton",t,true);this.getTable()?._updateAdaptation()}return this};g.prototype._setShowDetailsState=function(t,e){if(t===this.bShowDetails){return}this.bShowDetails=t;if(!e){this._persistShowDetails(t)}if(!this._oShowDetailsButton){return}const o=this.getInnerTable();if(this.bShowDetails){o.setHiddenInPopin();this._oShowDetailsButton.setSelectedKey("showDetails")}else{o.setHiddenInPopin(this._getImportanceToHide());this._oShowDetailsButton.setSelectedKey("hideDetails")}};g.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){const t=r.getResourceBundleFor("sap.ui.mdc");const e=this.getTable().getId();this.bShowDetails=false;this._oShowDetailsButton=new n(e+"-showHideDetails",{visible:false,selectedKey:"hideDetails",items:[new i({id:e+"-showDetails",icon:"sap-icon://detail-more",key:"showDetails",tooltip:t.getText("table.SHOWDETAILS_TEXT"),press:[function(){this._setShowDetailsState(true)},this]}),new i({id:e+"-hideDetails",icon:"sap-icon://detail-less",key:"hideDetails",tooltip:t.getText("table.HIDEDETAILS_TEXT"),press:[function(){this._setShowDetailsState(false)},this]})]})}return this._oShowDetailsButton};g.prototype._persistShowDetails=function(t){e.createShowDetailsChange(this.getTable(),{showDetails:t})};g.prototype._getImportanceToHide=function(){const t=this.getDetailsButtonSetting()||[];if(t.length>0){return t}else{return s.system.phone?["Low","Medium"]:["Low"]}};function w(t){const e=t.getParameter("hasPopin");const o=t.getParameter("hiddenInPopin");const n=t.getSource().getVisibleItems().length;if(n&&(o.length||e&&this.bShowDetails)){this._oShowDetailsButton.setVisible(true)}else{this._oShowDetailsButton.setVisible(false)}}function b(t){const e=this.getTable();const o=t.getParameter("listItem");if(o.getType()!=="Navigation"){return}const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setModel(e.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this._oRowActionItem.setType("Navigation");this.callHook("Press",this._oRowActionItem,{bindingContext:o.getBindingContext(this.getInnerTable().getBindingInfo("items").model)})}g.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.setHeaderToolbar()}};g.prototype.scrollToIndex=function(t){const e=this.getInnerTable();if(e){return e.scrollToIndex(t)}else{return Promise.reject()}};g.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding("items"):undefined};g.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindItems(t)}};g.prototype.isTableBound=function(){const t=this.getInnerTable();if(t){return t.isBound("items")}else{return false}};g.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.setInfoToolbar(t);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};g.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSortIndicator(e)};g.prototype._onColumnInsert=function(t){const o=this.getTable();const n=this.getInnerTable();if(e.isUserPersonalizationActive(o)&&n.getHiddenInPopin()?.includes(t.getInnerColumn().getImportance())&&o.getColumns().pop()===t){this._setShowDetailsState(true)}};g.prototype.onModifications=function(){const t=this.getTable();const e=t._getXConfig();const o=e?.aggregations?.type;this._setShowDetailsState(o?.ResponsiveTable?.showDetails??false,true)};g.prototype.showXConfigState=function(){return this._oShowDetailsButton?.getVisible()};g.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oShowDetailsButton?.destroy();delete this._oShowDetailsButton};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/RowActionItem", ["sap/ui/core/Element","sap/ui/mdc/enums/TableRowActionType"],e=>{"use strict";const t=e.extend("sap.ui.mdc.table.RowActionItem",{metadata:{library:"sap.ui.mdc",properties:{type:{type:"sap.ui.mdc.enums.TableRowActionType"},text:{type:"string"},icon:{type:"sap.ui.core.URI"},visible:{type:"boolean",defaultValue:true}},events:{press:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}}}}});t.prototype._onPress=function(e){this.firePress({bindingContext:e.bindingContext})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/RowSettings", ["sap/ui/core/Element"],t=>{"use strict";const i=t.extend("sap.ui.mdc.table.RowSettings",{metadata:{library:"sap.ui.mdc",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rowActions:{type:"sap.ui.mdc.table.RowActionItem",multiple:true}}}});i.prototype.getAllSettings=function(){const t={},i=this.clone();if(this.isBound("navigated")){t.navigated=i.getBindingInfo("navigated")}else{t.navigated=this.getNavigated()}if(this.isBound("highlight")){t.highlight=i.getBindingInfo("highlight")}else{t.highlight=this.getHighlight()}if(this.isBound("highlightText")){t.highlightText=i.getBindingInfo("highlightText")}else{t.highlightText=this.getHighlightText()}return t};i.prototype.getAllActions=function(){const t={},i=this.clone();if(this.isBound("rowActions")){t.items=i.getBindingInfo("rowActions");const e=t.items.template;t.templateInfo={type:e.isBound("type")?e.getBindingInfo("type"):e.getType(),text:e.isBound("text")?e.getBindingInfo("text"):e.getText(),icon:e.isBound("icon")?e.getBindingInfo("icon"):e.getIcon(),visible:e.isBound("visible")?e.getBindingInfo("visible"):e.getVisible()}}else{t.items=this.getRowActions()}return t};i.prototype.getRowActionCount=function(){let t=0;if(this.isBound("rowActions")){t=1}else{t=this.getRowActions().length}return t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TableSettings", ["sap/m/OverflowToolbarButton","sap/m/library","sap/m/OverflowToolbarMenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/Lib","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/ui/core/theming/Parameters","sap/ui/performance/trace/FESRHelper"],(e,t,n,a,s,o,l,i,c,r,p)=>{"use strict";const{HasPopup:u}=l.aria;let T;const d={createSettingsButton:function(e,t){if(!T){this._loadResourceBundle()}const n=this._createButton(e+"-settings",{icon:"sap-icon://action-settings",text:T.getText("table.SETTINGS"),press:t,tooltip:T.getText("table.SETTINGS"),ariaHasPopup:u.Dialog});p.setSemanticStepname(n,"press","mdc:tbl:p13n");c.addConfig(n,{addAccessibilityLabel:true,messageBundleKey:i.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT"},t[1]);return n},createPasteButton:function(e){const t=this._createButton(e+"-paste");p.setSemanticStepname(t,"press","mdc:tbl:paste");sap.ui.require(["sap/m/plugins/PasteProvider"],n=>{t.addDependent(new n({pasteFor:e+"-innerTable"}))});return t},createExportButton:function(e,o){if(!T){this._loadResourceBundle()}const l=r.get({name:"_sap_ui_mdc_Table_ExportButtonType"});const u=new n(e+"-export",{icon:"sap-icon://excel-attachment",text:T.getText("table.QUICK_EXPORT"),tooltip:T.getText("table.EXPORT_BUTTON_TEXT"),type:t.ButtonType[l],buttonMode:t.MenuButtonMode.Split,useDefaultActionOnly:true,defaultAction:o.default});const d=new a({items:[new s({text:T.getText("table.QUICK_EXPORT"),press:o.default}),new s({text:T.getText("table.EXPORT_WITH_SETTINGS"),press:o.exportAs})]});u.setMenu(d);p.setSemanticStepname(u,"defaultAction","OI:QE");p.setSemanticStepname(d.getItems()[0],"press","OI:QE");p.setSemanticStepname(d.getItems()[1],"press","OI:EXP:SETTINGS");c.addConfig(u._getButtonControl(),{addAccessibilityLabel:true,messageBundleKey:i.os.macintosh?"table.SHORTCUT_EXPORT_TO_EXCEL_MAC":"table.SHORTCUT_EXPORT_TO_EXCEL"},o.exportAs[1]);return u},createExpandCollapseButton:function(e,t,n){if(!T){this._loadResourceBundle()}const a=t?e+"-expandAll":e+"-collapseAll",s=t?T.getText("table.EXPAND_TREE"):T.getText("table.COLLAPSE_TREE");const o=this._createButton(a,{icon:t?"sap-icon://expand-all":"sap-icon://collapse-all",text:s,press:n,tooltip:s});p.setSemanticStepname(o,"press","mdc:tbl:"+(t?"expandAll":"collapseAll"));return o},createExpandCollapseMenuButton:function(e,t,o){if(!T){this._loadResourceBundle()}const l=t?e+"-expandAll":e+"-collapseAll",i=t?T.getText("table.EXPAND_TREE"):T.getText("table.COLLAPSE_TREE"),c=t?T.getText("table.EXPAND_NODE"):T.getText("table.COLLAPSE_NODE"),r=t?T.getText("table.EXPAND_MENU_BUTTON_TEXT"):T.getText("table.COLLAPSE_MENU_BUTTON_TEXT");const p=new n(l,{icon:t?"sap-icon://expand-all":"sap-icon://collapse-all",tooltip:r,menu:new a({items:[new s({text:i,press:o.tree}),new s({text:c,press:o.node})]})});return p},_createButton:function(t,n){return new e(t,n)},_loadResourceBundle:function(){T=o.getResourceBundleFor("sap.ui.mdc")}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TableTypeBase", ["sap/ui/core/Element","sap/ui/core/dnd/DragDropInfo","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/enums/TableP13nMode"],(t,e,o,n)=>{"use strict";const r=t.extend("sap.ui.mdc.table.TableTypeBase",{metadata:{library:"sap.ui.mdc",abstract:true,properties:{}}});r.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oManagedObjectModel=new o(this)};r.prototype.exit=function(){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;t.prototype.exit.apply(this,arguments)};r.prototype.setParent=function(){t.prototype.setParent.apply(this,arguments);this.getTable()?.setModel(this._oManagedObjectModel,"$sap.ui.mdc.Table#type")};r.prototype.callHook=function(t,e,o){const n="_on"+t;if(!e||!(e[n]instanceof Function)){throw new Error(this+": Hook '"+t+"' does not exist on "+e)}e[n].call(e,o)};r.prototype.getTable=function(){const t=this.getParent();return t&&t.isA("sap.ui.mdc.Table")?t:null};r.prototype.getInnerTable=function(){const t=this.getTable();return t?t._oTable:null};r.prototype.setProperty=function(e,o){t.prototype.setProperty.apply(this,arguments);this.updateTableByProperty(e,o);return this};r.prototype.updateTable=function(){for(const t in this.getMetadata().getAllProperties()){this.updateTableByProperty(t,this.getProperty(t))}};r.prototype.getTableSettings=function(){const t=this.getTable();if(!t){return{}}const o=new e({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",keyboardHandling:true,enabled:t.getActiveP13nModes().includes(n.Column),drop:[this._onColumnMove,this]});o.bIgnoreMetadataCheck=true;return{dragDropConfig:[o],busyIndicatorDelay:t.getBusyIndicatorDelay(),paste:[this._onPaste,this]}};r.prototype.getRowSettingsConfig=function(){const t=this.getTable();const e=t?t.getRowSettings():null;return e?e.getAllSettings():null};r.prototype.getRowActionsConfig=function(){const t=this.getTable();const e=t?t.getRowSettings():null;return e?e.getAllActions():null};r.prototype._onColumnMove=function(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("draggedControl");const r=t.getParameter("droppedControl");if(n===r){return}const i=t.getParameter("dropPosition");const p=o.indexOfColumn(n);const s=o.indexOfColumn(r);const a=s+(i=="Before"?0:1)+(p<s?-1:0);this.callHook("ColumnMove",e,{column:e.getColumns()[p],newIndex:a})};r.prototype._onPaste=function(t){this.callHook("Paste",this.getTable(),{data:t.getParameter("data")})};r.prototype._onColumnInsert=function(t){};r.prototype.loadModules=function(){return Promise.reject(this+" does not implement #loadModules")};r.prototype.updateTableByProperty=function(t,e){};r.prototype.removeToolbar=function(){};r.prototype.scrollToIndex=function(t){return Promise.reject()};r.prototype.updateRowSettings=function(){};r.prototype.prepareRowPress=function(){};r.prototype.cleanupRowPress=function(){};r.prototype.createTable=function(t){};r.prototype.getRowBinding=function(){};r.prototype.bindRows=function(t){};r.prototype.isTableBound=function(){};r.prototype.createRowTemplate=function(t){};r.prototype.insertFilterInfoBar=function(t,e){};r.prototype.enableColumnResize=function(){};r.prototype.disableColumnResize=function(){};r.prototype.createColumnResizeMenuItem=function(){};r.prototype.updateRowActions=function(){};r.prototype.updateSortIndicator=function(t,e){};r.prototype.getTableStyleClasses=function(){return[]};r.prototype.onModifications=function(t){};r.prototype.showXConfigState=function(){return false};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/TreeTableType", ["./GridTableType"],e=>{"use strict";let t;const r=e.extend("sap.ui.mdc.table.TreeTableType",{metadata:{library:"sap.ui.mdc"}});r.prototype.loadModules=function(){if(t){return Promise.resolve()}return e.prototype.loadModules.apply(this,arguments).then(()=>new Promise((e,r)=>{sap.ui.require(["sap/ui/table/TreeTable"],r=>{t=r;e()},()=>{r("Failed to load some modules")})}))};r.prototype.createTable=function(e){const r=this.getTable();if(!r||!t){return null}const a=new t(e,this.getTableSettings());a._oProxy._bEnableV4=true;return a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/V4AnalyticsPropertyHelper", ["./PropertyHelper","../util/PropertyHelper"],(e,t)=>{"use strict";const r=e.extend("sap.ui.mdc.table.V4AnalyticsPropertyHelper",{constructor:function(t,r){this._bEnableAggregatableAttribute=true;e.call(this,t,r,{technicallyGroupable:{type:"boolean",default:{value:"attribute:groupable"},inComplexProperty:{valueIfNotAllowed:false}},technicallyAggregatable:{type:"boolean",default:{value:"attribute:aggregatable"},inComplexProperty:{valueIfNotAllowed:false}},additionalProperties:{type:"PropertyReference[]"}})}});r.prototype.validateProperty=function(r,i,n){e.prototype.validateProperty.apply(this,arguments);if(r.groupable&&r.extension?.technicallyGroupable===false){t.throwInvalidPropertyError("A property cannot be groupable when not technically groupable.",r)}if(r.aggregatable&&r.extension?.technicallyAggregatable===false){t.throwInvalidPropertyError("A property cannot be aggregatable when not technically aggregatable.",r)}o(r);a(r,i)};function o(e){if(!e.isKey){return}const r=(e.groupable||e.extension?.technicallyGroupable)===true;const o=(e.aggregatable||e.extension?.technicallyAggregatable)===true;if(!r){t.reportInvalidProperty("A key property must be technically groupable.",e)}if(o){t.throwInvalidPropertyError("A key property must not be technically aggregatable.",e)}}function a(e,r){const o=e.extension?.additionalProperties??[];if(o.length===0){return}const a=(e.groupable||e.extension?.technicallyGroupable)===true;const i=(e.aggregatable||e.extension?.technicallyAggregatable)===true;if(!a&&!i){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is neither technically groupable nor"+" technically aggregatable.",e)}if(a&&i){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is both technically groupable and"+" technically aggregatable.",e)}if(e.groupable){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is groupable.",e)}if(o.includes(e.text)){t.throwInvalidPropertyError("'additionalProperties' must not contain the text.",e)}if(i&&o.includes(e.unit)){t.throwInvalidPropertyError("'additionalProperties' must not contain the unit.",e)}const n=e.key||e.name;let l=false;for(const a of r){const r=a.key||a.name;if(a.text===n){if(o.some(e=>e!==r)){t.throwInvalidPropertyError("This property is the text of another property, and therefore 'additionalProperties'"+" must not contain other properties than the related ID.",e)}l=true}if(a.unit===n){t.throwInvalidPropertyError("This property is the unit of another property, and therefore 'additionalProperties'"+" must be empty.",e)}if(o.includes(r)){if((a.extension?.additionalProperties||[]).includes(n)){t.throwInvalidPropertyError("An additional property must not reference this property in 'additionalProperties'.",e)}const r=(a.groupable||a.extension?.technicallyGroupable)===true;if(!r){t.throwInvalidPropertyError("An additional property must be technically groupable.",e)}const o=(a.aggregatable||a.extension?.technicallyAggregatable)===true;if(o){t.throwInvalidPropertyError("An additional property must not be technically aggregatable.",e)}}}if(l){return}const p=new Set(o);for(const e of p){const t=r.find(t=>(t.key||t.name)===e);for(const e of t.extension?.additionalProperties??[]){p.add(e)}}if(p.difference(new Set(o)).size>0){t.throwInvalidPropertyError("All nested additional properties must be listed at root level.",e)}}r.prototype.prepareProperty=function(t,r){e.prototype.prepareProperty.apply(this,arguments);Object.defineProperty(t,"getAggregatableProperties",{value:function(){return t.getSimpleProperties().filter(e=>e.aggregatable)}})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/menu/GroupHeaderRowContextMenu", ["../utils/Personalization","sap/m/Menu","sap/m/MenuItem","sap/ui/core/Element","sap/ui/core/Lib"],(e,t,n,o,s)=>{"use strict";const i=o.extend("sap.ui.mdc.table.menu.GroupHeaderRowContextMenu",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.core.IContextMenu"],aggregations:{menu:{type:"sap.m.Menu",multiple:false}}}});i.prototype.invalidate=function(){};i.prototype.openAsContextMenu=function(e,t){this.getMenu()?.openAsContextMenu(e,t)};i.prototype.close=function(){this.getMenu()?.close()};i.prototype.initContent=function(e,n){this._iGroupLevel=n.groupLevel;if(!this.getMenu()){this.setMenu(new t({items:[this._createUngroupItem(e)]}))}};i.prototype.isEmpty=function(){return!this.getMenu()?.getItems().some(e=>e.getVisible())};i.prototype._createUngroupItem=function(t){const o=s.getResourceBundleFor("sap.ui.mdc");return new n({text:o.getText("table.TBL_UNGROUP"),visible:"{$sap.ui.mdc.Table>/@custom/activeP13nModes/Group}",items:[new n({text:o.getText("table.TBL_UNGROUP_LEVEL"),press:()=>{const n=t._getGroupedProperties().map(e=>e.name);const o=n[this._iGroupLevel-1];e.createGroupChange(t,{propertyKey:o})}}),new n({text:o.getText("table.TBL_UNGROUP_ALL"),press:()=>{e.createClearGroupsChange(t)}})]})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/menu/QuickActionContainer", ["../utils/Personalization","sap/m/table/columnmenu/QuickActionContainer","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/ui/core/Element","sap/ui/core/library"],(e,t,n,r,o,i,a,s,c,u)=>{"use strict";const g=t.extend("sap.ui.mdc.table.menu.QuickActionContainer",{metadata:{library:"sap.ui.mdc",associations:{table:{type:"sap.ui.mdc.Table"},column:{type:"sap.ui.mdc.table.Column"}}}});g.prototype.initializeQuickActions=function(){const t=this.getTable();const c=this.getColumn();const g=t.getPropertyHelper();this.destroyQuickActions();if(t.isSortingEnabled()){const o=g.getProperty(c.getPropertyKey()).getSortableProperties();const i=t._getSortedProperties();if(o.length>0){this.addQuickAction(new n({items:o.map(e=>{let t=u.SortOrder.None;const n=i.find(t=>t.name===e.name);if(n){t=n.descending?u.SortOrder.Descending:u.SortOrder.Ascending}return new r({key:e.name,label:e.label,sortOrder:t})}),change:function(n){const r=n.getParameter("item");e.createSortChange(t,{propertyKey:r.getKey(),sortOrder:r.getSortOrder()})}}))}}if(t.isGroupingEnabled()){const n=g.getProperty(c.getPropertyKey()).getGroupableProperties();const r=t._getGroupedProperties();if(n.length>0){this.addQuickAction(new o({items:n.map(e=>{const t=r.some(t=>t.name===e.name);return new i({key:e.name,label:e.label,grouped:t})}),change:function(n){e.createGroupChange(t,{propertyKey:n.getParameter("item").getKey()})}}))}}if(t.isAggregationEnabled()){const n=g.getProperty(c.getPropertyKey()).getAggregatableProperties();const r=t._getAggregatedProperties();if(n.length>0){this.addQuickAction(new a({items:n.map(e=>new s({key:e.name,label:e.label,totaled:r.hasOwnProperty(e.name)})),change:function(n){e.createAggregateChange(t,{propertyKey:n.getParameter("item").getKey()})}}))}}if(t.getEnableColumnResize()){this.addQuickAction(t._getType().createColumnResizeMenuItem(c,this.getMenu()))}};g.prototype.updateQuickActions=function(e){const t=this.getTable();const n=t._getSortedProperties();const r=t._getGroupedProperties();const o=t._getAggregatedProperties();this.getQuickActions().forEach(t=>{if((!e||e.includes("Sort"))&&t.isA("sap.m.table.columnmenu.QuickSort")){t.getItems().forEach(e=>{const t=n.find(t=>t.name===e.getProperty("key"));if(t){e.setSortOrder(t.descending?u.SortOrder.Descending:u.SortOrder.Ascending)}else{e.setSortOrder(u.SortOrder.None)}})}else if((!e||e.includes("Group"))&&t.isA("sap.m.table.columnmenu.QuickGroup")){t.getItems().forEach(e=>{const t=r.some(t=>t.name===e.getProperty("key"));e.setGrouped(t)})}else if((!e||e.includes("Aggregate"))&&t.isA("sap.m.table.columnmenu.QuickTotal")){t.getItems().forEach(e=>{const t=o.hasOwnProperty(e.getProperty("key"));e.setTotaled(t)})}})};g.prototype.hasQuickActions=function(){return this.getEffectiveQuickActions().length>0};g.prototype.getTable=function(){return c.getElementById(this.getAssociation("table"))};g.prototype.getColumn=function(){return c.getElementById(this.getAssociation("column"))};return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/table/utils/Personalization", ["sap/ui/mdc/enums/ProcessingStrategy","sap/ui/core/library"],(e,t)=>{"use strict";const n={};n.isUserPersonalizationActive=function(e){return e._bUserPersonalizationActive===true};n.detectUserPersonalizationCompletion=function(e,t){if(!t.isOpen()){return}e._bUserPersonalizationActive=true;t.attachEventOnce("afterClose",()=>{e.getEngine().waitForChanges(e).then(()=>{delete e._bUserPersonalizationActive})})};n.openSettingsDialog=function(e,t){const n=e.getInbuiltFilter();if(n){if(!t){n.setVisibleFields(null)}else{const r=e.getPropertyHelper().getProperty(t.getPropertyKey()).getFilterableProperties();const o=r.map(e=>e.name);n.setVisibleFields(o)}}r(e,e.getActiveP13nModes(),{reset:()=>{e.getEngine().reset(e)}})};n.openFilterDialog=function(e,t){r(e,"Filter",{close:t})};async function r(e,t,n={}){await e.finalizePropertyHelper();const r=e.getEngine();const o=await r.show(e,t,{reset:n.reset,close:()=>{n.close?.();r.waitForChanges(e).then(()=>{delete e._bUserPersonalizationActive})}});if(o){e._bUserPersonalizationActive=true}}n.createSortChange=function(e,n){e.getEngine().createChanges({control:e,key:"Sort",state:[{name:n.propertyKey,descending:n.sortOrder===t.SortOrder.Descending,sorted:n.sortOrder!==t.SortOrder.None}],applyAbsolute:true})};n.createGroupChange=function(e,t){const n=(e.getCurrentState().groupLevels||[]).some(e=>e.name==t.propertyKey);e.getEngine().createChanges({control:e,key:"Group",state:[{grouped:!n,name:t.propertyKey}],applyAbsolute:e._isOfType("ResponsiveTable")})};n.createClearGroupsChange=function(t){t.getEngine().createChanges({control:t,key:"Group",state:[],applyAbsolute:e.FullReplace})};n.createClearFiltersChange=function(t){t.getEngine().createChanges({control:t,key:"Filter",state:[],applyAbsolute:e.FullReplace})};n.createAggregateChange=function(e,t){const n=t.propertyKey in(e.getCurrentState().aggregations||{});e.getEngine().createChanges({control:e,key:"Aggregate",state:[{name:t.propertyKey,aggregated:!n}],applyAbsolute:false})};n.createColumnWidthChange=function(e,t){e.getEngine().createChanges({control:e,key:"ColumnWidth",state:[{name:t.column.getPropertyKey(),width:t.width}],applyAbsolute:false})};n.createColumnReorderChange=function(e,t){const n=e.indexOfColumn(t.column);if(n===t.index){return}e.getEngine().createChanges({control:e,key:"Column",state:[{name:t.column.getPropertyKey(),position:t.index}]})};n.createShowDetailsChange=function(e,t){e.getEngine().createChanges({control:e,key:"ShowDetails",state:[{name:"ResponsiveTable",showDetails:t.showDetails}],applyAbsolute:true})};n.createFixedColumnCountChange=function(e,t){e.getEngine().createChanges({control:e,key:"ColumnFreeze",state:[{name:"GridTable",fixedColumnCount:t.fixedColumnCount}],applyAbsolute:true})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/LinkDelegate", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/ushell/SemanticObjectMapping","sap/ui/mdc/ushell/SemanticObjectMappingItem","sap/ui/mdc/ushell/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],(e,t,n,i,a,c,r,s,o,u,l,m)=>{"use strict";const f=Object.assign({},n);f.fetchLinkItems=function(e,t,n){const i=e.getPayload();const a=t?t.getObject(t.getPath()):undefined;const r=[];if(n){n.initialize(f._getSemanticObjects(i));r.forEach(e=>{n.addIntent(c.IntentType.API,{text:e.getText(),intent:e.getHref()})})}const s=f._calculateSemanticAttributes(a,i,n);return f._retrieveNavigationTargets("",s,i,n).then((e,t)=>Promise.resolve(e))};f.fetchLinkType=function(e){const t=e.getPayload();if(t&&t.semanticObjects){return f.hasDistinctSemanticObjects(t.semanticObjects).then(e=>Promise.resolve({type:e?m.Popover:m.Text,directLink:undefined}))}else{throw new Error("no payload or semanticObjects found")}};f.hasDistinctSemanticObjects=e=>{const t={};let n=null;const i=function(e){return e.filter(e=>!t[e]).length===0};const c=function(e){return e.some(e=>t[e]&&t[e].exists===true)};const s=async()=>{const e=await a.getServiceAsync("Navigation");if(!e){r.error("LinkDelegate: Service 'Navigation' could not be obtained");return Promise.resolve({})}try{const n=await e.getSemanticObjects();n.forEach(e=>{t[e]={exists:true}});return Promise.resolve(t)}catch(e){r.error("LinkDelegate: getSemanticObjects() of service 'Navigation' failed");return Promise.resolve({})}};if(i(e)){return Promise.resolve(c(e))}if(!n){n=s()}return n.then(()=>c(e))};f._calculateSemanticAttributes=function(e,t,n){const i=f._getSemanticObjects(t);const a=f._convertSemanticObjectMapping(f._getSemanticObjectMappings(t));if(!i.length){i.push("")}const c={};i.forEach(t=>{if(n){n.addContextObject(t,e)}c[t]={};for(const i in e){let o=null,u=null;if(n){o=n.getSemanticObjectAttribute(t,i);if(!o){o=n.createAttributeStructure();n.addSemanticObjectAttribute(t,i,o)}}if(e[i]===undefined||e[i]===null){if(o){o.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in LinkDelegate."})}continue}if(s(e[i])){if(o){o.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in LinkDelegate."})}continue}const l=a&&a[t]&&a[t][i]?a[t][i]:i;if(o&&i!==l){u={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+l+" in LinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+t+" with source attribute "+i+" and target attribute "+l+". You can modify the annotation if the mapping result is not what you expected."}}if(c[t][l]){r.error("LinkDelegate: The attribute "+i+" can not be renamed to the attribute "+l+" due to a clash situation. This can lead to wrong navigation later on.")}c[t][l]=e[i];if(o){if(u){o.transformations.push(u);const a=n.createAttributeStructure();a.transformations.push({value:e[i],description:"ℹ The attribute "+l+" with the value "+e[i]+" has been added due to a mapping rule regarding the attribute "+i+" in LinkDelegate."});n.addSemanticObjectAttribute(t,l,a)}}}});return c};f._retrieveNavigationTargets=function(n,c,s,o){if(!s.semanticObjects){return new Promise.resolve([])}const u=s.semanticObjects;const l=s.sourceControl;const m={ownNavigation:undefined,availableActions:[]};return t.load({name:"sap.ui.fl"}).then(()=>{const t=sap.ui.require("sap/ui/fl/Utils");if(!t){return Promise.reject("Could not load 'sap/ui/fl/Utils'!")}const b=a.getServiceAsync("Navigation");const g=a.getServiceAsync("URLParsing");return Promise.all([b,g]).then(a=>{const b=a[0];const g=a[1];if(!b||!g){r.error("LinkDelegate: Service 'Navigation' or 'URLParsing' could not be obtained");return Promise.resolve(m.availableActions,m.ownNavigation)}const d=e.getElementById(l);const p=t.getAppComponentForControl(d);const h=u.map(e=>({semanticObject:e,params:c?c[e]:undefined,appStateKey:n,ui5Component:p,sortResultsBy:"text"}));return b.getLinks(h).then(e=>{if(!e||!e.length){return Promise.resolve(m.availableActions,m.ownNavigation)}const t=f._getSemanticObjectUnavailableActions(s);const n=f._convertSemanticObjectUnavailableAction(t);return b.getHref().then(t=>{if(t&&t.indexOf("?")!==-1){t=t.split("?")[0]}if(t){t+="?"}const a=function(e,t){return!!n&&!!n[e]&&n[e].indexOf(t)>-1};const c=function(e){const n=g.parseShellHash(e.intent);if(a(n.semanticObject,n.action)){return Promise.resolve()}return b.getHref({target:{shellHash:e.intent}},p).then(a=>{if(e.intent&&e.intent.indexOf(t)===0){m.ownNavigation=new i({href:a,text:e.text,internalHref:e.intent});return}const c=new i({key:n.semanticObject&&n.action?n.semanticObject+"-"+n.action:undefined,text:e.text,description:undefined,href:a,internalHref:e.intent,icon:undefined,initiallyVisible:e.tags&&e.tags.indexOf("superiorAction")>-1});m.availableActions.push(c);if(o){o.addSemanticObjectIntent(n.semanticObject,{intent:c.getHref(),text:c.getText()})}})};const r=[];for(let t=0;t<u.length;t++){r.push(e[t].map(c))}return Promise.all(r).then(()=>Promise.resolve(m.availableActions,m.ownNavigation))})})})})};f._getSemanticObjects=function(e){return e.semanticObjects?e.semanticObjects:[]};f._getSemanticObjectUnavailableActions=function(e){const t=[];if(e.semanticObjectUnavailableActions){e.semanticObjectUnavailableActions.forEach(e=>{t.push(new l({semanticObject:e.semanticObject,actions:e.actions}))})}return t};f._getSemanticObjectMappings=function(e){const t=[];let n=[];if(e.semanticObjectMappings){e.semanticObjectMappings.forEach(e=>{n=[];if(e.items){e.items.forEach(e=>{n.push(new u({key:e.key,value:e.value}))})}t.push(new o({semanticObject:e.semanticObject,items:n}))})}return t};f._convertSemanticObjectMapping=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getItems().reduce((e,t)=>{e[t.getKey()]=t.getValue();return e},{})});return t};f._convertSemanticObjectUnavailableAction=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getActions()});return t};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectMapping", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.ushell.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.ushell.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectMappingItem", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.ushell.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/ushell/SemanticObjectUnavailableAction", ["sap/ui/core/Element"],e=>{"use strict";const t=e.extend("sap.ui.mdc.ushell.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/Common", [],()=>{"use strict";const e={cleanup:function(e,s){s.forEach(s=>{const t=e[s];if(t){if(t.destroy&&!t.bIsDestroyed){t.destroy()}e[s]=null}})}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/DateUtil", ["sap/base/i18n/date/CalendarType","sap/ui/core/date/UI5Date","sap/ui/mdc/enums/BaseType","sap/base/util/merge"],(e,t,n,o)=>{"use strict";const s={createInternalType:function(t,n){const s=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));const a=o({},t.getConstraints());const i=o({},t.getFormatOptions());if(i.style){delete i.style}i.pattern=n;i.calendarType=e.Gregorian;if(this.showTimezone(t)){i.showTimezone=false}return new s(i,a)},showTimezone:function(e){const t=e.getFormatOptions();const n=function(e,t){return!e.hasOwnProperty(t)||e[t]};return e.isA("sap.ui.model.odata.type.DateTimeWithTimezone")&&n(t,"showTimezone")&&(n(t,"showDate")||n(t,"showTime"))},typeToString:function(e,t,n){const o=this.createInternalType(t,n);const s=o.formatValue(e,"string");return s},stringToType:function(e,t,n){const o=this.createInternalType(t,n);const s=o.parseValue(e,"string");return s},typeToISO:function(e,n,o){if(n.getISOStringFromModelValue){return n.getISOStringFromModelValue(e)}else{let s=this.typeToDate(e,n,o);if(n.getFormatOptions().UTC){s=t.getInstance(Date.UTC(s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getMinutes(),s.getSeconds(),s.getMilliseconds()))}return s.toISOString()}},ISOToType:function(e,n,o){if(n.getModelValueFromISOString){return n.getModelValueFromISOString(e)}else{let s=t.getInstance(e);if(n.getFormatOptions().UTC){s=t.getInstance(s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate(),s.getUTCHours(),s.getUTCMinutes(),s.getUTCSeconds(),s.getUTCMilliseconds())}return this.dateToType(s,n,o)}},dateToType:function(e,o,s){let a;if(o.getModelValue){a=o.getModelValue(e)}else if(o.isA("sap.ui.model.type.DateTime")&&o.getFormatOptions().UTC){a=t.getInstance(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()))}else{const t=o.getModelFormat();const i=o.getFormatOptions();const r=s===n.DateTime?!!i.UTC:false;a=t.format(e,r)}return a},typeToDate:function(e,o,s){let a;if(o.getDateValue){a=o.getDateValue(e)}else if(o.isA("sap.ui.model.type.DateTime")&&o.getFormatOptions().UTC){a=t.getInstance(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}else{const t=o.getModelFormat();const i=o.getFormatOptions();const r=s===n.DateTime?!!i.UTC:false;a=t.parse(e,r)}return a}};return s});
/*
 * ! OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/DensityHelper", ["sap/ui/thirdparty/jquery","sap/ui/base/Object"],function(jQuery,n){"use strict";const e=["sapUiSizeCozy","sapUiSizeCompact","sapUiSizeCondensed"];const t=e[0];const s=function(n,t){if(!t||!t[n]){return undefined}for(let s=0;s<e.length;s++){if(t[n](e[s])){return e[s]}}return undefined};const i=function(t){const i=!n.isA(t,"sap.ui.core.Control");return i?s("hasClass",jQuery(t).closest("."+e.join(",."))):s("hasStyleClass",t)};const o={};o.syncDensity=function(n,e){if(!i(n)){const s=e&&i(e)||i(document.body)||t;return n.addStyleClass(s)}return undefined};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/FilterUtil", ["sap/ui/mdc/util/IdentifierUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/condition/ConditionConverter","sap/ui/mdc/condition/FilterConverter","sap/base/Log","sap/base/util/merge"],(e,t,i,n,r,o,s)=>{"use strict";const a=function(e){if(e&&e.getTypeMap){return e.getTypeMap()}if(e&&e.getTypeUtil){return e.getTypeUtil()}return e};const l={getPropertyByKey:function(t,i){let n=null;t.some(t=>{if(e.getPropertyPath(t)===i){n=t}return n!=null});if(!n){t.some(t=>{if(e.getPropertyKey(t)===i){n=t}return n!=null})}return n},getConditionsMap:function(e,n){let r,s;const a={};if(!e||!e.isA("sap.ui.mdc.FilterBar")){o.error("instance of sap.ui.mdc.FilterBar expected");return a}const l=e.getInternalConditions();for(const e in l){if(n.indexOf(e)>=0){r=[];if(l[e]){for(let n=0;n<l[e].length;n++){s={};s.operator=l[e][n].operator;if(s.operator===i.EQ&&l[e][n].validated===t.Validated){s.values=[l[e][n].values[0]]}else{s.values=l[e][n].values}r.push(s)}a[e]=r}}}return a},getFilterInfo:function(e,t,i,u){const p={};let c={};if(i&&i.length>0){Object.keys(t).forEach(e=>{const n=i.find(t=>t.name===e);const r=n&&n.path?n.path:e;c[r]=t[e]})}else{c=t}u=u?u:[];let f,d,g;const y={};const m={};if(i&&i.length>0){for(d in c){if(u.indexOf(d)<0){const t=l.getPropertyByKey(i,d);if(t){m[d]={type:t.typeConfig.typeInstance,caseSensitive:t.caseSensitive,baseType:t.typeConfig.baseType};y[d]=[];for(f=0;f<c[d].length;f++){g=s({},c[d][f]);y[d].push(n.toType(g,t.typeConfig.typeInstance,a(e)))}}else{o.error("sap.ui.mdc.util.FilterUitl.js :","could not find propertyMetadata of : "+d)}}}if(Object.keys(y).length>0){p.filters=r.createFilters(y,m)}}return p},getRequiredFieldNamesWithoutValues:function(e){const t=[];if(e&&e._getRequiredPropertyNames&&e._getConditionModel){e._getRequiredPropertyNames().forEach(i=>{const n=e._getConditionModel().getConditions(i);if(!n||n.length===0){t.push(i)}})}return t}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/IdentifierUtil", ["sap/ui/base/DataType"],e=>{"use strict";const t={replace:function(t){const r=function(){return"_"+Date.now().toString(36)+Math.random().toString(36).substring(2,12).padStart(12,0)+"_"};const n=e.getType("sap.ui.core.ID");if(!n.isValid(t)){t=t.replace(/[^A-Za-z0-9_.:]+/g,r())}return t},getFilterFieldId:function(e,r){return e.getId()+"--filter--"+t.replace(r)},getPropertyKey:function(e){return e.key||e.name},getPropertyPath:function(e){return e.path},getView:function(e){let t=null;if(e){let r=e.getParent();while(r){if(r.isA("sap.ui.core.mvc.View")){t=r;break}r=r.getParent()}}return t}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/InfoBar", ["sap/ui/core/Control","sap/m/OverflowToolbar","sap/ui/core/Lib","sap/ui/mdc/util/InfoBarRenderer","sap/m/Text","sap/ui/core/InvisibleText","sap/m/Label","sap/m/Button","sap/m/library","sap/m/ToolbarSpacer"],(t,e,i,s,o,r,n,l,a,p)=>{"use strict";const h=t.extend("sap.ui.mdc.util.InfoBar",{metadata:{library:"sap.ui.mdc",properties:{infoText:{type:"string"}},aggregations:{_toolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"}},events:{press:{parameters:{srcControl:{type:"sap.ui.core.Control"}}},removeAllFilters:{parameters:{}}}},renderer:s});h.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);this.setInfoText(this.getInfoText())};h.prototype.init=function(){this.setVisible(false);this.oText=new o({wrapping:false});this.oInvisibleText=(new r).toStatic();this.oRemoveAllFiltersBtn=new l(this.getId()+"-RemoveAllFilters",{type:a.ButtonType.Transparent,press:function(t){this.fireRemoveAllFilters()}.bind(this),icon:"sap-icon://decline",tooltip:i.getResourceBundleFor("sap.ui.mdc").getText("infobar.REMOVEALLFILTERS")});const t=new e(this.getId()+"--bar",{design:"Info",active:true,content:[this.oText,new p,this.oRemoveAllFiltersBtn]});t.attachPress(t=>{this.firePress({srcControl:t})});this.setAggregation("_toolbar",t)};h.prototype.setInfoText=function(t){this.setProperty("infoText",t);this.setVisible(!!t);if(this.oText&&this.oInvisibleText){this.oText.setText(t);this.oInvisibleText.setText(t)}return this};h.prototype.getACCTextId=function(){return this.oInvisibleText.getId()};h.prototype.exit=function(){if(this.oInvisibleText){this.oInvisibleText.destroy();this.oInvisibleText=null}if(this.oText){this.oText.destroy();this.oText=null}if(this.oRemoveAllFiltersBtn){this.oRemoveAllFiltersBtn.destroy();this.oRemoveAllFiltersBtn=null}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/InfoBarRenderer", ["../library"],e=>{"use strict";const r={apiVersion:2};r.render=function(e,r){e.openStart("div",r);e.attr("id",r.getId());e.openEnd();e.renderControl(r.getAggregation("_toolbar"));e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/PromiseCache", ["sap/ui/base/Object"],e=>{"use strict";const t=function(e){if(!e){throw new Error("PromiseCache: Please provide an identifier!")}if(this._oCache&&this._oCache[e]){this.remove.call(this,e)}};const i=function(e){if(typeof e==="object"&&this._oCache){for(const t in this._oCache){if(this._oCache[t].promise===e){return t}}}};const n=function(e,t){const n=typeof e==="string"?e:i.call(this,e);const o=n&&this._oCache&&this._oCache[n];if(t&&!o){throw new Error("PromiseCache: Promise not found!")}return o};const o=e.extend("sap.ui.mdc.util.PromiseCache",{constructor:function(){this._oCache={}},add:function(e,i){t.call(this,e);const n={};this._oCache[e]=n;n.promise=new Promise((e,t)=>{n.resolve=function(t){if(!n._isCanceled){n._isSettled=true;e(t)}};n.reject=function(e){if(!n._isCanceled){n._isSettled=true;t(e)}}});n.promise.isSettled=function(){return!!n._isSettled};n.promise.isPending=function(){return!n._isSettled&&!n._isCanceled};n.promise.isCanceled=function(){return!!n._isCanceled};n.promise.getInternalPromise=function(){return n._promise};if(i){const e=typeof i==="function";const t=!e&&typeof i.then==="function";if(!e&&!t){throw new Error("PromiseCache: fnCreate must be a promise or function")}const o=e?i():i;const s=o&&typeof o.then==="function";if(s){n._promise=o;n._promise.then(e=>{if(!n._isCanceled){n._isSettled=true;n.resolve(e)}return e},e=>{if(!n._isCanceled){n._isSettled=true;n.reject(e)}})}else{n.resolve(o)}}return this._oCache[e].promise},cancel:function(e){const t=n.call(this,e,true);if(!t._isSettled){t._isCanceled=true}return t.promise},retrieve:function(e,t){const i=this._oCache&&this._oCache[e];if(!i&&t){return this.add(...[e,t])}return i&&i.promise},retrieveMany:function(){const e=[];const t=arguments.length?[].slice.call(arguments):Object.keys(this._oCache);for(let i=0;i<t.length;i++){e.push(this.retrieve(t[i].toString()))}return e},remove:function(e){const t=typeof e==="string"?e:i.call(this,e);const n=t&&this._oCache&&this._oCache[t];if(n){n._isCanceled=true;delete this._oCache[t]}},resolve:function(e,t){const i=n.call(this,e,true);i.resolve(t);return i.promise},reject:function(e,t){const i=n.call(this,e,true);i.reject(t);return i.promise},clear:function(){Object.keys(this._oCache).forEach(e=>{this.remove(e)})},destroy:function(){this.clear();this._oCache=null}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/PropertyHelper", ["sap/ui/base/Object","sap/ui/base/DataType","sap/base/util/merge","sap/base/util/isPlainObject","sap/base/Log","sap/ui/core/Lib","sap/base/util/deepEqual","sap/ui/mdc/util/PropertyHelperUtil","sap/base/future"],(e,t,r,o,n,i,a,p,s)=>{"use strict";const l={key:{type:"string",mandatory:true,inComplexProperty:{allowed:true}},label:{type:"string",mandatory:true,inComplexProperty:{allowed:true}},tooltip:{type:"string",inComplexProperty:{allowed:true}},visible:{type:"boolean",default:{value:true},inComplexProperty:{allowed:true}},path:{type:"string"},dataType:{type:"string",mandatory:true},formatOptions:{type:"object"},constraints:{type:"object"},maxConditions:{type:"int",default:{value:-1}},caseSensitive:{type:"boolean",default:{value:true}},group:{type:"string",inComplexProperty:{allowed:true}},groupLabel:{type:"string",inComplexProperty:{allowed:true}},filterable:{type:"boolean",default:{value:true},inComplexProperty:{valueIfNotAllowed:false}},sortable:{type:"boolean",default:{value:true},inComplexProperty:{valueIfNotAllowed:false}},propertyInfos:{type:"PropertyReference[]",inComplexProperty:{allowed:true}}};const u={key:"name"};const f={isComplex:function(e){return T.isPropertyComplex(this)},getSimpleProperties:function(e){if(!y.get(e)){return[]}if(this.isComplex()){return this.propertyInfos.map(t=>e.getProperty(t))}else{return[this]}},getSortableProperties:function(e){return this.getSimpleProperties().filter(e=>e.sortable)},getFilterableProperties:function(e){return this.getSimpleProperties().filter(e=>e.filterable)}};const c=["key","label","tooltip","visible","path","dataType","formatOptions","constraints","maxConditions","group","groupLabel","caseSensitive"];const y=new WeakMap;function d(e,t){let r="";if(!t){r=`Invalid property definition: ${e}`}else if(Array.isArray(t)){const o=t.map(e=>`'${Object.keys(e)[0]}'`).join(",");r=`Invalid property definition for properties with keys ${o}: ${e}`}else{const o=t.key??t.name;r=`Invalid property definition for property with key '${o}': ${e}`}return r}function P(e,t){const r=d(e,t);if(p.bValidationException){s.errorThrows(r,{suffix:`Migrate this control's propertyInfo to avoid breaking changes in the future.`})}else{b(e,t)}}function b(e,t){const r=d(e,t);throw new Error(r)}function m(e,t){t.map(t=>{Object.keys(f).forEach(r=>{Object.defineProperty(t,r,{value:function(){return f[r].call(this,e)},writable:true})})})}function g(e){const t=Object.getOwnPropertyNames(e);Object.freeze(e);for(let r=0;r<t.length;r++){const n=e[t[r]];if(typeof n==="function"){Object.freeze(n)}else if(o(n)&&!Object.isFrozen(n)){g(n)}else if(Array.isArray(n)){g(n)}}}function h(e,t){if(!t){return e}return t.split(".").reduce((e,t)=>e&&e[t]?e[t]:null,e)}function v(e){let r;if(typeof e==="object"){r="object"}else{r=e.replace("PropertyReference","string")}return t.getType(r)}function x(e){const t=v(e);if(t.isArrayType()){return t.getBaseType().getDefaultValue()}else{return t.getDefaultValue()}}function w(e,t,r){t.forEach(t=>{e.prepareProperty(t,r)});g(t)}function C(e,t,r,o,n,i){const a=o==null;let p=[];const s=T.isPropertyComplex(t);if(a){i=y.get(e).mAttributeMetadata;n=t}if(!n){return[]}for(const l in i){const u=i[l];const f=a?l:o+"."+l;const c=n[l];if(s&&!u.inComplexProperty.allowed){if("valueIfNotAllowed"in u.inComplexProperty){n[l]=u.inComplexProperty.valueIfNotAllowed}continue}if(c!=null&&typeof u.type==="string"&&u.type.startsWith("PropertyReference")||f==="propertyInfos"){continue}if(c==null){j(n,u,o,l,p,c)}if(typeof u.type==="object"){p=p.concat(C(e,t,r,f,n[l],u.type))}}return p}function j(e,t,o,n,i,a){const p=t.default;if(p.ignoreIfNull&&a===null){return}if(typeof p.value==="string"&&p.value.startsWith("attribute:")){i.push({source:p.value.substring(p.value.indexOf(":")+1),targetPath:o,targetAttribute:n,targetType:t.type})}else if(Array.isArray(p.value)){e[n]=r([],p.value)}else if(typeof p.value==="object"&&p.value!==null){e[n]=r({},p.value)}else{e[n]=p.value}}function A(e){return Object.freeze(e.reduce((e,t)=>{e[t.key]=t;return e},{}))}function O(e,t){for(const r in e){const o=e[r];const n=!t;o.mandatory=o.mandatory===true&&n;o.default={...o.default};o.default.value=o.default.value??x(o.type);o.inComplexProperty={...o.inComplexProperty};if(o.inComplexProperty.allowed===true){o.inComplexProperty.allowed=n||t.inComplexProperty.allowed===true}else if(!("allowed"in o.inComplexProperty)){const e=t?.inComplexProperty.allowed===true&&t?.inComplexProperty.propagateAllowance!==false;o.inComplexProperty.allowed=e}if(typeof o.type==="object"){O(o.type,o)}delete o.inComplexProperty.propagateAllowance}}function I(e,t){if(!Array.isArray(t)){b("Property infos must be an array.")}const o=y.get(e);const n=r([],t);e.validateProperties(n,o.aPreviousRawProperties);const i=M(n);const a=A(i);m(e,i);w(e,i,a);e._validatePropertyConsistency(i,o.aProperties);o.aProperties=i;o.mProperties=a;o.aPreviousRawProperties=r([],t)}function M(e){const t=Object.entries(u);return e.map(e=>{const r={...e};t.forEach(([t,o])=>{if(t in e&&o in e&&e[t]!==e[o]){b(`The values of legacy-attribute '${o}' and it's replacement '${t}' must be identical.`,e)}if(!(t in e)&&o in e){r[t]=e[o]}if(!(o in e)&&t in e){r[o]=e[t]}});return r})}function k(e){return e.key||u["key"]&&e[u["key"]]}const T=e.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(t,r,o){e.call(this);if(r&&!e.isObjectA(r,"sap.ui.base.ManagedObject")){throw new Error("The type of the parent is invalid.")}Object.keys(o||{}).forEach(e=>{if(e in l&&o[e]!==true){throw new Error("The attribute '"+e+"' is reserved and cannot be overridden by additional attributes.")}});const n={};const i=Object.keys(o||{});n.mAttributeMetadata=c.concat(i).reduce((e,t)=>{e[t]=t in l?l[t]:o[t];return e},{});O(n.mAttributeMetadata);n.aMandatoryAttributes=Object.keys(n.mAttributeMetadata).filter(e=>n.mAttributeMetadata[e].mandatory);n.oParent=r||null;y.set(this,n);this.setProperties(t)}});T.prototype.validateProperties=function(e,t){const r=new Set;for(let o=0;o<e.length;o++){this.validateProperty(e[o],e,t);r.add(k(e[o]))}if(r.size!==e.length){b("Properties do not have unique keys.")}};T.prototype._validatePropertyConsistency=function(e,t){if(t?.length){const r=y.get(this);const{mAttributeMetadata:o}=r;const n=[];for(const r of t){const t=k(r);const i=e.find(e=>k(e)===t);if(!i){n.push({[t]:"PROPERTY_MISSING"})}else{const e=Object.entries(o).reduce((e,[t,o])=>{if(!a(r[t],i[t])){return[...e,{[t]:[r[t],i[t]]}]}return e},[]);if(e.length){n.push({[t]:e})}}}if(n.length){P(`Detected property info modifications after update:`,n)}}};T.prototype.validateProperty=function(e,t,r){if(!o(e)){b("Property info must be a plain object.")}E(this,e,t);if(T.isPropertyComplex(e)){if(!e.propertyInfos||e.propertyInfos.length===0){b("Complex property does not reference existing properties.",e)}}const n=y.get(this);n.aMandatoryAttributes.forEach(t=>{const r=n.mAttributeMetadata[t];const o=r.inComplexProperty.allowed;const i=u[t];const a=i&&i in e;const p=a?e[i]==null:e[t]==null;if(p&&T.isPropertyComplex(e)&&!o){return}if(!(t in e||a)){P("Property does not contain mandatory attribute '"+t+"'.",e)}else if(p){b("Property does not contain mandatory attribute '"+t+"'.",e)}})};function E(e,t,r,o,n,i){const a=o==null;if(a){i=y.get(e).mAttributeMetadata;n=t}for(const p in n){let s=i[p];const l=a?p:o+"."+p;const f=n[p];if(!s){s=i[Object.entries(u).find(e=>e[1]===p)?.[0]]}if(!s){P("Property contains invalid attribute '"+l+"'.",t)}else if(T.isPropertyComplex(t)&&!s.inComplexProperty.allowed){P("Complex property contains invalid attribute '"+l+"'.",t)}else if(typeof s.type==="object"&&f&&typeof f==="object"){E(e,t,r,l,f,s.type)}else if(f!=null&&!v(s.type).isValid(f)){b("The value of '"+l+"' is invalid.",t)}else if(f&&typeof s.type==="string"&&s.type.startsWith("PropertyReference")){S(e,t,r,l,f,s)}}}function S(e,t,r,o,n,i){const a=i.type.endsWith("[]")?n:[n];const p=new Set(a);if(a.indexOf(k(t))>-1){b("Property references itself in the '"+o+"' attribute.",t)}if(p.size!==a.length){b("Property contains duplicate names in the '"+o+"' attribute.",t)}for(let e=0;e<r.length;e++){if(p.has(k(r[e]))){if(T.isPropertyComplex(r[e])){b("Property references complex properties in the '"+o+"' attribute.",t)}p.delete(k(r[e]))}}if(p.size>0){b("Property references non-existing properties in the '"+o+"' attribute.",t)}}T.prototype.prepareProperty=function(e,t){const r=C(this,e,t);r.forEach(t=>{const r=h(e,t.targetPath);if(r){let o=h(e,t.source);if(o==null){o=x(t.targetType)}r[t.targetAttribute]=o}})};T.prototype.getParent=function(){const e=y.get(this);return e?e.oParent:null};T.prototype.setProperties=function(e){I(this,e)};T.prototype.getProperties=function(){const e=y.get(this);return e?e.aProperties:[]};T.prototype.getPropertyMap=function(){const e=y.get(this);return e?e.mProperties:{}};T.prototype.getProperty=function(e){return this.getPropertyMap()[e]||null};T.prototype.hasProperty=function(e){return e in this.getPropertyMap()};T.isPropertyComplex=function(e){return e!=null&&typeof e==="object"?"propertyInfos"in e:false};T.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);y.delete(this)};T.prototype._getAttributeMetadata=function(){const e=y.get(this);return e?r({},e.mAttributeMetadata):null};T.prototype.getRedundantProperties=function(){return[]};Object.defineProperties(T,{reportInvalidProperty:{value:P},throwInvalidPropertyError:{value:b}});return T});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/PropertyHelperUtil", ["sap/ui/core/Lib","sap/ui/VersionInfo","sap/ui/base/Object"],(i,a,n)=>{"use strict";const t={};t.checkValidationExceptions=async function(){if(this.bValidationException===null||this.bValidationException===undefined){this.bValidationException=await this._checkValidationExceptions()}return Promise.resolve(this.bValidationException)};t._checkValidationExceptions=async function(){const n=["sap.fe.core","sap.fe.macros","sap.sac.df"];const t=n.filter(a=>i.isLoaded(a));const e=await a.load();const o=window["sap-ui-mdc-config"]&&window["sap-ui-mdc-config"].disableStrictPropertyInfoValidation;const s=new URLSearchParams(window.location.search).get("sap-ui-xx-disableStrictPropertyValidation")=="true";const c=t.includes("sap.fe.core")||t.includes("sap.fe.macros");const r=t.includes("sap.sac.df");const d=new URLSearchParams(window.location.search).get("sap-ui-xx-enableStrictPropertyValidation")=="true";const p=e.version.indexOf("2.")===0;return(o||s||c||r)&&!d&&!p};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/TypeMap", ["sap/ui/mdc/enums/BaseType","sap/ui/model/SimpleType","sap/base/util/ObjectPath","sap/ui/mdc/util/DateUtil","sap/ui/mdc/util/loadModules","sap/base/util/merge","sap/base/future"],(e,t,a,n,s,i,r)=>{"use strict";const o="yyyy-MM-dd";const u="HH:mm:ss";const p=new WeakMap;const c={};c._get=function(e){const t=this._getMap().get(e);if(typeof t==="string"){return this._get(t)}else if(t){return[e,t]}};c._set=function(e,t){const a=this._getMap();if(a._bFrozen){throw"TypeMap: You must not modify a frozen TypeMap"}a.set(e,t)};c._getMap=function(){let e=p.get(this);if(!e){e=new Map;p.set(this,e)}return e};c.set=function(e,t,a){this._set(e,[t,a])};c.setAlias=function(e,t){this._set(e,t)};c._getBaseType=function(e){const t=this._get(e);return t&&t[1][0]};c._getOptions=function(e){const t=this._get(e);return t&&t[1][1]};c._getClass=function(e){const t=this._get(e);return t&&t[0]};c.export=function(){return Array.from(this._getMap())};c.import=function(e){e.export().forEach(e=>{this._getMap().set(e[0],e[1])})};c.freeze=function(){this._getMap()._bFrozen=true};c.getBaseType=function(t,a,n){const s=this._getBaseType(t);return s&&(typeof s==="function"?s(a,n):s)||e.String};c.getBaseTypeForType=function(e){return this.getBaseType(e.getMetadata&&e.getMetadata().getName(),e.getFormatOptions(),e.getConstraints())};c.getDataTypeClassName=function(e){return this._getClass(e)||e};c.getDataTypeClass=function(e){const t=this.getDataTypeClassName(e);let n;if(t){n=sap.ui.require(t.replace(/\./g,"/"));if(!n){n=a.get(t);if(n){r.errorThrows("DataType '"+e+"' module not loaded.",{suffix:"Load data type module before it is used, e.g. using TypeMap.retrieveDataTypeClasses."})}}}if(!n){throw new Error("DataType '"+e+"' cannot be determined")}return n};c.retrieveDataTypeClasses=function(e){const t=[];e.forEach(e=>{const a=this.getDataTypeClassName(e);t.push(a.replace(/\./g,"/"))});return new Promise((e,a)=>{s(t).then(t=>{e(t)}).catch(e=>{a(e)})})};c.getDataTypeInstance=function(e,t,a,n){const s=this.getDataTypeClass(e);const r=this._getOptions(s.getMetadata().getName());const o=r&&r(i({},t),i({},a),n);t=o&&o[0]||t;a=o&&o[1]||a;return new s(t,a)};c.getTypeConfig=function(e,t,a){const n=this._normalizeType.call(this,e,t,a);return{className:n.getMetadata().getName(),typeInstance:n,baseType:this.getBaseTypeForType(n)}};c.externalizeValue=function(t,a,s,i){const r=this._normalizeType.call(this,a,s,i);const p=this.getBaseTypeForType(r);switch(p){case e.DateTime:return n.typeToISO(t,r,p);case e.Date:return n.typeToString(t,r,o);case e.Time:return n.typeToString(t,r,u);case e.Boolean:return t;case e.Numeric:if(typeof t!=="string"&&(r.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||r.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return t.toString()}return t;default:return r.formatValue(t,"string")}};c.internalizeValue=function(t,a,s,i){const r=this._normalizeType.call(this,a,s,i);const p=this.getBaseTypeForType(r);switch(p){case e.DateTime:return n.ISOToType(t,r,p);case e.Date:if(t.indexOf("T")>=0){t=t.substr(0,t.indexOf("T"))}return n.stringToType(t,r,o);case e.Time:return n.stringToType(t,r,u);case e.Boolean:return t;case e.Numeric:if(typeof t!=="string"&&(r.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||r.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return t.toString()}return t;default:return r.parseValue(t,"string")}};c._normalizeType=function(e,a,n){if(e instanceof t){return e}return this.getDataTypeInstance(e,a,n)};c.initializeTypeFromValue=function(e,t){return{}};c.initializeInternalType=function(e,t){};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/TypeUtil", ["sap/ui/mdc/enums/BaseType","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/model/SimpleType","sap/ui/mdc/util/DateUtil"],(e,t,a,n,s,r)=>{"use strict";const i="yyyy-MM-dd";const o="HH:mm:ss";const u={getDataTypeClassName:function(e){const t={Boolean:"sap.ui.model.type.Boolean",Currency:"sap.ui.model.type.Currency",Date:"sap.ui.model.type.Date",DateTime:"sap.ui.model.type.DateTime",Float:"sap.ui.model.type.Float",Integer:"sap.ui.model.type.Integer",String:"sap.ui.model.type.String",Time:"sap.ui.model.type.Time",Unit:"sap.ui.model.type.Unit"};if(t[e]){e=t[e]}return e},getBaseType:function(t,a,n){switch(t){case"sap.ui.model.type.Date":return e.Date;case"sap.ui.model.type.DateTime":return e.DateTime;case"sap.ui.model.type.Time":return e.Time;case"sap.ui.model.type.Boolean":return e.Boolean;case"sap.ui.model.type.Unit":case"sap.ui.model.type.Currency":if(!a||(!a.hasOwnProperty("showMeasure")||a.showMeasure)&&(!a.hasOwnProperty("showNumber")||a.showNumber)){return e.Unit}else if(!a.hasOwnProperty("showNumber")||a.showNumber){return e.Numeric}else{return e.String}case"sap.ui.model.type.Integer":case"sap.ui.model.type.Float":return e.Numeric;default:return e.String}},getBaseTypeForType:function(e){return this.getBaseType(e.getMetadata&&e.getMetadata().getName(),e.getFormatOptions(),e.getConstraints())},getDataTypeClass:function(e){const a=this.getDataTypeClassName(e);const n=a?sap.ui.require(a.replace(/\./g,"/"))||t.get(a):undefined;if(!n){throw new Error("DataType '"+e+"' cannot be determined")}return n},getDataTypeInstance:function(e,t,a){const n=this.getDataTypeClass(e);return new n(t,a)},getTypeConfig:function(e,t,a){const n=this._normalizeType(e,t,a);return{className:n.getMetadata().getName(),typeInstance:n,baseType:this.getBaseTypeForType(n)}},internalizeValue:function(t,a,n,s){const u=this._normalizeType(a,n,s);const p=this.getBaseTypeForType(u);switch(p){case e.DateTime:return r.ISOToType(t,u,p);case e.Date:if(t.indexOf("T")>=0){t=t.substr(0,t.indexOf("T"))}return r.stringToType(t,u,i);case e.Time:return r.stringToType(t,u,o);case e.Boolean:return t;case e.Numeric:return t;default:return u.parseValue(t,"string")}},externalizeValue:function(t,a,n,s){const u=this._normalizeType(a,n,s);const p=this.getBaseTypeForType(u);switch(p){case e.DateTime:return r.typeToISO(t,u,p);case e.Date:return r.typeToString(t,u,i);case e.Time:return r.typeToString(t,u,o);case e.Boolean:return t;case e.Numeric:return t;default:return u.formatValue(t,"string")}},_normalizeType:function(e,t,a){if(e instanceof s){return e}return this.getDataTypeInstance(e,t,a)},getUnitTypeInstance:function(e,t,s){const r=e.getMetadata().getClass();const i=n({},e.getFormatOptions());const o=a(e.getConstraints())?undefined:n({},e.getConstraints());this._adjustUnitFormatOptions(i,t,s);return new r(i,o)},_adjustUnitFormatOptions:function(e,t,a){e.showNumber=t;e.showMeasure=a;e.strictParsing=true},initializeTypeFromValue:function(e,t){return{}},initializeInternalType:function(e,t){}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/util/loadModules", ["sap/ui/base/SyncPromise","sap/base/assert"],(r,e)=>{"use strict";return function s(t){e(typeof t==="string"||Array.isArray(t),"vModulePaths"+" param either must be a single string or an array of strings. - sap.ui.mdc.util.loadModules");let a;if(typeof t==="string"){a=[t]}else{a=t}const n=new Map;a.forEach(r=>{const e=sap.ui.require(r);n.set(r,e)});const i=a.filter(r=>n.get(r)===undefined);if(i.length===0){const e=Array.from(n.values());return r.resolve(e)}return new r((r,e)=>{function s(){const e=Array.from(arguments);i.forEach((r,s)=>{n.set(r,e[s])});const s=Array.from(n.values());r(s)}sap.ui.require(i,s,e)})}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/CollectiveSearchSelect", ["sap/m/VariantManagement","sap/ui/core/Lib"],(t,e)=>{"use strict";const o=t.extend("sap.ui.mdc.valuehelp.CollectiveSearchSelect",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Misc",defaultValue:null},selectedItemKey:{type:"string",group:"Misc",defaultValue:null}}},renderer:t.getMetadata().getRenderer()});o.prototype.init=function(){t.prototype.init.apply(this);this.oRb=e.getResourceBundleFor("sap.ui.mdc")};o.prototype.applySettings=function(e,o){t.prototype.applySettings.apply(this,arguments);this.setShowFooter(false);this.setProperty("_selectStategyForSameItem",false);this._createIllustratedMessages();this._oNoDataFoundIllustratedMessage.setTitle(this.oRb.getText("COL_SEARCH_SEL_NODATA_FOUND"));this.oVariantPopoverTrigger.setTooltip(this.oRb.getText("COL_SEARCH_TRIGGER_TT"))};o.prototype.setTitle=function(t){this.setProperty("title",t);this.setPopoverTitle(t);return this};o.prototype.getTitle=function(){return this.getProperty("title")};o.prototype.getCurrentText=function(){return t.prototype.getTitle.apply(this,arguments).getText()};o.prototype.setSelectedItemKey=function(t){this.setProperty("selectedItemKey",t);this.setSelectedKey(t);return this};o.prototype.getSelectedItemKey=function(){return this.getSelectedKey()};o.prototype._setInvisibleText=function(t){this.oVariantInvisibleText.setText(this.oRb.getText("COL_SEARCH_SEL_INVISIBLETXT",[t]))};o.prototype.exit=function(){t.prototype.exit.apply(this);this.oRb=undefined};o.prototype.getOverflowToolbarConfig=function(){const e=t.prototype.getOverflowToolbarConfig.apply(this);e.canOverflow=true;return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/Dialog", ["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/valuehelp/base/DialogTab","sap/ui/mdc/util/loadModules","sap/ui/Device","sap/m/VBox","sap/m/FlexItemData","sap/ui/model/resource/ResourceModel","sap/ui/mdc/util/Common","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/strings/formatMessage","sap/base/i18n/Localization","sap/ui/core/library","sap/ui/core/InvisibleMessage","sap/ui/mdc/util/DensityHelper"],(e,t,n,o,i,s,l,a,r,c,u,p,d,h,g)=>{"use strict";let f=e.getResourceBundleFor("sap.ui.mdc");p.attachChange(()=>{f=e.getResourceBundleFor("sap.ui.mdc")});let y,C,m,_,b,T;let I,S,v,M,k;const{InvisibleMessageMode:P}=d;const B=t.extend("sap.ui.mdc.valuehelp.Dialog",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.IDialogContainer","sap.ui.core.PopupInterface"],properties:{_selectedContentKey:{type:"string",visibility:"hidden"},_quickSelectEnabled:{type:"boolean",visibility:"hidden",defaultValue:false},_selectableContents:{type:"object[]",visibility:"hidden",defaultValue:[]},groupConfig:{type:"object",defaultValue:{}}},defaultAggregation:"content"}});function x(){if(i.system.desktop){return"700px"}if(i.system.tablet){return i.orientation.landscape?"600px":"600px"}}function E(){if(i.system.desktop){return"1080px"}if(i.system.tablet){return i.orientation.landscape?"920px":"600px"}}function O(e){const t=this.getContent();return t.filter(t=>!!t.getVisible()&&t.getGroup&&t.getGroup()===e).length>1}B.prototype._handleContentSelectionChange=function(e,t){this.fireRequestDelegateContent({container:this.getId(),contentId:e});return this.getRetrieveDelegateContentPromise().then(()=>{const n=this.getProperty("_selectedContentKey");const o=this.getContent();const i=n&&o&&o.find(e=>e.getId()===n);if(i){if(i.setCollectiveSearchSelect){i.setCollectiveSearchSelect(undefined)}i.onHide();this.unbindContentFromContainer(i)}return this._renderSelectedContent(e,undefined,t)})};B.prototype._onTabBarSelect=function(e){const t=e&&e.getParameter("key");this._handleContentSelectionChange(t)};B.prototype.invalidate=function(e){if(e){const n=this.getContent();const o=n.indexOf(e);if(this._oIconTabBar&&o!==-1&&!this.isDestroyStarted()){const t=this._oIconTabBar.getItems();if(t[o]){t[o].invalidate(e)}}else{t.prototype.invalidate.apply(this,arguments)}}};B.prototype.getUIAreaForContent=function(){const e=this.getAggregation("_container");if(e){return e.getUIArea()}return t.prototype.getUIAreaForContent.apply(this,arguments)};B.prototype.handleConfirmed=function(e){this.fireConfirm({close:true})};B.prototype.handleClosed=function(e){const n=this.getSelectedContent();if(n){n.onHide()}this.getContent().forEach(e=>{e.onContainerClose()});this.setProperty("_selectedContentKey",this._sInitialContentKey);t.prototype.handleClosed.apply(this,arguments)};B.prototype.getContainerControl=function(){if(!this.getModel("$i18n")){this.setModel(new a({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}const t=this.getAggregation("_container");if(!t){return this._retrievePromise("dialog",()=>o(["sap/m/Dialog","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/m/library"]).then(t=>{y=t[0];m=t[1];_=t[2];C=t[3];if(this.isDestroyStarted()){return null}const{ButtonType:n}=C;if(!this._oResourceBundle){this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")}this.oButtonOK=new m(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:n.Emphasized,press:this.handleConfirmed.bind(this),visible:{parts:["$valueHelp>/_config/maxConditions","$help>/_quickSelectEnabled"],formatter:function(e,t){return e!==1||!t}}});this.oButtonCancel=new m(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.handleCanceled.bind(this)});this._oManagedObjectModel=new _(this);const o=new y(this.getId()+"-dialog",{contentHeight:x(),contentWidth:E(),horizontalScrolling:false,verticalScrolling:false,title:{parts:["$help>/title","$help>/_selectableContents"],formatter:function(e,t){if(t&&t.length==1){const n=t[0];const o=n.getFormattedShortTitle()?n.getFormattedShortTitle():n.getTitle();if(o){e=this._oResourceBundle.getText("valuehelp.DIALOGSHORTTITLECOLONTITLE",[o,e])}}return e}.bind(this)},stretch:i.system.phone,resizable:true,draggable:true,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this),buttons:[this.oButtonOK,this.oButtonCancel]});g.syncDensity(o);o.setModel(this._oManagedObjectModel,"$help");this.setAggregation("_container",o,true);o.isPopupAdaptationAllowed=function(){return false};o.addStyleClass("sapMdcValueHelp");o.addStyleClass("sapMdcValueHelpTitle");const l=new s(this.getId()+"-Content",{fitContainer:true});l.addStyleClass("sapMdcValueHelpPanel");o.addContent(l);return o}))}return t};B.prototype.placeContent=function(e){const t=e.getContent()[0];const o=this.getProperty("_selectableContents");if(!o.length){return Promise.resolve(e)}const i=o.length>1;const s=[];if(i){s.push(this._getIconTabBar(e))}else{if(!this._oStandaloneTab){this._oStandaloneTab=new n(this.getId()+"-Standalone-DT",{content:{path:"/_selectableContents/0/displayContent",model:"$help"},layoutData:new l({growFactor:1,minHeight:"0"})})}s.push(this._oStandaloneTab)}if(A(this.getMaxConditions(),this.getContent())){s.push(this._getTokenizerPanel())}return Promise.all(s).then(n=>{t.removeAllItems();n.forEach(e=>{t.addItem(e)});if(i){e.addStyleClass("sapMdcValueHelpTitleShadow")}else{e.removeStyleClass("sapMdcValueHelpTitleShadow")}return e})};B.prototype.handleSelect=function(e){t.prototype.handleSelect.apply(this,arguments);if(this.getProperty("_quickSelectEnabled")&&this.isSingleSelect()){const t=e.getParameter("conditions");const n=[c.Set,c.Add].indexOf(e.getParameter("type"))!==-1;const o=t&&t.length;if(n&&o){this.fireConfirm({close:true})}}};B.prototype.observeChanges=function(e){if(e.name==="content"){const t=this.getContent();this.setProperty("_quickSelectEnabled",t&&t.every(e=>e.isQuickSelectSupported()));this._updateInitialContentKey();if(e.mutation==="insert"&&!this.getProperty("_selectedContentKey")){this.setProperty("_selectedContentKey",this._sInitialContentKey)}this.setProperty("_selectableContents",this._getSelectableContents());if(A(this.getMaxConditions(),this.getContent())){const e=this.getAggregation("_container");if(e&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(t=>{t.forEach(t=>{e.getContent()[0].addItem(t)})})}}}t.prototype.observeChanges.apply(this,arguments)};B.prototype._updateInitialContentKey=function(){const e=this.getContent().find(e=>!!e.getVisible());this._sInitialContentKey=e&&e.getId()};B.prototype.getSelectedContent=function(){const e=this.getProperty("_selectedContentKey");return this.getContent().find(t=>t.getId()===e)};B.prototype._getSelectableContents=function(){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=e?t:"";const o=[n];return this.getContent().filter(t=>{if(!t.getVisible()){return false}const n=t.getGroup&&t.getGroup();const i=n&&O.call(this,n);if(i&&t!==e){if(o.indexOf(n)>=0){return false}else{o.push(n)}}return true})};B.prototype._updateGroupSelectModel=function(){if(this._oGroupSelectModel){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=t?this.getContent().filter(e=>!!e.getVisible()&&e.getGroup&&e.getGroup()===t):[];this._oGroupSelectModel.setData(n.reduce((e,t)=>{e.entries.push({key:t.getId(),text:t.getFormattedTitle()});return e},{entries:[]}));if(this._oGroupSelect){const e=this._oGroupSelect.getSelectedItemKey();const t=n.map(e=>e.getId());const o=this.getProperty("_selectedContentKey");if(t.indexOf(e)==-1||e!==o){this._oGroupSelect.setSelectedItemKey(n[0].getId())}}}};B.prototype._retrieveGroupSelect=function(){return this._retrievePromise("collectiveSearchSelect",()=>o(["sap/ui/mdc/valuehelp/CollectiveSearchSelect","sap/m/VariantItem","sap/ui/model/json/JSONModel"]).then(e=>{const t=e[0];const n=e[1];const o=e[2];if(this.isDestroyStarted()){return null}if(!this._oGroupSelectModel){this._oGroupSelectModel=new o}if(!this._oGroupSelect){const e=new n(this.getId()+"-collSearchItem",{key:"{$select>key}",text:"{$select>text}"});this._oGroupSelect=new t(this.getId()+"--Select",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$select>/entries",template:e},select:function(e){this._handleContentSelectionChange(e.getParameter("key"),true)}.bind(this),selectedItemKey:this.getSelectedContent().getId(),maxWidth:i.system.phone?"5em":"25rem"});this._oGroupSelect.setModel(this._oGroupSelectModel,"$select")}return this._oGroupSelect}))};B.prototype._getIconTabBar=function(){if(!this._oIconTabBar){return this._retrievePromise("IconTabBar",()=>o(["sap/m/IconTabBar","sap/m/IconTabFilter"]).then(e=>{b=e[0];T=e[1];const{IconTabHeaderMode:t}=C;if(this.isDestroyStarted()){return null}this._oIconTabBar=new b(this.getId()+"-ITB",{expandable:false,upperCase:false,stretchContentHeight:true,headerMode:t.Inline,select:this._onTabBarSelect.bind(this),layoutData:new l({growFactor:1}),selectedKey:"{path: '$help>/_selectedContentKey', mode: 'OneWay'}"});this._oIconTabBar.addStyleClass("sapUiNoContentPadding");const o=new T(this.getId()+"-ITF",{key:{path:"$help>id"},content:new n(this.getId()+"-DT",{content:{path:"$help>displayContent"}}),text:{parts:["$help>","$valueHelp>/conditions"],formatter:function(e,t){let n="none";if(e){const o=e.getGroup&&e.getGroup();const i=e.getCount(t,o);n=o?this._getFormattedContentGroupLabel(o,i):e.getFormattedTitle(i)}return n}.bind(this)}});this._oIconTabBar.bindAggregation("items",{path:"/_selectableContents",model:"$help",templateShareable:false,template:o});return this._oIconTabBar}))}return this._oIconTabBar};B.prototype._getFormattedContentGroupLabel=function(e,t){const n=this.getGroupConfig();const o=n&&n[e];let i=o&&(t?o.label:o.nnLabel);i=i&&u(i,t?t:"");i=i||this._oResourceBundle.getText(t?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[t]);return i};B.prototype._getTokenizerPanel=function(e){if(!this.oTokenizerPanel){return this._retrievePromise("TokenizerPanel",()=>o(["sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/mdc/field/FieldMultiInput","sap/m/Token","sap/ui/model/Filter","sap/ui/mdc/field/ConditionType"]).then(e=>{I=e[0];S=e[1];s=e[2];v=e[3];M=e[4];k=e[5];const t=e[6];const{BackgroundDesign:n}=C;const{ButtonType:o}=C;if(this.isDestroyStarted()){return null}this.oTokenizerPanel=new I(this.getId()+"-TokenPanel",{backgroundDesign:n.Transparent,expanded:true,visible:{parts:["$valueHelp>/_config/maxConditions","$help>/content"],formatter:A},headerText:{parts:["$valueHelp>/conditions","$help>/_selectableContents"],formatter:function(e,t){let n=0;for(const t of e){if(t.isEmpty!==true){n++}}let o;if(t&&t.length==1){o=t[0].getFormattedTokenizerTitle(n);return o}else{o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLE");if(n===0){o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER")}return u(o,n)}}.bind(this)}});this.oTokenizerPanel.addStyleClass("sapMdcTokenizerPanel");const i=new S(this.getId()+"-TokenBox",{fitContainer:true,width:"100%"});const a=w.call(this);this._oConditionType=new t(a);this._oConditionType._bVHTokenizer=true;this.oTokenMultiInput=new v(this.getId()+"-Tokenizer",{width:"100%",showValueHelp:false,editable:true,showSuggestion:false,ariaAttributes:{role:"listbox",aria:{readonly:true,roledescription:this._oResourceBundle.getText("valuehelp.TOKENIZER_ARIA_ROLE_DESCRIPTION")}},tokenUpdate:function(e){if(e.getParameter("removedTokens")){const t=e.getParameter("removedTokens");const n=this.getModel("$valueHelp").getObject("/conditions");const o=[];t.forEach((e,t)=>{const{sPath:i}=e.getBindingContext("$valueHelp");const s=parseInt(i.slice(i.lastIndexOf("/")+1));o.push(n[s])});this.fireSelect({type:c.Remove,conditions:o})}}.bind(this),layoutData:new l({growFactor:1,maxWidth:"calc(100% - 2rem)"})});this.oTokenMultiInput._setValueVisible=function(e){this.$("inner").css("opacity","0")};const r=this.oTokenMultiInput.onAfterRendering;this.oTokenMultiInput.onAfterRendering=function(){r.apply(this.oTokenMultiInput,arguments);this.oTokenMultiInput._setValueVisible();this.oTokenMultiInput.setValue("");if(!this.bAddAriaLabelledOnlyOnce){this.bAddAriaLabelledOnlyOnce=true;this.oTokenMultiInput.addAriaLabelledBy(this.oTokenizerPanel._getLabellingElementId())}}.bind(this);R.call(this,true);this.oRemoveAllBtn=new m(this.getId()+"-TokenRemoveAll",{press:function(e){this.fireSelect({type:c.Set,conditions:[]});this.oInvisibleMessage.announce(f.getText("valuehelp.REMOVEALLTOKEN_ANNOUNCE"),P.Assertive);this.oTokenMultiInput.focus()}.bind(this),type:o.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.REMOVEALLTOKEN}",layoutData:new l({growFactor:0,baseSize:"2rem"}),enabled:{path:"$valueHelp>/conditions",formatter:function(e){let t=0;for(const n of e){if(n.isEmpty!==true){t++}}return t>0}}});this.oRemoveAllBtn.addStyleClass("sapUiTinyMarginBegin");i.addItem(this.oTokenMultiInput);i.addItem(this.oRemoveAllBtn);this.oTokenizerPanel.addContent(i);return this.oTokenizerPanel}))}else{const e=w.call(this);this._oConditionType.setFormatOptions(e)}return this.oTokenizerPanel};function A(e,t){let n=e!==1;if(n&&t&&t.every(e=>!e.getRequiresTokenizer())){n=false}return n}function w(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const n=this.getParent();const o=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,valueHelpID:n&&n.getId(),control:o,delegate:o&&o.getControlDelegate&&o.getControlDelegate(),delegateName:o&&o.getDelegate&&o.getDelegate()&&o.getDelegate().name,payload:o&&o.getPayload&&o.getPayload(),convertWhitespaces:true}}function R(e){if(this.oTokenMultiInput){const t=this.oTokenMultiInput.getBindingInfo("tokens");if(e){if(!t){const e=new k({path:"isEmpty",operator:"NE",value1:true});this._oConditionType.setFormatOptions(w.call(this));const t=new M(this.getId()+"-Token",{text:{path:"$valueHelp>",type:this._oConditionType}});this.oTokenMultiInput.bindAggregation("tokens",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:t,filters:e,length:50,startIndex:-50})}}else if(t){this.oTokenMultiInput.unbindAggregation("tokens")}}}B.prototype.openContainer=function(e){this._mAlreadyShownContents={};if(e){this._updateInitialContentKey();const t=function(){this._renderSelectedContent(this._sInitialContentKey,()=>{const t=this.getContent().find(e=>e.getId()===this.getProperty("_selectedContentKey"));const n=t.getInitialFocusedControl();if(n){e.setInitialFocus(n)}e.open();this.getContent().forEach(e=>{e.onContainerOpen()})})}.bind(this);if(A(this.getMaxConditions(),this.getContent())&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(n=>{n.forEach(t=>{e.getContent()[0].addItem(t)});t()})}else{if(this.oTokenMultiInput){R.call(this,true)}t()}}};B.prototype._renderSelectedContent=function(e,t,n){const o=this.getContent().find(t=>t.getId()===e);if(!o){throw new Error("sap.ui.mdc.ValueHelp: No content found.")}const i=[o.getContent()];const s=o.getGroup&&o.getGroup();let l;if(s&&O.call(this,s)){l=this._retrieveGroupSelect();i.push(l)}const a=!this._mAlreadyShownContents[e];return Promise.all(i).then(()=>{this.bindContentToContainer(o)}).then(()=>Promise.resolve(o.onBeforeShow(a))).then(()=>{this._mAlreadyShownContents[e]=true;this.setProperty("_selectedContentKey",e);this.setProperty("_selectableContents",this._getSelectableContents());this._oManagedObjectModel.checkUpdate(true,false,e=>{if(e.getPath().indexOf("displayContent")>=0){return true}});if(l){this._updateGroupSelectModel()}if(o.setCollectiveSearchSelect){o.setCollectiveSearchSelect(l?this._oGroupSelect:undefined)}if(t){t()}return this._retrievePromise("open").then(()=>o.onShow(a).then(()=>{if(n){const e=o.getDisplayContent();const t={onAfterRendering:()=>{this._oGroupSelect.focus();e.removeEventDelegate(t)}};e?.addEventDelegate(t)}return o}))})};B.prototype.closeContainer=function(e){const t=this.getAggregation("_container");if(t){if(e){t.oPopup._oPreviousFocus=null}t.close();if(this.oTokenMultiInput){R.call(this,false)}}};B.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};B.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"dialog",role:null,roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};B.prototype.isMultiSelect=function(){return this.getMaxConditions()!==1};B.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oInvisibleMessage=h.getInstance()};B.prototype.exit=function(){r.cleanup(this,["_oManagedObjectModel","_oResourceBundle","oButtonOK","oButtonCancel","oTokenizerPanel","oTokenMultiInput","_oIconTabBar","_oGroupSelect","_oGroupSelectModel","_sInitialContentKey","_mAlreadyShownContents","oInvisibleMessage","_oStandaloneTab"]);t.prototype.exit.apply(this,arguments)};return B});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/FilterBar", ["sap/m/library","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/valuehelp/FilterContainer","sap/m/Button","sap/m/p13n/enums/PersistenceMode","sap/m/OverflowToolbarLayoutData"],(t,e,i,r,o,a,s,l)=>{"use strict";const{OverflowToolbarPriority:h}=t;const n=e.extend("sap.ui.mdc.valuehelp.FilterBar",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/valuehelp/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},expandFilterFields:{type:"boolean",defaultValue:true},filterFieldThreshold:{type:"int",defaultValue:8}},aggregations:{}},renderer:i});const{ButtonType:c}=t;n.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new o(this.getId()+"-innerLayout",{});this.setAggregation("layout",this._oFilterBarLayout,true);this._oBtnFilters=new a(this.getId()+"-btnShowFilters",{type:c.Transparent,press:this._onToggleFilters.bind(this)});this._oBtnFilters.bindProperty("text",{model:e.INNER_MODEL_NAME,path:"/expandFilterFields",formatter:function(t){return this._oRb.getText("valuehelp."+(t?"HIDE":"SHOW")+"ADVSEARCH")}.bind(this)});this._oBtnFilters.bindProperty("visible",{model:e.INNER_MODEL_NAME,path:"/filterItems",formatter:function(t){return t.length>0}});this._oFilterBarLayout.addControl(this._getSearchButton().bindProperty("visible",{parts:[{path:"/showGoButton",model:e.INNER_MODEL_NAME},{path:"/liveMode",model:e.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)}));this._oFilterBarLayout.addControl(this._oBtnFilters);this._oShowAllFiltersBtn=new a(this.getId()+"-btnShowAllFilters",{type:c.Transparent,press:this._onShowAllFilters.bind(this),text:this._oRb.getText("valuehelp.SHOWALLFILTERS"),visible:false});this._oFilterBarLayout.addEndContent(this._oShowAllFiltersBtn)};n.prototype.init=function(){e.prototype.init.apply(this,arguments);this.getEngine().defaultProviderRegistry.attach(this,s.Transient)};n.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);if(this._oCollectiveSearch){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);this._oCollectiveSearch=null}e.prototype.exit.apply(this,arguments);this._oBasicSearchField=null;this._oBtnFilters=null;this._oShowAllFiltersBtn=null};n.prototype._onToggleFilters=function(t){this.setExpandFilterFields(!this.getExpandFilterFields())};n.prototype._onShowAllFilters=function(t){this._oFilterBarLayout._updateFilterBarLayout(true)};n.prototype.setCollectiveSearch=function(t){if(this._oCollectiveSearch){const t=this._oCollectiveSearch.getLayoutData();if(t&&t._bSetByFilterBar){this._oCollectiveSearch.setMaxWidth(t.getMaxWidth());this._oCollectiveSearch.destroyLayoutData()}if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch)}}this._oCollectiveSearch=t;if(this._oCollectiveSearch){if(!this._oCollectiveSearch.getLayoutData()){const t=new l(this._oCollectiveSearch.getId()+"--LD",{priority:h.NeverOverflow,shrinkable:true,minWidth:"5rem",maxWidth:this._oCollectiveSearch.getMaxWidth()});t._bSetByFilterBar=true;this._oCollectiveSearch.setLayoutData(t);this._oCollectiveSearch.setMaxWidth()}if(this._oFilterBarLayout){this._oFilterBarLayout.insertControl(this._oCollectiveSearch,0)}}return this};n.prototype.getCollectiveSearch=function(){return this._oCollectiveSearch};n.prototype.destroyCollectiveSearch=function(){if(this._oCollectiveSearch&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);this._oCollectiveSearch.destroy();this._oCollectiveSearch=undefined}return this};n.prototype.setBasicSearchField=function(t){if(this._oBasicSearchField){const t=this._oBasicSearchField.getLayoutData();if(t&&t._bSetByFilterBar){this._oBasicSearchField.destroyLayoutData()}if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField)}this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this)}this._oBasicSearchField=t;if(t){if(!this._oBasicSearchField.getLayoutData()){const t=new l(this._oBasicSearchField.getId()+"--LD",{shrinkable:true,minWidth:"6rem",maxWidth:this._oBasicSearchField.getWidth()});t._bSetByFilterBar=true;this._oBasicSearchField.setLayoutData(t)}if(this.isPropertyInitial("expandFilterFields")){this.setExpandFilterFields(false)}if(this._oFilterBarLayout){this._oFilterBarLayout.insertControl(t,this._oCollectiveSearch?1:0)}t.attachSubmit(this._handleFilterItemSubmit,this);this._enhanceBasicSearchField(t);if(!this._oObserver.isObserved(t,{properties:["visible"]})){this._oObserver.observe(t,{properties:["visible"]})}}return this};n.prototype.getBasicSearchField=function(){return this._oBasicSearchField};n.prototype.destroyBasicSearchField=function(){if(this._oBasicSearchField&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField);this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this);if(this._oObserver.isObserved(this._oBasicSearchField,{properties:["visible"]})){this._oObserver.unobserve(this._oBasicSearchField)}this._oBasicSearchField.destroy();this._oBasicSearchField=undefined}return this};n.prototype.getInitialFocusedControl=function(){let t=this.getBasicSearchField();if(!t&&this.getShowGoButton()){t=this._btnSearch}return t};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/FilterBarDelegate", ["sap/ui/core/Lib","sap/ui/mdc/FilterBarDelegate"],(e,t)=>{"use strict";const i=e.getResourceBundleFor("sap.ui.mdc");const r=Object.assign({},t);r.fetchProperties=function(e){const t=e.getParent();let r="$search";if(t&&!t.isPropertyInitial("filterFields")){r=t.getFilterFields()}return Promise.resolve([{name:r,label:i.getText("filterbar.SEARCH"),dataType:"sap.ui.model.type.String"}])};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/FilterContainer", ["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/VBox"],(t,e,o,i,n)=>{"use strict";const a=t.extend("sap.ui.mdc.valuehelp.FilterContainer",{metadata:{library:"sap.ui.mdc",aggregations:{_layout:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});a.prototype.init=function(){this.aLayoutItems=[];this.oToolbar=new o(this.getId()+"-tbr",{content:[new i]});this.oAlgnLayout=new e(this.getId()+"-aflayout",{visible:"{$sap.ui.filterbar.mdc.FilterBarBase>/expandFilterFields}"}).addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.oLayout=new n(this.getId()+"-vbox",{items:[this.oToolbar,this.oAlgnLayout]});this.setAggregation("_layout",this.oLayout,true)};a.prototype.exit=function(){this.aLayoutItems.forEach(t=>{t.destroy()});this.aLayoutItems=null};a.prototype.addControl=function(t){this.oToolbar.addContent(t)};a.prototype.insertControl=function(t,e){this.oToolbar.insertContent(t,e)};a.prototype.removeControl=function(t){this.oToolbar.removeContent(t)};a.prototype.addEndContent=function(t){this.oAlgnLayout.addEndContent(t)};a.prototype.insertFilterField=function(t,e){this.aLayoutItems.splice(e,0,t);this._updateFilterBarLayout()};a.prototype.removeFilterField=function(t){let e=-1;this.aLayoutItems.some((o,i)=>{if(t===o){e=i;return true}return false});if(e>=0){this.aLayoutItems.splice(e,1);this._updateFilterBarLayout()}};a.prototype.getFilterFields=function(){return this.oAlgnLayout.getContent()};a.prototype._updateFilterBarLayout=function(t){const e=this.aLayoutItems.length;const o=this.getParent().getFilterFieldThreshold();let i=t||e<=o;if(!i){const t=this.oAlgnLayout.getContent();t.some((t,e)=>{if(t!=this.aLayoutItems[e]){i=true;return true}return false})}if(i){this.oAlgnLayout.removeAllContent();this.aLayoutItems.some((i,n)=>{if(t||e<=o||n<o){this.oAlgnLayout.insertContent(i,n);return false}return true})}const n=this.oAlgnLayout.getEndContent()[0];n.setVisible(!t&&e>o)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/Popover", ["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/util/loadModules","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/Device","sap/ui/mdc/enums/RequestShowContainerReason"],(e,t,o,n,jQuery,i,s,a)=>{"use strict";let l,r,p;const{ValueState:u,TitleLevel:h}=i;const c=e.extend("sap.ui.mdc.valuehelp.Popover",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContainer","sap.ui.mdc.valuehelp.base.IDialogContainer","sap.ui.core.PopupInterface"],properties:{opensOnClick:{type:"boolean",defaultValue:false},opensOnFocus:{type:"boolean",defaultValue:false}},defaultAggregation:"content"}});c.prototype.invalidate=function(t){if(t){const o=this.getAggregation("_container");const n=this._oCurrentContent;if(o&&n&&t===n&&!this.isDestroyStarted()){o.invalidate(t)}else{e.prototype.invalidate.apply(this,arguments)}}};c.prototype.getUIAreaForContent=function(){const t=this.getAggregation("_container");if(t){return t.getUIArea()}return e.prototype.getUIAreaForContent.apply(this,arguments)};c.prototype._getContent=function(){const e=this.getContent();return e&&e[0]};c.prototype.getContainerControl=function(){const e=this.getAggregation("_container");if(!e){if(!this._oGetContainerControlPromise){if(s.system.phone){this._oGetContainerControlPromise=C.call(this)}else{this._oGetContainerControlPromise=f.call(this)}}return this._oGetContainerControlPromise}let t;let o;if(s.system.phone){[t]=e.getContent();[o]=e.getSubHeader().getContent();const n=m.call(this);this._oInputConditionType.setFormatOptions(n);g.call(this,this.getControl(),t,undefined,undefined,o)}else{t=e.getCustomHeader();d.call(this,this.getControl(),t)}return e};function d(e,t,o,n){o=o||e&&e.getValueState&&e.getValueState();n=n||e&&e.getValueStateText&&e.getValueStateText();if(o&&o!==u.None){t.setText(n);t.setValueState(o);t.setVisible(true)}else{t.setText();t.setValueState(u.None);t.setVisible(false)}}function g(e,t,o,n,i){d.call(this,e,t,o,n);if(t.getVisible()){i.setValueState(t.getValueState());i.setValueStateText(t.getText())}else{i.setValueState(u.None);i.setValueStateText()}if(e&&e.getPlaceholder){i.setPlaceholder(e.getPlaceholder())}const s=this.getModel("$valueHelp").getObject("/conditions");if(this.isSingleSelect()){if(s.length===1){const e=this._oInputConditionType.formatValue(s[0],"string");Promise.all([e]).then(([e])=>{i.setValue(e)}).catch(e=>{if(!(e instanceof p)){throw e}})}}else if(this._toggleShowConditions){this._toggleShowConditions(s.length>0)}}function f(){return n(["sap/m/Popover","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/ui/core/InvisibleText","sap/ui/core/Lib"]).then(e=>{if(this.isDestroyStarted()){return null}let t,o,n,i,s;[t,o,l,r,n,i,s]=e;const a=new n(this.getId()+"-pop-ValueState");d.call(this,this.getControl(),a);const p=new t(this.getId()+"-pop",{contentHeight:"auto",placement:o.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,title:this.getTitle(),titleAlignment:o.TitleAlignment.Center,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this),customHeader:a}).addStyleClass("sapMdcValueHelpPopover").addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");p._getAnimationDuration=()=>0;this._oInvisibleText=new i({text:s.getResourceBundleFor("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();p.addAriaLabelledBy(this._oInvisibleText);if(a){a.setPopup(p)}p.isPopupAdaptationAllowed=function(){return false};p.addStyleClass(this.isSingleSelect()?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");p.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});p._getAllContent=function(){const e=this.getParent();const t=[];if(e){if(this._oCurrentContent){t.push(this._oCurrentContent)}}return t}.bind(this);const u=this._getContent();const h=this.getContainerConfig(u);if(h){p.setShowArrow(!!h.showArrow);p.setShowHeader(!!h.showHeader);p.setResizable(!!h.resizable);if(h.getContentWidth){p.setContentWidth(h.getContentWidth())}}this.setAggregation("_container",p,true);return p})}function C(){return n(["sap/m/Dialog","sap/m/Input","sap/m/Button","sap/m/ToggleButton","sap/m/Bar","sap/m/ScrollContainer","sap/m/Title","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/m/List","sap/m/StandardListItem","sap/m/library","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/Lib","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/mdc/field/ConditionType"]).then(e=>{if(this.isDestroyStarted()){return null}let t,n,i,s,a,c,d,f,C,y,_,S,T,b,w,I,v;[t,n,i,s,a,c,d,l,r,f,C,y,_,S,T,b,w,p,I,v]=e;const{TitleAlignment:V,ListMode:P,ListType:A}=_;const H=b.getResourceBundleFor("sap.m");const O=this.isSingleSelect();const F=new f(this.getId()+"-pop-ValueState");const x=m.call(this);this._oInputConditionType=new v(x);this._oInputConditionType._bVHInput=true;const D=new n(this.getId()+"-pop-input",{value:{path:"/filterValue",model:"$valueHelp",mode:w.OneWay},width:"100%",showValueStateMessage:false,showValueHelp:this.hasDialog(),liveChange:e=>{const t=e.getParameter("value");const o=this.getValueHelp();if(o){o.setFilterValue(t)}if(!O){this._toggleShowConditions(false)}},submit:async e=>{const t=e.getParameter("value");if(t){const e=m.call(this);this._oInputConditionType.setFormatOptions(e);try{const e=await this._oInputConditionType.parseValue(t,"string");g.call(this,this.getControl(),F,undefined,undefined,D);this.fireSelect({type:O?o.Set:o.Add,conditions:[e]});this.fireConfirm({close:true})}catch(e){if(e instanceof I){g.call(this,this.getControl(),F,u.Error,e.message,D)}else{throw e}}}else{if(O){this.fireSelect({type:o.Set,conditions:[]})}this.fireConfirm({close:true})}},valueHelpRequest:e=>{this.handleRequestSwitchToDialog()}});const B=new l(this.getId()+"-pop-subheader",{content:[D]});const M=new c(this.getId()+"-pop--SC",{height:"100%",width:"100%",vertical:true});M._oWrapper=this;M.getContent=function(){const e=[];if(this._oWrapper._bShowConditions){const[t]=this.getDependents();e.push(t)}else if(this._oWrapper._oCurrentContent){e.push(this._oWrapper._oCurrentContent)}return e};let E;const L=new i(this.getId()+"-pop-closeButton",{text:H.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),press:e=>{D.fireSubmit({value:D.getValue()});if(!O){this._toggleShowConditions(false)}}});if(!O){const e=new C(this.getId()+"-pop-tokenList",{width:"auto",mode:P.Delete,delete:e=>{const t=e.getParameter("listItem");const n=this.getModel("$valueHelp").getObject("/conditions");const{sPath:i}=t.getBindingContext("$valueHelp");const s=parseInt(i.slice(i.lastIndexOf("/")+1));const a=[n[s]];this.fireSelect({type:o.Remove,conditions:a})}});M.addDependent(e);this._toggleShowConditions=t=>{if(this._bShowConditions!==t){this._bShowConditions=t;if(this._bShowConditions){const t=m.call(this);this._oTokenConditionType=this._oTokenConditionType||new v(t);this._oTokenConditionType._bVHTokenizer=true;this._oTokenConditionType.setFormatOptions(t);const o=new y(this.getId()+"-Token",{title:{path:"$valueHelp>",type:this._oTokenConditionType},selected:true,wrapping:true,type:A.Active,wrapCharLimit:1e4});e.bindAggregation("items",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:o})}else{e.unbindAggregation("items")}E.setPressed(t);M.invalidate()}};E=new s(this.getId()+"-pop-subheader-toggle",{icon:S.getIconURI("multiselect-all"),tooltip:H.getText("SHOW_SELECTED_BUTTON"),press:e=>{this._toggleShowConditions(e.getParameter("pressed"))}});B.addContent(E)}const R=new a(this.getId()+"-pop-header",{titleAlignment:V.Auto,contentMiddle:new d(this.getId()+"-pop-header-title",{text:this.getTitle(),level:h.H1}),contentRight:new i(this.getId()+"-pop-cancelButton",{icon:S.getIconURI("decline"),press:e=>{this.fireCancel();if(!O){this._toggleShowConditions(false)}}})});const k=new t(this.getId()+"-pop",{beginButton:L,stretch:true,titleAlignment:V.Auto,customHeader:R,subHeader:B,content:[F,M],horizontalScrolling:false,initialFocus:D,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this)});this._oInvisibleText=new T({text:b.getResourceBundleFor("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();k.addAriaLabelledBy(this._oInvisibleText);if(F){g.call(this,this.getControl(),F,undefined,undefined,D);F.setPopup(k)}k.addStyleClass(O?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");k.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});this.setAggregation("_container",k,true);return k})}function m(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const o=this.getParent();const n=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,hideOperator:t.operators&&t.operators.length===1,valueHelpID:o&&o.getId(),control:n,delegate:n&&n.getControlDelegate&&n.getControlDelegate(),delegateName:n&&n.getDelegate&&n.getDelegate()&&n.getDelegate().name,payload:n&&n.getPayload&&n.getPayload(),convertWhitespaces:true}}c.prototype.getScrollDelegate=function(t){if(s.system.phone){const e=this.getAggregation("_container");return e&&e.getContent()[1].getScrollDelegate()}else{return e.prototype.getScrollDelegate.apply(this,arguments)}};c.prototype.providesScrolling=function(){return true};c.prototype.observeChanges=function(t){if(t.name==="content"){const e=t.child;if(t.mutation==="remove"){e.detachNavigated(this.handleNavigated,this)}}e.prototype.observeChanges.apply(this,arguments)};c.prototype.placeContent=function(e){const t=this._getContent();const o=t&&t.getContent();const n=this.getContainerConfig(t);const i=n&&n.getFooter&&n.getFooter();return Promise.all([o,i]).then(t=>{this._oCurrentContent=t[0];const o=t[1];if(o&&e.getFooter()!=o&&o.isA&&o.isA("sap.m.Toolbar")){if(s.system.phone&&e.getBeginButton){const t=e.getBeginButton();o.addContent(t)}e.setFooter(o);return e}if(o){if(!e.getFooter()){const t=[new r(this.getId()+"-Spacer")].concat(o);const n=new l(this.getId()+"-TB",{content:t}).setModel(this._oManagedObjectModel,"$help");e.setFooter(n)}else{}}else if(e.getFooter()){e.setFooter()}return e})};c.prototype.openContainer=function(t,o){if(t.isOpen()){return}e.prototype.openContainer.apply(this,arguments);const n=this._getContent();const i=this._retrievePromise("open");Promise.resolve(n&&n.onBeforeShow(true)).then(async()=>{const e=this.getValueHelp();const t=o?await e._requestShowContainer(this,a.Filter):true;return t&&!i.isCanceled()?true:Promise.reject()}).then(()=>{if(s.system.phone){t.open()}else{this._openContainerByTarget(t)}}).catch(e=>{const t=this._retrievePromise("open");const o=i===t;if(o){this._cancelPromise(i);if(e&&e instanceof Error){throw e}}})};c.prototype._openContainerByTarget=function(e){const t=this.getControl();const o=t&&t.getFocusElementForValueHelp?t.getFocusElementForValueHelp(this.isTypeahead()):t;if(o&&o.getDomRef()){e.setContentMinWidth(jQuery(o.getDomRef()).outerWidth()+"px");if(!this.isFocusInHelp()){e.setInitialFocus(o)}e.openBy(o)}};c.prototype.closeContainer=function(t){e.prototype.closeContainer.apply(this,arguments);const o=this.getAggregation("_container");if(o){if(t){if(s.system.phone){o.oPopup._oPreviousFocus=null}else{o._oPreviousFocus=null}}o.close()}};c.prototype.handleOpened=function(e){this._resolvePromise("open");const t=this._getContent();if(t){t.onContainerOpen();t.onShow(true).then(e=>{this.fireOpened({itemId:e?.itemId,items:e?.items})})}else{this.fireOpened({itemId:undefined,items:undefined})}};c.prototype.handleConfirmed=function(e){const t=this.isSingleSelect();const o=e.getParameter("close");if(!s.system.phone||t||o){if(!o){this._disableFollowOfTemporarily()}this.fireConfirm({close:o||t})}};c.prototype._disableFollowOfTemporarily=function(){if(s.system.phone){return}if(this._followOfTimer){clearTimeout(this._followOfTimer)}const e=this.getAggregation("_container");e.setFollowOf(false);this._followOfTimer=setTimeout(()=>{e.setFollowOf(true)},300)};c.prototype.handleCanceled=function(t){if(!s.system.phone){e.prototype.handleCanceled.apply(this,arguments)}};c.prototype.handleClosed=function(t){const o=this._getContent();if(o){o.onHide();o.onContainerClose()}const n=this.getAggregation("_container");if(n){if(s.system.phone){n.oPopup._oPreviousFocus=null}else{n._oPreviousFocus=null}}e.prototype.handleClosed.apply(this,arguments)};c.prototype.removeVisualFocus=function(){const e=this._getContent();e?.removeVisualFocus()};c.prototype.setVisualFocus=function(){const e=this._getContent();e?.setVisualFocus()};c.prototype.navigateInContent=function(e){const t=this._getContent();this.bindContentToContainer(t);if(t){t.navigate(e)}};c.prototype.getItemForValue=function(e){const t=this._getContent();if(t){return t.getItemForValue(e)}};c.prototype.isValidationSupported=function(e){const t=this._getContent();if(t){return t.isValidationSupported()}};c.prototype.getUseAsValueHelp=function(){const e=this._getContent();return e&&e.getUseAsValueHelp&&e.getUseAsValueHelp()};c.prototype.getValueHelpIcon=function(){const e=this._getContent();return e&&e.getValueHelpIcon()};c.prototype.getAriaAttributes=function(t){const o=this._getContent();const n=o&&o.getAriaAttributes(t);if(n){return{contentId:n.contentId,ariaHasPopup:n.ariaHasPopup,role:this.isDialog()?"combobox":null,roleDescription:n.roleDescription,valueHelpEnabled:n.valueHelpEnabled,autocomplete:n.autocomplete}}return e.prototype.getAriaAttributes.apply(this,arguments)};c.prototype.shouldOpenOnNavigate=function(){const e=this._getContent();this.bindContentToContainer(e);return!!e&&e.shouldOpenOnNavigate()};c.prototype.isNavigationEnabled=function(e){if(this.isOpen()||this.getUseAsValueHelp()){const t=this._getContent();return!!t&&t.isNavigationEnabled(e)}return false};c.prototype.isFocusInHelp=function(){const e=this._getContent();return!!e&&e.isFocusInHelp()};c.prototype.isMultiSelect=function(){const e=this._getContent();return!!e&&e.isMultiSelect()};c.prototype.isTypeaheadSupported=function(){if(s.system.phone&&(this.isSingleSelect()||this.isDialog())){return false}const e=this._getContent();return e&&e.isSearchSupported()};c.prototype.setHighlightId=function(e){return this._getContent()?.setHighlightId?.(e)};c.prototype.exit=function(){this._oGetContainerControlPromise=undefined;if(this._oCurrentContent){if(!this._oCurrentContent.isDestroyed()){this._oCurrentContent.destroy()}this._oCurrentContent=null}if(this._oInvisibleText){this._oInvisibleText.destroy();delete this._oInvisibleText}if(this._oInputConditionType){this._oInputConditionType.destroy();this._oInputConditionType=undefined}if(this._oTokenConditionType){this._oTokenConditionType.destroy();this._oTokenConditionType=undefined}if(this._followOfTimer){clearTimeout(this._followOfTimer);this._followOfTimer=null}e.prototype.exit.apply(this,arguments)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/Container", ["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver"],(e,t,n,o)=>{"use strict";const i=e.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},localFilterValue:{type:"string"}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{parameters:{itemId:{type:"string"},items:{type:"int"}}},closed:{},cancel:{},requestDelegateContent:{parameters:{contentId:{type:"string"}}},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}}}});i.prototype.init=function(){this._oObserver=new o(this.observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.observeChanges=function(e){if(e.name==="content"){const t=e.child;if(e.mutation==="remove"){this.unbindContentFromContainer(t)}}};i.prototype.bindContentToContainer=function(e){if(e&&!e._bContentBound){e.attachConfirm(this.handleConfirmed,this);e.attachCancel(this.handleCanceled,this);e.attachSelect(this.handleSelect,this);if(e.attachNavigated){e.attachNavigated(this.handleNavigated,this)}if(e.attachVisualFocusSet){e.attachVisualFocusSet(this.handleVisualFocusSet,this)}if(e.attachTypeaheadSuggested){e.attachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(e.attachRequestSwitchToDialog){e.attachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}e.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:n.OneWay});const t={path:"/conditions",model:"$valueHelp",mode:n.OneWay};if(e._formatConditions){t.formatter=e._formatConditions.bind(e)}e.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:n.OneWay});e.bindProperty("conditions",t);e._bContentBound=true}};i.prototype.unbindContentFromContainer=function(e){if(e._bContentBound){e.unbindProperty("filterValue",true);e.unbindProperty("config",true);e.unbindProperty("conditions",true);e.detachConfirm(this.handleConfirmed,this);e.detachCancel(this.handleCanceled,this);e.detachSelect(this.handleSelect,this);if(e.detachNavigated){e.detachNavigated(this.handleNavigated,this)}if(e.detachVisualFocusSet){e.detachVisualFocusSet(this.handleVisualFocusSet,this)}if(e.detachTypeaheadSuggested){e.detachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(e.detachRequestSwitchToDialog){e.detachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}e._bContentBound=false}};i.prototype.handleNavigated=function(e){this.fireNavigated(e.mParameters)};i.prototype.handleVisualFocusSet=function(e){this.fireVisualFocusSet(e.mParameters)};i.prototype.handleTypeaheadSuggested=function(e){this.fireTypeaheadSuggested(e.mParameters)};i.prototype.handleRequestSwitchToDialog=function(e){this.fireRequestSwitchToDialog({container:this})};i.prototype.getContainerControl=function(){};i.prototype.getControl=function(){const e=this.getParent();return e&&e.getControl()};i.prototype.getMaxConditions=function(){const e=this.getModel("$valueHelp");return e&&e.getObject("/_config/maxConditions")};i.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};i.prototype.getDomRef=function(){const e=this.getAggregation("_container");return e&&e.getDomRef()};i.prototype.getUIArea=function(){return null};i.prototype.getUIAreaForContent=function(){return this.getUIArea()};i.prototype.open=function(e,t){if(!this.isOpening()){if(this._retrievePromise("close")){this._cancelPromise("close")}const n=this._addPromise("open");return Promise.all([this.getContainerControl(),e]).then(e=>this.placeContent(e[0])).then(e=>{if(!n.isCanceled()){this.openContainer(e,t)}return n})}return this._retrievePromise("open")};i.prototype.close=function(e){const t=this._retrievePromise("open");if(t){if(t.isSettled()){this.closeContainer(e)}else{this._cancelPromise(t)}}};i.prototype.placeContent=function(e){return e};i.prototype.openContainer=function(e,t){const n=this.getContent();for(let e=0;e<n.length;e++){this.bindContentToContainer(n[e])}};i.prototype.closeContainer=function(e){};i.prototype.handleOpened=function(e){this._resolvePromise("open");this.fireOpened()};i.prototype.handleClose=function(e){this._addPromise("close")};i.prototype.handleClosed=function(e){this._resolvePromise("close");this._removePromise("open");const t=this.getContent();for(let e=0;e<t.length;e++){this.unbindContentFromContainer(t[e])}this.fireClosed()};i.prototype.handleConfirmed=function(e){this.fireConfirm()};i.prototype.handleCanceled=function(e){this.fireCancel()};i.prototype.handleSelect=function(e){this.fireSelect({type:e.getParameter("type"),conditions:e.getParameter("conditions")})};i.prototype.isClosing=function(){const e=this._retrievePromise("close");return!!e&&!e.isCanceled()&&!e.isSettled()};i.prototype.isOpen=function(){const e=this._retrievePromise("open");return!!e&&e.isSettled()};i.prototype.isOpening=function(){const e=this._retrievePromise("open");return!!e&&!e.isCanceled()&&!e.isSettled()};i.prototype.getItemForValue=function(e){return undefined};i.prototype.isValidationSupported=function(){return false};i.prototype.navigate=function(e){return Promise.all([this.getContainerControl()]).then(e=>this.placeContent(e[0])).then(t=>{this.navigateInContent(e)})};i.prototype.navigateInContent=function(e){};i.prototype.removeVisualFocus=function(){};i.prototype.setVisualFocus=function(){};i.prototype.isTypeahead=function(){const e=this.getParent();return e&&e.getTypeahead()===this};i.prototype.isTypeaheadSupported=function(){return false};i.prototype.isDialog=function(){const e=this.getParent();return e&&(e.getDialog()===this||this.isTypeahead()&&!e.getDialog()&&this.getUseAsValueHelp())};i.prototype.hasDialog=function(){const e=this.getParent();return!!(e&&e.getDialog())};i.prototype.providesScrolling=function(){return false};i.prototype.getValueHelp=function(){const e=this.getParent();return e};i.prototype.getValueHelpDelegate=function(){const e=this.getParent();return e&&e.getControlDelegate()};i.prototype.getValueHelpDelegatePayload=function(){const e=this.getParent();return e&&e.getPayload()};i.prototype.awaitValueHelpDelegate=function(){const e=this.getParent();return e&&e.awaitControlDelegate()};i.prototype.isValueHelpDelegateInitialized=function(){const e=this.getParent();return!!e&&e.bDelegateInitialized};i.prototype.getUseAsValueHelp=function(){return false};i.prototype.getValueHelpIcon=function(){};i.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};i.prototype.getScrollDelegate=function(e){const t=this.getAggregation("_container");return t&&t.getScrollDelegate&&t.getScrollDelegate()};i.prototype.shouldOpenOnFocus=function(){const e=this.getValueHelpDelegate();const t=this.getValueHelp();return e?e.shouldOpenOnFocus(t,this):Promise.resolve(false)};i.prototype.shouldOpenOnClick=function(){const e=this.getValueHelpDelegate();const t=this.getValueHelp();return e?e.shouldOpenOnClick(t,this):Promise.resolve(false)};i.prototype.shouldOpenOnNavigate=function(){return false};i.prototype.isNavigationEnabled=function(e){return false};i.prototype.isFocusInHelp=function(){return!this.isTypeahead()};i.prototype.isMultiSelect=function(){return false};i.prototype.getContainerConfig=function(e){const t=e&&e.getContainerConfig();let n=t&&t[this.getMetadata().getName()];if(!n&&t){const e=Object.keys(t);const o=e.find(e=>this.isA(e));if(o){n=t[o]}}return n};i.prototype.getRetrieveDelegateContentPromise=function(){const e=this.getParent();return e&&e._retrievePromise("delegateContent")};i.prototype.getSelectedContent=function(){const e=this.getContent();return e&&e[0]};i.prototype.onConnectionChange=function(){const e=this.getContent();for(let t=0;t<e.length;t++){this.unbindContentFromContainer(e[t]);e[t].onConnectionChange()}};i.prototype.setHighlightId=function(e){};i.prototype.clone=function(t,n){const o=this.getContent();for(let e=0;e<o.length;e++){if(o[e]._bContentBound){o[e]._bRebindContent=true;this.unbindContentFromContainer(o[e])}}const i=e.prototype.clone.apply(this,arguments);for(let e=0;e<o.length;e++){if(o[e]._bRebindContent){this.bindContentToContainer(o[e]);delete o[e]._bRebindContent}}return i};i.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};t.call(i.prototype);return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/Content", ["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/base/strings/formatMessage","sap/ui/mdc/enums/RequestShowContainerReason"],(t,e,n,o,i,r,p,a,s)=>{"use strict";const u=t.extend("sap.ui.mdc.valuehelp.base.Content",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},shortTitle:{type:"string",group:"Appearance",defaultValue:""},tokenizerTitle:{type:"string",group:"Appearance",defaultValue:""},conditions:{type:"object[]",defaultValue:[],byValue:true},filterValue:{type:"string",defaultValue:""},config:{type:"object",defaultValue:{}},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{displayContent:{type:"sap.ui.core.Control",multiple:false}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}}}});u.prototype.init=function(){this._oObserver=new n(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","config"]});this._oOperator=i.getEQOperator()};u.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};u.prototype.setProperty=function(e,n,o){if(e==="conditions"||e==="filterValue"||e==="config"){o=true}return t.prototype.setProperty.apply(this,[e,n,o])};u.prototype.getContent=function(){};u.prototype.getContainerConfig=function(){};u.prototype.onBeforeShow=function(t){};u.prototype.onShow=function(t){this._bVisible=true;this.handleConditionsUpdate();return Promise.resolve({})};u.prototype.getInitialFocusedControl=function(){return null};u.prototype.onHide=function(){this._bVisible=false};u.prototype.getItemForValue=function(t){return undefined};u.prototype.isValidationSupported=function(){return false};u.prototype.getScrollDelegate=function(){const t=this.getParent();return t&&t.getScrollDelegate()};u.prototype.observeChanges=function(t){if(t.name==="conditions"){this.handleConditionsUpdate(t)}if(t.name==="filterValue"){this.handleFilterValueUpdate(t)}if(t.name==="config"){l.call(this,t.current)}};u.prototype.handleFilterValueUpdate=async function(t){if(this.isContainerOpen()&&this.isTypeahead()){const t=this.getValueHelpInstance();const e=!await t._requestShowContainer(this.getParent(),s.Filter);if(e){this.fireCancel()}}};u.prototype.handleConditionsUpdate=function(t){};u.prototype.createCondition=function(t,e,n){const i=f.call(this);const a=[t];if(i.valueTypes.length>1&&i.valueTypes[1]!==p.Static&&e!==null&&e!==undefined){a.push(e)}return o.createCondition(i.name,a,undefined,undefined,r.Validated,n)};u.prototype.removeVisualFocus=function(){};u.prototype.setVisualFocus=function(){};u.prototype.navigate=function(t){};u.prototype.getUIArea=function(){const e=this.getParent();if(e&&e.getUIAreaForContent){return e.getUIAreaForContent()}return t.prototype.getUIArea.apply(this,arguments)};u.prototype.isTypeahead=function(){const t=this.getParent();return t&&t.isTypeahead()};u.prototype.isSearchSupported=function(){return false};u.prototype.provideScrolling=function(){const t=this.getParent();return!t||!t.providesScrolling()};u.prototype.isContainerOpen=function(){const t=this.getParent();return t&&t.isOpen()};u.prototype.isContainerOpening=function(){const t=this.getParent();return t&&t.isOpening()};u.prototype.getValueHelpDelegate=function(){const t=this.getParent();return t&&t.getValueHelpDelegate()};u.prototype.getValueHelpInstance=function(){const t=this.getParent();return t&&t.getValueHelp&&t.getValueHelp()};u.prototype.awaitValueHelpDelegate=function(){const t=this.getParent();return t&&t.awaitValueHelpDelegate()};u.prototype.isValueHelpDelegateInitialized=function(){const t=this.getParent();return!!t&&t.isValueHelpDelegateInitialized()};u.prototype.getControl=function(){const t=this.getParent();return t&&t.getControl()};u.prototype.getCount=function(t){return 0};u.prototype.getValueHelpIcon=function(){};u.prototype.getAriaAttributes=function(t){return{contentId:null,ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};u.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};u.prototype.shouldOpenOnClick=function(){return false};u.prototype.shouldOpenOnNavigate=function(){return false};u.prototype.isNavigationEnabled=function(t){return false};u.prototype.isFocusInHelp=function(){return!this.isTypeahead()};u.prototype.isMultiSelect=function(){return!this.isSingleSelect()};u.prototype.isQuickSelectSupported=function(){return false};u.prototype.getRequiresTokenizer=function(){return true};function l(t){c.call(this,t.operators)}function c(t){this._oOperator=i.getEQOperator(t)}function f(){return this._oOperator}u.prototype.getFormattedTitle=function(t){let e=this.getTitle();if(e){e=a(e,t?t:"")}return e};u.prototype.getFormattedShortTitle=function(){return this.getShortTitle()};u.prototype.getFormattedTokenizerTitle=function(t){let e=this.getTokenizerTitle();if(e){e=a(e,t?t:"")}return e};u.prototype.getMaxConditions=function(){const t=this.getConfig();return t&&t.maxConditions};u.prototype.onContainerClose=function(){};u.prototype.onContainerOpen=function(){};u.prototype.onConnectionChange=function(){};u.prototype.setHighlightId=function(t){};e.call(u.prototype);return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/DefineConditionPanel", ["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/base/i18n/Localization","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/Messaging","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/Field","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/base/ManagedObjectModel","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/type/String","sap/ui/model/ParseException","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/library","sap/m/Button","sap/m/Panel","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/m/Title","sap/ui/core/IconPool","sap/ui/core/InvisibleMessage","sap/ui/thirdparty/jquery"],(t,e,i,n,s,o,a,l,r,d,u,c,h,p,g,f,C,y,v,I,m,b,_,O,T,x,S,D,P,V,w,N,E,M,$,B,L,A,F,R,U,jQuery)=>{"use strict";let H=a.getResourceBundleFor("sap.ui.mdc");let j=a.getResourceBundleFor("sap.m");i.attachChange(()=>{H=a.getResourceBundleFor("sap.ui.mdc");j=a.getResourceBundleFor("sap.m")});const{ButtonType:k}=N;const{ValueState:G}=D;const{InvisibleMessageMode:X}=D;const{TextAlign:K}=D;const{BackgroundDesign:W}=N;const{ToolbarDesign:q}=N;const{OverflowToolbarPriority:Y}=N;const z=t.extend("sap.ui.mdc.valuehelp.base.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},config:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true},_pagination:{type:"boolean",defaultValue:false,visibility:"hidden"},_prevButtonActive:{type:"boolean",defaultValue:false,visibility:"hidden"},_nextButtonActive:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{conditionProcessed:{}}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(t,e){t.openStart("section",e);t.class("sapUiMdcDefineConditionPanel");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("section")}},init:function(){l.registerObject(this,true);t.prototype.init.apply(this,arguments);this.oInvisibleMessage=U.getInstance();this._oManagedObjectModel=new _(this);this._oObserver=new e(J.bind(this));this._oObserver.observe(this,{properties:["conditions","config"]});this._iStartIndex=0;this._iShownConditions=10;this._iShownAdditionalConditions=0;this._sOperatorHelpId=this.getId()+"--rowSelect-help";this._oContentEventDelegate={onpaste:this.onPaste};ht.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition")},exit:function(){l.unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel},byId:function(t){return o.getElementById(this.getId()+"--"+t)},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new T({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}if(this.getConditions().length===0&&!this._sConditionsTimer){this.updateDefineConditions()}},removeCondition:function(t){const{oSource:e}=t;const i=e.getBindingContext("$this");let n=this.getConditions();const s=i.getPath();const o=s.match(/^.*\/(\d+)\/$/);let a;if(o){a=parseInt(o[1])}if(a>0&&n.length-1===a){this._bFocusLastRemoveBtn=true}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),X.Assertive);const l=this.byId("conditions");const r=l.getContent();let d=-1;for(const t of r){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){d++}if(t instanceof y&&t.hasOwnProperty("_iValueIndex")&&t.getBindingContext("$this").getPath().startsWith(s)){if(t.isInvalidInput()){t.setValue(null)}}}if(n.length===1&&a===0){this.addDummyCondition(1);n=this.getConditions()}if(d===0&&this._iStartIndex>0){this._iStartIndex=this._iStartIndex-this._iShownConditions}n.splice(a,1);this.setProperty("conditions",n,true);this.fireConditionProcessed()},addCondition:function(t){const e=this.getConditions();const i=this.getConfig();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(const t of o){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){a++;const e=t.getBindingContext("$this");const i=e.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}if(n===-1||e.length<n){this.addDummyCondition(l+1);this._bFocusLastCondition=true;if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),X.Assertive)},addDummyCondition:function(t){const e=st.call(this);const i=nt.call(this);const n=i.name;const s=r.createCondition(n,i.valueDefaults?i.valueDefaults:[],undefined,undefined,f.NotValidated);if(i.valueTypes[0]&&i.valueTypes[0]!==C.Static){s.isInitial=true}d.updateConditionValues(s);d.checkConditionsEmpty(s,e);const o=this.getConditions();if(t!==undefined){o.splice(t,0,s)}else{o.push(s)}this.setProperty("conditions",o,true);if(!s.isInitial){this.fireConditionProcessed()}},updateDefineConditions:function(){const t=wt.call(this);ct.call(this,t,true,this._bUpdateType);if(t.length===0){this.addDummyCondition()}if(t.length<this._iStartIndex){this._iStartIndex=0}},onChange:function(t){const e=t&&t.getParameter("promise");const i=t&&t.getSource();const n=function(t){const e=st.call(this);const i=this.getConditions();d.checkConditionsEmpty(i,e);d.updateConditionsValues(i,e);ct.call(this,i,false,false);if(t){i.forEach(t=>{if(!t.isEmpty){delete t.isInitial}})}this.setProperty("conditions",i,true)}.bind(this);if(e){e.then(t=>{this._bPendingChange=false;n({mParameters:{value:t}});if(this._bPendingValidateCondition){Pt.call(this,i);delete this._bPendingValidateCondition}}).catch(t=>{this._bPendingChange=false;if(this._bPendingValidateCondition){Pt.call(this,i);delete this._bPendingValidateCondition}});this._bPendingChange=true;return}else{n()}},onSelectChange:function(t){const e=t.getSource();const i=t.getParameter("promise");i.then(t=>{const i=e._sOldKey;const n=d.getOperator(t);const o=i&&d.getOperator(i);const a=e.getBindingContext("$this");let l=a.getObject();const r=a.getPath();const u=parseInt(r.split("/")[2]);const c=this.getConditions();if(u>=0){l=c[u]}if(n&&o){let a=false;if(!s(n.valueTypes[0],o.valueTypes[0])&&n.valueTypes[0]!==C.Static){if(u>=0){l.values.forEach((t,e)=>{if(t!==null){if(n.valueTypes[e]===C.Self&&o.valueTypes[e]===C.SelfNoParse||n.valueTypes[e]===C.SelfNoParse&&o.valueTypes[e]===C.Self){const t=et.call(this,n.name,e);const i=et.call(this,o.name,e);const s=i.formatValue(l.values[e],"string");const r=t.parseValue(s,"string");if(r!==l.values[e]){l.values[e]=t.parseValue(s,"string");a=true}}else{l.values[e]=null;a=true}}})}}let r=false;if(n.valueTypes.length===0||n.valueTypes[0]===C.Static){for(let i=0;i<c.length;i++){if(i!==u&&t===c[i].operator){r=true;l.invalid=true;a=true;e.setValueState(G.Error);e.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[t]));break}}}if(o.valueTypes.length===0||o.valueTypes[0]===C.Static){let t=-1;let e=false;for(let n=0;n<c.length;n++){if(i===c[n].operator){if(t<0){t=n}else{e=true;break}}}if(!e&&t>=0){delete c[t].invalid;a=true}}if(u>=0&&n.valueDefaults){l.values.forEach((t,e)=>{if(l.isInitial&&t!==n.valueDefaults[e]||t===null){l.values[e]=n.valueDefaults[e];l.isInitial=true;a=true}})}if(!n.valueTypes[1]&&o.valueTypes[1]){if(u>=0){if(l.values.length>1&&l.values[1]){l.values=l.values.slice(0,1);a=true}}}if(l.invalid&&!r){delete l.invalid;a=true}if(a){d.checkConditionsEmpty(l,st.call(this));this.setProperty("conditions",c,true)}if(!l.invalid&&(n.valueTypes.length===0||n.valueTypes[0]===C.Static||(o.valueTypes.length===0||o.valueTypes[0]===C.Static))){this.fireConditionProcessed()}}delete e._sOldKey}).catch(t=>{const i=e.getBindingContext("$this");let n=i.getObject();const s=i.getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();if(o>=0){n=a[o]}n.invalid=true;this.setProperty("conditions",a,true);e._sOldKey=e.getValue()})},onPaste:function(t){const e=t.originalEvent.clipboardData.getData("text/plain");const i=c(e,true);if(i.length>1){const i=t.srcControl;const s=i.getBindingContext("$condition").getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();const l=n({},this.getConfig());l.display=p.Value;l.getConditions=function(){return a};l.defaultOperatorName=a[o].operator;l.valueType=l.dataType;delete l.dataType;const r=new u(l);a.splice(o,1);r._parseValueToIndex(e,"string",o).then(t=>{r.validateValue(t);d.checkConditionsEmpty(t);this.setProperty("conditions",t,true);this.fireConditionProcessed();r.destroy()}).catch(t=>{const n=new S(H.getText("field.PASTE_ERROR"));const s={element:i,property:"value",type:r,newValue:e,oldValue:"",exception:n,message:n.message};i.fireParseError(s,false,true);r.destroy()});t.stopImmediatePropagation(true);t.preventDefault()}},cleanUp:function(){const t=this.byId("conditions");const e=t.getContent();for(const t of e){if(t instanceof y&&t.hasOwnProperty("_iValueIndex")){if(t.isInvalidInput()){t.setValue()}}}this.setProperty("inputOK",true,true);if(this._iStartIndex>0||this._iShownAdditionalConditions>0){this._iStartIndex=0;this._iShownAdditionalConditions=0;ft.call(this)}},getInitialFocusedControl:function(){const t=this.getAggregation("_content").getContent()[1];const e=t.getContent()[0];return e},_getValueHelp:function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}});function J(t){if(t.name==="value"){Z.call(this,t.object,t.current,t.old)}if(t.name==="config"){const e=this.getConditions();const i=t.current&&t.current.operators;const n=t.old&&t.old.operators;let o=false;if(!s(i,n)){o=true;at.call(this)}const a=t.current&&t.current.dataType;const l=t.old&&t.old.valueType;const r=a&&a.getMetadata().getName();const d=l&&l.getMetadata().getName();const u=a&&a.getFormatOptions();const c=l&&l.getFormatOptions();const h=a&&a.getConstraints();const p=l&&l.getConstraints();if(r!==d||!s(u,c)||!s(h,p)){if(!o){at.call(this)}if(this._sConditionsTimer){this._bUpdateType=true}else if(e.length>0){this._bUpdateType=true;ft.call(this);this._bUpdateType=false;ct.call(this,e,true,true)}}}if(t.name==="conditions"&&!this._bConditionUpdateRunning){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}this._sConditionsTimer=setTimeout(()=>{this._sConditionsTimer=null;this._bConditionUpdateRunning=true;this.updateDefineConditions();ft.call(this);this._bUpdateType=false;this._bConditionUpdateRunning=false},0)}}function Q(t){return true}function Z(t,e,i){t._sOldKey=i;let n=0;let s;if(i){const s=e&&d.getOperator(e);const o=d.getOperator(i);const a=t.getParent();let l;let r;n=a.indexOfContent(t);l=a.getContent()[n+2];if(l?.hasOwnProperty("_iValueIndex")&&l._iValueIndex===0){if(l instanceof y&&!l.isInvalidInput()){l.setValueState(G.None);l.setValueStateText()}r=a.getContent()[n+3];if(r?.hasOwnProperty("_iValueIndex")&&r._iValueIndex===1){if(r instanceof y&&!r.isInvalidInput()){r.setValueState(G.None);r.setValueStateText()}}else{r=undefined}}else{l=undefined}let u;if(e&&Q(e)){u=this._getValueHelp()}l?.setValueHelp?.(u);r?.setValueHelp?.(u);if(s?.createControl||o?.createControl){l?.destroy();r?.destroy()}else{if(l&&s?.valueTypes[0]!==o?.valueTypes[0]){l.unbindProperty("value")}if(r&&s?.valueTypes[1]!==o?.valueTypes[1]&&o?.valueTypes[1]){r.unbindProperty("value")}}}if(!e){s=t.getBindingContext("$this").getObject();if(s){const t=this.getConditions();n=d.indexOfCondition(s,t);if(n>=0){s=t[n];s.operator=i;this.setProperty("conditions",t,true)}}}const o=this.oOperatorModel.getData();let a;for(const t of o){if(t.key===e){a=t.text;break}}t.setAdditionalValue(a);this.onChange()}function tt(t,e,i,n){const s=d.getOperator(t.operator);if(!s||!s.valueTypes[e]){return null}const o=et.call(this,s.name,e);const a=this._oManagedObjectModel.getContext(n.getPath()+"values/"+e+"/");let l;if(s.createControl){l=s.createControl(o,"$this>",e,i)}if(!l){l=new y(i,{delegate:ut.call(this),value:{path:"$this>",type:o,mode:"TwoWay",targetType:"raw"},editMode:{parts:[{path:"$condition>operator"},{path:"$condition>invalid"}],formatter:mt},multipleLines:false,width:"100%",valueHelp:Q(t.operator)?this._getValueHelp():null})}if(l.getMetadata().hasProperty("placeholder")){if(e===0){l.bindProperty("placeholder",{path:"$condition>operator",formatter:Tt})}else{l.bindProperty("placeholder",{path:"$condition>operator",formatter:xt})}}l._iValueIndex=e;if(l.attachChange){l.attachChange(this.onChange.bind(this))}l.addDelegate(this._oContentEventDelegate,true,this);l.setLayoutData(new w({span:{parts:[{path:"$condition>"},{path:"$this>/config"}],formatter:Ot.bind(this)}}));l.setBindingContext(a,"$this");l.setBindingContext(n,"$condition");l.setFieldGroupIds([n.getPath()]);return l}function et(t,e){let i=lt.call(this);const n=d.getOperator(t);if(n.valueTypes[e]&&[C.Self,C.Static].indexOf(n.valueTypes[e])===-1){i=n._createLocalType(n.valueTypes[e],i)}let s=false;if(n.valueTypes[e]===C.Static){s=true;i=rt.call(this)}const o=s?g.String:dt.call(this,i);let a;const l=i.getFormatOptions();switch(o){case g.Numeric:if(l&&l.hasOwnProperty("emptyString")&&l.emptyString===null){a=i}else{a=it(i,{emptyString:null})}break;case g.Date:case g.Time:case g.DateTime:a=i;break;default:if(i.getConstraints()&&i.getConstraints().hasOwnProperty("nullable")&&i.getConstraints().nullable===false){a=it(i);if(i._bCreatedByOperator){a=n._createLocalType(n.valueTypes[e],i)}}else{a=i}break}return a}function it(t,e,i){const s=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));const o=n(t.getFormatOptions(),e||{});const a=n(t.getConstraints(),i||{});if(a.hasOwnProperty("nullable")&&a.nullable===false){a.nullable=true}return new s(o,a)}function nt(){const t=st.call(this);let e;const i=this.getConfig().defaultOperatorName;if(i){e=d.getOperator(i)}else{const t=lt.call(this);const i=dt.call(this,t);e=d.getDefaultOperator(i)}if(e&&t.indexOf(e.name)<0){for(let i=0;i<t.length;i++){e=d.getOperator(t[i]);if(!e||e.exclude||!e.hasRequiredValues()){e=undefined}else{break}}}if(!e){e=d.getOperator(t[0])}return e}function st(){const t=this.getConfig();let e=t&&t.operators;if(!e||e.length===0){e=d.getOperatorsForType(g.String)}return e}function ot(){let t;const e=st.call(this);for(const i of e){const e=d.getOperator(i);if(!t){t=e.group.id}else if(t!==e.group.id){return true}}return false}function at(){if(!this.oOperatorModel){return}const t=lt.call(this);const e=st.call(this);const i=[];const n=ot.call(this);const s=this._sOperatorHelpId+"-pop-fl";const a=o.getElementById(s);const l=a.getBindingInfo("items");let r=l?.template;if(!r||a.getGroupable()!==n){if(n){r=new b({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"})}else{r=new b({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"})}a.bindAggregation("items",{path:"om>/",templateShareable:false,template:r});a.setGroupable(n)}for(const s of e){const e=d.getOperator(s);if(!e||e.showInSuggest!==undefined&&e.showInSuggest==false){continue}const o=e.getLongText(dt.call(this,t));let a=e.additionalInfo;if(a===undefined){if(a!==""&&e.formatRange){a=e.formatRange(e._getRange(undefined,t),t)}else if(!n){a=e.group.text}}let l=e.exclude?"2":"1";if(e.group.text&&e.group.id){l=e.group.id}i.push({key:e.name,text:o,additionalText:a,groupId:l,groupText:e.group.text})}a.destroyItems();this.oOperatorModel.setData();this.oOperatorModel.setData(i)}function lt(){const t=this.getConfig();let e=t&&t.dataType;if(!e){e=rt.call(this)}return e}function rt(){if(!this._oDefaultType){this._oDefaultType=new x}return this._oDefaultType}function dt(t){const e=t.getMetadata().getName();const i=t.getFormatOptions();const n=t.getConstraints();const s=this.getConfig().delegate;const o=this.getConfig().control;let a=s?s.getTypeMap(o).getBaseType(e,i,n):g.String;if(a===g.Unit){a=g.Numeric}return a}function ut(){const t=this.getConfig();const e=t.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";const i=t.payload;return{name:e,payload:i}}function ct(t,e,i){const n=lt.call(this);const s=[];let o=0;for(o=0;o<t.length;o++){const e=t[o];const a=d.getOperator(e.operator);if(a&&a.valueTypes[0]===C.Static&&(e.values.length===0||i)){if(a.getStaticText){const t=a.getStaticText(n,dt.call(this,n));if(e.values.length>0){e.values[0]=t}else{e.values.push(t)}s.push(o)}}}if(e&&s.length>0){this.setProperty("conditions",t,true)}}function ht(){const t=new P(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});const e=new F(this.getId()+"-title",{text:{path:"$this>/label"}});const i=new E(this.getId()+"--prev",{icon:R.getIconURI("navigation-left-arrow"),tooltip:j.getText("PAGINGBUTTON_PREVIOUS"),visible:{path:"$this>/_pagination"},enabled:"{= ${$this>/inputOK} && ${$this>/_prevButtonActive}}",layoutData:new B({priority:Y.NeverOverflow}),press:Et.bind(this)});const n=new E(this.getId()+"--next",{icon:R.getIconURI("navigation-right-arrow"),tooltip:j.getText("PAGINGBUTTON_NEXT"),visible:{path:"$this>/_pagination"},enabled:"{= ${$this>/inputOK} && ${$this>/_nextButtonActive}}",layoutData:new B({priority:Y.NeverOverflow}),press:Nt.bind(this)});const s=new E(this.getId()+"--removeAll",{text:j.getText("CONDITIONPANEL_REMOVE_ALL"),visible:{path:"$this>/_pagination"},layoutData:new B({priority:Y.Low}),press:Mt.bind(this)});const o=new E(this.getId()+"--insert",{icon:R.getIconURI("add"),visible:{path:"$this>/_pagination"},enabled:{path:"$this>/inputOK"},layoutData:new B({priority:Y.Low}),press:$t.bind(this)});const a=new A(this.getId()+"--pageCount",{text:Bt.call(this),wrapping:false,textAlign:K.Center,visible:{path:"$this>/_pagination"},layoutData:new B({priority:Y.NeverOverflow})});const l=new $(this.getId()+"--toolbar",{width:"100%",design:q.Transparent,content:[e,new L,i,a,n,s,o]});const r=new M(this.getId()+"--panel",{headerToolbar:l,expanded:true,height:"100%",backgroundDesign:W.Transparent}).addStyleClass("sapMdcDefineconditionPanel");r.addDependent(new v(this._sOperatorHelpId,{typeahead:new I(this._sOperatorHelpId+"-pop",{content:[new m(this._sOperatorHelpId+"-pop-fl",{filterList:false,useFirstMatch:true})]})}));const d=new V(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");d.addDelegate({onAfterRendering:Ct},false,this);It.call(this,undefined,d,0,null,0);r.addContent(t);r.addContent(d);this._oInvisibleAddOperatorButtonText=new P({text:H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_DESCRIPTION")});r.addContent(this._oInvisibleAddOperatorButtonText);const u=new E(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:k.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new w({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)}}),ariaDescribedBy:this._oInvisibleAddOperatorButtonText});d.addContent(u);d.attachValidateFieldGroup(Dt,this);this.setAggregation("_content",r)}function pt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i===-1||t.length<i}function gt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i!==1}function ft(){const t=this.getConditions();const e=this.byId("conditions");const i=this.byId("pageCount");let n;let s=-1;let o=0;let a=-1;const l=this._iShownConditions+this._iShownAdditionalConditions;for(let i=0;i<t.length&&s<l;i++){const r=t[i];const u=d.getOperator(r.operator);if(r.validated!==f.Validated||u.exclude){a++;if(a>=this._iStartIndex){s++;if(s<l){const t=this._oManagedObjectModel.getContext("/conditions/"+i+"/");if(!this.oOperatorModel){this.oOperatorModel=new O;this.setModel(this.oOperatorModel,"om");at.call(this)}n=e.getContent();if(n[o]&&n[o].isA("sap.ui.mdc.Field")){o=St.call(this,r,e,o,t,s)}else{o=It.call(this,r,e,o,t,s)}}}}}n=e.getContent();while(n[o]&&n[o]!==this.byId("addBtn")){n[o].destroy();o++}Vt.call(this,undefined);i.setText(Bt.call(this));this.setProperty("_prevButtonActive",this._iStartIndex>0);this.setProperty("_nextButtonActive",s>=l);this.setProperty("_pagination",a>=l);this._bGridUpdated=true}function Ct(){if(!this._bGridUpdated){return}const t=this.byId("conditions");const e=t.getContent();let i=0;if(this._bFocusLastCondition){i=vt.call(this,"-operator");e[i].focus();this._bFocusLastCondition=false}if(this._bFocusLastRemoveBtn){i=yt.call(this,["-removeBtnLarge","-removeBtnSmall"]);e[i].focus();this._bFocusLastRemoveBtn=false}this._bGridUpdated=false}function yt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;if(!Array.isArray(t)){t=[t]}let s=0;let o=t[s];while(n>=0&&o!==undefined){const e=i[n];if(e.getId().endsWith(o)){const i=jQuery(e.getDomRef());if(i.is(":visible")){return n}else{s++;o=t[s]}}n--}return 0}function vt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;const s=t;while(n>=0){const t=i[n];if(t.getId().endsWith(s)){return n}n--}return 0}function It(t,e,i,n,s){const o=this.getId()+"--"+s;if(!this._oOperatorFieldType){this._oOperatorFieldType=new x({},{minLength:1})}const a=new y(o+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:p.Description,editMode:h.Editable,multipleLines:false,valueHelp:this._sOperatorHelpId,change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new w({span:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:_t.bind(this)},linebreak:true})).setBindingContext(n,"$this");if(n){a.setFieldGroupIds([n.getPath()])}this._oObserver.observe(a,{properties:["value"]});e.insertContent(a,i);i++;const l=new E(o+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:k.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new w({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:bt},visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n,"$this");if(n){l.setFieldGroupIds([n.getPath()])}e.insertContent(l,i);i++;if(t){for(let s=0;s<t.values.length;s++){const a=tt.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}const r=new E(o+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:k.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new w({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:bt},visibleS:false,visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)}})).setBindingContext(n,"$this");e.insertContent(r,i);i++;return i}function mt(t,e){if(!t){return this.getEditMode()}else if(e){return h.ReadOnly}const i=d.getOperator(t);let n=false;if(i&&i.valueTypes[0]===C.Static){n=true}return n?h.Display:h.Editable}function bt(t){const e=t&&d.getOperator(t);if(!e||!e.valueTypes[0]||e.valueTypes[0]===C.Static&&!e.getStaticText){return"XL8 L8 M8 S0"}else{return""}}function _t(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;let n="XL3 L3 M3 ";if(i===1){n+="S12"}else{n+="S10"}return n}function Ot(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;const n=t&&d.getOperator(t.operator);let s="";if(n&&n.valueTypes[1]){s="XL4 L4 M4 "}else{s="XL8 L8 M8 "}if(i===1){s+="S12"}else{s+="S10"}return s}function Tt(t){const e=t&&d.getOperator(t);if(e&&e.aLabels){return e.aLabels[0]}else if(e&&e.valueTypes[1]){return H.getText("valuehelp.DEFINECONDITIONS_FROM")}else{return H.getText("valuehelp.DEFINECONDITIONS_VALUE")}}function xt(t){const e=t&&d.getOperator(t);if(e&&e.aLabels){return e.aLabels[1]}else if(e&&e.valueTypes[1]){return H.getText("valuehelp.DEFINECONDITIONS_TO")}}function St(t,e,i,n,s){const o=this.getId()+"--"+s;let a=e.getContent();let l;const r=a[i];r.setBindingContext(n,"$this");if(n){r.setFieldGroupIds([n.getPath()])}if(r.getValueState()===G.Error&&!t.invalid){r.setValue(r.getValue());r.setValueState(G.None);r.setValueStateText()}i++;const d=a[i];d.setBindingContext(n,"$this");if(n){d.setFieldGroupIds([n.getPath()])}i++;let u;let c=a[i];let h;if(c.hasOwnProperty("_iValueIndex")&&c._iValueIndex===0){c.setValueHelp?.(Q(t.operator)&&this._getValueHelp());if(t.values.length>0){u=this._oManagedObjectModel.getContext(n.getPath()+"values/0/");c.setBindingContext(u,"$this");c.setBindingContext(n,"$condition");if(c.getMetadata().hasProperty("value")&&(this._bUpdateType||!c.getBindingInfo("value"))){l=et.call(this,t.operator,0);c.bindProperty("value",{path:"$this>",type:l})}i++;h=a[i];if(h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){if(t.values.length>1){u=this._oManagedObjectModel.getContext(n.getPath()+"values/1/");h.setBindingContext(u,"$this");if(h.getMetadata().hasProperty("value")&&(this._bUpdateType||!h.getBindingInfo("value"))){l=et.call(this,t.operator,1);h.bindProperty("value",{path:"$this>",type:l})}i++}else{h.destroy()}}else if(t.values.length>1){h=tt.call(this,t,1,o+"-values1",n);if(h){e.insertContent(h,i);i++}}}else{c.destroy();c=undefined;h=a[i+1];if(h&&h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){h.destroy()}}}else if(t.values.length>0){for(let s=0;s<t.values.length;s++){const a=tt.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}a=e.getContent();const p=a[i];p.setBindingContext(n,"$this");i++;return i}function Dt(t){if(this._bPendingChange){this._bPendingValidateCondition=true;return}let e=t.getSource();while(!(e.getParent()instanceof V)){e=e.getParent()}Pt.call(this,e)}function Pt(t){const e=t.getParent();let i=e.indexOfContent(t);let n;if(t.getId().endsWith("-operator")){n=t.getBindingContext("$this");i=i+2;t=e.getContent()[i]}else if(t.getId().endsWith("-removeBtnSmall")){n=t.getBindingContext("$this");i=i+1;t=e.getContent()[i]}else{n=t.getBindingContext("$condition")}let s;const o=n.getObject();const a=d.getOperator(o.operator);let l=!!o.invalid;if(!l&&a.valueTypes.length>0&&a.valueTypes[0]!==C.Static){if(a.valueTypes.length>1&&a.valueTypes[1]){if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===0){s=e.getContent()[i+1]}else if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===1){s=e.getContent()[i-1]}}if(t instanceof y&&!t.isInvalidInput()&&(!s||!s.isInvalidInput())){const e=t.getBinding("value").getType();try{a.validate(o.values,e);t.setValueState(G.None);t.setValueStateText();if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.None);s.setValueStateText()}}catch(e){l=true;t.setValueState(G.Error);t.setValueStateText(e.message);if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.Error);s.setValueStateText(e.message)}}}if(!l){const e=this.getConditions();const i=n.getPath();const a=parseInt(i.split("/")[2]);for(let i=0;i<e.length;i++){if(i!==a&&!o.isEmpty&&d.compareConditions(o,e[i])){l=true;t.setValueState(G.Error);t.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[o.values[0]]));if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.Error);s.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[o.values[1]]))}break}}}}Vt.call(this,l);this.fireConditionProcessed()}function Vt(t){let e=0;if(t!==true){const i=this.getConditions();for(e=0;e<i.length;e++){if(i[e].invalid){t=true;break}}}if(t!==true){const i=this.byId("conditions");const n=i.getContent();t=false;for(e=0;e<n.length;e++){const i=n[e];if(i.hasOwnProperty("_iValueIndex")&&(i instanceof y&&i.isInvalidInput()||i.getValueState&&i.getValueState()===G.Error)){if(i instanceof y&&!i.isInvalidInput()){let t=false;const e=i.getBindingContext("$condition");const n=e.getObject();const s=this.getConditions();const o=e.getPath();const a=parseInt(o.split("/")[2]);for(let e=0;e<s.length;e++){if(e!==a&&!n.isEmpty&&d.compareConditions(n,s[e])){t=true;break}}if(!t){i.setValueState(G.None);i.setValueStateText();continue}}t=true}}}this.setProperty("inputOK",!t,true)}function wt(){return this.getConditions().filter(t=>{const e=d.getOperator(t.operator);return t.validated!==f.Validated||e.exclude})}function Nt(t){this._iStartIndex=this._iStartIndex+this._iShownConditions;this._iShownAdditionalConditions=0;ft.call(this)}function Et(t){this._iStartIndex=this._iStartIndex-this._iShownConditions;if(this._iStartIndex<0){this._iStartIndex=0}this._iShownAdditionalConditions=0;ft.call(this)}function Mt(t){const e=this.getConditions().filter(t=>{const e=d.getOperator(t.operator);return t.validated===f.Validated&&!e.exclude});this.addDummyCondition(e.length+1);this._iStartIndex=0;this._iShownAdditionalConditions=0;this.setProperty("conditions",e,true);this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),X.Assertive);this.fireConditionProcessed()}function $t(t){const e=this.getConditions();const i=n({},this.getConfig());const s=i.maxConditions;const o=this.byId("conditions");const a=o.getContent();let l=0;let r=-1;for(const t of a){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){l++;if(l===1){const e=t.getBindingContext("$this");const i=e.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){r=parseInt(n[1])}}}}if(s===-1||e.length<s){this.addDummyCondition(r);if(l>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),X.Assertive)}function Bt(){const t=wt.call(this);const e=Math.ceil((t.length-this._iShownAdditionalConditions)/this._iShownConditions);const i=Math.floor(this._iStartIndex/this._iShownConditions)+1;const n=H.getText("valuehelp.PAGE_COUNT",[i,e]);return n}return z});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/DialogTab", ["sap/ui/core/Control"],e=>{"use strict";const t=e.extend("sap.ui.mdc.valuehelp.base.DialogTab",{metadata:{library:"sap.ui.mdc",properties:{content:{type:"object"}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapUiMdcDialogTab");e.openEnd();const n=t.getContent();if(n){e.renderControl(n)}e.close("div")}}});t.prototype.init=function(){e.prototype.init.apply(this,arguments)};t.prototype.exit=function(){if(this._displayContent){this._displayContent=null}return e.prototype.exit.apply(this,arguments)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/FilterableListContent", ["sap/ui/core/Lib","sap/ui/mdc/util/loadModules","sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/Common","sap/m/p13n/enums/PersistenceMode","sap/m/p13n/Engine","sap/base/util/merge","sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/Log"],(e,t,i,n,r,o,s,l,a,c,h,p,d)=>{"use strict";const u=i.extend("sap.ui.mdc.valuehelp.base.FilterableListContent",{metadata:{library:"sap.ui.mdc",properties:{filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},group:{type:"string",defaultValue:""}},aggregations:{filterBar:{type:"sap.ui.mdc.valuehelp.FilterBar",multiple:false},_defaultFilterBar:{type:"sap.ui.mdc.valuehelp.FilterBar",multiple:false,visibility:"hidden"}},associations:{},events:{}}});u.prototype.init=function(){i.prototype.init.apply(this,arguments);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oObserver.observe(this,{aggregations:["_defaultFilterBar","filterBar"]});this._oObserver.observe(this,{properties:["filterFields"]});a.getInstance().defaultProviderRegistry.attach(this,l.Transient);this.resetListBinding()};u.prototype.resetListBinding=function(){return this._addPromise("listBinding")};u.prototype.awaitListBinding=function(){return this._retrievePromise("listBinding")};u.prototype.resolveListBinding=function(){const e=this.getListBinding?.();if(e){this._resolvePromise("listBinding",e);this._updateBasicSearchField();return e}};u.prototype.handleFilterValueUpdate=function(e){if((this.isContainerOpening()||this.isContainerOpen())&&this._bContentBound){Promise.resolve(this.applyFilters()).finally(()=>{i.prototype.handleFilterValueUpdate.call(this,e)})}};u.prototype.applyFilters=function(){};u.prototype.getItemFromContext=function(e,t){const i=t&&t.keyPath||this.getKeyPath();const n=t&&t.descriptionPath||this.getDescriptionPath();let r;let o;if(!i){throw new Error("KeyPath missing")}if(e){r=i?e.getProperty(i):undefined;o=n?e.getProperty(n):undefined}if(r===null||r===undefined){return false}const s=this.createConditionPayload([r,o],e);return{key:r,description:o,payload:s}};u.prototype.createConditionPayload=function(e,t){let i;const n=this.getValueHelpDelegate();if(n){const r=this.getValueHelpInstance();i={};i=n.createConditionPayload(r,this,e,t)}return i};u.prototype._isContextSelected=function(e,t){return!!e&&!!this._findConditionsForContext(e,t).length};u.prototype._findConditionsForContext=function(e,t){const i=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();if(e&&i){if(i.isFilterableListItemSelected){d.warning("MDC.ValueHelp","Delegate method 'isFilterableListItemSelected' is deprecated, please implement 'findConditionsForContext' instead.");const n=i.isFilterableListItemSelected(this.getValueHelpInstance(),this,{getBindingContext:function(){return e}},t);if(n){const i=this.getItemFromContext(e);const n=i&&this.createCondition(i.key,i.description,i.payload);return t.filter(e=>p.compareConditions(e,n))}return[]}return i.findConditionsForContext(this.getValueHelpInstance(),this,e,t)}return[]};u.prototype._createDefaultFilterBar=function(){return t(["sap/ui/mdc/valuehelp/FilterBar"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=new t(this.getId()+"-FB",{liveMode:false,showGoButton:true});this.setAggregation("_defaultFilterBar",i,true);return i})};u.prototype._handleSearch=function(e){const t=e.getSource();this._setLocalFilterValue(t.getSearch());this.applyFilters()};u.prototype._updateBasicSearchField=function(){const e=this.getActiveFilterBar();if(e){const i=e.getBasicSearchField();let n=this.isSearchSupported();let r="$search";if(!this.isPropertyInitial("filterFields")){r=this.getFilterFields();n=!!r}if(!i&&n){if(!this._oSearchField){return t(["sap/ui/mdc/FilterField"]).then(t=>{if(!this.isDestroyStarted()&&!e.isDestroyed()){const e=t[0];this._oSearchField=new e(this.getId()+"-search",{conditions:"{$filters>/conditions/"+r+"}",propertyKey:r,dataType:"sap.ui.model.type.String",placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"});this._oSearchField._bCreatedByValueHelp=true;this._updateBasicSearchField()}})}e.setBasicSearchField(this._oSearchField)}else if(i){if(n){}else if(i._bCreatedByValueHelp){e.setBasicSearchField()}}}};u.prototype.onContainerClose=function(){this._setLocalFilterValue(undefined)};u.prototype.getActiveFilterBar=function(){return this.getFilterBar()||this.getAggregation("_defaultFilterBar")};u.prototype.observeChanges=function(e){if(e.object==this){let t;if(["_defaultFilterBar","filterBar"].indexOf(e.name)!==-1){t=e.child;let i;if(e.mutation==="insert"){this._updateBasicSearchField();this._assignCollectiveSearchSelect()}else{const n=t.getBasicSearchField();if(n&&n._bCreatedByValueHelp){t.setBasicSearchField()}if(e.name==="filterBar"){i=this.getAggregation("_defaultFilterBar");if(!i){this._createDefaultFilterBar()}}}}if(e.name==="filterFields"){this._updateBasicSearchField()}}i.prototype.observeChanges.apply(this,arguments)};u.prototype.getCollectiveSearchKey=function(){return this._oCollectiveSearchSelect&&this._oCollectiveSearchSelect.getSelectedItemKey()};u.prototype.getListBindingInfo=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.")};u.prototype._getListItemBindingContext=function(e){const t=this.getListBindingInfo().model;return e&&e.getBindingContext(t)};u.prototype.getInitialFocusedControl=function(){return this.getActiveFilterBar().getInitialFocusedControl()};u.prototype._getTypesForConditions=function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();return t?t.getTypesForConditions(i,this,e):{}};u.prototype.getFormattedTitle=function(e){let t=i.prototype.getFormattedTitle.apply(this,arguments);if(!t){t=this._oResourceBundle.getText(e?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[e])}return t};u.prototype.getFormattedShortTitle=function(){let e=this.getShortTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.Shorttitle")}return e};u.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.TokenizerTitle"+(e===0?"NoCount":""),[e])}return t};u.prototype.isSearchSupported=function(){if(!this.isPropertyInitial("filterFields")){const e=this.getFilterFields();if(e!=="$search"){return!!e}}return!!this.isValueHelpDelegateInitialized()&&!!this.getValueHelpDelegate()?.isSearchSupported(this.getValueHelpInstance(),this,this.getListBinding())};u.prototype.setCollectiveSearchSelect=function(e){this._oCollectiveSearchSelect=e;this._assignCollectiveSearchSelect()};u.prototype._assignCollectiveSearchSelect=function(){const e=this.getActiveFilterBar();if(e.setCollectiveSearch){e.setCollectiveSearch(this._oCollectiveSearchSelect)}};u.prototype.onBeforeShow=function(e){const t=this.getActiveFilterBar();if(t&&!t._bAttached){t.attachSearch(this._handleSearch,this);t._bAttached=true}if(e){this._updateBasicSearchField();const i=this.getValueHelpDelegate();return Promise.resolve(i&&i.getFilterConditions(this.getValueHelpInstance(),this)).then(i=>{this._oInitialFilterConditions=i;if(t){let i="$search";if(!this.isPropertyInitial("filterFields")){i=this.getFilterFields()}const n=c({},this._oInitialFilterConditions);const r=Promise.resolve(!n[i]&&h.retrieveExternalState(t).then(r=>{if(e){f(n,i,this.getSearch());return h.diffState(t,r,{filter:n})}})).then(e=>h.applyExternalState(t,e));t.cleanUpAllFilterFieldsInErrorState();return r.then(()=>t.awaitPendingModification())}})}return Promise.resolve()};u.prototype.onHide=function(){i.prototype.onHide.apply(this,arguments);const e=this.getActiveFilterBar();if(e?._bAttached){e.detachSearch(this._handleSearch,this);e._bAttached=false}};u.prototype._fireSelect=function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=t&&t.modifySelectionBehaviour?t.modifySelectionBehaviour(i,this,e):e;if(n){this.fireSelect(n)}};u.prototype.exit=function(){a.getInstance().defaultProviderRegistry.detach(this);s.cleanup(this,["_oCollectiveSearchSelect","_oInitialFilterConditions"]);if(this._oSearchField&&!this._oSearchField.getParent()){this._oSearchField.destroy();delete this._oSearchField}i.prototype.exit.apply(this,arguments)};u.prototype.getCount=function(e,t){const n=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();const r=n&&this.getValueHelpInstance();return n&&n.getCount?n.getCount(r,this,e,t):i.prototype.getCount.apply(this,arguments)};u.prototype._getLocalFilterValue=function(){const e=this.getParent();return e&&e.getLocalFilterValue()};u.prototype._setLocalFilterValue=function(e){const t=this.getParent();return t&&t.setLocalFilterValue(e)};u.prototype.getSearch=function(){const e=this._getLocalFilterValue();if(typeof e!=="undefined"){return e}return this.getFilterValue()};u.prototype.getSelectableConditions=function(){return this.getConditions().filter(e=>e.validated===r.Validated)};u.prototype.clone=function(e,t){const n=this.getActiveFilterBar();const r=n?._bAttached;if(r){n.detachSearch(this._handleSearch,this);n._bAttached=false}const o=i.prototype.clone.apply(this,arguments);if(r){n.attachSearch(this._handleSearch,this);n._bAttached=true}return o};function f(e,t,i){e[t]=i?[n.createCondition(o.Contains,[i],undefined,undefined,r.NotValidated)]:[];return}return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/base/ListContent", ["sap/ui/mdc/valuehelp/base/Content","sap/ui/mdc/enums/ConditionValidated"],(e,t)=>{"use strict";const a=e.extend("sap.ui.mdc.valuehelp.base.ListContent",{metadata:{library:"sap.ui.mdc",properties:{caseSensitive:{type:"boolean",defaultValue:false},useFirstMatch:{type:"boolean",group:"Behavior",defaultValue:true},useAsValueHelp:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{},events:{}}});a.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["caseSensitive"]})};a.prototype.observeChanges=function(t){if(t.name==="caseSensitive"){this.handleFilterValueUpdate(t)}e.prototype.observeChanges.apply(this,arguments)};a.prototype.getCount=function(e){let a=0;for(const i of e){if(i.isEmpty!==true&&i.validated===t.Validated){a++}}return a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/Bool", ["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/util/loadModules","sap/ui/model/ParseException"],(e,t,o)=>{"use strict";const s=e.extend("sap.ui.mdc.valuehelp.content.Bool",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent"]}});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setUseFirstMatch(true);this.setUseAsValueHelp(true);this.setFilterList(false);this.setCaseSensitive(false);this._oObserver.observe(this,{properties:["config"]})};s.prototype.exit=function(){if(this._oModel){this._oModel.destroy();this._oModel=undefined}e.prototype.exit.apply(this,arguments)};s.prototype.getContent=function(){return this._retrievePromise("boolContent",()=>t(["sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/json/JSONModel"]).then(function(t){if(this.isDestroyStarted()){return null}const o=t[0];const s=t[1];this._oModel=new s({type:"",items:[{key:true,text:"true"},{key:false,text:"false"}]});i.call(this,this.getConfig());const n=new o(this.getId()+"-Item",{key:{path:"$Bool>key"},text:{path:"$Bool>text"}});this.bindAggregation("items",{path:"$Bool>/items",template:n});this.setModel(this._oModel,"$Bool");return e.prototype.getContent.apply(this,arguments)}.bind(this)))};s.prototype.getItemForValue=function(e){return Promise.resolve().then(()=>{const t=this.getConfig();const s=e.dataType||t&&t.dataType;if(s){if(e.checkKey){if(e.parsedValue===true||e.parsedValue===false){return{key:e.parsedValue,description:s.formatValue(e.parsedValue,"string")}}else{e.checkDescription=true}}if(e.checkDescription&&e.value){const t=s.formatValue(true,"string");if(t.toLowerCase().startsWith(e.value.toLowerCase())){return{key:true,description:t}}const o=s.formatValue(false,"string");if(o.toLowerCase().startsWith(e.value.toLowerCase())){return{key:false,description:o}}}const t=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[e.value]);const i=e.exception||o;throw new i(t)}else{throw new Error("Type missing")}})};s.prototype.shouldOpenOnClick=function(){return false};s.prototype.isNavigationEnabled=function(e){return true};s.prototype.observeChanges=function(t){if(t.type==="property"&&t.name==="config"){i.call(this,t.current)}e.prototype.observeChanges.apply(this,arguments)};function i(e){if(this._oModel&&e){const t=e.dataType;const o=this._oModel.getData();if(t&&o["type"]!==t.getMetadata().getName()){o["type"]=t.getMetadata().getName();const e=o["items"];for(const o of e){o["text"]=t.formatValue(o["key"],"string")}this._oModel.checkUpdate(true)}}}return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/Conditions", ["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/Content","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/util/Common"],(e,t,i,n,o,l)=>{"use strict";const s=t.extend("sap.ui.mdc.valuehelp.content.Conditions",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],properties:{label:{type:"string"}},aggregations:{},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{}}});s.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")};s.prototype.exit=function(){l.cleanup(this,["_oScrollContainer","_oDefineConditionPanel"]);t.prototype.exit.apply(this,arguments)};s.prototype.getContent=function(){return this._retrievePromise("content",()=>{const e=["sap/ui/mdc/valuehelp/base/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"];if(this.provideScrolling()){e.push("sap/m/ScrollContainer")}return i(e).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=e[1];const n=e.length>2&&e[2];this._oManagedObjectModel=new i(this);this._oDefineConditionPanel=new t(this.getId()+"-DCP",{label:"{$help>/label}",conditions:"{$help>/conditions}",inputOK:"{$valueHelp>/_valid}",config:{path:"$help>/config"},conditionProcessed:a.bind(this),valueHelp:this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}).setModel(this._oManagedObjectModel,"$help");if(n){this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true,content:[this._oDefineConditionPanel]});this.setAggregation("displayContent",this._oScrollContainer);return this._oScrollContainer}else{this.setAggregation("displayContent",this._oDefineConditionPanel);return this._oDefineConditionPanel}})})};s.prototype.getCount=function(e){let t=0;for(const i of e){if(i.isEmpty!==true&&i.validated===o.NotValidated){t++}}return t};s.prototype.getUseAsValueHelp=function(){return false};s.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};s.prototype.isFocusInHelp=function(){return true};s.prototype.getInitialFocusedControl=function(){return this._oDefineConditionPanel.getInitialFocusedControl()};s.prototype.getRequiresTokenizer=function(){return true};s.prototype.getFormattedTitle=function(e){let i=t.prototype.getFormattedTitle.apply(this,arguments);if(!i){i=this._oResourceBundle.getText(e?"valuehelp.DEFINECONDITIONS":"valuehelp.DEFINECONDITIONSNONUMBER",[e])}return i};s.prototype.getFormattedShortTitle=function(){let e=this.getShortTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.Shorttitle")}return e};s.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.TokenizerTitle"+(e===0?"NoCount":""),[e])}return t};s.prototype.getAriaAttributes=function(e){return{contentId:this.getId()+"-DCP",ariaHasPopup:"dialog",roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};s.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{showArrow:true,showHeader:true,getContentWidth:function(){return"500px"},getFooter:function(){return this._retrievePromise("footer",()=>i(["sap/m/library","sap/m/Button"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const{ButtonType:i}=t;const n=e[1];const o=new n(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:i.Emphasized,press:r.bind(this)});const l=new n(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.fireCancel.bind(this)});return[o,l]}))}.bind(this)}}};s.prototype.onContainerClose=function(){if(this._oDefineConditionPanel){this._oDefineConditionPanel.cleanUp()}};function r(e){this.fireConfirm({close:true})}function a(e){let t=this.getConditions();if(this.getMaxConditions()===1){t=t.filter(e=>e.validated==="NotValidated")}this.fireSelect({type:n.Set,conditions:t})}return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/FixedList", ["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/ParseException","sap/base/util/deepEqual"],(t,e,i,s,n,o,a,l)=>{"use strict";const r=e.extend("sap.ui.mdc.valuehelp.content.FixedList",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],properties:{groupable:{type:"boolean",group:"Appearance",defaultValue:false},filterList:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.valuehelp.content.FixedListItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{}}});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oResourceBundle=t.getResourceBundleFor("sap.ui.mdc");this._iNavigateIndex=-1};r.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}e.prototype.exit.apply(this,arguments)};r.prototype.getContent=function(){return this._retrievePromise("content",()=>i(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/base/ManagedObjectModel","sap/base/strings/whitespaceReplacer"]).then(t=>{if(this.isDestroyStarted()){return null}const e=t[0];const i=t[1];const s=t[2];const n=t[3];const o=t[4];const a=t[5];const l=t[6];this._oManagedObjectModel=new a(this);const r=new i(this.getId()+"-item",{type:s.ListType.Active,label:{path:"$help>text",formatter:l},value:{path:"$help>additionalText",formatter:l},valueTextDirection:"{$help>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");const c=new n({path:"text",test:p.bind(this),caseSensitive:true});let h;if(this.getGroupable()){h=new o("groupKey",false,f.bind(this))}const d=new e(this.getId()+"-List",{width:"100%",showNoData:false,mode:s.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$help>/items",template:r,filters:c,sorter:h,templateShareable:false},itemPress:u.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");d.applyAriaRole("listbox");d.setModel(this._oManagedObjectModel,"$help");this.setAggregation("displayContent",d,true);m.call(this);return d}))};r.prototype._handleFirstMatchSuggest=function(){const t=this.isTypeahead();const e=c.call(this)?.getItems();const i=this.getFilterValue();const s=this.getUseFirstMatch();if(t&&s&&e?.length&&i){const t=this.getValueHelpDelegate();const s=t.isFilteringCaseSensitive(this.getValueHelpInstance(),this);const n=t.getFirstMatch(this.getValueHelpInstance(),this,{value:this.getFilterValue(),checkDescription:!!this.getDescriptionPath(),control:this.getControl(),caseSensitive:s});if(n){const t=e.find(t=>t.getBindingContext("$help")===n);const o=y.call(this,t);const a=this.createCondition(v.call(this,o),F.call(this,o));const l=this.getListBinding()?.getCurrentContexts();const r=l?.length;this.fireTypeaheadSuggested({condition:a,filterValue:i,itemId:t?.getId(),items:r,caseSensitive:s})}}};function c(){return this.getAggregation("displayContent")}function u(t){const e=t.getParameter("listItem");const i=e.getSelected();if(i){const t=y.call(this,e);const i=v.call(this,t);const s=F.call(this,t);h.call(this,i,s);this.fireSelect({type:o.Set,conditions:this.getConditions()});this.fireConfirm()}}function h(t,e){const i=this.createCondition(t,e);const s=this.getConditions();if(l([i],s)){m.call(this)}else{this.setProperty("conditions",[i],true)}return i}function p(t){const e=this.getFilterList();return!e||d.call(this,t,this.getFilterValue())}function d(t,e){return!e||typeof e==="string"&&(this.getCaseSensitive()?t.startsWith(e):t.toLowerCase().startsWith(e.toLowerCase()))}function g(){const t=c.call(this);const e=this.getListBinding();if(this._iNavigateIndex>=0){this.setProperty("conditions",[],true);this._iNavigateIndex=-1;t.setFakeFocus()}if(t){e.update();t.updateItems();t.invalidate();this._handleFirstMatchSuggest();m.call(this)}}function f(t){const e=t.getProperty("groupKey");const i=t.getProperty("groupText");return{key:e,text:i}}function m(){const t=c.call(this);if(t){const e=this.getConditions();let i;let o=false;const a=this.getParent().isOpen();if(e.length>0&&(e[0].validated===s.Validated||e[0].operator===n.EQ)){i=e[0].values[0]}const l=t.getItems();l.forEach((s,n)=>{if(s.isA("sap.m.DisplayListItem")){const n=y.call(this,s);if(e.length>0&&v.call(this,n)===i){s.setSelected(true);if(a&&!s.hasStyleClass("sapMLIBFocused")){t.setFakeFocus(s)}}else if(e.length===0&&this._iNavigateIndex<0&&!o&&this._sHighlightId===s.getId()){s.setSelected(true);o=true}else{s.setSelected(false);if(a&&s.hasStyleClass("sapMLIBFocused")){t.setFakeFocus()}}}})}}function y(t){return this._oManagedObjectModel.getProperty(t.getBindingContextPath())}function I(t){return this._oManagedObjectModel.getProperty(t.getPath())}function v(t){const e=t.getBinding("key");if(e){return e.getInternalValue()}else{return t.getKey()}}function F(t){const e=t.getBinding("text");if(e){return e.getInternalValue()}else{return t.getText()}}r.prototype.getItemForValue=function(t){return this.getContent().then(()=>{if(t.value===null||t.value===undefined){return null}else if(!t.value&&t.checkDescription){return null}const e=this.getItems();let i;let s=0;let n;let o;for(s=0;s<e.length;s++){i=e[s];n=v.call(this,i);o=F.call(this,i);if(t.checkKey&&l(n,t.parsedValue)||t.checkDescription&&(l(o,t.parsedDescription)||i.getText()===t.value)){return{key:n,description:o}}}if(t.checkKey&&t.value===""){return null}if(this.getUseFirstMatch()&&!t.exactMatch){const e=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,t);if(e){return this.getItemFromContext(e)}}const r=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[t.value]);const c=t.exception||a;throw new c(r)})};r.prototype.getItemFromContext=function(t,e){const i=I.call(this,t);const s=v.call(this,i);const n=F.call(this,i);return{key:s,description:n}};r.prototype.isValidationSupported=function(t){return true};r.prototype.isSearchSupported=function(){return true};r.prototype.handleConditionsUpdate=function(t){if(this._iNavigateIndex>=0&&!this._bConditionSetByNavigate){const t=this.getConditions();const e=c.call(this);const i=e.getSelectedItem();const s=i&&y.call(this,i);if(t.length!==1||!v.call(this,s)===t[0].values[0]){this._iNavigateIndex=-1}}m.call(this)};r.prototype.handleFilterValueUpdate=function(t){g.call(this);e.prototype.handleFilterValueUpdate.apply(this,arguments)};r.prototype.removeVisualFocus=function(){const t=c.call(this);t?.removeStyleClass("sapMListFocus")};r.prototype.setVisualFocus=function(){const t=c.call(this);if(!t?.hasStyleClass("sapMListFocus")){t?.addStyleClass("sapMListFocus")}};r.prototype.navigate=function(t){const e=c.call(this);if(!e){return}const i=e.getItems();const s=i.length;const n=this._iNavigateIndex>=0?i[this._iNavigateIndex]:e.getSelectedItem();let o=0;const a=this.getFilterList();const l=this.getFilterValue();let r=false;const u=this.getParent().isOpen();if(!a&&!n){let e=0;if(t>=0){for(e=0;e<i.length;e++){if(!i[e].isA("sap.m.GroupHeaderListItem")&&d.call(this,i[e].getLabel(),l)){o=e;break}}}else{for(e=i.length-1;e>=0;e--){if(!i[e].isA("sap.m.GroupHeaderListItem")&&d.call(this,i[e].getLabel(),l)){o=e;break}}}}else if(n){o=e.indexOfItem(n);o=o+t}else if(t>=0){o=t-1}else{o=s+t}if(t===9999){o=s-1}if(t===-9999){o=0}let p;if(o<0){o=0;p=true;r=true}else if(o>=s-1){o=s-1;p=false}else{p=t>=0}const g=function(){while(i[o]&&i[o].isA("sap.m.GroupHeaderListItem")){if(p){o++}else{o--}}};if(!u||t===0){g();if(o<0||o>s-1){p=!p;r=o<0;o=o<0?0:s-1;g()}}const f=i[o];if(f){const t=this.getUseFirstMatch();if(f!==n||t&&!r||this._iNavigateIndex!==o&&!r){let t,i,s;this._iNavigateIndex=o;if(u){e.scrollToIndex(o);e.setFakeFocus(f)}if(f.isA("sap.m.GroupHeaderListItem")){this._bConditionSetByNavigate=true;this.setProperty("conditions",[],true);delete this._bConditionSetByNavigate;this.fireNavigated({condition:undefined,itemId:f.getId(),leaveFocus:false})}else{t=y.call(this,f);i=v.call(this,t);s=F.call(this,t);this._bConditionSetByNavigate=true;const e=h.call(this,i,s);delete this._bConditionSetByNavigate;const n=this.getValueHelpDelegate();const o=n.isFilteringCaseSensitive(this.getValueHelpInstance(),this);this.fireNavigated({condition:e,itemId:f.getId(),leaveFocus:false,caseSensitive:o})}if(u){this.setVisualFocus();this.fireVisualFocusSet()}}else if(r){this._iNavigateIndex=-1;this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:r})}}};r.prototype.onShow=function(t){return e.prototype.onShow.apply(this,arguments).then(()=>{const t=c.call(this);let e;if(!t){return null}const i=t.getSelectedItem();if(i){const s=t.indexOfItem(i);t.scrollToIndex(s);e=i.getId()}const s=this.getListBinding()?.getCurrentContexts();const n=s?.length;return{itemId:e,items:n}})};r.prototype.onHide=function(){this.removeVisualFocus();const t=c.call(this);t?.setFakeFocus();this._iNavigateIndex=-1};r.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};r.prototype.getAriaAttributes=function(t){return{contentId:this.getId()+"-List",ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:this.getUseFirstMatch()?"both":"none"}};r.prototype.shouldOpenOnClick=function(){return!this.getFilterList()};r.prototype.isFocusInHelp=function(){return false};r.prototype.isSingleSelect=function(t){return true};r.prototype.isNavigationEnabled=function(t){return this.getItems().length>0};r.prototype.onConnectionChange=function(){this._iNavigateIndex=-1};r.prototype.getListBinding=function(){const t=c.call(this);return t&&t.getBinding("items")};r.prototype.getKeyPath=function(){return"key"};r.prototype.getDescriptionPath=function(){return"text"};r.prototype.setHighlightId=function(t){if(this._sHighlightId!==t){this._sHighlightId=t;m.call(this)}};r.prototype.destroyItems=function(){const t=c.call(this);t?.destroyItems();return this.destroyAggregation("items")};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/FixedListItem", ["sap/ui/core/ListItem"],e=>{"use strict";const t=e.extend("sap.ui.mdc.valuehelp.content.FixedListItem",{metadata:{library:"sap.ui.mdc",properties:{groupKey:{type:"any",group:"Appearance",defaultValue:null},groupText:{type:"string",group:"Appearance",defaultValue:null}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/MDCTable", ["sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/util/Common","sap/base/Log","sap/ui/core/library","sap/ui/core/Element","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/TableRowCountMode","sap/base/util/restricted/_throttle","sap/ui/mdc/util/DensityHelper"],(e,t,i,o,n,s,l,a,r,h,p,c)=>{"use strict";const{TitleLevel:u}=n;const d=e.extend("sap.ui.mdc.valuehelp.content.MDCTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContent"],properties:{forceBind:{type:"boolean",defaultValue:false}},aggregations:{table:{type:"sap.ui.mdc.Table",multiple:false}},events:{},defaultAggregation:"table"}});d.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._bRebindTable=false};d.prototype._setTableSelectionState=function(){this._bSelectionIsUpdating=true;const e=this._getAllCurrentContexts();if(e){this._oTable._setSelectedContexts(e.filter(e=>this._isContextSelected(e,this.getConditions())))}this._bSelectionIsUpdating=false};d.prototype.handleConditionsUpdate=function(e){if(!this._bIgnoreNextConditionChange){this._setTableSelectionState()}else{this._bIgnoreNextConditionChange=false}};d.prototype._handleUpdateFinished=function(e){if(this._oTable){this.resolveListBinding();if(!this._bQueryingContexts){this._setTableSelectionState()}}};d.prototype._handleUpdateFinishedThrottled=p(d.prototype._handleUpdateFinished,100,{leading:false});d.prototype.observeChanges=function(t){if(t.name==="table"){const e=t.child;if(t.mutation==="remove"){b.call(this,this._oTable);this._oTable=null;this.resetListBinding()}else{this._oTable=e;c.syncDensity(this._oTable);this.resolveListBinding();if(this._oTable.getAutoBindOnInit()){o.warning("Usage of autobound tables may lead to unnecessary requests.")}else if(this.getForceBind()){this._bRebindTable=true}e.addDelegate({onmouseover:function(e){const t=s.closestTo(e.target);if(t&&t.isA("sap.m.ColumnListItem")){t.setType("Active")}}})}return}e.prototype.observeChanges.apply(this,arguments)};d.prototype._getAllCurrentContexts=function(){const e=this._oTable&&this._oTable.getRowBinding();if(e){return e.getAllCurrentContexts?e.getAllCurrentContexts():e.getContexts()}return undefined};d.prototype._handleSelectionChange=function(e){if(!this._bSelectionIsUpdating){this._bQueryingContexts=true;const e=this._getAllCurrentContexts();const t=e&&this._oTable.getSelectedContexts();this._bQueryingContexts=false;if(e){const i=this.getConditions();let o=i;let n=false;e.forEach(e=>{const s=this._findConditionsForContext(e,i);const l=!!s.length;const a=t.indexOf(e)>=0;if(!l&&a){const t=this.getItemFromContext(e);const i=t&&this.createCondition(t.key,t.description,t.payload);o=this.isSingleSelect()?[i]:o.concat(i);n=true}else if(l&&!a){o=o.filter(e=>s.indexOf(e)===-1);n=true}});if(n){this._prepareSelect(o,r.Set)}}}};d.prototype._prepareSelect=function(e,t){let i=typeof t==="string"&&t;i=i||(t?r.Add:r.Remove);this._bIgnoreNextConditionChange=true;this._fireSelect({type:i,conditions:e})};d.prototype._getTable=function(){return this._oTable};d.prototype.getContent=function(){return this._retrievePromise("wrappedContent",()=>t(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/ScrollContainer"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=e[1];const o=e[2];if(!this._oContentLayout){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox",{visible:"{$this>/_filterBarVisible}"});this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){const e=this._oWrapper.getActiveFilterBar.call(this._oWrapper);const t=e?[e]:[];return t};this._oTableBox=new i(this.getId()+"-TB",{height:"100%"});this._oTableBox.addStyleClass("sapMdcValueHelpPanelTableBox");this._oTableBox._oWrapper=this;this._oTableBox.getItems=function(){const e=this._oWrapper._oTable._isOfType(a.ResponsiveTable)?this._oWrapper._oScrollContainer:this._oWrapper._oTable;const t=e?[e]:[];return t};this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTableBox});this._oScrollContainer=new o(this.getId()+"-SC",{height:"calc(100% - 0.5rem)",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e}}this.setAggregation("displayContent",this._oContentLayout);if(!this.getActiveFilterBar()){return this._createDefaultFilterBar().then(()=>{this._oFilterBarVBox.invalidate();return this._oContentLayout})}return this._oContentLayout}))};d.prototype.getListBinding=function(){const e=this.getTable();return e&&e.getRowBinding()};d.prototype._configureTable=function(){if(this._oTable){const t=e.prototype.isSingleSelect.apply(this);const i=this._oTable._getType();const o=this.getActiveFilterBar();if(o&&this._oTable.getFilter()!==o.getId()){this._oTable.setFilter(o)}if(!this._oTable.getHeader()){this._oTable.setHeader(this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER"))}if(this._oTable.isPropertyInitial("headerLevel")){this._oTable.setHeaderLevel(u.H2)}if(this._oTable.isPropertyInitial("headerStyle")){this._oTable.setHeaderStyle(u.H5)}const n=t?l.SingleMaster:l.Multi;if(this._oTable.getSelectionMode()===l.None){this._oTable.setSelectionMode(n)}if(this._oTable.getSelectionMode()!==n){throw new Error("Table selectionMode needs to be "+n)}const s=this._oTable._isOfType(a.Table);if(s){const e=i.getRowCountMode();if(e===h.Auto){i.setRowCount(3)}}}};d.prototype.onShow=function(){return e.prototype.onShow.apply(this,arguments)};d.prototype.onBeforeShow=function(t){this._configureTable();return Promise.resolve(e.prototype.onBeforeShow.apply(this,arguments)).then(()=>{const e=this.getTable();if(e){this._oTable.initialized().then(()=>{_.call(this,this._oTable)});const i=e.isTableBound();const o=i&&e._oTable.getShowOverlay();if(this._bRebindTable||o){e.rebind();this._bRebindTable=false}else if(t){if(e._isOfType(a.ResponsiveTable)){this._oScrollContainer.scrollTo(0,0)}else if(i){e.scrollToIndex(0)}}}})};d.prototype.onHide=function(){e.prototype.onHide.apply(this,arguments);if(this._oTable){b.call(this,this._oTable)}};d.prototype.getScrollDelegate=function(){if(!this.isTypeahead()&&this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return e.prototype.getScrollDelegate.apply(this,arguments)};d.prototype.isQuickSelectSupported=function(){return true};d.prototype.setParent=function(t){e.prototype.setParent.apply(this,arguments)};d.prototype.isSingleSelect=function(){if(this._oTable){if(this._oTable.getSelectionMode()===l.Multi){return false}else{return true}}else{return e.prototype.isSingleSelect.apply(this,arguments)}};d.prototype.clone=function(t,i){const o=this._oTable?._bAttached;if(o){b.call(this,this._oTable)}const n=e.prototype.clone.apply(this,arguments);if(o){_.call(this,this._oTable)}return n};function _(e){if(!e._bAttached){e.attachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);e.attachEvent("selectionChange",this._handleSelectionChange,this);e._bAttached=true}}function b(e){if(e._bAttached){e.detachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);e.detachEvent("selectionChange",this._handleSelectionChange,this);e._bAttached=false}}d.prototype.exit=function t(o){i.cleanup(this,["_oContentLayout","_oFilterBarVBox","_oTableBox","_oResourceBundle","_oScrollContainer","_oTableHelper","_bSelectionIsUpdating","_sTableType","_oUITableSelectionPlugin","_oTable","_bRebindTable","_mKnownContexts","_bIgnoreNextConditionChange","_bQueryingContexts"]);e.prototype.exit.apply(this,arguments)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/mdc/valuehelp/content/MTable", ["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/util/loadModules","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/mdc/util/Common","sap/base/strings/formatMessage","sap/base/util/merge","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/Log","sap/ui/core/Element","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/m/table/Util"],(e,t,i,s,n,o,a,l,h,r,c,d,g,u,p,f,_)=>{"use strict";const{ListMode:m}=n;const{Sticky:I}=n;const S=t.extend("sap.ui.mdc.valuehelp.content.MTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],aggregations:{table:{type:"sap.m.Table",multiple:false}},events:{contentUpdated:{}},defaultAggregation:"table"}});S.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oMResourceBundle=e.getResourceBundleFor("sap.m");this._iNavigateIndex=-1;this._sHighlightId=undefined;this._bAnnounceTableUpdate=false};S.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};function y(){const e=this._getTable();if(e){const i=e.getItems();const s=this.getConditions();const n=this.isSingleSelect()&&!t.prototype.isSingleSelect.apply(this);const o=this.getParent().isOpen();i.forEach(t=>{const i=this._getListItemBindingContext(t);if(n&&e.indexOfItem(t)!==this._iNavigateIndex){t.setSelected(false)}else{t.setSelected(this._isContextSelected(i,s))}if(this.isTypeahead()){if(this.isSingleSelect()){if(e.indexOfItem(t)===this._iNavigateIndex||t.getSelected()&&(!this._sHighlightId||t.getId()===this._sHighlightId)){if(o&&!t.hasStyleClass("sapMLIBFocused")){e.setFakeFocus(t)}}else if(t.getId()===this._sHighlightId){t.addStyleClass("sapMLIBSelected").updateSelectedDOM(true,t.$())}else{if(o&&t.hasStyleClass("sapMLIBFocused")){e.setFakeFocus()}if((!t.getSelected()||this._sHighlightId&&t.getId()!==this._sHighlightId)&&t.hasStyleClass("sapMLIBSelected")){t.removeStyleClass("sapMLIBSelected").updateSelectedDOM(false,t.$())}}}}})}T.call(this)}function b(){if(!this._oUpdateSelectionPromise&&!this.isDestroyed()){this._oUpdateSelectionPromise=new Promise(e=>{this._iUpdateSelectionTimeout=setTimeout(()=>{if(!this.isDestroyed()){y.call(this)}e()},0)})}return this._oUpdateSelectionPromise}function T(){if(this._iUpdateSelectionTimeout){clearTimeout(this._iUpdateSelectionTimeout);this._iUpdateSelectionTimeout=null;delete this._oUpdateSelectionPromise}}S.prototype.onBeforeShow=function(e){return Promise.resolve(t.prototype.onBeforeShow.apply(this,arguments)).then(()=>{if(!this._bNavigateInitialize){const e=this._getTable();M.call(this,e)}if(e){const e=this.getListBinding();const t=this.getListBindingInfo();const i=e&&e.isSuspended();const s=!e&&t&&t.suspended;if((i||s)&&!this.isTypeahead()){return undefined}return this.applyFilters()}})};S.prototype.applyFilters=function(){this._bAnnounceTableUpdate=!this.isTypeahead()&&this.isContainerOpen();if(this._iNavigateIndex>=0&&this.getParent().isOpen()){this._iNavigateIndex=-1;this.removeVisualFocus();if(this.isSingleSelect()){this.setProperty("conditions",[],true)}}this._sHighlightId=undefined;const e=function(){if(!this.isDestroyed()){return this.applyFilters()}}.bind(this);const t=this.getListBinding();const i=this.isValueHelpDelegateInitialized();let s;if(!t||!i){s=Promise.all([this.awaitListBinding(),this.awaitValueHelpDelegate()]).then(e)}if(!i||!this.isTypeahead()&&!this.isContainerOpen()&&t.isSuspended()){return undefined}if(!s){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=this.getListBindingInfo();const o=n&&n.length;e.updateBindingInfo(i,this,n);e.updateBinding(i,t,n,this);s=Promise.resolve(e.checkListBindingPending(i,t,o))}this._addPromise("applyFilters",s);return s.finally(()=>{const e=this._retrievePromise("applyFilters");e?.getInternalPromise().then(e=>{this._handleFirstMatchSuggest(this._oTable.getItems())});return e&&e.getInternalPromise()})};S.prototype._handleSelectionChange=function(e){const t=this.isTypeahead();if(!t||!this.isSingleSelect()){const i=e.getParameters();const s=i.listItems||i.listItem&&[i.listItem];if(t&&s.length===1&&f(s[0].getDomRef(),document.activeElement)&&s[0].getDomRef()!==document.activeElement){s[0].focus()}const n=s.map(e=>{const t=this._getListItemBindingContext(e);const i=this.getItemFromContext(t);return i&&this.createCondition(i.key,i.description,i.payload)});this._fireSelect({type:i.selected?d.Add:d.Remove,conditions:n});if(t){this.fireConfirm()}}};S.prototype._handleItemPress=function(e){const t=e.getParameter("listItem");const i=this._getListItemBindingContext(t);const s=this.getItemFromContext(i);const n=this._getTable();const o=n.getMode()===m.SingleSelectMaster;const a=o?t.getSelected():!t.getSelected();t.setSelected(a);const l=a?d.Add:d.Remove;const h=this.createCondition(s.key,s.description,s.payload);this._fireSelect({type:l,conditions:[h]});if(this.isTypeahead()){this.fireConfirm({close:true})}};S.prototype._updateHeaderText=function(e){const t=this.getListBinding();if(!this.isTypeahead()&&this._oTablePanel&&t){const t=this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER");const i=this.getListBinding()?.getCount?.()||0;const s=i>0?this._oResourceBundle.getText("valuehelp.TABLETITLE",[i]):t;this._oTablePanel.setHeaderText(s);if(e&&this._bAnnounceTableUpdate){_.announceTableUpdate(t,i);this._bAnnounceTableUpdate=false}}};S.prototype._handleUpdateFinished=function(){if(this.getParent().isOpen()){this._updateHeaderText(true);b.apply(this).then(()=>{if(this._bScrollToSelectedItem){const e=this._getTable();if(e&&this.isTypeahead()&&this.isSingleSelect()){const t=this._iNavigateIndex>=0?e.getItems()[this._iNavigateIndex]:e.getSelectedItem();if(t){this._handleScrolling(t)}}this._bScrollToSelectedItem=false}})}};S.prototype._getTable=function(){return this._oTable};function v(e,t){return[m.SingleSelectMaster,...e?[]:[m.SingleSelectLeft],...t?[]:[m.MultiSelect]]}S.prototype.onShow=function(e){const i=this._getTable();if(i){if(!i.hasStyleClass("sapMComboBoxList")){i.addStyleClass("sapMComboBoxList")}const e=this.isTypeahead();const s=t.prototype.isSingleSelect.apply(this);const n=i.getMode();if(n===m.None){const t=e?m.SingleSelectMaster:m.SingleSelectLeft;i.setMode(s?t:m.MultiSelect)}else{const t=v(e,s);if(!t.includes(n)){throw new Error(`Table selection mode needs to be '${t.join("' or '")}'`)}}}this._updateHeaderText();return t.prototype.onShow.apply(this,arguments).then(e=>Promise.resolve(this._oUpdateSelectionPromise).then(()=>{const t=this.isSingleSelect();if(i&&this.isTypeahead()){if(t){let t;if(this._iNavigateIndex>=0){t=i.getItems()[this._iNavigateIndex]}else if(this._sHighlightId){t=i.getItems().find(e=>e.getId()===this._sHighlightId)}else{t=i.getSelectedItem()}if(t){this._handleScrolling(t);e.itemId=t.getId()}else{this._bScrollToSelectedItem=true;if(i.getItems().length===0&&i.getShowNoData()){e.itemId=i.getId("nodata-text")}}}e.items=w.call(this)}return e}))};S.prototype.onHide=function(){t.prototype.onHide.apply(this,arguments);const e=this.getTable();if(e){this.removeVisualFocus();e?.setFakeFocus();if(e.hasStyleClass("sapMComboBoxList")){e.removeStyleClass("sapMComboBoxList")}D.call(this,e)}this._iNavigateIndex=-1;this._bScrollToSelectedItem=false;this._sHighlightId=undefined};S.prototype.handleConditionsUpdate=function(e){if(this._iNavigateIndex>=0&&!this._bConditionSetByNavigate){const e=this.getConditions();const t=this._getTable();const i=t.getItems();const s=this._getListItemBindingContext(i[this._iNavigateIndex]);if(!this._isContextSelected(s,e)){this._iNavigateIndex=-1}}b.call(this)};S.prototype.getContent=function(){if(!this.isTypeahead()){return this._retrievePromise("wrappedContent",()=>s(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/Panel","sap/m/ScrollContainer","sap/ui/model/resource/ResourceModel"]).then(e=>{if(this.isDestroyStarted()){return null}const[t,i,s,n,o]=e;if(!this._oContentLayout&&!this.isDestroyed()){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox");this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper.getActiveFilterBar.call(this._oWrapper)]};if(!this.getModel("$i18n")){this.setModel(new o({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}this._oTablePanel=new s(this.getId()+"-TablePanel",{expanded:true,height:"100%",headerText:this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER")});this._oTablePanel.addStyleClass("sapMdcTablePanel");this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTablePanel});this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e};this._oTablePanel.addContent(this._oScrollContainer)}this.setAggregation("displayContent",this._oContentLayout);const a=this.getActiveFilterBar();if(!a){return this._createDefaultFilterBar().then(()=>this._oContentLayout)}return this._oContentLayout}))}return this._oTable};S.prototype.getItemForValue=function(e){if(!e.checkKey&&!e.checkDescription){return null}if(e.checkKey&&!e.hasOwnProperty("parsedValue")){throw new Error("MTable: Cannot check key without a given parsedValue! "+this.getId())}if(e.checkDescription&&!e.hasOwnProperty("parsedDescription")){throw new Error("MTable: Cannot check description without a given parsedDescription! "+this.getId())}if(e.checkKey&&!this.getKeyPath()){throw new Error("MTable: KeyPath missing! "+this.getId())}if(e.checkDescription&&!this.getDescriptionPath()){throw new Error("MTable: DescriptionPath missing! "+this.getId())}e.caseSensitive=e.caseSensitive||this.getCaseSensitive();const t=x.call(this);const i=this.getValueHelpDelegate();const s=this.getValueHelpInstance();const n=i&&i.getFilterConditions(s,this,e);return Promise.all([t,n]).then(t=>{const[i,s]=t;let n;if(!i){const t=this.getTable();if(!n){n=C.call(this,e,t.getItems(),s)}}if(!n){n=this._loadItemForValue(e,s)}return n})};function C(e,t,i){if(t.length===0){return}const s=function(e,t){const i=e.isA("sap.ui.model.Context")?e:this._getListItemBindingContext(e);return i&&i.getProperty(t)}.bind(this);let n;let o;const a=B.call(this,e,i);const h=l.apply(t,a,s);if(h.length===1||h.length>1&&this.getUseFirstMatch()){const e=this._getListItemBindingContext(h[0]);const t=this.getItemFromContext(e,{inParameters:n,outParameters:o});return{key:t.key,description:t.description,payload:t.payload}}else if(h.length>1){if(!e.caseSensitive){const s=c({},e);s.caseSensitive=true;return C.call(this,s,t,i)}throw F.call(this,e.exception,true,e.parsedValue||e.value)}}function B(e,t){const s=e.caseSensitive;const n=this.getKeyPath();const l=this.getDescriptionPath();const h=[];if(e.checkKey&&e.hasOwnProperty("parsedValue")){h.push(new o({path:n,operator:a.EQ,value1:e.parsedValue,caseSensitive:s}))}if(e.checkDescription){if(e.hasOwnProperty("parsedDescription")&&e.parsedDescription!==undefined){h.push(new o({path:l,operator:a.EQ,value1:e.parsedDescription,caseSensitive:s}))}else if(e.value){h.push(new o({path:l,operator:a.EQ,value1:e.value,caseSensitive:s}))}}let r=h.length>1?new o({filters:h,and:false}):h[0];if(r&&t){const e=this._getTypesForConditions(t);const s=i.createFilters(t,e,undefined,this.getCaseSensitive());if(s){r=new o({filters:[r,s],and:true})}}return r}function x(){return this.awaitListBinding().then(e=>{const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const s=this.getListBindingInfo();const n=s&&s.length;if(e&&t){return t.checkListBindingPending(i,e,n)}else{return true}})}S.prototype.getListBinding=function(){const e=this._getTable();return e&&e.getBinding("items")};S.prototype.getListBindingInfo=function(){const e=this._getTable();return e&&e.getBindingInfo("items")};S.prototype._loadItemForValue=function(e,t){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}const i=this.getKeyPath();const s=this.getDescriptionPath();const n=this.getUseFirstMatch();const o=this._getTable();const a=o&&o.getBinding("items");const l=a&&a.getPath();const h=this.getValueHelpDelegate();const r=this.getValueHelpInstance();const c=B.call(this,e,t);const d=a.getModel().bindList(l,a.getContext(),undefined,c);d.initialize();return h.executeFilter(r,d,2).then(t=>{const o=t.getContexts();setTimeout(()=>{d.destroy()},0);if(o.length&&(o.length<2||n)){return this.getItemFromContext(o[0],{keyPath:i,descriptionPath:s,inParameters:undefined})}else if(e.checkKey&&e.parsedValue===""&&o.length===0){return null}else{const t=F.call(this,e.exception,o.length>1,e.value);throw t}})};function F(e,t,i){let s;if(t){s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[i])}else{s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[i])}const n=new e(s);n._bNotUnique=t;return n}S.prototype.isValidationSupported=function(e){return true};S.prototype.navigate=function(e){const t=this.getParent().isOpen();if(!t&&this._iNavigateIndex<0&&!this._bNavigateInitialize){this._bNavigateInitialize=true;this.onBeforeShow(true).then(()=>{this.onShow(true).then(t=>{this.navigate(e)})});return}this._bNavigateInitialize=false;const i=this.getListBinding();if(!i||!i.getLength()){x.call(this).then(t=>{if(!t&&i.getLength()!==0){this.navigate(e)}});return}const s=this.isSingleSelect();const n=this._getTable();const o=n.getItems();const a=this._iNavigateIndex<0&&this._sHighlightId?o.findIndex(e=>e.getId()===this._sHighlightId):this._iNavigateIndex;const l=a>=0?o[a]:s&&n.getSelectedItem();const h=o.length;let r=0;let c=false;if(e===9999){r=h-1}else if(e===-9999){r=0}else if(l){r=o.indexOf(l);r=r+e}else if(e>=0){r=e-1}else{r=h+e}let d;let g=false;if(r<0){r=0;d=true;c=true}else if(r>=h-1){if(r>=h){g=true}r=h-1;d=false}else{d=e>=0}this.setHighlightId();if(!t){const e=function(){while(o[r]&&o[r].isA("sap.m.GroupHeaderListItem")){if(d){r++}else{r--}}};const t=()=>{const e=this.getConditions();while(o[r]&&this._isContextSelected(this._getListItemBindingContext(o[r]),e)){if(d){r++}else{r--}}};e();if(!s){t()}if(r<0||r>h-1){d=!d;c=r<0;r=r<0?0:h-1;e();if(!s){t()}}}else if(!s){if(o[r]){o[r].focus()}else{n.focus()}return}else if(g&&this._oShowAllItemsButton){if(l){l.setSelected(false);n.setFakeFocus();l.removeStyleClass("sapMLIBSelected")}this._iNavigateIndex=-1;this.setProperty("conditions",[],true);this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:false});this._oShowAllItemsButton.focus();return}const u=o[r];if(u){if(u!==l||this._iNavigateIndex!==r&&!c){let e;const i=[];const o=this.getValueHelpDelegate();const a=o.isFilteringCaseSensitive(this.getValueHelpInstance(),this);this._iNavigateIndex=r;if(t){this._handleScrolling(u);n.setFakeFocus(u);this.setVisualFocus();this.fireVisualFocusSet()}if(!u.isA("sap.m.GroupHeaderListItem")){const t=this._getListItemBindingContext(u);const s=this.getItemFromContext(t);e=s&&this.createCondition(s.key,s.description,s.payload);i.push(e)}if(s){this._bConditionSetByNavigate=true;this.setProperty("conditions",i,true);b.call(this);delete this._bConditionSetByNavigate}this.fireNavigated({condition:e,itemId:u.getId(),leaveFocus:false,caseSensitive:a})}else if(c){if(s){this._iNavigateIndex=-1}this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:c})}}};S.prototype.isNavigationEnabled=function(e){if(e===1||e===-1){if(e===1||e===-1&&(this.isSingleSelect()||!this.getParent().isOpen())){return true}else{return false}}else if(this.isSingleSelect()){const e=this.getListBinding();const t=this.getListBindingInfo();if((e?.isLengthFinal()||t.length)&&!e?.isSuspended()){return true}else{return false}}else{return false}};S.prototype._handleScrolling=function(e){const t=this.getScrollDelegate();if(t){const t=this._getTable();const i=!isNaN(e)?e:t.indexOfItem(e);t.scrollToIndex(i).catch(e=>{});return true}return false};S.prototype.getScrollDelegate=function(){if(this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return t.prototype.getScrollDelegate.apply(this,arguments)};S.prototype.removeVisualFocus=function(){const e=this.getTable();e?.removeStyleClass("sapMListFocus")};S.prototype.setVisualFocus=function(){const e=this.getTable();if(e&&this.isTypeahead()){if(this.isSingleSelect()){if(!e.hasStyleClass("sapMListFocus")){e.addStyleClass("sapMListFocus")}}else{e.focus()}}};S.prototype.getAriaAttributes=function(e){const t=this.getTable();const i=this.isTypeahead();const s=this.getUseAsValueHelp();let n=null;if(e!==1&&(i&&s||!i)){const e=P.apply(this);n=e.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION")}return{contentId:t&&t.getId(),ariaHasPopup:"listbox",roleDescription:n,valueHelpEnabled:!i,autocomplete:this.getUseFirstMatch()?"both":"none"}};S.prototype._handleFirstMatchSuggest=function(){const e=this.isTypeahead();const t=this._oTable?.getItems();const i=this.getFilterValue();const s=this.getUseFirstMatch();if(e&&s&&i&&!this._bNavigateInitialize){const e=this.getValueHelpDelegate();const s=e.isFilteringCaseSensitive(this.getValueHelpInstance(),this);let n;let o=0;if(t?.length){const i=this.getConditions();if(i.length===1&&this.isSingleSelect()){for(let e=0;e<t.length;e++){const s=this._getListItemBindingContext(t[e]);if(this._isContextSelected(s,i)){n=s;break}}}if(!n){n=e.getFirstMatch(this.getValueHelpInstance(),this,{value:this.getFilterValue(),checkDescription:!!this.getDescriptionPath(),control:this.getControl(),caseSensitive:this.getCaseSensitive()})}o=w.call(this)}if(n){const e=this.getItemFromContext(n);const a=this.createCondition(e.key,e.description,e.payload);const l=t.find(e=>this._getListItemBindingContext(e)===n);this.fireTypeaheadSuggested({condition:a,filterValue:i,itemId:l?.getId(),items:o,caseSensitive:s})}else{this.fireTypeaheadSuggested({condition:null,filterValue:i,itemId:null,items:o,caseSensitive:s})}}};function P(){if(!this._oResourceBundleM){this._oResourceBundleM=e.getResourceBundleFor("sap.m")}return this._oResourceBundleM}S.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{getContentHeight:function(){const e=this._getTable();const t=e&&e.getDomRef();return t&&Math.round(t.getBoundingClientRect().height)}.bind(this),getFooter:function(){return this._retrievePromise("footer",()=>this.awaitListBinding().then(e=>{const t=this.getListBindingInfo();const i=this.getParent().hasDialog();if(i&&t&&t.length&&!p.system.phone){return s(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(e=>{if(this.isDestroyStarted()){return null}const[t,i,s]=e;const n={onsapup(e){const t=this._getTable();if(t.getMode()===m.MultiSelect){const i=t.getItems();if(i.length>0){e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();this._bFocusTable=true;i[i.length-1].focus()}}else{e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();this.navigate(9999)}},onsapfocusleave(e){const t=e.relatedControlId&&u.getElementById(e.relatedControlId);const i=this.getParent();if(i&&t&&f(i.getDomRef(),t.getFocusDomRef())){e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();const t=this._getTable();if(t.getMode()===m.MultiSelect){if(!this._bFocusTable){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true})}delete this._bFocusTable}else{this.navigate(-9999)}}}};this._oShowAllItemsButton=new t(this.getId()+"-showAllItems",{text:this._oMResourceBundle.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){this.fireRequestSwitchToDialog()}.bind(this)});this._oShowAllItemsButton.addDelegate(n,true,this);const o=[new s(this.getId()+"-Spacer")].concat(this._oShowAllItemsButton);const a=new i(this.getId()+"-TB",{content:o});return a})}}))}.bind(this)}}};function L(){if(this._oTable&&this.getParent()){const e=this._oTable.getSticky();if(!e||e.length===0){this._oTable.setSticky([I.ColumnHeaders])}}}S.prototype.setParent=function(e){t.prototype.setParent.apply(this,arguments);L.call(this)};S.prototype.observeChanges=function(e){if(e.name==="config"){L.call(this)}if(e.name==="items"&&e.mutation==="ready"){this.resolveListBinding()}if(e.name==="table"){this._sHighlightId=undefined;const t=e.child;if(e.mutation==="remove"){this._oObserver.unobserve(t);D.call(this,t);this._oTable=null;this._removePromise("footer");this.resetListBinding()}else{this._oTable=t;this._oTable.addStyleClass("sapMdcValueHelpMTable");L.call(this);if(!this.resolveListBinding()){this._oObserver.observe(e.child,{bindings:["items"]})}}}t.prototype.observeChanges.apply(this,arguments)};S.prototype._handleTableEvent=function(e){if(!this.isTypeahead()){return}const t=this._getTable();const i=u.closestTo(e.target);switch(e.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(t.indexOfItem(i)===0){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true)}}break;case"sapnext":if(i.isA("sap.m.ListItemBase")&&this._oShowAllItemsButton){const s=t.getItems();if(s.indexOf(i)===s.length-1){e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true);this._oShowAllItemsButton.focus()}}break;default:break}};S.prototype.isQuickSelectSupported=function(){return true};S.prototype.isSingleSelect=function(){const e=this._getTable();if(e&&e.getMode()!==m.None){if(e.getMode()===m.MultiSelect){return false}else{return true}}else{return t.prototype.isSingleSelect.apply(this,arguments)}};S.prototype.onConnectionChange=function(){this._sHighlightId=undefined;this._iNavigateIndex=-1};S.prototype.exit=function(){T.call(this);h.cleanup(this,["_sTableWidth","_oTable","_oScrollContainer","_oContentLayout","_oTablePanel","_oFilterBarVBox","_oMResourceBundle","_oResourceBundle","_oTableDelegate","_sHighlightId","_bAnnounceTableUpdate"]);t.prototype.exit.apply(this,arguments)};S.prototype.setHighlightId=function(e){if(this._sHighlightId!==e){this._sHighlightId=e;b.call(this)}};S.prototype.clone=function(e,i){const s=this._getTable();const n=s?._bAttached;if(n){D.call(this,s)}const o=t.prototype.clone.apply(this,arguments);if(n){M.call(this,s)}return o};function M(e){if(!e._bAttached){e.attachItemPress(this._handleItemPress,this);e.attachSelectionChange(this._handleSelectionChange,this);e.attachUpdateFinished(this._handleUpdateFinished,this);this._oTableDelegate=this._oTableDelegate||{onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};e.addDelegate(this._oTableDelegate,true,this);e._bAttached=true}}function D(e){if(e._bAttached){e.removeDelegate(this._oTableDelegate);this._oTable.detachItemPress(this._handleItemPress,this);this._oTable.detachSelectionChange(this._handleSelectionChange,this);this._oTable.detachUpdateFinished(this._handleUpdateFinished,this);e._bAttached=false}}function w(){const e=this.getListBinding();const t=this.getListBindingInfo();let i=e?.getCount();if(i===undefined&&(e?.isLengthFinal()||t.length)){const e=this.getListBinding().getCurrentContexts();i=e?.length}return i}return S});
sap.ui.require.preload({
	"sap/ui/mdc/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.mdc","type":"library","embeds":[],"applicationVersion":{"version":"1.136.0"},"title":"UI5 library: sap.ui.mdc","description":"UI5 library: sap.ui.mdc","ach":"CA-UI5-MDC","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.136","libs":{"sap.ui.core":{"minVersion":"1.136.0"},"sap.m":{"minVersion":"1.136.0"},"sap.ui.layout":{"minVersion":"1.136.0","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.valuehelp.base.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],"elements":["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.DragDropConfig","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.SelectionButton","sap.ui.mdc.chart.SelectionButtonItem","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.Link","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.ushell.SemanticObjectUnavailableAction","sap.ui.mdc.ushell.SemanticObjectMapping","sap.ui.mdc.ushell.SemanticObjectMappingItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.FixedListItem","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],"types":["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowAction","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],"interfaces":["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent","sap.ui.mdc.valuehelp.base.ITypeaheadContainer","sap.ui.mdc.valuehelp.base.IDialogContainer"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
