/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/base/Object","sap/base/util/isEmptyObject","sap/ui/core/Locale"],(t,e,n,i)=>{"use strict";const o=e.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset()}});o.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this};o.prototype.isEmpty=function(){return!(!n(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length)};o.prototype.initialize=function(t){this.reset();t.forEach(t=>{this.createSemanticObjectStructure(t)})};o.prototype.addContextObject=function(t,e){for(const n in e){const i=this.createAttributeStructure();this.addSemanticObjectAttribute(t,n,i);i.transformations.push({value:e[n],description:"ℹ The attribute "+n+" with the value "+e[n]+" is initially taken from the binding context."})}};o.prototype.createSemanticObjectStructure=function(t){this._oLog.semanticObjects[t]={attributes:{},intents:[]}};o.prototype.createAttributeStructure=function(){return{transformations:[]}};o.prototype.addSemanticObjectIntent=function(t,e){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].intents.push(e);return this};o.prototype.addSemanticObjectAttribute=function(t,e,n){if(!this._oLog.semanticObjects[t]){this.createSemanticObjectStructure(t)}this._oLog.semanticObjects[t].attributes[e]=n;return this};o.prototype.getSemanticObjectAttribute=function(t,e){return this._oLog.semanticObjects[t]&&this._oLog.semanticObjects[t].attributes[e]?this._oLog.semanticObjects[t].attributes[e]:undefined};o.prototype.addIntent=function(t,e){switch(t){case o.IntentType.API:this._oLog.intents.api.push(e);break;case o.IntentType.BREAKOUT:this._oLog.intents.breakout.push(e);break;default:throw"Intent type "+t+" is not supported yet."}return this};o.prototype.getFormattedText=function(){const e=function(t){return typeof t==="string"?"'"+t+"'":t};const o=function(t,n){const i={value:"• "+n+" : ",description:""};t.forEach((t,n)=>{i.value=i.value+(n>0?"  ➜  ":"")+e(t["value"]);i.description=i.description+"…   "+t["description"]+"\n";if(t["reason"]){i.description=i.description+"…   "+t["reason"]+"\n"}});return i};const s=function(t){let e="";t.forEach(t=>{e+="• '"+t.text+"' : "+t.intent+"\n"});return e};const a=function(e){try{const n=new i(t.getLanguageTag()).toString();if(typeof window.Intl!=="undefined"){const t=window.Intl.Collator(n,{numeric:true});e.sort((e,n)=>t.compare(e,n))}else{e.sort((t,e)=>t.localeCompare(e,n,{numeric:true}))}}catch(t){}};let r="";for(const t in this._oLog.semanticObjects){r=r+"\n⬤"+" "+t+"\n";if(n(this._oLog.semanticObjects[t].attributes)){r+="……  🔴 No semantic attributes available for semantic object "+t+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n"}else{const e=Object.keys(this._oLog.semanticObjects[t].attributes);a(e);for(const n of e){const e=o(this._oLog.semanticObjects[t].attributes[n].transformations,n);r+=e.value+"\n";r+=e.description}}if(this._oLog.semanticObjects[t].intents.length){r+="\nIntents returned by FLP for semantic object "+t+":\n";r+=s(this._oLog.semanticObjects[t].intents)}}if(this._oLog.intents.api.length){r+="\nIntents defined in items aggregation:\n";r+=s(this._oLog.intents.api)}if(this._oLog.intents.breakout.length){r+="\nIntents returned by modifyItemsCallback callback:\n";r+=s(this._oLog.intents.breakout)}return r};o.prototype._getLogFormattedText=function(){return!this.isEmpty()?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available"};o.IntentType={BREAKOUT:"Breakout",API:"Api"};return o});
//# sourceMappingURL=Log.js.map