/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./PanelRenderer","sap/ui/core/Lib","sap/ui/layout/VerticalLayout","sap/base/Log","sap/ui/layout/HorizontalLayout","sap/m/HBox","sap/m/VBox","sap/m/ImageContent","sap/m/Link","sap/m/Label","sap/m/Text","sap/m/Button","sap/m/FlexItemData","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem","sap/ui/core/CustomData","./Factory","sap/ui/core/library"],(t,e,n,i,o,r,a,s,l,c,p,u,g,m,d,h,f,y,P,I,b,k,_,v)=>{"use strict";const{HasPopup:C}=v.aria;const A=t.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true},_content:{type:"sap.ui.layout.VerticalLayout",visibility:"hidden",multiple:false}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}},renderer:e});A.prototype.init=function(){t.prototype.init.call(this);this._registerP13n();const e=new d({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,runtimeItems:[]});e.setDefaultBindingMode(h.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdclinkPanel");this._oObserver=new f(z.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]})};const L=n.getResourceBundleFor("sap.ui.mdc");A.prototype.applySettings=function(){this._createContent();t.prototype.applySettings.apply(this,arguments)};A.prototype.exit=function(t){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}if(this._oMetadataHelper){this._oMetadataHelper=null}};const w=0,M=1,S=2,x=3;A.prototype._registerP13n=function(){P.getInstance().register(this,{controller:{LinkItems:new y({control:this})}});I.call(A.prototype);P.getInstance().defaultProviderRegistry.attach(this,"Global")};A.prototype._createContent=function(){const t=[];t[w]=this._createAdditionalContentArea();t[M]=this._createSeparator();t[S]=this._createLinkArea();t[x]=this._createFooterArea();const e=new i({width:"100%",content:t});this.setAggregation("_content",e)};A.prototype._createAdditionalContentArea=function(){const t=new s({fitContainer:false,items:this.getAdditionalContent()});return t};A.prototype._createSeparator=function(){const t=new s({fitContainer:false,visible:{parts:[{path:"$sapuimdclinkPanel>/countAdditionalContent"},{path:"$sapuimdcLink>/metadata"}],formatter:function(t,e){return t>0&&e.length>0}}});t.addStyleClass("mdcbaseinfoPanelSeparator");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");t.setModel(this.getModel("$sapuimdcLink"),"$sapuimdcLink");return t};A.prototype._createLinkArea=function(){const t=new s({fitContainer:false,items:{path:"$sapuimdclinkPanel>/runtimeItems",templateShareable:false,factory:this._fnLinkItemFactory.bind(this)}});t.addStyleClass("mdcbaseinfoPanelSectionLinks");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");return t};A.prototype._fnLinkItemFactory=function(t,e){const n=new l({src:"{$sapuimdclinkPanel>icon}",visible:{path:"$sapuimdclinkPanel>icon",formatter:function(t){return!!t}}});const i=new c({text:"{$sapuimdclinkPanel>text}",href:"{$sapuimdclinkPanel>href}",target:"{$sapuimdclinkPanel>target}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!!t}},press:this.onPressLink.bind(this),wrapping:true,customData:new k({key:"internalHref",value:"{$sapuimdclinkPanel>internalHref}"})});const o=new p({text:"{$sapuimdclinkPanel>text}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!t}},wrapping:true});const g=new u({text:"{$sapuimdclinkPanel>description}",visible:{path:"$sapuimdclinkPanel>description",formatter:function(t){return!!t}},wrapping:true});const d=new s({items:[i,o,g]});const h=new a({layoutData:new m({styleClass:e.getProperty("description")?"mdcbaseinfoPanelItemsGroup":"mdcbaseinfoPanelItemsWithoutGroup"}),items:[n,d]});const f=new r({visible:"{$sapuimdclinkPanel>visible}",content:[h]});f.addStyleClass("mdcbaseinfoPanelListItem");return f};A.prototype._createFooterArea=function(){const t=new g(this.getId()+"--idSectionPersonalizationButton",{type:"Transparent",text:L.getText("info.POPOVER_DEFINE_LINKS"),press:this.onPressLinkPersonalization.bind(this)});t.setAriaHasPopup(C.Dialog);const e=new a({visible:{path:"$sapuimdcLink>/metadata",formatter:function(t){return t.length>0}},justifyContent:"End",items:[t]});e.addStyleClass("mdcbaseinfoPanelPersonalizationButton");return e};A.prototype.onPressLink=function(t){const e=t.getSource();const n=t.getParameters().ctrlKey||t.getParameters().metaKey;const i=e?.getTarget()==="_blank"||n;if(i){return}t.preventDefault();const r=this.getBeforeNavigationCallback();if(!r){o.error("sap.ui.mdc.link.Panel: beforeNavigationCallback not set");return}const a=e?.getCustomData()?.[0]?.getValue();const s=a?.length?a:e.getHref();r(t).then(t=>{if(t){A.navigate(s)}})};A.oNavigationPromise=undefined;A.navigate=function(t){const e=_.getUShellContainer();if(t.indexOf("#")===0&&e){if(!A.oNavigationPromise){A.oNavigationPromise=_.getServiceAsync("Navigation").then(e=>{e.navigate({target:{shellHash:t.substring(1)}});A.oNavigationPromise=undefined})}}else{window.location.href=t}};A.prototype.onPressLinkPersonalization=function(){this._openPersonalizationDialog()};A.prototype._openPersonalizationDialog=function(){return new Promise(t=>{const e=this.getParent();this.fireBeforeSelectionDialogOpen();if(e.isA("sap.m.Popover")){e.setModal(true)}P.getInstance().show(this,"LinkItems",{contentWidth:"28rem",contentHeight:"35rem",close:()=>this.fireAfterSelectionDialogClose()}).then(e=>{e.attachClose(()=>this.fireAfterSelectionDialogClose());t(e)})})};A._getVisibleItems=function(t){return t.filter(t=>t.id!==undefined&&t.visible)};A.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel")};A.prototype._propagateDefaultIcon=function(t){if(!t){return}const e=this._getInternalModel();e.getProperty("/runtimeItems").forEach((t,n)=>{if(t.icon){return}e.setProperty("/runtimeItems/"+n+"/icon","sap-icon://chain-link")})};let $,W,D,H,O;function z(t){const e=this._getInternalModel();if(t.object.isA("sap.ui.mdc.link.Panel")){switch(t.name){case"additionalContent":$=t.child?[t.child]:t.children;$.forEach(e=>{switch(t.mutation){case"insert":this._getAdditionalContentArea().addItem(e);break;case"remove":break;default:o.error("Mutation '"+t.mutation+"' is not supported yet.")}});e.setProperty("/countAdditionalContent",$.length);break;case"items":W=t.child?[t.child]:t.children;W.forEach(function(n){const i=e.getProperty("/runtimeItems/");switch(t.mutation){case"insert":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")+1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")+1);i.splice(this.indexOfItem(n),0,n.getJson());e.setProperty("/runtimeItems",i);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(n,{properties:["visible"]});break;case"remove":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")-1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")-1);D=i.find(t=>t.id===n.getId());i.splice(i.indexOf(D),1);e.setProperty("/runtimeItems",i);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(n);n.destroy();this.invalidate();break;default:o.error("Mutation '"+t.mutation+"' is not supported yet.")}},this);break;case"enablePersonalization":this._getPersonalizationButton().setVisible(t.current);break;default:o.error("The property or aggregation '"+t.name+"' has not been registered.")}}else if(t.object.isA("sap.ui.mdc.link.PanelItem")){switch(t.name){case"visible":H=t.object;O=this.indexOfItem(H);if(H.getVisibleChangedByUser()){e.setProperty("/runtimeItems/"+O+"/visible",H.getVisible())}else{e.setProperty("/baselineItems/"+O+"/visible",H.getVisible());e.setProperty("/runtimeItems/"+O+"/visible",H.getVisible())}break;default:o.error("The '"+t.name+"' of PanelItem is not supported yet.")}}}A.prototype.getCurrentState=function(){const t=[];let e;this.getItems().forEach((n,i)=>{e=n&&n.getId();if(n.getVisible()){t.push({key:e,name:e})}});return{items:t}};A.prototype.initPropertyHelper=async function(){await new Promise(t=>{sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],e=>{if(!this._oMetadataHelper){this._oMetadataHelper=e}t()})});const t=this._oMetadataHelper.retrieveAllMetadata(this);return{getProperties:function(){const e=[];t.forEach(t=>{e.push({name:t.id,getName:function(){return t.id},getLabel:function(){return t.text},text:t.text,href:t.href,internalHref:t.internalHref,description:t.description,target:t.target,visible:t.visible})});return e}}};A.prototype._getAdditionalContentArea=function(){return this.getAggregation("_content").getContent()[w]};A.prototype._getSeparator=function(){return this.getAggregation("_content").getContent()[M]};A.prototype._getLinkArea=function(){return this.getAggregation("_content").getContent()[S]};A.prototype._getLinkControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[0])};A.prototype._getLabelControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[1])};A.prototype._getDescriptionTextControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[2])};A.prototype._getFooterArea=function(){return this.getAggregation("_content").getContent()[x]};A.prototype._getPersonalizationButton=function(){return this._getFooterArea().getItems()[0]};return A});
//# sourceMappingURL=Panel.js.map