/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/odata/v4/ChartDelegate","sap/m/Text","sap/base/Log","sap/ui/mdc/odata/v4/util/DelegateUtil","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/ui/mdc/chart/ChartImplementationContainer","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/p13n/MessageStrip","sap/ui/mdc/FilterBarDelegate","sap/ui/mdc/chart/PropertyHelper","sap/ui/thirdparty/jquery","sap/ui/mdc/enums/ChartItemRoleType","sap/base/util/merge"],(t,e,r,a,n,i,o,s,l,u,c,g,h,d,jQuery,p,m)=>{"use strict";const y=Object.assign({},r);const f=new window.WeakMap;let _;let C;let b;let I;let S;y._getState=function(t){if(f.has(t)){return f.get(t)}if(t){n.info("Couldn't get state for "+t.getId())}};y._setState=function(t,e){f.set(t,e)};y._deleteState=function(t){if(this._getState(t)){if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}if(this._getState(t).observer){this._getState(t).observer.disconnect();this._getState(t).observer=null}}return f.delete(t)};y._getChart=function(t){if(f.has(t)){return f.get(t).innerChart}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setChart=function(t,e){if(f.has(t)){f.get(t).innerChart=e}else{f.set(t,{innerChart:e})}};y._getInnerStructure=function(t){if(f.has(t)){return f.get(t).innerStructure}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setInnerStructure=function(t,e){if(f.has(t)){f.get(t).innerStructure=e}else{f.set(t,{innerStructure:e})}};y.getFilterDelegate=function(){return h};y.addCondition=function(t,e,r){return Promise.resolve()};y.removeCondition=function(t,e,r){return Promise.resolve()};y._getBindingInfoFromState=function(t){if(f.has(t)){const e=f.get(t).bindingInfo;if(e){delete e.events}return e}if(t){n.info("Couldn't get state for "+t.getId())}return undefined};y._setBindingInfoForState=function(t,e){if(f.has(t)){f.get(t).bindingInfo=e}else{f.set(t,{bindingInfo:e})}};y._setUpChartObserver=function(t){const e=this._getState(t);if(!e.observer){e.observer=new u(t=>{if(t.type==="destroy"){this.exit(t.object)}})}e.observer.observe(t,{destroy:true})};y.exit=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).destroy()}this._deleteState(t)};y.zoomIn=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"in"})}};y.zoomOut=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"out"})}};y.getZoomState=function(t){if(this._getChart(t)){const e=this._getChart(t).getZoomInfo();if(e&&e.hasOwnProperty("currentZoomLevel")&&e.currentZoomLevel!=null&&e.enabled){return{enabled:e.enabled,enabledZoomIn:e.currentZoomLevel<1,enabledZoomOut:e.currentZoomLevel>0}}}return{enabled:false}};y.getInnerChartSelectionHandler=function(t){return{eventId:"_selectionDetails",listener:this._getChart(t)}};y.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout}const t=[p.axis1,p.category,p.series];const e=[p.axis1,p.axis2,p.category,p.series];const r=[p.axis1,p.category,p.category2];const a=[p.axis1,p.axis2,p.axis3,p.category,p.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:t},{key:"bar",allowedLayoutOptions:t},{key:"line",allowedLayoutOptions:t},{key:"combination",allowedLayoutOptions:t},{key:"pie",allowedLayoutOptions:t},{key:"donut",allowedLayoutOptions:t},{key:"dual_column",allowedLayoutOptions:e},{key:"dual_bar",allowedLayoutOptions:e},{key:"dual_line",allowedLayoutOptions:e},{key:"stacked_bar",allowedLayoutOptions:t},{key:"scatter",allowedLayoutOptions:e},{key:"bubble",allowedLayoutOptions:a},{key:"heatmap",allowedLayoutOptions:r},{key:"bullet",allowedLayoutOptions:t},{key:"vertical_bullet",allowedLayoutOptions:t},{key:"dual_stacked_bar",allowedLayoutOptions:e},{key:"100_stacked_bar",allowedLayoutOptions:t},{key:"stacked_column",allowedLayoutOptions:t},{key:"dual_stacked_column",allowedLayoutOptions:e},{key:"100_stacked_column",allowedLayoutOptions:t},{key:"dual_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_stacked_combination",allowedLayoutOptions:e},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:e},{key:"stacked_combination",allowedLayoutOptions:t},{key:"100_dual_stacked_bar",allowedLayoutOptions:t},{key:"100_dual_stacked_column",allowedLayoutOptions:t},{key:"horizontal_stacked_combination",allowedLayoutOptions:t},{key:"waterfall",allowedLayoutOptions:r},{key:"horizontal_waterfall",allowedLayoutOptions:r}];return this._aChartTypeLayout};y.getAdaptionUI=function(t){return Promise.resolve(this._setupAdaptionUI(t))};y._setupAdaptionUI=function(t){let r=this.getChartTypeLayoutConfig().find(e=>e.key===t.getChartType());if(!r){const e=[p.axis1,p.axis2,p.axis3,p.category,p.category2,p.series];r={key:t.getChartType(),allowedLayoutOptions:e}}const a=[{kind:"Groupable"},{kind:"Aggregatable"}];r.templateConfig=a;const n={panelConfig:r};const i=new c(n);if(t.getChartType()==="heatmap"){const t=e.getResourceBundleFor("sap.ui.mdc");i.setMessageStrip(new g({text:t.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}))}return i};y.setLegendVisible=function(t,e){if(this._getChart(t)){this._getChart(t).setVizProperties({legend:{visible:e},sizeLegend:{visible:e}})}else{n.error("Could not set legend visibility since inner chart is not yet initialized!")}};y._getSorterForItem=function(t,e){if(t.getType()==="aggregatable"){return new s(this._getAggregatedMeasureNameForMDCItem(t),e.descending)}else if(t.getType()==="groupable"){return new s(this.getInternalChartNameFromPropertyNameAndKind(e.key,"groupable",t.getParent()),e.descending)}};y.insertItemToInnerChart=function(t,e,r){if(e.getType()==="groupable"){const a=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const n=this._getChart(t).getDimensionByName(a);if(!n){this.createInnerDimension(t,e)}else{n.setLabel(e.getLabel());n.setRole(e.getRole()?e.getRole():"category")}const i=t._bDrillDown;if(i&&n){this._getChart(t).drillDown(n);t._bDrillDown=false}else if(!i){const e=this._getChart(t).getVisibleDimensions();e.splice(r,0,a);this._getChart(t).setVisibleDimensions(e)}}else if(e.getType()==="aggregatable"){this.createInnerMeasure(t,e);const a=this._getChart(t).getVisibleMeasures();a.splice(r,0,this._getAggregatedMeasureNameForMDCItem(e));this._getChart(t).setVisibleMeasures(a)}this._prepareColoringForItem(t,e).then(()=>{this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures())});this._updateSemanticalPattern(t)};y.removeItemFromInnerChart=function(t,e){if(e.getType()==="groupable"&&this._getChart(t).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t))){if(this._getState(t).inResultDimensions.length>0){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}if(t._iDrillUpIndex){this._getChart(t).drillUp(t._iDrillUpIndex);t._iDrillUpIndex=0}else{let e=t.getItems().filter(t=>t.getType()==="groupable");e=e.map(function(e){return this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t)}.bind(this));this._getChart(t).setVisibleDimensions(e)}}else if(e.getType()==="aggregatable"&&this._getChart(t).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(e))){const r=[];t.getItems().filter(t=>t.getType()==="aggregatable").filter(t=>t!==e).forEach(t=>{r.push(this._getAggregatedMeasureNameForMDCItem(t))});this._getChart(t).setVisibleMeasures(r);this._getChart(t).removeMeasure(this._getChart(t).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(e)))}this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures());this._updateSemanticalPattern(t)};y.addItem=function(t,e,r,a){if(t.getModel){return Promise.resolve(this._createMDCChartItem(e,t,a))}};y.removeItem=function(t,e){return Promise.resolve(true)};y._createMDCChartItem=function(t,e,r){return this._getPropertyInfosByName(t,e).then(t=>{if(!t){return null}return this._createMDCItemFromProperty(t,e.getId(),r)})};y._createMDCItemFromProperty=function(t,e,r){if(t.groupable){return new o(e+"--GroupableItem--"+t.key,{propertyKey:t.key,label:t.label,type:"groupable",role:r?r:"category"})}if(t.aggregatable){return new o(e+"--AggregatableItem--"+t.key,{propertyKey:t.key,label:t.label,type:"aggregatable",role:r?r:"axis1"})}return null};y.initializeInnerChart=function(t){return new Promise((e,r)=>{this._loadChart().then(r=>{if(!t.isDestroyed()){let r;this._setInnerStructure(t,new l(t.getId()+"--implementationContainer",{}));t.addStyleClass("sapUiMDCChartTempTextOuter");if(t.getNoData()){this._getInnerStructure(t).setChartNoDataContent(t.getNoData())}else{r=new a({text:t.getNoDataText()});this._getInnerStructure(t).addStyleClass("sapUiMDCChartTempText");this._getInnerStructure(t).setNoDataContent(r)}this._setUpChartObserver(t);e(this._getInnerStructure(t))}})})};y.changedNoDataStruct=function(t,e){const r=this._getInnerStructure(t);if(r){r.setChartNoDataContent(e);r.invalidate()}};y._createContentFromItems=function(t){return new Promise((e,r)=>{const a=[];const i=[];const o=[];const s=[];t.getItems().forEach((e,r)=>{i.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{if(!r){n.error("sap.ui.mdc.Chart: Item "+e.getPropertyKey()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return}switch(e.getType()){case"groupable":o.push(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t));this._addInnerDimension(t,e,r);break;case"aggregatable":s.push(this._getAggregatedMeasureNameForMDCItem(e));this._addInnerMeasure(t,e,r);break;default:n.error("MDC Chart Item "+e.getId()+" with label "+e.getLabel()+' has no known type. Supported typed are: "groupable" & "aggregatable"')}a.push(this._prepareColoringForItem(t,e))}))});Promise.all(i).then(()=>{this._getState(t).aColMeasures.forEach(e=>{if(this._getState(t).aInSettings.indexOf(e)==-1){a.push(new Promise((r,a)=>{t._getPropertyByNameAsync(e).then(function(a){const n=this.getPropertyAttribute(t,a,"aggregationMethod");const i=this.getPropertyAttribute(t,a,"path");const o=this.getInternalChartNameFromPropertyNameAndKind(e,"aggregatable",t);const l={name:o,label:a.label,role:a.role||"axis1"};if(n&&i){l.analyticalInfo={propertyPath:i,with:n}}const u=this.getPropertyAttribute(t,a,"unitPath");if(u){l.unitBinding=u}const c=new I(l);s.push(c);this._getChart(t).addMeasure(c);r()})}))}});Promise.all(a).then(()=>{this._getChart(t).setVisibleDimensions(o);this._getChart(t).setVisibleMeasures(s);const r=t.getDelegate().inResultDimensions;if(r&&r instanceof Array&&r.length!=0){const e=[];r.forEach(r=>{e.push(this._getPropertyInfosByName(r,t).then(e=>{const r=y.innerDimensionFactory(t,undefined,e);this._getChart(t).addDimension(r);const a=this.getInternalChartNameFromPropertyNameAndKind(e.key,"groupable",t);this._getState(t).inResultDimensions.push(a)}))});Promise.all(e).then(()=>{this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)})}this._updateColoring(t,o,s);this._updateSemanticalPattern(t);e()})})})};y.getInnerChart=function(t){return this._getChart(t)};y._prepareColoringForItem=function(t,e){return this._addCriticality(t,e).then(()=>{this._getState(e.getParent()).aInSettings.push(e.getPropertyKey());if(e.getType()==="aggregatable"){this._getPropertyInfosByName(e.getPropertyKey(),e.getParent()).then(r=>{this._getAdditionalColoringMeasuresForItem(t,r).forEach(t=>{const r=this._getState(e.getParent());if(r.aColMeasures?.indexOf(t)==-1){r.aColMeasures.push(t)}})})}})};y._getAdditionalColoringMeasuresForItem=function(t,e){let r=[];const a=this.getPropertyAttribute(t,e,"datapoint");const n=a?.criticality||null;if(n?.DynamicThresholds){r=n.DynamicThresholds.usedMeasures}return r};y._addCriticality=function(t,e){return this._getPropertyInfosByName(e.getPropertyKey(),e.getParent()).then(r=>{const a=this.getPropertyAttribute(t,r,"datapoint");const n=this.getPropertyAttribute(t,r,"criticality");if(n||a?.criticality){const a=this._getState(e.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};const i={};if(e.getType()=="groupable"){const t=n||[];for(const e in t){i[e]={Values:t[e]}}const r=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",e.getParent());a.Criticality.DimensionValues[r]=i}else{const n=this.getPropertyAttribute(t,r,"datapoint");const o=n?.criticality||[];for(const t in o){i[t]=o[t]}const s=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"aggregatable",e.getParent());a.Criticality.MeasureValues[s]=i}const o=this._getState(e.getParent());o.oColorings=a;this._setState(e.getParent(),o)}})};y._updateColoring=function(t,e,r){const a=this._getChart(t);const n=this._getState(t);const i=jQuery.extend(true,{},n.oColorings);if(i&&i.Criticality){let t;for(let r=0;r<e.length;r++){const a=e[r];if(n.oColorings.Criticality.DimensionValues[a]){t={coloring:"Criticality",parameters:{dimension:a}};delete i.Criticality.MeasureValues;break}}if(!t){delete i.Criticality.DimensionValues;for(const t in i.Criticality.MeasureValues){if(r.indexOf(t)==-1){delete i.Criticality.MeasureValues[t]}}t={coloring:"Criticality",parameters:{measure:r}}}if(t){a.setColorings(i);a.setActiveColoring(t)}}};y._updateSemanticalPattern=function(t){const e=this._getChart(t).getVisibleMeasures();e.forEach(e=>{const r=this.getPropertyFromNameAndKind(e,"aggregatable",t);if(!r){return}const a=this.getPropertyAttribute(t,r,"datapoint");if(a){if(a.targetValue||a.foreCastValue){const r=this._getChart(t).getMeasureByName(e);r.setSemantics("actual");if(a.targetValue!=null){const e=this._getChart(t).getMeasureByName(a.targetValue);if(e){e.setSemantics("reference")}else{n.error("sap.ui.mdc.Chart: "+a.targetValue+" is not a valid measure")}}if(a.foreCastValue){const e=this._getChart(t).getMeasureByName(a.foreCastValue);if(e){e.setSemantics("projected")}else{n.error("sap.ui.comp.SmartChart: "+a.ForecastValue.Path+" is not a valid measure")}}r.setSemanticallyRelatedMeasures({referenceValueMeasure:a.targetValue,projectedValueMeasure:a.foreCastValue})}}})};y.mMatchingIcon={bar:"sap-icon://horizontal-bar-chart",bullet:"sap-icon://horizontal-bullet-chart",bubble:"sap-icon://bubble-chart",column:"sap-icon://vertical-bar-chart",combination:"sap-icon://business-objects-experience",dual_bar:"sap-icon://horizontal-bar-chart",dual_column:"sap-icon://vertical-bar-chart",dual_combination:"sap-icon://business-objects-experience",dual_horizontal_combination:"sap-icon://business-objects-experience",dual_horizontal_stacked_combination:"sap-icon://business-objects-experience",dual_line:"sap-icon://line-chart",dual_stacked_bar:"sap-icon://full-stacked-chart",dual_stacked_column:"sap-icon://vertical-stacked-chart",dual_stacked_combination:"sap-icon://business-objects-experience",donut:"sap-icon://donut-chart",heatmap:"sap-icon://heatmap-chart",horizontal_stacked_combination:"sap-icon://business-objects-experience",line:"sap-icon://line-chart",pie:"sap-icon://pie-chart",scatter:"sap-icon://scatter-chart",stacked_bar:"sap-icon://full-stacked-chart",stacked_column:"sap-icon://vertical-stacked-chart",stacked_combination:"sap-icon://business-objects-experience",treemap:"sap-icon://Chart-Tree-Map",vertical_bullet:"sap-icon://vertical-bullet-chart","100_dual_stacked_bar":"sap-icon://full-stacked-chart","100_dual_stacked_column":"sap-icon://vertical-stacked-chart","100_stacked_bar":"sap-icon://full-stacked-chart","100_stacked_column":"sap-icon://full-stacked-column-chart",waterfall:"sap-icon://vertical-waterfall-chart",horizontal_waterfall:"sap-icon://horizontal-waterfall-chart"};y.getChartTypeInfo=function(t){const r=t.getChartType(),a=e.getResourceBundleFor("sap.ui.mdc"),n=e.getResourceBundleFor("sap.chart");const i={icon:y.mMatchingIcon[r],text:a.getText("chart.CHART_TYPE_TOOLTIP",[n.getText("info/"+r)])};return i};y.getAvailableChartTypes=function(t){const r=[];if(this._getChart(t)){const a=this._getChart(t).getAvailableChartTypes().available;const n=e.getResourceBundleFor("sap.chart");for(let t=0;t<a.length;t++){const e=a[t].chart;r.push({key:e,icon:y.mMatchingIcon[e],text:n.getText("info/"+e)})}}return r};y.getDrillStack=function(t){const e=Object.assign([],this._getChart(t).getDrillStack());e.forEach(e=>{e.dimension=e.dimension.map(e=>{const r=this.getPropertyFromNameAndKind(e,"groupable",t);if(r){return r.key}else{n.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+e);return e}})});return e};y.getSortedDimensions=function(t){return new Promise((e,r)=>{if(t.isPropertyHelperFinal()){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}else{t.finalizePropertyHelper().then(()=>{e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))})}})};y._sortPropertyDimensions=function(t){const e=t.filter(t=>t.groupable);if(e){e.sort((t,e)=>{if(t.label&&e.label){return t.label.localeCompare(e.label)}})}return e};y.getDrillableItems=function(t){const e=t.getItems().filter(t=>t.getType()==="groupable");return e};y.setChartType=function(t,e){this._getChart(t).setChartType(e)};y.createInnerChartContent=function(t,e){return new Promise((r,a)=>{this._setChart(t,new _({id:t.getId()+"--innerChart",chartType:"column",height:"100%",width:"100%",isAnalytical:true,vizProperties:{plotArea:{scrollbar:{forceToShowInMobile:true}}}}));this._getChart(t).setCustomMessages({NO_DATA:t.getNoDataText()});this._getState(t).inResultDimensions=[];this._getInnerStructure(t).removeStyleClass("sapUiMDCChartTempText");t.removeStyleClass("sapUiMDCChartTempTextOuter");t.addStyleClass("sapUiMDCChartGrid");const i=this._getState(t);i.aColMeasures=[];i.aInSettings=[];this._setState(t,i);this._createContentFromItems(t).then(()=>{this._getChart(t).attachRenderComplete(()=>{if(this._getState(t).toolbarUpdateRequested){t._updateToolbar();this._getState(t).toolbarUpdateRequested=false}});this._getInnerStructure(t).setContent(this._getChart(t));this._getInnerStructure(t).setShowNoDataStruct(false);i.dataLoadedCallback=e;this._setState(t,i);let a;if(this._getBindingInfo){a=this._getBindingInfo(t);n.warning("mdc ChartDelegate","calling the private delegate._getBindingInfo. Please make the function public!")}else{a=this.getBindingInfo(t)}this.updateBindingInfo(t,a);this._performInitialBind(t,a);r()})})};y._performInitialBind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const r=this._getState(t);r.innerChartBound=true;this._checkForMeasureWarning(t)}};y.requestToolbarUpdate=function(t){if(t.getItems().length===0){t._updateToolbar();return}this._getState(t).toolbarUpdateRequested=true};y.createInnerDimension=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{this._addInnerDimension(t,e,r)})};y.createInnerMeasure=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(r=>{this._addInnerMeasure(t,e,r)})};y._addInnerDimension=function(t,e,r){const a=this.innerDimensionFactory(t,e,r);this._getChart(t).addDimension(a);if(t._bDrillDown){this._getChart(t).drillDown(a);t._bDrillDown=false}};y.innerDimensionFactory=function(t,e,r){let a;const n=this.getInternalChartNameFromPropertyNameAndKind(e?.getPropertyKey()||r.key,"groupable",t);let i={name:n,role:e?.getRole()||r.role,label:e?.getLabel()||r.label,textFormatter:this.formatText.bind(r)};const o=this.getPropertyAttribute(t,r,"timeUnitType");if(o){i=m(i,{timeUnit:o});a=new b(i)}else{a=new C(i)}const s=this.getPropertyAttribute(t,r,"textProperty");if(s){a.setTextProperty(s);a.setDisplayText(true)}return a};y._addInnerMeasure=function(t,e,r){const a=this.innerMeasureFactory(t,e,r);this._getChart(t).addMeasure(a)};y.fetchConfigurationForVizchart=function(t,e,r){return null};y.getPropertyAttribute=function(t,e,r){let a=e.hasOwnProperty(r)?e[r]:null;if(!a){a=this.fetchConfigurationForVizchart(t,e.key,r)}return a};y.innerMeasureFactory=function(t,e,r){const a=this.getPropertyAttribute(t,r,"aggregationMethod");const n=this.getPropertyAttribute(t,r,"path");const i={name:this._getAggregatedMeasureNameForMDCItem(e),label:e?.getLabel()||r.label,role:e?.getRole()||r.role||"axis1"};if(a&&n){i.analyticalInfo={propertyPath:n,with:a}}const o=this.getPropertyAttribute(t,r,"unitPath");if(o){i.unitBinding=o}return new I(i)};y.rebind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getInnerStructure(t).setShowNoDataStruct(false);if(e.binding){e.binding.bHasAnalyticalInfo=true}this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const r=this._getState(t);r.innerChartBound=true}};y._checkForMeasureWarning=function(t){if(!t.getNoData()){return}const e=t.getItems().filter(t=>t.getType()==="aggregatable");if(e.length===0){this._getInnerStructure(t).setShowNoDataStruct(true);t.setBusy(false)}else{this._getInnerStructure(t).setShowNoDataStruct(false)}};y.getBindingInfo=function(t){if(this._getBindingInfoFromState(t)){return this._getBindingInfoFromState(t)}const e=t.getDelegate().payload;const r="/"+e.collectionName;const a={path:r};return a};y.getInnerChartBound=function(t){const e=this._getState(t);return!!e?.innerChartBound};y.updateBindingInfo=function(t,e){P(t,e);e.filters=this.getFilters(t);e.sorter=this.getSorters(t)};function P(e,r){const a=t.getElementById(e.getFilter());if(!a){return}const n=a.getConditions();const o=a.getSearch instanceof Function?a.getSearch():"";if(n){const t=i.getParametersInfo(a,n);if(t){r.path=t}}if(!r.parameters){r.parameters={}}r.parameters["$search"]=o||undefined}y.getSorters=function(t){let e;const r=t.getSortConditions()?t.getSortConditions().sorters:[];r.forEach(r=>{const a=t.getItems().find(t=>t.getPropertyKey()===r.key);if(!a){return}const n=this._getSorterForItem(a,r);if(e){e.push(n)}else{e=[n]}});return e};y._getAggregatedMeasureNameForMDCItem=function(t){return this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent())};y.getInternalChartNameFromPropertyNameAndKind=function(t,e,r){return t};y.getPropertyFromNameAndKind=function(t,e,r){return r.getPropertyHelper().getProperty(t)};y.setChartTooltipVisibility=function(t,e){if(this._getChart(t)){if(e){if(!this._getState(t).vizTooltip){const e=this._getState(t);e.vizTooltip=new S;this._setState(t,e)}this._getState(t).vizTooltip.connect(this._getChart(t).getVizUid())}else if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}}else{n.error("Trying to set chart tooltip while inner chart was not yet initialized")}};y._loadChart=function(){return new Promise(t=>{const r=["sap/chart/Chart","sap/chart/data/Dimension","sap/chart/data/TimeDimension","sap/chart/data/Measure","sap/viz/ui5/controls/VizTooltip"];function a(e,r,a,n,i){_=e;C=r;b=a;I=n;S=i;t()}e.load({name:"sap.viz"}).then(()=>{sap.ui.require(r,a)})})};y.getPropertyHelperClass=function(){return d};y.formatText=function(t,e){return t};y.setNoDataText=function(t,e){this._getChart(t).setCustomMessages({NO_DATA:e})};y.showOverlay=function(t,e){if(this._getInnerStructure(t)){this._getInnerStructure(t).showOverlay(e)}};y._getPropertyInfosByName=function(t,e){return e._getPropertyByNameAsync(t)};y._getModel=function(t){const e=t.getDelegate().payload;return t.getModel(e.model)};y._addBindingListener=function(t,e,r){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=r}else{const a=t.events[e];t.events[e]=function(){r.apply(this,arguments);a.apply(this,arguments)}}};y._onDataLoadComplete=function(t){const e=this.getControlDelegate()._getInnerStructure(this);if(this.getNoData()){if(t.getSource()&&t.getSource().getCurrentContexts().length===0){e.setShowNoDataStruct(true)}else{e.setShowNoDataStruct(false)}}this._innerChartDataLoadComplete(t);const r=this.getControlDelegate()._getChart(this);this._announceUpdate(this.getChartType(),this.getHeader(),r.getVisibleDimensions().length,r.getVisibleMeasures().length)};return y});
//# sourceMappingURL=ChartDelegate.js.map