/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/SelectionPanel","sap/ui/model/Sorter","sap/m/p13n/MessageStrip","sap/ui/core/message/MessageType"],(t,e,o,s)=>{"use strict";const n=t.extend("sap.ui.mdc.p13n.panels.ActionToolbarPanel",{metadata:{library:"sap.ui.mdc"},renderer:{apiVersion:2}});n.prototype._bindListItems=function(t){const o=this.getAggregation("_template");if(o){const o=function(t){return t.getProperty("alignment")};const s=new e({path:"alignment",descending:false,group:o});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",sorter:s,key:"name",templateShareable:false,template:this.getAggregation("_template").clone()},t))}};n.prototype._removeFactoryControl=function(){this._oListControl.getItems().filter(t=>!t._bGroupHeader).forEach(t=>{const e=t.getCells()[0];if(e.getItems().length>1){e.removeItem(e.getItems()[1])}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields};n.prototype._moveTableItem=function(t,e){const o=this._oListControl.getItems();const s=this._getP13nModel().getProperty("/items");const n=s.indexOf(this._getModelEntry(t));e=e<=0?0:Math.min(e,o.length-1);const i=s.indexOf(o[e].getBindingContext(this.P13N_MODEL).getObject());if(i==n){return}s.splice(i,0,s.splice(n,1)[0]);this._getP13nModel().setProperty("/items",s);this._oSelectedItem=this._oListControl.getItems()[e];this._updateEnableOfMoveButtons(this._oSelectedItem,true);this._handleActivated(this._oSelectedItem);this.fireChange({reason:"Move",item:this._getModelEntry(this._oSelectedItem)});this._updateItemEnableState()};n.prototype._onPressButtonMoveToTop=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(!this._oListControl.getItems()[t-1]._bGroupHeader){t--}this._moveSelectedItem(t)};n.prototype._onPressButtonMoveToBottom=function(){let t=this._oListControl.getItems().indexOf(this._oHoveredItem);while(t<this._oListControl.getItems().length-1&&!this._oListControl.getItems()[t+1]._bGroupHeader){t++}this._moveSelectedItem(t)};n.prototype._onItemPressed=function(t){const e=t.getParameter("srcControl");if(!this._isControlPartOfMoveButtons(e)){const e=t.getParameter("listItem");this._oSelectedItem=e;const o=e.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this.PRESENCE_ATTRIBUTE)){this._handleActivated(e);this._updateEnableOfMoveButtons(e,true)}}};n.prototype._isControlPartOfMoveButtons=function(t){const e=this._oSelectedItem?this._oSelectedItem.getCells()[1].getItems():[];let o=false;if(e.length>2){for(let s=2;s<e.length;s++){if(e[s]==t||e[s]==t.getParent()){o=true}}}return o};n.prototype._updateEnableOfMoveButtons=function(t,e){const o=this._oListControl.getItems().indexOf(t);const s=this._oListControl.getItems().length-1;let n=true,i=true;if(o==0){n=false}if(o==s){i=false}const r=this._oListControl.getItems().some(t=>t._bGroupHeader);if(r){if(o>0&&this._oListControl.getItems()[o-1]._bGroupHeader){n=false}if(o<s&&this._oListControl.getItems()[o+1]._bGroupHeader){i=false}}this._getMoveTopButton().setEnabled(n);this._getMoveUpButton().setEnabled(n);this._getMoveDownButton().setEnabled(i);this._getMoveBottomButton().setEnabled(i);if(e){t.focus()}};n.prototype._updateMessageStripForItemEnablement=function(){const t=this._getP13nModel().getProperty("/items");const e=t.find(t=>t.enabled==false);if(!e){this.setMessageStrip(null);return}const n=new o({text:this._getResourceText("p13n.MESSAGE_DISABLED_ITEMS"),type:s.Warning,showIcon:true});this.setMessageStrip(n)};n.prototype._updateItemEnableState=function(){this._oListControl.getItems().forEach(t=>{if(!t.isA("sap.m.ColumnListItem")){return}this._updateCheckboxEnablement(t)});this._updateMessageStripForItemEnablement();this._updateClearAllIcon()};n.prototype._updateCheckboxEnablement=function(t){t.onsapspace=()=>{};t.removeStyleClass("sapMLIBActive");const e=t.getMultiSelectControl(true);e.bindProperty("enabled",{path:`${this.P13N_MODEL}>enabled`,formatter:function(t){return t??true}})};n.prototype._createInnerListControl=function(){const e=t.prototype._createInnerListControl.apply(this,arguments);return e};n.prototype.setP13nData=function(e){t.prototype.setP13nData.apply(this,arguments);this._updateItemEnableState();return this};n.prototype._filterList=function(e,o,s){t.prototype._filterList.apply(this,arguments);this._updateItemEnableState()};n.prototype._updateClearAllIcon=function(){const t=this._getP13nModel().getProperty("/items");const e=t?.filter(t=>t.enabled===false);this._oListControl._getClearAllIcon()?.setVisible(e.length===0)};return n});
//# sourceMappingURL=ActionToolbarPanel.js.map