/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/AbstractContainer","sap/m/p13n/AbstractContainerItem","sap/m/p13n/SelectionPanel","./GroupView","sap/ui/core/Lib","sap/ui/model/Filter","sap/m/Button","sap/m/Bar","sap/m/ToolbarSpacer","sap/m/Select","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/core/InvisibleText","sap/m/SearchField","sap/m/OverflowToolbarLayoutData","sap/ui/core/Item","sap/m/library","sap/ui/model/json/JSONModel"],(t,e,i,s,o,n,r,a,h,c,l,u,p,g,d,_,w,y)=>{"use strict";const{BarDesign:S}=w;const f=t.extend("sap.ui.mdc.p13n.panels.AdaptFiltersPanel",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"},enableReorder:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});f.prototype.GROUP_KEY="group";f.prototype.LIST_KEY="list";f.prototype.P13N_MODEL="$p13n";f.prototype.getVerticalScrolling=function(){return true};f.prototype.applySettings=function(o){this.addView(new e({key:this.LIST_KEY,content:new i(this.getId()+"-listView",{activeColumn:this._getResourceText("p13nDialog.LIST_VIEW_ACTIVE"),change:function(t){this.fireChange();this.getP13nModel().setProperty("/items",t.getSource().getP13nData())}.bind(this)})}));this.addView(new e({key:this.GROUP_KEY,content:new s(this.getId()+"-groupView",{change:function(t){this.fireChange();this.getP13nModel().setProperty("/itemsGrouped",t.getSource().getP13nData())}.bind(this)})}));t.prototype.applySettings.apply(this,arguments);this.getView(this.LIST_KEY).getContent().setEnableReorder(this.getEnableReorder());const n=this._getQuickFilter();const r=this._getViewSwitch();const c=this._getShowHideBtn();const l=new a({contentMiddle:[n,new h,c,r]});l.setDesign(S.SubHeader);this.setHeader(l);const u=new a({contentMiddle:[this._getSearchField()]});u.addStyleClass("sapUiMDCAdaptFiltersSearchBar");u.setDesign(S.SubHeader);this.setSubHeader(u);this.addStyleClass("sapUiMDCAdaptFiltersPanel")};f.prototype.setItemFactory=function(t){this.setProperty("itemFactory",t);this.getViews().forEach(e=>{const i=e.getContent();i.setItemFactory(t)});return this};f.prototype.switchView=function(e){const i=e;t.prototype.switchView.call(this,i);this._getShowHideBtn().setVisible(!this._isCustomView());this._getViewSwitch().setSelectedKey(this.getCurrentViewKey());if(!this._isCustomView(e)){this.showFactory(this.getCurrentViewContent()._getShowFactory())}this._filterByModeAndSearch()};f.prototype.addCustomView=function(t){const i=t.item;const s=i.getKey();const o=t.content;const n=t.search;const r=t.selectionChange;const a=t.filterSelect;if(!s){throw new Error("Please provide an item of type sap.m.SegmentedButtonItem with a key")}if(this._oViewSwitch){this._oViewSwitch.attachSelectionChange(t=>{if(r){r(t.getParameter("item").getKey())}if(this._isCustomView()){if(n instanceof Function){n(this._getSearchField().getValue())}if(a instanceof Function){a(this._getQuickFilter().getSelectedKey())}}})}if(n instanceof Function){this._getSearchField().attachLiveChange(t=>{if(this._isCustomView()){n(this._getSearchField().getValue())}})}if(a instanceof Function){this._getQuickFilter().attachChange(t=>{if(this._isCustomView()){a(this._getQuickFilter().getSelectedKey())}})}this.addView(new e({key:s,content:o.addStyleClass("sapUiMDCPanelPadding")}));const h=this._getViewSwitch();h.addItem(i)};f.prototype.showFactory=function(t){if(this.getCurrentViewContent().showFactory){this.getCurrentViewContent().showFactory(t)}};f.prototype.getSelectedFields=function(){return this.getCurrentViewContent().getSelectedFields()};f.prototype.setGroupExpanded=function(t,e){this.getView(this.GROUP_KEY).getContent().setGroupExpanded(t,e)};f.prototype.setP13nModel=function(t){this.setModel(t,this.P13N_MODEL);this.getView(this.LIST_KEY).getContent().setP13nData(t.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(t.getProperty("/itemsGrouped"));this._filterByModeAndSearch()};f.prototype.setP13nData=function(t){const e=this.getP13nModel();if(!e){this.setP13nModel(new y(t))}else{e.setData(t);this.getView(this.LIST_KEY).getContent().setP13nData(e.getProperty("/items"));this.getView(this.GROUP_KEY).getContent().setP13nData(e.getProperty("/itemsGrouped"))}};f.prototype.restoreDefaults=function(){this._sModeKey="all";this._getQuickFilter().setSelectedKey(this._sModeKey);this._getSearchField().setValue("");this._filterByModeAndSearch();if(this.getCurrentViewKey()===this.LIST_KEY){this._getShowHideBtn().setText(this._getResourceText("filterbar.ADAPT_SHOW_VALUE"));this.showFactory(false)}};f.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL)};f.prototype._getShowHideBtn=function(){const t=this._getResourceText("filterbar.ADAPT_SHOW_VALUE");const e=this._getResourceText("filterbar.ADAPT_HIDE_VALUE");if(!this._oShowHideBtn){this._oShowHideBtn=new r({press:function(i){this.showFactory(!this.getCurrentViewContent()._getShowFactory());const s=i.oSource;const o=s.getText()===t?e:t;s.setText(o)}.bind(this)})}this._oShowHideBtn.setText(!this._isCustomView()&&this.getCurrentViewContent()._getShowFactory()?e:t);return this._oShowHideBtn};f.prototype._getQuickFilter=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new c({items:[new _({key:"all",text:this._getResourceText("p13nDialog.GROUPMODE_ALL")}),new _({key:"visible",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new _({key:"active",text:this._getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new _({key:"visibleactive",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")}),new _({key:"mandatory",text:this._getResourceText("p13nDialog.GROUPMODE_MANDATORY")})],tooltip:this._getResourceText("p13nDialog.QUICK_FILTER"),change:this._onGroupModeChange.bind(this)})}return this._oGroupModeSelect};f.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new g(this.getId()+"-searchField",{liveChange:[this._filterByModeAndSearch,this],width:"100%"});this._oSearchField.setPlaceholder(this._getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"))}return this._oSearchField};f.prototype.getInitialFocusedControl=function(){return this._getSearchField()};f.prototype._onGroupModeChange=function(t){this._sModeKey=t.getParameters().selectedItem.getKey();this._filterByModeAndSearch()};f.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new l({items:[new u({tooltip:this._getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new u({tooltip:this._getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(t){if(this.getCurrentViewKey()===this.LIST_KEY){this.getCurrentViewContent()._removeMoveButtons()}const e=t.getParameter("item").getKey();this.switchView(e)}.bind(this)});this._oInvText=new p({text:this._getResourceText("p13nDialog.VIEW_SWITCH")}).toStatic();this._oViewSwitch.addAriaLabelledBy(this._oInvText)}return this._oViewSwitch};f.prototype._isCustomView=function(){return this._sCurrentView!=this.GROUP_KEY&&this._sCurrentView!=this.LIST_KEY};f.prototype._filterByModeAndSearch=function(){if(this._isCustomView(this.getCurrentViewKey())){return}this._sSearchString=this._getSearchField().getValue();const t=this._createFilterQuery();this._getSearchField().setValue(this._sSearchString);this.getCurrentViewContent().filterContent(t);return t};f.prototype._getResourceText=function(t){return o.getResourceBundleFor("sap.ui.mdc").getText(t)};f.prototype._createFilterQuery=function(){let t=[],e=[],i=[];if(this._sSearchString){t=[new n("label","Contains",this._sSearchString),new n("tooltip","Contains",this._sSearchString)];i=new n(t,false)}switch(this._sModeKey){case"visible":e=new n("visible","EQ",true);break;case"active":e=new n("active","EQ",true);break;case"mandatory":e=new n("required","EQ",true);break;case"visibleactive":e=new n([new n("active","EQ",true),new n("visible","EQ",true)],true);break;default:}const s=new n("visibleInDialog","EQ",true);return new n([].concat(i,e,s),true)};f.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._sModeKey=null;this._sSearchString=null;if(this._oInvText){this._oInvText.destroy();this._oInvText=null}};return f});
//# sourceMappingURL=AdaptFiltersPanel.js.map