/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/m/Button","sap/m/Column","sap/m/Table","sap/ui/core/Lib","sap/ui/core/Element","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/enums/ChartItemRoleType","sap/ui/core/InvisibleMessage","sap/ui/mdc/chart/Util"],(e,t,o,n,i,s,r,a,l,h,p,g,u,c,m,d,_,f,M,I,y,b,jQuery,v,P,C,B,O)=>{"use strict";const{ValueState:D}=v;const{FlexJustifyContent:x}=M;const E=e.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},init:function(){this._bMobileMode=I.system.phone;e.prototype.init.apply(this,arguments);this._bindListItems()},renderer:{apiVersion:2}});E.prototype._setInnerLayout=function(){this._oInnerControl=new c({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){let e=null;const t=this.getParent();if(t&&t.$){e=t.$("cont");if(e.children().length>0){const e=this._oInnerControl.$()[0].clientWidth;const t=570;if(!this._bMobileMode&&e<=t){this._switchMobileMode(true)}else if(this._bMobileMode&&e>t){this._switchMobileMode(false)}}}}};if(I.system.desktop){this._sContainerResizeListener=y.register(this._oInnerControl,this._fnHandleResize.bind(this))}};E.prototype._switchMobileMode=function(e){if(this._bMobileMode==e){return}this._bMobileMode=e;if(this._sContainerResizeListener){y.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._setInnerLayout();this._bindListItems()};E.prototype._createInnerListControl=function(){const e=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";const t=new l(e,Object.assign(this._getListControlConfig(),{}));this.setEnableReorder(true);const o=t.onItemFocusIn;t.onItemFocusIn=function(e,n){if(this.getEnableReorder()){this._handleActivated(e)}o.apply(t,arguments)}.bind(this);t.addEventDelegate({onAfterRendering:this._onAfterTableRender.bind(this)});return t};E.prototype._onAfterTableRender=function(){if(this._oFocusInfo){if(this._oFocusInfo.oMoveButton){this._oFocusInfo.oMoveButton.focus()}this._oFocusInfo=null}this._mInvalidMap.forEach((e,t)=>{if(this._mNamesMap.has(t)){this._mNamesMap.get(t).setValueState(D.Error);this._mNamesMap.get(t).setValue(e)}})};E.prototype._bindListItems=function(e){let t;const o=h.getResourceBundleFor("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){t=this.getPanelConfig().sorter}else{const e={text:o.getText("chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER")};const n={text:o.getText("chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER")};const i={Aggregatable:e,Groupable:n,Measure:e,Dimension:n};const s=function(e){const t=e.getProperty("kind");return{key:t,text:i[t].text}};const r=function(e,t){if(e===t){return 0}if(e==="MEASURE"||e==="AGGREGATABLE"){return 1}return-1};t=new _("kind",false,s,r)}let n;this._mTemplatesMap=new Map;this._mNamesMap=new Map;this._mInvalidMap=new Map;if(this._bMobileMode){n=this._createListItemMobile}else{n=this._createListItem}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new g({filters:[new g("visible",u.EQ,true),new g("template",u.EQ,true)],and:false})],factory:n.bind(this),sorter:t},e))};E.prototype._getTemplateComboBox=function(e){const t=new g("visible",u.EQ,false);const o=new window.Intl.Collator;const n=function(e,t){return o.compare(e,t)};const i=new _("label",false,false,n);const r=new d({id:this.getId()+"-templateComboBox-"+e,width:"100%",placeholder:this._getPlaceholderTextForTemplate(e),items:{path:this.P13N_MODEL+">/items",template:new s({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[t,new g("kind",u.EQ,e)],sorter:i},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(e,r);return r};E.prototype._getPlaceholderTextForTemplate=function(e){const t=h.getResourceBundleFor("sap.ui.mdc");return t.getText("chart.PERSONALIZATION_DIALOG_TEMPLATE_PLACEHOLDER")};E.prototype._getRoleSelect=function(){return new n({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new s({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(e){if(!e){return false}return e.length>1}}})};E.prototype._getNameComboBox=function(e,t,o){const n=new window.Intl.Collator;const i=function(e,t){return n.compare(e,t)};const r=new _("label",false,false,i);const a=new g({filters:[new g("visible",u.EQ,false),new g("name",u.EQ,o)],and:false});return new d(e+"-combo",{width:"100%",items:{path:this.P13N_MODEL+">/items",factory:function(e,t){return new s({key:t.getObject().name,text:t.getObject().label})},templateShareable:false,filters:[a,new g("kind",u.EQ,t)],sorter:r},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new b({key:"prevName",value:o}),new b({key:"prevKind",value:t})]})};E.prototype._createListItem=function(e,t){let n;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{if(t.getObject().name!=t.getObject().tempName){t.getObject().tempName=t.getObject().name}const o=this._getNameComboBox(e,t.getObject().kind,t.getObject().name);i.push(o);i.push(this._getRoleSelect());n=this.getId()+t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(new m({justifyContent:x.End,items:[new r({id:n,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",tooltip:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY"),customData:[new b({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new b({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));this._mNamesMap.set(t.getObject().name,o)}let s;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;s=new o({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(t=>t.visible===false&&t.template===false&&t.kind===e);return t.length!=0}}})}else{s=new o({cells:i})}s.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return s};E.prototype._createListItemMobile=function(e,t){let n;const i=[];if(t.getObject()&&t.getObject().template){i.push(this._getTemplateComboBox(t.getObject().kind))}else{const o=new c({items:[this._getNameComboBox(e,t.getObject().kind,t.getObject().name),this._getRoleSelect()]});n=t.getObject().kind+"-RemoveBtn-"+t.getObject().name;i.push(o)}const s=new m({justifyContent:x.End,items:[new r({id:n,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(e){return!e}},customData:[new b({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new b({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});i.push(s);let a;if(t.getObject()&&t.getObject().template){const e=t.getObject().kind;a=new o({cells:i,visible:{path:this.P13N_MODEL+">/items",formatter:function(t){t=t.filter(t=>t.visible===false&&t.template===false&&t.kind===e);return t.length!=0}}})}else{a=new o({cells:i})}a.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onkeydown:this._keydownHandler.bind(this)});return a};E.prototype._keydownHandler=function(t){if((t.metaKey||t.ctrlKey)&&t.keyCode===P.D){let e;const o=p.getElementById(t.currentTarget.id);if(this._bMobileMode){e=o.getCells()[1].getItems()[o.getCells()[1].getItems().length-1]}else{e=o.getCells()[2].getItems()[o.getCells()[2].getItems().length-1]}if(e){this._onPressHide(t,e);t.preventDefault()}}else{e.prototype._keydownHandler.apply(this,arguments)}};E.prototype._handleActivated=function(e){const t=this._getModelItemByTableItem(e);if(t&&t.template){this.removeMoveButtons()}this._oHoveredItem=e;this._updateEnableOfMoveButtons(e,false);this._addMoveButtons(e);this._setMoveButtonVisibility(true)};E.prototype.onChangeOfItemName=function(e){const t=e.getSource().data().prevName;const o=e.getSource().data().prevKind;const n=e.getSource().getSelectedKey();const i=this._getP13nModel().getProperty("/items").find(e=>e.name===t&&e.kind===o);const s=this._getP13nModel().getProperty("/items").find(e=>e.name===n&&e.kind===o);this.removeMoveButtons();if(i&&s){i.visible=false;s.visible=true;i.tempName=i.name;s.role=i.role;this._moveItemsByIndex(this._getItemIndex(s),this._getItemIndex(i),true);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes();this._mInvalidMap.delete(t);this._mInvalidMap.delete(n)}else if(e.getSource()&&e.getSource()instanceof d){this._mInvalidMap.set(e.getSource().data("prevName"),e.getSource().getValue());e.getSource().setValueState(D.Error)}};E.prototype._getItemIndexByNameAndKind=function(e,t){const o=this._getP13nModel().getProperty("/items");const n=o.find(o=>o.name===e&&o.kind===t&&!o.template);return this._getItemIndex(n)};E.prototype._getItemIndex=function(e){return this._getP13nModel().getProperty("/items").indexOf(e)};E.prototype.removeMoveButtons=function(){const e=this._getMoveButtonContainer();if(e){e.removeItem(this._getMoveBottomButton());e.removeItem(this._getMoveDownButton());e.removeItem(this._getMoveUpButton());e.removeItem(this._getMoveTopButton())}};E.prototype.getP13nData=function(){const e=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",e);return e};E.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent()}return undefined};E.prototype._addMoveButtons=function(e){const t=e;if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(t.getCells&&t.getCells()&&(t.getCells().length===2||t.getCells().length===3)&&!o){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0)}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0)}}};E.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();e.prototype._moveSelectedItem.apply(this,arguments)};E.prototype._updateAvailableRolesForItems=function(){const e=this._getP13nModel().getProperty("/items");let t=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){t=this.getPanelConfig().allowedLayoutOptions}else{f.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!")}e.forEach(e=>{if(!e.availableRoles){return}e.availableRoles=e.availableRoles.filter(e=>t.indexOf(e.key)!=-1)});this._getP13nModel().setProperty("/items",e);this._refreshP13nModel()};E.prototype._onPressHide=function(e,t){let o;if(t){o=t.data().propertyName}else{o=e.getSource().data().propertyName}const n=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);n.filter(e=>e.name===o).forEach(e=>{e.visible=false;if(this._mTemplatesMap.has(e.kind)&&this._mTemplatesMap.get(e.kind).getVisible()){this._mTemplatesMap.get(e.kind).focus()}});this._announce(this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY_ANNOUNCE"));this._getP13nModel().setProperty("/items",n);this._refreshP13nModel();this._fireChangeItems();this._updateVisibleIndexes()};E.prototype._announce=function(e){const{InvisibleMessageMode:t}=v;const o=B.getInstance();o.announce(e,t.Assertive)};E.prototype.setP13nData=function(t){t=t.filter(e=>!e.template);e.prototype.setP13nData.apply(this,arguments);let o=[];const n=[];this.getP13nData().forEach((e,t)=>{if(!e.availableRoles){e.availableRoles=O.getLayoutOptionsForType(e.kind)}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){const t=this.getPanelConfig().allowedLayoutOptions;if(t?.length>=1){e.availableRoles=e.availableRoles.filter(e=>t.indexOf(e.key)!=-1);if(t.indexOf(e.role)===-1){e.role=t[0]}}}e.template=false;e.tempName=e.name;if(!e.visible){n.push(e)}if(!e.index){e.index=t}o.push(e)});o=o.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",o);this._updateVisibleIndexes()};E.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map;this._getP13nModel().getProperty("/items").forEach((e,t)=>{if(e.template||!e.visible){return}if(this._mVisibleIndexes.has(e.kind)){this._mVisibleIndexes.get(e.kind).push(t)}else{const o=[t];this._mVisibleIndexes.set(e.kind,o)}})};E.prototype.onChangeOfTemplateName=function(e){const t=e.getSource().getSelectedKey();const o=this._getCleanP13nItems().find(e=>e.name===t);if(o){o.visible=true;e.getSource().setSelectedKey(undefined);this._refreshP13nModel();const t=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];const n=this._getItemIndexByNameAndKind(o.name,o.kind);let i=t[t.length-1];if(n>i){i+=1}if(i&&n!=i){this._moveItemsByIndex(n,i,true)}else{this._fireChangeItems()}this._mInvalidMap.delete(e.getSource().getValue());this._updateVisibleIndexes()}else if(e.getSource()&&e.getSource()instanceof d){if(e.getSource().getValue()!=""){e.getSource().setValueState(D.Error)}else{e.getSource().setValueState(D.None)}}};E.prototype._refreshP13nModel=function(){this._getP13nModel().refresh(true)};E.prototype._getTemplateItems=function(){const e=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[]}this.getPanelConfig().templateConfig.forEach(t=>{const o={template:true,kind:t.kind};e.push(o)});return e};E.prototype._getListControlConfig=function(){const t=e.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){t.columns=[new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})}),new a]}else{const e=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});const o=new a({header:new i({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})});t.columns=[e,o,new a]}t.mode="None";return t};E.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(e=>!e.template)};E.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(e=>({columnKey:e.name,visible:e.visible,index:e.index,role:e.role}))});this.fireChange()};E.prototype.onChangeOfRole=function(e){const t=e.getParameter("selectedItem");if(t){let t;if(this._bMobileMode){t=e.getSource().getParent().getParent()}else{t=e.getSource().getParent()}this.fireChange();this._updateEnableOfMoveButtons(t)}this._fireChangeItems()};E.prototype._updateEnableOfMoveButtons=function(e,t){if(!e){return}const o=this._getModelItemByTableItem(e);const n=this._getP13nModel().getProperty("/items").indexOf(o);let i=true,s=true;if(!o||o.template){return}const r=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];if(n==0||r.indexOf(n)===0){i=false}if(r.indexOf(n)===r.length-1){s=false}this._getMoveTopButton().setEnabled(i);this._getMoveUpButton().setEnabled(i);this._getMoveDownButton().setEnabled(s);this._getMoveBottomButton().setEnabled(s);if(t&&(!s||!i)){this._oFocusInfo={oMoveButton:!s?this._getMoveUpButton():this._getMoveDownButton()}}};E.prototype._getListItemFromMoveButton=function(e){if(e&&e.getParent()&&e.getParent().getParent()){return e.getParent().getParent()}return undefined};E.prototype._onPressButtonMoveToTop=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind)[0];this._oSelectedItem=t;this._moveSelectedItem(n)};E.prototype._onPressButtonMoveUp=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind);const i=this._getP13nModel().getProperty("/items").indexOf(o);this._oSelectedItem=t;const s=n[n.indexOf(i)-1];this._moveSelectedItem(s)};E.prototype._onPressButtonMoveDown=function(e,t){if(!t){t=this._getListItemFromMoveButton(e.getSource())}if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind);const i=this._getP13nModel().getProperty("/items").indexOf(o);this._oSelectedItem=t;const s=n[n.indexOf(i)+1];this._moveSelectedItem(s)};E.prototype._onPressButtonMoveToBottom=function(e){const t=this._getListItemFromMoveButton(e.getSource());if(!t){return}const o=this._getP13nModel().getProperty(t.getBindingContextPath());const n=this._mVisibleIndexes.get(o.kind)[this._mVisibleIndexes.get(o.kind).length-1];this._oSelectedItem=t;this._moveSelectedItem(n)};E.prototype._moveTableItem=function(e,t){const o=this._getP13nModel().getProperty("/items");const n=o.indexOf(e.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(n,t)};E.prototype._moveItemsByIndex=function(e,t,o){const n=this._getP13nModel().getProperty("/items");t=t<=0?0:Math.min(t,n.length-1);if(t==e){return}n.splice(t,0,n.splice(e,1)[0]);n.forEach((e,t)=>{if(!e.template){e.index=t}});this._getP13nModel().setProperty("/items",n);if(!o){this._oSelectedItem=this._oListControl.getItems().find(e=>{const o=this._getModelItemByTableItem(e);return o&&o===n[t]});this._updateEnableOfMoveButtons(this._oSelectedItem,!o);this._handleActivated(this._oSelectedItem)}this._fireChangeItems()};E.prototype._getModelItemByTableItem=function(e){return this._getP13nModel().getProperty(e.getBindingContextPath())};E.prototype._getMoveConfigForTableItem=function(e){const t=this._getModelItemByTableItem(e);if(!t){return undefined}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(t),aggregationRole:t.kind,template:t.template}};E.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){const t=e.prototype._getDragDropConfig.apply(this,arguments);t.attachDragStart(this._checkDragStart.bind(this));t.attachDragEnter(this._checkDrag.bind(this));t.attachDragEnd(()=>{this._oDraggedItem=null});return t}return this._oDragDropInfo};E.prototype._checkDrag=function(e){const t=e.getParameter("target");const o=this._getMoveConfigForTableItem(t);const n=this._getMoveConfigForTableItem(this._oDraggedItem);if(!o||o.template||n.aggregationRole!=o.aggregationRole){e.preventDefault();return}};E.prototype._checkDragStart=function(e){this._oDraggedItem=e.getParameter("target");this._checkDrag(e)};E.prototype._onRearrange=function(e){const t=e.getParameter("draggedControl");const o=e.getParameter("droppedControl");const n=e.getParameter("dropPosition");const i=this._getMoveConfigForTableItem(t);const s=this._getMoveConfigForTableItem(o);if(!i||i.template||!s){e.preventDefault();return}const r=i.currentIndex;let a=s.currentIndex;if(s.template&&n=="After"){e.preventDefault();return}if(!s.template&&(i.aggregationRole!=undefined&&i.aggregationRole!=s.aggregationRole)){e.preventDefault();return}if(r<a){if(n=="Before"&&a!=0){a-=1}}else if(n=="After"){a+=1}this._moveItemsByIndex(r,a);this._refreshP13nModel();this._updateVisibleIndexes()};E.prototype._getMoveTopButton=function(){if(this._oMoveTopButton&&this._oMoveTopButton.isDestroyed()){this._oMoveTopButton=null}return e.prototype._getMoveTopButton.apply(this,arguments)};E.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null}return e.prototype._getMoveUpButton.apply(this,arguments)};E.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null}return e.prototype._getMoveDownButton.apply(this,arguments)};E.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null}return e.prototype._getMoveBottomButton.apply(this,arguments)};E.prototype._getResourceTextMDC=function(e,t){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:h.getResourceBundleFor("sap.ui.mdc");return e?this.oResourceBundleMDC.getText(e,t):this.oResourceBundleMDC};E.prototype.exit=function(){this._fnSort=null;this.oResourceBundleMDC=null;this._bMobileMode=null;return e.prototype.exit.apply(this,arguments)};E.prototype.onReset=function(){};return E});
//# sourceMappingURL=ChartItemPanel.js.map