/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/BasePanel","sap/m/Label","sap/base/util/deepEqual","sap/m/CustomListItem","sap/m/List","sap/m/Panel","sap/m/Toolbar","sap/m/Text","sap/ui/core/Element","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/core/library","sap/m/HBox","sap/m/library","sap/base/util/merge","sap/m/Title"],(t,e,i,o,n,s,r,a,l,c,p,h,d,g,u,_)=>{"use strict";const{IconColor:f}=h;const{FlexJustifyContent:m}=g;const{ListKeyboardMode:C}=g;const y=t.extend("sap.ui.mdc.p13n.panels.GroupView",{metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"}}},renderer:{apiVersion:2}});y.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCGroupView");const e=new o({visible:"{"+this.P13N_MODEL+">groupVisible}",accDescription:{path:this.P13N_MODEL+">groupLabel",formatter:function(t){return p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.FILTER_GROUP_DESCRIPTION",[t])}},content:[this._createGroupPanelTemplate()]});this._bShowFactory=true;this.displayColumns();this._aInitializedLists=[];this._setTemplate(e);e.setType("Inactive");this._setMoveButtonVisibility(true)};y.prototype._getShowFactory=function(){return this._bShowFactory};y.prototype.getPanels=function(){const t=[];this._oListControl.getItems().forEach(e=>{t.push(e.getContent()[0])});return t};y.prototype._createGroupPanelTemplate=function(){const{P13N_MODEL:t}=this;return new s({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(t)){const e=this.getBindingContext(t).sPath.split("/")[2]==="0";return e}else{return false}}},expand:function(t){const e=t.getSource();const i=e.getContent()[0];this._addInitializedList(i);if(this._getShowFactory()){this._addFactoryControl(i);this.filterContent(this._aCurrentFilters)}}.bind(this),width:"100%",headerToolbar:[new r({content:[new _({wrapping:true,text:"{"+this.P13N_MODEL+">groupLabel}"})]})],content:[this._createGroupListTemplate()]})};y.prototype._createGroupListTemplate=function(){const t=new n({keyboardMode:C.Edit,selectionChange:function(t){const{sPath:e}=t.getParameter("listItem").getBindingContext(this.P13N_MODEL);const i=this._getP13nModel().getProperty(e);const o=this.getModel(this.P13N_MODEL);if(o&&i){o.setProperty(e+"/selected",i.visible)}const n=this._checkSpecialChangeReason(t.getParameter("selectAll"),t.getParameter("listItems"));this.fireChange({reason:n||(i.visible?this.CHANGE_REASON_ADD:this.CHANGE_REASON_REMOVE),item:i})}.bind(this),showSeparators:"None",mode:"MultiSelect"});t.bindItems(this._getItemsBinding());return t};y.prototype._addFactoryControl=function(t){if(t.getItems().length==0||t.getItems()[0].getContent().length<2){t.getItems().forEach(t=>{const e=t.getBindingContext(this.P13N_MODEL);const i=this.getItemFactory().call(this,e);if(i){t.addContent(i);const e=t.getContent()[0].getItems()[0];e.setLabelFor(i)}if(t.getContent()[0].getItems().length>1){t.getContent()[0].removeItem(1)}})}this.addStyleClass("sapUiMDCAFLabelMarking")};y.prototype._createInnerListControl=function(){const t=new n(this.getId()+"-innerGroupViewList",Object.assign(this._getListControlConfig(),{keyboardMode:C.Edit,mode:"None",infoToolbar:new r,updateStarted:function(t){this._checkAllPanels()}.bind(this)}));return t};y.prototype._getItemsBinding=function(){const t=function(){const t=[new d({width:"100%",justifyContent:m.SpaceBetween,items:[new e({required:"{"+this.P13N_MODEL+">required}",text:"{"+this.P13N_MODEL+">label}"})]})];return new o({selected:"{"+this.P13N_MODEL+">visible}",tooltip:"{"+this.P13N_MODEL+">tooltip}",accDescription:"{"+this.P13N_MODEL+">label}",content:t})}.bind(this);return{path:this.P13N_MODEL+">items",templateShareable:false,template:t()}};y.prototype._getIconTemplate=function(){return new d({width:"18.5%",justifyContent:m.Center,items:[new c({src:"sap-icon://circle-task-2",size:"0.5rem",color:f.Neutral,visible:{path:this.P13N_MODEL+">active",formatter:function(t){if(t){return true}else{return false}}}})]})};y.prototype._loopGroupList=function(t){this._oListControl.getItems().forEach(e=>{const i=e.getContent()[0];const o=i.getContent()[0];this._loopItems(o,(e,i)=>{t(e,i)})})};y.prototype._loopItems=function(t,e){t.getItems().forEach(t=>{const i=t.getBindingContextPath();const o=this._getP13nModel().getProperty(i).name;e.call(this,t,o)})};y.prototype._removeFactoryControl=function(){this._loopGroupList((t,e)=>{if(t.getContent()[1]){t.removeContent(t.getContent()[1]);const e=t.getParent();this._addInitializedList(e);const i=this._getIconTemplate();t.getContent()[0].addItem(i)}});this.removeStyleClass("sapUiMDCAFLabelMarking");return this._aInitializedLists||[]};y.prototype._addInitializedList=function(t){const e=t.getId();if(this._aInitializedLists.indexOf(e)<0){this._aInitializedLists.push(e)}};y.prototype._getInitializedLists=function(){const t=[];this._aInitializedLists.forEach(e=>{const i=l.getElementById(e);if(i){t.push(i)}});return t};y.prototype.getSelectedFields=function(){const t=[];this._oListControl.getItems().forEach(e=>{const i=e.getContent()[0];const o=i.getContent()[0];this._loopItems(o,(e,i)=>{if(e.getSelected()){t.push(i)}})});return t};y.prototype.filterContent=function(t){if(!this._bInitialized||i(t,this._aCurrentFilters)){return}const e=this._removeFactoryControl();this._oListControl.getItems().forEach(i=>{const o=i.getContent()[0];const n=o.getContent()[0];if(n.getBinding("items")){n.getBinding("items").filter(t,true);this._togglePanelVisibility(o)}if(this._getShowFactory()&&e.indexOf(n.getId())>-1){this._addFactoryControl(n)}});this._aCurrentFilters=t};y.prototype.showFactory=function(t){this._bShowFactory=t;this.displayColumns();if(t){this._getInitializedLists().forEach(t=>{this._addFactoryControl(t)})}else{this._removeFactoryControl()}};y.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(t=>{const e=t.getContent()[0];this._togglePanelVisibility(e)})};y.prototype.setGroupExpanded=function(t,e){this._oListControl.getItems().forEach(function(i){const o=i.getContent()[0];const n=o.getBindingContext(this.P13N_MODEL).sPath;const s=this._getP13nModel().getProperty(n);if(s.group===t){o.setExpanded(e)}},this)};y.prototype._togglePanelVisibility=function(t){const e=t.getContent()[0];const i=t.getBindingContext(this.P13N_MODEL);if(i){const t=i.sPath;const o=this._getP13nModel().getProperty(t);o.groupVisible=e.getVisibleItems().length<1?false:true;this._getP13nModel().setProperty(t,o)}};y.prototype.getItems=function(){return this._oListControl.getItems()};y.prototype._checkFirstGroup=function(){if(!this._bInitialized&&this._oListControl&&this._oListControl.getItems().length>0){this._bInitialized=true;const t=this._oListControl.getItems()[0].getContent()[0].getContent()[0];this._addFactoryControl(t);this._addInitializedList(t)}};y.prototype.displayColumns=function(){const t=this._oListControl.getInfoToolbar().removeAllContent();t.forEach(t=>{t.destroy()});this._oListControl.getInfoToolbar().addContent(new a({width:"75%",text:p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_COLUMN")}).addStyleClass("firstColumnPadding"));if(!this._bShowFactory){this._oListControl.getInfoToolbar().addContent(new a({textAlign:"Center",width:"25%",text:p.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.LIST_VIEW_ACTIVE")}).addStyleClass("firstColumnPadding"))}};y.prototype.setP13nData=function(t){this._getP13nModel().setProperty("/itemsGrouped",t);if(!this._bInitialized){this._bindListItems()}this._checkFirstGroup();this._checkAllPanels()};y.prototype.getP13nData=function(t){let e=this._getP13nModel().getProperty("/itemsGrouped");if(t){e=e.filter(t=>t[this.PRESENCE_ATTRIBUTE])}return e};y.prototype._bindListItems=function(){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/itemsGrouped",templateShareable:false,key:"group",template:this.getAggregation("_template").clone()}))};y.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._aInitializedLists=null;this._bShowFactory=false;this._bInitialized=false};return y});
//# sourceMappingURL=GroupView.js.map