/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/p13n/FilterController","sap/ui/core/Lib","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual"],(t,e,n,o,i,r)=>{"use strict";const a=t.extend("sap.ui.mdc.p13n.subcontroller.FilterController");a.prototype.getStateKey=function(){return"filter"};a.prototype.getUISettings=function(){return{title:e.getResourceBundleFor("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE"),tabText:e.getResourceBundleFor("sap.ui.mdc").getText("p13nDialog.TAB_Filter"),afterClose:function(t){const e=t.getSource();if(e){const t=e.getContent()[0];if(t.isA("sap.m.p13n.Container")){t.removeView("Filter")}else{e.removeAllContent()}}e.destroy()}}};a.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState()[this.getStateKey()]};a.prototype.getSelectorForReset=function(){const t=this.getAdaptationControl(),e=t.getInbuiltFilter();let n=[t];if(e){n=n.concat(e)}return n};a.prototype.getBeforeApply=function(){const t=this.getAdaptationControl().getInbuiltFilter();const e=t?t.createConditionChanges():Promise.resolve([]);return e};a.prototype.getFilterControl=function(){return this.getAdaptationControl().isA("sap.ui.mdc.IFilter")?this.getAdaptationControl():this.getAdaptationControl()._oP13nFilter};a.prototype.sanityCheck=function(t){a.checkConditionOperatorSanity(t);return t};a.prototype._indexOfCondition=function(t,e){return o.indexOfCondition(t,e)};a.checkConditionOperatorSanity=function(t){for(const e in t){const n=t[e];for(let r=0;r<n.length;r++){const a=n[r];const s=a.operator;if(!o.getOperator(s)){n.splice(r,1);if(t[e].length==0){delete t[e]}i.warning("The provided conditions for field '"+e+"' contain unsupported operators - these conditions will be neglected.")}}}};a.prototype.initAdaptationUI=function(t,n){const o=this.mixInfoAndState(t);return this.getAdaptationControl().retrieveInbuiltFilter().then(t=>{t.setP13nData(o);t.setLiveMode(false);t.setProperty("_useFixedWidth",false);t.getTitle=function(){return e.getResourceBundleFor("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE")};this._oAdaptationFB=t;return t.createFilterFields().then(()=>{this._oPanel=t;return t})})};a.prototype.update=function(t){if(this._oPanel){const e=this.mixInfoAndState(t);this._oPanel.setP13nData(e);const n=this.getAdaptationControl();const o=n&&n.getInbuiltFilter();if(o){o.createFilterFields()}}};a.prototype.getDelta=function(t){if(t.applyAbsolute===n.FullReplace){Object.keys(t.existingState).forEach(function(e){if(!t.changedState.hasOwnProperty(e)){t.changedState[e]=[]}})}return this.getConditionDeltaChanges(t)};a.prototype._createConditionChangeContent=function(t,e){return{name:t,condition:e}};a.prototype.model2State=function(){const t={},e=this.getCurrentState();this.getP13nData().items.forEach(n=>{if(n.active&&Object.keys(e).includes(n.name)){t[n.name]=e[n.name]}});return t};a.prototype.mixInfoAndState=function(t){const e=this.getCurrentState()||{};const n=this.prepareAdaptationData(t,(t,n)=>{const o=e[t.name];t.active=o&&o.length>0?true:false;return!(n.filterable===false)});this.sortP13nData({visible:"active",position:undefined},n.items);return n};a.prototype.changesToState=function(t,e,n){const o={};t.forEach(t=>{const e=r({},t.changeSpecificData.content);const n=e.name;if(!o[n]){o[n]=[]}if(t.changeSpecificData.changeType===this.getChangeOperations()["remove"]){e.condition.filtered=false}o[n].push(e.condition)});return o};return a});
//# sourceMappingURL=FilterController.js.map