/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/dnd/DragDropBase","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/base/ManagedObjectObserver"],(t,e,o,r)=>{"use strict";const n=t.extend("sap.ui.mdc.table.DragDropConfig",{metadata:{library:"sap.ui.mdc",properties:{draggable:{type:"boolean",defaultValue:false},droppable:{type:"boolean",defaultValue:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move"},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On"}},events:{dragStart:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"},browserEvent:{type:"DragEvent"}}},dragEnd:{parameters:{bindingContext:{type:"sap.ui.model.Context"},browserEvent:{type:"DragEvent"}}},dragEnter:{allowPreventDefault:true},dragOver:{allowPreventDefault:true},drop:{}}}});n.prototype.init=function(){this._oObserver=new r(this._observeChanges.bind(this))};n.prototype.exit=function(){this._oObserver.destroy();this._oObserver=null};n.prototype.setDraggable=function(t){this.setProperty("draggable",t,true);this.getDraggable()?this._addDragInfoToTable():this._removeDragInfoFromTable();return this};n.prototype.setDroppable=function(t){this.setProperty("droppable",t,true);this.getDroppable()?this._addDropInfoToTable():this._removeDropInfoFromTable();return this};n.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);this._oDragInfo?.setEnabled(t);this._oDropInfo?.setEnabled(t);return this};n.prototype.setGroupName=function(t){this.setProperty("groupName",t,true);this._oDragInfo?.setGroupName(t);this._oDropInfo?.setGroupName(t);return this};n.prototype.setKeyboardHandling=function(t){this.setProperty("keyboardHandling",t,true);this._oDragInfo?.setKeyboardHandling(t);this._oDropInfo?.setKeyboardHandling(t);return this};n.prototype.setDropEffect=function(t){this.setProperty("dropEffect",t,true);this._oDropInfo?.setDropEffect(t);return this};n.prototype.setDropPosition=function(t){this.setProperty("dropPosition",t,true);this._oDropInfo?.setDropPosition(t);return this};n.prototype.setParent=function(){const e=this.getParent();e&&this._disconnectFromParent(e);t.prototype.setParent.apply(this,arguments);const o=this.getParent();o&&this._connectToParent(o)};n.prototype._connectToParent=function(t){this._oObserver.observe(t,{aggregations:["_content"]});const e=t.getAggregation("_content");e&&this._connectToTable(e)};n.prototype._disconnectFromParent=function(t){this._oObserver?.unobserve(t,{aggregations:["_content"]});this._disconnectFromTable()};n.prototype._observeChanges=function(t){if(t.mutation=="insert"){this._connectToTable(t.child)}else{this._disconnectFromTable()}};n.prototype._connectToTable=function(t){this._oTable=t;this._addDragInfoToTable();this._addDropInfoToTable()};n.prototype._disconnectFromTable=function(){this._removeDragInfoFromTable();this._removeDropInfoFromTable();this._oTable=null};n.prototype._addDragInfoToTable=function(){if(this._oTable&&!this._oDragInfo&&this.getDraggable()){this._oDragInfo=new e({enabled:this.getEnabled(),groupName:this.getGroupName(),keyboardHandling:this.getKeyboardHandling(),sourceAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragStart:[this._onDragInfoEvent,this],dragEnd:[this._onDragInfoEvent,this]});this._oTable.addDragDropConfig(this._oDragInfo)}};n.prototype._removeDragInfoFromTable=function(){if(this._oTable&&this._oDragInfo){this._oTable.removeDragDropConfig(this._oDragInfo);this._oDragInfo.destroy();this._oDragInfo=null}};n.prototype._addDropInfoToTable=function(){if(this._oTable&&!this._oDropInfo&&this.getDroppable()){this._oDropInfo=new o({enabled:this.getEnabled(),groupName:this.getGroupName(),dropEffect:this.getDropEffect(),dropPosition:this.getDropPosition(),keyboardHandling:this.getKeyboardHandling(),targetAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragEnter:[this._onDropInfoEvent,this],dragOver:[this._onDropInfoEvent,this],drop:[this._onDropInfoEvent,this]});this._oTable.addDragDropConfig(this._oDropInfo)}};n.prototype._removeDropInfoFromTable=function(){if(this._oTable&&this._oDropInfo){this._oTable.removeDragDropConfig(this._oDropInfo);this._oDropInfo.destroy();this._oDropInfo=null}};function s(t){const e=t.isA("sap.m.ListItemBase")?"items":"rows";const o=t.getParent().getBindingInfo(e)||{};return t.getBindingContext(o.model)}function a(t){let e;const o=t.getDragControl();if(o?.isA("sap.m.ListItemBase")){e=s(o)}else if(o?.isA("sap.ui.table.Row")){e=t.getComplexData("sap.ui.table-"+o.getParent().getId()).draggedRowContext}return e||o}n.prototype._onDragInfoEvent=function(t){const e=t.getParameter("dragSession");const o=t.getId()=="dragStart";const r={bindingContext:a(e),browserEvent:t.getParameter("browserEvent")};const n=this.fireEvent(t.getId(),r,o);if(o&&!n){t.preventDefault()}};n.prototype._onDropInfoEvent=function(t){const e=t.getParameter("dragSession");const o=e.getDropControl();const r=t.getParameter("dropPosition");const n=t.getId().startsWith("drag");const i={bindingContext:s(o),dragSource:a(e),browserEvent:t.getParameter("browserEvent")};if(r){i.dropPosition=r}const p=this.fireEvent(t.getId(),i,n);if(n&&!p){t.preventDefault()}};return n});
//# sourceMappingURL=DragDropConfig.js.map