/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableTypeBase","./menu/GroupHeaderRowContextMenu","../enums/TableRowCountMode","sap/m/table/Util","./utils/Personalization","sap/ui/model/json/JSONModel","sap/ui/core/Lib"],(e,t,o,n,i,s,a)=>{"use strict";let l,r,u,c,p,d;const g=e.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.enums.TableRowCountMode",group:"Behavior",defaultValue:o.Auto},rowCount:{type:"int",group:"Appearance",defaultValue:10},selectionLimit:{type:"int",group:"Behavior",defaultValue:200},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},scrollThreshold:{type:"int",group:"Behavior",defaultValue:-1}}}});g.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this.disableColumnResize()};g.prototype.updateTableByProperty=function(e,t){const n=this.getInnerTable();if(!n){return}if(e==="rowCountMode"){let e=n.getRowMode();let i=false;if(e&&(t===o.Fixed&&!e.isA("sap.ui.table.rowmodes.Fixed")||t===o.Auto&&!e.isA("sap.ui.table.rowmodes.Auto")||t===o.Interactive&&!e.isA("sap.ui.table.rowmodes.Interactive"))){const t=this.getTable().getCreationRow();if(t){i=t.getVisible()}e.destroy();e=null}if(!e){const e=p[t]??p[o.Auto];const s=new e({fixedBottomRowCount:"{= ${$sap.ui.mdc.Table>/@custom/hasGrandTotal} ? 1 : 0}"});n.setRowMode(s.setHideEmptyRows?.(i)??s)}this._updateTableRowCount()}else if(e==="rowCount"){this._updateTableRowCount()}};g.prototype._updateTableRowCount=function(){const e=this.getInnerTable();if(this.getRowCountMode()===o.Fixed||this.getRowCountMode()===o.Interactive){e.getRowMode().setRowCount(this.getRowCount())}else{e.getRowMode().setMinRowCount(this.getRowCount())}};g.prototype.loadUiTableLibrary=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=a.load({name:"sap.ui.table"})}return this._oGridTableLibLoaded};g.prototype.loadModules=function(){if(l){return Promise.resolve()}return this.loadUiTableLibrary().then(()=>new Promise((e,t)=>{sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/rowmodes/Fixed","sap/ui/table/rowmodes/Auto","sap/ui/table/rowmodes/Interactive","sap/ui/table/RowSettings"],(t,n,i,s,a,g,h,b)=>{l=t;r=n;u=i;c=s;p={[o.Fixed]:a,[o.Auto]:g,[o.Interactive]:h};d=b;e()},()=>{t("Failed to load some modules")})}))};g.prototype.createTable=function(e){const o=this.getTable();if(!o||!l){return null}const n=new l(e,this.getTableSettings());n.setAggregation("groupHeaderRowContextMenu",new t);return n};g.prototype.getTableSettings=function(){const t=this.getTable();const o={SingleMaster:"RowOnly"};const n=this.getRowSettingsConfig();const i={enableBusyIndicator:true,enableColumnReordering:false,threshold:{path:"$sap.ui.mdc.Table>/threshold",formatter:function(e){return e>-1?e:undefined}},scrollThreshold:"{$sap.ui.mdc.Table#type>/scrollThreshold}",noData:t._getNoDataText(),extension:[t._oToolbar],ariaLabelledBy:[t._oTitle],rowSettingsTemplate:n?new d(n):null,selectionMode:"None",selectionBehavior:{path:"$sap.ui.mdc.Table>/selectionMode",formatter:function(e){return o[e]}},enableColumnFreeze:"{$sap.ui.mdc.Table#type>/enableColumnFreeze}",fixedColumnCount:{parts:[{path:"$sap.ui.mdc.Table#type>/fixedColumnCount"},{path:"$typeSettings>/p13nFixedColumnCount"}],formatter:function(e,t){return t??e}},models:{$typeSettings:new s({p13nFixedColumnCount:null})},columnFreeze:[f,this],beforeOpenContextMenu:[b,this]};if(t.hasListeners("rowPress")){i.cellClick=[h,this]}return Object.assign({},e.prototype.getTableSettings.apply(this,arguments),i)};function h(e){this.callHook("RowPress",this.getTable(),{bindingContext:e.getParameter("rowBindingContext")})}function b(e){const t=e.getParameters();const o=this.getTable();const n=this.getInnerTable();const i=n.getRows().find(e=>e.getIndex()===t.rowIndex);this.callHook("BeforeOpenContextMenu",o,{bindingContext:n.getContextByIndex(t.rowIndex),column:o.getColumns()[t.columnIndex],contextMenu:t.contextMenu,event:e,groupLevel:t.contextMenu.isA("sap.ui.mdc.table.menu.GroupHeaderRowContextMenu")?i.getLevel():undefined})}g.createColumn=function(e,t){return new r(e,t)};g.prototype.enableColumnResize=function(){const e=this.getTable();const t=this.getInnerTable();if(!e||!t){return}t.getColumns().forEach(e=>{e.setResizable(true);e.setAutoResizable(true)});t.detachColumnResize(m,this);t.attachColumnResize(m,this)};g.prototype.disableColumnResize=function(){const e=this.getTable();const t=this.getInnerTable();if(!e||!t){return}t.getColumns().forEach(e=>{e.setResizable(false);e.setAutoResizable(false)});t.detachColumnResize(m,this)};function m(e){const t=this.getTable();const o=this.getInnerTable();const n=e.getParameter("column");const i=e.getParameter("width");const s=o.indexOfColumn(n);const a=t.getColumns()[s];this.callHook("ColumnResize",t,{column:a,width:i})}async function f(e){const t=this.getTable();await Promise.resolve();i.createFixedColumnCountChange(t,{fixedColumnCount:this.getInnerTable().getFixedColumnCount()})}g.prototype.updateRowSettings=function(){const e=this.getInnerTable();if(!e){return}e.destroyRowSettingsTemplate();e.setRowSettingsTemplate(new d(this.getRowSettingsConfig()));this.updateRowActions()};g.prototype.updateRowActions=function(){const e=this.getInnerTable();if(!e){return}const t=this.getTable().getRowSettings();this._removeRowActions();if(!t||!t.isBound("rowActions")&&(!t.getRowActions()||t.getRowActions().length==0)){return}const o=t.getAllActions();if("templateInfo"in o){const e=o.templateInfo;o.items.template=new c({type:e.type,visible:e.visible,icon:e.icon,text:e.text,press:[w,this]});delete o.templateInfo}else{o.items=o.items.map(function(e){const t=new c({type:e.isBound("type")?e.getBindingInfo("type"):e.getType(),visible:e.isBound("visible")?e.getBindingInfo("visible"):e.getVisible(),icon:e.isBound("icon")?e.getBindingInfo("icon"):e.getIcon(),text:e.isBound("text")?e.getBindingInfo("text"):e.getText(),press:[w,this]});t.data("rowAction",e);return t},this)}e.setRowActionTemplate(new u(o));e.setRowActionCount(t.getRowActionCount())};g.prototype._removeRowActions=function(){const e=this.getInnerTable();const t=e.getRowActionTemplate();if(t){t.destroy()}e.setRowActionTemplate();e.setRowActionCount()};function w(e){const t=this.getTable();const o=e.getParameter("item");const n=t.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const e=i.items.model;const t=o.getBindingContext(e);if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setBindingContext(t,i.items.model);this._oRowActionItem.setModel(this.getModel(e),e);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this.callHook("Press",this._oRowActionItem,{bindingContext:e.getParameter("row").getBindingContext(this.getInnerTable().getBindingInfo("rows").model)})}g.prototype.prepareRowPress=function(){const e=this.getInnerTable();if(e&&!e.hasListeners("cellClick")){e.attachEvent("cellClick",h,this)}};g.prototype.cleanupRowPress=function(){const e=this.getTable();if(!e.hasListeners("rowPress")){this.getInnerTable()?.detachEvent("cellClick",h,this)}};g.prototype.removeToolbar=function(){const e=this.getInnerTable();if(e){e.removeExtension(this.getTable()._oToolbar)}};g.prototype.scrollToIndex=function(e){const t=this.getTable();const o=this.getInnerTable();if(!o){return Promise.reject()}return new Promise(i=>{if(e===-1){e=n.isEmpty(t.getRowBinding())?0:t.getRowBinding().getLength()}if(o._setFirstVisibleRowIndex(e)){o.attachEventOnce("rowsUpdated",()=>{i()})}else{i()}})};g.prototype.getRowBinding=function(){const e=this.getInnerTable();return e?e.getBinding():undefined};g.prototype.bindRows=function(e){const t=this.getInnerTable();if(t){t.bindRows(e)}};g.prototype.isTableBound=function(){const e=this.getInnerTable();return e?e.isBound("rows"):false};g.prototype.insertFilterInfoBar=function(e,t){const o=this.getInnerTable();if(o){o.insertExtension(e,1);if(!o.getAriaLabelledBy().includes(t)){o.addAriaLabelledBy(t)}}};g.prototype.updateSortIndicator=function(e,t){e.getInnerColumn().setSorted(t!=="None");e.getInnerColumn().setSortOrder(t)};g.prototype.getTableStyleClasses=function(){const t=e.prototype.getTableStyleClasses.apply(this,arguments);if(this.getRowCountMode()===o.Auto){t.push("sapUiMdcTableFitContainer")}return t};g.prototype.setScrollThreshold=function(e){this.setProperty("scrollThreshold",e,true);return this};g.prototype.setEnableColumnFreeze=function(e){if(this.getEnableColumnFreeze()!==e){this.setProperty("enableColumnFreeze",e,true);this.getTable()?._updateAdaptation()}return this};g.prototype.onModifications=function(){const e=this.getTable();const t=this.getInnerTable();const o=e._getXConfig();const n=o?.aggregations?.type;t.getModel("$typeSettings").setProperty("/p13nFixedColumnCount",n?.GridTable?.fixedColumnCount??0)};g.prototype.showXConfigState=function(){return this.getEnableColumnFreeze()};return g});
//# sourceMappingURL=GridTableType.js.map