/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableTypeBase","./utils/Personalization","sap/m/plugins/ColumnResizer","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowActionType"],(t,e,o,n,i,s,a,r,l,u)=>{"use strict";let p,h,c;const g=t.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.enums.TableGrowingMode",group:"Behavior",defaultValue:l.Basic},showDetailsButton:{type:"boolean",group:"Behavior",defaultValue:false},detailsButtonSetting:{type:"sap.ui.core.Priority[]",group:"Behavior"},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:"Block"}}}});g.prototype.setDetailsButtonSetting=function(t){return this.setProperty("detailsButtonSetting",t,true)};g.prototype.setParent=function(){t.prototype.setParent.apply(this,arguments);this._oShowDetailsButton?.destroy();delete this._oShowDetailsButton;return this};g.prototype.updateTableByProperty=function(t,e){const o=this.getInnerTable();if(!o){return}if(t==="growingMode"){o.setGrowingScrollToLoad(e===l.Scroll);o.setGrowing(e!==l.None)}else if(t==="showDetailsButton"){this._updateShowDetailsButton(o,e)}else if(t==="popinLayout"){o.setPopinLayout(e)}};g.prototype._updateShowDetailsButton=function(t,e){if(e&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);t.attachEvent("popinChanged",w,this);t.setHiddenInPopin(this._getImportanceToHide())}else if(!e&&this._oShowDetailsButton){t.detachEvent("popinChanged",w,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton}};g.prototype.loadModules=function(){if(!p){return new Promise((t,e)=>{sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],(e,o,n)=>{p=e;h=o;c=n;t()},()=>{e("Failed to load some modules")})})}else{return Promise.resolve()}};g.prototype.createTable=function(t){const e=this.getTable();if(!e||!p){return null}return new p(t,this.getTableSettings())};g.prototype.getTableSettings=function(){const e=this.getTable();const o={autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","GroupHeaders","HeaderToolbar","InfoToolbar"],growingThreshold:{path:"$sap.ui.mdc.Table>/threshold",formatter:function(t){return t>-1?t:undefined}},noData:e._getNoDataText(),headerToolbar:e._oToolbar,ariaLabelledBy:[e._oTitle],beforeOpenContextMenu:[f,this]};if(e.hasListeners("rowPress")){o.itemPress=[d,this]}return Object.assign({},t.prototype.getTableSettings.apply(this,arguments),o)};function d(t){this.callHook("RowPress",this.getTable(),{bindingContext:t.getParameter("listItem").getBindingContext(this.getInnerTable().getBindingInfo("items").model)});b.call(this,t)}function f(t){const e=t.getParameters();const o=this.getInnerTable();const n=a.getElementById(e.column?.getId().replace(/\-innerColumn$/,""));this.callHook("BeforeOpenContextMenu",this.getTable(),{bindingContext:e.listItem.getBindingContext(o.getBindingInfo("items").model),column:n,contextMenu:o.getContextMenu(),event:t,groupLevel:undefined})}g.createColumn=function(t,e){return new h(t,e)};g.prototype.createRowTemplate=function(t){return new c(t,this.getRowSettingsConfig())};g.prototype.prepareRowPress=function(){if(this._attachItemPress()){this.updateRowActions()}};g.prototype.cleanupRowPress=function(){if(this._detachItemPress()){this.updateRowActions()}};g.prototype.updateRowSettings=function(){const t=this.getTable();if(!t||!t._oRowTemplate){return}t._oRowTemplate.unbindProperty("navigated");t._oRowTemplate.unbindProperty("highlight");t._oRowTemplate.unbindProperty("highlightText");t._oRowTemplate.applySettings(this.getRowSettingsConfig());this.updateRowActions()};g.prototype.updateRowActions=function(){const t=this.getTable();const e=this.getRowActionsConfig();const o=t.hasListeners("rowPress")?"Active":"Inactive";t._oRowTemplate.unbindProperty("type");if(!t.getRowSettings()){t._oRowTemplate.setType(o);return}if(o==="Inactive"){this._detachItemPress()}let n,i,s;if("templateInfo"in e){const t=e.templateInfo;s=t.visible.formatter;i=typeof t.visible=="object";n=t.visible}else if(e&&e.items){if(e.items.length==0){t._oRowTemplate.setType(o);return}const a=e.items.find(t=>t.getType()=="Navigation");if(!a&&e.items.length>0){throw new Error("No row action of type 'Navigation' found. ResponsiveTableType only accepts row actions of type 'Navigation'.")}t._oRowTemplate.data("rowAction",a);i=a.isBound("visible");n=i?Object.assign({},a.getBindingInfo("visible")):a.getVisible();s=n.formatter}if(i){n.formatter=t=>{const e=s?s(t):t;const n=e===true?u.Navigation:o;if(n===u.Navigation){this._attachItemPress()}return n};t._oRowTemplate.bindProperty("type",n)}else{n=n?u.Navigation:o;t._oRowTemplate.setProperty("type",n);if(n===u.Navigation){this._attachItemPress()}}};g.prototype.enableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}let n=o.findOn(e);e.setFixedLayout("Strict");if(!n){n=new o;e.addDependent(n);n.attachColumnResize(m,this)}else{n.setEnabled(true);n.detachColumnResize(m,this);n.attachColumnResize(m,this)}};g.prototype.disableColumnResize=function(){const t=this.getTable();const e=this.getInnerTable();if(!t||!e){return}const n=o.findOn(e);if(n){n.setEnabled(false);n.detachColumnResize(m,this)}};function m(t){const e=this.getTable();const o=this.getInnerTable();const n=t.getParameter("column");const i=t.getParameter("width");const s=o.indexOfColumn(n);const a=e.getColumns()[s];this.callHook("ColumnResize",e,{column:a,width:i})}g.prototype.createColumnResizeMenuItem=function(t,e){const n=o.findOn(this.getInnerTable());if(!n){return}if(e.isA("sap.m.table.columnmenu.Menu")){return n.getColumnResizeQuickAction(t.getInnerColumn(),e)}else{return n.getColumnResizeButton(t.getInnerColumn())}};g.prototype._attachItemPress=function(){const t=this.getInnerTable();if(t&&!t.hasListeners("itemPress")){t.attachEvent("itemPress",d,this);return true}return false};g.prototype._detachItemPress=function(){const t=this.getTable();const e=this.getInnerTable();if(!t.hasListeners("rowPress")&&e){e.detachEvent("itemPress",d,this);return true}return false};g.prototype.setShowDetailsButton=function(t){if(this.getShowDetailsButton()!==t){this.setProperty("showDetailsButton",t,true);this.getTable()?._updateAdaptation()}return this};g.prototype._setShowDetailsState=function(t,e){if(t===this.bShowDetails){return}this.bShowDetails=t;if(!e){this._persistShowDetails(t)}if(!this._oShowDetailsButton){return}const o=this.getInnerTable();if(this.bShowDetails){o.setHiddenInPopin();this._oShowDetailsButton.setSelectedKey("showDetails")}else{o.setHiddenInPopin(this._getImportanceToHide());this._oShowDetailsButton.setSelectedKey("hideDetails")}};g.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){const t=r.getResourceBundleFor("sap.ui.mdc");const e=this.getTable().getId();this.bShowDetails=false;this._oShowDetailsButton=new n(e+"-showHideDetails",{visible:false,selectedKey:"hideDetails",items:[new i({id:e+"-showDetails",icon:"sap-icon://detail-more",key:"showDetails",tooltip:t.getText("table.SHOWDETAILS_TEXT"),press:[function(){this._setShowDetailsState(true)},this]}),new i({id:e+"-hideDetails",icon:"sap-icon://detail-less",key:"hideDetails",tooltip:t.getText("table.HIDEDETAILS_TEXT"),press:[function(){this._setShowDetailsState(false)},this]})]})}return this._oShowDetailsButton};g.prototype._persistShowDetails=function(t){e.createShowDetailsChange(this.getTable(),{showDetails:t})};g.prototype._getImportanceToHide=function(){const t=this.getDetailsButtonSetting()||[];if(t.length>0){return t}else{return s.system.phone?["Low","Medium"]:["Low"]}};function w(t){const e=t.getParameter("hasPopin");const o=t.getParameter("hiddenInPopin");const n=t.getSource().getVisibleItems().length;if(n&&(o.length||e&&this.bShowDetails)){this._oShowDetailsButton.setVisible(true)}else{this._oShowDetailsButton.setVisible(false)}}function b(t){const e=this.getTable();const o=t.getParameter("listItem");if(o.getType()!=="Navigation"){return}const n=e.getRowSettings();const i=n.getAllActions();if(n.isBound("rowActions")){const t=i.items.model;if(!this._oRowActionItem){this._oRowActionItem=i.items.template.clone()}this._oRowActionItem.setModel(e.getModel(t),t);n.addDependent(this._oRowActionItem)}else{this._oRowActionItem=o.data("rowAction")}this._oRowActionItem.setType("Navigation");this.callHook("Press",this._oRowActionItem,{bindingContext:o.getBindingContext(this.getInnerTable().getBindingInfo("items").model)})}g.prototype.removeToolbar=function(){const t=this.getInnerTable();if(t){t.setHeaderToolbar()}};g.prototype.scrollToIndex=function(t){const e=this.getInnerTable();if(e){return e.scrollToIndex(t)}else{return Promise.reject()}};g.prototype.getRowBinding=function(){const t=this.getInnerTable();return t?t.getBinding("items"):undefined};g.prototype.bindRows=function(t){const e=this.getInnerTable();if(e){e.bindItems(t)}};g.prototype.isTableBound=function(){const t=this.getInnerTable();if(t){return t.isBound("items")}else{return false}};g.prototype.insertFilterInfoBar=function(t,e){const o=this.getInnerTable();if(o){o.setInfoToolbar(t);if(!o.getAriaLabelledBy().includes(e)){o.addAriaLabelledBy(e)}}};g.prototype.updateSortIndicator=function(t,e){t.getInnerColumn().setSortIndicator(e)};g.prototype._onColumnInsert=function(t){const o=this.getTable();const n=this.getInnerTable();if(e.isUserPersonalizationActive(o)&&n.getHiddenInPopin()?.includes(t.getInnerColumn().getImportance())&&o.getColumns().pop()===t){this._setShowDetailsState(true)}};g.prototype.onModifications=function(){const t=this.getTable();const e=t._getXConfig();const o=e?.aggregations?.type;this._setShowDetailsState(o?.ResponsiveTable?.showDetails??false,true)};g.prototype.showXConfigState=function(){return this._oShowDetailsButton?.getVisible()};g.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oShowDetailsButton?.destroy();delete this._oShowDetailsButton};return g});
//# sourceMappingURL=ResponsiveTableType.js.map