/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PropertyHelper","../util/PropertyHelper"],(e,t)=>{"use strict";const r=e.extend("sap.ui.mdc.table.V4AnalyticsPropertyHelper",{constructor:function(t,r){this._bEnableAggregatableAttribute=true;e.call(this,t,r,{technicallyGroupable:{type:"boolean",default:{value:"attribute:groupable"},inComplexProperty:{valueIfNotAllowed:false}},technicallyAggregatable:{type:"boolean",default:{value:"attribute:aggregatable"},inComplexProperty:{valueIfNotAllowed:false}},additionalProperties:{type:"PropertyReference[]"}})}});r.prototype.validateProperty=function(r,i,n){e.prototype.validateProperty.apply(this,arguments);if(r.groupable&&r.extension?.technicallyGroupable===false){t.throwInvalidPropertyError("A property cannot be groupable when not technically groupable.",r)}if(r.aggregatable&&r.extension?.technicallyAggregatable===false){t.throwInvalidPropertyError("A property cannot be aggregatable when not technically aggregatable.",r)}o(r);a(r,i)};function o(e){if(!e.isKey){return}const r=(e.groupable||e.extension?.technicallyGroupable)===true;const o=(e.aggregatable||e.extension?.technicallyAggregatable)===true;if(!r){t.reportInvalidProperty("A key property must be technically groupable.",e)}if(o){t.throwInvalidPropertyError("A key property must not be technically aggregatable.",e)}}function a(e,r){const o=e.extension?.additionalProperties??[];if(o.length===0){return}const a=(e.groupable||e.extension?.technicallyGroupable)===true;const i=(e.aggregatable||e.extension?.technicallyAggregatable)===true;if(!a&&!i){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is neither technically groupable nor"+" technically aggregatable.",e)}if(a&&i){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is both technically groupable and"+" technically aggregatable.",e)}if(e.groupable){t.throwInvalidPropertyError("'additionalProperties' must be empty if the property is groupable.",e)}if(o.includes(e.text)){t.throwInvalidPropertyError("'additionalProperties' must not contain the text.",e)}if(i&&o.includes(e.unit)){t.throwInvalidPropertyError("'additionalProperties' must not contain the unit.",e)}const n=e.key||e.name;let l=false;for(const a of r){const r=a.key||a.name;if(a.text===n){if(o.some(e=>e!==r)){t.throwInvalidPropertyError("This property is the text of another property, and therefore 'additionalProperties'"+" must not contain other properties than the related ID.",e)}l=true}if(a.unit===n){t.throwInvalidPropertyError("This property is the unit of another property, and therefore 'additionalProperties'"+" must be empty.",e)}if(o.includes(r)){if((a.extension?.additionalProperties||[]).includes(n)){t.throwInvalidPropertyError("An additional property must not reference this property in 'additionalProperties'.",e)}const r=(a.groupable||a.extension?.technicallyGroupable)===true;if(!r){t.throwInvalidPropertyError("An additional property must be technically groupable.",e)}const o=(a.aggregatable||a.extension?.technicallyAggregatable)===true;if(o){t.throwInvalidPropertyError("An additional property must not be technically aggregatable.",e)}}}if(l){return}const p=new Set(o);for(const e of p){const t=r.find(t=>(t.key||t.name)===e);for(const e of t.extension?.additionalProperties??[]){p.add(e)}}if(p.difference(new Set(o)).size>0){t.throwInvalidPropertyError("All nested additional properties must be listed at root level.",e)}}r.prototype.prepareProperty=function(t,r){e.prototype.prepareProperty.apply(this,arguments);Object.defineProperty(t,"getAggregatableProperties",{value:function(){return t.getSimpleProperties().filter(e=>e.aggregatable)}})};return r});
//# sourceMappingURL=V4AnalyticsPropertyHelper.js.map