/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/ushell/SemanticObjectMapping","sap/ui/mdc/ushell/SemanticObjectMappingItem","sap/ui/mdc/ushell/SemanticObjectUnavailableAction","sap/ui/mdc/enums/LinkType"],(e,t,n,i,a,c,r,s,o,u,l,m)=>{"use strict";const f=Object.assign({},n);f.fetchLinkItems=function(e,t,n){const i=e.getPayload();const a=t?t.getObject(t.getPath()):undefined;const r=[];if(n){n.initialize(f._getSemanticObjects(i));r.forEach(e=>{n.addIntent(c.IntentType.API,{text:e.getText(),intent:e.getHref()})})}const s=f._calculateSemanticAttributes(a,i,n);return f._retrieveNavigationTargets("",s,i,n).then((e,t)=>Promise.resolve(e))};f.fetchLinkType=function(e){const t=e.getPayload();if(t&&t.semanticObjects){return f.hasDistinctSemanticObjects(t.semanticObjects).then(e=>Promise.resolve({type:e?m.Popover:m.Text,directLink:undefined}))}else{throw new Error("no payload or semanticObjects found")}};f.hasDistinctSemanticObjects=e=>{const t={};let n=null;const i=function(e){return e.filter(e=>!t[e]).length===0};const c=function(e){return e.some(e=>t[e]&&t[e].exists===true)};const s=async()=>{const e=await a.getServiceAsync("Navigation");if(!e){r.error("LinkDelegate: Service 'Navigation' could not be obtained");return Promise.resolve({})}try{const n=await e.getSemanticObjects();n.forEach(e=>{t[e]={exists:true}});return Promise.resolve(t)}catch(e){r.error("LinkDelegate: getSemanticObjects() of service 'Navigation' failed");return Promise.resolve({})}};if(i(e)){return Promise.resolve(c(e))}if(!n){n=s()}return n.then(()=>c(e))};f._calculateSemanticAttributes=function(e,t,n){const i=f._getSemanticObjects(t);const a=f._convertSemanticObjectMapping(f._getSemanticObjectMappings(t));if(!i.length){i.push("")}const c={};i.forEach(t=>{if(n){n.addContextObject(t,e)}c[t]={};for(const i in e){let o=null,u=null;if(n){o=n.getSemanticObjectAttribute(t,i);if(!o){o=n.createAttributeStructure();n.addSemanticObjectAttribute(t,i,o)}}if(e[i]===undefined||e[i]===null){if(o){o.transformations.push({value:undefined,description:"ℹ Undefined and null values have been removed in LinkDelegate."})}continue}if(s(e[i])){if(o){o.transformations.push({value:undefined,description:"ℹ Plain objects has been removed in LinkDelegate."})}continue}const l=a&&a[t]&&a[t][i]?a[t][i]:i;if(o&&i!==l){u={value:undefined,description:"ℹ The attribute "+i+" has been renamed to "+l+" in LinkDelegate.",reason:"🔴 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+t+" with source attribute "+i+" and target attribute "+l+". You can modify the annotation if the mapping result is not what you expected."}}if(c[t][l]){r.error("LinkDelegate: The attribute "+i+" can not be renamed to the attribute "+l+" due to a clash situation. This can lead to wrong navigation later on.")}c[t][l]=e[i];if(o){if(u){o.transformations.push(u);const a=n.createAttributeStructure();a.transformations.push({value:e[i],description:"ℹ The attribute "+l+" with the value "+e[i]+" has been added due to a mapping rule regarding the attribute "+i+" in LinkDelegate."});n.addSemanticObjectAttribute(t,l,a)}}}});return c};f._retrieveNavigationTargets=function(n,c,s,o){if(!s.semanticObjects){return new Promise.resolve([])}const u=s.semanticObjects;const l=s.sourceControl;const m={ownNavigation:undefined,availableActions:[]};return t.load({name:"sap.ui.fl"}).then(()=>{const t=sap.ui.require("sap/ui/fl/Utils");if(!t){return Promise.reject("Could not load 'sap/ui/fl/Utils'!")}const b=a.getServiceAsync("Navigation");const g=a.getServiceAsync("URLParsing");return Promise.all([b,g]).then(a=>{const b=a[0];const g=a[1];if(!b||!g){r.error("LinkDelegate: Service 'Navigation' or 'URLParsing' could not be obtained");return Promise.resolve(m.availableActions,m.ownNavigation)}const d=e.getElementById(l);const p=t.getAppComponentForControl(d);const h=u.map(e=>({semanticObject:e,params:c?c[e]:undefined,appStateKey:n,ui5Component:p,sortResultsBy:"text"}));return b.getLinks(h).then(e=>{if(!e||!e.length){return Promise.resolve(m.availableActions,m.ownNavigation)}const t=f._getSemanticObjectUnavailableActions(s);const n=f._convertSemanticObjectUnavailableAction(t);return b.getHref().then(t=>{if(t&&t.indexOf("?")!==-1){t=t.split("?")[0]}if(t){t+="?"}const a=function(e,t){return!!n&&!!n[e]&&n[e].indexOf(t)>-1};const c=function(e){const n=g.parseShellHash(e.intent);if(a(n.semanticObject,n.action)){return Promise.resolve()}return b.getHref({target:{shellHash:e.intent}},p).then(a=>{if(e.intent&&e.intent.indexOf(t)===0){m.ownNavigation=new i({href:a,text:e.text,internalHref:e.intent});return}const c=new i({key:n.semanticObject&&n.action?n.semanticObject+"-"+n.action:undefined,text:e.text,description:undefined,href:a,internalHref:e.intent,icon:undefined,initiallyVisible:e.tags&&e.tags.indexOf("superiorAction")>-1});m.availableActions.push(c);if(o){o.addSemanticObjectIntent(n.semanticObject,{intent:c.getHref(),text:c.getText()})}})};const r=[];for(let t=0;t<u.length;t++){r.push(e[t].map(c))}return Promise.all(r).then(()=>Promise.resolve(m.availableActions,m.ownNavigation))})})})})};f._getSemanticObjects=function(e){return e.semanticObjects?e.semanticObjects:[]};f._getSemanticObjectUnavailableActions=function(e){const t=[];if(e.semanticObjectUnavailableActions){e.semanticObjectUnavailableActions.forEach(e=>{t.push(new l({semanticObject:e.semanticObject,actions:e.actions}))})}return t};f._getSemanticObjectMappings=function(e){const t=[];let n=[];if(e.semanticObjectMappings){e.semanticObjectMappings.forEach(e=>{n=[];if(e.items){e.items.forEach(e=>{n.push(new u({key:e.key,value:e.value}))})}t.push(new o({semanticObject:e.semanticObject,items:n}))})}return t};f._convertSemanticObjectMapping=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getItems().reduce((e,t)=>{e[t.getKey()]=t.getValue();return e},{})});return t};f._convertSemanticObjectUnavailableAction=function(e){if(!e.length){return undefined}const t={};e.forEach(e=>{if(!e.getSemanticObject()){throw Error("LinkDelegate: 'semanticObject' property with value '"+e.getSemanticObject()+"' is not valid")}t[e.getSemanticObject()]=e.getActions()});return t};return f});
//# sourceMappingURL=LinkDelegate.js.map