/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/base/DataType","sap/base/util/merge","sap/base/util/isPlainObject","sap/base/Log","sap/ui/core/Lib","sap/base/util/deepEqual","sap/ui/mdc/util/PropertyHelperUtil","sap/base/future"],(e,t,r,o,n,i,a,p,s)=>{"use strict";const l={key:{type:"string",mandatory:true,inComplexProperty:{allowed:true}},label:{type:"string",mandatory:true,inComplexProperty:{allowed:true}},tooltip:{type:"string",inComplexProperty:{allowed:true}},visible:{type:"boolean",default:{value:true},inComplexProperty:{allowed:true}},path:{type:"string"},dataType:{type:"string",mandatory:true},formatOptions:{type:"object"},constraints:{type:"object"},maxConditions:{type:"int",default:{value:-1}},caseSensitive:{type:"boolean",default:{value:true}},group:{type:"string",inComplexProperty:{allowed:true}},groupLabel:{type:"string",inComplexProperty:{allowed:true}},filterable:{type:"boolean",default:{value:true},inComplexProperty:{valueIfNotAllowed:false}},sortable:{type:"boolean",default:{value:true},inComplexProperty:{valueIfNotAllowed:false}},propertyInfos:{type:"PropertyReference[]",inComplexProperty:{allowed:true}}};const u={key:"name"};const f={isComplex:function(e){return T.isPropertyComplex(this)},getSimpleProperties:function(e){if(!y.get(e)){return[]}if(this.isComplex()){return this.propertyInfos.map(t=>e.getProperty(t))}else{return[this]}},getSortableProperties:function(e){return this.getSimpleProperties().filter(e=>e.sortable)},getFilterableProperties:function(e){return this.getSimpleProperties().filter(e=>e.filterable)}};const c=["key","label","tooltip","visible","path","dataType","formatOptions","constraints","maxConditions","group","groupLabel","caseSensitive"];const y=new WeakMap;function d(e,t){let r="";if(!t){r=`Invalid property definition: ${e}`}else if(Array.isArray(t)){const o=t.map(e=>`'${Object.keys(e)[0]}'`).join(",");r=`Invalid property definition for properties with keys ${o}: ${e}`}else{const o=t.key??t.name;r=`Invalid property definition for property with key '${o}': ${e}`}return r}function P(e,t){const r=d(e,t);if(p.bValidationException){s.errorThrows(r,{suffix:`Migrate this control's propertyInfo to avoid breaking changes in the future.`})}else{b(e,t)}}function b(e,t){const r=d(e,t);throw new Error(r)}function m(e,t){t.map(t=>{Object.keys(f).forEach(r=>{Object.defineProperty(t,r,{value:function(){return f[r].call(this,e)},writable:true})})})}function g(e){const t=Object.getOwnPropertyNames(e);Object.freeze(e);for(let r=0;r<t.length;r++){const n=e[t[r]];if(typeof n==="function"){Object.freeze(n)}else if(o(n)&&!Object.isFrozen(n)){g(n)}else if(Array.isArray(n)){g(n)}}}function h(e,t){if(!t){return e}return t.split(".").reduce((e,t)=>e&&e[t]?e[t]:null,e)}function v(e){let r;if(typeof e==="object"){r="object"}else{r=e.replace("PropertyReference","string")}return t.getType(r)}function x(e){const t=v(e);if(t.isArrayType()){return t.getBaseType().getDefaultValue()}else{return t.getDefaultValue()}}function w(e,t,r){t.forEach(t=>{e.prepareProperty(t,r)});g(t)}function C(e,t,r,o,n,i){const a=o==null;let p=[];const s=T.isPropertyComplex(t);if(a){i=y.get(e).mAttributeMetadata;n=t}if(!n){return[]}for(const l in i){const u=i[l];const f=a?l:o+"."+l;const c=n[l];if(s&&!u.inComplexProperty.allowed){if("valueIfNotAllowed"in u.inComplexProperty){n[l]=u.inComplexProperty.valueIfNotAllowed}continue}if(c!=null&&typeof u.type==="string"&&u.type.startsWith("PropertyReference")||f==="propertyInfos"){continue}if(c==null){j(n,u,o,l,p,c)}if(typeof u.type==="object"){p=p.concat(C(e,t,r,f,n[l],u.type))}}return p}function j(e,t,o,n,i,a){const p=t.default;if(p.ignoreIfNull&&a===null){return}if(typeof p.value==="string"&&p.value.startsWith("attribute:")){i.push({source:p.value.substring(p.value.indexOf(":")+1),targetPath:o,targetAttribute:n,targetType:t.type})}else if(Array.isArray(p.value)){e[n]=r([],p.value)}else if(typeof p.value==="object"&&p.value!==null){e[n]=r({},p.value)}else{e[n]=p.value}}function A(e){return Object.freeze(e.reduce((e,t)=>{e[t.key]=t;return e},{}))}function O(e,t){for(const r in e){const o=e[r];const n=!t;o.mandatory=o.mandatory===true&&n;o.default={...o.default};o.default.value=o.default.value??x(o.type);o.inComplexProperty={...o.inComplexProperty};if(o.inComplexProperty.allowed===true){o.inComplexProperty.allowed=n||t.inComplexProperty.allowed===true}else if(!("allowed"in o.inComplexProperty)){const e=t?.inComplexProperty.allowed===true&&t?.inComplexProperty.propagateAllowance!==false;o.inComplexProperty.allowed=e}if(typeof o.type==="object"){O(o.type,o)}delete o.inComplexProperty.propagateAllowance}}function I(e,t){if(!Array.isArray(t)){b("Property infos must be an array.")}const o=y.get(e);const n=r([],t);e.validateProperties(n,o.aPreviousRawProperties);const i=M(n);const a=A(i);m(e,i);w(e,i,a);e._validatePropertyConsistency(i,o.aProperties);o.aProperties=i;o.mProperties=a;o.aPreviousRawProperties=r([],t)}function M(e){const t=Object.entries(u);return e.map(e=>{const r={...e};t.forEach(([t,o])=>{if(t in e&&o in e&&e[t]!==e[o]){b(`The values of legacy-attribute '${o}' and it's replacement '${t}' must be identical.`,e)}if(!(t in e)&&o in e){r[t]=e[o]}if(!(o in e)&&t in e){r[o]=e[t]}});return r})}function k(e){return e.key||u["key"]&&e[u["key"]]}const T=e.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(t,r,o){e.call(this);if(r&&!e.isObjectA(r,"sap.ui.base.ManagedObject")){throw new Error("The type of the parent is invalid.")}Object.keys(o||{}).forEach(e=>{if(e in l&&o[e]!==true){throw new Error("The attribute '"+e+"' is reserved and cannot be overridden by additional attributes.")}});const n={};const i=Object.keys(o||{});n.mAttributeMetadata=c.concat(i).reduce((e,t)=>{e[t]=t in l?l[t]:o[t];return e},{});O(n.mAttributeMetadata);n.aMandatoryAttributes=Object.keys(n.mAttributeMetadata).filter(e=>n.mAttributeMetadata[e].mandatory);n.oParent=r||null;y.set(this,n);this.setProperties(t)}});T.prototype.validateProperties=function(e,t){const r=new Set;for(let o=0;o<e.length;o++){this.validateProperty(e[o],e,t);r.add(k(e[o]))}if(r.size!==e.length){b("Properties do not have unique keys.")}};T.prototype._validatePropertyConsistency=function(e,t){if(t?.length){const r=y.get(this);const{mAttributeMetadata:o}=r;const n=[];for(const r of t){const t=k(r);const i=e.find(e=>k(e)===t);if(!i){n.push({[t]:"PROPERTY_MISSING"})}else{const e=Object.entries(o).reduce((e,[t,o])=>{if(!a(r[t],i[t])){return[...e,{[t]:[r[t],i[t]]}]}return e},[]);if(e.length){n.push({[t]:e})}}}if(n.length){P(`Detected property info modifications after update:`,n)}}};T.prototype.validateProperty=function(e,t,r){if(!o(e)){b("Property info must be a plain object.")}E(this,e,t);if(T.isPropertyComplex(e)){if(!e.propertyInfos||e.propertyInfos.length===0){b("Complex property does not reference existing properties.",e)}}const n=y.get(this);n.aMandatoryAttributes.forEach(t=>{const r=n.mAttributeMetadata[t];const o=r.inComplexProperty.allowed;const i=u[t];const a=i&&i in e;const p=a?e[i]==null:e[t]==null;if(p&&T.isPropertyComplex(e)&&!o){return}if(!(t in e||a)){P("Property does not contain mandatory attribute '"+t+"'.",e)}else if(p){b("Property does not contain mandatory attribute '"+t+"'.",e)}})};function E(e,t,r,o,n,i){const a=o==null;if(a){i=y.get(e).mAttributeMetadata;n=t}for(const p in n){let s=i[p];const l=a?p:o+"."+p;const f=n[p];if(!s){s=i[Object.entries(u).find(e=>e[1]===p)?.[0]]}if(!s){P("Property contains invalid attribute '"+l+"'.",t)}else if(T.isPropertyComplex(t)&&!s.inComplexProperty.allowed){P("Complex property contains invalid attribute '"+l+"'.",t)}else if(typeof s.type==="object"&&f&&typeof f==="object"){E(e,t,r,l,f,s.type)}else if(f!=null&&!v(s.type).isValid(f)){b("The value of '"+l+"' is invalid.",t)}else if(f&&typeof s.type==="string"&&s.type.startsWith("PropertyReference")){S(e,t,r,l,f,s)}}}function S(e,t,r,o,n,i){const a=i.type.endsWith("[]")?n:[n];const p=new Set(a);if(a.indexOf(k(t))>-1){b("Property references itself in the '"+o+"' attribute.",t)}if(p.size!==a.length){b("Property contains duplicate names in the '"+o+"' attribute.",t)}for(let e=0;e<r.length;e++){if(p.has(k(r[e]))){if(T.isPropertyComplex(r[e])){b("Property references complex properties in the '"+o+"' attribute.",t)}p.delete(k(r[e]))}}if(p.size>0){b("Property references non-existing properties in the '"+o+"' attribute.",t)}}T.prototype.prepareProperty=function(e,t){const r=C(this,e,t);r.forEach(t=>{const r=h(e,t.targetPath);if(r){let o=h(e,t.source);if(o==null){o=x(t.targetType)}r[t.targetAttribute]=o}})};T.prototype.getParent=function(){const e=y.get(this);return e?e.oParent:null};T.prototype.setProperties=function(e){I(this,e)};T.prototype.getProperties=function(){const e=y.get(this);return e?e.aProperties:[]};T.prototype.getPropertyMap=function(){const e=y.get(this);return e?e.mProperties:{}};T.prototype.getProperty=function(e){return this.getPropertyMap()[e]||null};T.prototype.hasProperty=function(e){return e in this.getPropertyMap()};T.isPropertyComplex=function(e){return e!=null&&typeof e==="object"?"propertyInfos"in e:false};T.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);y.delete(this)};T.prototype._getAttributeMetadata=function(){const e=y.get(this);return e?r({},e.mAttributeMetadata):null};T.prototype.getRedundantProperties=function(){return[]};Object.defineProperties(T,{reportInvalidProperty:{value:P},throwInvalidPropertyError:{value:b}});return T});
//# sourceMappingURL=PropertyHelper.js.map