/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/enums/BaseType","sap/ui/model/SimpleType","sap/base/util/ObjectPath","sap/ui/mdc/util/DateUtil","sap/ui/mdc/util/loadModules","sap/base/util/merge","sap/base/future"],(e,t,a,n,s,i,r)=>{"use strict";const o="yyyy-MM-dd";const u="HH:mm:ss";const p=new WeakMap;const c={};c._get=function(e){const t=this._getMap().get(e);if(typeof t==="string"){return this._get(t)}else if(t){return[e,t]}};c._set=function(e,t){const a=this._getMap();if(a._bFrozen){throw"TypeMap: You must not modify a frozen TypeMap"}a.set(e,t)};c._getMap=function(){let e=p.get(this);if(!e){e=new Map;p.set(this,e)}return e};c.set=function(e,t,a){this._set(e,[t,a])};c.setAlias=function(e,t){this._set(e,t)};c._getBaseType=function(e){const t=this._get(e);return t&&t[1][0]};c._getOptions=function(e){const t=this._get(e);return t&&t[1][1]};c._getClass=function(e){const t=this._get(e);return t&&t[0]};c.export=function(){return Array.from(this._getMap())};c.import=function(e){e.export().forEach(e=>{this._getMap().set(e[0],e[1])})};c.freeze=function(){this._getMap()._bFrozen=true};c.getBaseType=function(t,a,n){const s=this._getBaseType(t);return s&&(typeof s==="function"?s(a,n):s)||e.String};c.getBaseTypeForType=function(e){return this.getBaseType(e.getMetadata&&e.getMetadata().getName(),e.getFormatOptions(),e.getConstraints())};c.getDataTypeClassName=function(e){return this._getClass(e)||e};c.getDataTypeClass=function(e){const t=this.getDataTypeClassName(e);let n;if(t){n=sap.ui.require(t.replace(/\./g,"/"));if(!n){n=a.get(t);if(n){r.errorThrows("DataType '"+e+"' module not loaded.",{suffix:"Load data type module before it is used, e.g. using TypeMap.retrieveDataTypeClasses."})}}}if(!n){throw new Error("DataType '"+e+"' cannot be determined")}return n};c.retrieveDataTypeClasses=function(e){const t=[];e.forEach(e=>{const a=this.getDataTypeClassName(e);t.push(a.replace(/\./g,"/"))});return new Promise((e,a)=>{s(t).then(t=>{e(t)}).catch(e=>{a(e)})})};c.getDataTypeInstance=function(e,t,a,n){const s=this.getDataTypeClass(e);const r=this._getOptions(s.getMetadata().getName());const o=r&&r(i({},t),i({},a),n);t=o&&o[0]||t;a=o&&o[1]||a;return new s(t,a)};c.getTypeConfig=function(e,t,a){const n=this._normalizeType.call(this,e,t,a);return{className:n.getMetadata().getName(),typeInstance:n,baseType:this.getBaseTypeForType(n)}};c.externalizeValue=function(t,a,s,i){const r=this._normalizeType.call(this,a,s,i);const p=this.getBaseTypeForType(r);switch(p){case e.DateTime:return n.typeToISO(t,r,p);case e.Date:return n.typeToString(t,r,o);case e.Time:return n.typeToString(t,r,u);case e.Boolean:return t;case e.Numeric:if(typeof t!=="string"&&(r.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||r.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return t.toString()}return t;default:return r.formatValue(t,"string")}};c.internalizeValue=function(t,a,s,i){const r=this._normalizeType.call(this,a,s,i);const p=this.getBaseTypeForType(r);switch(p){case e.DateTime:return n.ISOToType(t,r,p);case e.Date:if(t.indexOf("T")>=0){t=t.substr(0,t.indexOf("T"))}return n.stringToType(t,r,o);case e.Time:return n.stringToType(t,r,u);case e.Boolean:return t;case e.Numeric:if(typeof t!=="string"&&(r.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||r.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return t.toString()}return t;default:return r.parseValue(t,"string")}};c._normalizeType=function(e,a,n){if(e instanceof t){return e}return this.getDataTypeInstance(e,a,n)};c.initializeTypeFromValue=function(e,t){return{}};c.initializeInternalType=function(e,t){};return c});
//# sourceMappingURL=TypeMap.js.map