/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/valuehelp/base/DialogTab","sap/ui/mdc/util/loadModules","sap/ui/Device","sap/m/VBox","sap/m/FlexItemData","sap/ui/model/resource/ResourceModel","sap/ui/mdc/util/Common","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/strings/formatMessage","sap/base/i18n/Localization","sap/ui/core/library","sap/ui/core/InvisibleMessage","sap/ui/mdc/util/DensityHelper"],(e,t,n,o,i,s,l,a,r,c,u,p,d,h,g)=>{"use strict";let f=e.getResourceBundleFor("sap.ui.mdc");p.attachChange(()=>{f=e.getResourceBundleFor("sap.ui.mdc")});let y,C,m,_,b,T;let I,S,v,M,k;const{InvisibleMessageMode:P}=d;const B=t.extend("sap.ui.mdc.valuehelp.Dialog",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.IDialogContainer","sap.ui.core.PopupInterface"],properties:{_selectedContentKey:{type:"string",visibility:"hidden"},_quickSelectEnabled:{type:"boolean",visibility:"hidden",defaultValue:false},_selectableContents:{type:"object[]",visibility:"hidden",defaultValue:[]},groupConfig:{type:"object",defaultValue:{}}},defaultAggregation:"content"}});function x(){if(i.system.desktop){return"700px"}if(i.system.tablet){return i.orientation.landscape?"600px":"600px"}}function E(){if(i.system.desktop){return"1080px"}if(i.system.tablet){return i.orientation.landscape?"920px":"600px"}}function O(e){const t=this.getContent();return t.filter(t=>!!t.getVisible()&&t.getGroup&&t.getGroup()===e).length>1}B.prototype._handleContentSelectionChange=function(e,t){this.fireRequestDelegateContent({container:this.getId(),contentId:e});return this.getRetrieveDelegateContentPromise().then(()=>{const n=this.getProperty("_selectedContentKey");const o=this.getContent();const i=n&&o&&o.find(e=>e.getId()===n);if(i){if(i.setCollectiveSearchSelect){i.setCollectiveSearchSelect(undefined)}i.onHide();this.unbindContentFromContainer(i)}return this._renderSelectedContent(e,undefined,t)})};B.prototype._onTabBarSelect=function(e){const t=e&&e.getParameter("key");this._handleContentSelectionChange(t)};B.prototype.invalidate=function(e){if(e){const n=this.getContent();const o=n.indexOf(e);if(this._oIconTabBar&&o!==-1&&!this.isDestroyStarted()){const t=this._oIconTabBar.getItems();if(t[o]){t[o].invalidate(e)}}else{t.prototype.invalidate.apply(this,arguments)}}};B.prototype.getUIAreaForContent=function(){const e=this.getAggregation("_container");if(e){return e.getUIArea()}return t.prototype.getUIAreaForContent.apply(this,arguments)};B.prototype.handleConfirmed=function(e){this.fireConfirm({close:true})};B.prototype.handleClosed=function(e){const n=this.getSelectedContent();if(n){n.onHide()}this.getContent().forEach(e=>{e.onContainerClose()});this.setProperty("_selectedContentKey",this._sInitialContentKey);t.prototype.handleClosed.apply(this,arguments)};B.prototype.getContainerControl=function(){if(!this.getModel("$i18n")){this.setModel(new a({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}const t=this.getAggregation("_container");if(!t){return this._retrievePromise("dialog",()=>o(["sap/m/Dialog","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/m/library"]).then(t=>{y=t[0];m=t[1];_=t[2];C=t[3];if(this.isDestroyStarted()){return null}const{ButtonType:n}=C;if(!this._oResourceBundle){this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")}this.oButtonOK=new m(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:n.Emphasized,press:this.handleConfirmed.bind(this),visible:{parts:["$valueHelp>/_config/maxConditions","$help>/_quickSelectEnabled"],formatter:function(e,t){return e!==1||!t}}});this.oButtonCancel=new m(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.handleCanceled.bind(this)});this._oManagedObjectModel=new _(this);const o=new y(this.getId()+"-dialog",{contentHeight:x(),contentWidth:E(),horizontalScrolling:false,verticalScrolling:false,title:{parts:["$help>/title","$help>/_selectableContents"],formatter:function(e,t){if(t&&t.length==1){const n=t[0];const o=n.getFormattedShortTitle()?n.getFormattedShortTitle():n.getTitle();if(o){e=this._oResourceBundle.getText("valuehelp.DIALOGSHORTTITLECOLONTITLE",[o,e])}}return e}.bind(this)},stretch:i.system.phone,resizable:true,draggable:true,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this),buttons:[this.oButtonOK,this.oButtonCancel]});g.syncDensity(o);o.setModel(this._oManagedObjectModel,"$help");this.setAggregation("_container",o,true);o.isPopupAdaptationAllowed=function(){return false};o.addStyleClass("sapMdcValueHelp");o.addStyleClass("sapMdcValueHelpTitle");const l=new s(this.getId()+"-Content",{fitContainer:true});l.addStyleClass("sapMdcValueHelpPanel");o.addContent(l);return o}))}return t};B.prototype.placeContent=function(e){const t=e.getContent()[0];const o=this.getProperty("_selectableContents");if(!o.length){return Promise.resolve(e)}const i=o.length>1;const s=[];if(i){s.push(this._getIconTabBar(e))}else{if(!this._oStandaloneTab){this._oStandaloneTab=new n(this.getId()+"-Standalone-DT",{content:{path:"/_selectableContents/0/displayContent",model:"$help"},layoutData:new l({growFactor:1,minHeight:"0"})})}s.push(this._oStandaloneTab)}if(A(this.getMaxConditions(),this.getContent())){s.push(this._getTokenizerPanel())}return Promise.all(s).then(n=>{t.removeAllItems();n.forEach(e=>{t.addItem(e)});if(i){e.addStyleClass("sapMdcValueHelpTitleShadow")}else{e.removeStyleClass("sapMdcValueHelpTitleShadow")}return e})};B.prototype.handleSelect=function(e){t.prototype.handleSelect.apply(this,arguments);if(this.getProperty("_quickSelectEnabled")&&this.isSingleSelect()){const t=e.getParameter("conditions");const n=[c.Set,c.Add].indexOf(e.getParameter("type"))!==-1;const o=t&&t.length;if(n&&o){this.fireConfirm({close:true})}}};B.prototype.observeChanges=function(e){if(e.name==="content"){const t=this.getContent();this.setProperty("_quickSelectEnabled",t&&t.every(e=>e.isQuickSelectSupported()));this._updateInitialContentKey();if(e.mutation==="insert"&&!this.getProperty("_selectedContentKey")){this.setProperty("_selectedContentKey",this._sInitialContentKey)}this.setProperty("_selectableContents",this._getSelectableContents());if(A(this.getMaxConditions(),this.getContent())){const e=this.getAggregation("_container");if(e&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(t=>{t.forEach(t=>{e.getContent()[0].addItem(t)})})}}}t.prototype.observeChanges.apply(this,arguments)};B.prototype._updateInitialContentKey=function(){const e=this.getContent().find(e=>!!e.getVisible());this._sInitialContentKey=e&&e.getId()};B.prototype.getSelectedContent=function(){const e=this.getProperty("_selectedContentKey");return this.getContent().find(t=>t.getId()===e)};B.prototype._getSelectableContents=function(){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=e?t:"";const o=[n];return this.getContent().filter(t=>{if(!t.getVisible()){return false}const n=t.getGroup&&t.getGroup();const i=n&&O.call(this,n);if(i&&t!==e){if(o.indexOf(n)>=0){return false}else{o.push(n)}}return true})};B.prototype._updateGroupSelectModel=function(){if(this._oGroupSelectModel){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=t?this.getContent().filter(e=>!!e.getVisible()&&e.getGroup&&e.getGroup()===t):[];this._oGroupSelectModel.setData(n.reduce((e,t)=>{e.entries.push({key:t.getId(),text:t.getFormattedTitle()});return e},{entries:[]}));if(this._oGroupSelect){const e=this._oGroupSelect.getSelectedItemKey();const t=n.map(e=>e.getId());const o=this.getProperty("_selectedContentKey");if(t.indexOf(e)==-1||e!==o){this._oGroupSelect.setSelectedItemKey(n[0].getId())}}}};B.prototype._retrieveGroupSelect=function(){return this._retrievePromise("collectiveSearchSelect",()=>o(["sap/ui/mdc/valuehelp/CollectiveSearchSelect","sap/m/VariantItem","sap/ui/model/json/JSONModel"]).then(e=>{const t=e[0];const n=e[1];const o=e[2];if(this.isDestroyStarted()){return null}if(!this._oGroupSelectModel){this._oGroupSelectModel=new o}if(!this._oGroupSelect){const e=new n(this.getId()+"-collSearchItem",{key:"{$select>key}",text:"{$select>text}"});this._oGroupSelect=new t(this.getId()+"--Select",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$select>/entries",template:e},select:function(e){this._handleContentSelectionChange(e.getParameter("key"),true)}.bind(this),selectedItemKey:this.getSelectedContent().getId(),maxWidth:i.system.phone?"5em":"25rem"});this._oGroupSelect.setModel(this._oGroupSelectModel,"$select")}return this._oGroupSelect}))};B.prototype._getIconTabBar=function(){if(!this._oIconTabBar){return this._retrievePromise("IconTabBar",()=>o(["sap/m/IconTabBar","sap/m/IconTabFilter"]).then(e=>{b=e[0];T=e[1];const{IconTabHeaderMode:t}=C;if(this.isDestroyStarted()){return null}this._oIconTabBar=new b(this.getId()+"-ITB",{expandable:false,upperCase:false,stretchContentHeight:true,headerMode:t.Inline,select:this._onTabBarSelect.bind(this),layoutData:new l({growFactor:1}),selectedKey:"{path: '$help>/_selectedContentKey', mode: 'OneWay'}"});this._oIconTabBar.addStyleClass("sapUiNoContentPadding");const o=new T(this.getId()+"-ITF",{key:{path:"$help>id"},content:new n(this.getId()+"-DT",{content:{path:"$help>displayContent"}}),text:{parts:["$help>","$valueHelp>/conditions"],formatter:function(e,t){let n="none";if(e){const o=e.getGroup&&e.getGroup();const i=e.getCount(t,o);n=o?this._getFormattedContentGroupLabel(o,i):e.getFormattedTitle(i)}return n}.bind(this)}});this._oIconTabBar.bindAggregation("items",{path:"/_selectableContents",model:"$help",templateShareable:false,template:o});return this._oIconTabBar}))}return this._oIconTabBar};B.prototype._getFormattedContentGroupLabel=function(e,t){const n=this.getGroupConfig();const o=n&&n[e];let i=o&&(t?o.label:o.nnLabel);i=i&&u(i,t?t:"");i=i||this._oResourceBundle.getText(t?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[t]);return i};B.prototype._getTokenizerPanel=function(e){if(!this.oTokenizerPanel){return this._retrievePromise("TokenizerPanel",()=>o(["sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/mdc/field/FieldMultiInput","sap/m/Token","sap/ui/model/Filter","sap/ui/mdc/field/ConditionType"]).then(e=>{I=e[0];S=e[1];s=e[2];v=e[3];M=e[4];k=e[5];const t=e[6];const{BackgroundDesign:n}=C;const{ButtonType:o}=C;if(this.isDestroyStarted()){return null}this.oTokenizerPanel=new I(this.getId()+"-TokenPanel",{backgroundDesign:n.Transparent,expanded:true,visible:{parts:["$valueHelp>/_config/maxConditions","$help>/content"],formatter:A},headerText:{parts:["$valueHelp>/conditions","$help>/_selectableContents"],formatter:function(e,t){let n=0;for(const t of e){if(t.isEmpty!==true){n++}}let o;if(t&&t.length==1){o=t[0].getFormattedTokenizerTitle(n);return o}else{o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLE");if(n===0){o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER")}return u(o,n)}}.bind(this)}});this.oTokenizerPanel.addStyleClass("sapMdcTokenizerPanel");const i=new S(this.getId()+"-TokenBox",{fitContainer:true,width:"100%"});const a=w.call(this);this._oConditionType=new t(a);this._oConditionType._bVHTokenizer=true;this.oTokenMultiInput=new v(this.getId()+"-Tokenizer",{width:"100%",showValueHelp:false,editable:true,showSuggestion:false,ariaAttributes:{role:"listbox",aria:{readonly:true,roledescription:this._oResourceBundle.getText("valuehelp.TOKENIZER_ARIA_ROLE_DESCRIPTION")}},tokenUpdate:function(e){if(e.getParameter("removedTokens")){const t=e.getParameter("removedTokens");const n=this.getModel("$valueHelp").getObject("/conditions");const o=[];t.forEach((e,t)=>{const{sPath:i}=e.getBindingContext("$valueHelp");const s=parseInt(i.slice(i.lastIndexOf("/")+1));o.push(n[s])});this.fireSelect({type:c.Remove,conditions:o})}}.bind(this),layoutData:new l({growFactor:1,maxWidth:"calc(100% - 2rem)"})});this.oTokenMultiInput._setValueVisible=function(e){this.$("inner").css("opacity","0")};const r=this.oTokenMultiInput.onAfterRendering;this.oTokenMultiInput.onAfterRendering=function(){r.apply(this.oTokenMultiInput,arguments);this.oTokenMultiInput._setValueVisible();this.oTokenMultiInput.setValue("");if(!this.bAddAriaLabelledOnlyOnce){this.bAddAriaLabelledOnlyOnce=true;this.oTokenMultiInput.addAriaLabelledBy(this.oTokenizerPanel._getLabellingElementId())}}.bind(this);R.call(this,true);this.oRemoveAllBtn=new m(this.getId()+"-TokenRemoveAll",{press:function(e){this.fireSelect({type:c.Set,conditions:[]});this.oInvisibleMessage.announce(f.getText("valuehelp.REMOVEALLTOKEN_ANNOUNCE"),P.Assertive);this.oTokenMultiInput.focus()}.bind(this),type:o.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.REMOVEALLTOKEN}",layoutData:new l({growFactor:0,baseSize:"2rem"}),enabled:{path:"$valueHelp>/conditions",formatter:function(e){let t=0;for(const n of e){if(n.isEmpty!==true){t++}}return t>0}}});this.oRemoveAllBtn.addStyleClass("sapUiTinyMarginBegin");i.addItem(this.oTokenMultiInput);i.addItem(this.oRemoveAllBtn);this.oTokenizerPanel.addContent(i);return this.oTokenizerPanel}))}else{const e=w.call(this);this._oConditionType.setFormatOptions(e)}return this.oTokenizerPanel};function A(e,t){let n=e!==1;if(n&&t&&t.every(e=>!e.getRequiresTokenizer())){n=false}return n}function w(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const n=this.getParent();const o=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,valueHelpID:n&&n.getId(),control:o,delegate:o&&o.getControlDelegate&&o.getControlDelegate(),delegateName:o&&o.getDelegate&&o.getDelegate()&&o.getDelegate().name,payload:o&&o.getPayload&&o.getPayload(),convertWhitespaces:true}}function R(e){if(this.oTokenMultiInput){const t=this.oTokenMultiInput.getBindingInfo("tokens");if(e){if(!t){const e=new k({path:"isEmpty",operator:"NE",value1:true});this._oConditionType.setFormatOptions(w.call(this));const t=new M(this.getId()+"-Token",{text:{path:"$valueHelp>",type:this._oConditionType}});this.oTokenMultiInput.bindAggregation("tokens",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:t,filters:e,length:50,startIndex:-50})}}else if(t){this.oTokenMultiInput.unbindAggregation("tokens")}}}B.prototype.openContainer=function(e){this._mAlreadyShownContents={};if(e){this._updateInitialContentKey();const t=function(){this._renderSelectedContent(this._sInitialContentKey,()=>{const t=this.getContent().find(e=>e.getId()===this.getProperty("_selectedContentKey"));const n=t.getInitialFocusedControl();if(n){e.setInitialFocus(n)}e.open();this.getContent().forEach(e=>{e.onContainerOpen()})})}.bind(this);if(A(this.getMaxConditions(),this.getContent())&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(n=>{n.forEach(t=>{e.getContent()[0].addItem(t)});t()})}else{if(this.oTokenMultiInput){R.call(this,true)}t()}}};B.prototype._renderSelectedContent=function(e,t,n){const o=this.getContent().find(t=>t.getId()===e);if(!o){throw new Error("sap.ui.mdc.ValueHelp: No content found.")}const i=[o.getContent()];const s=o.getGroup&&o.getGroup();let l;if(s&&O.call(this,s)){l=this._retrieveGroupSelect();i.push(l)}const a=!this._mAlreadyShownContents[e];return Promise.all(i).then(()=>{this.bindContentToContainer(o)}).then(()=>Promise.resolve(o.onBeforeShow(a))).then(()=>{this._mAlreadyShownContents[e]=true;this.setProperty("_selectedContentKey",e);this.setProperty("_selectableContents",this._getSelectableContents());this._oManagedObjectModel.checkUpdate(true,false,e=>{if(e.getPath().indexOf("displayContent")>=0){return true}});if(l){this._updateGroupSelectModel()}if(o.setCollectiveSearchSelect){o.setCollectiveSearchSelect(l?this._oGroupSelect:undefined)}if(t){t()}return this._retrievePromise("open").then(()=>o.onShow(a).then(()=>{if(n){const e=o.getDisplayContent();const t={onAfterRendering:()=>{this._oGroupSelect.focus();e.removeEventDelegate(t)}};e?.addEventDelegate(t)}return o}))})};B.prototype.closeContainer=function(e){const t=this.getAggregation("_container");if(t){if(e){t.oPopup._oPreviousFocus=null}t.close();if(this.oTokenMultiInput){R.call(this,false)}}};B.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};B.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"dialog",role:null,roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};B.prototype.isMultiSelect=function(){return this.getMaxConditions()!==1};B.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oInvisibleMessage=h.getInstance()};B.prototype.exit=function(){r.cleanup(this,["_oManagedObjectModel","_oResourceBundle","oButtonOK","oButtonCancel","oTokenizerPanel","oTokenMultiInput","_oIconTabBar","_oGroupSelect","_oGroupSelectModel","_sInitialContentKey","_mAlreadyShownContents","oInvisibleMessage","_oStandaloneTab"]);t.prototype.exit.apply(this,arguments)};return B});
//# sourceMappingURL=Dialog.js.map