/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/util/loadModules","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/Device","sap/ui/mdc/enums/RequestShowContainerReason"],(e,t,o,n,jQuery,i,s,a)=>{"use strict";let l,r,p;const{ValueState:u,TitleLevel:h}=i;const c=e.extend("sap.ui.mdc.valuehelp.Popover",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContainer","sap.ui.mdc.valuehelp.base.IDialogContainer","sap.ui.core.PopupInterface"],properties:{opensOnClick:{type:"boolean",defaultValue:false},opensOnFocus:{type:"boolean",defaultValue:false}},defaultAggregation:"content"}});c.prototype.invalidate=function(t){if(t){const o=this.getAggregation("_container");const n=this._oCurrentContent;if(o&&n&&t===n&&!this.isDestroyStarted()){o.invalidate(t)}else{e.prototype.invalidate.apply(this,arguments)}}};c.prototype.getUIAreaForContent=function(){const t=this.getAggregation("_container");if(t){return t.getUIArea()}return e.prototype.getUIAreaForContent.apply(this,arguments)};c.prototype._getContent=function(){const e=this.getContent();return e&&e[0]};c.prototype.getContainerControl=function(){const e=this.getAggregation("_container");if(!e){if(!this._oGetContainerControlPromise){if(s.system.phone){this._oGetContainerControlPromise=C.call(this)}else{this._oGetContainerControlPromise=f.call(this)}}return this._oGetContainerControlPromise}let t;let o;if(s.system.phone){[t]=e.getContent();[o]=e.getSubHeader().getContent();const n=m.call(this);this._oInputConditionType.setFormatOptions(n);g.call(this,this.getControl(),t,undefined,undefined,o)}else{t=e.getCustomHeader();d.call(this,this.getControl(),t)}return e};function d(e,t,o,n){o=o||e&&e.getValueState&&e.getValueState();n=n||e&&e.getValueStateText&&e.getValueStateText();if(o&&o!==u.None){t.setText(n);t.setValueState(o);t.setVisible(true)}else{t.setText();t.setValueState(u.None);t.setVisible(false)}}function g(e,t,o,n,i){d.call(this,e,t,o,n);if(t.getVisible()){i.setValueState(t.getValueState());i.setValueStateText(t.getText())}else{i.setValueState(u.None);i.setValueStateText()}if(e&&e.getPlaceholder){i.setPlaceholder(e.getPlaceholder())}const s=this.getModel("$valueHelp").getObject("/conditions");if(this.isSingleSelect()){if(s.length===1){const e=this._oInputConditionType.formatValue(s[0],"string");Promise.all([e]).then(([e])=>{i.setValue(e)}).catch(e=>{if(!(e instanceof p)){throw e}})}}else if(this._toggleShowConditions){this._toggleShowConditions(s.length>0)}}function f(){return n(["sap/m/Popover","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/ui/core/InvisibleText","sap/ui/core/Lib"]).then(e=>{if(this.isDestroyStarted()){return null}let t,o,n,i,s;[t,o,l,r,n,i,s]=e;const a=new n(this.getId()+"-pop-ValueState");d.call(this,this.getControl(),a);const p=new t(this.getId()+"-pop",{contentHeight:"auto",placement:o.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,title:this.getTitle(),titleAlignment:o.TitleAlignment.Center,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this),customHeader:a}).addStyleClass("sapMdcValueHelpPopover").addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");p._getAnimationDuration=()=>0;this._oInvisibleText=new i({text:s.getResourceBundleFor("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();p.addAriaLabelledBy(this._oInvisibleText);if(a){a.setPopup(p)}p.isPopupAdaptationAllowed=function(){return false};p.addStyleClass(this.isSingleSelect()?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");p.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});p._getAllContent=function(){const e=this.getParent();const t=[];if(e){if(this._oCurrentContent){t.push(this._oCurrentContent)}}return t}.bind(this);const u=this._getContent();const h=this.getContainerConfig(u);if(h){p.setShowArrow(!!h.showArrow);p.setShowHeader(!!h.showHeader);p.setResizable(!!h.resizable);if(h.getContentWidth){p.setContentWidth(h.getContentWidth())}}this.setAggregation("_container",p,true);return p})}function C(){return n(["sap/m/Dialog","sap/m/Input","sap/m/Button","sap/m/ToggleButton","sap/m/Bar","sap/m/ScrollContainer","sap/m/Title","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/m/List","sap/m/StandardListItem","sap/m/library","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/Lib","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/mdc/field/ConditionType"]).then(e=>{if(this.isDestroyStarted()){return null}let t,n,i,s,a,c,d,f,C,y,_,S,T,b,w,I,v;[t,n,i,s,a,c,d,l,r,f,C,y,_,S,T,b,w,p,I,v]=e;const{TitleAlignment:V,ListMode:P,ListType:A}=_;const H=b.getResourceBundleFor("sap.m");const O=this.isSingleSelect();const F=new f(this.getId()+"-pop-ValueState");const x=m.call(this);this._oInputConditionType=new v(x);this._oInputConditionType._bVHInput=true;const D=new n(this.getId()+"-pop-input",{value:{path:"/filterValue",model:"$valueHelp",mode:w.OneWay},width:"100%",showValueStateMessage:false,showValueHelp:this.hasDialog(),liveChange:e=>{const t=e.getParameter("value");const o=this.getValueHelp();if(o){o.setFilterValue(t)}if(!O){this._toggleShowConditions(false)}},submit:async e=>{const t=e.getParameter("value");if(t){const e=m.call(this);this._oInputConditionType.setFormatOptions(e);try{const e=await this._oInputConditionType.parseValue(t,"string");g.call(this,this.getControl(),F,undefined,undefined,D);this.fireSelect({type:O?o.Set:o.Add,conditions:[e]});this.fireConfirm({close:true})}catch(e){if(e instanceof I){g.call(this,this.getControl(),F,u.Error,e.message,D)}else{throw e}}}else{if(O){this.fireSelect({type:o.Set,conditions:[]})}this.fireConfirm({close:true})}},valueHelpRequest:e=>{this.handleRequestSwitchToDialog()}});const B=new l(this.getId()+"-pop-subheader",{content:[D]});const M=new c(this.getId()+"-pop--SC",{height:"100%",width:"100%",vertical:true});M._oWrapper=this;M.getContent=function(){const e=[];if(this._oWrapper._bShowConditions){const[t]=this.getDependents();e.push(t)}else if(this._oWrapper._oCurrentContent){e.push(this._oWrapper._oCurrentContent)}return e};let E;const L=new i(this.getId()+"-pop-closeButton",{text:H.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),press:e=>{D.fireSubmit({value:D.getValue()});if(!O){this._toggleShowConditions(false)}}});if(!O){const e=new C(this.getId()+"-pop-tokenList",{width:"auto",mode:P.Delete,delete:e=>{const t=e.getParameter("listItem");const n=this.getModel("$valueHelp").getObject("/conditions");const{sPath:i}=t.getBindingContext("$valueHelp");const s=parseInt(i.slice(i.lastIndexOf("/")+1));const a=[n[s]];this.fireSelect({type:o.Remove,conditions:a})}});M.addDependent(e);this._toggleShowConditions=t=>{if(this._bShowConditions!==t){this._bShowConditions=t;if(this._bShowConditions){const t=m.call(this);this._oTokenConditionType=this._oTokenConditionType||new v(t);this._oTokenConditionType._bVHTokenizer=true;this._oTokenConditionType.setFormatOptions(t);const o=new y(this.getId()+"-Token",{title:{path:"$valueHelp>",type:this._oTokenConditionType},selected:true,wrapping:true,type:A.Active,wrapCharLimit:1e4});e.bindAggregation("items",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:o})}else{e.unbindAggregation("items")}E.setPressed(t);M.invalidate()}};E=new s(this.getId()+"-pop-subheader-toggle",{icon:S.getIconURI("multiselect-all"),tooltip:H.getText("SHOW_SELECTED_BUTTON"),press:e=>{this._toggleShowConditions(e.getParameter("pressed"))}});B.addContent(E)}const R=new a(this.getId()+"-pop-header",{titleAlignment:V.Auto,contentMiddle:new d(this.getId()+"-pop-header-title",{text:this.getTitle(),level:h.H1}),contentRight:new i(this.getId()+"-pop-cancelButton",{icon:S.getIconURI("decline"),press:e=>{this.fireCancel();if(!O){this._toggleShowConditions(false)}}})});const k=new t(this.getId()+"-pop",{beginButton:L,stretch:true,titleAlignment:V.Auto,customHeader:R,subHeader:B,content:[F,M],horizontalScrolling:false,initialFocus:D,afterOpen:this.handleOpened.bind(this),beforeClose:this.handleClose.bind(this),afterClose:this.handleClosed.bind(this)});this._oInvisibleText=new T({text:b.getResourceBundleFor("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();k.addAriaLabelledBy(this._oInvisibleText);if(F){g.call(this,this.getControl(),F,undefined,undefined,D);F.setPopup(k)}k.addStyleClass(O?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");k.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});this.setAggregation("_container",k,true);return k})}function m(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const o=this.getParent();const n=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,hideOperator:t.operators&&t.operators.length===1,valueHelpID:o&&o.getId(),control:n,delegate:n&&n.getControlDelegate&&n.getControlDelegate(),delegateName:n&&n.getDelegate&&n.getDelegate()&&n.getDelegate().name,payload:n&&n.getPayload&&n.getPayload(),convertWhitespaces:true}}c.prototype.getScrollDelegate=function(t){if(s.system.phone){const e=this.getAggregation("_container");return e&&e.getContent()[1].getScrollDelegate()}else{return e.prototype.getScrollDelegate.apply(this,arguments)}};c.prototype.providesScrolling=function(){return true};c.prototype.observeChanges=function(t){if(t.name==="content"){const e=t.child;if(t.mutation==="remove"){e.detachNavigated(this.handleNavigated,this)}}e.prototype.observeChanges.apply(this,arguments)};c.prototype.placeContent=function(e){const t=this._getContent();const o=t&&t.getContent();const n=this.getContainerConfig(t);const i=n&&n.getFooter&&n.getFooter();return Promise.all([o,i]).then(t=>{this._oCurrentContent=t[0];const o=t[1];if(o&&e.getFooter()!=o&&o.isA&&o.isA("sap.m.Toolbar")){if(s.system.phone&&e.getBeginButton){const t=e.getBeginButton();o.addContent(t)}e.setFooter(o);return e}if(o){if(!e.getFooter()){const t=[new r(this.getId()+"-Spacer")].concat(o);const n=new l(this.getId()+"-TB",{content:t}).setModel(this._oManagedObjectModel,"$help");e.setFooter(n)}else{}}else if(e.getFooter()){e.setFooter()}return e})};c.prototype.openContainer=function(t,o){if(t.isOpen()){return}e.prototype.openContainer.apply(this,arguments);const n=this._getContent();const i=this._retrievePromise("open");Promise.resolve(n&&n.onBeforeShow(true)).then(async()=>{const e=this.getValueHelp();const t=o?await e._requestShowContainer(this,a.Filter):true;return t&&!i.isCanceled()?true:Promise.reject()}).then(()=>{if(s.system.phone){t.open()}else{this._openContainerByTarget(t)}}).catch(e=>{const t=this._retrievePromise("open");const o=i===t;if(o){this._cancelPromise(i);if(e&&e instanceof Error){throw e}}})};c.prototype._openContainerByTarget=function(e){const t=this.getControl();const o=t&&t.getFocusElementForValueHelp?t.getFocusElementForValueHelp(this.isTypeahead()):t;if(o&&o.getDomRef()){e.setContentMinWidth(jQuery(o.getDomRef()).outerWidth()+"px");if(!this.isFocusInHelp()){e.setInitialFocus(o)}e.openBy(o)}};c.prototype.closeContainer=function(t){e.prototype.closeContainer.apply(this,arguments);const o=this.getAggregation("_container");if(o){if(t){if(s.system.phone){o.oPopup._oPreviousFocus=null}else{o._oPreviousFocus=null}}o.close()}};c.prototype.handleOpened=function(e){this._resolvePromise("open");const t=this._getContent();if(t){t.onContainerOpen();t.onShow(true).then(e=>{this.fireOpened({itemId:e?.itemId,items:e?.items})})}else{this.fireOpened({itemId:undefined,items:undefined})}};c.prototype.handleConfirmed=function(e){const t=this.isSingleSelect();const o=e.getParameter("close");if(!s.system.phone||t||o){if(!o){this._disableFollowOfTemporarily()}this.fireConfirm({close:o||t})}};c.prototype._disableFollowOfTemporarily=function(){if(s.system.phone){return}if(this._followOfTimer){clearTimeout(this._followOfTimer)}const e=this.getAggregation("_container");e.setFollowOf(false);this._followOfTimer=setTimeout(()=>{e.setFollowOf(true)},300)};c.prototype.handleCanceled=function(t){if(!s.system.phone){e.prototype.handleCanceled.apply(this,arguments)}};c.prototype.handleClosed=function(t){const o=this._getContent();if(o){o.onHide();o.onContainerClose()}const n=this.getAggregation("_container");if(n){if(s.system.phone){n.oPopup._oPreviousFocus=null}else{n._oPreviousFocus=null}}e.prototype.handleClosed.apply(this,arguments)};c.prototype.removeVisualFocus=function(){const e=this._getContent();e?.removeVisualFocus()};c.prototype.setVisualFocus=function(){const e=this._getContent();e?.setVisualFocus()};c.prototype.navigateInContent=function(e){const t=this._getContent();this.bindContentToContainer(t);if(t){t.navigate(e)}};c.prototype.getItemForValue=function(e){const t=this._getContent();if(t){return t.getItemForValue(e)}};c.prototype.isValidationSupported=function(e){const t=this._getContent();if(t){return t.isValidationSupported()}};c.prototype.getUseAsValueHelp=function(){const e=this._getContent();return e&&e.getUseAsValueHelp&&e.getUseAsValueHelp()};c.prototype.getValueHelpIcon=function(){const e=this._getContent();return e&&e.getValueHelpIcon()};c.prototype.getAriaAttributes=function(t){const o=this._getContent();const n=o&&o.getAriaAttributes(t);if(n){return{contentId:n.contentId,ariaHasPopup:n.ariaHasPopup,role:this.isDialog()?"combobox":null,roleDescription:n.roleDescription,valueHelpEnabled:n.valueHelpEnabled,autocomplete:n.autocomplete}}return e.prototype.getAriaAttributes.apply(this,arguments)};c.prototype.shouldOpenOnNavigate=function(){const e=this._getContent();this.bindContentToContainer(e);return!!e&&e.shouldOpenOnNavigate()};c.prototype.isNavigationEnabled=function(e){if(this.isOpen()||this.getUseAsValueHelp()){const t=this._getContent();return!!t&&t.isNavigationEnabled(e)}return false};c.prototype.isFocusInHelp=function(){const e=this._getContent();return!!e&&e.isFocusInHelp()};c.prototype.isMultiSelect=function(){const e=this._getContent();return!!e&&e.isMultiSelect()};c.prototype.isTypeaheadSupported=function(){if(s.system.phone&&(this.isSingleSelect()||this.isDialog())){return false}const e=this._getContent();return e&&e.isSearchSupported()};c.prototype.setHighlightId=function(e){return this._getContent()?.setHighlightId?.(e)};c.prototype.exit=function(){this._oGetContainerControlPromise=undefined;if(this._oCurrentContent){if(!this._oCurrentContent.isDestroyed()){this._oCurrentContent.destroy()}this._oCurrentContent=null}if(this._oInvisibleText){this._oInvisibleText.destroy();delete this._oInvisibleText}if(this._oInputConditionType){this._oInputConditionType.destroy();this._oInputConditionType=undefined}if(this._oTokenConditionType){this._oTokenConditionType.destroy();this._oTokenConditionType=undefined}if(this._followOfTimer){clearTimeout(this._followOfTimer);this._followOfTimer=null}e.prototype.exit.apply(this,arguments)};return c});
//# sourceMappingURL=Popover.js.map