/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver"],(e,t,n,o)=>{"use strict";const i=e.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},localFilterValue:{type:"string"}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{parameters:{itemId:{type:"string"},items:{type:"int"}}},closed:{},cancel:{},requestDelegateContent:{parameters:{contentId:{type:"string"}}},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}}}});i.prototype.init=function(){this._oObserver=new o(this.observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};i.prototype.observeChanges=function(e){if(e.name==="content"){const t=e.child;if(e.mutation==="remove"){this.unbindContentFromContainer(t)}}};i.prototype.bindContentToContainer=function(e){if(e&&!e._bContentBound){e.attachConfirm(this.handleConfirmed,this);e.attachCancel(this.handleCanceled,this);e.attachSelect(this.handleSelect,this);if(e.attachNavigated){e.attachNavigated(this.handleNavigated,this)}if(e.attachVisualFocusSet){e.attachVisualFocusSet(this.handleVisualFocusSet,this)}if(e.attachTypeaheadSuggested){e.attachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(e.attachRequestSwitchToDialog){e.attachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}e.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:n.OneWay});const t={path:"/conditions",model:"$valueHelp",mode:n.OneWay};if(e._formatConditions){t.formatter=e._formatConditions.bind(e)}e.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:n.OneWay});e.bindProperty("conditions",t);e._bContentBound=true}};i.prototype.unbindContentFromContainer=function(e){if(e._bContentBound){e.unbindProperty("filterValue",true);e.unbindProperty("config",true);e.unbindProperty("conditions",true);e.detachConfirm(this.handleConfirmed,this);e.detachCancel(this.handleCanceled,this);e.detachSelect(this.handleSelect,this);if(e.detachNavigated){e.detachNavigated(this.handleNavigated,this)}if(e.detachVisualFocusSet){e.detachVisualFocusSet(this.handleVisualFocusSet,this)}if(e.detachTypeaheadSuggested){e.detachTypeaheadSuggested(this.handleTypeaheadSuggested,this)}if(e.detachRequestSwitchToDialog){e.detachRequestSwitchToDialog(this.handleRequestSwitchToDialog,this)}e._bContentBound=false}};i.prototype.handleNavigated=function(e){this.fireNavigated(e.mParameters)};i.prototype.handleVisualFocusSet=function(e){this.fireVisualFocusSet(e.mParameters)};i.prototype.handleTypeaheadSuggested=function(e){this.fireTypeaheadSuggested(e.mParameters)};i.prototype.handleRequestSwitchToDialog=function(e){this.fireRequestSwitchToDialog({container:this})};i.prototype.getContainerControl=function(){};i.prototype.getControl=function(){const e=this.getParent();return e&&e.getControl()};i.prototype.getMaxConditions=function(){const e=this.getModel("$valueHelp");return e&&e.getObject("/_config/maxConditions")};i.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};i.prototype.getDomRef=function(){const e=this.getAggregation("_container");return e&&e.getDomRef()};i.prototype.getUIArea=function(){return null};i.prototype.getUIAreaForContent=function(){return this.getUIArea()};i.prototype.open=function(e,t){if(!this.isOpening()){if(this._retrievePromise("close")){this._cancelPromise("close")}const n=this._addPromise("open");return Promise.all([this.getContainerControl(),e]).then(e=>this.placeContent(e[0])).then(e=>{if(!n.isCanceled()){this.openContainer(e,t)}return n})}return this._retrievePromise("open")};i.prototype.close=function(e){const t=this._retrievePromise("open");if(t){if(t.isSettled()){this.closeContainer(e)}else{this._cancelPromise(t)}}};i.prototype.placeContent=function(e){return e};i.prototype.openContainer=function(e,t){const n=this.getContent();for(let e=0;e<n.length;e++){this.bindContentToContainer(n[e])}};i.prototype.closeContainer=function(e){};i.prototype.handleOpened=function(e){this._resolvePromise("open");this.fireOpened()};i.prototype.handleClose=function(e){this._addPromise("close")};i.prototype.handleClosed=function(e){this._resolvePromise("close");this._removePromise("open");const t=this.getContent();for(let e=0;e<t.length;e++){this.unbindContentFromContainer(t[e])}this.fireClosed()};i.prototype.handleConfirmed=function(e){this.fireConfirm()};i.prototype.handleCanceled=function(e){this.fireCancel()};i.prototype.handleSelect=function(e){this.fireSelect({type:e.getParameter("type"),conditions:e.getParameter("conditions")})};i.prototype.isClosing=function(){const e=this._retrievePromise("close");return!!e&&!e.isCanceled()&&!e.isSettled()};i.prototype.isOpen=function(){const e=this._retrievePromise("open");return!!e&&e.isSettled()};i.prototype.isOpening=function(){const e=this._retrievePromise("open");return!!e&&!e.isCanceled()&&!e.isSettled()};i.prototype.getItemForValue=function(e){return undefined};i.prototype.isValidationSupported=function(){return false};i.prototype.navigate=function(e){return Promise.all([this.getContainerControl()]).then(e=>this.placeContent(e[0])).then(t=>{this.navigateInContent(e)})};i.prototype.navigateInContent=function(e){};i.prototype.removeVisualFocus=function(){};i.prototype.setVisualFocus=function(){};i.prototype.isTypeahead=function(){const e=this.getParent();return e&&e.getTypeahead()===this};i.prototype.isTypeaheadSupported=function(){return false};i.prototype.isDialog=function(){const e=this.getParent();return e&&(e.getDialog()===this||this.isTypeahead()&&!e.getDialog()&&this.getUseAsValueHelp())};i.prototype.hasDialog=function(){const e=this.getParent();return!!(e&&e.getDialog())};i.prototype.providesScrolling=function(){return false};i.prototype.getValueHelp=function(){const e=this.getParent();return e};i.prototype.getValueHelpDelegate=function(){const e=this.getParent();return e&&e.getControlDelegate()};i.prototype.getValueHelpDelegatePayload=function(){const e=this.getParent();return e&&e.getPayload()};i.prototype.awaitValueHelpDelegate=function(){const e=this.getParent();return e&&e.awaitControlDelegate()};i.prototype.isValueHelpDelegateInitialized=function(){const e=this.getParent();return!!e&&e.bDelegateInitialized};i.prototype.getUseAsValueHelp=function(){return false};i.prototype.getValueHelpIcon=function(){};i.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};i.prototype.getScrollDelegate=function(e){const t=this.getAggregation("_container");return t&&t.getScrollDelegate&&t.getScrollDelegate()};i.prototype.shouldOpenOnFocus=function(){const e=this.getValueHelpDelegate();const t=this.getValueHelp();return e?e.shouldOpenOnFocus(t,this):Promise.resolve(false)};i.prototype.shouldOpenOnClick=function(){const e=this.getValueHelpDelegate();const t=this.getValueHelp();return e?e.shouldOpenOnClick(t,this):Promise.resolve(false)};i.prototype.shouldOpenOnNavigate=function(){return false};i.prototype.isNavigationEnabled=function(e){return false};i.prototype.isFocusInHelp=function(){return!this.isTypeahead()};i.prototype.isMultiSelect=function(){return false};i.prototype.getContainerConfig=function(e){const t=e&&e.getContainerConfig();let n=t&&t[this.getMetadata().getName()];if(!n&&t){const e=Object.keys(t);const o=e.find(e=>this.isA(e));if(o){n=t[o]}}return n};i.prototype.getRetrieveDelegateContentPromise=function(){const e=this.getParent();return e&&e._retrievePromise("delegateContent")};i.prototype.getSelectedContent=function(){const e=this.getContent();return e&&e[0]};i.prototype.onConnectionChange=function(){const e=this.getContent();for(let t=0;t<e.length;t++){this.unbindContentFromContainer(e[t]);e[t].onConnectionChange()}};i.prototype.setHighlightId=function(e){};i.prototype.clone=function(t,n){const o=this.getContent();for(let e=0;e<o.length;e++){if(o[e]._bContentBound){o[e]._bRebindContent=true;this.unbindContentFromContainer(o[e])}}const i=e.prototype.clone.apply(this,arguments);for(let e=0;e<o.length;e++){if(o[e]._bRebindContent){this.bindContentToContainer(o[e]);delete o[e]._bRebindContent}}return i};i.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};t.call(i.prototype);return i});
//# sourceMappingURL=Container.js.map