/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/base/strings/formatMessage","sap/ui/mdc/enums/RequestShowContainerReason"],(t,e,n,o,i,r,p,a,s)=>{"use strict";const u=t.extend("sap.ui.mdc.valuehelp.base.Content",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},shortTitle:{type:"string",group:"Appearance",defaultValue:""},tokenizerTitle:{type:"string",group:"Appearance",defaultValue:""},conditions:{type:"object[]",defaultValue:[],byValue:true},filterValue:{type:"string",defaultValue:""},config:{type:"object",defaultValue:{}},visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{displayContent:{type:"sap.ui.core.Control",multiple:false}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enums.ValueHelpSelectionType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{},requestSwitchToDialog:{},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}}}});u.prototype.init=function(){this._oObserver=new n(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","config"]});this._oOperator=i.getEQOperator()};u.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};u.prototype.setProperty=function(e,n,o){if(e==="conditions"||e==="filterValue"||e==="config"){o=true}return t.prototype.setProperty.apply(this,[e,n,o])};u.prototype.getContent=function(){};u.prototype.getContainerConfig=function(){};u.prototype.onBeforeShow=function(t){};u.prototype.onShow=function(t){this._bVisible=true;this.handleConditionsUpdate();return Promise.resolve({})};u.prototype.getInitialFocusedControl=function(){return null};u.prototype.onHide=function(){this._bVisible=false};u.prototype.getItemForValue=function(t){return undefined};u.prototype.isValidationSupported=function(){return false};u.prototype.getScrollDelegate=function(){const t=this.getParent();return t&&t.getScrollDelegate()};u.prototype.observeChanges=function(t){if(t.name==="conditions"){this.handleConditionsUpdate(t)}if(t.name==="filterValue"){this.handleFilterValueUpdate(t)}if(t.name==="config"){l.call(this,t.current)}};u.prototype.handleFilterValueUpdate=async function(t){if(this.isContainerOpen()&&this.isTypeahead()){const t=this.getValueHelpInstance();const e=!await t._requestShowContainer(this.getParent(),s.Filter);if(e){this.fireCancel()}}};u.prototype.handleConditionsUpdate=function(t){};u.prototype.createCondition=function(t,e,n){const i=f.call(this);const a=[t];if(i.valueTypes.length>1&&i.valueTypes[1]!==p.Static&&e!==null&&e!==undefined){a.push(e)}return o.createCondition(i.name,a,undefined,undefined,r.Validated,n)};u.prototype.removeVisualFocus=function(){};u.prototype.setVisualFocus=function(){};u.prototype.navigate=function(t){};u.prototype.getUIArea=function(){const e=this.getParent();if(e&&e.getUIAreaForContent){return e.getUIAreaForContent()}return t.prototype.getUIArea.apply(this,arguments)};u.prototype.isTypeahead=function(){const t=this.getParent();return t&&t.isTypeahead()};u.prototype.isSearchSupported=function(){return false};u.prototype.provideScrolling=function(){const t=this.getParent();return!t||!t.providesScrolling()};u.prototype.isContainerOpen=function(){const t=this.getParent();return t&&t.isOpen()};u.prototype.isContainerOpening=function(){const t=this.getParent();return t&&t.isOpening()};u.prototype.getValueHelpDelegate=function(){const t=this.getParent();return t&&t.getValueHelpDelegate()};u.prototype.getValueHelpInstance=function(){const t=this.getParent();return t&&t.getValueHelp&&t.getValueHelp()};u.prototype.awaitValueHelpDelegate=function(){const t=this.getParent();return t&&t.awaitValueHelpDelegate()};u.prototype.isValueHelpDelegateInitialized=function(){const t=this.getParent();return!!t&&t.isValueHelpDelegateInitialized()};u.prototype.getControl=function(){const t=this.getParent();return t&&t.getControl()};u.prototype.getCount=function(t){return 0};u.prototype.getValueHelpIcon=function(){};u.prototype.getAriaAttributes=function(t){return{contentId:null,ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:"none"}};u.prototype.isSingleSelect=function(){return this.getMaxConditions()===1};u.prototype.shouldOpenOnClick=function(){return false};u.prototype.shouldOpenOnNavigate=function(){return false};u.prototype.isNavigationEnabled=function(t){return false};u.prototype.isFocusInHelp=function(){return!this.isTypeahead()};u.prototype.isMultiSelect=function(){return!this.isSingleSelect()};u.prototype.isQuickSelectSupported=function(){return false};u.prototype.getRequiresTokenizer=function(){return true};function l(t){c.call(this,t.operators)}function c(t){this._oOperator=i.getEQOperator(t)}function f(){return this._oOperator}u.prototype.getFormattedTitle=function(t){let e=this.getTitle();if(e){e=a(e,t?t:"")}return e};u.prototype.getFormattedShortTitle=function(){return this.getShortTitle()};u.prototype.getFormattedTokenizerTitle=function(t){let e=this.getTokenizerTitle();if(e){e=a(e,t?t:"")}return e};u.prototype.getMaxConditions=function(){const t=this.getConfig();return t&&t.maxConditions};u.prototype.onContainerClose=function(){};u.prototype.onContainerOpen=function(){};u.prototype.onConnectionChange=function(){};u.prototype.setHighlightId=function(t){};e.call(u.prototype);return u});
//# sourceMappingURL=Content.js.map