/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/base/i18n/Localization","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/Messaging","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/Field","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/base/ManagedObjectModel","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/type/String","sap/ui/model/ParseException","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/library","sap/m/Button","sap/m/Panel","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/m/Title","sap/ui/core/IconPool","sap/ui/core/InvisibleMessage","sap/ui/thirdparty/jquery"],(t,e,i,n,s,o,a,l,r,d,u,c,h,p,g,f,C,y,v,I,m,b,_,O,T,x,S,D,P,V,w,N,E,M,$,B,L,A,F,R,U,jQuery)=>{"use strict";let H=a.getResourceBundleFor("sap.ui.mdc");let j=a.getResourceBundleFor("sap.m");i.attachChange(()=>{H=a.getResourceBundleFor("sap.ui.mdc");j=a.getResourceBundleFor("sap.m")});const{ButtonType:k}=N;const{ValueState:G}=D;const{InvisibleMessageMode:X}=D;const{TextAlign:K}=D;const{BackgroundDesign:W}=N;const{ToolbarDesign:q}=N;const{OverflowToolbarPriority:Y}=N;const z=t.extend("sap.ui.mdc.valuehelp.base.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},config:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true},_pagination:{type:"boolean",defaultValue:false,visibility:"hidden"},_prevButtonActive:{type:"boolean",defaultValue:false,visibility:"hidden"},_nextButtonActive:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{conditionProcessed:{}}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(t,e){t.openStart("section",e);t.class("sapUiMdcDefineConditionPanel");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("section")}},init:function(){l.registerObject(this,true);t.prototype.init.apply(this,arguments);this.oInvisibleMessage=U.getInstance();this._oManagedObjectModel=new _(this);this._oObserver=new e(J.bind(this));this._oObserver.observe(this,{properties:["conditions","config"]});this._iStartIndex=0;this._iShownConditions=10;this._iShownAdditionalConditions=0;this._sOperatorHelpId=this.getId()+"--rowSelect-help";this._oContentEventDelegate={onpaste:this.onPaste};ht.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition")},exit:function(){l.unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel},byId:function(t){return o.getElementById(this.getId()+"--"+t)},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new T({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}if(this.getConditions().length===0&&!this._sConditionsTimer){this.updateDefineConditions()}},removeCondition:function(t){const{oSource:e}=t;const i=e.getBindingContext("$this");let n=this.getConditions();const s=i.getPath();const o=s.match(/^.*\/(\d+)\/$/);let a;if(o){a=parseInt(o[1])}if(a>0&&n.length-1===a){this._bFocusLastRemoveBtn=true}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),X.Assertive);const l=this.byId("conditions");const r=l.getContent();let d=-1;for(const t of r){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){d++}if(t instanceof y&&t.hasOwnProperty("_iValueIndex")&&t.getBindingContext("$this").getPath().startsWith(s)){if(t.isInvalidInput()){t.setValue(null)}}}if(n.length===1&&a===0){this.addDummyCondition(1);n=this.getConditions()}if(d===0&&this._iStartIndex>0){this._iStartIndex=this._iStartIndex-this._iShownConditions}n.splice(a,1);this.setProperty("conditions",n,true);this.fireConditionProcessed()},addCondition:function(t){const e=this.getConditions();const i=this.getConfig();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(const t of o){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){a++;const e=t.getBindingContext("$this");const i=e.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}if(n===-1||e.length<n){this.addDummyCondition(l+1);this._bFocusLastCondition=true;if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),X.Assertive)},addDummyCondition:function(t){const e=st.call(this);const i=nt.call(this);const n=i.name;const s=r.createCondition(n,i.valueDefaults?i.valueDefaults:[],undefined,undefined,f.NotValidated);if(i.valueTypes[0]&&i.valueTypes[0]!==C.Static){s.isInitial=true}d.updateConditionValues(s);d.checkConditionsEmpty(s,e);const o=this.getConditions();if(t!==undefined){o.splice(t,0,s)}else{o.push(s)}this.setProperty("conditions",o,true);if(!s.isInitial){this.fireConditionProcessed()}},updateDefineConditions:function(){const t=wt.call(this);ct.call(this,t,true,this._bUpdateType);if(t.length===0){this.addDummyCondition()}if(t.length<this._iStartIndex){this._iStartIndex=0}},onChange:function(t){const e=t&&t.getParameter("promise");const i=t&&t.getSource();const n=function(t){const e=st.call(this);const i=this.getConditions();d.checkConditionsEmpty(i,e);d.updateConditionsValues(i,e);ct.call(this,i,false,false);if(t){i.forEach(t=>{if(!t.isEmpty){delete t.isInitial}})}this.setProperty("conditions",i,true)}.bind(this);if(e){e.then(t=>{this._bPendingChange=false;n({mParameters:{value:t}});if(this._bPendingValidateCondition){Pt.call(this,i);delete this._bPendingValidateCondition}}).catch(t=>{this._bPendingChange=false;if(this._bPendingValidateCondition){Pt.call(this,i);delete this._bPendingValidateCondition}});this._bPendingChange=true;return}else{n()}},onSelectChange:function(t){const e=t.getSource();const i=t.getParameter("promise");i.then(t=>{const i=e._sOldKey;const n=d.getOperator(t);const o=i&&d.getOperator(i);const a=e.getBindingContext("$this");let l=a.getObject();const r=a.getPath();const u=parseInt(r.split("/")[2]);const c=this.getConditions();if(u>=0){l=c[u]}if(n&&o){let a=false;if(!s(n.valueTypes[0],o.valueTypes[0])&&n.valueTypes[0]!==C.Static){if(u>=0){l.values.forEach((t,e)=>{if(t!==null){if(n.valueTypes[e]===C.Self&&o.valueTypes[e]===C.SelfNoParse||n.valueTypes[e]===C.SelfNoParse&&o.valueTypes[e]===C.Self){const t=et.call(this,n.name,e);const i=et.call(this,o.name,e);const s=i.formatValue(l.values[e],"string");const r=t.parseValue(s,"string");if(r!==l.values[e]){l.values[e]=t.parseValue(s,"string");a=true}}else{l.values[e]=null;a=true}}})}}let r=false;if(n.valueTypes.length===0||n.valueTypes[0]===C.Static){for(let i=0;i<c.length;i++){if(i!==u&&t===c[i].operator){r=true;l.invalid=true;a=true;e.setValueState(G.Error);e.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[t]));break}}}if(o.valueTypes.length===0||o.valueTypes[0]===C.Static){let t=-1;let e=false;for(let n=0;n<c.length;n++){if(i===c[n].operator){if(t<0){t=n}else{e=true;break}}}if(!e&&t>=0){delete c[t].invalid;a=true}}if(u>=0&&n.valueDefaults){l.values.forEach((t,e)=>{if(l.isInitial&&t!==n.valueDefaults[e]||t===null){l.values[e]=n.valueDefaults[e];l.isInitial=true;a=true}})}if(!n.valueTypes[1]&&o.valueTypes[1]){if(u>=0){if(l.values.length>1&&l.values[1]){l.values=l.values.slice(0,1);a=true}}}if(l.invalid&&!r){delete l.invalid;a=true}if(a){d.checkConditionsEmpty(l,st.call(this));this.setProperty("conditions",c,true)}if(!l.invalid&&(n.valueTypes.length===0||n.valueTypes[0]===C.Static||(o.valueTypes.length===0||o.valueTypes[0]===C.Static))){this.fireConditionProcessed()}}delete e._sOldKey}).catch(t=>{const i=e.getBindingContext("$this");let n=i.getObject();const s=i.getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();if(o>=0){n=a[o]}n.invalid=true;this.setProperty("conditions",a,true);e._sOldKey=e.getValue()})},onPaste:function(t){const e=t.originalEvent.clipboardData.getData("text/plain");const i=c(e,true);if(i.length>1){const i=t.srcControl;const s=i.getBindingContext("$condition").getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();const l=n({},this.getConfig());l.display=p.Value;l.getConditions=function(){return a};l.defaultOperatorName=a[o].operator;l.valueType=l.dataType;delete l.dataType;const r=new u(l);a.splice(o,1);r._parseValueToIndex(e,"string",o).then(t=>{r.validateValue(t);d.checkConditionsEmpty(t);this.setProperty("conditions",t,true);this.fireConditionProcessed();r.destroy()}).catch(t=>{const n=new S(H.getText("field.PASTE_ERROR"));const s={element:i,property:"value",type:r,newValue:e,oldValue:"",exception:n,message:n.message};i.fireParseError(s,false,true);r.destroy()});t.stopImmediatePropagation(true);t.preventDefault()}},cleanUp:function(){const t=this.byId("conditions");const e=t.getContent();for(const t of e){if(t instanceof y&&t.hasOwnProperty("_iValueIndex")){if(t.isInvalidInput()){t.setValue()}}}this.setProperty("inputOK",true,true);if(this._iStartIndex>0||this._iShownAdditionalConditions>0){this._iStartIndex=0;this._iShownAdditionalConditions=0;ft.call(this)}},getInitialFocusedControl:function(){const t=this.getAggregation("_content").getContent()[1];const e=t.getContent()[0];return e},_getValueHelp:function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}});function J(t){if(t.name==="value"){Z.call(this,t.object,t.current,t.old)}if(t.name==="config"){const e=this.getConditions();const i=t.current&&t.current.operators;const n=t.old&&t.old.operators;let o=false;if(!s(i,n)){o=true;at.call(this)}const a=t.current&&t.current.dataType;const l=t.old&&t.old.valueType;const r=a&&a.getMetadata().getName();const d=l&&l.getMetadata().getName();const u=a&&a.getFormatOptions();const c=l&&l.getFormatOptions();const h=a&&a.getConstraints();const p=l&&l.getConstraints();if(r!==d||!s(u,c)||!s(h,p)){if(!o){at.call(this)}if(this._sConditionsTimer){this._bUpdateType=true}else if(e.length>0){this._bUpdateType=true;ft.call(this);this._bUpdateType=false;ct.call(this,e,true,true)}}}if(t.name==="conditions"&&!this._bConditionUpdateRunning){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}this._sConditionsTimer=setTimeout(()=>{this._sConditionsTimer=null;this._bConditionUpdateRunning=true;this.updateDefineConditions();ft.call(this);this._bUpdateType=false;this._bConditionUpdateRunning=false},0)}}function Q(t){return true}function Z(t,e,i){t._sOldKey=i;let n=0;let s;if(i){const s=e&&d.getOperator(e);const o=d.getOperator(i);const a=t.getParent();let l;let r;n=a.indexOfContent(t);l=a.getContent()[n+2];if(l?.hasOwnProperty("_iValueIndex")&&l._iValueIndex===0){if(l instanceof y&&!l.isInvalidInput()){l.setValueState(G.None);l.setValueStateText()}r=a.getContent()[n+3];if(r?.hasOwnProperty("_iValueIndex")&&r._iValueIndex===1){if(r instanceof y&&!r.isInvalidInput()){r.setValueState(G.None);r.setValueStateText()}}else{r=undefined}}else{l=undefined}let u;if(e&&Q(e)){u=this._getValueHelp()}l?.setValueHelp?.(u);r?.setValueHelp?.(u);if(s?.createControl||o?.createControl){l?.destroy();r?.destroy()}else{if(l&&s?.valueTypes[0]!==o?.valueTypes[0]){l.unbindProperty("value")}if(r&&s?.valueTypes[1]!==o?.valueTypes[1]&&o?.valueTypes[1]){r.unbindProperty("value")}}}if(!e){s=t.getBindingContext("$this").getObject();if(s){const t=this.getConditions();n=d.indexOfCondition(s,t);if(n>=0){s=t[n];s.operator=i;this.setProperty("conditions",t,true)}}}const o=this.oOperatorModel.getData();let a;for(const t of o){if(t.key===e){a=t.text;break}}t.setAdditionalValue(a);this.onChange()}function tt(t,e,i,n){const s=d.getOperator(t.operator);if(!s||!s.valueTypes[e]){return null}const o=et.call(this,s.name,e);const a=this._oManagedObjectModel.getContext(n.getPath()+"values/"+e+"/");let l;if(s.createControl){l=s.createControl(o,"$this>",e,i)}if(!l){l=new y(i,{delegate:ut.call(this),value:{path:"$this>",type:o,mode:"TwoWay",targetType:"raw"},editMode:{parts:[{path:"$condition>operator"},{path:"$condition>invalid"}],formatter:mt},multipleLines:false,width:"100%",valueHelp:Q(t.operator)?this._getValueHelp():null})}if(l.getMetadata().hasProperty("placeholder")){if(e===0){l.bindProperty("placeholder",{path:"$condition>operator",formatter:Tt})}else{l.bindProperty("placeholder",{path:"$condition>operator",formatter:xt})}}l._iValueIndex=e;if(l.attachChange){l.attachChange(this.onChange.bind(this))}l.addDelegate(this._oContentEventDelegate,true,this);l.setLayoutData(new w({span:{parts:[{path:"$condition>"},{path:"$this>/config"}],formatter:Ot.bind(this)}}));l.setBindingContext(a,"$this");l.setBindingContext(n,"$condition");l.setFieldGroupIds([n.getPath()]);return l}function et(t,e){let i=lt.call(this);const n=d.getOperator(t);if(n.valueTypes[e]&&[C.Self,C.Static].indexOf(n.valueTypes[e])===-1){i=n._createLocalType(n.valueTypes[e],i)}let s=false;if(n.valueTypes[e]===C.Static){s=true;i=rt.call(this)}const o=s?g.String:dt.call(this,i);let a;const l=i.getFormatOptions();switch(o){case g.Numeric:if(l&&l.hasOwnProperty("emptyString")&&l.emptyString===null){a=i}else{a=it(i,{emptyString:null})}break;case g.Date:case g.Time:case g.DateTime:a=i;break;default:if(i.getConstraints()&&i.getConstraints().hasOwnProperty("nullable")&&i.getConstraints().nullable===false){a=it(i);if(i._bCreatedByOperator){a=n._createLocalType(n.valueTypes[e],i)}}else{a=i}break}return a}function it(t,e,i){const s=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));const o=n(t.getFormatOptions(),e||{});const a=n(t.getConstraints(),i||{});if(a.hasOwnProperty("nullable")&&a.nullable===false){a.nullable=true}return new s(o,a)}function nt(){const t=st.call(this);let e;const i=this.getConfig().defaultOperatorName;if(i){e=d.getOperator(i)}else{const t=lt.call(this);const i=dt.call(this,t);e=d.getDefaultOperator(i)}if(e&&t.indexOf(e.name)<0){for(let i=0;i<t.length;i++){e=d.getOperator(t[i]);if(!e||e.exclude||!e.hasRequiredValues()){e=undefined}else{break}}}if(!e){e=d.getOperator(t[0])}return e}function st(){const t=this.getConfig();let e=t&&t.operators;if(!e||e.length===0){e=d.getOperatorsForType(g.String)}return e}function ot(){let t;const e=st.call(this);for(const i of e){const e=d.getOperator(i);if(!t){t=e.group.id}else if(t!==e.group.id){return true}}return false}function at(){if(!this.oOperatorModel){return}const t=lt.call(this);const e=st.call(this);const i=[];const n=ot.call(this);const s=this._sOperatorHelpId+"-pop-fl";const a=o.getElementById(s);const l=a.getBindingInfo("items");let r=l?.template;if(!r||a.getGroupable()!==n){if(n){r=new b({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"})}else{r=new b({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"})}a.bindAggregation("items",{path:"om>/",templateShareable:false,template:r});a.setGroupable(n)}for(const s of e){const e=d.getOperator(s);if(!e||e.showInSuggest!==undefined&&e.showInSuggest==false){continue}const o=e.getLongText(dt.call(this,t));let a=e.additionalInfo;if(a===undefined){if(a!==""&&e.formatRange){a=e.formatRange(e._getRange(undefined,t),t)}else if(!n){a=e.group.text}}let l=e.exclude?"2":"1";if(e.group.text&&e.group.id){l=e.group.id}i.push({key:e.name,text:o,additionalText:a,groupId:l,groupText:e.group.text})}a.destroyItems();this.oOperatorModel.setData();this.oOperatorModel.setData(i)}function lt(){const t=this.getConfig();let e=t&&t.dataType;if(!e){e=rt.call(this)}return e}function rt(){if(!this._oDefaultType){this._oDefaultType=new x}return this._oDefaultType}function dt(t){const e=t.getMetadata().getName();const i=t.getFormatOptions();const n=t.getConstraints();const s=this.getConfig().delegate;const o=this.getConfig().control;let a=s?s.getTypeMap(o).getBaseType(e,i,n):g.String;if(a===g.Unit){a=g.Numeric}return a}function ut(){const t=this.getConfig();const e=t.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";const i=t.payload;return{name:e,payload:i}}function ct(t,e,i){const n=lt.call(this);const s=[];let o=0;for(o=0;o<t.length;o++){const e=t[o];const a=d.getOperator(e.operator);if(a&&a.valueTypes[0]===C.Static&&(e.values.length===0||i)){if(a.getStaticText){const t=a.getStaticText(n,dt.call(this,n));if(e.values.length>0){e.values[0]=t}else{e.values.push(t)}s.push(o)}}}if(e&&s.length>0){this.setProperty("conditions",t,true)}}function ht(){const t=new P(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});const e=new F(this.getId()+"-title",{text:{path:"$this>/label"}});const i=new E(this.getId()+"--prev",{icon:R.getIconURI("navigation-left-arrow"),tooltip:j.getText("PAGINGBUTTON_PREVIOUS"),visible:{path:"$this>/_pagination"},enabled:"{= ${$this>/inputOK} && ${$this>/_prevButtonActive}}",layoutData:new B({priority:Y.NeverOverflow}),press:Et.bind(this)});const n=new E(this.getId()+"--next",{icon:R.getIconURI("navigation-right-arrow"),tooltip:j.getText("PAGINGBUTTON_NEXT"),visible:{path:"$this>/_pagination"},enabled:"{= ${$this>/inputOK} && ${$this>/_nextButtonActive}}",layoutData:new B({priority:Y.NeverOverflow}),press:Nt.bind(this)});const s=new E(this.getId()+"--removeAll",{text:j.getText("CONDITIONPANEL_REMOVE_ALL"),visible:{path:"$this>/_pagination"},layoutData:new B({priority:Y.Low}),press:Mt.bind(this)});const o=new E(this.getId()+"--insert",{icon:R.getIconURI("add"),visible:{path:"$this>/_pagination"},enabled:{path:"$this>/inputOK"},layoutData:new B({priority:Y.Low}),press:$t.bind(this)});const a=new A(this.getId()+"--pageCount",{text:Bt.call(this),wrapping:false,textAlign:K.Center,visible:{path:"$this>/_pagination"},layoutData:new B({priority:Y.NeverOverflow})});const l=new $(this.getId()+"--toolbar",{width:"100%",design:q.Transparent,content:[e,new L,i,a,n,s,o]});const r=new M(this.getId()+"--panel",{headerToolbar:l,expanded:true,height:"100%",backgroundDesign:W.Transparent}).addStyleClass("sapMdcDefineconditionPanel");r.addDependent(new v(this._sOperatorHelpId,{typeahead:new I(this._sOperatorHelpId+"-pop",{content:[new m(this._sOperatorHelpId+"-pop-fl",{filterList:false,useFirstMatch:true})]})}));const d=new V(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");d.addDelegate({onAfterRendering:Ct},false,this);It.call(this,undefined,d,0,null,0);r.addContent(t);r.addContent(d);this._oInvisibleAddOperatorButtonText=new P({text:H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_DESCRIPTION")});r.addContent(this._oInvisibleAddOperatorButtonText);const u=new E(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:k.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new w({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:pt.bind(this)}}),ariaDescribedBy:this._oInvisibleAddOperatorButtonText});d.addContent(u);d.attachValidateFieldGroup(Dt,this);this.setAggregation("_content",r)}function pt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i===-1||t.length<i}function gt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i!==1}function ft(){const t=this.getConditions();const e=this.byId("conditions");const i=this.byId("pageCount");let n;let s=-1;let o=0;let a=-1;const l=this._iShownConditions+this._iShownAdditionalConditions;for(let i=0;i<t.length&&s<l;i++){const r=t[i];const u=d.getOperator(r.operator);if(r.validated!==f.Validated||u.exclude){a++;if(a>=this._iStartIndex){s++;if(s<l){const t=this._oManagedObjectModel.getContext("/conditions/"+i+"/");if(!this.oOperatorModel){this.oOperatorModel=new O;this.setModel(this.oOperatorModel,"om");at.call(this)}n=e.getContent();if(n[o]&&n[o].isA("sap.ui.mdc.Field")){o=St.call(this,r,e,o,t,s)}else{o=It.call(this,r,e,o,t,s)}}}}}n=e.getContent();while(n[o]&&n[o]!==this.byId("addBtn")){n[o].destroy();o++}Vt.call(this,undefined);i.setText(Bt.call(this));this.setProperty("_prevButtonActive",this._iStartIndex>0);this.setProperty("_nextButtonActive",s>=l);this.setProperty("_pagination",a>=l);this._bGridUpdated=true}function Ct(){if(!this._bGridUpdated){return}const t=this.byId("conditions");const e=t.getContent();let i=0;if(this._bFocusLastCondition){i=vt.call(this,"-operator");e[i].focus();this._bFocusLastCondition=false}if(this._bFocusLastRemoveBtn){i=yt.call(this,["-removeBtnLarge","-removeBtnSmall"]);e[i].focus();this._bFocusLastRemoveBtn=false}this._bGridUpdated=false}function yt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;if(!Array.isArray(t)){t=[t]}let s=0;let o=t[s];while(n>=0&&o!==undefined){const e=i[n];if(e.getId().endsWith(o)){const i=jQuery(e.getDomRef());if(i.is(":visible")){return n}else{s++;o=t[s]}}n--}return 0}function vt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;const s=t;while(n>=0){const t=i[n];if(t.getId().endsWith(s)){return n}n--}return 0}function It(t,e,i,n,s){const o=this.getId()+"--"+s;if(!this._oOperatorFieldType){this._oOperatorFieldType=new x({},{minLength:1})}const a=new y(o+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:p.Description,editMode:h.Editable,multipleLines:false,valueHelp:this._sOperatorHelpId,change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new w({span:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:_t.bind(this)},linebreak:true})).setBindingContext(n,"$this");if(n){a.setFieldGroupIds([n.getPath()])}this._oObserver.observe(a,{properties:["value"]});e.insertContent(a,i);i++;const l=new E(o+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:k.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new w({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:bt},visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n,"$this");if(n){l.setFieldGroupIds([n.getPath()])}e.insertContent(l,i);i++;if(t){for(let s=0;s<t.values.length;s++){const a=tt.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}const r=new E(o+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:k.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new w({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:bt},visibleS:false,visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:gt.bind(this)}})).setBindingContext(n,"$this");e.insertContent(r,i);i++;return i}function mt(t,e){if(!t){return this.getEditMode()}else if(e){return h.ReadOnly}const i=d.getOperator(t);let n=false;if(i&&i.valueTypes[0]===C.Static){n=true}return n?h.Display:h.Editable}function bt(t){const e=t&&d.getOperator(t);if(!e||!e.valueTypes[0]||e.valueTypes[0]===C.Static&&!e.getStaticText){return"XL8 L8 M8 S0"}else{return""}}function _t(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;let n="XL3 L3 M3 ";if(i===1){n+="S12"}else{n+="S10"}return n}function Ot(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;const n=t&&d.getOperator(t.operator);let s="";if(n&&n.valueTypes[1]){s="XL4 L4 M4 "}else{s="XL8 L8 M8 "}if(i===1){s+="S12"}else{s+="S10"}return s}function Tt(t){const e=t&&d.getOperator(t);if(e&&e.aLabels){return e.aLabels[0]}else if(e&&e.valueTypes[1]){return H.getText("valuehelp.DEFINECONDITIONS_FROM")}else{return H.getText("valuehelp.DEFINECONDITIONS_VALUE")}}function xt(t){const e=t&&d.getOperator(t);if(e&&e.aLabels){return e.aLabels[1]}else if(e&&e.valueTypes[1]){return H.getText("valuehelp.DEFINECONDITIONS_TO")}}function St(t,e,i,n,s){const o=this.getId()+"--"+s;let a=e.getContent();let l;const r=a[i];r.setBindingContext(n,"$this");if(n){r.setFieldGroupIds([n.getPath()])}if(r.getValueState()===G.Error&&!t.invalid){r.setValue(r.getValue());r.setValueState(G.None);r.setValueStateText()}i++;const d=a[i];d.setBindingContext(n,"$this");if(n){d.setFieldGroupIds([n.getPath()])}i++;let u;let c=a[i];let h;if(c.hasOwnProperty("_iValueIndex")&&c._iValueIndex===0){c.setValueHelp?.(Q(t.operator)&&this._getValueHelp());if(t.values.length>0){u=this._oManagedObjectModel.getContext(n.getPath()+"values/0/");c.setBindingContext(u,"$this");c.setBindingContext(n,"$condition");if(c.getMetadata().hasProperty("value")&&(this._bUpdateType||!c.getBindingInfo("value"))){l=et.call(this,t.operator,0);c.bindProperty("value",{path:"$this>",type:l})}i++;h=a[i];if(h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){if(t.values.length>1){u=this._oManagedObjectModel.getContext(n.getPath()+"values/1/");h.setBindingContext(u,"$this");if(h.getMetadata().hasProperty("value")&&(this._bUpdateType||!h.getBindingInfo("value"))){l=et.call(this,t.operator,1);h.bindProperty("value",{path:"$this>",type:l})}i++}else{h.destroy()}}else if(t.values.length>1){h=tt.call(this,t,1,o+"-values1",n);if(h){e.insertContent(h,i);i++}}}else{c.destroy();c=undefined;h=a[i+1];if(h&&h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){h.destroy()}}}else if(t.values.length>0){for(let s=0;s<t.values.length;s++){const a=tt.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}a=e.getContent();const p=a[i];p.setBindingContext(n,"$this");i++;return i}function Dt(t){if(this._bPendingChange){this._bPendingValidateCondition=true;return}let e=t.getSource();while(!(e.getParent()instanceof V)){e=e.getParent()}Pt.call(this,e)}function Pt(t){const e=t.getParent();let i=e.indexOfContent(t);let n;if(t.getId().endsWith("-operator")){n=t.getBindingContext("$this");i=i+2;t=e.getContent()[i]}else if(t.getId().endsWith("-removeBtnSmall")){n=t.getBindingContext("$this");i=i+1;t=e.getContent()[i]}else{n=t.getBindingContext("$condition")}let s;const o=n.getObject();const a=d.getOperator(o.operator);let l=!!o.invalid;if(!l&&a.valueTypes.length>0&&a.valueTypes[0]!==C.Static){if(a.valueTypes.length>1&&a.valueTypes[1]){if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===0){s=e.getContent()[i+1]}else if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===1){s=e.getContent()[i-1]}}if(t instanceof y&&!t.isInvalidInput()&&(!s||!s.isInvalidInput())){const e=t.getBinding("value").getType();try{a.validate(o.values,e);t.setValueState(G.None);t.setValueStateText();if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.None);s.setValueStateText()}}catch(e){l=true;t.setValueState(G.Error);t.setValueStateText(e.message);if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.Error);s.setValueStateText(e.message)}}}if(!l){const e=this.getConditions();const i=n.getPath();const a=parseInt(i.split("/")[2]);for(let i=0;i<e.length;i++){if(i!==a&&!o.isEmpty&&d.compareConditions(o,e[i])){l=true;t.setValueState(G.Error);t.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[o.values[0]]));if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(G.Error);s.setValueStateText(H.getText("field.CONDITION_ALREADY_EXIST",[o.values[1]]))}break}}}}Vt.call(this,l);this.fireConditionProcessed()}function Vt(t){let e=0;if(t!==true){const i=this.getConditions();for(e=0;e<i.length;e++){if(i[e].invalid){t=true;break}}}if(t!==true){const i=this.byId("conditions");const n=i.getContent();t=false;for(e=0;e<n.length;e++){const i=n[e];if(i.hasOwnProperty("_iValueIndex")&&(i instanceof y&&i.isInvalidInput()||i.getValueState&&i.getValueState()===G.Error)){if(i instanceof y&&!i.isInvalidInput()){let t=false;const e=i.getBindingContext("$condition");const n=e.getObject();const s=this.getConditions();const o=e.getPath();const a=parseInt(o.split("/")[2]);for(let e=0;e<s.length;e++){if(e!==a&&!n.isEmpty&&d.compareConditions(n,s[e])){t=true;break}}if(!t){i.setValueState(G.None);i.setValueStateText();continue}}t=true}}}this.setProperty("inputOK",!t,true)}function wt(){return this.getConditions().filter(t=>{const e=d.getOperator(t.operator);return t.validated!==f.Validated||e.exclude})}function Nt(t){this._iStartIndex=this._iStartIndex+this._iShownConditions;this._iShownAdditionalConditions=0;ft.call(this)}function Et(t){this._iStartIndex=this._iStartIndex-this._iShownConditions;if(this._iStartIndex<0){this._iStartIndex=0}this._iShownAdditionalConditions=0;ft.call(this)}function Mt(t){const e=this.getConditions().filter(t=>{const e=d.getOperator(t.operator);return t.validated===f.Validated&&!e.exclude});this.addDummyCondition(e.length+1);this._iStartIndex=0;this._iShownAdditionalConditions=0;this.setProperty("conditions",e,true);this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),X.Assertive);this.fireConditionProcessed()}function $t(t){const e=this.getConditions();const i=n({},this.getConfig());const s=i.maxConditions;const o=this.byId("conditions");const a=o.getContent();let l=0;let r=-1;for(const t of a){if(t instanceof y&&t.getValueHelp()===this._sOperatorHelpId){l++;if(l===1){const e=t.getBindingContext("$this");const i=e.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){r=parseInt(n[1])}}}}if(s===-1||e.length<s){this.addDummyCondition(r);if(l>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(H.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),X.Assertive)}function Bt(){const t=wt.call(this);const e=Math.ceil((t.length-this._iShownAdditionalConditions)/this._iShownConditions);const i=Math.floor(this._iStartIndex/this._iShownConditions)+1;const n=H.getText("valuehelp.PAGE_COUNT",[i,e]);return n}return z});
//# sourceMappingURL=DefineConditionPanel.js.map