/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/util/loadModules","sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/util/Common","sap/m/p13n/enums/PersistenceMode","sap/m/p13n/Engine","sap/base/util/merge","sap/ui/mdc/p13n/StateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/Log"],(e,t,i,n,r,o,s,l,a,c,h,p,d)=>{"use strict";const u=i.extend("sap.ui.mdc.valuehelp.base.FilterableListContent",{metadata:{library:"sap.ui.mdc",properties:{filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},group:{type:"string",defaultValue:""}},aggregations:{filterBar:{type:"sap.ui.mdc.valuehelp.FilterBar",multiple:false},_defaultFilterBar:{type:"sap.ui.mdc.valuehelp.FilterBar",multiple:false,visibility:"hidden"}},associations:{},events:{}}});u.prototype.init=function(){i.prototype.init.apply(this,arguments);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oObserver.observe(this,{aggregations:["_defaultFilterBar","filterBar"]});this._oObserver.observe(this,{properties:["filterFields"]});a.getInstance().defaultProviderRegistry.attach(this,l.Transient);this.resetListBinding()};u.prototype.resetListBinding=function(){return this._addPromise("listBinding")};u.prototype.awaitListBinding=function(){return this._retrievePromise("listBinding")};u.prototype.resolveListBinding=function(){const e=this.getListBinding?.();if(e){this._resolvePromise("listBinding",e);this._updateBasicSearchField();return e}};u.prototype.handleFilterValueUpdate=function(e){if((this.isContainerOpening()||this.isContainerOpen())&&this._bContentBound){Promise.resolve(this.applyFilters()).finally(()=>{i.prototype.handleFilterValueUpdate.call(this,e)})}};u.prototype.applyFilters=function(){};u.prototype.getItemFromContext=function(e,t){const i=t&&t.keyPath||this.getKeyPath();const n=t&&t.descriptionPath||this.getDescriptionPath();let r;let o;if(!i){throw new Error("KeyPath missing")}if(e){r=i?e.getProperty(i):undefined;o=n?e.getProperty(n):undefined}if(r===null||r===undefined){return false}const s=this.createConditionPayload([r,o],e);return{key:r,description:o,payload:s}};u.prototype.createConditionPayload=function(e,t){let i;const n=this.getValueHelpDelegate();if(n){const r=this.getValueHelpInstance();i={};i=n.createConditionPayload(r,this,e,t)}return i};u.prototype._isContextSelected=function(e,t){return!!e&&!!this._findConditionsForContext(e,t).length};u.prototype._findConditionsForContext=function(e,t){const i=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();if(e&&i){if(i.isFilterableListItemSelected){d.warning("MDC.ValueHelp","Delegate method 'isFilterableListItemSelected' is deprecated, please implement 'findConditionsForContext' instead.");const n=i.isFilterableListItemSelected(this.getValueHelpInstance(),this,{getBindingContext:function(){return e}},t);if(n){const i=this.getItemFromContext(e);const n=i&&this.createCondition(i.key,i.description,i.payload);return t.filter(e=>p.compareConditions(e,n))}return[]}return i.findConditionsForContext(this.getValueHelpInstance(),this,e,t)}return[]};u.prototype._createDefaultFilterBar=function(){return t(["sap/ui/mdc/valuehelp/FilterBar"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=new t(this.getId()+"-FB",{liveMode:false,showGoButton:true});this.setAggregation("_defaultFilterBar",i,true);return i})};u.prototype._handleSearch=function(e){const t=e.getSource();this._setLocalFilterValue(t.getSearch());this.applyFilters()};u.prototype._updateBasicSearchField=function(){const e=this.getActiveFilterBar();if(e){const i=e.getBasicSearchField();let n=this.isSearchSupported();let r="$search";if(!this.isPropertyInitial("filterFields")){r=this.getFilterFields();n=!!r}if(!i&&n){if(!this._oSearchField){return t(["sap/ui/mdc/FilterField"]).then(t=>{if(!this.isDestroyStarted()&&!e.isDestroyed()){const e=t[0];this._oSearchField=new e(this.getId()+"-search",{conditions:"{$filters>/conditions/"+r+"}",propertyKey:r,dataType:"sap.ui.model.type.String",placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"});this._oSearchField._bCreatedByValueHelp=true;this._updateBasicSearchField()}})}e.setBasicSearchField(this._oSearchField)}else if(i){if(n){}else if(i._bCreatedByValueHelp){e.setBasicSearchField()}}}};u.prototype.onContainerClose=function(){this._setLocalFilterValue(undefined)};u.prototype.getActiveFilterBar=function(){return this.getFilterBar()||this.getAggregation("_defaultFilterBar")};u.prototype.observeChanges=function(e){if(e.object==this){let t;if(["_defaultFilterBar","filterBar"].indexOf(e.name)!==-1){t=e.child;let i;if(e.mutation==="insert"){this._updateBasicSearchField();this._assignCollectiveSearchSelect()}else{const n=t.getBasicSearchField();if(n&&n._bCreatedByValueHelp){t.setBasicSearchField()}if(e.name==="filterBar"){i=this.getAggregation("_defaultFilterBar");if(!i){this._createDefaultFilterBar()}}}}if(e.name==="filterFields"){this._updateBasicSearchField()}}i.prototype.observeChanges.apply(this,arguments)};u.prototype.getCollectiveSearchKey=function(){return this._oCollectiveSearchSelect&&this._oCollectiveSearchSelect.getSelectedItemKey()};u.prototype.getListBindingInfo=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.")};u.prototype._getListItemBindingContext=function(e){const t=this.getListBindingInfo().model;return e&&e.getBindingContext(t)};u.prototype.getInitialFocusedControl=function(){return this.getActiveFilterBar().getInitialFocusedControl()};u.prototype._getTypesForConditions=function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();return t?t.getTypesForConditions(i,this,e):{}};u.prototype.getFormattedTitle=function(e){let t=i.prototype.getFormattedTitle.apply(this,arguments);if(!t){t=this._oResourceBundle.getText(e?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[e])}return t};u.prototype.getFormattedShortTitle=function(){let e=this.getShortTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.Shorttitle")}return e};u.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.TokenizerTitle"+(e===0?"NoCount":""),[e])}return t};u.prototype.isSearchSupported=function(){if(!this.isPropertyInitial("filterFields")){const e=this.getFilterFields();if(e!=="$search"){return!!e}}return!!this.isValueHelpDelegateInitialized()&&!!this.getValueHelpDelegate()?.isSearchSupported(this.getValueHelpInstance(),this,this.getListBinding())};u.prototype.setCollectiveSearchSelect=function(e){this._oCollectiveSearchSelect=e;this._assignCollectiveSearchSelect()};u.prototype._assignCollectiveSearchSelect=function(){const e=this.getActiveFilterBar();if(e.setCollectiveSearch){e.setCollectiveSearch(this._oCollectiveSearchSelect)}};u.prototype.onBeforeShow=function(e){const t=this.getActiveFilterBar();if(t&&!t._bAttached){t.attachSearch(this._handleSearch,this);t._bAttached=true}if(e){this._updateBasicSearchField();const i=this.getValueHelpDelegate();return Promise.resolve(i&&i.getFilterConditions(this.getValueHelpInstance(),this)).then(i=>{this._oInitialFilterConditions=i;if(t){let i="$search";if(!this.isPropertyInitial("filterFields")){i=this.getFilterFields()}const n=c({},this._oInitialFilterConditions);const r=Promise.resolve(!n[i]&&h.retrieveExternalState(t).then(r=>{if(e){f(n,i,this.getSearch());return h.diffState(t,r,{filter:n})}})).then(e=>h.applyExternalState(t,e));t.cleanUpAllFilterFieldsInErrorState();return r.then(()=>t.awaitPendingModification())}})}return Promise.resolve()};u.prototype.onHide=function(){i.prototype.onHide.apply(this,arguments);const e=this.getActiveFilterBar();if(e?._bAttached){e.detachSearch(this._handleSearch,this);e._bAttached=false}};u.prototype._fireSelect=function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=t&&t.modifySelectionBehaviour?t.modifySelectionBehaviour(i,this,e):e;if(n){this.fireSelect(n)}};u.prototype.exit=function(){a.getInstance().defaultProviderRegistry.detach(this);s.cleanup(this,["_oCollectiveSearchSelect","_oInitialFilterConditions"]);if(this._oSearchField&&!this._oSearchField.getParent()){this._oSearchField.destroy();delete this._oSearchField}i.prototype.exit.apply(this,arguments)};u.prototype.getCount=function(e,t){const n=this.isValueHelpDelegateInitialized()&&this.getValueHelpDelegate();const r=n&&this.getValueHelpInstance();return n&&n.getCount?n.getCount(r,this,e,t):i.prototype.getCount.apply(this,arguments)};u.prototype._getLocalFilterValue=function(){const e=this.getParent();return e&&e.getLocalFilterValue()};u.prototype._setLocalFilterValue=function(e){const t=this.getParent();return t&&t.setLocalFilterValue(e)};u.prototype.getSearch=function(){const e=this._getLocalFilterValue();if(typeof e!=="undefined"){return e}return this.getFilterValue()};u.prototype.getSelectableConditions=function(){return this.getConditions().filter(e=>e.validated===r.Validated)};u.prototype.clone=function(e,t){const n=this.getActiveFilterBar();const r=n?._bAttached;if(r){n.detachSearch(this._handleSearch,this);n._bAttached=false}const o=i.prototype.clone.apply(this,arguments);if(r){n.attachSearch(this._handleSearch,this);n._bAttached=true}return o};function f(e,t,i){e[t]=i?[n.createCondition(o.Contains,[i],undefined,undefined,r.NotValidated)]:[];return}return u});
//# sourceMappingURL=FilterableListContent.js.map