/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/Content","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/util/Common"],(e,t,i,n,o,l)=>{"use strict";const s=t.extend("sap.ui.mdc.valuehelp.content.Conditions",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],properties:{label:{type:"string"}},aggregations:{},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{}}});s.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")};s.prototype.exit=function(){l.cleanup(this,["_oScrollContainer","_oDefineConditionPanel"]);t.prototype.exit.apply(this,arguments)};s.prototype.getContent=function(){return this._retrievePromise("content",()=>{const e=["sap/ui/mdc/valuehelp/base/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"];if(this.provideScrolling()){e.push("sap/m/ScrollContainer")}return i(e).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=e[1];const n=e.length>2&&e[2];this._oManagedObjectModel=new i(this);this._oDefineConditionPanel=new t(this.getId()+"-DCP",{label:"{$help>/label}",conditions:"{$help>/conditions}",inputOK:"{$valueHelp>/_valid}",config:{path:"$help>/config"},conditionProcessed:a.bind(this),valueHelp:this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}).setModel(this._oManagedObjectModel,"$help");if(n){this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true,content:[this._oDefineConditionPanel]});this.setAggregation("displayContent",this._oScrollContainer);return this._oScrollContainer}else{this.setAggregation("displayContent",this._oDefineConditionPanel);return this._oDefineConditionPanel}})})};s.prototype.getCount=function(e){let t=0;for(const i of e){if(i.isEmpty!==true&&i.validated===o.NotValidated){t++}}return t};s.prototype.getUseAsValueHelp=function(){return false};s.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};s.prototype.isFocusInHelp=function(){return true};s.prototype.getInitialFocusedControl=function(){return this._oDefineConditionPanel.getInitialFocusedControl()};s.prototype.getRequiresTokenizer=function(){return true};s.prototype.getFormattedTitle=function(e){let i=t.prototype.getFormattedTitle.apply(this,arguments);if(!i){i=this._oResourceBundle.getText(e?"valuehelp.DEFINECONDITIONS":"valuehelp.DEFINECONDITIONSNONUMBER",[e])}return i};s.prototype.getFormattedShortTitle=function(){let e=this.getShortTitle();if(!e){e=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.Shorttitle")}return e};s.prototype.getFormattedTokenizerTitle=function(e){let t=this.getTokenizerTitle();if(!t){t=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.TokenizerTitle"+(e===0?"NoCount":""),[e])}return t};s.prototype.getAriaAttributes=function(e){return{contentId:this.getId()+"-DCP",ariaHasPopup:"dialog",roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};s.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{showArrow:true,showHeader:true,getContentWidth:function(){return"500px"},getFooter:function(){return this._retrievePromise("footer",()=>i(["sap/m/library","sap/m/Button"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const{ButtonType:i}=t;const n=e[1];const o=new n(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:i.Emphasized,press:r.bind(this)});const l=new n(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.fireCancel.bind(this)});return[o,l]}))}.bind(this)}}};s.prototype.onContainerClose=function(){if(this._oDefineConditionPanel){this._oDefineConditionPanel.cleanUp()}};function r(e){this.fireConfirm({close:true})}function a(e){let t=this.getConditions();if(this.getMaxConditions()===1){t=t.filter(e=>e.validated==="NotValidated")}this.fireSelect({type:n.Set,conditions:t})}return s});
//# sourceMappingURL=Conditions.js.map