/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/ParseException","sap/base/util/deepEqual"],(t,e,i,s,n,o,a,l)=>{"use strict";const r=e.extend("sap.ui.mdc.valuehelp.content.FixedList",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],properties:{groupable:{type:"boolean",group:"Appearance",defaultValue:false},filterList:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.valuehelp.content.FixedListItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{}}});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oResourceBundle=t.getResourceBundleFor("sap.ui.mdc");this._iNavigateIndex=-1};r.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}e.prototype.exit.apply(this,arguments)};r.prototype.getContent=function(){return this._retrievePromise("content",()=>i(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/base/ManagedObjectModel","sap/base/strings/whitespaceReplacer"]).then(t=>{if(this.isDestroyStarted()){return null}const e=t[0];const i=t[1];const s=t[2];const n=t[3];const o=t[4];const a=t[5];const l=t[6];this._oManagedObjectModel=new a(this);const r=new i(this.getId()+"-item",{type:s.ListType.Active,label:{path:"$help>text",formatter:l},value:{path:"$help>additionalText",formatter:l},valueTextDirection:"{$help>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");const c=new n({path:"text",test:p.bind(this),caseSensitive:true});let h;if(this.getGroupable()){h=new o("groupKey",false,f.bind(this))}const d=new e(this.getId()+"-List",{width:"100%",showNoData:false,mode:s.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$help>/items",template:r,filters:c,sorter:h,templateShareable:false},itemPress:u.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");d.applyAriaRole("listbox");d.setModel(this._oManagedObjectModel,"$help");this.setAggregation("displayContent",d,true);m.call(this);return d}))};r.prototype._handleFirstMatchSuggest=function(){const t=this.isTypeahead();const e=c.call(this)?.getItems();const i=this.getFilterValue();const s=this.getUseFirstMatch();if(t&&s&&e?.length&&i){const t=this.getValueHelpDelegate();const s=t.isFilteringCaseSensitive(this.getValueHelpInstance(),this);const n=t.getFirstMatch(this.getValueHelpInstance(),this,{value:this.getFilterValue(),checkDescription:!!this.getDescriptionPath(),control:this.getControl(),caseSensitive:s});if(n){const t=e.find(t=>t.getBindingContext("$help")===n);const o=y.call(this,t);const a=this.createCondition(v.call(this,o),F.call(this,o));const l=this.getListBinding()?.getCurrentContexts();const r=l?.length;this.fireTypeaheadSuggested({condition:a,filterValue:i,itemId:t?.getId(),items:r,caseSensitive:s})}}};function c(){return this.getAggregation("displayContent")}function u(t){const e=t.getParameter("listItem");const i=e.getSelected();if(i){const t=y.call(this,e);const i=v.call(this,t);const s=F.call(this,t);h.call(this,i,s);this.fireSelect({type:o.Set,conditions:this.getConditions()});this.fireConfirm()}}function h(t,e){const i=this.createCondition(t,e);const s=this.getConditions();if(l([i],s)){m.call(this)}else{this.setProperty("conditions",[i],true)}return i}function p(t){const e=this.getFilterList();return!e||d.call(this,t,this.getFilterValue())}function d(t,e){return!e||typeof e==="string"&&(this.getCaseSensitive()?t.startsWith(e):t.toLowerCase().startsWith(e.toLowerCase()))}function g(){const t=c.call(this);const e=this.getListBinding();if(this._iNavigateIndex>=0){this.setProperty("conditions",[],true);this._iNavigateIndex=-1;t.setFakeFocus()}if(t){e.update();t.updateItems();t.invalidate();this._handleFirstMatchSuggest();m.call(this)}}function f(t){const e=t.getProperty("groupKey");const i=t.getProperty("groupText");return{key:e,text:i}}function m(){const t=c.call(this);if(t){const e=this.getConditions();let i;let o=false;const a=this.getParent().isOpen();if(e.length>0&&(e[0].validated===s.Validated||e[0].operator===n.EQ)){i=e[0].values[0]}const l=t.getItems();l.forEach((s,n)=>{if(s.isA("sap.m.DisplayListItem")){const n=y.call(this,s);if(e.length>0&&v.call(this,n)===i){s.setSelected(true);if(a&&!s.hasStyleClass("sapMLIBFocused")){t.setFakeFocus(s)}}else if(e.length===0&&this._iNavigateIndex<0&&!o&&this._sHighlightId===s.getId()){s.setSelected(true);o=true}else{s.setSelected(false);if(a&&s.hasStyleClass("sapMLIBFocused")){t.setFakeFocus()}}}})}}function y(t){return this._oManagedObjectModel.getProperty(t.getBindingContextPath())}function I(t){return this._oManagedObjectModel.getProperty(t.getPath())}function v(t){const e=t.getBinding("key");if(e){return e.getInternalValue()}else{return t.getKey()}}function F(t){const e=t.getBinding("text");if(e){return e.getInternalValue()}else{return t.getText()}}r.prototype.getItemForValue=function(t){return this.getContent().then(()=>{if(t.value===null||t.value===undefined){return null}else if(!t.value&&t.checkDescription){return null}const e=this.getItems();let i;let s=0;let n;let o;for(s=0;s<e.length;s++){i=e[s];n=v.call(this,i);o=F.call(this,i);if(t.checkKey&&l(n,t.parsedValue)||t.checkDescription&&(l(o,t.parsedDescription)||i.getText()===t.value)){return{key:n,description:o}}}if(t.checkKey&&t.value===""){return null}if(this.getUseFirstMatch()&&!t.exactMatch){const e=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this,t);if(e){return this.getItemFromContext(e)}}const r=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[t.value]);const c=t.exception||a;throw new c(r)})};r.prototype.getItemFromContext=function(t,e){const i=I.call(this,t);const s=v.call(this,i);const n=F.call(this,i);return{key:s,description:n}};r.prototype.isValidationSupported=function(t){return true};r.prototype.isSearchSupported=function(){return true};r.prototype.handleConditionsUpdate=function(t){if(this._iNavigateIndex>=0&&!this._bConditionSetByNavigate){const t=this.getConditions();const e=c.call(this);const i=e.getSelectedItem();const s=i&&y.call(this,i);if(t.length!==1||!v.call(this,s)===t[0].values[0]){this._iNavigateIndex=-1}}m.call(this)};r.prototype.handleFilterValueUpdate=function(t){g.call(this);e.prototype.handleFilterValueUpdate.apply(this,arguments)};r.prototype.removeVisualFocus=function(){const t=c.call(this);t?.removeStyleClass("sapMListFocus")};r.prototype.setVisualFocus=function(){const t=c.call(this);if(!t?.hasStyleClass("sapMListFocus")){t?.addStyleClass("sapMListFocus")}};r.prototype.navigate=function(t){const e=c.call(this);if(!e){return}const i=e.getItems();const s=i.length;const n=this._iNavigateIndex>=0?i[this._iNavigateIndex]:e.getSelectedItem();let o=0;const a=this.getFilterList();const l=this.getFilterValue();let r=false;const u=this.getParent().isOpen();if(!a&&!n){let e=0;if(t>=0){for(e=0;e<i.length;e++){if(!i[e].isA("sap.m.GroupHeaderListItem")&&d.call(this,i[e].getLabel(),l)){o=e;break}}}else{for(e=i.length-1;e>=0;e--){if(!i[e].isA("sap.m.GroupHeaderListItem")&&d.call(this,i[e].getLabel(),l)){o=e;break}}}}else if(n){o=e.indexOfItem(n);o=o+t}else if(t>=0){o=t-1}else{o=s+t}if(t===9999){o=s-1}if(t===-9999){o=0}let p;if(o<0){o=0;p=true;r=true}else if(o>=s-1){o=s-1;p=false}else{p=t>=0}const g=function(){while(i[o]&&i[o].isA("sap.m.GroupHeaderListItem")){if(p){o++}else{o--}}};if(!u||t===0){g();if(o<0||o>s-1){p=!p;r=o<0;o=o<0?0:s-1;g()}}const f=i[o];if(f){const t=this.getUseFirstMatch();if(f!==n||t&&!r||this._iNavigateIndex!==o&&!r){let t,i,s;this._iNavigateIndex=o;if(u){e.scrollToIndex(o);e.setFakeFocus(f)}if(f.isA("sap.m.GroupHeaderListItem")){this._bConditionSetByNavigate=true;this.setProperty("conditions",[],true);delete this._bConditionSetByNavigate;this.fireNavigated({condition:undefined,itemId:f.getId(),leaveFocus:false})}else{t=y.call(this,f);i=v.call(this,t);s=F.call(this,t);this._bConditionSetByNavigate=true;const e=h.call(this,i,s);delete this._bConditionSetByNavigate;const n=this.getValueHelpDelegate();const o=n.isFilteringCaseSensitive(this.getValueHelpInstance(),this);this.fireNavigated({condition:e,itemId:f.getId(),leaveFocus:false,caseSensitive:o})}if(u){this.setVisualFocus();this.fireVisualFocusSet()}}else if(r){this._iNavigateIndex=-1;this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:r})}}};r.prototype.onShow=function(t){return e.prototype.onShow.apply(this,arguments).then(()=>{const t=c.call(this);let e;if(!t){return null}const i=t.getSelectedItem();if(i){const s=t.indexOfItem(i);t.scrollToIndex(s);e=i.getId()}const s=this.getListBinding()?.getCurrentContexts();const n=s?.length;return{itemId:e,items:n}})};r.prototype.onHide=function(){this.removeVisualFocus();const t=c.call(this);t?.setFakeFocus();this._iNavigateIndex=-1};r.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};r.prototype.getAriaAttributes=function(t){return{contentId:this.getId()+"-List",ariaHasPopup:"listbox",roleDescription:null,valueHelpEnabled:false,autocomplete:this.getUseFirstMatch()?"both":"none"}};r.prototype.shouldOpenOnClick=function(){return!this.getFilterList()};r.prototype.isFocusInHelp=function(){return false};r.prototype.isSingleSelect=function(t){return true};r.prototype.isNavigationEnabled=function(t){return this.getItems().length>0};r.prototype.onConnectionChange=function(){this._iNavigateIndex=-1};r.prototype.getListBinding=function(){const t=c.call(this);return t&&t.getBinding("items")};r.prototype.getKeyPath=function(){return"key"};r.prototype.getDescriptionPath=function(){return"text"};r.prototype.setHighlightId=function(t){if(this._sHighlightId!==t){this._sHighlightId=t;m.call(this)}};r.prototype.destroyItems=function(){const t=c.call(this);t?.destroyItems();return this.destroyAggregation("items")};return r});
//# sourceMappingURL=FixedList.js.map