/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/util/Common","sap/base/Log","sap/ui/core/library","sap/ui/core/Element","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/mdc/enums/TableRowCountMode","sap/base/util/restricted/_throttle","sap/ui/mdc/util/DensityHelper"],(e,t,i,o,n,s,l,a,r,h,p,c)=>{"use strict";const{TitleLevel:u}=n;const d=e.extend("sap.ui.mdc.valuehelp.content.MDCTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContent"],properties:{forceBind:{type:"boolean",defaultValue:false}},aggregations:{table:{type:"sap.ui.mdc.Table",multiple:false}},events:{},defaultAggregation:"table"}});d.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._bRebindTable=false};d.prototype._setTableSelectionState=function(){this._bSelectionIsUpdating=true;const e=this._getAllCurrentContexts();if(e){this._oTable._setSelectedContexts(e.filter(e=>this._isContextSelected(e,this.getConditions())))}this._bSelectionIsUpdating=false};d.prototype.handleConditionsUpdate=function(e){if(!this._bIgnoreNextConditionChange){this._setTableSelectionState()}else{this._bIgnoreNextConditionChange=false}};d.prototype._handleUpdateFinished=function(e){if(this._oTable){this.resolveListBinding();if(!this._bQueryingContexts){this._setTableSelectionState()}}};d.prototype._handleUpdateFinishedThrottled=p(d.prototype._handleUpdateFinished,100,{leading:false});d.prototype.observeChanges=function(t){if(t.name==="table"){const e=t.child;if(t.mutation==="remove"){b.call(this,this._oTable);this._oTable=null;this.resetListBinding()}else{this._oTable=e;c.syncDensity(this._oTable);this.resolveListBinding();if(this._oTable.getAutoBindOnInit()){o.warning("Usage of autobound tables may lead to unnecessary requests.")}else if(this.getForceBind()){this._bRebindTable=true}e.addDelegate({onmouseover:function(e){const t=s.closestTo(e.target);if(t&&t.isA("sap.m.ColumnListItem")){t.setType("Active")}}})}return}e.prototype.observeChanges.apply(this,arguments)};d.prototype._getAllCurrentContexts=function(){const e=this._oTable&&this._oTable.getRowBinding();if(e){return e.getAllCurrentContexts?e.getAllCurrentContexts():e.getContexts()}return undefined};d.prototype._handleSelectionChange=function(e){if(!this._bSelectionIsUpdating){this._bQueryingContexts=true;const e=this._getAllCurrentContexts();const t=e&&this._oTable.getSelectedContexts();this._bQueryingContexts=false;if(e){const i=this.getConditions();let o=i;let n=false;e.forEach(e=>{const s=this._findConditionsForContext(e,i);const l=!!s.length;const a=t.indexOf(e)>=0;if(!l&&a){const t=this.getItemFromContext(e);const i=t&&this.createCondition(t.key,t.description,t.payload);o=this.isSingleSelect()?[i]:o.concat(i);n=true}else if(l&&!a){o=o.filter(e=>s.indexOf(e)===-1);n=true}});if(n){this._prepareSelect(o,r.Set)}}}};d.prototype._prepareSelect=function(e,t){let i=typeof t==="string"&&t;i=i||(t?r.Add:r.Remove);this._bIgnoreNextConditionChange=true;this._fireSelect({type:i,conditions:e})};d.prototype._getTable=function(){return this._oTable};d.prototype.getContent=function(){return this._retrievePromise("wrappedContent",()=>t(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/ScrollContainer"]).then(e=>{if(this.isDestroyStarted()){return null}const t=e[0];const i=e[1];const o=e[2];if(!this._oContentLayout){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox",{visible:"{$this>/_filterBarVisible}"});this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){const e=this._oWrapper.getActiveFilterBar.call(this._oWrapper);const t=e?[e]:[];return t};this._oTableBox=new i(this.getId()+"-TB",{height:"100%"});this._oTableBox.addStyleClass("sapMdcValueHelpPanelTableBox");this._oTableBox._oWrapper=this;this._oTableBox.getItems=function(){const e=this._oWrapper._oTable._isOfType(a.ResponsiveTable)?this._oWrapper._oScrollContainer:this._oWrapper._oTable;const t=e?[e]:[];return t};this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTableBox});this._oScrollContainer=new o(this.getId()+"-SC",{height:"calc(100% - 0.5rem)",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e}}this.setAggregation("displayContent",this._oContentLayout);if(!this.getActiveFilterBar()){return this._createDefaultFilterBar().then(()=>{this._oFilterBarVBox.invalidate();return this._oContentLayout})}return this._oContentLayout}))};d.prototype.getListBinding=function(){const e=this.getTable();return e&&e.getRowBinding()};d.prototype._configureTable=function(){if(this._oTable){const t=e.prototype.isSingleSelect.apply(this);const i=this._oTable._getType();const o=this.getActiveFilterBar();if(o&&this._oTable.getFilter()!==o.getId()){this._oTable.setFilter(o)}if(!this._oTable.getHeader()){this._oTable.setHeader(this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER"))}if(this._oTable.isPropertyInitial("headerLevel")){this._oTable.setHeaderLevel(u.H2)}if(this._oTable.isPropertyInitial("headerStyle")){this._oTable.setHeaderStyle(u.H5)}const n=t?l.SingleMaster:l.Multi;if(this._oTable.getSelectionMode()===l.None){this._oTable.setSelectionMode(n)}if(this._oTable.getSelectionMode()!==n){throw new Error("Table selectionMode needs to be "+n)}const s=this._oTable._isOfType(a.Table);if(s){const e=i.getRowCountMode();if(e===h.Auto){i.setRowCount(3)}}}};d.prototype.onShow=function(){return e.prototype.onShow.apply(this,arguments)};d.prototype.onBeforeShow=function(t){this._configureTable();return Promise.resolve(e.prototype.onBeforeShow.apply(this,arguments)).then(()=>{const e=this.getTable();if(e){this._oTable.initialized().then(()=>{_.call(this,this._oTable)});const i=e.isTableBound();const o=i&&e._oTable.getShowOverlay();if(this._bRebindTable||o){e.rebind();this._bRebindTable=false}else if(t){if(e._isOfType(a.ResponsiveTable)){this._oScrollContainer.scrollTo(0,0)}else if(i){e.scrollToIndex(0)}}}})};d.prototype.onHide=function(){e.prototype.onHide.apply(this,arguments);if(this._oTable){b.call(this,this._oTable)}};d.prototype.getScrollDelegate=function(){if(!this.isTypeahead()&&this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return e.prototype.getScrollDelegate.apply(this,arguments)};d.prototype.isQuickSelectSupported=function(){return true};d.prototype.setParent=function(t){e.prototype.setParent.apply(this,arguments)};d.prototype.isSingleSelect=function(){if(this._oTable){if(this._oTable.getSelectionMode()===l.Multi){return false}else{return true}}else{return e.prototype.isSingleSelect.apply(this,arguments)}};d.prototype.clone=function(t,i){const o=this._oTable?._bAttached;if(o){b.call(this,this._oTable)}const n=e.prototype.clone.apply(this,arguments);if(o){_.call(this,this._oTable)}return n};function _(e){if(!e._bAttached){e.attachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);e.attachEvent("selectionChange",this._handleSelectionChange,this);e._bAttached=true}}function b(e){if(e._bAttached){e.detachEvent("_bindingChange",this._handleUpdateFinishedThrottled,this);e.detachEvent("selectionChange",this._handleSelectionChange,this);e._bAttached=false}}d.prototype.exit=function t(o){i.cleanup(this,["_oContentLayout","_oFilterBarVBox","_oTableBox","_oResourceBundle","_oScrollContainer","_oTableHelper","_bSelectionIsUpdating","_sTableType","_oUITableSelectionPlugin","_oTable","_bRebindTable","_mKnownContexts","_bIgnoreNextConditionChange","_bQueryingContexts"]);e.prototype.exit.apply(this,arguments)};return d});
//# sourceMappingURL=MDCTable.js.map