/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/util/loadModules","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/mdc/util/Common","sap/base/strings/formatMessage","sap/base/util/merge","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/Log","sap/ui/core/Element","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/m/table/Util"],(e,t,i,s,n,o,a,l,h,r,c,d,g,u,p,f,_)=>{"use strict";const{ListMode:m}=n;const{Sticky:I}=n;const S=t.extend("sap.ui.mdc.valuehelp.content.MTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.base.ITypeaheadContent","sap.ui.mdc.valuehelp.base.IDialogContent"],aggregations:{table:{type:"sap.m.Table",multiple:false}},events:{contentUpdated:{}},defaultAggregation:"table"}});S.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oMResourceBundle=e.getResourceBundleFor("sap.m");this._iNavigateIndex=-1;this._sHighlightId=undefined;this._bAnnounceTableUpdate=false};S.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};function y(){const e=this._getTable();if(e){const i=e.getItems();const s=this.getConditions();const n=this.isSingleSelect()&&!t.prototype.isSingleSelect.apply(this);const o=this.getParent().isOpen();i.forEach(t=>{const i=this._getListItemBindingContext(t);if(n&&e.indexOfItem(t)!==this._iNavigateIndex){t.setSelected(false)}else{t.setSelected(this._isContextSelected(i,s))}if(this.isTypeahead()){if(this.isSingleSelect()){if(e.indexOfItem(t)===this._iNavigateIndex||t.getSelected()&&(!this._sHighlightId||t.getId()===this._sHighlightId)){if(o&&!t.hasStyleClass("sapMLIBFocused")){e.setFakeFocus(t)}}else if(t.getId()===this._sHighlightId){t.addStyleClass("sapMLIBSelected").updateSelectedDOM(true,t.$())}else{if(o&&t.hasStyleClass("sapMLIBFocused")){e.setFakeFocus()}if((!t.getSelected()||this._sHighlightId&&t.getId()!==this._sHighlightId)&&t.hasStyleClass("sapMLIBSelected")){t.removeStyleClass("sapMLIBSelected").updateSelectedDOM(false,t.$())}}}}})}T.call(this)}function b(){if(!this._oUpdateSelectionPromise&&!this.isDestroyed()){this._oUpdateSelectionPromise=new Promise(e=>{this._iUpdateSelectionTimeout=setTimeout(()=>{if(!this.isDestroyed()){y.call(this)}e()},0)})}return this._oUpdateSelectionPromise}function T(){if(this._iUpdateSelectionTimeout){clearTimeout(this._iUpdateSelectionTimeout);this._iUpdateSelectionTimeout=null;delete this._oUpdateSelectionPromise}}S.prototype.onBeforeShow=function(e){return Promise.resolve(t.prototype.onBeforeShow.apply(this,arguments)).then(()=>{if(!this._bNavigateInitialize){const e=this._getTable();M.call(this,e)}if(e){const e=this.getListBinding();const t=this.getListBindingInfo();const i=e&&e.isSuspended();const s=!e&&t&&t.suspended;if((i||s)&&!this.isTypeahead()){return undefined}return this.applyFilters()}})};S.prototype.applyFilters=function(){this._bAnnounceTableUpdate=!this.isTypeahead()&&this.isContainerOpen();if(this._iNavigateIndex>=0&&this.getParent().isOpen()){this._iNavigateIndex=-1;this.removeVisualFocus();if(this.isSingleSelect()){this.setProperty("conditions",[],true)}}this._sHighlightId=undefined;const e=function(){if(!this.isDestroyed()){return this.applyFilters()}}.bind(this);const t=this.getListBinding();const i=this.isValueHelpDelegateInitialized();let s;if(!t||!i){s=Promise.all([this.awaitListBinding(),this.awaitValueHelpDelegate()]).then(e)}if(!i||!this.isTypeahead()&&!this.isContainerOpen()&&t.isSuspended()){return undefined}if(!s){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=this.getListBindingInfo();const o=n&&n.length;e.updateBindingInfo(i,this,n);e.updateBinding(i,t,n,this);s=Promise.resolve(e.checkListBindingPending(i,t,o))}this._addPromise("applyFilters",s);return s.finally(()=>{const e=this._retrievePromise("applyFilters");e?.getInternalPromise().then(e=>{this._handleFirstMatchSuggest(this._oTable.getItems())});return e&&e.getInternalPromise()})};S.prototype._handleSelectionChange=function(e){const t=this.isTypeahead();if(!t||!this.isSingleSelect()){const i=e.getParameters();const s=i.listItems||i.listItem&&[i.listItem];if(t&&s.length===1&&f(s[0].getDomRef(),document.activeElement)&&s[0].getDomRef()!==document.activeElement){s[0].focus()}const n=s.map(e=>{const t=this._getListItemBindingContext(e);const i=this.getItemFromContext(t);return i&&this.createCondition(i.key,i.description,i.payload)});this._fireSelect({type:i.selected?d.Add:d.Remove,conditions:n});if(t){this.fireConfirm()}}};S.prototype._handleItemPress=function(e){const t=e.getParameter("listItem");const i=this._getListItemBindingContext(t);const s=this.getItemFromContext(i);const n=this._getTable();const o=n.getMode()===m.SingleSelectMaster;const a=o?t.getSelected():!t.getSelected();t.setSelected(a);const l=a?d.Add:d.Remove;const h=this.createCondition(s.key,s.description,s.payload);this._fireSelect({type:l,conditions:[h]});if(this.isTypeahead()){this.fireConfirm({close:true})}};S.prototype._updateHeaderText=function(e){const t=this.getListBinding();if(!this.isTypeahead()&&this._oTablePanel&&t){const t=this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER");const i=this.getListBinding()?.getCount?.()||0;const s=i>0?this._oResourceBundle.getText("valuehelp.TABLETITLE",[i]):t;this._oTablePanel.setHeaderText(s);if(e&&this._bAnnounceTableUpdate){_.announceTableUpdate(t,i);this._bAnnounceTableUpdate=false}}};S.prototype._handleUpdateFinished=function(){if(this.getParent().isOpen()){this._updateHeaderText(true);b.apply(this).then(()=>{if(this._bScrollToSelectedItem){const e=this._getTable();if(e&&this.isTypeahead()&&this.isSingleSelect()){const t=this._iNavigateIndex>=0?e.getItems()[this._iNavigateIndex]:e.getSelectedItem();if(t){this._handleScrolling(t)}}this._bScrollToSelectedItem=false}})}};S.prototype._getTable=function(){return this._oTable};function v(e,t){return[m.SingleSelectMaster,...e?[]:[m.SingleSelectLeft],...t?[]:[m.MultiSelect]]}S.prototype.onShow=function(e){const i=this._getTable();if(i){if(!i.hasStyleClass("sapMComboBoxList")){i.addStyleClass("sapMComboBoxList")}const e=this.isTypeahead();const s=t.prototype.isSingleSelect.apply(this);const n=i.getMode();if(n===m.None){const t=e?m.SingleSelectMaster:m.SingleSelectLeft;i.setMode(s?t:m.MultiSelect)}else{const t=v(e,s);if(!t.includes(n)){throw new Error(`Table selection mode needs to be '${t.join("' or '")}'`)}}}this._updateHeaderText();return t.prototype.onShow.apply(this,arguments).then(e=>Promise.resolve(this._oUpdateSelectionPromise).then(()=>{const t=this.isSingleSelect();if(i&&this.isTypeahead()){if(t){let t;if(this._iNavigateIndex>=0){t=i.getItems()[this._iNavigateIndex]}else if(this._sHighlightId){t=i.getItems().find(e=>e.getId()===this._sHighlightId)}else{t=i.getSelectedItem()}if(t){this._handleScrolling(t);e.itemId=t.getId()}else{this._bScrollToSelectedItem=true;if(i.getItems().length===0&&i.getShowNoData()){e.itemId=i.getId("nodata-text")}}}e.items=w.call(this)}return e}))};S.prototype.onHide=function(){t.prototype.onHide.apply(this,arguments);const e=this.getTable();if(e){this.removeVisualFocus();e?.setFakeFocus();if(e.hasStyleClass("sapMComboBoxList")){e.removeStyleClass("sapMComboBoxList")}D.call(this,e)}this._iNavigateIndex=-1;this._bScrollToSelectedItem=false;this._sHighlightId=undefined};S.prototype.handleConditionsUpdate=function(e){if(this._iNavigateIndex>=0&&!this._bConditionSetByNavigate){const e=this.getConditions();const t=this._getTable();const i=t.getItems();const s=this._getListItemBindingContext(i[this._iNavigateIndex]);if(!this._isContextSelected(s,e)){this._iNavigateIndex=-1}}b.call(this)};S.prototype.getContent=function(){if(!this.isTypeahead()){return this._retrievePromise("wrappedContent",()=>s(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/Panel","sap/m/ScrollContainer","sap/ui/model/resource/ResourceModel"]).then(e=>{if(this.isDestroyStarted()){return null}const[t,i,s,n,o]=e;if(!this._oContentLayout&&!this.isDestroyed()){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox");this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper.getActiveFilterBar.call(this._oWrapper)]};if(!this.getModel("$i18n")){this.setModel(new o({bundleName:"sap/ui/mdc/messagebundle",async:true}),"$i18n")}this._oTablePanel=new s(this.getId()+"-TablePanel",{expanded:true,height:"100%",headerText:this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER")});this._oTablePanel.addStyleClass("sapMdcTablePanel");this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTablePanel});this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e};this._oTablePanel.addContent(this._oScrollContainer)}this.setAggregation("displayContent",this._oContentLayout);const a=this.getActiveFilterBar();if(!a){return this._createDefaultFilterBar().then(()=>this._oContentLayout)}return this._oContentLayout}))}return this._oTable};S.prototype.getItemForValue=function(e){if(!e.checkKey&&!e.checkDescription){return null}if(e.checkKey&&!e.hasOwnProperty("parsedValue")){throw new Error("MTable: Cannot check key without a given parsedValue! "+this.getId())}if(e.checkDescription&&!e.hasOwnProperty("parsedDescription")){throw new Error("MTable: Cannot check description without a given parsedDescription! "+this.getId())}if(e.checkKey&&!this.getKeyPath()){throw new Error("MTable: KeyPath missing! "+this.getId())}if(e.checkDescription&&!this.getDescriptionPath()){throw new Error("MTable: DescriptionPath missing! "+this.getId())}e.caseSensitive=e.caseSensitive||this.getCaseSensitive();const t=x.call(this);const i=this.getValueHelpDelegate();const s=this.getValueHelpInstance();const n=i&&i.getFilterConditions(s,this,e);return Promise.all([t,n]).then(t=>{const[i,s]=t;let n;if(!i){const t=this.getTable();if(!n){n=C.call(this,e,t.getItems(),s)}}if(!n){n=this._loadItemForValue(e,s)}return n})};function C(e,t,i){if(t.length===0){return}const s=function(e,t){const i=e.isA("sap.ui.model.Context")?e:this._getListItemBindingContext(e);return i&&i.getProperty(t)}.bind(this);let n;let o;const a=B.call(this,e,i);const h=l.apply(t,a,s);if(h.length===1||h.length>1&&this.getUseFirstMatch()){const e=this._getListItemBindingContext(h[0]);const t=this.getItemFromContext(e,{inParameters:n,outParameters:o});return{key:t.key,description:t.description,payload:t.payload}}else if(h.length>1){if(!e.caseSensitive){const s=c({},e);s.caseSensitive=true;return C.call(this,s,t,i)}throw F.call(this,e.exception,true,e.parsedValue||e.value)}}function B(e,t){const s=e.caseSensitive;const n=this.getKeyPath();const l=this.getDescriptionPath();const h=[];if(e.checkKey&&e.hasOwnProperty("parsedValue")){h.push(new o({path:n,operator:a.EQ,value1:e.parsedValue,caseSensitive:s}))}if(e.checkDescription){if(e.hasOwnProperty("parsedDescription")&&e.parsedDescription!==undefined){h.push(new o({path:l,operator:a.EQ,value1:e.parsedDescription,caseSensitive:s}))}else if(e.value){h.push(new o({path:l,operator:a.EQ,value1:e.value,caseSensitive:s}))}}let r=h.length>1?new o({filters:h,and:false}):h[0];if(r&&t){const e=this._getTypesForConditions(t);const s=i.createFilters(t,e,undefined,this.getCaseSensitive());if(s){r=new o({filters:[r,s],and:true})}}return r}function x(){return this.awaitListBinding().then(e=>{const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const s=this.getListBindingInfo();const n=s&&s.length;if(e&&t){return t.checkListBindingPending(i,e,n)}else{return true}})}S.prototype.getListBinding=function(){const e=this._getTable();return e&&e.getBinding("items")};S.prototype.getListBindingInfo=function(){const e=this._getTable();return e&&e.getBindingInfo("items")};S.prototype._loadItemForValue=function(e,t){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}const i=this.getKeyPath();const s=this.getDescriptionPath();const n=this.getUseFirstMatch();const o=this._getTable();const a=o&&o.getBinding("items");const l=a&&a.getPath();const h=this.getValueHelpDelegate();const r=this.getValueHelpInstance();const c=B.call(this,e,t);const d=a.getModel().bindList(l,a.getContext(),undefined,c);d.initialize();return h.executeFilter(r,d,2).then(t=>{const o=t.getContexts();setTimeout(()=>{d.destroy()},0);if(o.length&&(o.length<2||n)){return this.getItemFromContext(o[0],{keyPath:i,descriptionPath:s,inParameters:undefined})}else if(e.checkKey&&e.parsedValue===""&&o.length===0){return null}else{const t=F.call(this,e.exception,o.length>1,e.value);throw t}})};function F(e,t,i){let s;if(t){s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[i])}else{s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[i])}const n=new e(s);n._bNotUnique=t;return n}S.prototype.isValidationSupported=function(e){return true};S.prototype.navigate=function(e){const t=this.getParent().isOpen();if(!t&&this._iNavigateIndex<0&&!this._bNavigateInitialize){this._bNavigateInitialize=true;this.onBeforeShow(true).then(()=>{this.onShow(true).then(t=>{this.navigate(e)})});return}this._bNavigateInitialize=false;const i=this.getListBinding();if(!i||!i.getLength()){x.call(this).then(t=>{if(!t&&i.getLength()!==0){this.navigate(e)}});return}const s=this.isSingleSelect();const n=this._getTable();const o=n.getItems();const a=this._iNavigateIndex<0&&this._sHighlightId?o.findIndex(e=>e.getId()===this._sHighlightId):this._iNavigateIndex;const l=a>=0?o[a]:s&&n.getSelectedItem();const h=o.length;let r=0;let c=false;if(e===9999){r=h-1}else if(e===-9999){r=0}else if(l){r=o.indexOf(l);r=r+e}else if(e>=0){r=e-1}else{r=h+e}let d;let g=false;if(r<0){r=0;d=true;c=true}else if(r>=h-1){if(r>=h){g=true}r=h-1;d=false}else{d=e>=0}this.setHighlightId();if(!t){const e=function(){while(o[r]&&o[r].isA("sap.m.GroupHeaderListItem")){if(d){r++}else{r--}}};const t=()=>{const e=this.getConditions();while(o[r]&&this._isContextSelected(this._getListItemBindingContext(o[r]),e)){if(d){r++}else{r--}}};e();if(!s){t()}if(r<0||r>h-1){d=!d;c=r<0;r=r<0?0:h-1;e();if(!s){t()}}}else if(!s){if(o[r]){o[r].focus()}else{n.focus()}return}else if(g&&this._oShowAllItemsButton){if(l){l.setSelected(false);n.setFakeFocus();l.removeStyleClass("sapMLIBSelected")}this._iNavigateIndex=-1;this.setProperty("conditions",[],true);this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:false});this._oShowAllItemsButton.focus();return}const u=o[r];if(u){if(u!==l||this._iNavigateIndex!==r&&!c){let e;const i=[];const o=this.getValueHelpDelegate();const a=o.isFilteringCaseSensitive(this.getValueHelpInstance(),this);this._iNavigateIndex=r;if(t){this._handleScrolling(u);n.setFakeFocus(u);this.setVisualFocus();this.fireVisualFocusSet()}if(!u.isA("sap.m.GroupHeaderListItem")){const t=this._getListItemBindingContext(u);const s=this.getItemFromContext(t);e=s&&this.createCondition(s.key,s.description,s.payload);i.push(e)}if(s){this._bConditionSetByNavigate=true;this.setProperty("conditions",i,true);b.call(this);delete this._bConditionSetByNavigate}this.fireNavigated({condition:e,itemId:u.getId(),leaveFocus:false,caseSensitive:a})}else if(c){if(s){this._iNavigateIndex=-1}this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:c})}}};S.prototype.isNavigationEnabled=function(e){if(e===1||e===-1){if(e===1||e===-1&&(this.isSingleSelect()||!this.getParent().isOpen())){return true}else{return false}}else if(this.isSingleSelect()){const e=this.getListBinding();const t=this.getListBindingInfo();if((e?.isLengthFinal()||t.length)&&!e?.isSuspended()){return true}else{return false}}else{return false}};S.prototype._handleScrolling=function(e){const t=this.getScrollDelegate();if(t){const t=this._getTable();const i=!isNaN(e)?e:t.indexOfItem(e);t.scrollToIndex(i).catch(e=>{});return true}return false};S.prototype.getScrollDelegate=function(){if(this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return t.prototype.getScrollDelegate.apply(this,arguments)};S.prototype.removeVisualFocus=function(){const e=this.getTable();e?.removeStyleClass("sapMListFocus")};S.prototype.setVisualFocus=function(){const e=this.getTable();if(e&&this.isTypeahead()){if(this.isSingleSelect()){if(!e.hasStyleClass("sapMListFocus")){e.addStyleClass("sapMListFocus")}}else{e.focus()}}};S.prototype.getAriaAttributes=function(e){const t=this.getTable();const i=this.isTypeahead();const s=this.getUseAsValueHelp();let n=null;if(e!==1&&(i&&s||!i)){const e=P.apply(this);n=e.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION")}return{contentId:t&&t.getId(),ariaHasPopup:"listbox",roleDescription:n,valueHelpEnabled:!i,autocomplete:this.getUseFirstMatch()?"both":"none"}};S.prototype._handleFirstMatchSuggest=function(){const e=this.isTypeahead();const t=this._oTable?.getItems();const i=this.getFilterValue();const s=this.getUseFirstMatch();if(e&&s&&i&&!this._bNavigateInitialize){const e=this.getValueHelpDelegate();const s=e.isFilteringCaseSensitive(this.getValueHelpInstance(),this);let n;let o=0;if(t?.length){const i=this.getConditions();if(i.length===1&&this.isSingleSelect()){for(let e=0;e<t.length;e++){const s=this._getListItemBindingContext(t[e]);if(this._isContextSelected(s,i)){n=s;break}}}if(!n){n=e.getFirstMatch(this.getValueHelpInstance(),this,{value:this.getFilterValue(),checkDescription:!!this.getDescriptionPath(),control:this.getControl(),caseSensitive:this.getCaseSensitive()})}o=w.call(this)}if(n){const e=this.getItemFromContext(n);const a=this.createCondition(e.key,e.description,e.payload);const l=t.find(e=>this._getListItemBindingContext(e)===n);this.fireTypeaheadSuggested({condition:a,filterValue:i,itemId:l?.getId(),items:o,caseSensitive:s})}else{this.fireTypeaheadSuggested({condition:null,filterValue:i,itemId:null,items:o,caseSensitive:s})}}};function P(){if(!this._oResourceBundleM){this._oResourceBundleM=e.getResourceBundleFor("sap.m")}return this._oResourceBundleM}S.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{getContentHeight:function(){const e=this._getTable();const t=e&&e.getDomRef();return t&&Math.round(t.getBoundingClientRect().height)}.bind(this),getFooter:function(){return this._retrievePromise("footer",()=>this.awaitListBinding().then(e=>{const t=this.getListBindingInfo();const i=this.getParent().hasDialog();if(i&&t&&t.length&&!p.system.phone){return s(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(e=>{if(this.isDestroyStarted()){return null}const[t,i,s]=e;const n={onsapup(e){const t=this._getTable();if(t.getMode()===m.MultiSelect){const i=t.getItems();if(i.length>0){e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();this._bFocusTable=true;i[i.length-1].focus()}}else{e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();this.navigate(9999)}},onsapfocusleave(e){const t=e.relatedControlId&&u.getElementById(e.relatedControlId);const i=this.getParent();if(i&&t&&f(i.getDomRef(),t.getFocusDomRef())){e.stopPropagation();e.stopImmediatePropagation(true);e.preventDefault();const t=this._getTable();if(t.getMode()===m.MultiSelect){if(!this._bFocusTable){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true})}delete this._bFocusTable}else{this.navigate(-9999)}}}};this._oShowAllItemsButton=new t(this.getId()+"-showAllItems",{text:this._oMResourceBundle.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){this.fireRequestSwitchToDialog()}.bind(this)});this._oShowAllItemsButton.addDelegate(n,true,this);const o=[new s(this.getId()+"-Spacer")].concat(this._oShowAllItemsButton);const a=new i(this.getId()+"-TB",{content:o});return a})}}))}.bind(this)}}};function L(){if(this._oTable&&this.getParent()){const e=this._oTable.getSticky();if(!e||e.length===0){this._oTable.setSticky([I.ColumnHeaders])}}}S.prototype.setParent=function(e){t.prototype.setParent.apply(this,arguments);L.call(this)};S.prototype.observeChanges=function(e){if(e.name==="config"){L.call(this)}if(e.name==="items"&&e.mutation==="ready"){this.resolveListBinding()}if(e.name==="table"){this._sHighlightId=undefined;const t=e.child;if(e.mutation==="remove"){this._oObserver.unobserve(t);D.call(this,t);this._oTable=null;this._removePromise("footer");this.resetListBinding()}else{this._oTable=t;this._oTable.addStyleClass("sapMdcValueHelpMTable");L.call(this);if(!this.resolveListBinding()){this._oObserver.observe(e.child,{bindings:["items"]})}}}t.prototype.observeChanges.apply(this,arguments)};S.prototype._handleTableEvent=function(e){if(!this.isTypeahead()){return}const t=this._getTable();const i=u.closestTo(e.target);switch(e.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(t.indexOfItem(i)===0){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true)}}break;case"sapnext":if(i.isA("sap.m.ListItemBase")&&this._oShowAllItemsButton){const s=t.getItems();if(s.indexOf(i)===s.length-1){e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true);this._oShowAllItemsButton.focus()}}break;default:break}};S.prototype.isQuickSelectSupported=function(){return true};S.prototype.isSingleSelect=function(){const e=this._getTable();if(e&&e.getMode()!==m.None){if(e.getMode()===m.MultiSelect){return false}else{return true}}else{return t.prototype.isSingleSelect.apply(this,arguments)}};S.prototype.onConnectionChange=function(){this._sHighlightId=undefined;this._iNavigateIndex=-1};S.prototype.exit=function(){T.call(this);h.cleanup(this,["_sTableWidth","_oTable","_oScrollContainer","_oContentLayout","_oTablePanel","_oFilterBarVBox","_oMResourceBundle","_oResourceBundle","_oTableDelegate","_sHighlightId","_bAnnounceTableUpdate"]);t.prototype.exit.apply(this,arguments)};S.prototype.setHighlightId=function(e){if(this._sHighlightId!==e){this._sHighlightId=e;b.call(this)}};S.prototype.clone=function(e,i){const s=this._getTable();const n=s?._bAttached;if(n){D.call(this,s)}const o=t.prototype.clone.apply(this,arguments);if(n){M.call(this,s)}return o};function M(e){if(!e._bAttached){e.attachItemPress(this._handleItemPress,this);e.attachSelectionChange(this._handleSelectionChange,this);e.attachUpdateFinished(this._handleUpdateFinished,this);this._oTableDelegate=this._oTableDelegate||{onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};e.addDelegate(this._oTableDelegate,true,this);e._bAttached=true}}function D(e){if(e._bAttached){e.removeDelegate(this._oTableDelegate);this._oTable.detachItemPress(this._handleItemPress,this);this._oTable.detachSelectionChange(this._handleSelectionChange,this);this._oTable.detachUpdateFinished(this._handleUpdateFinished,this);e._bAttached=false}}function w(){const e=this.getListBinding();const t=this.getListBindingInfo();let i=e?.getCount();if(i===undefined&&(e?.isLengthFinal()||t.length)){const e=this.getListBinding().getCurrentContexts();i=e?.length}return i}return S});
//# sourceMappingURL=MTable.js.map