/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/EventProvider","./ChangeReason","./DataState","sap/base/Log","sap/base/util/each"],function(t,e,a,n,s){"use strict";var i;var r=[];var o=t.extend("sap.ui.model.Binding",{constructor:function(e,a,n,s){t.apply(this);this.oModel=e;this.bRelative=!a.startsWith("/");this.sPath=a;this.oContext=n;this.mParameters=s;this.bInitial=false;this.bSuspended=false;this.oDataState=null;this.bIgnoreMessages=undefined;this.bIsBeingDestroyed=undefined;this.bFiredAsync=undefined},metadata:{abstract:true,publicMethods:["getPath","getContext","getModel","attachChange","detachChange","refresh","isInitial","attachDataStateChange","detachDataStateChange","attachAggregatedDataStateChange","detachAggregatedDataStateChange","attachDataRequested","detachDataRequested","attachDataReceived","detachDataReceived","suspend","resume","isSuspended"]}});o.prototype.getPath=function(){return this.sPath};o.prototype.getContext=function(){return this.oContext};o.prototype.setContext=function(t,a){var n;if(this.oContext!=t){var s=sap.ui.require("sap/ui/core/Messaging");if(s){s.removeMessages(this.getDataState().getControlMessages(),true)}this.oContext=t;this.getDataState().reset();this.checkDataState();n={reason:e.Context};if(a&&a.detailedReason){n.detailedReason=a.detailedReason}this._fireChange(n)}};o.prototype.getDataState=function(){if(!this.oDataState){this.oDataState=new a}return this.oDataState};o.prototype.getModel=function(){return this.oModel};o.prototype.getResolvedPath=function(){return this.oModel?this.oModel.resolve(this.sPath,this.oContext):undefined};o.prototype.getIgnoreMessages=function(){if(this.bIgnoreMessages===undefined){return undefined}return this.bIgnoreMessages&&this.supportsIgnoreMessages()};o.prototype.setIgnoreMessages=function(t){this.bIgnoreMessages=t};o.prototype.supportsIgnoreMessages=function(){return false};o.prototype.attachChange=function(t,e){if(!this.hasListeners("change")){this.oModel.addBinding(this)}return this.attachEvent("change",t,e)};o.prototype.detachChange=function(t,e){this.detachEvent("change",t,e);if(!this.hasListeners("change")){this.oModel.removeBinding(this)}return this};o.prototype.attachDataStateChange=function(t,e){return this.attachEvent("DataStateChange",t,e)};o.prototype.detachDataStateChange=function(t,e){return this.detachEvent("DataStateChange",t,e)};o.prototype.attachAggregatedDataStateChange=function(t,e){return this.attachEvent("AggregatedDataStateChange",t,e)};o.prototype.detachAggregatedDataStateChange=function(t,e){return this.detachEvent("AggregatedDataStateChange",t,e)};o.prototype._fireChange=function(t){this.fireEvent("change",t)};o.prototype.attachDataRequested=function(t,e){return this.attachEvent("dataRequested",t,e)};o.prototype.detachDataRequested=function(t,e){return this.detachEvent("dataRequested",t,e)};o.prototype.fireDataRequested=function(t){this.fireEvent("dataRequested",t)};o.prototype.attachDataReceived=function(t,e){return this.attachEvent("dataReceived",t,e)};o.prototype.detachDataReceived=function(t,e){return this.detachEvent("dataReceived",t,e)};o.prototype.fireDataReceived=function(t){this.fireEvent("dataReceived",t)};o.prototype.updateRequired=function(t){return t&&this.getModel()===t};o.prototype.hasValidation=function(){return!!this.getType()};o.prototype.checkUpdate=function(t){if(this.bSuspended&&!t){return}this._fireChange({reason:e.Change})};o.prototype.refresh=function(t){if(this.bSuspended&&!t){return}this.checkUpdate(t)};o.prototype.initialize=function(){if(!this.bSuspended){this.checkUpdate(true)}return this};o.prototype._refresh=function(t){this.refresh(t)};o.prototype.isResolved=function(){return!this.bRelative||!!this.oContext};o.prototype.isInitial=function(){return this.bInitial};o.prototype.isRelative=function(){return this.bRelative};o.prototype.attachEvents=function(t){if(!t){return this}var e=this;s(t,function(t,a){var s="attach"+t.substring(0,1).toUpperCase()+t.substring(1);if(e[s]){e[s](a)}else{n.warning(e.toString()+" has no handler for event '"+t+"'")}});return this};o.prototype.detachEvents=function(t){if(!t){return this}var e=this;s(t,function(t,a){var s="detach"+t.substring(0,1).toUpperCase()+t.substring(1);if(e[s]){e[s](a)}else{n.warning(e.toString()+" has no handler for event '"+t+"'")}});return this};o.prototype.attachRefresh=function(t,e){return this.attachEvent("refresh",t,e)};o.prototype.detachRefresh=function(t,e){return this.detachEvent("refresh",t,e)};o.prototype._fireRefresh=function(t){this.fireEvent("refresh",t)};o.prototype.suspend=function(){this.bSuspended=true};o.prototype.isSuspended=function(){return this.bSuspended};o.prototype.resume=function(){this.bSuspended=false;this.checkUpdate()};o.prototype.destroy=function(){var e=this.oDataState;if(this.bIsBeingDestroyed){return}this.bIsBeingDestroyed=true;if(e){var a=sap.ui.require("sap/ui/core/Messaging");if(a){a.removeMessages(e.getControlMessages(),true)}e.setModelMessages();if(e.changed()){this.fireEvent("DataStateChange",{dataState:e});this.fireEvent("AggregatedDataStateChange",{dataState:e})}delete this.oDataState}t.prototype.destroy.apply(this,arguments)};o.prototype.isDestroyed=function(){return!!this.bIsBeingDestroyed};o.prototype.checkDataState=function(t){this._checkDataState(this.getResolvedPath(),t)};o.prototype._checkDataState=function(t,e){if(!e||t&&t in e){var a=this;var n=this.getDataState();var s=function(){a.fireEvent("AggregatedDataStateChange",{dataState:n});n.changed(false);a.bFiredAsync=false};if(!this.getIgnoreMessages()){this._checkDataStateMessages(n,t)}if(n&&n.changed()){if(this.mEventRegistry["DataStateChange"]){this.fireEvent("DataStateChange",{dataState:n})}if(this.bIsBeingDestroyed){s()}else if(this.mEventRegistry["AggregatedDataStateChange"]&&!this.bFiredAsync){h(s);this.bFiredAsync=true}}}};o.prototype._checkDataStateMessages=function(t,e){if(e){t.setModelMessages(this.oModel.getMessagesByPath(e))}else{t.setModelMessages([])}};function h(t){if(!i){i=setTimeout(function(){i=undefined;var t=r;r=[];t.forEach(function(t){t()})},0)}r.push(t)}return o});
//# sourceMappingURL=Binding.js.map