/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./FilterOperator","sap/base/Log","sap/base/i18n/Localization","sap/ui/base/Object"],function(t,e,r,i){"use strict";var a=i.extend("sap.ui.model.Filter",{constructor:function(r,s,o,l){i.call(this);if(typeof r==="object"&&!Array.isArray(r)){this.sPath=r.path;this.sOperator=r.operator;this.oValue1=r.value1;this.oValue2=r.value2;this.sVariable=r.variable;this.oCondition=r.condition;this.aFilters=r.filters||r.aFilters;this.bAnd=r.and||r.bAnd;this.fnTest=r.test;this.fnCompare=r.comparator;this.bCaseSensitive=r.caseSensitive}else{if(Array.isArray(r)){this.aFilters=r}else{this.sPath=r}if(typeof s==="boolean"){this.bAnd=s}else if(typeof s==="function"){this.fnTest=s}else{this.sOperator=s}this.oValue1=o;this.oValue2=l;if(this.sOperator===t.Any||this.sOperator===t.All){throw new Error("The filter operators 'Any' and 'All' are only supported with the parameter object notation.")}}if(this.aFilters?.includes(a.NONE)){throw new Error("Filter.NONE not allowed in multiple filter")}else if(this.oCondition&&this.oCondition===a.NONE){throw new Error("Filter.NONE not allowed as condition")}if(this.sOperator===t.Any){if(this.sVariable&&this.oCondition){this._checkLambdaArgumentTypes()}else if(!this.sVariable&&!this.oCondition){}else{throw new Error("When using the filter operator 'Any', a lambda variable and a condition have to be given or neither.")}}else if(this.sOperator===t.All){this._checkLambdaArgumentTypes()}else if(Array.isArray(this.aFilters)&&!this.sPath&&!this.sOperator&&!this.oValue1&&!this.oValue2){this._bMultiFilter=true;if(!this.aFilters.every(n)){e.error("Filter in aggregation of multi filter has to be instance of"+" sap.ui.model.Filter")}}else if(!this.aFilters&&this.sPath!==undefined&&(this.sOperator&&this.oValue1!==undefined||this.fnTest)){this._bMultiFilter=false}else{e.error("Wrong parameters defined for filter.")}this.sFractionalSeconds1=undefined;this.sFractionalSeconds2=undefined}});a.NONE=new a({path:"/",test:()=>false});a.checkFilterNone=function(t){if(Array.isArray(t)&&t.length>1&&t.includes(a.NONE)){throw new Error("Filter.NONE cannot be used together with other filters")}};a.prototype._checkLambdaArgumentTypes=function(){if(!this.sVariable||typeof this.sVariable!=="string"){throw new Error("When using the filter operators 'Any' or 'All', a string has to be given as argument 'variable'.")}if(!n(this.oCondition)){throw new Error("When using the filter operator 'Any' or 'All', a valid instance of sap.ui.model.Filter has to be given as argument 'condition'.")}};function n(t){return t instanceof a}a.prototype.appendFractionalSeconds1=function(t){this.sFractionalSeconds1=t};a.prototype.appendFractionalSeconds2=function(t){this.sFractionalSeconds2=t};var s={Logical:"Logical",Binary:"Binary",Unary:"Unary",Lambda:"Lambda",Reference:"Reference",Literal:"Literal",Variable:"Variable",Call:"Call",Custom:"Custom"};var o={Equal:"==",NotEqual:"!=",LessThan:"<",GreaterThan:">",LessThanOrEqual:"<=",GreaterThanOrEqual:">=",And:"&&",Or:"||",Not:"!"};var l={Contains:"contains",StartsWith:"startswith",EndsWith:"endswith"};a.prototype.getAST=function(e){var r,i,a,n,h,u,c,f,p;function d(t,e,r){return{type:s.Logical,op:t,left:e,right:r}}function b(t,e,r){return{type:s.Binary,op:t,left:e,right:r}}function y(t,e){return{type:s.Unary,op:t,arg:e}}function g(t,e,r,i){return{type:s.Lambda,op:t,ref:e,variable:r,condition:i}}function A(t){return{type:s.Reference,path:t}}function E(t){return{type:s.Literal,value:t}}function F(t){return{type:s.Variable,name:t}}function N(t,e){return{type:s.Call,name:t,args:e}}if(this.aFilters){i=this.bAnd?o.And:o.Or;a=this.bAnd?"AND":"OR";r=this.aFilters[this.aFilters.length-1].getAST(e);for(var O=this.aFilters.length-2;O>=0;O--){r=d(i,this.aFilters[O].getAST(e),r)}}else{i=this.sOperator;a=this.sOperator;n=A(this.sPath);h=E(this.oValue1);switch(i){case t.EQ:r=b(o.Equal,n,h);break;case t.NE:r=b(o.NotEqual,n,h);break;case t.LT:r=b(o.LessThan,n,h);break;case t.GT:r=b(o.GreaterThan,n,h);break;case t.LE:r=b(o.LessThanOrEqual,n,h);break;case t.GE:r=b(o.GreaterThanOrEqual,n,h);break;case t.Contains:r=N(l.Contains,[n,h]);break;case t.StartsWith:r=N(l.StartsWith,[n,h]);break;case t.EndsWith:r=N(l.EndsWith,[n,h]);break;case t.NotContains:r=y(o.Not,N(l.Contains,[n,h]));break;case t.NotStartsWith:r=y(o.Not,N(l.StartsWith,[n,h]));break;case t.NotEndsWith:r=y(o.Not,N(l.EndsWith,[n,h]));break;case t.BT:u=h;c=E(this.oValue2);r=d(o.And,b(o.GreaterThanOrEqual,n,u),b(o.LessThanOrEqual,n,c));break;case t.NB:u=h;c=E(this.oValue2);r=d(o.Or,b(o.LessThan,n,u),b(o.GreaterThan,n,c));break;case t.Any:case t.All:f=F(this.sVariable);p=this.oCondition.getAST(e);r=g(i,n,f,p);break;default:throw new Error("Unknown operator: "+i)}}if(e&&!r.origin){r.origin=a}return r};a.prototype.getComparator=function(){return this.fnCompare};a.prototype.getCondition=function(){return this.oCondition};a.prototype.getOperator=function(){return this.sOperator};a.prototype.getPath=function(){return this.sPath};a.prototype.getFilters=function(){return this.aFilters&&this.aFilters.slice()};a.prototype.getTest=function(){return this.fnTest};a.prototype.getValue1=function(){return this.oValue1};a.prototype.getValue2=function(){return this.oValue2};a.prototype.getVariable=function(){return this.sVariable};a.prototype.isAnd=function(){return!!this.bAnd};a.prototype.isCaseSensitive=function(){return this.bCaseSensitive};a.defaultComparator=function(t,e){if(t==e){return 0}if(t==null||e==null){return NaN}if(typeof t=="string"&&typeof e=="string"){return t.localeCompare(e,r.getLanguageTag().toString())}if(t<e){return-1}if(t>e){return 1}return NaN};return a});
//# sourceMappingURL=Filter.js.map