/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Binding","sap/ui/base/SyncPromise","sap/ui/model/ChangeReason","sap/base/Log","sap/base/assert","./SimpleType","./DataState"],function(t,e,n,r,a){"use strict";var i=t.extend("sap.ui.model.PropertyBinding",{constructor:function(e,n,r,a){t.apply(this,arguments);this.fnFormatter=undefined;this.sInternalType=undefined;this.sMode=undefined;this.oType=undefined},metadata:{abstract:true,publicMethods:["getValue","setValue","setType","getType","setFormatter","getFormatter","getExternalValue","setExternalValue","getBindingMode"]}});i.prototype._getBoundValue=function(t){var e=this.getValue();return t(e)};i.prototype._setBoundValue=function(t,n,r){var a=this.getDataState(),i=this;if(this.oType){r||=this.getContext();return e.resolve(t).then(function(t){return n(t)}).then(function(t){return e.all([t,i.oType.validateValue(t)])}).then(function([t]){if(i.getContext()!==r){r.setProperty(i.sPath,t,undefined,true);return}a.setInvalidValue(undefined);i.setValue(t)}).catch(function(e){if(i.getContext()===r){a.setInvalidValue(t);i.checkDataState()}throw e}).unwrap()}if(r){r.setProperty(this.sPath,t)}else{a.setInvalidValue(undefined);this.setValue(t)}return undefined};i.prototype._rawToExternal=function(t){if(this.oType){t=this.oType.formatValue(t,this.sInternalType)}if(this.fnFormatter){t=this.fnFormatter(t)}return t};i.prototype._externalToRaw=function(t){if(this.oType){t=this.oType.parseValue(t,this.sInternalType)}return t};i.prototype._rawToInternal=function(t){if(this.oType&&t!==null&&t!==undefined){return this.oType.getModelFormat().parse(t)}return t};i.prototype._internalToRaw=function(t){if(t!==null&&t!==undefined){return this.oType.getModelFormat().format(t)}return t};i.prototype.getExternalValue=function(){switch(this.sInternalType){case"raw":return this.getRawValue();case"internal":return this.getInternalValue();default:return this._getBoundValue(this._rawToExternal.bind(this))}};i.prototype.setExternalValue=function(t){return this._setExternalValue(t)};i.prototype._setExternalValue=function(t,e){switch(this.sInternalType){case"raw":return this._setRawValue(t,e);case"internal":return this._setInternalValue(t,e);default:if(this.fnFormatter){r.warning("Tried to use twoway binding, but a formatter function is used");return undefined}return this._setBoundValue(t,this._externalToRaw.bind(this),e)}};i.prototype.getInternalValue=function(){return this._getBoundValue(this._rawToInternal.bind(this))};i.prototype.setInternalValue=function(t){return this._setInternalValue(t)};i.prototype._setInternalValue=function(t,e){return this._setBoundValue(t,this._internalToRaw.bind(this),e)};i.prototype.getRawValue=function(){return this._getBoundValue(function(t){return t})};i.prototype.setRawValue=function(t){return this._setRawValue(t)};i.prototype._setRawValue=function(t,e){return this._setBoundValue(t,t=>t,e)};i.prototype.setType=function(t,e){const r=this.oType;this.oType=t;this.sInternalType=e;if(this.fnTypeChangedCallback&&t&&r!==t){this.fnTypeChangedCallback();this._fireChange({reason:n.Change})}};i.prototype.getType=function(){return this.oType};i.prototype.setFormatter=function(t){this.fnFormatter=t};i.prototype.getFormatter=function(){return this.fnFormatter};i.prototype.getBindingMode=function(){return this.sMode};i.prototype.setBindingMode=function(t){this.sMode=t};i.prototype.registerTypeChanged=function(t){this.fnTypeChangedCallback=t};i.prototype.resume=function(){this.bSuspended=false;this.checkUpdate(true)};return i});
//# sourceMappingURL=PropertyBinding.js.map