/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalBinding","sap/base/assert","sap/base/Log","sap/base/util/each","sap/ui/model/ChangeReason","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/TreeBindingAdapter","sap/ui/model/odata/ODataTreeBindingAdapter"],function(e,t,o,n,a,i,r,s,d){"use strict";var l=function(){if(!(this instanceof r)||this._bIsAdapted){return}d.apply(this);for(var e in l.prototype){if(l.prototype.hasOwnProperty(e)){this[e]=l.prototype[e]}}this.setAutoExpandMode(this.mParameters.autoExpandMode||i.Bundled)},u="sap.ui.model.analytics.AnalyticalTreeBindingAdapter";l.prototype.getGrandTotalContext=function(){return this._oRootNode&&this._oRootNode.context};l.prototype.getGrandTotalNode=function(){return this._oRootNode};l.prototype.getGrandTotalContextInfo=function(){return this._oRootNode};l.prototype.getLength=function(){if(!this._oRootNode){return 0}return this._oRootNode.magnitude+this._oRootNode.numberOfTotals+(this._oWatermark?1:0)};l.prototype.getContextByIndex=function(e){if(this._oRootNode&&e===this.getLength()-1&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode.context}var t=this.findNode(e);if(!t||!t.context){t={context:this.getContexts(e,1,0)[0]}}return t?t.context:undefined};l.prototype.getNodeByIndex=function(e){if(e===this.getLength()-1&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode}if(e>=this.getLength()){return undefined}return this.findNode(e)};l.prototype._isNodeSelectable=function(e){if(!e){return false}return e.isLeaf&&!e.isArtificial};l.prototype._getContextsOrNodes=function(e,t,o,a){var i,r,s,d,l=[],u=[],h=this;if(!this.isResolved()){return u}t=t||0;o=o||this.oModel.iSizeLimit;a=a||0;this._iPageSize=o;this._iThreshold=Math.max(this._iThreshold,a);this._aRowIndexMap=[];this._buildTree(t,o);if(this._oRootNode){u=this._retrieveNodeSection(this._oRootNode,t,o)}this._updateRowIndexMap(u,t);if(this._oWatermark){for(i=0;i<u.length;i+=1){if(u[i].absoluteNodeIndex>this._oWatermark.lastWatermarkNodeIndex){u.length=i+1;break}}if(u.length<o){this._autoExpandPaging()}}for(i=0;i<u.length;i++){s=u[i];if(!s.context){r=r||{};d=s.parent;r[d.groupID]=d;this._updateNodeSections(d.groupID,{startIndex:s.positionInParent,length:1})}l.push(s.context)}if(r){n(r,function(e,t){t.magnitude=0;t.numberOfTotals=0;h._loadChildContexts(t,{absoluteNodeIndex:t.absoluteNodeIndex})});l=[];for(i=0;i<u.length;i+=1){s=u[i];l.push(s.context)}}if(e){return u}else{return l}};l.prototype._autoExpandPaging=function(){t(this._oWatermark,"No watermark was set!");t(this._isRunningInAutoExpand(i.Bundled),"Optimised AutoExpand Paging can only be used with TreeAutoExpandMode.Bundled!");var e=this.getNodeContexts(this._oWatermark.context,{startIndex:this._oWatermark.startIndex,length:this._iPageSize,threshold:this._iThreshold,level:this._oWatermark.level,numberOfExpandedLevels:this._oWatermark.autoExpand});return e};l.prototype._afterMatchHook=function(e,t,o,n,a,i){if(e.sumNode&&e!==this._oRootNode){if(t.length===o){return true}var r=n.call(this,e.sumNode,e.sumNode.positionInParent,i);if(r){t.push(e.sumNode)}}return undefined};l.prototype._afterMapHook=function(e,t){if(e.sumNode&&e!==this._oRootNode){t.call(this,e.sumNode)}};l.prototype._createSumNode=function(e){var t;if(this.bProvideGrandTotals&&!this.mParameters.sumOnTop&&this.hasTotaledMeasures()&&e.children.length>1){t=this._createNode({parent:e.parent,positionInParent:e.children.length,context:e.context,level:e.level});t.nodeState=this._createNodeState({groupID:t.groupID,sum:true,expanded:false})}return t};l.prototype._buildTree=function(e,t){this._oRootNode=undefined;this._oWatermark=undefined;var n=this.mParameters&&this.getNumberOfExpandedLevels();var a=this.getRootContexts({startIndex:0,length:this._iPageSize,threshold:this._iThreshold,numberOfExpandedLevels:this._autoExpandMode===i.Bundled?n:undefined});var r;if(a==null){o.warning("AnalyticalTreeBindingAdapter: No Dimensions given. An artificial rootContext has be created. Please check your Table/Service definition for dimension columns!")}else{r=a[0]}if(!r){return}var s=this._getNodeState("/");if(!s){s=this._updateTreeState({groupID:"/",expanded:true,sum:true});this._updateNodeSections("/",{startIndex:0,length:t})}this._oRootNode=this._createNode({context:r,parent:null,level:0,nodeState:s,isLeaf:false,autoExpand:n,absoluteNodeIndex:-1});this._oRootNode.isArtificial=true;this._loadChildContexts(this._oRootNode,{absoluteNodeIndex:-1})};l.prototype._loadChildContexts=function(e,t){var n=e.nodeState;const a=this._isRunningInAutoExpand(i.Bundled);var r=this.getGroupSize(e.context,e.level);if(r>=0){if(!e.children[r-1]){e.children[r-1]=undefined}if(e.level===this.aAggregationLevel.length){n.leafCount=r}e.sumNode=this._createSumNode(e)}for(var s=0;s<n.sections.length;s++){var d=n.sections[s];if(d.startIndex>e.children.length){continue}var l;if(r===-1){l=d.length}else{l=Math.min(d.length,r-d.startIndex)}var h=false;if(e.autoExpand>=0&&a){h=true;l=Math.max(0,r)}var p=this.getNodeContexts(e.context,{startIndex:d.startIndex,length:l,threshold:h?0:this._iThreshold,level:e.level,supressRequest:h});for(var f=0;f<p.length;f++){var g=p[f];var c=f+d.startIndex;var x=e.children[c];var m={context:p[f],parent:e,level:e.level+1,positionInParent:c,autoExpand:Math.max(e.autoExpand-1,-1),absoluteNodeIndex:++t.absoluteNodeIndex};if(x){x.context=m.context;x.parent=m.parent;x.level=m.level;x.positionInParent=m.positionInParent;x.magnitude=0;x.numberOfTotals=0;x.totalNumberOfLeafs=0;x.autoExpand=m.autoExpand;x.absoluteNodeIndex=m.absoluteNodeIndex;var _;if(g){_=this._calculateGroupID(x)}x.groupID=_}else{x=this._createNode(m)}x.nodeState=this._getNodeState(x.groupID);if(!x.nodeState){x.nodeState=this._createNodeState({groupID:x.groupID,expanded:false})}x.nodeState.parentGroupID=e.groupID;x.isLeaf=!this.nodeHasChildren(x);e.children[c]=x;if(x.isLeaf){e.numberOfLeafs+=1}if(x.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[x.groupID]&&x.isLeaf){this.setNodeSelection(x.nodeState,true)}if((x.autoExpand>=0||x.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[x.groupID]){if(x.autoExpand>=0&&x.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[x.groupID]){if(x.nodeState.selectAllMode===undefined){x.nodeState.selectAllMode=true}}this._updateTreeState({groupID:x.nodeState.groupID,fallbackNodeState:x.nodeState,expanded:true});this._loadChildContexts(x,t)}e.magnitude+=x.magnitude;e.numberOfTotals+=x.numberOfTotals;e.numberOfLeafs+=x.numberOfLeafs}if(x&&x.isLeaf){e.totalNumberOfLeafs=r}else{e.totalNumberOfLeafs+=x.totalNumberOfLeafs}}}r=a?e.children.length:r;e.magnitude+=Math.max(r||0,0);if(!r&&!a){o.warning("AnalyticalTreeBindingAdapter: iMaxGroupSize("+r+") is undefined for node '"+e.groupID+"'!")}if(e.sumNode||e===this._oRootNode&&this.providesGrandTotal()&&this.hasTotaledMeasures()){e.numberOfTotals+=1}if(a&&e.autoExpand!=-1){if(!this._oWatermark&&!e.isLeaf&&!this.mFinalLength[e.groupID]){const t=this._getIndexBeforeFirstMissingNode(e);let n=e.children.length;let a="WATERMARK: at '"+e.groupID+"' ("+e.absoluteNodeIndex+") and start index "+n+" with last complete node index "+t;if(n===0){n=e.positionInParent;e=e.parent;a+=" --\x3e moved to '"+e.groupID+"' ("+e.absoluteNodeIndex+") and start index "+n}this._oWatermark={groupID:e.groupID,context:e.context,absoluteNodeIndex:e.absoluteNodeIndex,startIndex:n,level:e.level,autoExpand:e.autoExpand,lastWatermarkNodeIndex:t};o.debug(a,undefined,u)}}};l.prototype._getIndexBeforeFirstMissingNode=function(e){let t=e.absoluteNodeIndex;e.children.some(e=>{t=e.isLeaf?e.absoluteNodeIndex:this._getIndexBeforeFirstMissingNode(e);return!e.isLeaf&&!this.mFinalLength[e.groupID]});return t};l.prototype._calculateGroupID=function(e){var o;var n=this.aAggregationLevel.length;if(!this.isGrouped()&&e&&e.positionInParent){o="/"+e.positionInParent+"/"}else if(e.level>n){o=this._getGroupIdFromContext(e.context,n);t(e.positionInParent!=undefined,"If the node level is greater than the number of grouped columns, the position of the node to its parent must be defined!");o+=e.positionInParent+"/"}else{o=this._getGroupIdFromContext(e.context,e.level)}return o};l.prototype.collapse=function(e){var o,r;if(typeof e==="object"){o=e}else if(typeof e==="number"){r=this.findNode(e);t(r&&r.nodeState,"AnalyticalTreeBindingAdapter.collapse("+e+"): No node found!");if(!r){return}o=r.nodeState}this._updateTreeState({groupID:o.groupID,expanded:false});o.selectAllMode=false;var s=false;if(this.bCollapseRecursive||this._isRunningInAutoExpand(i.Bundled)){var d=o.groupID;if(this._isRunningInAutoExpand(i.Bundled)&&this._oWatermark&&(typeof d=="string"&&d.length>0&&this._oWatermark.groupID.startsWith(d))){if(r&&r.parent){const e=r.parent.children[r.positionInParent+1];this._oWatermark={groupID:r.parent.groupID,context:r.parent.context,absoluteNodeIndex:r.parent.absoluteNodeIndex,startIndex:r.positionInParent+1,level:r.parent.level,autoExpand:r.parent.autoExpand,lastWatermarkNodeIndex:this._getIndexBeforeFirstMissingNode(e??r)}}this._autoExpandPaging();s=true}var l=this;n(this._mTreeState.expanded,function(e,t){if(typeof d=="string"&&d.length>0&&e.startsWith(d)){l._updateTreeState({groupID:e,expanded:false})}});var u=[];n(this._mTreeState.selected,function(e,t){if(typeof d=="string"&&d.length>0&&e.startsWith(d)){t.selectAllMode=false;l.setNodeSelection(t,false);u.push(e)}});if(u.length){var h={rowIndices:[]};var p=0;this._map(this._oRootNode,function(e){if(!e||!e.isArtificial){p++}if(e&&u.indexOf(e.groupID)!==-1){if(e.groupID===this._sLeadSelectionGroupID){h.oldIndex=p;h.leadIndex=-1}h.rowIndices.push(p)}});this._publishSelectionChanges(h)}}if(!s){this._fireChange({reason:a.Collapse})}};l.prototype.collapseToLevel=function(e){this.setNumberOfExpandedLevels(e,true);s.prototype.collapseToLevel.call(this,e)};l.prototype.nodeHasChildren=function(o){t(o,"AnalyticalTreeBindingAdapter.nodeHasChildren: No node given!");if(!o||!o.parent||o.nodeState.sum){return false}else if(o.isArtificial){return true}else{return e.prototype.hasChildren.call(this,o.context,{level:o.level})}};l.prototype.resetData=function(t,o){var n=e.prototype.resetData.call(this,t,o);this._aRowIndexMap=[];this._oRootNode=undefined;this._oWatermark=undefined;this._iPageSize=0;this._iThreshold=0;if(!o||o.reason!==a.Sort){this.clearSelection();this._createTreeState(true)}return n};l.prototype.hasTotaledMeasures=function(){var e=false;n(this.getMeasureDetails()||[],function(t,o){if(o.analyticalInfo.total){e=true;return false}return true});return e};l.prototype.isGrouped=function(){return this.aAggregationLevel.length>0};l.prototype._isRunningInAutoExpand=function(e){if(this.getNumberOfExpandedLevels()>0&&this._autoExpandMode===e){return true}else{return false}};l.prototype.setNumberOfExpandedLevels=function(e,t){var n;e=e||0;if(e<0){o.warning("Number of expanded levels was set to 0. Negative values are prohibited",this,u);e=0}n=this.aAggregationLevel.length;if(e>n){o.warning("Number of expanded levels was reduced from "+e+" to "+n+" which is the number of grouped dimensions",this,u);e=n}if(!t){this.resetData()}this.mParameters.numberOfExpandedLevels=e};l.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels};l.prototype._getSelectableNodesCount=function(e){if(e){return e.totalNumberOfLeafs}else{return 0}};return l},true);
//# sourceMappingURL=AnalyticalTreeBindingAdapter.js.map