/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/security/encodeURL","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/Sorter","sap/ui/model/odata/ODataUtils"],function(e,t,r,i,n){"use strict";var o=o||{},a=/^\d+$/;o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={deepEqual:function(e,t,r){var i,n,o=0,a,s;if(!e||e.length!==t.length){return 2}if(e!==t){for(a=0,s=e.length;a<s;a+=1){n=e[a];i=t[a];if(n.grouped!==i.grouped||n.inResult!==i.inResult||n.level!==i.level||n.name!==i.name||n.total!==i.total||n.visible!==i.visible){return 2}if(n.formatter!==i.formatter){o=1;if(r){r(i)}}}}return o},tokenizeNametoLabelText:function(e){var t="";t=e.replace(/^P_(.*)/,"$1");t=t.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");t=t.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");t=t.replace(/(.*) _E$/,"$1");t=t.replace(/(.*) _(.*)/g,"$1 $2");return t}};o.Model=function(e,t){this._init(e,t)};o.Model.ReferenceByURI=function(e){return{sServiceURI:e}};o.Model.ReferenceByModel=function(e){return{oModel:e}};o.Model.ReferenceWithWorkaround=function(e,t){return{oModelReference:e,aWorkaroundID:t}};o.Model.prototype={_init:function(e,t){var r,i=this;if(typeof t=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead"}this._mParameter=t;this._oActivatedWorkarounds={};if(e&&e.aWorkaroundID){for(var n=-1,o;(o=e.aWorkaroundID[++n])!==undefined;){this._oActivatedWorkarounds[o]=true}e=e.oModelReference}if(!e||!e.sServiceURI&&!e.oModel){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel"}if(e.oModel){this._oModel=e.oModel;a()}if(e.sServiceURI){if(t&&t.modelVersion===2){r=sap.ui.require("sap/ui/model/odata/v2/ODataModel")||sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new r(e.sServiceURI);a()}else{r=sap.ui.require("sap/ui/model/odata/ODataModel")||sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new r(e.sServiceURI);a()}}if(this._oModel.getServiceMetadata()&&this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded"}function a(){if(!i._oModel.getServiceMetadata()){i._oModel.attachMetadataLoaded(s)}else{s()}}function s(){if(i.bIsInitialized){return}i.bIsInitialized=true;if(t&&t.sAnnotationJSONDoc){i.mergeV2Annotations(t.sAnnotationJSONDoc)}i._interpreteMetadata(i._oModel.getServiceMetadata().dataServices)}},_interpreteMetadata:function(e){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var t=this._oModel.getServiceMetadata().dataServices.schema[0];for(var r=-1,i;(i=t.entityContainer[++r])!==undefined;){if(i.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=i;break}}var n=t.entityType;var a=[],s=[],u=[];for(var l=-1,h;(h=n[++l])!==undefined;){var f=false;if(h.extensions!=undefined){for(var y=-1,p;(p=h.extensions[++y])!==undefined;){if(p.namespace==o.constants.SAP_NAMESPACE&&p.name=="semantics"){f=true;switch(p.value){case"aggregate":a.push(h);break;case"parameters":s.push(h);break;default:u.push(h)}}if(f){continue}}if(!f){u.push(h)}}else{u.push(h)}}for(var d=-1,_;(_=u[++d])!==undefined;){var m=new o.EntityType(this._oModel.getServiceMetadata(),t,_);this._oEntityTypeSet[m.getQName()]=m;var c=this._getEntitySetsOfType(t,m.getQName());if(c.length==0){throw"Invalid consumption model: No entity set for entity type "+m.getQName()+" found"}if(c.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+m.getQName()+" found"}var g=new o.EntitySet(this._oModel.getServiceMetadata(),t,c[0][0],c[0][1],m);this._oEntitySetSet[g.getQName()]=g;this._oEntityTypeNameToEntitySetMap[m.getQName()]=g}var v={};for(var P=-1,S;(S=s[++P])!==undefined;){var E=new o.EntityType(this._oModel.getServiceMetadata(),t,S);this._oEntityTypeSet[E.getQName()]=E;var N=this._getEntitySetsOfType(t,E.getQName());if(N.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+E.getQName()+" found"}if(N.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+E.getQName()+" found"}var b=new o.EntitySet(this._oModel.getServiceMetadata(),t,N[0][0],N[0][1],E);this._oEntitySetSet[b.getQName()]=b;this._oEntityTypeNameToEntitySetMap[E.getQName()]=b;var R=new o.Parameterization(E,b);this._oParameterizationSet[R.getName()]=R;v[E.getQName()]=R;var x=E.getQName();if(t.association!=undefined){for(var T=-1,A;(A=t.association[++T])!==undefined;){if(A.referentialConstraint==undefined){continue}var M=null;if(A.end[0].type==x&&A.end[0].multiplicity=="*"&&A.end[1].multiplicity=="1"){M=A.end[1].type}else if(A.end[1].type==x&&A.end[1].multiplicity=="*"&&A.end[0].multiplicity=="1"){M=A.end[0].type}if(!M){continue}if(A.referentialConstraint.dependent.propertyRef.length!=1){continue}var I=R.findParameterByName(A.referentialConstraint.dependent.propertyRef[0].name);if(I==null){continue}var Q=this._oEntityTypeSet[M];var F=this._oEntityTypeNameToEntitySetMap[M];I.setValueSetEntity(Q,F)}}}for(var D=-1,U;(U=a[++D])!==undefined;){var k=new o.EntityType(this._oModel.getServiceMetadata(),t,U);this._oEntityTypeSet[k.getQName()]=k;var w=k.getQName();var O=null;var V=null;if(t.association!=undefined){for(var L=-1,C;(C=t.association[++L])!==undefined;){var q=null;if(C.end[0].type==w){q=C.end[1].type}else if(C.end[1].type==w){q=C.end[0].type}else{continue}var B=null;B=v[q];if(B!=null){if(O!=null){throw"Unable to handle multiple parameter entity types of query entity "+k.name}else{O=B;V=C}}}}var z=this._getEntitySetsOfType(t,k.getQName());if(z.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics"}var $=new o.EntitySet(this._oModel.getServiceMetadata(),t,z[0][0],z[0][1],k);this._oEntitySetSet[$.getQName()]=$;this._oEntityTypeNameToEntitySetMap[k.getQName()]=$;var H=new o.QueryResult(this,k,$,O);this._oQueryResultSet[H.getName()]=H;if(O){O.setTargetQueryResult(H,V)}if(t.association!=undefined){for(var j=-1,K;(K=t.association[++j])!==undefined;){if(K.referentialConstraint==undefined){continue}var W=null;if(K.end[0].type==w&&K.end[0].multiplicity=="*"&&K.end[1].multiplicity=="1"){W=K.end[1].type}else if(K.end[1].type==w&&K.end[1].multiplicity=="*"&&K.end[0].multiplicity=="1"){W=K.end[0].type}if(!W){continue}if(K.referentialConstraint.dependent.propertyRef.length!=1){continue}var Z=H.findDimensionByName(K.referentialConstraint.dependent.propertyRef[0].name);if(Z==null){continue}var J=this._oEntityTypeNameToEntitySetMap[W];Z.setMembersEntitySet(J)}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(e){var t=null;try{t=JSON.parse(e)}catch(e){return}var r;try{r=this._oModel.getServiceMetadata().dataServices}catch(e){return}for(var i in t){if(!(this.oUI5ODataModelAnnotatableObject.objectName==i)){continue}if(!(t[i]instanceof Array)){continue}this.mergeV2AnnotationLevel(r[this.oUI5ODataModelAnnotatableObject.objectName],t[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break}return},mergeV2AnnotationLevel:function(e,t,r){for(var i=-1,n;(n=t[++i])!==undefined;){for(var o=-1,a;(a=e[++o])!==undefined;){if(!(n[r.keyPropName]==a[r.keyPropName])){continue}if(n["extensions"]!=undefined){if(a["extensions"]==undefined){a["extensions"]=[]}for(var s=-1,u;(u=n["extensions"][++s])!==undefined;){var l=false;for(var h=-1,f;(f=a["extensions"][++h])!==undefined;){if(u.name==f.name&&u.namespace==f.namespace){f.value=u.value;l=true;break}}if(!l){a["extensions"].push(u)}}}for(var y=-1,p;(p=r.aSubObject[++y])!==undefined;){for(var d in n){if(!(p.objectName==d)){continue}if(!(n[p.objectName]instanceof Array)){continue}if(a[p.objectName]==undefined||!(a[p.objectName]instanceof Array)){continue}this.mergeV2AnnotationLevel(a[p.objectName],n[p.objectName],p);break}}}}return},findQueryResultByName:function(e){var t=this._oQueryResultSet[e];if(!t&&this._oDefaultEntityContainer){var r=this._oDefaultEntityContainer.name+"."+e;t=this._oQueryResultSet[r]}return t},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames}this._aQueryResultNames=new Array(0);for(var e in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[e].getName())}return this._aQueryResultNames},getAllQueryResults:function(){return this._oQueryResultSet},getODataModel:function(){return this._oModel},_getEntitySetsOfType:function(e,t){var r=[];for(var i=-1,n;(n=e.entityContainer[++i])!==undefined;){for(var o=-1,a;(a=n.entitySet[++o])!==undefined;){if(a.entityType==t){r.push([n,a])}}}return r},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};o.QueryResult=function(e,t,r,i){this._init(e,t,r,i)};o.QueryResult.prototype={_init:function(e,t,r,i,n){this._oModel=e;this._oEntityType=t;this._oEntitySet=r;this._oParameterization=i;this._oDimensionSet={};this._oMeasureSet={};var a=t.getTypeDescription().property;var s={};for(var u=-1,l;(l=a[++u])!==undefined;){if(l.extensions==undefined){continue}for(var h=-1,f;(f=l.extensions[++h])!==undefined;){if(!f.namespace==o.constants.SAP_NAMESPACE){continue}switch(f.name){case"aggregation-role":switch(f.value){case"dimension":{var y=new o.Dimension(this,l);this._oDimensionSet[y.getName()]=y;break}case"measure":{var p=new o.Measure(this,l);this._oMeasureSet[p.getName()]=p;break}case"totaled-properties-list":this._oTotaledPropertyListProperty=l;break;default:}break;case"attribute-for":{var d=new o.DimensionAttribute(this,l);var _=d.getKeyProperty();s[_.name]=d;break}default:}}}for(var m in s){var c=s[m];c.getDimension().addAttribute(c)}if(e._oActivatedWorkarounds.IdentifyTextPropertiesByName){var g=[];for(var v in this._oDimensionSet){var P=this._oDimensionSet[v];if(!P.getTextProperty()){var S=null;S=t.findPropertyByName(v+"Name");if(!S){S=t.findPropertyByName(v+"Text")}if(!S){S=t.findPropertyByName(v+"Desc")}if(!S){S=t.findPropertyByName(v+"Description")}if(S){P.setTextProperty(S);g.push(S.name)}}}for(var E=-1,N;(N=g[++E])!==undefined;){delete this._oDimensionSet[N]}}},getName:function(){return this.getEntitySet().getQName()},getParameterization:function(){return this._oParameterization},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames}this._aDimensionNames=[];for(var e in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[e].getName())}return this._aDimensionNames},getAllDimensions:function(){return this._oDimensionSet},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames}this._aMeasureNames=[];for(var e in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[e].getName())}return this._aMeasureNames},getAllMeasures:function(){return this._oMeasureSet},findDimensionByName:function(e){return this._oDimensionSet[e]},findDimensionByPropertyName:function(e){if(this._oDimensionSet[e]){return this._oDimensionSet[e]}for(var t in this._oDimensionSet){var r=this._oDimensionSet[t];var i=r.getTextProperty();if(i&&i.name==e){return r}if(r.findAttributeByName(e)){return r}}return null},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty},findMeasureByName:function(e){return this._oMeasureSet[e]},findMeasureByPropertyName:function(e){if(this._oMeasureSet[e]){return this._oMeasureSet[e]}for(var t in this._oMeasureSet){var r=this._oMeasureSet[t];var i=r.getFormattedValueProperty();if(i&&i.name==e){return r}}return null},getModel:function(){return this._oModel},getEntityType:function(){return this._oEntityType},getEntitySet:function(){return this._oEntitySet},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};o.Parameterization=function(e,t){this._init(e,t)};o.Parameterization.prototype={_init:function(e,t){this._oEntityType=e;this._oEntitySet=t;this._oParameterSet={};var r=e.getTypeDescription().property;for(var i=-1,n;(n=r[++i])!==undefined;){if(n.extensions==undefined){continue}for(var a=-1,s;(s=n.extensions[++a])!==undefined;){if(!s.namespace==o.constants.SAP_NAMESPACE){continue}switch(s.name){case"parameter":{var u=new o.Parameter(this,n);this._oParameterSet[u.getName()]=u;break}default:}}}},setTargetQueryResult:function(e,t){this._oQueryResult=e;var r=this._oEntityType.getSchema().namespace+"."+t.name;var i=this._oEntityType.getTypeDescription().navigationProperty;if(!i){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type"}for(var n=-1,o;(o=i[++n])!==undefined;){if(o.relationship==r){this._oNavPropToQueryResult=o.name}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type"}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set"}return this._oQueryResult},getName:function(){return this.getEntitySet().getQName()},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames}this._aParameterNames=[];for(var e in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[e].getName())}return this._aParameterNames},getAllParameters:function(){return this._oParameterSet},findParameterByName:function(e){return this._oParameterSet[e]},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult},getEntityType:function(){return this._oEntityType},getEntitySet:function(){return this._oEntitySet},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};o.Parameter=function(e,t){this._init(e,t)};o.Parameter.prototype={_init:function(e,t){this._oParameterization=e;this._oProperty=t;var r=e.getEntityType();if(t.extensions!=undefined){for(var i=-1,n;(n=t.extensions[++i])!==undefined;){if(!n.namespace==o.constants.SAP_NAMESPACE){continue}switch(n.name){case"parameter":switch(n.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property"}break;case"label":this._sLabelText=n.value;break;case"text":this._oTextProperty=r.findPropertyByName(n.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=r.findPropertyByName(n.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=r.findPropertyByName(n.value);break;default:}}}if(!this._sLabelText){this._sLabelText=""}},setValueSetEntity:function(e,t){this._oValueSetEntityType=e;this._oValueSetEntitySet=t},getTextProperty:function(){return this._oTextProperty},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},isOptional:function(){return!this._bRequired},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter},isLowerIntervalBoundary:function(){return this._oUpperIntervalBoundaryParameterProperty?true:false},getPeerIntervalBoundaryParameter:function(){var e=null;if(this._oLowerIntervalBoundaryParameterProperty){e=this._oLowerIntervalBoundaryParameterProperty.name}else{e=this._oUpperIntervalBoundaryParameterProperty.name}if(!e){throw"Parameter is not an interval boundary"}return this._oParameterization.findParameterByName(e)},isValueSetAvailable:function(){return this._oValueSetEntityType?true:false},getName:function(){return this._oProperty.name},getProperty:function(){return this._oProperty},getContainingParameterization:function(){return this._oParameterization},getURIToValueEntitySet:function(e){var t=null;t=(e?e:"")+"/"+this._oValueSetEntitySet.getQName();return t},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};o.Dimension=function(e,t){this._init(e,t)};o.Dimension.prototype={_init:function(e,t){this._oQueryResult=e;this._oProperty=t;this._oAttributeSet={}},setMembersEntitySet:function(e){this._oMembersEntitySet=e},getName:function(){return this._oProperty.name},getKeyProperty:function(){return this._oProperty},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName())}return this._oTextProperty},setTextProperty:function(e){this._oTextProperty=e},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName())}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText==null?"":this._sLabelText},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var e=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName());if(e){this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(e.name)}}return this._sSuperOrdinateDimension},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name)}return this._oHierarchy},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames}this._aAttributeNames=[];for(var e in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[e].getName())}return this._aAttributeNames},getAllAttributes:function(){return this._oAttributeSet},findAttributeByName:function(e){return this._oAttributeSet[e]},addAttribute:function(e){this._oAttributeSet[e.getName()]=e},getContainingQueryResult:function(){return this._oQueryResult},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false},getMasterDataEntitySet:function(){return this._oMembersEntitySet},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};o.DimensionAttribute=function(e,t){this._init(e,t)};o.DimensionAttribute.prototype={_init:function(e,t){this._oQueryResult=e;this._oProperty=t;if(t.extensions!=undefined){for(var r=-1,i;(i=t.extensions[++r])!==undefined;){if(!i.namespace==o.constants.SAP_NAMESPACE){continue}switch(i.name){case"attribute-for":this._sDimensionName=i.value;break;case"label":this._sLabelText=i.value;break;case"text":this._oTextProperty=e.getEntityType().findPropertyByName(i.value);break;default:}}}},getName:function(){return this._oProperty.name},getKeyProperty:function(){return this._oProperty},getTextProperty:function(){return this._oTextProperty},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName)},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};o.Measure=function(e,t){this._init(e,t)};o.Measure.prototype={_init:function(e,t){this._oQueryResult=e;this._oProperty=t;if(t.extensions!=undefined){for(var r=-1,i;(i=t.extensions[++r])!==undefined;){if(!i.namespace==o.constants.SAP_NAMESPACE){continue}switch(i.name){case"label":this._sLabelText=i.value;break;case"text":this._oTextProperty=e.getEntityType().findPropertyByName(i.value);break;case"unit":this._oUnitProperty=e.getEntityType().findPropertyByName(i.value);break;default:}}}if(!this._sLabelText){this._sLabelText=""}},getName:function(){return this._oProperty.name},getRawValueProperty:function(){return this._oProperty},getFormattedValueProperty:function(){return this._oTextProperty},getUnitProperty:function(){return this._oUnitProperty},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName())}return this._sLabelText},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable}var e=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return e[this.getName()]!=undefined},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};o.EntitySet=function(e,t,r,i,n){this._init(e,t,r,i,n)};o.EntitySet.prototype={_init:function(e,t,r,i,n){this._oEntityType=n;this._oEntitySet=i;this._oContainer=r;this._oSchema=t;this._oModel=e;if(t.entityContainer.length>1){this._sQName=r.name+"."+i.name}else{this._sQName=i.name}},getQName:function(){return this._sQName},getSetDescription:function(){return this._oEntitySet},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames}this._oUpdatablePropertyNames={};var e=true;if(this._oEntitySet.extensions!=undefined){for(var t=-1,r;(r=this._oEntitySet.extensions[++t])!==undefined;){if(r.namespace==o.constants.SAP_NAMESPACE&&r.name=="updatable"){if(r.value=="false"){e=false;break}}}}if(!e){return this._oUpdatablePropertyNames}var i=this._oEntityType.getTypeDescription().property;for(var n=-1,a;(a=i[++n])!==undefined;){var s=true;if(a.extensions==undefined){continue}for(var u=-1,l;(l=a.extensions[++u])!==undefined;){if(l.namespace!=o.constants.SAP_NAMESPACE){continue}if(l.name=="updatable"){if(l.value=="false"){s=false;break}}}if(s){this._oUpdatablePropertyNames[a.name]=true}}return this._oUpdatablePropertyNames},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};o.EntityType=function(e,t,r){this._init(e,t,r)};o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(e,t,r){this._oEntityType=r;this._oSchema=t;this._oModel=e;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=t.namespace+"."+r.name;var i={};function n(e){var t=i[e];if(!t){t=i[e]={}}return t}for(var a=-1,s;(s=r.key.propertyRef[++a])!==undefined;){this._aKeyProperties.push(s.name)}for(var u=-1,l;(l=r.property[++u])!==undefined;){this._oPropertySet[l.name]=l;this._aFilterablePropertyNames.push(l.name);this._aSortablePropertyNames.push(l.name);if(l.extensions==undefined){continue}for(var h=-1,f;(f=l.extensions[++h])!==undefined;){if(f.namespace!==o.constants.SAP_NAMESPACE){continue}switch(f.name){case"filterable":if(f.value=="false"){this._aFilterablePropertyNames.pop(l.name)}break;case"sortable":if(f.value=="false"){this._aSortablePropertyNames.pop(l.name)}break;case"required-in-filter":if(f.value=="true"){this._aRequiredFilterPropertyNames.push(l.name)}break;case"filter-restriction":if(f.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||f.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||f.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[l.name]=f.value}break;case"hierarchy-node-external-key-for":n(f.value).externalKeyProperty=l;break;case"hierarchy-node-for":n(l.name).dimensionName=f.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":n(f.value).parentNodeIDProperty=l;break;case"hierarchy-level-for":n(f.value).levelProperty=l;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":n(f.value).drillStateProperty=l;break;default:}}}this._oRecursiveHierarchySet={};for(var y in i){var p=i[y];var d=this._oPropertySet[y];var _=this._oPropertySet[p.dimensionName];if(_==null){_=d}this._oRecursiveHierarchySet[_.name]=new o.RecursiveHierarchy(r,d,p.parentNodeIDProperty,p.levelProperty,_,p.externalKeyProperty)}},getProperties:function(){return this._oPropertySet},findPropertyByName:function(e){return this._oPropertySet[e]},getKeyProperties:function(){return this._aKeyProperties},getLabelOfProperty:function(e){var t=this._oPropertySet[e];if(t==null){throw"no such property with name "+e}if(t.extensions!=undefined){for(var r=-1,i;(i=t.extensions[++r])!==undefined;){if(!i.namespace==o.constants.SAP_NAMESPACE){continue}if(i.name=="label"){return i.value}}}return null},getHeadingOfProperty:function(e){var t=this._oPropertySet[e];if(t==null){throw"no such property with name "+e}var r=null;if(t.extensions!=undefined){for(var i=-1,n;(n=t.extensions[++i])!==undefined;){if(!n.namespace==o.constants.SAP_NAMESPACE){continue}if(n.name=="heading"){return n.value}if(n.name=="label"){r=n.value}}}return r},getQuickInfoOfProperty:function(e){var t=this._oPropertySet[e];if(t==null){throw"no such property with name "+e}var r=null;if(t.extensions!=undefined){for(var i=-1,n;(n=t.extensions[++i])!==undefined;){if(!n.namespace==o.constants.SAP_NAMESPACE){continue}if(n.name=="quickinfo"){return n.value}if(n.name=="label"){r=n.value}}}return r},getTextPropertyOfProperty:function(e){var t=this._oPropertySet[e];if(t==null){throw"no such property with name "+e}if(t.extensions!=undefined){for(var r=-1,i;(i=t.extensions[++r])!==undefined;){if(i.name=="text"){return this.findPropertyByName(i.value)}}}return null},getSuperOrdinatePropertyOfProperty:function(e){var t=this._oPropertySet[e];if(t==null){throw"no such property with name "+e}if(t.extensions!=undefined){for(var r=-1,i;(i=t.extensions[++r])!==undefined;){if(i.name=="super-ordinate"){return this.findPropertyByName(i.value)}}}return null},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames},getSortablePropertyNames:function(){return this._aSortablePropertyNames},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames}this._aHierarchyPropertyNames=[];for(var e in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[e].getNodeValueProperty().name)}return this._aHierarchyPropertyNames},getHierarchy:function(e){if(this._oRecursiveHierarchySet[e]==undefined){return null}return this._oRecursiveHierarchySet[e]},getQName:function(){return this._sQName},getTypeDescription:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};o.RecursiveHierarchy=function(e,t,r,i,n,o){this._init(e,t,r,i,n,o)};o.RecursiveHierarchy.prototype={_init:function(e,t,r,i,n,o){this._oEntityType=e;this._oNodeIDProperty=t;this._oParentNodeIDProperty=r;this._oNodeLevelProperty=i;this._oNodeValueProperty=n;this._oNodeExternalKeyProperty=o},isRecursiveHierarchy:function(){return true},isLeveledHierarchy:function(){return false},getNodeExternalKeyProperty:function(){return this._oNodeExternalKeyProperty},getNodeIDProperty:function(){return this._oNodeIDProperty},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty},getNodeLevelProperty:function(){return this._oNodeLevelProperty},getNodeValueProperty:function(){return this._oNodeValueProperty},_oEntityType:null,_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null,_oNodeExternalKeyProperty:null};o.FilterExpression=function(e,t,r){this._init(e,t,r)};o.FilterExpression.prototype={_init:function(e,t,r){this._oEntityType=r;this._oSchema=t;this._oModel=e;this._aConditionUI5Filter=[];this._aUI5FilterArray=[]},_renderPropertyFilterValue:function(t,r,i){if(r==="Edm.Time"&&a.test(t)){t={ms:parseInt(t),__edmType:"Edm.Time"}}return e(n._formatValue(t,r,true,i))},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[]},_addCondition:function(e){const{sPath:t,sOperator:r,oValue1:i,oValue2:n,sFractionalSeconds1:o,sFractionalSeconds2:a}=e;const s=this._aConditionUI5Filter.some(e=>e.sPath===t&&e.sOperator===r&&e.oValue1==i&&e.oValue2==n&&e.sFractionalSeconds1===o&&e.sFractionalSeconds2===a);if(!s){this._aConditionUI5Filter.push(e)}},_addUI5FilterArray:function(e){this._aUI5FilterArray.push(e)},addCondition:function(e,r,i,n){let o=e;let a;if(typeof e==="object"){o=e.sPath;a=e}var s=this._oEntityType.findPropertyByName(o);if(s==null){throw"Cannot add filter condition for unknown property name "+o}var u=this._oEntityType.getFilterablePropertyNames();if((u?Array.prototype.indexOf.call(u,o):-1)===-1){throw"Cannot add filter condition for not filterable property name "+o}this._addCondition(a||new t(o,r,i,n));return this},removeConditions:function(e){var t=this._oEntityType.findPropertyByName(e);if(t==null){throw"Cannot remove filter conditions for unknown property name "+e}for(var r=0;r<this._aConditionUI5Filter.length;r++){var i=this._aConditionUI5Filter[r];if(i.sPath==e){this._aConditionUI5Filter.splice(r--,1)}}return this},addSetCondition:function(e,i){var n=this._oEntityType.findPropertyByName(e);if(n==null){throw"Cannot add filter condition for unknown property name "+e}var o=this._oEntityType.getFilterablePropertyNames();if((o?Array.prototype.indexOf.call(o,e):-1)===-1){throw"Cannot add filter condition for not filterable property name "+e}for(var a=-1,s;(s=i[++a])!==undefined;){this._addCondition(new t(e,r.EQ,s))}return this},addUI5FilterConditions:function(e){if(!Array.isArray(e)){throw"Argument is not an array"}if(e.length==0){return this}var t=false;for(var r=0;r<e.length;r++){if(e[r].aFilters!=undefined){t=true;break}}if(t){this._addUI5FilterArray(e)}else{for(var i=0;i<e.length;i++){this.addCondition(e[i])}}return this},getExpressionAsUI5FilterArray:function(){var e=this._aConditionUI5Filter.concat([]);for(var t=-1,r;(r=this._aUI5FilterArray[++t])!==undefined;){for(var i=-1,n;(n=r[++i])!==undefined;){e.push(n)}}return e},getPropertiesReferencedByUI5FilterArray:function(e,t){for(var r=-1,i;(i=e[++r])!==undefined;){if(i.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(i.aFilters,t)}else{if(t[i.sPath]==undefined){t[i.sPath]=[]}t[i.sPath].push(i)}}},getReferencedProperties:function(){var e={};for(var t=-1,r;(r=this._aConditionUI5Filter[++t])!==undefined;){if(e[r.sPath]==undefined){e[r.sPath]=[]}e[r.sPath].push(r)}for(var i=-1,n;(n=this._aUI5FilterArray[++i])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(n,e)}return e},renderUI5Filter:function(e){const{sPath:t,sOperator:i,oValue1:n,oValue2:o,sFractionalSeconds1:a,sFractionalSeconds2:s}=e;let u=null;const l=this._oEntityType.findPropertyByName(t);if(l==null){throw"Cannot add filter condition for unknown property name "+t}switch(i){case r.BT:u="("+t+" ge "+this._renderPropertyFilterValue(n,l.type,a)+" and "+t+" le "+this._renderPropertyFilterValue(o,l.type,s)+")";break;case r.NB:u="("+t+" lt "+this._renderPropertyFilterValue(n,l.type,a)+" or "+t+" gt "+this._renderPropertyFilterValue(o,l.type,s)+")";break;case r.Contains:case r.NotContains:u=(i[0]==="N"?"not ":"")+"substringof("+this._renderPropertyFilterValue(n,"Edm.String")+","+t+")";break;case r.StartsWith:case r.EndsWith:case r.NotStartsWith:case r.NotEndsWith:u=i.toLowerCase().replace("not","not ")+"("+t+","+this._renderPropertyFilterValue(n,"Edm.String")+")";break;default:u=t+" "+i.toLowerCase()+" "+this._renderPropertyFilterValue(n,l.type,a)}return u},renderUI5MultiFilter:function(e){var t=[];var r="";var i=e.bAnd==true?" and ":" or ";for(var n=-1,o;(o=e.aFilters[++n])!==undefined;){if(o.aFilters!=undefined){t.push(o);continue}r+=(r==""?"":i)+"("+this.renderUI5Filter(o)+")"}if(t.length>0){for(var a=-1,s;(s=t[++a])!==undefined;){r+=(r==""?"":i)+"("+this.renderUI5MultiFilter(s)+")"}}return r},renderUI5FilterArray:function(e){if(e.length==0){return""}var t="";e.sort(function(e,t){const r=e.sPath||"";const i=t.sPath||"";if(r===i){return 0}return r>i?1:-1});var i=e[0].sPath;var n="";var o=[],a=[];for(var s=-1,u;(u=e[++s])!==undefined;){if(u.aFilters!=undefined){a.push(u);continue}if(i!=u.sPath){if(n!=""){t+=(t==""?"":" and ")+"("+n+")"}n="";if(o.length>0){for(var l=-1,h;(h=o[++l])!==undefined;){n+=(n==""?"":" and ")+this.renderUI5Filter(h)}t+=(t==""?"":" and ")+"("+n+")";n=""}i=u.sPath;o=[]}if(u.sOperator==r.NE){o.push(u);continue}n+=(n==""?"":" or ")+this.renderUI5Filter(u)}if(n!=""){t+=(t==""?"":" and ")+"("+n+")"}if(o.length>0){n="";for(var f=-1,y;(y=o[++f])!==undefined;){n+=(n==""?"":" and ")+this.renderUI5Filter(y)}t+=(t==""?"":" and ")+"("+n+")"}if(a.length>0){for(var p=-1,d;(d=a[++p])!==undefined;){t+=(t==""?"":" and ")+"("+this.renderUI5MultiFilter(d)+")"}}return t},getURIFilterOptionValue:function(){var e=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var t=-1,r;(r=this._aUI5FilterArray[++t])!==undefined;){e+=(e==""?"":" and ")+"("+this.renderUI5FilterArray(r)+")"}return e},checkValidity:function(){var e=this._oEntityType.getRequiredFilterPropertyNames();var t=this.getReferencedProperties();for(var i=-1,n;(n=e[++i])!==undefined;){if(t[n]==undefined){throw"filter expression does not contain required property "+n}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var u=a[s];if(u==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(t[s]!=undefined){if(t[s].length>1){var l=t[s][0].oValue1;for(var h=0;h<t[s].length;h++){if(t[s][h].oValue1!=l||t[s][h].sOperator!=r.EQ){throw"filter expression may use "+s+" only with a single EQ condition"}}}}}}return true},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};o.SortExpression=function(e,t,r){this._init(e,t,r)};o.SortExpression.prototype={_init:function(e,t,r){this._oEntityType=r;this._oSchema=t;this._oModel=e;this._aSortCondition=[]},_containsSorter:function(e){var t=null;for(var r=-1,i;(i=this._aSortCondition[++r])!==undefined;){if(i.property.name===e){t={sorter:i,index:r};break}}return t},_removeFromArray:function(e,t,r){var i=e.slice((r||t)+1||e.length);e.length=t<0?e.length+t:t;return e.push.apply(e,i)},clear:function(){this._aSortCondition=[]},addSorter:function(e,t,r){var i=this._oEntityType.findPropertyByName(e);if(i==null){throw"Cannot add sort condition for unknown property name "+e}var n=this._containsSorter(e);if(n!=null){if(!r){n.sorter.order=t}return this}var o=this._oEntityType.getSortablePropertyNames();if((o?Array.prototype.indexOf.call(o,e):-1)===-1){throw"Cannot add sort condition for not sortable property name "+e}this._aSortCondition.push({property:i,order:t});return this},removeSorter:function(e){if(!e){return}var t=this._containsSorter(e);if(t){this._removeFromArray(this._aSortCondition,t.index)}},getExpressionsAsUI5SorterArray:function(){var e=[];for(var t=-1,r;(r=this._aSortCondition[++t])!==undefined;){e.push(new i(r.property.name,r.order==o.SortOrder.Descending))}return e},getExpressionAsUI5Sorter:function(){var e=this.getExpressionsAsUI5SorterArray();if(e.length==0){return null}else{return e[0]}},getURIOrderByOptionValue:function(e){if(this._aSortCondition.length==0){return""}var t="";for(var r=-1,i;(i=this._aSortCondition[++r])!==undefined;){if(!e[i.property.name]){continue}t+=(t==""?"":",")+i.property.name+" "+i.order}return t},getEntityType:function(){return this._oEntityType},getSchema:function(){return this._oSchema},getModel:function(){return this._oModel},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};o.ParameterizationRequest=function(e){this._init(e)};o.ParameterizationRequest.prototype={_init:function(e){if(!e){throw"No parameterization given"}this._oParameterization=e;this._oParameterValueAssignment=[]},_renderParameterKeyValue:function(t,r){return e(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(t,r))},getParameterization:function(){return this._oParameterization},setParameterValue:function(e,t,r){var i=this._oParameterization.findParameterByName(e);if(!i){throw"Invalid parameter name "+e}if(r!=null){if(!i.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+e+" accepting only single values"}if(!i.isLowerIntervalBoundary()){throw"Range value given, but parameter "+e+" does not hold the lower boundary"}}if(!i.isIntervalBoundary()){if(t==null){delete this._oParameterValueAssignment[e]}else{this._oParameterValueAssignment[e]=t}}else{if(t==null&&r!=null){throw"Parameter "+e+": An upper boundary cannot be given without the lower boundary"}if(t==null){delete this._oParameterValueAssignment[e];r=null}else{this._oParameterValueAssignment[e]=t}var n=i.getPeerIntervalBoundaryParameter();if(r==null){r=t}if(t==null){delete this._oParameterValueAssignment[n.getName()]}else{this._oParameterValueAssignment[n.getName()]=r}}return},getURIToParameterizationEntitySet:function(e){return(e?e:"")+"/"+this._oParameterization.getEntitySet().getQName()},getURIToParameterizationEntry:function(e){var t=this._oParameterization.getAllParameters();for(var r in t){if(this._oParameterValueAssignment[r]==undefined){throw"Parameter "+r+" has no value assigned"}}var i="",n=true;for(var o in this._oParameterValueAssignment){i+=(n?"":",")+o+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[o],t[o].getProperty().type);n=false}return(e?e:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+i+")"},_oParameterization:null,_oParameterValueAssignment:null};o.QueryResultRequest=function(e,t){this._init(e,t)};o.QueryResultRequest.prototype={_init:function(e,t){this._oQueryResult=e;this._oParameterizationRequest=t;this._oAggregationLevel={};this._oDimensionHierarchies={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null},addRecursiveHierarchy:function(e,t,r){var i;if(!e){return}i=this._oQueryResult.findDimensionByName(e);if(!i){throw new Error("'"+e+"' is not a dimension property")}if(!i.getHierarchy()){throw new Error("Dimension '"+e+"' does not have a hierarchy")}this._oSelectedPropertyNames=null;this._oDimensionHierarchies[e]={externalKey:t,id:true,text:r}},setParameterizationRequest:function(e){this._oParameterizationRequest=e},setResourcePath:function(e){this._sResourcePath=e;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path"}if(this._oQueryResult.getParameterization()){var t=e.lastIndexOf("/");if(t==-1){throw"Missing navigation from parameter entity set to query result in resource path"}var r=e.substring(t+1);if(r!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path"}}},getParameterizationRequest:function(){return this._oParameterizationRequest},getQueryResult:function(){return this._oQueryResult},setAggregationLevel:function(e){this._oAggregationLevel={};if(!e){e=this._oQueryResult.getAllDimensionNames()}this.addToAggregationLevel(e);this._oSelectedPropertyNames=null},addToAggregationLevel:function(e){if(!e){return}this._oSelectedPropertyNames=null;for(var t=-1,r;(r=e[++t])!==undefined;){if(!this._oQueryResult.findDimensionByName(r)){throw r+" is not a valid dimension name"}this._oAggregationLevel[r]={key:true,text:false,attributes:null}}},removeFromAggregationLevel:function(e){if(!e){return}this._oSelectedPropertyNames=null;for(var t=-1,r;(r=e[++t])!==undefined;){if(!this._oQueryResult.findDimensionByName(r)){throw r+" is not a valid dimension name"}if(this._oAggregationLevel[r]!=undefined){delete this._oAggregationLevel[r];this.getSortExpression().removeSorter(r)}}},getAggregationLevel:function(){var e=[];for(var t in this._oAggregationLevel){e.push(t)}return e},getAggregationLevelDetails:function(e){if(this._oAggregationLevel[e]==undefined){throw"Aggregation level does not include dimension "+e}return this._oAggregationLevel[e]},setMeasures:function(e){if(!e){e=this._oQueryResult.getAllMeasureNames()}this._oSelectedPropertyNames=null;this._oMeasures={};for(var t=-1,r;(r=e[++t])!==undefined;){if(!this._oQueryResult.findMeasureByName(r)){throw r+" is not a valid measure name"}this._oMeasures[r]={value:true,text:false,unit:false}}},getMeasureNames:function(){var e=[];for(var t in this._oMeasures){e.push(t)}return e},includeDimensionKeyTextAttributes:function(e,t,r,i){this._oSelectedPropertyNames=null;var n=[];if(e){if(this._oAggregationLevel[e]==undefined){throw e+" is not included in the aggregation level"}n.push(e)}else{for(var o in this._oAggregationLevel){n.push(o)}i=null}for(var a=-1,s;(s=n[++a])!==undefined;){if(t!=null){this._oAggregationLevel[s].key=t}if(r!=null){this._oAggregationLevel[s].text=r}if(i!=null){this._oAggregationLevel[s].attributes=i}}},includeMeasureRawFormattedValueUnit:function(e,t,r,i){this._oSelectedPropertyNames=null;var n=[];if(e){if(this._oMeasures[e]==undefined){throw e+" is not part of the query result"}n.push(e)}else{for(var o in this._oMeasures){n.push(o)}}for(var a=-1,s;(s=n[++a])!==undefined;){if(t!=null){this._oMeasures[s].value=t}if(r!=null){this._oMeasures[s].text=r}if(i!=null){this._oMeasures[s].unit=i}}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(e){this._oFilterExpression=e},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e)}return this._oSortExpression},setSortExpression:function(e){this._oSortExpression=e},setRequestOptions:function(e,t,r){if(e!=null){this._bIncludeEntityKey=e}if(t!=null){this._bIncludeCount=t}if(r!=null){this._bReturnNoEntities=r}},setResultPageBoundaries:function(e,t){if(e!=null&&typeof e!=="number"){throw"Start value must be null or numeric"}if(t!==null&&typeof t!=="number"){throw"End value must be null or numeric"}if(e==null){e=1}if(e<1||e>(t==null?e:t)){throw"Invalid values for requested page boundaries"}this._iSkipRequestOption=e>1?e-1:null;this._iTopRequestOption=t!=null?t-e+1:null},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1}else{e=this._iSkipRequestOption+this._iTopRequestOption}}return{start:this._iSkipRequestOption==null?1:this._iSkipRequestOption,end:e}},getURIToQueryResultEntitySet:function(e){var t=null;if(this._sResourcePath!=null){t=(e?e:"")+this._sResourcePath}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request"}else{t=this._oParameterizationRequest.getURIToParameterizationEntry(e)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()}}else{t=(e?e:"")+"/"+this._oQueryResult.getEntitySet().getQName()}return t},getURIOrderByOptionValue:function(){var e,t,r=null,i=this._oSortExpression?this._oSortExpression._aSortCondition:[],n,o=i.length;if(o){e=this._oQueryResult.getAllMeasureNames();for(n=0;n<o;n+=1){t=i[n];if(!this._oSelectedPropertyNames[t.property.name]&&e.indexOf(t.property.name)<0){continue}r=(r?r+",":"")+t.property.name+" "+t.order}}return r},getURIQueryOptionValue:function(e){var t,r=null,i,n=this;function o(e){var t;if(!e){return}t=typeof e==="string"?e:e.name;if(!n._oSelectedPropertyNames[t]){i+=(i==""?"":",")+t;n._oSelectedPropertyNames[t]=true}}switch(e){case"$select":{i="";this._oSelectedPropertyNames={};for(t in this._oAggregationLevel){var a=this._oQueryResult.findDimensionByName(t);var s=this._oAggregationLevel[t];if(s.key==true){o(a.getKeyProperty())}if(s.text==true){o(a.getTextProperty())}if(s.attributes){for(var u=-1,l;(l=s.attributes[++u])!==undefined;){o(a.findAttributeByName(l).getName())}}}for(t in this._oMeasures){var h=this._oQueryResult.findMeasureByName(t);var f=this._oMeasures[t];if(f.value==true){o(h.getRawValueProperty())}if(f.text==true){o(h.getFormattedValueProperty())}if(f.unit==true){o(h.getUnitProperty())}}for(t in this._oDimensionHierarchies){var y=this._oQueryResult.findDimensionByName(t).getHierarchy();var p=this._oDimensionHierarchies[t];if(p.id){o(y.getNodeIDProperty())}if(p.externalKey){o(y.getNodeExternalKeyProperty())}if(p.text){o(this._oQueryResult.getEntityType().getTextPropertyOfProperty(y.getNodeIDProperty().name))}}if(this._bIncludeEntityKey){var d=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var _=-1,m;(m=d[++_])!==undefined;){i+=(i==""?"":",")+m.name}}r=i?i:null;break}case"$filter":{var c=null;if(this._oFilterExpression){c=this._oFilterExpression.getURIFilterOptionValue()}r=c?c:null;break}case"$orderby":{r=this.getURIOrderByOptionValue();break}case"$top":{r=null;if(this._bReturnNoEntities){r=0}else if(this._iTopRequestOption!==null){r=this._iTopRequestOption}break}case"$skip":{r=null;if(!this._bReturnNoEntities){r=this._iSkipRequestOption}break}case"$inlinecount":{r=this._bIncludeCount==true?"allpages":null;break}default:break}return r},getURIToQueryResultEntries:function(e,t){if(!t){t=this.getURIToQueryResultEntitySet(e)}this.getFilterExpression().checkValidity();var r=this.getURIQueryOptionValue("$select");var i=this.getURIQueryOptionValue("$filter");var n=this.getURIQueryOptionValue("$orderby");var o=this.getURIQueryOptionValue("$top");var a=this.getURIQueryOptionValue("$skip");var s=this.getURIQueryOptionValue("$inlinecount");var u=t;var l=false;if(r!==null){u+="?$select="+r;l=true}if(this._oFilterExpression&&i!==null){if(!l){u+="?";l=true}else{u+="&"}u+="$filter="+i}if(this._oSortExpression&&n!==null){if(!l){u+="?";l=true}else{u+="&"}u+="$orderby="+n}if((this._iTopRequestOption||this._bReturnNoEntities)&&o!==null){if(!l){u+="?";l=true}else{u+="&"}u+="$top="+o}if(this._iSkipRequestOption&&a!==null){if(!l){u+="?";l=true}else{u+="&"}u+="$skip="+a}if(this._bIncludeCount&&s!==null){if(!l){u+="?";l=true}else{u+="&"}u+="$inlinecount="+s}return u},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oDimensionHierarchies:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};o.ParameterValueSetRequest=function(e){this._init(e)};o.ParameterValueSetRequest.prototype={_init:function(e){this._oParameter=e;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null},includeParameterText:function(e){if(e!=null){this._oValueSetResult.text=e}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();var t=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(t,e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(e){this._oFilterExpression=e},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e)}return this._oSortExpression},setSortExpression:function(e){this._oSortExpression=e},getURIQueryOptionValue:function(e){var t=null;switch(e){case"$select":{var r="";r+=(r==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){r+=(r==""?"":",")+this._oParameter.getTextProperty().name}t=r?r:null;break}case"$filter":{var i=null;if(this._oFilterExpression){i=this._oFilterExpression.getURIFilterOptionValue()}t=i?i:null;break}case"$orderby":{var n=null;if(this._oSortExpression){n=this._oSortExpression.getURIOrderByOptionValue()}t=n?n:null;break}default:break}return t},getURIToParameterValueSetEntries:function(e){var t=null;t=(e?e:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var r=this.getURIQueryOptionValue("$select");var i=this.getURIQueryOptionValue("$filter");var n=this.getURIQueryOptionValue("$orderby");var o=t;var a=false;if(r){o+="?$select="+r;a=true}if(this._oFilterExpression&&i){if(!a){o+="?";a=true}else{o+="&"}o+="$filter="+i}if(this._oSortExpression&&n){if(!a){o+="?";a=true}else{o+="&"}o+="$orderby="+n}return o},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};o.DimensionMemberSetRequest=function(e,t,r){this._init(e,t,r)};o.DimensionMemberSetRequest.prototype={_init:function(e,t,r){this._oDimension=e;this._oParameterizationRequest=t;this._bUseMasterData=r;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"Parameterized master data entity sets are not yet implemented"}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet()}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request"}}},setParameterizationRequest:function(e){this._oParameterizationRequest=e},includeDimensionTextAttributes:function(e,t){this._oValueSetResult.text={text:false,attributes:false};if(e==true){this._oValueSetResult.text=true}if(t==true){this._oValueSetResult.attributes=true}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oEntitySet.getEntityType();var t=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(t,e.getSchema(),e)}return this._oFilterExpression},setFilterExpression:function(e){this._oFilterExpression=e},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType)}return this._oSortExpression},setSortExpression:function(e){this._oSortExpression=e},setRequestOptions:function(e){if(e!=null){this._bIncludeCount=e}},setResultPageBoundaries:function(e,t){if(e!=null&&typeof e!=="number"){throw"Start value must be null or numeric"}if(t!==null&&typeof t!=="number"){throw"End value must be null or numeric"}if(e==null){e=1}if(e<1||e>(t==null?e:t)){throw"Invalid values for requested page boundaries"}this._iSkipRequestOption=e>1?e-1:null;this._iTopRequestOption=t!=null?t-e+1:null},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1}else{e=this._iSkipRequestOption+this._iTopRequestOption}}return{start:this._iSkipRequestOption==null?1:this._iSkipRequestOption,end:e}},getURIQueryOptionValue:function(e){var t=null;switch(e){case"$select":{var r="";var i=this._oEntitySet.getEntityType();var n=i.getKeyProperties();var o=[];if(this._bUseMasterData){for(var a=-1,s;(s=n[++a])!==undefined;){r+=(r==""?"":",")+s;var u=i.getTextPropertyOfProperty(s);if(u){if(this._oValueSetResult.text==true){r+=","+u.name}o.push(u.name)}}}else{r+=(r==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){r+=(r==""?"":",")+this._oDimension.getTextProperty().name}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var l=i.getProperties();for(var h in l){var f=false;for(var y=-1,p;(p=n[++y])!==undefined;){if(h==p){f=true;break}}if(f){continue}for(var d=-1,_;(_=o[++d])!==undefined;){if(h==_){f=true;break}}if(!f){r+=","+h}}}else{var m=this._oDimension.getAllAttributeNames();for(var c=-1,g;(g=m[++c])!==undefined;){r+=(r==""?"":",")+this._oDimension.findAttributeByName(g).getName()}}}t=r?r:null;break}case"$filter":{var v=null;if(this._oFilterExpression){v=this._oFilterExpression.getURIFilterOptionValue()}t=v?v:null;break}case"$orderby":{var P=null;if(this._oSortExpression){P=this._oSortExpression.getURIOrderByOptionValue()}t=P?P:null;break}case"$top":{if(this._iTopRequestOption!==null){t=this._iTopRequestOption}break}case"$skip":{t=this._iSkipRequestOption;break}case"$inlinecount":{t=this._bIncludeCount==true?"allpages":null;break}default:break}return t},getURIToDimensionMemberEntitySet:function(e){var t=null;if(!this._bUseMasterData&&this._oParameterizationRequest){t=this._oParameterizationRequest.getURIToParameterizationEntry(e)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult()}else{t=(e?e:"")+"/"+this._oEntitySet.getQName()}return t},getURIToDimensionMemberEntries:function(e){var t=this.getURIToDimensionMemberEntitySet(e);this.getFilterExpression().checkValidity();var r=this.getURIQueryOptionValue("$select");var i=this.getURIQueryOptionValue("$filter");var n=this.getURIQueryOptionValue("$orderby");var o=this.getURIQueryOptionValue("$top");var a=this.getURIQueryOptionValue("$skip");var s=this.getURIQueryOptionValue("$inlinecount");var u=t;var l=false;if(r){u+="?$select="+r;l=true}if(this._oFilterExpression&&i){if(!l){u+="?";l=true}else{u+="&"}u+="$filter="+i}if(this._oSortExpression&&n){if(!l){u+="?";l=true}else{u+="&"}u+="$orderby="+n}if(this._iTopRequestOption&&o){if(!l){u+="?";l=true}else{u+="&"}u+="$top="+o}if(this._iSkipRequestOption&&a){if(!l){u+="?";l=true}else{u+="&"}u+="$skip="+a}if(this._bIncludeCount&&s){if(!l){u+="?";l=true}else{u+="&"}u+="$inlinecount="+s}return u},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o},true);
//# sourceMappingURL=odata4analytics.js.map