/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CountMode","./ODataUtils","sap/base/assert","sap/base/Log","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/array/diff","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/Filter"],function(t,e,i,s,a,n,r,h,o,l,u,f,d,p,g){"use strict";var c=d.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(t,e,i,s,a,n){d.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitial=true;this.sCountMode=n&&n.countMode||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.oCombinedFilter=null;this.oModel.checkFilter(this.aApplicationFilters);if(!this.oModel.getServiceMetadata()){var r=this,h=function(t){r.bInitial=false;r._initSortersFilters();r.oModel.detachMetadataLoaded(h)};this.oModel.attachMetadataLoaded(this,h)}else{this.bInitial=false;this._initSortersFilters()}var o=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=o;if(Array.isArray(o)&&!s&&!a){this.aKeys=o;this.iLength=o.length;this.bLengthFinal=true;this.bDataAvailable=true}else if(o===null&&this.oModel.resolve(this.sPath,this.oContext)){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true}else if(this.oModel.getServiceMetadata()){this.resetData()}}});c.prototype.getAllCurrentContexts=function(){var t=[],e=this;this.aKeys.forEach(function(i){t.push(e.oModel.getContext("/"+i))});return t};c.prototype.getContexts=function(t,e,i){if(this.bInitial){return[]}this.iLastLength=e;this.iLastStartIndex=t;this.iLastThreshold=i;if(!t){t=0}if(!e){e=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<e){e=this.iLength}}if(!i){i=0}var s=true,n=this._getContexts(t,e),o={},l;l=this.calculateSection(t,e,i,n);s=n.length!=e&&!(this.bLengthFinal&&n.length>=this.iLength-t);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&l.length>0&&(s||e<l.length)){this.loadData(l.startIndex,l.length);n.dataRequested=true}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(l.startIndex,l.length,true);n.dataRequested=true}this.bRefresh=false}else{for(var u=0;u<n.length;u++){o[n[u].getPath()]=n[u].getObject()}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&t<this.iLastEndIndex){var f=this;var d=h(this.aLastContexts,n,function(t,e){return a(t&&f.oLastContextData&&f.oLastContextData[t.getPath()],e&&o&&o[e.getPath()])});n.diff=d}}this.iLastEndIndex=t+e;this.aLastContexts=n.slice(0);this.oLastContextData=r({},o)}return n};c.prototype.getCurrentContexts=function(){return this.aLastContexts||[]};c.prototype._getContexts=function(t,e){var i=[],s,a;if(!t){t=0}if(!e){e=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<e){e=this.iLength}}for(var n=t;n<t+e;n++){a=this.aKeys[n];if(!a){break}s=this.oModel.getContext("/"+a);i.push(s)}return i};c.prototype.calculateSection=function(t,e,i,s){var a,n,r,h,o,l={},u;n=t;a=0;for(var f=t;f>=Math.max(t-i,0);f--){u=this.aKeys[f];if(!u){h=f+1;break}}for(var d=t+e;d<t+e+i;d++){u=this.aKeys[d];if(!u){r=d;break}}o=t-h;if(h&&t>i&&o<i){if(s.length!=e){n=t-i}else{n=h-i}a=i}n=Math.max(n,0);if(n==t){n+=s.length}if(s.length!=e){a+=e-s.length}o=r-t-e;if(o==0){a+=i}if(r&&o<i&&o>0){if(n>t){n=r;a+=i}}if(this.bLengthFinal&&this.iLength<a+n){a=this.iLength-n}l.startIndex=n;l.length=a;return l};c.prototype.setContext=function(t){if(this.oContext!=t){this.oContext=t;if(this.isRelative()){this._initSortersFilters();if(!this.bInitial){var e=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=e;if(Array.isArray(e)&&!this.aSorters.length>0&&!this.aFilters.length>0){this.aKeys=e;this.iLength=e.length;this.bLengthFinal=true;this._fireChange({reason:o.Context})}else if(!this.oModel.resolve(this.sPath,this.oContext)||e===null){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:o.Context})}else{this.refresh()}}}}};c.prototype.getDownloadUrl=function(t){var e=[],i;if(t){e.push("$format="+encodeURIComponent(t))}if(this.sSortParams){e.push(this.sSortParams)}if(this.sFilterParams){e.push(this.sFilterParams)}if(this.sCustomParams){e.push(this.sCustomParams)}i=this.oModel.resolve(this.sPath,this.oContext);return i&&this.oModel._createRequestUrl(i,null,e)};c.prototype.loadData=function(e,i,s){var a=this,r=false;if(e||i){this.sRangeParams="$skip="+e+"&$top="+i;this.iStartIndex=e}else{e=this.iStartIndex}var h=[];if(this.sRangeParams){h.push(this.sRangeParams)}if(this.sSortParams){h.push(this.sSortParams)}if(this.sFilterParams){h.push(this.sFilterParams)}if(this.sCustomParams){h.push(this.sCustomParams)}if(!this.bLengthFinal&&(this.sCountMode==t.Inline||this.sCountMode==t.Both)){h.push("$inlinecount=allpages");r=true}function l(t){n(t.results,function(t,i){a.aKeys[e+t]=a.oModel._getKey(i)});if(r&&t.__count){a.iLength=parseInt(t.__count);a.bLengthFinal=true}if(a.iLength<e+t.results.length){a.iLength=e+t.results.length;a.bLengthFinal=false}if(t.results.length<i||i===undefined){a.iLength=e+t.results.length;a.bLengthFinal=true}if(e==0&&t.results.length==0){a.iLength=0;a.bLengthFinal=true}a.oRequestHandle=null;a.bPendingRequest=false;a.bNeedsUpdate=true;a.bIgnoreSuspend=true}function u(t){a.fireDataReceived({data:t})}function f(t,e){a.oRequestHandle=null;a.bPendingRequest=false;if(!e){a.aKeys=[];a.iLength=0;a.bLengthFinal=true;a.bDataAvailable=true;a._fireChange({reason:o.Change})}a.fireDataReceived()}function d(t){a.oRequestHandle=t}var p=this.sPath,g=this.oContext;if(this.isRelative()){p=this.oModel.resolve(p,g)}if(p){if(s){var c=this.oModel._createRequestUrl(p,null,h);this.fireDataRequested();this.oModel.fireRequestSent({url:c,method:"GET",async:true});setTimeout(function(){a.bNeedsUpdate=true;a.checkUpdate();a.oModel.fireRequestCompleted({url:c,method:"GET",async:true,success:true});a.fireDataReceived({data:{}})},0)}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(p,h,l,f,false,d,u)}}};c.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength}else{var t=this.iLastThreshold||this.iLastLength||10;return this.iLength+t}};c.prototype.isLengthFinal=function(){return this.bLengthFinal};c.prototype._getLength=function(){var t=this;var e=[];if(this.sFilterParams){e.push(this.sFilterParams)}if(this.mParameters&&this.mParameters.custom){var i={custom:{}};n(this.mParameters.custom,function(t,e){i.custom[t]=e});e.push(this.oModel.createCustomParams(i))}function a(e){t.iLength=parseInt(e);t.bLengthFinal=true}function r(t){var e="Request for $count failed: "+t.message;if(t.response){e+=", "+t.response.statusCode+", "+t.response.statusText+", "+t.response.body}s.warning(e)}var h=this.oModel.resolve(this.sPath,this.oContext);if(h){var o=this.oModel._createRequestUrl(h+"/$count",null,e);var l=this.oModel._createRequest(o,"GET",false);l.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(l,a,r,undefined,undefined,this.oModel.getServiceMetadata())}};c.prototype.refresh=function(t,e,i){var s=false;if(!t){if(i){var a=this.oModel.resolve(this.sPath,this.oContext);var r=this.oModel.oMetadata._getEntityTypeByPath(a);if(r&&r.entityType in i){s=true}}if(e&&!s){n(this.aKeys,function(t,i){if(i in e){s=true;return false}return true})}if(!e&&!i){s=true}}if(t||s){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:o.Refresh})}};c.prototype._fireRefresh=function(t){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",t)}};c.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()){if(this.bDataAvailable){this._fireChange({reason:o.Change})}else{this._fireRefresh({reason:o.Refresh})}}};c.prototype.checkUpdate=function(t,e){var i=this.sChangeReason?this.sChangeReason:o.Change,s=false,r,h,l=this,u,f;if(this.bSuspended&&!this.bIgnoreSuspend){return}if(!t&&!this.bNeedsUpdate){u=this.oModel._getObject(this.sPath,this.oContext);f=Array.isArray(u)&&!a(u,this.aExpandRefs);this.aExpandRefs=u;if(f){if(this.aSorters.length>0||this.aFilters.length>0){this.refresh();return}else{this.aKeys=u;this.iLength=u.length;this.bLengthFinal=true;s=true}}else if(e){n(this.aKeys,function(t,i){if(i in e){s=true;return false}return true})}else{s=true}if(s&&this.aLastContexts){s=false;var d=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=d.length){s=true}else{n(this.aLastContexts,function(t,e){r=l.oLastContextData[e.getPath()];h=d[t].getObject();if(!a(r,h,true)){s=true;return false}return true})}}}if(t||s||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:i})}this.sChangeReason=undefined;this.bIgnoreSuspend=false};c.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==t.Request||this.sCountMode==t.Both)){this._getLength()}};c.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false}};c.prototype.sort=function(t,e){var i=false;if(!t){t=[]}if(t instanceof p){t=[t]}this.aSorters=t;this.createSortParams(t);if(!this.bInitial){this.aKeys=[];this.abortPendingRequest();this.sChangeReason=o.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:t});i=true}if(e){return i}else{return this}};c.prototype.createSortParams=function(t){this.sSortParams=e.createSortParams(t)};c.prototype.filter=function(t,e,i){var s=false;if(!t){t=[]}if(t instanceof l){t=[t]}this.oModel.checkFilter(t);if(e==f.Application){this.aApplicationFilters=t}else{this.aFilters=t}if(!t||!Array.isArray(t)||t.length==0){this.aFilters=[]}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)||this.aApplicationFilters.length===0){this.aApplicationFilters=[]}this.convertFilters();this.oCombinedFilter=u.combineFilters(this.aFilters,this.aApplicationFilters);this.createFilterParams(this.oCombinedFilter);if(!this.bInitial){this.resetData();this.abortPendingRequest();this.sChangeReason=o.Filter;this._fireRefresh({reason:this.sChangeReason});if(e==f.Application){this._fireFilter({filters:this.aApplicationFilters})}else{this._fireFilter({filters:this.aFilters})}s=true}if(i){return s}else{return this}};c.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(t){return t instanceof g?t.convert():t});this.aApplicationFilters=this.aApplicationFilters.map(function(t){return t instanceof g?t.convert():t})};c.prototype.createFilterParams=function(t){this.sFilterParams=e.createFilterParams(t,this.oModel.oMetadata,this.oEntityType)};c.prototype._initSortersFilters=function(){var t=this.oModel.resolve(this.sPath,this.oContext);if(!t){return}this.oEntityType=this._getEntityType();this.convertFilters();this.oCombinedFilter=u.combineFilters(this.aFilters,this.aApplicationFilters);this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter)};c.prototype._getEntityType=function(){var t=this.oModel.resolve(this.sPath,this.oContext);if(t){var e=this.oModel.oMetadata._getEntityTypeByPath(t);i(e,"EntityType for path "+t+" could not be found!");return e}return undefined};c.prototype.resume=function(){this.bIgnoreSuspend=false;d.prototype.resume.apply(this,arguments)};return c});
//# sourceMappingURL=ODataListBinding.js.map