/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataUtils","sap/ui/thirdparty/URI","sap/ui/core/Messaging","sap/ui/core/message/MessageParser","sap/ui/core/message/Message","sap/ui/core/message/MessageType","sap/base/Log"],function(e,r,t,s,a,i,n,o,u){"use strict";var d="sap.ui.model.odata.ODataMessageParser",c=/^\/+|\/$/g,l={error:o.Error,info:o.Information,success:o.Success,warning:o.Warning};var h=i.extend("sap.ui.model.odata.ODataMessageParser",{metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},constructor:function(e,r,t){i.apply(this);this._serviceUrl=g(this._parseUrl(e).url);this._metadata=r;this._headerField="sap-message";this._lastMessages=[];this._bPersistTechnicalMessages=t}});h.prototype.getHeaderField=function(){return this._headerField};h.prototype.setHeaderField=function(e){this._headerField=e;return this};h.prototype.parse=function(e,r,t,s,a){var i,n,o=String(e.statusCode);if(r.method==="GET"&&o==="204"){return}n={request:r,response:e,url:r.requestUri};if(e.statusCode>=200&&e.statusCode<300){i=this._parseHeader(e,n)}else if(e.statusCode>=400&&e.statusCode<600){try{i=this._parseBody(e,n)}catch(e){i=this._createGenericError(n);u.debug("Failed to parse error messages from the response body",e,d)}finally{this._logErrorMessages(i,r,o)}}else{i=this._createGenericError(n);u.error("Request failed with unsupported status code "+o+": "+r.method+" "+r.requestUri,undefined,d)}if(r.method==="GET"&&o==="424"){return}this._propagateMessages(i,n,t,s,!a)};h.prototype._getAffectedTargets=function(e,r,t,s){var a=Object.assign({"":true},t,s),i,n=this._parseUrl(r.url).url;if(r.request.key&&r.request.created){a[r.request.key]=true}if(n.startsWith(this._serviceUrl)){n=n.slice(this._serviceUrl.length+1)}i=this._metadata._getEntitySetByPath(n);if(i){a[i.name]=true}e.forEach(function(e){e.getTargets().forEach(function(e){var r,t,s;if(!e){return}s=e.replace(c,"");a[s]=true;t=s.lastIndexOf("/");if(t>0){r=s.slice(0,t);a[r]=true}})});return a};h.prototype._propagateMessages=function(e,t,s,i,n){var o,l=t.request.deepPath,h=[],p,f=l&&t.request.updateAggregatedMessages,g=t.request.headers&&t.request.headers["sap-messages"]==="transientOnly",y=[],_=r._returnsCollection(t.request.functionMetadata),m,v,M;function T(e,r){return r.some(function(e){return o[e]})||f&&e.aFullTargets.some(function(e){if(_){return p.some(function(r){var t=r.slice(r.indexOf("("));return e.startsWith(l+t)})}else{return e.startsWith(l)}})}s=s||{};if(g){h=this._lastMessages;m=e.some(function(e){return!e.getPersistent()&&!e.getTechnical()});if(m){u.error("Unexpected non-persistent message in response, but requested only "+"transition messages",undefined,d)}}else{o=this._getAffectedTargets(e,t,s,i);p=Object.keys(s);v=t.response.statusCode;M=v>=200&&v<300;this._lastMessages.forEach(function(e){var r=e.getTargets().map(function(e){e=e.replace(c,"");var r=e.lastIndexOf(")/");if(r>0){e=e.substr(0,r+1)}return e});if(M||n){if(!e.getPersistent()&&T(e,r)){y.push(e)}else{h.push(e)}}else if(!e.getPersistent()&&e.getTechnical()&&T(e,r)){y.push(e)}else{h.push(e)}})}a.updateMessages(y,e);this._lastMessages=h.concat(e)};h.prototype._createMessage=function(e,r,t){var s=e.target&&e.target.indexOf("/#TRANSIENT#")===0||e.transient||e.transition||t&&this._bPersistTechnicalMessages,a,i=typeof e.message==="object"?e.message.value:e.message,o=e["@sap.severity"]||e.severity;e.transition=!!s;a=this._createTargets(e,r,t);return new n({code:e.code||"",description:e.description,descriptionUrl:e.longtext_url||"",fullTarget:a.aDeepPaths,message:i,persistent:!!s,processor:this._processor,target:a.aTargets,technical:t,technicalDetails:{headers:r.response.headers,statusCode:r.response.statusCode},type:l[o]||o})};h._isResponseForCreate=function(e){var r=e.request,t=e.response;if(r.method==="POST"&&t.statusCode==201&&t.headers["location"]){return true}if(r.key&&r.created&&t.statusCode>=400){return false}return undefined};h.prototype._createTarget=function(e,r,s,a){var i,n,o,u,d,c,l,p,f,g=r.request,y=r.response;if(e===undefined&&(!s&&g.headers["sap-message-scope"]==="BusinessObject"||s&&a)){return{deepPath:"",target:""}}e=e||"";e=e.startsWith("/#TRANSIENT#")?e.slice(12):e;if(e[0]!=="/"){n=h._isResponseForCreate(r);o=g.deepPath||"";if(n===true){f=y.headers["location"]}else if(n===false){f=g.key}else{f=r.url}p=this._parseUrl(f);l=p.url;u=l.indexOf(this._serviceUrl);if(u>-1){c=l.slice(u+this._serviceUrl.length)}else{c="/"+l}if(!n&&g.functionMetadata){c=g.functionTarget}if(c.slice(c.lastIndexOf("/")).indexOf("(")>-1||!this._metadata._isCollection(c)){o=e?o+"/"+e:o;e=e?c+"/"+e:c}else{o=o+e;e=c+e}}i=this._processor.resolve(e,undefined,true);while(i&&i.lastIndexOf("/")>0&&i!==d){d=i;i=this._processor.resolve(i,undefined,true)||d}e=i||e;return{deepPath:t._normalizeKey(this._metadata._getReducedPath(o||e)),target:t._normalizeKey(e)}};h.prototype._createTargets=function(e,r,t){var s=[],a=Array.isArray(e.additionalTargets)?[e.target].concat(e.additionalTargets):[e.target],i,n=[],o=this;if(e.propertyref!==undefined&&a[0]!==undefined){u.warning("Used the message's 'target' property for target calculation; the property"+" 'propertyref' is deprecated and must not be used together with 'target'",r.url,d)}else if(a[0]===undefined){a[0]=e.propertyref}a.forEach(function(a){i=o._createTarget(a,r,t,e.transition);s.push(i.deepPath);n.push(i.target)});return{aDeepPaths:s,aTargets:n}};h.prototype._parseHeader=function(e,r){var t,s,a,i,n=this.getHeaderField(),o=[];if(!e.headers){return o}for(s in e.headers){if(s.toLowerCase()===n.toLowerCase()){n=s}}if(!e.headers[n]){return o}a=e.headers[n];try{i=JSON.parse(a);o.push(this._createMessage(i,r));if(Array.isArray(i.details)){for(t=0;t<i.details.length;t+=1){o.push(this._createMessage(i.details[t],r))}}}catch(e){u.error("The message string returned by the back-end could not be parsed: '"+e.message+"'");return o}return o};h.prototype._parseBody=function(e,r){var t=p(e);return t&&t.indexOf("xml")>-1?this._parseBodyXML(e,r,t):this._parseBodyJSON(e,r)};h.prototype._createGenericError=function(r){return[this._createMessage({description:r.response.body,message:e.getResourceBundleFor("sap.ui.core").getText("CommunicationError"),severity:o.Error,transition:true},r,true)]};h.prototype._getBodyMessages=function(e,r,t){var s=t.request.headers["Content-ID"],a=[],i=this._createMessage(e,t,true),n=this;r.forEach(function(e){var r=n._createMessage(e,t,true);if(i&&i.getCode()===r.getCode()&&i.getMessage()===r.getMessage()){i=undefined}if(!s||!e.ContentID||s===e.ContentID){a.push(r)}});if(i){a.unshift(i)}return a};h.prototype._logErrorMessages=function(e,r,t){var s=e.length?JSON.stringify(e.map(function(e){return{code:e.getCode(),message:e.getMessage(),persistent:e.getPersistent(),targets:e.getTargets(),type:e.getType()}})):"Another request in the same change set failed";u.error("Request failed with status code "+t+": "+r.method+" "+r.requestUri,s,d)};h.prototype._parseBodyXML=function(e,r,t){var s,a,i,n,u,d,c,l=(new DOMParser).parseFromString(e.body,t),h=y(l,["error","errordetail"]),p=[];if(!h.length){return this._createGenericError(r)}for(n=0;n<h.length;n+=1){c=h[n];i={};i.severity=o.Error;for(d=0;d<c.childNodes.length;d+=1){s=c.childNodes[d];a=s.nodeName;if(a==="errordetails"||a==="details"||a==="innererror"||a==="#text"){continue}if(a==="message"&&s.hasChildNodes()&&s.firstChild.nodeType!==window.Node.TEXT_NODE){for(u=0;u<s.childNodes.length;u+=1){if(s.childNodes[u].nodeName==="value"){i.message=s.childNodes[u].text||s.childNodes[u].textContent}}}else{i[s.nodeName]=s.text||s.textContent}}p.push(i)}return this._getBodyMessages(p[0],p.slice(1),r)};h.prototype._parseBodyJSON=function(e,r){var t,s,a=JSON.parse(e.body);if(a.error){s=a.error}else{s=a["odata.error"]}if(!s){u.error("Error message returned by server did not contain error-field");return this._createGenericError(r)}s.severity=o.Error;if(Array.isArray(s.details)){t=s.details}else if(s.innererror&&Array.isArray(s.innererror.errordetails)){t=s.innererror.errordetails}else{t=[]}return this._getBodyMessages(s,t,r)};h.prototype._parseUrl=function(e){var r={url:e,parameters:{},hash:""};var t=-1;t=e.indexOf("#");if(t>-1){r.hash=r.url.substr(t+1);r.url=r.url.substr(0,t)}t=e.indexOf("?");if(t>-1){var a=r.url.substr(t+1);r.parameters=s.parseQuery(a);r.url=r.url.substr(0,t)}return r};h.prototype._setPersistTechnicalMessages=function(e){this._bPersistTechnicalMessages=e};function p(e){if(e&&e.headers){for(var r in e.headers){if(r.toLowerCase()==="content-type"){return e.headers[r].replace(/([^;]*);.*/,"$1")}}}return false}var f=document.createElement("a");function g(e){f.href=e;return s.parse(f.href).path}function y(e,r){var t=[];var s={};for(var a=0;a<r.length;a+=1){s[r[a]]=true}var i=e;while(i){if(s[i.tagName]){t.push(i)}if(i.hasChildNodes()){i=i.firstChild}else{while(!i.nextSibling){i=i.parentNode;if(!i||i===e){i=null;break}}if(i){i=i.nextSibling}}}return t}return h});
//# sourceMappingURL=ODataMessageParser.js.map