/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_ODataMetaModelUtils","sap/base/Log","sap/base/i18n/Localization","sap/base/util/isEmptyObject","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/model/_Helper","sap/ui/model/BindingMode","sap/ui/model/ClientContextBinding","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/MetaModel","sap/ui/model/json/JSONListBinding","sap/ui/model/json/JSONModel","sap/ui/model/json/JSONPropertyBinding","sap/ui/model/json/JSONTreeBinding"],function(e,t,n,o,i,r,a,s,d,l,u,c,p,h,f,y,g){"use strict";var m=new Map,C="sap.ui.model.odata.ODataMetaModel",O=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;const M=/^(((\/dataServices\/schema\/\d+)\/entityContainer\/\d+)\/functionImport\/\d+)\/parameter\/\d+$/;var v=h.extend("sap.ui.model.odata.ODataMetaListBinding"),b=r.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});v.prototype.applyFilter=function(){var e=this,t=c.combineFilters(this.aFilters,this.aApplicationFilters);this.aIndices=c.apply(this.aIndices,t,function(t,n){return n==="@sapui.name"?t:e.oModel.getProperty(n,e.oList[t])},this.mNormalizeCache);this.iLength=this.aIndices.length};var S=p.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(t,n,o){var i=o.annotationsLoaded(),r=this;function l(){var i;if(r.bDestroyed){throw new Error("Meta model already destroyed")}i=JSON.parse(JSON.stringify(t.getServiceMetadata()));r.oModel=new f(i);r.oModel.setDefaultBindingMode(r.sDefaultBindingMode);if(!o._requestAnnotationChanges){e.merge(n?n.getData():{},i,r,o.bIgnoreAnnotationsFromMetadata);return undefined}return o._requestAnnotationChanges().then(t=>{e.merge(n?n.getData():{},i,r,o.bIgnoreAnnotationsFromMetadata);r.aAnnotationChanges=s.deepClone(t,20);r._applyAnnotationChanges()})}p.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=d.OneTime;this.oLoadedPromise=i?i.then(l):new Promise(function(e){l();e()});this.oLoadedPromiseSync=a.resolve(this.oLoadedPromise);this.oMetadata=t;this.oDataModel=o;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={OneTime:true}}});S.prototype._applyAnnotationChanges=function(){if(!this.aAnnotationChanges){return}const e=[];this.aAnnotationChanges.forEach(t=>{const n=this._getObject(t.path,undefined,true);if(n){this.oModel.setProperty(n,t.value)}else{e.push(t)}});this.aAnnotationChanges=e.length?e:undefined};S.prototype._getObject=function(e,n,o){var r=n,a,s,d,l,c,p,h,f=e||"",y;if(!n||n instanceof u){f=this.resolve(e||"",n);if(!f){t.error("Invalid relative path w/o context",e,C);return null}}if(f.charAt(0)==="/"){r=this.oModel._getObject("/");f=f.slice(1)}h="/";c=r;while(f){p=undefined;a=undefined;if(f.charAt(0)==="["){try{y=i.parseExpression(f,1);l=y.at;if(f.length===l+1||f.charAt(l+1)==="/"){a=y.result;p=f.slice(0,l+1);f=f.slice(l+2)}}catch(e){if(!(e instanceof SyntaxError)){throw e}}}if(p===undefined){l=f.indexOf("/");if(l<0){p=f;f=""}else{p=f.slice(0,l);f=f.slice(l+1)}}if(!c){if(o){return null}if(t.isLoggable(t.Level.WARNING,C)){t.warning("Invalid part: "+p,"path: "+e+", context: "+(n instanceof u?n.getPath():n),C)}break}if(a){if(r===n){t.error("A query is not allowed when an object context has been given",e,C);return null}if(!Array.isArray(c)){t.error("Invalid query: '"+h+"' does not point to an array",e,C);return null}s=h+p;p=this.mQueryCache[s];if(p===undefined){this.oResolver=this.oResolver||new b({models:this.oModel});for(d=0;d<c.length;d+=1){this.oResolver.bindObject(h+d);this.oResolver.bindProperty("any",a);try{if(this.oResolver.getAny()){this.mQueryCache[s]=p=d;break}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject()}}}}c=c[p];h=h+p+"/"}return o?h:c};S.prototype._getOrCreateSharedModelCache=function(){var e=this.oDataModel;if(!this.oSharedModelCache){this.oSharedModelCache={bFirstCodeListRequested:false,oModel:new e.constructor(e.getCodeListModelParameters())}}return this.oSharedModelCache};S.prototype._mergeMetadata=function(t){var n=this.getODataEntityContainer(),o=e.getChildAnnotations(t.annotations,n.namespace+"."+n.name,true),i=n.entitySet.length,r=this.oModel.getObject("/dataServices/schema"),a=this;t.entitySets.forEach(function(o){var i,s,d=o.entityType,l=d.slice(0,d.lastIndexOf("."));if(!a.getODataEntitySet(o.name)){n.entitySet.push(JSON.parse(JSON.stringify(o)));if(!a.getODataEntityType(d)){i=a.oMetadata._getEntityTypeByName(d);s=e.getSchema(r,l);s.entityType.push(JSON.parse(JSON.stringify(i)));e.visitParents(s,t.annotations,"entityType",e.visitEntityType,s.entityType.length-1)}}});e.visitChildren(n.entitySet,o,"EntitySet",r,null,i);e.addUnitAnnotations(r,this)};S.prototype._sendBundledRequest=function(){var e=this.mQName2PendingRequest,t=Object.keys(e),n=this;if(!t.length){return}this.mQName2PendingRequest={};t=t.sort();t.forEach(function(e,n){t[n]=encodeURIComponent(e)});this.oDataModel.addAnnotationUrl("$metadata?sap-value-list="+t.join(",")).then(function(t){var o;n._mergeMetadata(t);for(o in e){try{e[o].resolve(t)}catch(t){e[o].reject(t)}}n._applyAnnotationChanges()},function(t){var n;for(n in e){e[n].reject(t)}})};S.prototype.bindContext=function(e,t,n){return new l(this,e,t,n)};S.prototype.bindList=function(e,t,n,o,i){return new v(this,e,t,n,o,i)};S.prototype.bindProperty=function(e,t,n){return new y(this,e,t,n)};S.prototype.bindTree=function(e,t,n,o){return new g(this,e,t,n,o)};S.prototype.destroy=function(){p.prototype.destroy.apply(this,arguments);if(this.oSharedModelCache){this.oSharedModelCache.oModel.destroy();delete this.oSharedModelCache}return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments)};S.cleanupCodeListModelURLParameters=function(e,t){let o=false;e.aUrlParams=e.aUrlParams.join("&").split("&").filter(e=>{if(e.startsWith("sap-language=")){o=true;return true}return e.startsWith("sap-client=")});if(!o){const o=new URL(t,"https://localhost").searchParams;e.aUrlParams.push("sap-language="+(o.get("sap-language")??n.getSAPLogonLanguage()))}};S.prototype.fetchCodeList=function(e){var n=this;return this.oLoadedPromiseSync.then(function(){var o,i,r,s,d,l,u,c,p,h="com.sap.vocabularies.CodeList.v1."+e,f=n.getODataEntityContainer()[h];if(!f||!f.Url.String){return null}if(f.Url.String!=="./$metadata"){throw new Error(h+"/Url/String has to be './$metadata' for the service "+n.oDataModel.getCodeListModelParameters().serviceUrl)}d=f.CollectionPath.String;u=n.oDataModel.getMetadataUrl();o=u+"#"+d;c=m.get(o);if(c){return c}i=o+"#"+n.getId();c=m.get(i);if(c){return c}s=n._getOrCreateSharedModelCache();r=s.oModel;p=new a(function(e,t){S.cleanupCodeListModelURLParameters(r,u);r._read("/"+d,{error:t,success:e,urlParameters:{$skip:0,$top:5e3}},undefined,n.oDataModel._request.bind(n.oDataModel))});l=new a(function(e,t){try{e(n._getPropertyNamesForCodeListCustomizing(d))}catch(e){t(e)}});c=a.all([p,l]).then(function(e){var r=e[0].results,a=e[1];m.set(o,c);m.delete(i);return r.reduce(function(e,o){var i=o[a.code],r={Text:o[a.text],UnitSpecificScale:o[a.unitSpecificScale]};if(a.standardCode){r.StandardCode=o[a.standardCode]}if(r.UnitSpecificScale===null){t.error("Ignoring customizing w/o unit-specific scale for code "+i+" from "+d,n.oDataModel.getCodeListModelParameters().serviceUrl,C)}else{e[i]=r}return e},{})}).catch(function(e){if(r.bDestroyed){m.delete(o);m.delete(i)}else{t.error("Couldn't load code list: "+d+" for "+n.oDataModel.getCodeListModelParameters().serviceUrl,e,C)}throw e}).finally(function(){if(s.bFirstCodeListRequested){if(!r.bDestroyed){r.destroy()}delete n.oSharedModelCache}else{s.bFirstCodeListRequested=true}});m.set(i,c);return c})};S.prototype.getMetaContext=function(e){var t,n,o,i,r,a,s,d,l;function u(e){var t=e.indexOf("(");return t>=0?e.slice(0,t):e}if(!e){return null}d=e.split("/");if(d[0]!==""){throw new Error("Not an absolute path: "+e)}d.shift();s=u(d[0]);n=this.getODataEntitySet(s);if(n){l=n.entityType}else{i=this.getODataFunctionImport(s);if(i){if(d.length===1){r=this.getODataFunctionImport(s,true)}l=i.returnType;if(l.lastIndexOf("Collection(",0)===0){l=l.slice(11,-1)}}else{throw new Error("Entity set or function import not found: "+s)}}d.shift();while(d.length){o=this.getODataEntityType(l);if(o){a=u(d[0]);t=this.getODataAssociationEnd(o,a)}else{o=this.getODataComplexType(l)}if(t){l=t.type;if(t.multiplicity==="1"&&a!==d[0]){throw new Error("Multiplicity is 1: "+d[0])}d.shift()}else{r=this.getODataProperty(o,d,true);if(d.length){throw new Error("Property not found: "+d.join("/"))}break}}r=r||this.getODataEntityType(l,true);return this.createBindingContext(r)};S.prototype.getODataAssociationEnd=function(t,n){var o=t?e.findObject(t.navigationProperty,n):null,i=o?e.getObject(this.oModel,"association",o.relationship):null,r=i?e.findObject(i.end,o.toRole,"role"):null;return r};S.prototype.getODataAssociationSetEnd=function(t,n){var o,i=null,r=this.getODataEntityContainer(),a=t?e.findObject(t.navigationProperty,n):null;if(r&&a){o=e.findObject(r.associationSet,a.relationship,"association");i=o?e.findObject(o.end,a.toRole,"role"):null}return i};S.prototype.getODataComplexType=function(t,n){return e.getObject(this.oModel,"complexType",t,n)};S.prototype.getODataEntityContainer=function(t){var n=t?undefined:null,o=this.oModel.getObject("/dataServices/schema");if(o){o.forEach(function(o,i){var r=e.findIndex(o.entityContainer,"true","isDefaultEntityContainer");if(r>=0){n=t?"/dataServices/schema/"+i+"/entityContainer/"+r:o.entityContainer[r]}});if(!n&&o.length===1&&o[0].entityContainer&&o[0].entityContainer.length===1){n=t?"/dataServices/schema/0/entityContainer/0":o[0].entityContainer[0]}}return n};S.prototype.getODataEntitySet=function(t,n){return e.getFromContainer(this.getODataEntityContainer(),"entitySet",t,n)};S.prototype.getODataEntityType=function(t,n){return e.getObject(this.oModel,"entityType",t,n)};S.prototype.getODataFunctionImport=function(t,n){var o=t&&t.indexOf("/")>=0?t.split("/"):undefined,i=o?e.getObject(this.oModel,"entityContainer",o[0]):this.getODataEntityContainer();return e.getFromContainer(i,"functionImport",o?o[1]:t,n)};S.prototype.getFunctionImportParameterContext=function(t,n){const o=this.getODataFunctionImport(t,true);if(!o){throw new Error(`Function import "${t}" not found`)}const i=this.getObject(o);const r=e.findIndex(i.parameter,n);if(r<0){throw new Error(`Parameter "${n}" not found for function import "${t}"`)}return this.createBindingContext(o+"/parameter/"+r)};S.prototype.getODataProperty=function(t,n,o){var i,r=Array.isArray(n)?n:[n],a=null,s;while(t&&r.length){i=e.findIndex(t.property,r[0]);if(i<0){break}r.shift();a=t.property[i];s=t.$path+"/property/"+i;if(r.length){t=this.getODataComplexType(a.type)}}return o?s:a};S.prototype.getODataValueLists=function(t){var n=false,i,r=t.getPath(),a=this.mContext2Promise[r],s=this;if(a){return a}let d=false;i=O.exec(r);if(!i){i=M.exec(r);d=true}if(!i){throw new Error(`"${r}" neither references a property nor a function import parameter`)}a=new Promise(function(a,l){var u=t.getObject(),c=e.getValueLists(u);const p=""in c&&s.getODataEntitySet(c[""].CollectionPath.String);if(!p&&u["sap:value-list"]){n=true;const t=s.oModel.getObject(i[i.length-1]).namespace+"."+s.oModel.getObject(i[i.length-2]).name;const p=(d?s.oModel.getObject(i[1]).name+"/":"")+u.name;s.mQName2PendingRequest[t+"/"+p]={resolve:function(n){const i=n.annotations[d?"EntityContainer":"propertyAnnotations"]?.[t]?.[p]||{};Object.keys(i).forEach(e=>{if(!u.hasOwnProperty(e)){u[e]=i[e]}});c=e.getValueLists(u);if(o(c)){l(new Error("No value lists returned for "+r))}else{delete s.mContext2Promise[r];a(c)}},reject:l};setTimeout(s._sendBundledRequest.bind(s),0)}else{a(c)}});if(n){this.mContext2Promise[r]=a}return a};S.prototype.getProperty=function(){return this._getObject.apply(this,arguments)};S.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments)};S.prototype.loaded=function(){return this.oLoadedPromise};S.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh")};S.prototype.requestCurrencyCodes=function(){return Promise.resolve(this.fetchCodeList("CurrencyCodes")).then(function(e){return e?s.merge({},e):e})};S.prototype.requestUnitsOfMeasure=function(){return Promise.resolve(this.fetchCodeList("UnitsOfMeasure")).then(function(e){return e?s.merge({},e):e})};S.prototype.setLegacySyntax=function(e){if(e){throw new Error("Legacy syntax not supported by ODataMetaModel")}};S.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty")};S.prototype._getPropertyNamesForCodeListCustomizing=function(e){var t="/"+e+"/##",n=this.oDataModel.getObject(t),o=n["Org.OData.Core.V1.AlternateKeys"],i=S._getKeyPath(n,t),r=this.oDataModel.getObject("/"+e+"/"+i+"/##");if(o){if(o.length!==1){throw new Error("Single alternative expected: "+t+"Org.OData.Core.V1.AlternateKeys")}else if(o[0].Key.length!==1){throw new Error("Single key expected: "+t+"Org.OData.Core.V1.AlternateKeys/0/Key")}i=o[0].Key[0].Name.Path}return{code:i,standardCode:r["com.sap.vocabularies.CodeList.v1.StandardCode"]&&r["com.sap.vocabularies.CodeList.v1.StandardCode"].Path,text:r["com.sap.vocabularies.Common.v1.Text"].Path,unitSpecificScale:r["com.sap.vocabularies.Common.v1.UnitSpecificScale"].Path}};S._getKeyPath=function(e,t){var n=e.key.propertyRef;if(n&&n.length===1){return n[0].name}throw new Error("Single key expected: "+t)};S.getCodeListTerm=function(e){if(e==="/##@@requestCurrencyCodes"){return"CurrencyCodes"}else if(e==="/##@@requestUnitsOfMeasure"){return"UnitsOfMeasure"}return undefined};S.clearCodeListsCache=function(){m.clear()};return S});
//# sourceMappingURL=ODataMetaModel.js.map