/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/_Helper","sap/ui/model/ChangeReason","sap/ui/model/Context","sap/ui/model/Filter","sap/ui/model/TreeBinding","sap/ui/model/TreeBindingUtils","sap/ui/model/odata/v2/ODataTreeBinding"],function(e,t,i,n,r,o,s,a,d,l,h,u){"use strict";var f="sap.ui.model.odata.ODataTreeBindingFlat";var p=function(){if(!(this instanceof l)||this._bIsAdapted){return}for(var e in p.prototype){if(p.prototype.hasOwnProperty(e)){this[e]=p.prototype[e]}}this.mParameters=this.mParameters||{};this._iPageSize=0;this._aNodes=this._aNodes||[];this._aNodeCache=[];this._aCollapsed=this._aCollapsed||[];this._aExpanded=this._aExpanded||[];this._aRemoved=[];this._aAdded=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._aTurnedToLeaf=[];this._mSubtreeHandles={};this._iLowestServerLevel=null;this._aExpandedAfterSelectAll=this._aExpandedAfterSelectAll||[];this._mSelected=this._mSelected||{};this._mDeselected=this._mDeselected||{};this._bSelectAll=false;this._iLengthDelta=0;if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive}this._bIsAdapted=true;this._bReadOnly=true;this._aPendingRequests=[];this._aPendingChildrenRequests=[];this._aPendingSubtreeRequests=[];this._bSubmitChangesCalled=false};p.prototype.setNumberOfExpandedLevels=function(e){this.resetData();u.prototype.setNumberOfExpandedLevels.apply(this,arguments)};p.prototype.getContexts=function(e,t,i){return this._getContextsOrNodes(false,e,t,i)};p.prototype._getContextsOrNodes=function(e,t,i,n){if(!this.isResolved()||this.isInitial()){return[]}t=t||0;i=i||this.oModel.iSizeLimit;n=n||0;this._iPageSize=i;this._iThreshold=n;if(this._aNodes.length==0&&!this.isLengthFinal()){this._loadData(t,i,n)}var r=[];var o=this._retrieveNodeSection(t,i);this._aNodeCache=[];var s;var a=0;var d=0;var l={};for(var h=0;h<o.length;h++){var u=o[h];this._aNodeCache[t+h]=u&&u.context?u:undefined;r.push(u.context);if(!u.context){if(u.serverIndex!=undefined){if(s==undefined){s=u.serverIndex}d=u.serverIndex}else if(u.positionInParent!=undefined){var f=u.parent;l[f.key]=l[f.key]||[];l[f.key].push(u)}}}a=1+Math.max(d-(s||0),0);if(s!=undefined&&a){this._loadData(s,a,n)}for(var p in l){var c=this._calculateRequestParameters(l[p]);this._loadChildren(l[p][0].parent,c.skip,c.top)}if(e){return o}else{return r}};p.prototype._calculateRequestParameters=function(e){var t,i=e[0].positionInParent,n=e[0].parent,r=Math.min(i+Math.max(this._iThreshold,e.length),n.children.length);for(t=i;t<r;t++){var o=n.children[t];if(o){break}}return{skip:i,top:t-i}};p.prototype._retrieveNodeSection=function(e,t){return this._bReadOnly?this._indexRetrieveNodeSection(e,t):this._mapRetrieveNodeSection(e,t)};p.prototype._hasPendingRequest=function(e){return this._aPendingChildrenRequests.some(t=>t.sParent===e)};p.prototype._turnNodeToLeaf=function(e){e.nodeState.collapsed=false;e.nodeState.expanded=false;e.nodeState.isLeaf=true;e.nodeState.wasExpanded=true;this._aTurnedToLeaf.push(e)};p.prototype._mapRetrieveNodeSection=function(e,t){const i=this.getLength()-1;var n=-1;var r=[];let o;this._map((s,a,d,l,h)=>{n++;if(s&&this._aRemoved.length){if(o&&o.nodeState.expanded&&o.level>=s.level&&!this._hasPendingRequest(o.key)){this._turnNodeToLeaf(o)}else if(s.nodeState.expanded&&i===n&&!this._hasPendingRequest(s.key)){this._turnNodeToLeaf(s)}}o=s;if(n>=e){if(!s){if(d=="serverIndex"){s={serverIndex:l}}else if(d=="positionInParent"){s={positionInParent:l,parent:h}}}r.push(s)}if(r.length>=t){a.broken=true}});return r};p.prototype._indexRetrieveNodeSection=function(e,t){var i,n=[],r,o;for(i=e;i<e+t;i++){r=this.getNodeInfoByRowIndex(i);if(r.index!==undefined&&r.index<this._aNodes.length){o=this._aNodes[r.index];if(!o){o={serverIndex:r.index}}}else if(r.parent){o=r.parent.children[r.childIndex];if(!o){o={parent:r.parent,positionInParent:r.childIndex}}}if(o){n.push(o);o=null}}return n};p.prototype.getNodes=function(e,t,i){return this._getContextsOrNodes(true,e,t,i)};p.prototype._map=function(e){var t,i,n,r,o={broken:false};t=function(e){if(e.addedSubtrees.length>0&&!e.nodeState.collapsed){for(var t=0;t<e.addedSubtrees.length;t++){var n=e.addedSubtrees[t];i(e,n);if(o.broken){return}}}};i=function(e,t){var i=t._getSubtree();if(t){if(Array.isArray(i)){if(t._oSubtreeRoot){r(i,t._oSubtreeRoot.serverIndex,t._oSubtreeRoot,t._oSubtreeRoot.originalLevel||0,e.level+1)}else{r(i,null,null,0,e.level+1)}}else{t._oSubtreeRoot.level=e.level+1;n(t._oSubtreeRoot,false,t._oNewParentNode,-1,t._oSubtreeRoot)}}};n=function(i,r,s,a,d){if(!r){if(!i.nodeState.removed||d==i){e(i,o,"positionInParent",a,s);if(o.broken){return}}}t(i);if(o.broken){return}if(i&&i.children&&i.nodeState.expanded){for(var l=0;l<i.children.length;l++){var h=i.children[l];if(h&&!h.nodeState.removed&&!h.nodeState.reinserted){h.level=i.level+1}if(h&&!h.nodeState.removed){n(h,false,i,l,d)}else if(!h){e(h,o,"positionInParent",l,i)}if(o.broken){return}}}};r=function(i,r,s,a,d){for(var l=0;l<i.length;l++){var h=i[l];if(h&&h.nodeState&&h.nodeState.removed&&h!=s){if(!h.initiallyCollapsed){l+=h.magnitude}continue}if(h&&a>=0&&d>=0){h.level=h.originalLevel||0;var u=h.level-a||0;h.level=d+u||0}if(r===null){e(h,o,"newNode")}else{e(h,o,"serverIndex",r+l)}if(o.broken){return}if(h&&h.nodeState){if(!h.initiallyCollapsed&&h.nodeState.collapsed){l+=h.magnitude}else if(h.initiallyCollapsed&&h.nodeState.expanded){n(h,true);if(o.broken){return}}else if(!h.initiallyCollapsed&&h.nodeState.expanded){t(h)}}if(o.broken){return}}};r(this._aNodes,0,null)};p.prototype._loadData=function(e,t,i){var n=this;if(!this.bSkipDataEvents){this.fireDataRequested()}this.bSkipDataEvents=false;return this._requestServerIndexNodes(e,t,i).then(function(e){n._addServerIndexNodes(e.oData,e.iSkip);n._fireChange({reason:s.Change});n.fireDataReceived({data:e.oData})},function(e){var t=e.statusCode===0;if(!t){n._aNodes=[];n._bLengthFinal=true;n._fireChange({reason:s.Change});n.fireDataReceived()}})};p.prototype._restoreServerIndexNodes=function(e,t,i){var n=this;return this._requestServerIndexNodes(e,t,0,i).then(function(e){n._addServerIndexNodes(e.oData,e.iSkip);return e})};p.prototype._addServerIndexNodes=function(e,i){var n,r,o,s,a=function(e,t){return!e.isDeepOne&&!e.initiallyCollapsed&&e.serverIndex<o&&e.serverIndex+e.magnitude>=o};if(!this._bLengthFinal){var d=e.__count?parseInt(e.__count):0;this._aNodes[d-1]=undefined;this._bLengthFinal=true}if(e.results&&e.results.length>0){for(s=0;s<e.results.length;s++){n=e.results[s];r=this.oModel.getKey(n);o=i+s;const d=n[this.oTreeProperties["hierarchy-node-descendant-count-for"]];let h=Number(d);if(h<0){h=0;t.error("The entry data with key '"+r+"' under binding path '"+this.getPath()+"' has a negative 'hierarchy-node-descendant-count-for' which isn't allowed.")}if(!Number.isSafeInteger(h)){t.error("The value of magnitude is not a safe integer: "+JSON.stringify(d),this.getResolvedPath(),f)}var l=this._aNodes[o]=this._aNodes[o]||{key:r,context:this.oModel.getContext("/"+r,this.oModel.resolveDeep(this.sPath,this.oContext)+r.slice(r.indexOf("("))),magnitude:h,level:n[this.oTreeProperties["hierarchy-level-for"]],originalLevel:n[this.oTreeProperties["hierarchy-level-for"]],initiallyCollapsed:n[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",initiallyIsLeaf:n[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",nodeState:{isLeaf:n[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:n[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:n[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[r]?this._mSelected[r].nodeState.selected:false},children:[],addedSubtrees:[],serverIndex:o,parent:null,originalParent:null,isDeepOne:false};if(this._iLowestServerLevel===null){this._iLowestServerLevel=l.level}else{this._iLowestServerLevel=Math.min(this._iLowestServerLevel,l.level)}if(this._bSelectAll){if(!this._aExpandedAfterSelectAll.some(a)){this.setNodeSelection(l,true)}}}}};p.prototype._requestServerIndexNodes=function(e,t,i,n){return new Promise(function(r,o){var s={iSkip:e,iTop:t+(i||0),iThreshold:i};this._aPendingRequests.sort(function(e,t){return e.iSkip-t.iSkip});for(var a=0;a<this._aPendingRequests.length;a++){if(h._determineRequestDelta(s,this._aPendingRequests[a])===false){return}}e=s.iSkip;t=s.iTop;function l(i){var n=this._aPendingRequests.indexOf(s);this._aPendingRequests.splice(n,1);r({oData:i,iSkip:e,iTop:t})}function u(e){var t=this._aPendingRequests.indexOf(s);this._aPendingRequests.splice(t,1);o(e)}var f=["$skip="+e,"$top="+t];if(!this._bLengthFinal||n){f.push("$inlinecount=allpages")}if(this.sCustomParams){f.push(this.sCustomParams)}var p=new d(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels());var c=[p];if(this.aApplicationFilters){c=c.concat(this.aApplicationFilters)}var _=this.getResolvedPath();if(_){s.oRequestHandle=this.oModel.read(_,{headers:this._getHeaders(),urlParameters:f,filters:[new d({filters:c,and:true})],sorters:this.aSorters||[],success:l.bind(this),error:u.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingRequests.push(s)}}.bind(this))};p.prototype._propagateMagnitudeChange=function(e,t){while(e!=null&&(e.initiallyCollapsed||e.isDeepOne)){e.magnitude+=t;if(!e.nodeState.expanded){return}e=e.parent}};p.prototype._getInitialMagnitude=function(e){var t=0,i;if(e.isDeepOne){return 0}if(e.children){for(var n=0;n<e.children.length;n++){i=e.children[n];t+=i.magnitude+1}}return e.magnitude-t};p.prototype._loadChildren=function(e,t,i){var n=this;if(!this.bSkipDataEvents){this.fireDataRequested()}this.bSkipDataEvents=false;this._requestChildren(e,t,i).then(function(t){n._addChildNodes(t.oData,e,t.iSkip);n._fireChange({reason:s.Change});n.fireDataReceived({data:t.oData})},function(t){var i=t.statusCode===0;if(!i){if(e.childCount===undefined){e.children=[];e.childCount=0;n._fireChange({reason:s.Change})}n.fireDataReceived()}})};p.prototype._restoreChildren=function(e,t,i){var n=this,r=e.context.getProperty(this.oTreeProperties["hierarchy-node-for"]);return this._requestChildren(e,t,i,true).then(function(e){var t;n._map(function(e,i){if(e&&e.context.getProperty(n.oTreeProperties["hierarchy-node-for"])===r){t=e;i.broken=true}});if(t){n._addChildNodes(e.oData,t,e.iSkip);n.expand(t,true)}return e})};p.prototype._addChildNodes=function(e,t,i){if(t.childCount==undefined&&e&&e.__count){var n=e.__count?parseInt(e.__count):0;t.childCount=n;t.children[n-1]=undefined;if(t.nodeState.expanded){this._propagateMagnitudeChange(t,n)}else{t.magnitude=n}this._cleanTreeStateMaps()}if(e.results&&e.results.length>0){for(var r=0;r<e.results.length;r++){var o=e.results[r];this._createChildNode(o,t,i+r)}}};p.prototype._createChildNode=function(e,t,i){var n=this.oModel.getKey(e);var r;if(t.containingServerIndex!==undefined){r=t.containingServerIndex}else{r=t.serverIndex}var o=t.children[i]=t.children[i]||{key:n,context:this.oModel.getContext("/"+n,this.oModel.resolveDeep(this.sPath,this.oContext)+n.slice(n.indexOf("("))),magnitude:0,level:t.level+1,originalLevel:t.level+1,initiallyCollapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",initiallyIsLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",nodeState:{isLeaf:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:e[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[n]?this._mSelected[n].nodeState.selected:false},positionInParent:i,children:[],addedSubtrees:[],parent:t,originalParent:t,isDeepOne:true,containingServerIndex:r};if(this._bSelectAll&&this._aExpandedAfterSelectAll.indexOf(t)===-1){this.setNodeSelection(o,true)}return o};p.prototype._requestChildren=function(e,t,i,n){return new Promise(function(r,o){var s={sParent:e.key,iSkip:t,iTop:i};this._aPendingChildrenRequests.sort(function(e,t){return e.iSkip-t.iSkip});for(var a=0;a<this._aPendingChildrenRequests.length;a++){var l=this._aPendingChildrenRequests[a];if(l.sParent===s.sParent){if(h._determineRequestDelta(s,l)===false){return}}}t=s.iSkip;i=s.iTop;function u(e){var n=this._aPendingChildrenRequests.indexOf(s);this._aPendingChildrenRequests.splice(n,1);r({oData:e,iSkip:t,iTop:i})}function f(e){var t=this._aPendingChildrenRequests.indexOf(s);this._aPendingChildrenRequests.splice(t,1);o(e)}var p=["$skip="+t,"$top="+i];if(e.childCount==undefined||n){p.push("$inlinecount=allpages")}if(this.sCustomParams){p.push(this.sCustomParams)}var c=new d(this.oTreeProperties["hierarchy-parent-node-for"],"EQ",e.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var _=[c];if(this.aApplicationFilters){_=_.concat(this.aApplicationFilters)}var v=this.getResolvedPath();if(v){s.oRequestHandle=this.oModel.read(v,{headers:this._getHeaders(),urlParameters:p,filters:[new d({filters:_,and:true})],sorters:this.aSorters||[],success:u.bind(this),error:f.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingChildrenRequests.push(s)}}.bind(this))};p.prototype._loadSubTree=function(e,i){var n=this;var r;if(e.serverIndex!==undefined&&!e.initiallyCollapsed){var o=[];var s;var a=e.serverIndex+1;var d=a+e.magnitude;for(var l=a;l<d;l++){if(this._aNodes[l]===undefined){if(!s){s={iSkip:l,iTop:1};o.push(s)}else{s.iTop++}}else{s=null}}if(o.length){r=Promise.all(o.map(function(e){return n._loadData(e.iSkip,e.iTop)}))}}if(!r){r=Promise.resolve()}return r.then(function(){if(!n.bSkipDataEvents){n.fireDataRequested()}n.bSkipDataEvents=false;return n._requestSubTree(e,i).then(function(t){n._addSubTree(t.oData,e);n.fireDataReceived({data:t.oData})},function(e){t.warning("ODataTreeBindingFlat: Error during subtree request",e.message);var i=e.statusCode===0;if(!i){n.fireDataReceived()}})})};p.prototype._addSubTree=function(e,t){if(e.results&&e.results.length>0){var i,n,r,o,s,a=[],d={},l,h,u;if(t.serverIndex!==undefined&&!t.initiallyCollapsed){a=this._aNodes.slice(t.serverIndex,t.serverIndex+t.magnitude+1)}else{a.push(t)}for(h=a.length-1;h>=0;h--){o=a[h];if(o.nodeState.isLeaf){continue}if(o.initiallyCollapsed||o.isDeepOne){o.childCount=undefined;if(o.magnitude&&o.nodeState.expanded){this._propagateMagnitudeChange(o.parent,-o.magnitude)}o.magnitude=0}d[o.context.getProperty(this.oTreeProperties["hierarchy-node-for"])]=o}for(l=0;l<e.results.length;l++){r=e.results[l];i=r[this.oTreeProperties["hierarchy-node-for"]];if(d[i]){continue}n=r[this.oTreeProperties["hierarchy-parent-node-for"]];s=d[n];if(s.childCount===undefined){s.childCount=0}o=s.children[s.childCount];if(o){a.push(o);if(o.childCount){o.childCount=undefined;if(o.initiallyCollapsed||o.isDeepOne){o.magnitude=0}}}else{o=this._createChildNode(r,s,s.childCount);if(o.nodeState.expanded){this._aExpanded.push(o);this._sortNodes(this._aExpanded)}}s.childCount++;if(s.nodeState.expanded){this._propagateMagnitudeChange(s,1)}else{s.magnitude++}if(!o.nodeState.isLeaf){d[i]=o}}for(u=a.length-1;u>=0;u--){o=a[u];if(!o.nodeState.expanded&&!o.nodeState.isLeaf){this.expand(o,true)}}}};p.prototype._requestSubTree=function(e,t){return new Promise(function(i,n){var r={sParent:e.key,iLevel:t};for(var o=0;o<this._aPendingSubtreeRequests.length;o++){var s=this._aPendingSubtreeRequests[o];if(s.sParent===r.sParent&&s.iLevel===r.iLevel){return}}function a(e){var t=this._aPendingSubtreeRequests.indexOf(r);this._aPendingSubtreeRequests.splice(t,1);i({oData:e,sParent:r.sParent,iLevel:r.iLevel})}function l(e){var t=this._aPendingSubtreeRequests.indexOf(r);this._aPendingSubtreeRequests.splice(t,1);n(e)}var h=[];if(this.sCustomParams){h.push(this.sCustomParams)}const u=this.oTreeProperties["hierarchy-node-for"];const f=new d(u,"EQ",e.context.getProperty(u));var p=new d(this.oTreeProperties["hierarchy-level-for"],"LE",t);var c=[f,p];if(this.aApplicationFilters){c=c.concat(this.aApplicationFilters)}var _=this.getResolvedPath();if(_){r.oRequestHandle=this.oModel.read(_,{headers:this._getHeaders(),urlParameters:h,filters:[new d({filters:c,and:true})],sorters:this.aSorters||[],success:a.bind(this),error:l.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingSubtreeRequests.push(r)}}.bind(this))};p.prototype.findNode=function(e){return this._bReadOnly?this._indexFindNode(e):this._mapFindNode(e)};p.prototype._mapFindNode=function(e){if(this.isInitial()){return undefined}var t=this._aNodeCache[e];if(t){return t}var i=-1;this._map(function(n,r,o,s,a){i++;if(i===e){t=n;r.broken=true}});return t};p.prototype._indexFindNode=function(e){if(this.isInitial()){return undefined}var t=this._aNodeCache[e];if(t){return t}var i=this.getNodeInfoByRowIndex(e);if(i.parent){t=i.parent.children[i.childIndex]}else{t=this._aNodes[i.index]}this._aNodeCache[e]=t;return t};p.prototype.toggleIndex=function(t){var i=this.findNode(t);e(i!=undefined,"toggleIndex("+t+"): Node not found!");if(i){if(i.nodeState.expanded){this.collapse(i)}else{this.expand(i)}}};p.prototype.expand=function(t,i){var n=t;if(typeof t!=="object"){n=this.findNode(t);e(n!=undefined,"expand("+t+"): Node not found!")}if(n.nodeState.expanded){return}n.nodeState.expanded=true;n.nodeState.collapsed=false;var r=this._aCollapsed.indexOf(n);if(r!=-1){this._aCollapsed.splice(r,1)}this._aExpanded.push(n);this._sortNodes(this._aExpanded);if(n.serverIndex!==undefined){this._aNodeChanges[n.serverIndex]=true}if(this._bSelectAll){this._aExpandedAfterSelectAll.push(n)}if(n.initiallyCollapsed&&n.childCount==undefined){this._loadChildren(n,0,this._iPageSize+this._iThreshold)}else{this._propagateMagnitudeChange(n.parent,n.magnitude)}this._cleanTreeStateMaps();this._aNodeCache=[];if(!i){this._fireChange({reason:s.Expand})}};p.prototype.expandToLevel=function(e){this.setNumberOfExpandedLevels(e)};p.prototype.expandNodeToLevel=function(e,t,i){if(!this._bReadOnly){return Promise.reject(new Error("ODataTreeBindingFlat: expandNodeToLevel is not supported while there are pending changes in the hierarchy"))}var n=this.findNode(e);return this._loadSubTree(n,t).then(function(){if(!i){this._fireChange({reason:s.Expand})}}.bind(this))};p.prototype.collapse=function(t,i){var n=t;if(typeof t!=="object"){n=this.findNode(t);e(n!=undefined,"expand("+t+"): Node not found!")}if(n.nodeState.collapsed){return}n.nodeState.expanded=false;n.nodeState.collapsed=true;var r=this._aExpanded.indexOf(n);if(r!=-1){this._aExpanded.splice(r,1)}if(this._bSelectAll){r=this._aExpandedAfterSelectAll.indexOf(n);if(r!==-1){this._aExpandedAfterSelectAll.splice(r,1)}}this._aCollapsed.push(n);this._sortNodes(this._aCollapsed);if(n.isDeepOne){this._propagateMagnitudeChange(n.parent,n.magnitude*-1)}if(n.serverIndex!==undefined){this._aNodeChanges[n.serverIndex]=true}this._cleanUpSelection();this._cleanTreeStateMaps();this._aNodeCache=[];if(!i){this._fireChange({reason:s.Collapse})}};p.prototype.collapseToLevel=function(e){var t=-1,i=[],n;if(this.bCollapseRecursive){for(var r in this._mSelected){var o=this._mSelected[r];if(o.level>e){n=this.getRowIndexByNode(o);i.push(n);if(this._sLeadSelectionKey==r){t=n}this.setNodeSelection(o,false)}}}this.setNumberOfExpandedLevels(e);if(this.bCollapseRecursive&&i.length){this._publishSelectionChanges({rowIndices:i,oldIndex:t,leadIndex:-1})}};p.prototype._getInvisibleSelectedNodes=function(){var e=[];var t=true;var i=function(e,i){if(e.nodeState.collapsed||e.nodeState.removed&&!e.nodeState.reinserted){t=false;i.broken=true}};for(var n in this._mSelected){var r=this._mSelected[n];t=true;this._up(r,i,false);if(!t){e.push(r)}}return e};p.prototype._cleanUpSelection=function(e){var t=this._getInvisibleSelectedNodes();t.forEach(function(t){if(t.key==this._sLeadSelectionKey){this._sLeadSelectionKey=null}if(this.bCollapseRecursive||e){this.setNodeSelection(t,false)}}.bind(this));if((this.bCollapseRecursive||e)&&t.length){this._publishSelectionChanges({rowIndices:[],indexChangesCouldNotBeDetermined:true})}};p.prototype._isInSubtree=function(e,t){var i=false;var n=function(t,n){if(t==e){n.broken=true;i=true}};this._up(t,n,false);return i};p.prototype._up=function(e,t,i){var n={broken:false};var r=this._getParent(e,i);if(r){this._structuralUp(r,t,n,i)}else{this._flatUp(e,t,n,true)}};p.prototype._structuralUp=function(e,t,i,n){var r=e;do{t(r,i);if(i.broken){return}e=r;r=this._getParent(r)}while(r);this._flatUp(e,t,i)};p.prototype._flatUp=function(e,t,i,n){var r=e.serverIndex,o=n?r-1:r,s,a;for(;o>=0;o--){if(this._aNodeChanges[o]){s=this._aNodes[o];if(s.initiallyCollapsed){continue}if(s.serverIndex+s.magnitude>=r){t(s,i);if(i.broken){return}a=this._getParent(s);if(a){this._structuralUp(a,t,i);return}}else{continue}}}};p.prototype._getParent=function(e,t){return t?e.originalParent:e.parent};p.prototype._cleanTreeStateMaps=function(){this._iLengthDelta=this._bReadOnly?this._indexCleanTreeStateMaps():this._mapCleanTreeStateMaps()};p.prototype._indexCleanTreeStateMaps=function(){return this._calcIndexDelta(this._aNodes.length)};p.prototype._mapCleanTreeStateMaps=function(){var e=this._aCollapsed.concat(this._aRemoved).concat(this._aExpanded).concat(this._aAdded),t=true,i,n=0,r=function(e,i){if(e.nodeState.isLeaf||e.nodeState.collapsed||e.nodeState.removed&&!e.nodeState.reinserted){t=false;i.broken=true}},o={};var s=[[0,1],[-1,0]];e.forEach(function(e){if(o[e.key]){return}else{o[e.key]=true}if(e.nodeState.added){if(!e.nodeState.removed||e.nodeState.reinserted){t=true;this._up(e,r,false);if(t){n++}}}else if(e.nodeState.collapsed||e.nodeState.expanded||e.nodeState.removed){t=true;this._up(e,r,false);if(t){if(e.nodeState.removed&&!e.nodeState.reinserted){if(e.isDeepOne||e.initiallyCollapsed){n-=1}else{n-=e.magnitude+1}}else{if(e.nodeState.collapsed&&e.serverIndex!==undefined&&!e.initiallyCollapsed){n-=e.magnitude}if(e.nodeState.expanded&&(e.isDeepOne||e.initiallyCollapsed)){n+=e.children.length}}}if(e.nodeState.reinserted){i=t;t=true;this._up(e,r,true);var a=s[t|0][i|0];if(a){if(e.isDeepOne){n+=a*1}else if(e.initiallyCollapsed){n+=a}else{n+=a*(1+e.magnitude)}}}}}.bind(this));return n};p.prototype.isLengthFinal=function(){return this._bLengthFinal};p.prototype.getLength=function(){return this._aNodes.length+this._iLengthDelta};p.prototype.getContextByIndex=function(e){if(this.isInitial()){return undefined}var t=this.findNode(e);return t&&t.context};p.prototype.getNodeByIndex=function(e){if(this.isInitial()){return undefined}var t=this.findNode(e);return t};p.prototype.isExpanded=function(e){var t=this.findNode(e);return t&&t.nodeState.expanded};p.prototype.hasChildren=function(e){if(!e){return false}var t=this._findNodeByContext(e);var i=t&&t.node;return!(i&&i.nodeState.isLeaf)};p.prototype.nodeHasChildren=function(e){return!(e&&e.nodeState.isLeaf)};p.prototype._hasChangedEntity=function(e){var t=false;this._map(function(i,n){if(i&&i.key in e){t=true;n.broken=true}});return t};p.prototype._isRefreshAfterChangeAllowed=function(){return!this._isRestoreTreeStateSupported()};p.prototype._isRestoreTreeStateSupported=function(){return this._bRestoreTreeStateAfterChange&&(!this.aApplicationFilters||this.aApplicationFilters.length===0)};p.prototype._hasPendingChanges=function(e){var t;if(!this.isResolved()||!this._aAllChangedNodes.length){return false}t=this._optimizeChanges();if(t.added.length||t.moved.length||t.removed.length){return true}t.creationCancelled.forEach(function(t){var i=e.indexOf(t.key);if(i>-1){e.splice(i,1)}});return false};p.prototype._getPendingChanges=function(){var e,t,i,n,r={};if(this.isResolved()){i=this._optimizeChanges();e=i.added.concat(i.moved);t=this.oTreeProperties["hierarchy-node-for"];n=this.oTreeProperties["hierarchy-parent-node-for"];e.forEach(function(e){r[e.key]={};r[e.key][n]=e.parent.context.getProperty(t)});i.removed.forEach(function(e){r[e.key]={}});i.creationCancelled.forEach(function(e){r[e.key]=null})}return r};p.prototype._resetChanges=function(e){var t,i=this.getResolvedPath();if(!i||!this._aAllChangedNodes.length){return}if(e){t=e.some(function(e){return e===i});if(!t){return}}this._aRemoved.forEach(e=>{this._resetMovedOrRemovedNode(e)});this._aAdded.forEach(e=>{this._resetParentState(e)});this._aTurnedToLeaf.forEach(e=>{if(!e.initiallyIsLeaf){e.nodeState.isLeaf=false;e.nodeState.expanded=true;e.nodeState.collapsed=false;delete e.nodeState.wasExpanded}});this._mSubtreeHandles={};this._aAdded=[];this._aRemoved=[];this._aAllChangedNodes=[];this._aNodeCache=[];this._aTurnedToLeaf=[];this._cleanTreeStateMaps();this._fireChange({reason:s.Change})};p.prototype.setNodeSelection=function(t,i){e(t,"Node must be defined!");t.nodeState.selected=i;if(i){delete this._mDeselected[t.key];this._mSelected[t.key]=t}else{delete this._mSelected[t.key];this._mDeselected[t.key]=t;if(t.key===this._sLeadSelectionKey){this._sLeadSelectionKey=null}}};p.prototype.isIndexSelected=function(e){var t=this.findNode(e);return t&&t.nodeState?t.nodeState.selected:false};p.prototype.isIndexSelectable=function(e){var t=this.findNode(e);return!!t};p.prototype._clearSelection=function(){return this._bReadOnly?this._indexClearSelection():this._mapClearSelection()};p.prototype._indexClearSelection=function(){var e=-1,t=[],i,n,r;this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(i in this._mSelected){n=this._mSelected[i];this.setNodeSelection(n,false);r=this.getRowIndexByNode(n);t.push(r);if(this._sLeadSelectionKey==i){e=r}}return{rowIndices:t,oldIndex:e,leadIndex:-1}};p.prototype._mapClearSelection=function(){var e=-1;var t=-1;var i=0;var n=[];this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(var r in this._mSelected){if(r){i++}}this._map(function(r,o,s,a,d){e++;if(r&&r.nodeState.selected){this.setNodeSelection(r,false);n.push(e);if(this._sLeadSelectionKey==r.key){t=e}if(n.length==i){o.broken=true}}}.bind(this));return{rowIndices:n,oldIndex:t,leadIndex:-1}};p.prototype.setSelectedIndex=function(e){var i=this.findNode(e);if(i){var n=this._clearSelection();var r=n.rowIndices.indexOf(e);if(r>=0){n.rowIndices.splice(r,1)}else{n.rowIndices.push(e)}n.leadKey=i.key;n.leadIndex=e;this.setNodeSelection(i,true);this._publishSelectionChanges(n)}else{t.warning("ODataTreeBindingFlat: The selection of index '"+e+"' was ignored. Please make sure to only select rows, for which data has been fetched to the client.")}};p.prototype.getSelectedIndex=function(){return this._bReadOnly?this._indexGetSelectedIndex():this._mapGetSelectedIndex()};p.prototype._indexGetSelectedIndex=function(){if(!this._sLeadSelectionKey||n(this._mSelected)){return-1}var e=this._mSelected[this._sLeadSelectionKey];if(e){return this.getRowIndexByNode(e)}else{return-1}};p.prototype._mapGetSelectedIndex=function(){if(!this._sLeadSelectionKey||n(this._mSelected)){return-1}var e=-1;this._map(function(t,i){e++;if(t){if(t.key===this._sLeadSelectionKey){i.broken=true}}}.bind(this));return e};p.prototype.getSelectedIndices=function(){return this._bReadOnly?this._indexGetSelectedIndices():this._mapGetSelectedIndices()};p.prototype._indexGetSelectedIndices=function(){var e=this._getSelectedNodesInfo();return e.map(function(e){return e.rowIndex})};p.prototype._mapGetSelectedIndices=function(){var e=[];if(n(this._mSelected)){return e}var t=-1;this._map(function(i){t++;if(i){if(i.nodeState&&i.nodeState.selected){e.push(t)}}});return e};p.prototype.getSelectedNodesCount=function(){var t;if(this._bSelectAll){if(this._bReadOnly){var i=[],n=0,r;this._aExpandedAfterSelectAll.sort(function(t,i){var n=this._getRelatedServerIndex(t);var r=this._getRelatedServerIndex(i);e(n!=undefined,"getSelectedNodesCount: (containing) Server-Index not found for node 'a'");e(r!=undefined,"getSelectedNodesCount: (containing) Server-Index not found node 'b'");if(n==r&&t.isDeepOne&&i.isDeepOne){return t.originalLevel-i.originalLevel}return n-r}.bind(this));var o=-1,s,a,d;for(d=0;d<this._aExpandedAfterSelectAll.length;d++){s=this._aExpandedAfterSelectAll[d];a=this._getRelatedServerIndex(s);if(a<=o&&!s.initiallyCollapsed){continue}if(s.initiallyCollapsed){o=a}else{o=a+s.magnitude}i.push(s);n+=s.magnitude}var l=function(e,t){if(i.indexOf(e)!==-1){n--;t.broken=true}};for(r in this._mSelected){this._up(this._mSelected[r],l,true)}var h;var u=function(e,t){if(e.nodeState.collapsed||e.nodeState.removed&&!e.nodeState.reinserted||i.indexOf(e)!==-1){h=false;t.broken=true}};for(r in this._mDeselected){h=true;this._up(this._mDeselected[r],u,true);if(h){n++}}t=this.getLength()-n}else{t=0;this._map(function(e,i,n,r,o){var s;if(e){if(e.nodeState.selected){t++}}else if(e===undefined&&n==="serverIndex"){var a=true;for(var d=r-1;d>=0;d--){if(this._aNodeChanges[d]){s=this._aNodes[d];if(s.serverIndex+s.magnitude>=r&&this._aExpandedAfterSelectAll.indexOf(s)!==-1){a=false;break}}}if(a){t++}}}.bind(this))}}else{var f=this._getInvisibleSelectedNodes();t=Math.max(Object.keys(this._mSelected).length-f.length,0)}return t};p.prototype.getSelectedContexts=function(){return this._bReadOnly?this._indexGetSelectedContexts():this._mapGetSelectedContexts()};p.prototype._indexGetSelectedContexts=function(){var e=this._getSelectedNodesInfo();return e.map(function(e){return e.node.context})};p.prototype._mapGetSelectedContexts=function(){var e=[];if(n(this._mSelected)){return e}var t=function(t){if(t){if(t.nodeState.selected&&!t.isArtificial){e.push(t.context)}}};this._map(t);return e};p.prototype.setSelectionInterval=function(e,t){var i,n,r=this._clearSelection(),o={},s=[],a=this._setSelectionInterval(e,t,true);for(n=0;n<r.rowIndices.length;n++){i=r.rowIndices[n];o[i]=true}for(n=0;n<a.rowIndices.length;n++){i=a.rowIndices[n];if(o[i]){delete o[i]}else{o[i]=true}}for(i in o){if(o[i]){s.push(parseInt(i))}}this._publishSelectionChanges({rowIndices:s,oldIndex:r.oldIndex,leadIndex:a.leadIndex,leadKey:a.leadKey})};p.prototype._setSelectionInterval=function(e,t,i){return this._bReadOnly?this._indexSetSelectionInterval(e,t,i):this._mapSetSelectionInterval(e,t,i)};p.prototype._indexSetSelectionInterval=function(e,t,i){var n=Math.min(e,t),r=Math.max(e,t),o=[],s=[],a,d,l,h;i=!!i;for(l=n;l<=r;l++){d=this.findNode(l);if(d){if(d.nodeState.selected!==i){s.push(l)}if(d.key===this._sLeadSelectionKey){a=l}this.setNodeSelection(d,i);o.push(d)}}h={rowIndices:s,oldIndex:a,leadIndex:a&&!i?-1:undefined};if(o.length>0&&i){h.leadKey=o[o.length-1].key;h.leadIndex=r}return h};p.prototype._mapSetSelectionInterval=function(e,t,i){var n=Math.min(e,t);var r=Math.max(e,t);var o=[];var s=[];var a=Math.abs(r-n)+1;var d;var l=-1;var h=function(e,t,h,u,f){l++;if(e){if(l>=n&&l<=r){if(e.nodeState.selected!==!!i){s.push(l)}if(e.key===this._sLeadSelectionKey){d=l}this.setNodeSelection(e,!!i);o.push(e);if(o.length===a){t.broken=true}}}}.bind(this);this._map(h);var u={rowIndices:s,oldIndex:d,leadIndex:d&&!i?-1:undefined};if(o.length>0&&i){var f=o[o.length-1];u.leadKey=f.key;u.leadIndex=r}return u};p.prototype.addSelectionInterval=function(e,t){var i=this._setSelectionInterval(e,t,true);this._publishSelectionChanges(i)};p.prototype.removeSelectionInterval=function(e,t){var i=this._setSelectionInterval(e,t,false);this._publishSelectionChanges(i)};p.prototype.selectAll=function(){if(this._bReadOnly){this._indexSelectAll()}else{this._mapSelectAll()}};p.prototype._indexSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var e={rowIndices:[],oldIndex:-1,selectAll:true};var t=this.getLength(),i,n;for(i=0;i<t;i++){n=this.findNode(i);if(n&&!n.isArtificial){if(n.key===this._sLeadSelectionKey){e.oldIndex=i}if(!n.nodeState.selected){e.rowIndices.push(i)}this.setNodeSelection(n,true);e.leadKey=n.key;e.leadIndex=i}}this._publishSelectionChanges(e)};p.prototype._mapSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var e={rowIndices:[],oldIndex:-1,selectAll:true};var t=-1;this._map(function(i){if(!i||!i.isArtificial){t++}if(i){if(i.key===this._sLeadSelectionKey){e.oldIndex=t}if(i){if(!i.isArtificial&&!i.nodeState.selected){e.rowIndices.push(t)}this.setNodeSelection(i,true);e.leadKey=i.key;e.leadIndex=t}}}.bind(this));this._publishSelectionChanges(e)};p.prototype.clearSelection=function(e){var t=this._clearSelection();if(!e){this._publishSelectionChanges(t)}};p.prototype._publishSelectionChanges=function(e){e.oldIndex=e.oldIndex||this.getSelectedIndex();e.rowIndices.sort(function(e,t){return e-t});if(e.leadIndex>=0&&e.leadKey){this._sLeadSelectionKey=e.leadKey}else if(e.leadIndex===-1){this._sLeadSelectionKey=undefined}else{e.leadIndex=e.oldIndex}if(e.rowIndices.length>0||e.leadIndex!=undefined&&e.leadIndex!==-1||e.indexChangesCouldNotBeDetermined){this.fireSelectionChanged(e)}};p.prototype.setCollapseRecursive=function(e){this.bCollapseRecursive=!!e};p.prototype.resetData=function(){u.prototype.resetData.apply(this,arguments);this._aNodes=[];this._aNodeCache=[];this._aCollapsed=[];this._aExpanded=[];this._aExpandedAfterSelectAll=[];this._mSelected={};this._mDeselected={};this._aAdded=[];this._aRemoved=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._bLengthFinal=false;this._iLowestServerLevel=null;this._bSelectAll=false;this._bReadOnly=true;this._iLengthDelta=0};p.prototype._findNodeByContext=function(e){for(var t in this._aNodeCache){if(this._aNodeCache[t]&&this._aNodeCache[t].context==e){return{node:this._aNodeCache[t],index:parseInt(t)}}}var i=-1;var n;this._map(function(t,r,o,s,a){i++;if(t){if(t.context===e){n=t;r.broken=true}}});return{node:n,index:i}};p.prototype.createEntry=function(e){var i,n=this.getResolvedPath();if(n){e=e||{};if(e.expand){throw new Error("Parameter 'expand' is not supported")}if(e.inactive){throw new Error("Parameter 'inactive' is not supported")}e.groupId=this.oModel._resolveGroup(n).groupId;e.refreshAfterChange=false;i=this.oModel.createEntry(n,e)}else{t.warning("ODataTreeBindingFlat: createEntry failed, as the binding path could not be resolved.")}return i};p.prototype.submitChanges=function(e){var i=this.getResolvedPath();if(!i){t.error("#submitChanges failed: binding is unresolved",this.getPath(),f);return}this._bSubmitChangesCalled=true;e=e||{};e.groupId=this.oModel._resolveGroup(i).groupId;this.oModel.submitChanges(e)};p.prototype._submitChanges=function(e){var i,n,r=e.groupId,o=this.getResolvedPath(),s=false,a=this;function d(e){t.error("Tree state restoration request failed for binding: "+o,e,f)}if(!o||r&&r!==this.oModel._resolveGroup(o).groupId){this._bSubmitChangesCalled=false;return}n=this._optimizeChanges();i=Object.values(n).some(function(e){return e.length});if(!i&&!this._bSubmitChangesCalled){return}this.bRefresh=false;this._bSubmitChangesCalled=false;e.success=function(e,i){var r,l=e.__batchResponses&&e.__batchResponses[0]&&e.__batchResponses[0].__changeResponses;if(l&&l.length>0){r=l.some(function(e){var t=parseInt(e.statusCode);return t<200||t>299});if(r){}else if(!s&&a._isRestoreTreeStateSupported()){a._restoreTreeState(n).catch(function(e){d(e);a._refresh(true)})}else if(!a.bRefresh){a._refresh(true)}}else if(i){t.warning("#submitChanges: no change response in batch response",o,f)}};this._generateSubmitData(n,function(e){d(e);s=true})};p.prototype._generateSubmitData=function(i,n){var r=i.added,o=i.creationCancelled,s=i.moved,a=i.removed,d={error:n,groupId:this.oModel._resolveGroup(this.getResolvedPath()).groupId},l=this;function h(t){e(t.context,"Node does not have a context.");var i=t.parent.context.getProperty(l.oTreeProperties["hierarchy-node-for"]);l.oModel.setProperty(l.oTreeProperties["hierarchy-parent-node-for"],i,t.context)}r.forEach(h);s.forEach(function(e){h(e);if(this._isRestoreTreeStateSupported()){this._generatePreorderPositionRequest(e,d);this._generateSiblingsPositionRequest(e,d)}}.bind(this));a.forEach(function(e){this._generateDeleteRequest(e);t.debug("ODataTreeBindingFlat: DELETE "+e.key)}.bind(this));o.forEach(function(e){this._generateDeleteRequest(e)}.bind(this))};p.prototype._generatePreorderPositionRequest=function(e,t){var i,n,r,s,a,l=[],h=this.getResolvedPath(),u=[],f=this;if(!h){return}t=t||{};r=t.success||function(){};s=function(t){f._updateNodeInfoAfterSave(e,t.results||[]);r.apply(null,arguments)};if(this.aApplicationFilters){l=l.concat(this.aApplicationFilters)}for(i=this._aTreeKeyProperties.length-1;i>=0;i--){n=this._aTreeKeyProperties[i];u.push(n);l.push(new d(n,"EQ",e.context.getProperty(n)))}l.push(new d(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels()));a=o.extend({},this.mParameters);u=u.concat([this.oTreeProperties["hierarchy-node-for"],this.oTreeProperties["hierarchy-node-descendant-count-for"],this.oTreeProperties["hierarchy-drill-state-for"],this.oTreeProperties["hierarchy-preorder-rank-for"]]);a.select=u.join(",");this.oModel.read(h,{headers:this._getHeaders(),filters:[new d({filters:l,and:true})],error:t.error,groupId:t.groupId||this.sGroupId,sorters:this.aSorters,success:s,urlParameters:this.oModel.createCustomParams(a)})};p.prototype._generateSiblingsPositionRequest=function(e,t){var n,r,o,s;if(t){n=t.groupId||this.sGroupId;o=t.success;s=t.error}r=i({},this.mParameters);r.select=this.oTreeProperties["hierarchy-sibling-rank-for"];this.oModel.read(e.context.getPath(),{headers:this._getHeaders(),urlParameters:this.oModel.createCustomParams(r),groupId:n,success:o,error:s})};p.prototype._nodeIsOnTopLevel=function(e){if(e&&e.serverIndex>=0){var i=e.parent==null;if(i){if(e.originalLevel==this._iLowestServerLevel){return true}else{return false}}}else{t.warning("ODataTreeBindingFlat.nodeIsOnTopLevel: Node is not defined or not a server-indexed node.")}return undefined};p.prototype._generateDeleteRequest=function(e){var t=e.context;if(e.nodeState.added){this.oModel._discardEntityChanges(t.getPath().slice(1),true);return undefined}else{var i=this.oModel.remove(t.getPath(),{groupId:this.oModel._resolveGroup(this.getResolvedPath()).groupId,refreshAfterChange:false});return i}};p.prototype._filterChangeForServerSections=function(e){var t={};t.removed=e.removed.filter(function(e){return!e.isDeepOne});t.added=e.added.filter(function(e){return!e.isDeepOne});e.moved.forEach(function(e){if(!e.newIsDeepOne){t.added.push(e)}if(!e.isDeepOne){t.removed.push(e)}});return t};p.prototype._filterChangesForDeepSections=function(e){var t={};e.removed.forEach(function(e){var i;if(e.isDeepOne){i=e.parent;if(!t[i.key]){t[i.key]={added:[],removed:[]}}t[i.key].removed.push(e)}});e.added.forEach(function(e){var i;if(e.isDeepOne){i=e.parent;if(!t[i.key]){t[i.key]={added:[],removed:[]}}t[i.key].added.push(e)}});e.moved.forEach(function(e){var i;if(e.newIsDeepOne){i=e.parent;if(!t[i.key]){t[i.key]={added:[],removed:[]}}t[i.key].added.push(e)}if(e.isDeepOne){i=e.originalParent;if(!t[i.key]){t[i.key]={added:[],removed:[]}}t[i.key].removed.push(e)}});return t};p.prototype._optimizeOptimizedChanges=function(e){var t,i=this;t=e.added.slice();t.sort(function(e,t){var n=e.newIsDeepOne!==undefined?e.newIsDeepOne:e.isDeepOne,r=t.newIsDeepOne!==undefined?t.newIsDeepOne:t.isDeepOne;if(n&&r){return 0}if(n){return 1}if(r){return-1}return e.context.getProperty(i.oTreeProperties["hierarchy-preorder-rank-for"])-t.context.getProperty(i.oTreeProperties["hierarchy-preorder-rank-for"])});var n=-1;t=t.filter(function(e,t){if(e.newIsDeepOne!==undefined?e.newIsDeepOne:e.isDeepOne){return true}if(t<=n){return false}var r=e.context.getProperty(i.oTreeProperties["hierarchy-node-descendant-count-for"]);if(r){n=t+r}return true});return{added:t,removed:e.removed,moved:e.moved}};p.prototype._updateNodeInfoAfterSave=function(e,t){var i,n,r=e.context,o=this.oTreeProperties["hierarchy-drill-state-for"],s=this.oTreeProperties["hierarchy-node-for"],a=r.getProperty(s);n=!t.some(function(e){return a===e[s]});i=r.getProperty(o)==="collapsed";if(this._aAdded.includes(e)){e.isDeepOne=n;e.initiallyCollapsed=i}else{e.newIsDeepOne=n;e.newInitiallyCollapsed=i}};p.prototype._requestExtraInfoForAddedNodes=function(e){var t=[],i=this;e.forEach(function(e){var n=new Promise(function(t,n){i._generatePreorderPositionRequest(e,{success:t,error:n})});t.push(n)});t=t.map(function(e){return e.then(function(e){return{responseData:e}},function(e){return{error:e}})});return Promise.all(t).then(function(e){var t=0;e.forEach(function(e){if(e.error){if(e.error.statusCode===0){t++}else{throw new Error("Tree state restoration request failed. Complete or partial tree state might get lost. Error: "+(e.error.message.value||e.error.message))}}});return t===0})};p.prototype._restoreTreeState=function(e){var t=this;this._abortPendingRequest();e=e||{creationCancelled:[],added:[],removed:[],moved:[]};if(!this.bSkipDataEvents){this.fireDataRequested()}this.bSkipDataEvents=false;return this._requestExtraInfoForAddedNodes(e.added).then(function(i){if(i){return t._executeRestoreTreeState(e).then(function(e){if(e){t._fireChange({reason:s.Change});t.fireDataReceived({data:e});return e}return undefined})}return undefined})};p.prototype._executeRestoreTreeState=function(e){var t,i,n,r,o={},s=[],a=this;r=this._collectServerSections(this._aNodes);e=this._optimizeOptimizedChanges(e);t=this._filterChangeForServerSections(e);this._adaptSections(r,t);r.forEach(function(e,t){s.push(a._restoreServerIndexNodes(e.iSkip,e.iTop,t===0))});n=this._filterChangesForDeepSections(e);r=this._collectDeepNodes();r.forEach(function(e){var t=e.aChildSections,i=e.oParentNode,r=n[i.key];if(r){a._adaptSections(t,r,{ignoreMagnitude:true,indexName:"positionInParent"})}t.forEach(function(e){s.push(a._restoreChildren(i,e.iSkip,e.iTop))})});this._aCollapsed.forEach(function(e){o[e.key]=true});i=this._aCollapsed.length;this.resetData(true);s=s.map(function(e){return e.then(function(e){return{responseData:e}},function(e){return{error:e}})});return Promise.all(s).then(function(e){var t=0;e.forEach(function(e){var i=e.error;if(i){if(i.statusCode===0){t++}else{throw new Error("Tree state restoration request failed. Complete or partial"+" tree state might get lost. Error: "+(i.message.value||i.message))}}});if(t<e.length){if(i>0){a._map(function(e,t){if(e&&o[e.key]){a.collapse(e,true);i--;if(i===0){t.broken=true}}})}return e}return undefined})};p.prototype._collectServerSections=function(e){var t=[];var i;for(var n=0;n<e.length;n++){if(e[n]!==undefined){if(!i){i={iSkip:n,iTop:1};t.push(i)}else{i.iTop++}}else{i=null}}return t};p.prototype._adaptSections=function(e,i,n){var r=i.removed||[],o=i.added||[],s=n&&n.indexName||"serverIndex",a,d,l,h,u,f=0,p,c,_,v,g,S,y,x=0,m,C,I=[];for(var b=o.length-1;b>=0;b--){a=o[b];if(a.newIsDeepOne!==undefined?a.newIsDeepOne:a.isDeepOne){C=this.oTreeProperties["hierarchy-sibling-rank-for"]}else{C=this.oTreeProperties["hierarchy-preorder-rank-for"];if(a.newInitiallyCollapsed!==undefined?!a.newInitiallyCollapsed:!a.initiallyCollapsed){p=a.context.getProperty(this.oTreeProperties["hierarchy-node-descendant-count-for"])}}c=a.context.getProperty(C);if(c===undefined){t.warning("ODataTreeBindingFlat","Missing "+C+" value for node "+a.key);break}I.push({position:c,magnitude:p||0,assignedToSection:false})}for(var P=0;P<e.length;P++){d=e[P];y=x;_=v;v=0;m=0;for(var N=r.length-1;N>=0;N--){a=r[N];c=a[s];if(c>=d.iSkip&&c<=d.iSkip+d.iTop){if(s==="serverIndex"){f++}p=n&&n.ignoreMagnitude?0:this._getInitialMagnitude(a);u=1+p;h=d.iSkip+d.iTop-c-u;if(h>0){m-=u}else{m-=d.iSkip+d.iTop-c;if(h<0){v=c+u}}y-=u}}if(d.iSkip<=_){g=d.iSkip-_;m+=g;if(d.iTop+m<0){v=_}}d.iSkip+=x;d.iTop+=m;if(d.iTop>0){x=0;m=0;for(var R=0;R<I.length;R++){l=I[R];c=l.position;S=n&&n.ignoreMagnitude?1:l.magnitude+1;if(c>=d.iSkip&&c<=d.iSkip+d.iTop){m+=S;I[R].assignedToSection=true}else if(c<d.iSkip){x+=S}}d.iSkip+=x;d.iTop+=m;d.iTop+=f}if(d.iTop<=0){e.splice(P,1);P--}x=y}for(var T=0;T<I.length;T++){l=I[T];S=n&&n.ignoreMagnitude?1:l.magnitude+1;if(!l.assignedToSection){e.push({iSkip:l.position,iTop:S})}}e.sort(function(e,t){return e.iSkip-t.iSkip});for(var k=0;k<e.length;k++){if(k+1<e.length){d=e[k];var D=e[k+1];if(d.iSkip+d.iTop===D.iSkip){d.iTop+=D.iTop;e.splice(k+1,1);k--}}}};p.prototype._optimizeChanges=function(){var t=[],i=[],n=[],r=[];var o=false;var s=function(e,t){if(e.nodeState.removed&&!e.nodeState.reinserted){o=true;t.broken=true}};var a=[];var d=function(e){if((e.isDeepOne||e.serverIndex>=0)&&a.indexOf(e)==-1){a.push(e)}if(e.nodeState.added){i.push(e)}};this._aAllChangedNodes.forEach(function(e){o=false;this._up(e,s,false);if(o){d(e)}else if(e.nodeState.removed&&!e.nodeState.reinserted){d(e)}else if(e.nodeState.added){n.push(e)}else{r.push(e)}}.bind(this));a.sort(function(t,i){var n=this._getRelatedServerIndex(t);var r=this._getRelatedServerIndex(i);e(n!=undefined,"_generateSubmitData: (containing) Server-Index not found for node 'a'");e(r!=undefined,"_generateSubmitData: (containing) Server-Index not found node 'b'");if(n==r&&t.isDeepOne&&i.isDeepOne){if(t.parent===i.parent){return t.positionInParent-i.positionInParent}else{return t.originalLevel-i.originalLevel}}return n-r}.bind(this));var l=function(e){var t=false;this._up(e,function(e,i){if(e.nodeState.removed&&!e.nodeState.reinserted){t=true;i.broken=true}},true);return t}.bind(this);for(var h=0;h<a.length;h++){var u=a[h];if(!l(u)){t.push(u)}}return{removed:t,creationCancelled:i,added:n,moved:r}};p.prototype._collectDeepNodes=function(){var e=[],t=this;this._map(function(i){if(i&&i.nodeState.expanded&&(i.isDeepOne||i.initiallyCollapsed||i.initiallyIsLeaf)){e.push({oParentNode:i,aChildSections:t._collectServerSections(i.children)})}});return e};p.prototype._trackChangedNode=function(e){if(this._aAllChangedNodes.indexOf(e)==-1){this._aAllChangedNodes.push(e)}};p.prototype.addContexts=function(i,n){var r=this._findNodeByContext(i),o=r.node,d=this.getModel(),l,h;e(i&&n,"ODataTreeBinding.addContexts() was called with incomplete arguments!");if(o){this._bReadOnly=false;if(o.nodeState&&o.nodeState.isLeaf){o.nodeState.isLeaf=false;o.nodeState.collapsed=true}if(!Array.isArray(n)){if(n instanceof a){n=[n]}else{t.warning("ODataTreeBinding.addContexts(): The child node argument is not of type sap.ui.model.Context.")}}var u=function(e){return function(){return[e]}};n=n.slice();n.reverse();for(var f=0;f<n.length;f++){h=n[f];if(!(h instanceof a)){t.warning("ODataTreeBindingFlat.addContexts(): no valid child context given!");return}l=this._mSubtreeHandles[h.getPath()];this._ensureHierarchyNodeIDForContext(h);if(l&&l._isRemovedSubtree){t.info("ODataTreeBindingFlat.addContexts(): Existing context added '"+h.getPath()+"'");l._oNewParentNode=o;l._oSubtreeRoot.nodeState.reinserted=true;l._oSubtreeRoot.originalParent=l._oSubtreeRoot.originalParent||l._oSubtreeRoot.parent;l._oSubtreeRoot.parent=o;l._oSubtreeRoot.containingSubtreeHandle=l;this._trackChangedNode(l._oSubtreeRoot)}else{t.info("ODataTreeBindingFlat.addContexts(): Newly created context added.");this._ensureHierarchyNodeIDForContext(h);var p={context:h,key:d.getKey(h),parent:o,nodeState:{isLeaf:true,collapsed:false,expanded:false,selected:false,added:true},addedSubtrees:[],children:[],magnitude:0};this._trackChangedNode(p);this._aAdded.push(p);l={_getSubtree:u(p),_oSubtreeRoot:null,_oNewParentNode:o}}o.addedSubtrees.unshift(l);if(o.serverIndex!==undefined){this._aNodeChanges[o.serverIndex]=true}}this._aNodeCache=[];this._cleanTreeStateMaps();this._fireChange({reason:s.Add})}else{t.warning("The given parent context could not be found in the tree. No new sub-nodes were added!")}};p.prototype._ensureHierarchyNodeIDForContext=function(e){if(e){var t=e.getProperty(this.oTreeProperties["hierarchy-node-for"]);if(e.isTransient()&&!t){this.oModel.setProperty(this.oTreeProperties["hierarchy-node-for"],r(),e)}}};p.prototype.removeContext=function(e){var i=this;var n=this._findNodeByContext(e);var r=n.node;var o=n.index;if(r){this._bReadOnly=false;r.nodeState.removed=true;this._aRemoved.push(r);this._trackChangedNode(r);if(r.serverIndex!==undefined){this._aNodeChanges[r.serverIndex]=true}if(r.containingSubtreeHandle&&r.parent!=null){var a=r.parent.addedSubtrees.indexOf(r.containingSubtreeHandle);if(a!=-1){r.parent.addedSubtrees.splice(a,1);r.nodeState.reinserted=false;r.parent=null}}this._aNodeCache=[];this.setNodeSelection(r,false);this._cleanUpSelection(true);this._cleanTreeStateMaps();this._fireChange({reason:s.Remove});this._mSubtreeHandles[e.getPath()]={_removedFromVisualIndex:o,_isRemovedSubtree:true,_oSubtreeRoot:r,_getSubtree:function(){if(r.serverIndex!=undefined&&!r.initiallyCollapsed){return i._aNodes.slice(r.serverIndex,r.serverIndex+r.magnitude+1)}else{return r}},getContext:function(){return e}};return e}else{t.warning("ODataTreeBinding.removeContext(): The given context is not part of the tree. Was it removed already?")}return undefined};p.prototype._getRelatedServerIndex=function(e){if(e.serverIndex===undefined){return e.containingServerIndex}else{return e.serverIndex}};p.prototype.getNodeInfoByRowIndex=function(e){var t=0,i=0,n,r,o=-1;while(t<this._aCollapsed.length||i<this._aExpanded.length){if(this._aCollapsed[t]&&this._aExpanded[i]){if(this._getRelatedServerIndex(this._aCollapsed[t])>this._getRelatedServerIndex(this._aExpanded[i])){n=this._aExpanded[i];i++;r=false}else{n=this._aCollapsed[t];t++;r=true}}else if(this._aCollapsed[t]){n=this._aCollapsed[t];t++;r=true}else{n=this._aExpanded[i];i++;r=false}if(e<=this._getRelatedServerIndex(n)){break}if(r){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex>o){e+=n.magnitude;o=n.serverIndex+n.magnitude}}else if(n.serverIndex>o){if(!n.isDeepOne&&n.initiallyCollapsed){e-=n.magnitude}if(e<=n.serverIndex){return this._calcDirectIndex(n,e+n.magnitude-n.serverIndex-1)}}}return{index:e}};p.prototype._calcDirectIndex=function(e,t){var i,n,r;for(n=0;n<e.children.length;n++){i=e.children[n];if(t===0){return{parent:e,childIndex:n}}r=i?i.magnitude:0;t--;if(!i||i.nodeState.collapsed){continue}if(t<r){return this._calcDirectIndex(i,t)}else{t-=r}}return undefined};p.prototype.getRowIndexByNode=function(e){var t=0;var i;var n;if(e.isDeepOne){while(e.parent){t+=e.positionInParent+1;for(n=0;n<e.positionInParent;n++){i=e.parent.children[n];if(i&&i.nodeState.expanded){t+=i.magnitude}}e=e.parent}}return this._calcIndexDelta(e.serverIndex)+e.serverIndex+t};p.prototype._getSelectedNodesInfo=function(){var e=[];if(n(this._mSelected)){return e}var t=true;var i=function(e,i){if(e.nodeState.collapsed||e.nodeState.removed&&!e.nodeState.reinserted){t=false;i.broken=true}};for(var r in this._mSelected){var o=this._mSelected[r];t=true;this._up(o,i,false);if(t){e.push({node:o,rowIndex:this.getRowIndexByNode(o)})}}e.sort(function(e,t){return e.rowIndex-t.rowIndex});return e};p.prototype._calcIndexDelta=function(e){var t,i,n,r=0,o=0,s=0;for(t=0;t<this._aCollapsed.length;t++){var a=this._aCollapsed[t];if(this._getRelatedServerIndex(a)>=e){break}if(!a.isDeepOne){if(a.serverIndex>=s&&!a.initiallyCollapsed){r-=a.magnitude;s=a.serverIndex+a.magnitude}else{}}else{}}n=this._aCollapsed.filter(function(t){return t.serverIndex>=0&&t.serverIndex<e&&!t.isDeepOne&&!t.initiallyCollapsed});var d=function(e){return n.some(function(t){return e>t.serverIndex&&e<t.serverIndex+t.magnitude})};for(t=0;t<this._aExpanded.length;t++){var l=this._aExpanded[t],h=this._getRelatedServerIndex(l);if(h>=e){break}if(l.isDeepOne){var u=l.parent;var f=false;while(u){if(u.nodeState.collapsed){f=true;break}u=u.parent}i=d(h);if(!f&&!i){o+=l.children.length}}else if(l.initiallyCollapsed){i=d(h);if(!i){o+=l.children.length}}}return o+r};p.prototype._sortNodes=function(e){var t=function(e,t){var i=this._getRelatedServerIndex(e);var n=this._getRelatedServerIndex(t);return i-n}.bind(this);e.sort(t)};p.prototype._abortPendingRequest=function(){if(this._aPendingRequests.length||this._aPendingChildrenRequests.length){this.bSkipDataEvents=true;var e,t;for(e=this._aPendingRequests.length-1;e>=0;e--){this._aPendingRequests[e].oRequestHandle.abort()}this._aPendingRequests=[];for(t=this._aPendingChildrenRequests.length-1;t>=0;t--){this._aPendingChildrenRequests[t].oRequestHandle.abort()}this._aPendingChildrenRequests=[]}};p.prototype.attachSelectionChanged=function(e,t,i){this.attachEvent("selectionChanged",e,t,i);return this};p.prototype.detachSelectionChanged=function(e,t){this.detachEvent("selectionChanged",e,t);return this};p.prototype.fireSelectionChanged=function(e){this.fireEvent("selectionChanged",e);return this};p.prototype.getRootContexts=function(){};p.prototype.getNodeContexts=function(){};p.prototype._findParentNode=function(e){if(e.parent){return e.parent}let t=e.serverIndex;let i;do{t-=1;i=this._aNodes[t];if(!i){break}}while(i.level>=e.level);return i};p.prototype._resetMovedOrRemovedNode=function(e){this._resetParentState(e);e.level=e.originalLevel;e.parent=e.originalParent;delete e.containingSubtreeHandle;delete e.nodeState.removed;delete e.nodeState.reinserted};p.prototype._resetParentState=function(e){const t=this._findParentNode(e);if(t){t.addedSubtrees=[];if(t.initiallyIsLeaf){t.nodeState.isLeaf=true;t.nodeState.expanded=false;t.nodeState.collapsed=false}else if(t.nodeState.wasExpanded){t.nodeState.isLeaf=false;t.nodeState.expanded=true;t.nodeState.collapsed=false;delete t.nodeState.wasExpanded;this._aTurnedToLeaf.splice(this._aTurnedToLeaf.indexOf(t),1)}}};return p},true);
//# sourceMappingURL=ODataTreeBindingFlat.js.map