/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,a,n,o,r,s,i,l){"use strict";function u(t){return t.oConstraints&&t.oConstraints.isDateOnly}function g(e,a){var n,o;e.oConstraints=undefined;if(a){n=a.nullable;if(n===false||n==="false"){e.oConstraints={nullable:false}}else if(n!==undefined&&n!==true&&n!=="true"){t.warning("Illegal nullable: "+n,null,e.getName())}if(a.isDateOnly===true){e.oConstraints=e.oConstraints||{};e.oConstraints.isDateOnly=true}o=a.precision;if(o!==undefined){if(o===Math.floor(o)&&o>=1&&o<=12){e.oConstraints=e.oConstraints||{};e.oConstraints.precision=o}else if(o!==0){t.warning("Illegal precision: "+o,null,e.getName())}}}e._handleLocalizationChange()}var h=l.extend("sap.ui.model.odata.type.DateTimeBase",{constructor:function(t,e){l.apply(this,arguments);g(this,e);this.oFormat=null;this.oFormatOptions=t},metadata:{abstract:true}});h.prototype.getDateValue=function(t){var e;if(!t){return null}e=n.getInstance(t);if(u(this)){e.setFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e.setHours(0,0,0,0)}else if(this.oFormatOptions&&this.oFormatOptions.UTC){e.setFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e.setHours(e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds())}return e};h.prototype.formatValue=function(t,e){if(t===null||t===undefined){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"object":if(u(this)){return this.getDateValue(t)}return t;case"string":if(!(t instanceof Date)){throw new r("Illegal "+this.getName()+" value: "+t)}return this.getFormat().format(t);default:throw new r("Don't know how to format "+this.getName()+" to "+e)}};h.prototype.getFormat=function(){if(!this.oFormat){var t=e({strictParsing:true},this.oFormatOptions);if(u(this)){t.UTC=true;this.oFormat=o.getDateInstance(t)}else{this.oFormat=o.getDateTimeInstance(t)}}return this.oFormat};h.prototype._getErrorMessage=function(){var t=n.getInstance().getFullYear(),e=u(this)?new Date(Date.UTC(t,11,31)):n.getInstance(t,11,31,23,59,58),o=u(this)?"EnterDate":"EnterDateTime",r=a.getResourceBundleFor("sap.ui.core");return r.getText(o,[this.formatValue(e,"string")])};h.prototype.parseValue=function(t,e){var a;if(t===null||t===""){return null}switch(this.getPrimitiveType(e)){case"object":if(u(this)){return this._getModelValue(t)}return t;case"string":a=this.getFormat().parse(t);if(!a){throw new s(this._getErrorMessage())}return a;default:throw new s("Don't know how to parse "+this.getName()+" from "+e)}};h.prototype._handleLocalizationChange=function(){this.oFormat=null};h.prototype.validateValue=function(t){if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new i(this._getErrorMessage())}return}else if(t instanceof Date){if(t.getFullYear()===0){throw new i(this._getErrorMessage())}return}throw new i("Illegal "+this.getName()+" value: "+t)};h.prototype._getModelValue=function(t){var e;if(t===null){return null}n.checkDate(t);e=n.getInstance(t);if(u(this)){e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());e.setUTCHours(0,0,0,0)}else if(this.oFormatOptions&&this.oFormatOptions.UTC){e.setUTCFullYear(t.getFullYear(),t.getMonth(),t.getDate());e.setUTCHours(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds())}return e};return h});
//# sourceMappingURL=DateTimeBase.js.map