/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/_Helper","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException"],function(e,t,o,i,n,r,a){"use strict";var s="For type 'object', at least one of the format options 'showDate' or"+" 'showTime' must be enabled";var h=n.extend("sap.ui.model.odata.type.DateTimeWithTimezone",{constructor:function(e,t){if(t&&Object.keys(t).length){throw new Error("Type "+this.getName()+" does not support constraints")}e=Object.assign({},e);n.call(this,e);this.oFormat=null;this.bParseWithValues=true;this.bUseInternalValues=true;this.vEmptyTimezoneValue=null;this.bShowDate=e.showDate===undefined||e.showDate;this.bShowTime=e.showTime===undefined||e.showTime;this.bShowTimezone=e.showTimezone===undefined||e.showTimezone;this.setConstraints=function(){throw new Error("Constraints are immutable")};this.setFormatOptions=function(){throw new Error("Format options are immutable")}}});h.prototype._getErrorMessage=function(){var o=new Date(Date.UTC(t.getInstance().getFullYear(),11,31,23,59,58)),i=!this.bShowDate&&!this.bShowTime?"EnterDateTimeTimezone":"EnterDateTime";return e.getResourceBundleFor("sap.ui.core").getText(i,[this.formatValue([o,"America/New_York"],"string")])};h.prototype.formatValue=function(e,t){var o=e&&e[0],i=e&&e[1];if(!e||i===undefined||o===undefined||!o&&!this.bShowTimezone){return null}if(o&&!(o instanceof Date)){throw new r("Timestamp value for "+this.getName()+" is not an instance of Date: "+o)}switch(this.getPrimitiveType(t)){case"object":if(!this.bShowDate&&!this.bShowTime){throw new r(s)}return o;case"string":return this.getFormat().format(o,i);default:throw new r("Don't know how to format "+this.getName()+" to "+t)}};h.prototype.getFormat=function(){if(!this.oFormat){var e=i.extend({strictParsing:true},this.oFormatOptions);this.oFormat=o.getDateTimeWithTimezoneInstance(e)}return this.oFormat};h.prototype.getName=function(){return"sap.ui.model.odata.type.DateTimeWithTimezone"};h.prototype.getPartsIgnoringMessages=function(){if(!this.bShowDate&&!this.bShowTime){return[0]}else if(!this.bShowTimezone){return[1]}return[]};h.prototype.getPlaceholderText=function(){return this.getFormat().getPlaceholderText()};h.prototype.parseValue=function(e,t,o){var i;if(!o){throw new a("'aCurrentValues' is mandatory")}switch(this.getPrimitiveType(t)){case"object":if(!this.bShowDate&&!this.bShowTime){throw new a(s)}if(!e){return[null,undefined]}if(!(e instanceof Date)){throw new a("Given value must be an instance of Date")}return[e,undefined];case"string":if(!e){if(!this.bShowDate&&!this.bShowTime){return[undefined,this.vEmptyTimezoneValue]}return[null,undefined]}try{i=this.getFormat().parse(e,o[1])}catch(e){throw new a(e.message)}if(!i){throw new a(this._getErrorMessage())}return i;default:throw new a("Don't know how to parse "+this.getName()+" from "+t)}};h.prototype.processPartTypes=function(e){var t=e[1];if(t&&t.isA("sap.ui.model.odata.type.String")&&t.getFormatOptions().parseKeepsEmptyString===true){this.vEmptyTimezoneValue=""}};h.prototype.validateValue=function(e){};h.prototype._handleLocalizationChange=function(){this.oFormat=null};return h});
//# sourceMappingURL=DateTimeWithTimezone.js.map