/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(e,t,a,o,r,n,i){"use strict";function s(){return t.getResourceBundleFor("sap.ui.core").getText("EnterNumber")}function l(e){return!e.oConstraints||e.oConstraints.nullable!==false}function u(t,a){var o;t.oConstraints=undefined;if(a){o=a.nullable;if(o===false||o==="false"){t.oConstraints={nullable:false}}else if(o!==undefined&&o!==true&&o!=="true"){e.warning("Illegal nullable: "+o,null,t.getName())}}t._handleLocalizationChange()}var p=i.extend("sap.ui.model.odata.type.Double",{constructor:function(e,t){i.apply(this,arguments);this.oFormatOptions=e;u(this,t);this.checkParseEmptyValueToZero()}});p.prototype.formatValue=function(e,t){var a,r;if(e===null||e===undefined){return null}if(typeof e==="number"){r=e}else if(typeof e==="string"){r=parseFloat(e)}else if(t!=="any"){throw new o("Illegal "+this.getName()+" value: "+e)}switch(this.getPrimitiveType(t)){case"any":return e;case"float":return r;case"int":return Math.floor(r);case"string":if(r&&(Math.abs(r)>=1e15||Math.abs(r)<1e-4)){a=this.getFormat().oFormatOptions;return r.toExponential().replace("e"," E").replace(".",a.decimalSeparator).replace("+",a.plusSign).replace("-",a.minusSign)}return this.getFormat().format(r);default:throw new o("Don't know how to format "+this.getName()+" to "+t)}};p.prototype.getFormat=function(){if(!this.oFormat){var e={groupingEnabled:true},t=this.oFormatOptions||{};if(t.style!=="short"&&t.style!=="long"){e.preserveDecimals=true}Object.assign(e,this.oFormatOptions);delete e.parseEmptyValueToZero;this.oFormat=a.getFloatInstance(e)}return this.oFormat};p.prototype.parseValue=function(e,t){var a=this.getEmptyValue(e,true);if(a!==undefined){return a}var o;switch(this.getPrimitiveType(t)){case"string":o=this.getFormat().parse(e);if(isNaN(o)){throw new r(s())}break;case"int":case"float":o=e;break;default:throw new r("Don't know how to parse "+this.getName()+" from "+t)}return o};p.prototype._handleLocalizationChange=function(){this.oFormat=null};p.prototype.validateValue=function(e){if(e===null&&l(this)){return}if(typeof e==="number"){return}throw new n(s())};p.prototype.getName=function(){return"sap.ui.model.odata.type.Double"};return p});
//# sourceMappingURL=Double.js.map