/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,a,n,o,r,i,s){"use strict";function u(t,e){return a.getResourceBundleFor("sap.ui.core").getText(t,e)}function l(e,a){var n;e.oConstraints=undefined;if(a){n=a.nullable;if(n===false||n==="false"){e.oConstraints={nullable:false}}else if(n!==undefined&&n!==true&&n!=="true"){t.warning("Illegal nullable: "+n,null,e.getName())}}e._handleLocalizationChange()}var m=s.extend("sap.ui.model.odata.type.Int",{constructor:function(t,e){s.apply(this,arguments);this.oFormatOptions=t;l(this,e);this.checkParseEmptyValueToZero()},metadata:{abstract:true}});m.prototype._handleLocalizationChange=function(){this.oFormat=null};m.prototype.formatValue=function(t,e){if(t===undefined||t===null){return null}if(typeof t!=="number"&&e!=="any"){throw new o("Illegal "+this.getName()+" value: "+t)}switch(this.getPrimitiveType(e)){case"string":return this.getFormat().format(t);case"int":return Math.floor(t);case"float":case"any":return t;default:throw new o("Don't know how to format "+this.getName()+" to "+e)}};m.prototype.getFormat=function(){if(!this.oFormat){var t=e({groupingEnabled:true},this.oFormatOptions);delete t.parseEmptyValueToZero;this.oFormat=n.getIntegerInstance(t)}return this.oFormat};m.prototype.parseValue=function(t,e){var a=this.getEmptyValue(t,true);if(a!==undefined){return a}switch(this.getPrimitiveType(e)){case"string":var n=this.getFormat().parse(t);if(isNaN(n)){throw new r(u("EnterInt"))}return n;case"float":return Math.floor(t);case"int":return t;default:throw new r("Don't know how to parse "+this.getName()+" from "+e)}};m.prototype.validateValue=function(t){var e=this.getRange();if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new i(u("EnterInt"))}return}if(typeof t!=="number"){throw new i(t+" (of type "+typeof t+") is not a valid "+this.getName()+" value")}if(Math.floor(t)!==t){throw new i(u("EnterInt"))}if(t<e.minimum){throw new i(u("EnterNumberMin",[this.formatValue(e.minimum,"string")]))}if(t>e.maximum){throw new i(u("EnterNumberMax",[this.formatValue(e.maximum,"string")]))}};return m});
//# sourceMappingURL=Int.js.map