/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,n,r,a,i,o,u){"use strict";var s=/^[-+]?(\d+)$/,l={minimum:"-9223372036854775808",maximum:"9223372036854775807"},m={minimum:"-9007199254740991",maximum:"9007199254740991"};function f(t,e,n){var r,a,i;a=s.exec(e);if(a){i=e.charAt(0)==="-";r=i?n.minimum.slice(1):n.maximum;if(a[1].length<r.length){return undefined}if(a[1].length>r.length||a[1]>r){if(i){return p("EnterNumberMin",[t.formatValue(n.minimum,"string")])}else{return p("EnterNumberMax",[t.formatValue(n.maximum,"string")])}}return undefined}return p("EnterInt")}function p(t,e){return n.getResourceBundleFor("sap.ui.core").getText(t,e)}function c(t){return!t.oConstraints||t.oConstraints.nullable!==false}function h(e,n){var r;e.oConstraints=undefined;if(n){r=n.nullable;if(r===false||r==="false"){e.oConstraints={nullable:false}}else if(r!==undefined&&r!==true&&r!=="true"){t.warning("Illegal nullable: "+r,null,e.getName())}}e._handleLocalizationChange()}var g=u.extend("sap.ui.model.odata.type.Int64",{constructor:function(t,e){u.apply(this,arguments);this.oFormatOptions=t;h(this,e);this.checkParseEmptyValueToZero()}});g.prototype.formatValue=function(t,e){var n;if(t===null||t===undefined){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"float":case"int":n=f(this,t,m);if(n){throw new a(n)}return parseInt(t);case"string":return this.getFormat().format(t);default:throw new a("Don't know how to format "+this.getName()+" to "+e)}};g.prototype.getFormat=function(){if(!this.oFormat){var t=e({groupingEnabled:true},this.oFormatOptions);t.parseAsString=true;delete t.parseEmptyValueToZero;this.oFormat=r.getIntegerInstance(t)}return this.oFormat};g.prototype.getName=function(){return"sap.ui.model.odata.type.Int64"};g.prototype._handleLocalizationChange=function(){this.oFormat=null};g.prototype.parseValue=function(t,e){var n=this.getEmptyValue(t);if(n!==undefined){return n}var a;switch(this.getPrimitiveType(e)){case"string":a=this.getFormat().parse(t);if(!a){throw new i(p("EnterInt"))}break;case"int":case"float":a=r.getIntegerInstance({maxIntegerDigits:Infinity,groupingEnabled:false}).format(t);break;default:throw new i("Don't know how to parse "+this.getName()+" from "+e)}return a};g.prototype.validateValue=function(t){var e;if(t===null&&c(this)){return}if(typeof t==="string"){e=f(this,t,l);if(e){throw new o(e)}return}throw new o(p("EnterInt"))};return g});
//# sourceMappingURL=Int64.js.map