/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,o,a,n,r,i){"use strict";function s(){return e.getResourceBundleFor("sap.ui.core").getText("EnterNumber")}function u(t){return!t.oConstraints||t.oConstraints.nullable!==false}function l(e,o){var a;e.oConstraints=undefined;if(o){a=o.nullable;if(a===false||a==="false"){e.oConstraints={nullable:false}}else if(a!==undefined&&a!==true&&a!=="true"){t.warning("Illegal nullable: "+a,null,e.getName())}}e._handleLocalizationChange()}var p=i.extend("sap.ui.model.odata.type.Single",{constructor:function(t,e){i.apply(this,arguments);this.oFormatOptions=t;l(this,e);this.checkParseEmptyValueToZero()}});p.prototype.formatValue=function(t,e){var o;if(t===null||t===undefined){return null}if(typeof t==="number"){o=t}else if(typeof t==="string"){o=parseFloat(t)}else if(e!=="any"){throw new a("Illegal "+this.getName()+" value: "+t)}switch(this.getPrimitiveType(e)){case"any":return t;case"float":return o;case"int":return Math.floor(o);case"string":return this.getFormat().format(parseFloat(o.toPrecision(7)));default:throw new a("Don't know how to format "+this.getName()+" to "+e)}};p.prototype.getFormat=function(){if(!this.oFormat){var t={groupingEnabled:true},e=this.oFormatOptions||{};if(e.style!=="short"&&e.style!=="long"){t.preserveDecimals=true}Object.assign(t,this.oFormatOptions);delete t.parseEmptyValueToZero;this.oFormat=o.getFloatInstance(t)}return this.oFormat};p.prototype.parseValue=function(t,e){var o=this.getEmptyValue(t,true);if(o!==undefined){return o}switch(this.getPrimitiveType(e)){case"string":var a=this.getFormat().parse(t);if(isNaN(a)){throw new n(s())}return Math.fround(a);case"int":case"float":return Math.fround(t);default:throw new n("Don't know how to parse "+this.getName()+" from "+e)}};p.prototype._handleLocalizationChange=function(){this.oFormat=null};p.prototype.validateValue=function(t){if(t===null&&u(this)){return}if(typeof t==="number"){return}throw new r(s())};p.prototype.getName=function(){return"sap.ui.model.odata.type.Single"};return p});
//# sourceMappingURL=Single.js.map