/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,n,o,r,i,a,u,s){"use strict";var l={__edmType:"Edm.Time",ms:86398e3},p={format:d,parse:g};function m(t){return n.getResourceBundleFor("sap.ui.core").getText("EnterTime",[t.formatValue(l,"string")])}function f(t){return typeof t==="object"&&t.__edmType==="Edm.Time"&&typeof t.ms==="number"}function c(e,n){var o;e.oConstraints=undefined;if(n){o=n.nullable;if(o===false||o==="false"){e.oConstraints={nullable:false}}else if(o!==undefined&&o!==true&&o!=="true"){t.warning("Illegal nullable: "+o,null,e.getName())}}}function g(t){if(!f(t)){throw new i("Illegal sap.ui.model.odata.type.Time value: "+h(t))}return new Date(t.ms)}function d(t){return{__edmType:"Edm.Time",ms:((t.getUTCHours()*60+t.getUTCMinutes())*60+t.getUTCSeconds())*1e3+t.getUTCMilliseconds()}}function h(t){try{return JSON.stringify(t)}catch(e){return String(t)}}var y=s.extend("sap.ui.model.odata.type.Time",{constructor:function(t,e){s.apply(this,arguments);c(this,e);this.oFormatOptions=t}});y.prototype.formatValue=function(t,e){if(t===undefined||t===null){return null}switch(this.getPrimitiveType(e)){case"any":return t;case"string":return this.getFormat().format(g(t));default:throw new i("Don't know how to format "+this.getName()+" to "+e)}};y.prototype.getDateValue=function(t){var e;if(!t){return null}e=o.getInstance(t.ms);e.setFullYear(1970,0,1);e.setHours(e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return e};y.prototype.getFormat=function(){if(!this.oFormat){var t=e({strictParsing:true},this.oFormatOptions);t.UTC=true;this.oFormat=r.getTimeInstance(t)}return this.oFormat};y.prototype.getISOStringFromModelValue=function(t){if(!t){return null}return o.getInstance(t.ms).toISOString().slice(11,-1)};y.prototype.getModelFormat=function(){return p};y.prototype.getModelValue=function(t){var e;if(t===null){e=null}else{o.checkDate(t);e=o.getInstance(0);e.setUTCHours(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds());e=d(e)}this.validateValue(e);return e};y.prototype.getModelValueFromISOString=function(t){if(!t){return null}return d(o.getInstance("1970-01-01T"+t+"Z"))};y.prototype.getName=function(){return"sap.ui.model.odata.type.Time"};y.prototype.parseValue=function(t,e){var n;if(t===""||t===null){return null}if(this.getPrimitiveType(e)!=="string"){throw new a("Don't know how to parse "+this.getName()+" from "+e)}n=this.getFormat().parse(t);if(!n){throw new a(m(this))}return d(n)};y.prototype.validateValue=function(t){if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new u(m(this))}return}if(!f(t)){throw new u("Illegal "+this.getName()+" value: "+h(t))}};y.prototype._handleLocalizationChange=function(){this.oFormat=null};return y});
//# sourceMappingURL=Time.js.map