/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/i18n/date/CalendarType","sap/base/util/extend","sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,o,n,i,a,r,s,l,u){"use strict";function f(t){return n.getResourceBundleFor("sap.ui.core").getText("EnterTime",[t.formatValue("23:59:58","string")])}function p(e,o){var n,i;e.oConstraints=undefined;if(o){n=o.nullable;i=o.precision;if(n===false){e.oConstraints={nullable:false}}else if(n!==undefined&&n!==true){t.warning("Illegal nullable: "+n,null,e.getName())}if(i===Math.floor(i)&&i>0&&i<=12){e.oConstraints=e.oConstraints||{};e.oConstraints.precision=i}else if(i!==undefined&&i!==0){t.warning("Illegal precision: "+i,null,e.getName())}}}var d=u.extend("sap.ui.model.odata.type.TimeOfDay",{constructor:function(t,e){u.apply(this,arguments);this.oModelFormat=undefined;this.rTimeOfDay=undefined;this.oFormat=undefined;p(this,e);this.oFormatOptions=t}});d.prototype._handleLocalizationChange=function(){this.oFormat=null};d.prototype._resetModelFormatter=function(){this.oModelFormat=undefined};d.prototype.formatValue=function(t,e){var o,n,a;if(t===undefined||t===null){return null}a=this.getPrimitiveType(e);switch(a){case"any":return t;case"object":case"string":n=t.indexOf(".");if(n>=0){t=t.slice(0,n+4)}o=this.getModelFormat().parse(t);if(o){if(a==="object"){return i.getInstance(1970,0,1,o.getUTCHours(),o.getUTCMinutes(),o.getUTCSeconds())}return this.getFormat().format(o)}throw new r("Illegal "+this.getName()+" value: "+t);default:throw new r("Don't know how to format "+this.getName()+" to "+e)}};d.prototype.getDateValue=function(t){return t?i.getInstance("1970-01-01T"+t):null};d.prototype.getFormat=function(){if(!this.oFormat){var t=o({strictParsing:true},this.oFormatOptions);t.UTC=true;this.oFormat=a.getTimeInstance(t)}return this.oFormat};d.prototype.getISOStringFromModelValue=function(t){return t?t:null};d.prototype.getModelFormat=function(){var t="HH:mm:ss",o;if(!this.oModelFormat){o=this.oConstraints&&this.oConstraints.precision;if(o){t+="."+"".padEnd(o,"S")}this.oModelFormat=a.getTimeInstance({calendarType:e.Gregorian,pattern:t,strictParsing:true,UTC:true})}return this.oModelFormat};d.prototype.getModelValue=function(t){var e;if(t===null){e=null}else{i.checkDate(t);e=i.getInstance(0);e.setUTCHours(t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds());e=this.getModelFormat().format(e)}this.validateValue(e);return e};d.prototype.getModelValueFromISOString=function(t){return t?this.getModelFormat().format(i.getInstance("1970-01-01T"+t+"Z")):null};d.prototype.getName=function(){return"sap.ui.model.odata.type.TimeOfDay"};d.prototype.parseValue=function(t,e){var o;if(t===""||t===null){return null}switch(this.getPrimitiveType(e)){case"object":return this.getModelFormat().format(t,false);case"string":o=this.getFormat().parse(t);if(!o){throw new s(f(this))}return this.getModelFormat().format(o);default:throw new s("Don't know how to parse "+this.getName()+" from "+e)}};d.prototype.validateValue=function(t){var e;if(t===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new l(f(this))}return}if(!this.rTimeOfDay){e=this.oConstraints&&this.oConstraints.precision;this.rTimeOfDay=new RegExp("^(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d"+(e?"(\\.\\d{1,"+e+"})?":"")+")?$")}if(!this.rTimeOfDay.test(t)){throw new l("Illegal sap.ui.model.odata.type.TimeOfDay value: "+t)}};return d});
//# sourceMappingURL=TimeOfDay.js.map