/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_CreatedContextsCache","./Context","./ODataAnnotations","./ODataContextBinding","./ODataListBinding","./ODataTreeBinding","sap/base/assert","sap/base/Log","sap/base/i18n/Localization","sap/base/security/encodeURL","sap/base/util/deepEqual","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/uid","sap/ui/base/SyncPromise","sap/ui/core/Messaging","sap/ui/core/message/Message","sap/ui/core/message/MessageParser","sap/ui/core/message/MessageType","sap/ui/core/Supportability","sap/ui/model/_Helper","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/Model","sap/ui/model/odata/CountMode","sap/ui/model/odata/MessageScope","sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataMetaModel","sap/ui/model/odata/ODataMessageParser","sap/ui/model/odata/ODataPropertyBinding","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/OperationMode","sap/ui/model/odata/UpdateMethod","sap/ui/thirdparty/datajs","sap/ui/thirdparty/URI","sap/ui/util/isCrossOriginURL"],function(e,t,a,r,s,n,i,o,d,u,h,f,c,p,l,g,y,_,m,v,b,C,P,R,q,M,E,S,A,T,x,U,D,I,O,k,H,w,B,L,F){"use strict";const G=false;var j="sap.ui.model.odata.v2.ODataModel",N=["context","properties"],$={},W=["groupId","urlParameters"];const K=/\/~[\w\-]+~[A-Z0-9]?\//;$[P.Error]=0;$[P.Warning]=1;$[P.Success]=2;$[P.Information]=3;$[P.None]=4;var z=A.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(t,r){A.apply(this,arguments);var s,n,i,o,u,h,f,c,p,l,g,y,_,m,v,b,C,P,q,E,S,D,I,O,B,L,G,j,N,$,W,K=this;if(typeof t==="object"){r=t;this.sServiceUrl=r.serviceUrl}else{this.sServiceUrl=t}this.mCodeListModelParams=this.createCodeListModelParameters(r);if(r){s=r.user;n=r.password;i=r.headers;o=r.tokenHandling;u=r.withCredentials;h=r.maxDataServiceVersion;f=r.useBatch;c=r.refreshAfterChange;p=r.annotationURI;l=r.loadAnnotationsJoined;_=r.defaultBindingMode;g=r.defaultCountMode;y=r.preliminaryContext;m=r.defaultOperationMode;v=r.metadataNamespaces;b=r.serviceUrlParams;C=r.metadataUrlParams;P=r.json;q=r.messageParser;E=r.skipMetadataAnnotationParsing;S=r.defaultUpdateMethod;D=r.disableHeadRequestForToken;I=r.sequentializeRequests;O=r.disableSoftStateHeader;B=r.bindableResponseHeaders;L=r.warmupUrl;G=r.canonicalRequests;j=r.tokenHandlingForGet;N=r.earlyTokenRequest;$=r.persistTechnicalMessages;W=r.ignoreAnnotationsFromMetadata}this.mPathCache={};this.mInvalidatedPaths={};this.bCanonicalRequests=!!G;this.bTokenHandlingForGet=!!j;this.sMessageScope=x.RequestedObjects;this.sWarmupUrl=L;this.bWarmup=!!L;this.mSupportedBindingModes={OneWay:true,OneTime:true,TwoWay:true};this.mUnsupportedFilterOperators={Any:true,All:true};this.sDefaultBindingMode=_||M.OneWay;this.bIsMessageScopeSupported=false;this.iPendingDeferredRequests=0;this.bJSON=P!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};S=z._fixUpdateMethod(S);this.sDefaultUpdateMethod=S||w.MERGE;this.bTokenHandling=o!==false;this.bWithCredentials=u===true;this.bUseBatch=f!==false;this.bRefreshAfterChange=c!==false;this.sMaxDataServiceVersion=h;this.bLoadAnnotationsJoined=l!==false;this.aAnnotationURIs=[];if(p){this.aAnnotationURIs=Array.isArray(p)?p.slice():[p]}this.pAnnotationChanges=null;this.sDefaultCountMode=g||T.Request;this.sDefaultOperationMode=m||H.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!E;this.bDisableHeadRequestForToken=!!D;this.bSequentializeRequests=!!I;this.bDisableSoftStateHeader=!!O;this.aBindableResponseHeaders=B?B:null;this.bPreliminaryContext=y||false;this.mMetadataUrlParams=C||{};this.mChangedEntities4checkUpdate={};this.bPersistTechnicalMessages=$===undefined?undefined:!!$;this.oCreatedContextsCache=new e;this.aSideEffectCleanUpFunctions=[];this.oTransitionMessagesOnlyGroups=new Set;this.bIgnoreAnnotationsFromMetadata=!!W;if(q){q.setProcessor(this)}this.oMessageParser=q;this.setDeferredGroups(["changes"]);this.setChangeGroups({"*":{groupId:"changes"}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.fnRetryAfter=null;this.oRetryAfterError=null;this.pRetryAfter=null;this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();var Q=this.sServiceUrl.split("?");if(Q.length>1){this.sServiceUrl=Q[0];if(Q[1]){this.aUrlParams.push(Q[1])}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=s;this.sPassword=n;if(R.isStatisticsEnabled()){this.aUrlParams.push("sap-statistics=true")}this.oHeaders={};this.setHeaders(i);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header"}this.sMetadataUrl=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=o==="skipServerCache"?undefined:z._getSharedData("server",this._getServerUrl());this.oSharedServiceData=z._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=z._getSharedData("meta",this.sMetadataUrl);this.bUseCache=this._cacheSupported(this.sMetadataUrl);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new U(this.sMetadataUrl,{async:true,cacheKey:this.bUseCache?this.sMetadataUrl:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:v,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata}}else{this.oMetadata=this.oSharedMetaData.oMetadata}this.oAnnotations=new a(this.oMetadata,{source:this.aAnnotationURIs,skipMetadata:this.bSkipMetadataAnnotationParsing||this.bIgnoreAnnotationsFromMetadata,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(this.sMetadataUrl),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"]}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(b){this.aUrlParams=this.aUrlParams.concat(k._createUrlParamsArray(b))}this.onMetadataFailed=function(e){K.fireMetadataFailed(e.getParameters())};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed)}this.oMetadata.loaded().then(function(){K._initializeMetadata()});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata"}else{this.oHeaders["Accept"]="application/json"}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml"}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}else if(this.oSharedServerData&&this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}if(N){this.securityTokenAvailable()}}this.oHeaders["Accept-Language"]=d.getLanguageTag().toString();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion}if(!this.mCustomHeaders["X-Requested-With"]&&!F(this.sServiceUrl)){this.oHeaders["X-Requested-With"]="XMLHttpRequest"}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"],final:G}});z.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};z.prototype.attachBatchRequestFailed=function(e,t,a){this.attachEvent("batchRequestFailed",e,t,a);return this};z.prototype.detachBatchRequestFailed=function(e,t){this.detachEvent("batchRequestFailed",e,t);return this};z.prototype.fireBatchRequestFailed=function(e){this.fireEvent("batchRequestFailed",e);return this};z.prototype.attachBatchRequestSent=function(e,t,a){this.attachEvent("batchRequestSent",e,t,a);return this};z.prototype.detachBatchRequestSent=function(e,t){this.detachEvent("batchRequestSent",e,t);return this};z.prototype.fireBatchRequestSent=function(e){this.fireEvent("batchRequestSent",e);return this};z.prototype.attachBatchRequestCompleted=function(e,t,a){this.attachEvent("batchRequestCompleted",e,t,a);return this};z.prototype.detachBatchRequestCompleted=function(e,t){this.detachEvent("batchRequestCompleted",e,t);return this};z.prototype.fireBatchRequestCompleted=function(e){this.fireEvent("batchRequestCompleted",e);return this};z.mSharedData={server:{},service:{},meta:{}};z._fixUpdateMethod=function(e){if(e==="Put"){return w.PUT}else if(e==="Merge"){return w.MERGE}return e};z._getSharedData=function(e,t){var a=this.mSharedData[e][t];if(!a){a={};this.mSharedData[e][t]=a}return a};z.prototype._initializeMetadata=function(){if(this.bDestroyed){return}this.bIsMessageScopeSupported=this.oMetadata._isMessageScopeSupported();var e=function(){this.fireMetadataLoaded({metadata:this.oMetadata});o.debug(this+" - metadataloaded fired")}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(e,this.fireMetadataFailed.bind(this))}else{e()}};z.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh()}return undefined};z.prototype.fireAnnotationsLoaded=function(e){this.fireEvent("annotationsLoaded",e);return this};z.prototype.attachAnnotationsLoaded=function(e,t,a){this.attachEvent("annotationsLoaded",e,t,a);return this};z.prototype.detachAnnotationsLoaded=function(e,t){this.detachEvent("annotationsLoaded",e,t);return this};z.prototype.fireAnnotationsFailed=function(e){this.fireEvent("annotationsFailed",e);o.debug(this+" - annotationsfailed fired");return this};z.prototype.attachAnnotationsFailed=function(e,t,a){this.attachEvent("annotationsFailed",e,t,a);return this};z.prototype.detachAnnotationsFailed=function(e,t){this.detachEvent("annotationsFailed",e,t);return this};z.prototype.fireMetadataLoaded=function(e){this.fireEvent("metadataLoaded",e);return this};z.prototype.attachMetadataLoaded=function(e,t,a){this.attachEvent("metadataLoaded",e,t,a);return this};z.prototype.detachMetadataLoaded=function(e,t){this.detachEvent("metadataLoaded",e,t);return this};z.prototype.fireMetadataFailed=function(e){this.fireEvent("metadataFailed",e);return this};z.prototype.attachMetadataFailed=function(e,t,a){this.attachEvent("metadataFailed",e,t,a);return this};z.prototype.detachMetadataFailed=function(e,t){this.detachEvent("metadataFailed",e,t);return this};z.prototype._createEventInfo=function(e,t,a){var r,s,n={};n.url=e.requestUri;n.method=e.method;n.async=e.async;n.headers=e.headers;if(a){n.requests=[];for(var i=0;i<a.length;i++){s={};if(Array.isArray(a[i])){var o=a[i];for(var d=0;d<o.length;d++){e=o[d].request;r=a[i][d].response;s={};s.url=e.requestUri;s.method=e.method;s.headers=e.headers;if(r){s.response={};if(e._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort"}else{s.success=true;if(r.message){s.response.message=r.message;r=r.response;s.response.responseText=r.body;s.success=false}s.response.headers=r.headers;s.response.statusCode=r.statusCode;s.response.statusText=r.statusText}}n.requests.push(s)}}else{e=a[i].request;r=a[i].response;s.url=e.requestUri;s.method=e.method;s.headers=e.headers;if(r){s.response={};if(e._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort"}else{s.success=true;if(r.message){s.response.message=r.message;r=r.response;s.response.responseText=r.body;s.success=false}s.response.headers=r.headers;s.response.statusCode=r.statusCode;s.response.statusText=r.statusText}}n.requests.push(s)}}}if(t){n.response={};n.success=true;if(t.message){n.response.message=t.message;n.success=false}if(t.response){t=t.response}if(t&&t.statusCode!=undefined){n.response.headers=t.headers;n.response.statusCode=t.statusCode;n.response.statusText=t.statusText;n.response.responseText=t.body!==undefined?t.body:t.responseText;if(t.expandAfterCreateFailed){n.response.expandAfterCreateFailed=true}if(t.expandAfterFunctionCallFailed){n.response.expandAfterFunctionCallFailed=true}}}n.ID=e.requestID;return n};z.prototype._createRequestID=function(){var e;e=_();return e};z.prototype._getServerUrl=function(){var e,t;e=new L(this.sServiceUrl).absoluteTo(document.baseURI);t=new L("/").absoluteTo(e).toString();return t};z.prototype._createMetadataUrl=function(e){if(e.indexOf(this.sServiceUrl)==-1){if(!e.startsWith("/")){e="/"+e}e=this.sServiceUrl+e}var t=Object.assign({},this.mMetadataUrlParams);const a=new URL(e,"https://localhost").searchParams;for(const[e]of a){t[e]=a.get(e)}var r=k._createUrlParamsArray(t);var s=e.split("?");if(s.length>1){e=s[0]}return this._addUrlParams(e,r)};z.prototype._addUrlParams=function(e,t){var a=[];if(this.aUrlParams){a=a.concat(this.aUrlParams)}if(t){a=a.concat(t)}if(a.length>0){e+="?"+a.join("&")}return e};z.prototype._createRequestUrl=function(e,t,a,r){return this._createRequestUrlWithNormalizedPath(this._normalizePath(e,t),a,r)};z.prototype._createRequestUrlWithNormalizedPath=function(e,t,a){var r="";if(!a){r=this.sServiceUrl+e}else{r=e.substr(e.indexOf("/")+1)}return this._addUrlParams(r,t)};z.prototype._importData=function(e,t,a,r,s,n,i,o,d,u){var h=this,f,p,g,y;s=s||"";i=i||"";if(e.results&&Array.isArray(e.results)){f=[];c(e.results,function(e,r){var i=h._getKey(r);i=h._importData(r,t,a,undefined,s.substr(0,s.lastIndexOf("/")),n,i,undefined,undefined,u);if(i){f.push(i)}});return f}else{if(i){s="/"+i;n+=i.substr(i.indexOf("("))}else{i=this._getKey(e)}if(!i){return i}g=this._getEntity(i);y=g;if(!g||g.__metadata&&g.__metadata.invalid){if(!y){y=e}g=e;i=this._addEntity(g)}if(this.aBindableResponseHeaders){var _={};for(var m in a.headers){var v=m.toLowerCase();if(this.aBindableResponseHeaders.indexOf(v)>-1){_[v]=a.headers[m]}}if(!l(_)){if(!e.__metadata){e.__metadata={}}e.__metadata.headers=_}}c(e,function(e,r){if(r&&(r.__metadata&&r.__metadata.uri||r.results)&&!r.__deferred){var o=s+"/"+e;var d=n+"/"+e;p=h._importData(r,t,a,undefined,o,d,undefined,false,"/"+i+"/"+e,u);if(Array.isArray(p)){g[e]={__list:p};if(u){g[e].__list.sideEffects=true;h.aSideEffectCleanUpFunctions.push(function(){delete g[e]})}}else{if(y[e]&&y[e].__ref){if(y[e].__ref!==p){h.mInvalidatedPaths[s.substr(s.lastIndexOf("("))+"/"+e]="/"+p}}g[e]={__ref:p}}}else if(!r||!r.__deferred){if(y[e]&&r===null){h.mInvalidatedPaths[s.substr(s.lastIndexOf("("))+"/"+e]=null}g[e]=r}});if(this.hasContext("/"+i)&&this.getContext("/"+i).isPreliminary()){var b=this.getContext("/"+i);b.setUpdated(true);this.callAfterUpdate(function(){b.setUpdated(false)});b.setPreliminary(false)}if(r&&r.created&&r.key){this._cleanupAfterCreate(r,i)}this._updateChangedEntity(i,g);t[i]=true;s=s||"/"+i;n=n||s;var C=this.resolveFromCache(n);if(C==="/"+i||C&&C.split("/").length>2){this._writePathCache(C,"/"+i,o)}this._writePathCache(s,"/"+i,o);this._writePathCache(n,"/"+i,o,true);if(d){this._writePathCache(d,"/"+i,o)}return i}};z.prototype._writePathCache=function(e,t,a,r){var s,n,i,o,d,u;if(e&&t){if(!this.mPathCache[e]){this.mPathCache[e]={}}if(!a&&e.lastIndexOf("/")===0){t=e}this.mPathCache[e].canonicalPath=t;if(r){d=e.split("/");for(u=3;u<d.length;u+=1){i=d.slice(0,u).join("/");o=this.mPathCache[i];if(o){s=o.canonicalPath+e.slice(i.length);n=this.mPathCache[s];if(n){n.canonicalPath=t}}}}}};z.prototype._removeReferences=function(e){var t=this,a;if(!e){return e}if(e.results){a=[];c(e.results,function(e,r){a.push(t._removeReferences(r))});return a}else{c(e,function(t,a){if(a){if(a["__ref"]||a["__list"]){delete e[t]}}});return e}};z.prototype._restoreReferences=function(e,t){var a=this,r,s,n;function o(e){var r=t[e];if(!r){r=a._getObject("/"+e);i(r,"ODataModel inconsistent: "+e+" not found!");if(r){r=y({},r);t[e]=r;a._restoreReferences(r,t)}}return r}if(!t){t={}}c(e,function(t,a){if(a){if(a.__ref){r=a.__ref;s=o(r);if(s){e[t]=s}delete a.__ref}else if(a.__list){n=[];c(a.__list,function(e,t){s=o(t);if(s){n.push(s)}});delete a.__list;a.results=n}}});return e};z.prototype.removeData=function(){this.oData={}};z.prototype.initialize=function(){var e=this.getBindings();e.forEach(function(e){e.initialize()})};z.prototype.getServiceUrl=function(){return this.sServiceUrl};z.prototype.invalidate=function(e){var t;for(var a in this.oData){t=this.oData[a];if(!e||e(a,t)){t.__metadata.invalid=true}}};z.prototype.invalidateEntry=function(e){var t;if(typeof e==="string"){if(e.indexOf("/")===0){t=this._getObject(e)}else{t=this.oData[e]}}else if(e instanceof E){t=this._getObject(e.getPath())}if(t&&t.__metadata){t.__metadata.invalid=true}};z.prototype.invalidateEntityType=function(e){var t;for(var a in this.oData){t=this.oData[a];if(t.__metadata.type===e){t.__metadata.invalid=true}}};z.prototype.refresh=function(e,t,a){if(typeof e==="string"){a=e;e=false;t=false}if(t){this.removeData()}this._refresh(e,a)};z.prototype._refresh=function(e,t,a,r){var s=this.getBindings();this.sRefreshGroupId=t;s.forEach(function(t){t._refresh(e,a,r)});this.sRefreshGroupId=undefined};z.prototype.checkUpdate=function(e,t,a,r){if(t){this.bForceUpdate=this.bForceUpdate||e;Object.assign(this.mChangedEntities4checkUpdate,a);if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate,false,this.mChangedEntities4checkUpdate)}.bind(this),0)}return}e=this.bForceUpdate||e;if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;this.mChangedEntities4checkUpdate={}}var s=this.getBindings();s.forEach(function(t){if(!r||this.isMetaModelPath(t.getPath())){t.checkUpdate(e,a)}}.bind(this));this._processAfterUpdate()};z.prototype.checkDataState=function(e){var t=this.getBindings();t.forEach(function(t){if(t.checkDataState){t.checkDataState(e)}})};z.prototype.bindProperty=function(e,t,a){var r=new O(this,e,t,a);return r};z.prototype.bindList=function(e,t,a,r,n){var i=new s(this,e,t,a,r,n);return i};z.prototype.bindTree=function(e,t,a,r,s){var i=new n(this,e,t,a,r,s);return i};z.prototype.createBindingContext=function(e,t,a,r,s){var n,i,o,d,u,h,f,c,p,l=this;if(t!==null&&typeof t==="object"&&!(t instanceof E)){s=r;r=a;a=t;t=undefined}if(typeof t=="function"){s=a;r=t;a=undefined;t=undefined}if(typeof t=="boolean"){s=t;r=undefined;a=undefined;t=undefined}if(typeof a=="function"){s=r;r=a;a=undefined}if(typeof a=="boolean"){s=a;r=undefined;a=undefined}if(typeof r=="boolean"){s=r;r=undefined}if(a){n=a.canonicalRequest}n=this._isCanonicalRequestNeeded(n);p=this.resolve(e,t,n);if(!p&&n){p=this.resolve(e,t)}d=this.resolveDeep(e,t);if(!p){if(r){r(null)}return null}if(s===undefined){s=this._isReloadNeeded(p,a)}if(!s){i=this.resolve(e,t,true);if(i){f=this.getContext(i,d)}else{f=null}if(r){r(f)}return f}function g(a){var s=a?l._getKey(a):null,n=!(e===""||e.indexOf("/")>0),i=null,o,u;f=null;if(s){f=l.getContext("/"+s,d);i={__ref:s}}if(t&&h&&n){o=t.getPath();o=o.substr(1);u=l._getEntity(o);if(u){u[e]=i}}r(f)}function y(a){var s;if(a.statusCode=="404"&&t&&h){var n=t.getPath();n=n.substr(1);s=l._getEntity(n);if(s){s[e]={__ref:null}}}r(null)}if(r){h=!e.startsWith("/");c=[];o=this.createCustomParams(a);if(o){c.push(o)}if(a&&(a.batchGroupId||a.groupId)){u=a.groupId||a.batchGroupId}this.read(e,{canonicalRequest:n,context:t,error:y,groupId:u,success:g,updateAggregatedMessages:true,urlParameters:c})}if(a&&a.createPreliminaryContext){p=this.resolve(e,t,n);if(!p&&n){p=this.resolve(e,t)}f=this.getContext(p,d);return f}return undefined};z.prototype._updateContext=function(e,t,a){e.sPath=t;if(a!==undefined){e.sDeepPath=a}this.mContexts[t]=e};z.prototype._splitEntries=function(e){return e.replace(/\s/g,"").split(",").map(function(e){return e.split("/")})};z.prototype._filterOwnSelect=function(e,t){var a,r;if(!t){return[]}r=t.map(function(e){return e.name});a=e.filter(function(e){return e.length===1}).map(function(e){return e[0]});if(e.length===0||a.indexOf("*")!==-1||a.indexOf("**")!==-1){return r}else{return a.filter(function(e){return r.indexOf(e)!==-1})}};z.prototype._filterOwnExpand=function(e,t){return e.map(function(e){return e[0]}).filter(function(e,t,a){return a.indexOf(e)===t}).filter(function(e){return t.length===0||t.some(function(t){return t.indexOf(e)===0||t.indexOf("**")===0})})};z.prototype._filterSelectByNavProp=function(e,t){return e.filter(function(e){return e[0]===t}).map(function(e){return e.length>1?e.slice(1):["**"]})};z.prototype._filterExpandByNavProp=function(e,t){return e.filter(function(e){return e.length>1&&e[0]===t}).map(function(e){return e.slice(1)})};z.prototype._isReloadNeeded=function(e,t){var a=this,r=this.oMetadata,s,n=[],i=[];if(!this.oMetadata.isLoaded()){return true}var o;if(t){o=t.canonicalRequest}o=this._isCanonicalRequestNeeded(o);if(o){e=this.resolve(e,undefined,o)||e}var d=this._getObject(e);s=this.oMetadata._getEntityTypeByPath(e);if(this._isCreatedEntity(d)){return false}function u(e,t,s,n){var i,o,d,h,f,c,p,l,g,y;if(!e){return false}if(t===null){return false}if(!t){return true}if(t.__metadata&&t.__metadata.invalid){return true}g=a._filterOwnSelect(s,e.property);for(o=0;o<g.length;o++){y=g[o];if(t[y]===undefined){return true}}l=a._filterOwnExpand(n,s);for(o=0;o<l.length;o++){i=l[o];d=t[i];if(d===null){continue}if(d===undefined||d.__deferred){return true}f=r._getEntityTypeByNavProperty(e,i);p=a._filterSelectByNavProp(s,i);c=a._filterExpandByNavProp(n,i);if(d.__ref){h=a._getEntity(d.__ref);if(u(f,h,p,c)){return true}}if(d.__list){for(var _=0;_<d.__list.length;_++){h=a._getEntity(d.__list[_]);if(u(f,h,p,c)){return true}}}}return false}if(t){if(t.select){i=this._splitEntries(t.select)}if(t.expand){n=this._splitEntries(t.expand)}}return u(s,d,i,n)};z.prototype.createCustomParams=function(e){var t=[],a,r={expand:true,select:true};for(var s in e){if(s in r){t.push("$"+s+"="+u(e[s]))}if(s==="custom"){a=e[s];for(s in a){if(s.indexOf("$")===0){o.warning(this+" - Trying to set OData parameter '"+s+"' as custom query option!")}else if(typeof a[s]==="string"){t.push(s+"="+u(a[s]))}else{t.push(s)}}}}return t.join("&")};z.prototype.bindContext=function(e,t,a){var s=new r(this,e,t,a);return s};z.prototype.setDefaultCountMode=function(e){this.sDefaultCountMode=e};z.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode};z.prototype._addEntity=function(e){var t=this._getKey(e);this.oData[t]=e;return t};z.prototype._removeEntity=function(e){e=e&&k._normalizeKey(e);delete this.oData[e];delete this.mChangedEntities[e];delete this.mContexts["/"+e]};z.prototype._getEntity=function(e){var t=this.oData[e];if(!t){e=e&&k._normalizeKey(e);t=this.oData[e]}return t};z.prototype._getKey=function(e){var t,a;if(e instanceof E){t=e.getPath().substr(1)}else if(e&&e.__metadata&&e.__metadata.uri){a=e.__metadata.uri;t=a.substr(a.lastIndexOf("/")+1)}else if(typeof e==="string"){t=e.substr(e.lastIndexOf("/")+1)}if(!this.oData[t]){t=t&&k._normalizeKey(t)}return t};z.prototype.getKey=function(e){return this._getKey(e)};z.prototype.createKey=function(e,t){var a=this.oMetadata._getEntityTypeByPath(e),r=e,s=this,n,o;i(a,'Could not find entity type of collection "'+e+'" in service metadata!');r+="(";if(a.key.propertyRef.length===1){n=a.key.propertyRef[0].name;i(n in t,'Key property "'+n+'" is missing in object!');o=this.oMetadata._getPropertyMetadata(a,n);r+=encodeURIComponent(k.formatValue(t[n],o.type))}else{c(a.key.propertyRef,function(e,d){if(e>0){r+=","}n=d.name;i(n in t,'Key property "'+n+'" is missing in object!');o=s.oMetadata._getPropertyMetadata(a,n);r+=n;r+="=";r+=encodeURIComponent(k.formatValue(t[n],o.type))})}r+=")";return r};z.prototype.getProperty=function(e,t,a){var r=this._getObject(e,t);if(!a){return r}if(!g(r)){return r}r=y({},r);if(a===true){return this._restoreReferences(r)}else{return this._removeReferences(r)}};z.prototype.getObject=function(e,t,a){if(g(t)){a=t;t=undefined}var r=this,s=this.resolve(e,t),n=this._getObject(s),i=this.oMetadata._getEntityTypeByPath(s),d=[],u=[];if(!i||!g(n)||!n.__metadata||!n.__metadata.uri){return n}if(!a||!(a.select||a.expand)){return y({},n)}function h(e,t,a,s){var n,i,d,u,f,c,p,l,g,y,_,m,v,b;if(!t){return undefined}if(!e){return undefined}_=r._filterOwnSelect(a,e.property);v={};for(i=0;i<_.length;i++){b=_[i];if(t[b]!==undefined||t.__metadata.created){v[b]=t[b]}else{o.fatal("No data loaded for select property: "+b+" of entry: "+r.getKey(t));return undefined}}if(t.__metadata){v.__metadata=t.__metadata}g=r._filterOwnExpand(s,a);for(i=0;i<g.length;i++){n=g[i];d=t[n];u=r.oMetadata._getEntityTypeByNavProperty(e,n);p=r._filterSelectByNavProp(a,n);f=r._filterExpandByNavProp(s,n);if(d&&d.__ref){c=r._getObject("/"+d.__ref);l=h(u,c,p,f);if(l!==undefined){v[n]=l}else{o.fatal("No data loaded for expand property: "+n+" of entry: "+r.getKey(l));return undefined}}if(d&&d.__list){m=[];for(var C=0;C<d.__list.length;C++){c=r._getObject("/"+d.__list[C]);l=h(u,c,p,f);if(l!==undefined){m.push(l)}else{o.fatal("No data loaded for expand property: "+n+" of entry: "+r.getKey(l));return undefined}}v[n]=m}}y=r._filterOwnSelect(a,e.navigationProperty);for(var P=0;P<y.length;P++){n=y[P];if(g.indexOf(n)===-1){var R=v.__metadata.uri+"/"+n;v[n]={__deferred:{uri:R}}}}return v}if(a.select){u=this._splitEntries(a.select)}if(a.expand){d=this._splitEntries(a.expand)}n=h(i,n,u,d);return n};z.prototype._getObject=function(e,t,a,r){var s,n,i,o,d,u,h,f,c,p,l,_=r?undefined:null;let m=_;if(this.isLegacySyntax()){m=this.oData}p=this.resolve(e,t,this.bCanonicalRequests);if(!p&&this.bCanonicalRequests){p=this.resolve(e,t)}if(!p){return m}if(e&&e.startsWith("@$ui5.")){return this._getInstanceAnnotationValue(e,t)}if(this._isMetadataPath(p)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(p)){h=this.getMetaModel();i=D.getCodeListTerm(p);if(i){n=h.fetchCodeList(i);if(n.isFulfilled()){return n.getResult()}if(n.isRejected()){n.caught()}return undefined}if(!this.bMetaModelLoaded){return null}l=p.indexOf("/##");o=p.substr(0,l);f=p.substr(l+3);u=h.getMetaContext(o);m=h.getProperty(f,u)}else{m=this.oMetadata._getAnnotation(p)}}else if(D.getCodeListTerm(p)){return undefined}}else{if(p==="/"){return this.oData}var v=p.split("/"),b=0;d=v[1];v.splice(0,2);s=this.mChangedEntities[d];c=this._getEntity(d);m=a?c:s||c;while(m&&v[b]){var C=s&&s.hasOwnProperty(v[b]);s=s&&s[v[b]];c=c&&c[v[b]];m=a||!C?c:s;if(m){if(m.__ref){s=this.mChangedEntities[m.__ref];c=this._getEntity(m.__ref);m=a?c:s||c}else if(m.__list){m=m.__list}else if(m.__deferred){m=undefined}}b++}}if(g(s)){m=a?c:y({},c,s)}return m};z.prototype._getInstanceAnnotationValue=function(e,t){if(e==="@$ui5.context.isInactive"){return t.isInactive()}if(e==="@$ui5.context.isTransient"){return t.isTransient()}throw new Error("Unsupported instance annotation: "+e)};z.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken()}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken}}};z.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken};z.prototype.getSecurityToken=function(){var e=this.oSharedServiceData.securityToken;if(!e){this.refreshSecurityToken();e=this.oSharedServiceData.securityToken}return e};z.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken)}else{this.pSecurityToken=new Promise(function(e,t){this.refreshSecurityToken(function(){e(this.oSharedServiceData.securityToken)}.bind(this),function(e){t(e)},true)}.bind(this))}}return this.pSecurityToken};z.prototype.refreshSecurityToken=function(e,t,a){var r,s,n=this,i={abort:function(){if(n.pRetryAfter){throw new Error("abort() during HTTP 503 'Retry-after' processing not supported")}this.request.abort()}},o=this._createRequestUrlWithNormalizedPath("/");function d(t,a){if(a){s=n._getHeader("x-csrf-token",a.headers);n._setSessionContextIdHeader(n._getHeader("sap-contextid",a.headers));if(s){if(n.oSharedServerData){n.oSharedServerData.securityToken=s}n.oSharedServiceData.securityToken=s;n.pSecurityToken=Promise.resolve(s);n.oHeaders["x-csrf-token"]=s}else{n.resetSecurityToken();n.bTokenHandling=false}}if(e){e(t,a)}}function u(e){if(e.$rejected){n.resetSecurityToken();t(e);return}n.resetSecurityToken();n.bTokenHandling=false;n._handleError(e,r);if(t){t(e)}}function h(e){if(e.$rejected){n.resetSecurityToken();t(e);return}i.request=f("GET",u)}function f(e,t){r=n._createRequest(o,"",e,n._getHeaders(undefined,true),null,null,!!a);r.headers["x-csrf-token"]="Fetch";return n._request(r,d,t,undefined,undefined,n.getServiceMetadata())}if(this.bDisableHeadRequestForToken){i.request=f("GET",u)}else{i.request=f("HEAD",h)}return i};z.prototype.checkAndProcessRetryAfterError=function(e,t,a,r,s,n,i,o,d){if(t.response?.statusCode===503&&this._getHeader("retry-after",t.response.headers)&&this.fnRetryAfter&&!this.bSequentializeRequests){if(!this.pRetryAfter){this.oRetryAfterError=this.createRetryAfterError(t);this.pRetryAfter=this.fnRetryAfter(this.oRetryAfterError)}this.pRetryAfter.then(()=>{this.pRetryAfter=this.oRetryAfterError=null;o.abort=this._request(e,a,r,s,n,i,d).abort},e=>{this.pRetryAfter=null;this.onRetryAfterRejected(r,t,e)});return true}return false};z.prototype.createRetryAfterError=function(e){const t=new Error(e.message);const a=this._getHeader("retry-after",e.response.headers);const r=parseInt(a);t.retryAfter=new Date(Number.isNaN(r)?a:Date.now()+r*1e3);return t};z.prototype.onRetryAfterRejected=function(e,t,a){if(this.bDestroyed){return}const r=a?.message?"Retry-After handler rejected with: "+a.message:"Retry-After handler rejected w/o reason";if(t){t.$rejected=true;if(this.oRetryAfterError!==a){t.$ownReason=true;t.$reported=true;o.error(r,a?.stack,j)}}e(t||{$ownReason:true,$rejected:true,$reported:true,message:r})};z.prototype._submitRequest=function(e,t,a){var r=this,s,n,i,o,d;o=new Promise(function(e,t){d=e});function u(e,a){if(t){t(e,a)}r.aSideEffectCleanUpFunctions.forEach(function(e){e()});r.aSideEffectCleanUpFunctions=[];d()}function h(t){if(r.bTokenHandling&&t.response){var s=r._getHeader("x-csrf-token",t.response.headers);if(!e.bTokenReset&&t.response.statusCode=="403"&&s&&s.toLowerCase()==="required"){r.resetSecurityToken();e.bTokenReset=true;p();return}}if(a){a(t)}d()}function f(e){if(r.bTokenHandling&&(e.method!=="GET"||r.bTokenHandlingForGet)){r.pReadyForRequest=r.securityTokenAvailable()}return r.pReadyForRequest}function p(){if(r.bTokenHandling){delete e.headers["x-csrf-token"]}f(e).then(function(t){if(r.bTokenHandling&&(e.method!=="GET"||r.bTokenHandlingForGet)){e.headers["x-csrf-token"]=t}g()},function(e){if(e.$rejected){h(e);return}g()})}function l(e,t,a){var s,n=t.eventInfo.requests;if(n){c(n,function(t,a){if(Array.isArray(a)){a.forEach(function(t){c(t.parts,function(a,n){s=r._createEventInfo(t.request,n.fnError);r["fireRequest"+e](s)})})}else if(a.parts){c(a.parts,function(t,n){s=r._createEventInfo(a.request,n.fnError);r["fireRequest"+e](s)})}else{s=r._createEventInfo(a.request,a.fnError);r["fireRequest"+e](s)}});if(t.eventInfo.batch){s=r._createEventInfo(t,a,n);r["fireBatchRequest"+e](s)}}}function g(){if(r.sSessionContextId){e.headers["sap-contextid"]=r.sSessionContextId}n=r._request(e,u,h,s,undefined,r.getServiceMetadata());if(e.eventInfo){l("Sent",e,null);delete e.eventInfo}if(i&&n){n.abort()}}s=r._getODataHandler(e.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){p()});this.pSequentialRequestCompleted=o}else{p()}return{abort:function(){if(n){n.abort()}i=true}}};z.prototype._setSessionContextIdHeader=function(e){if(e){this.sSessionContextId=e}};z.prototype._submitSingleRequest=function(e){var t=this,a,r={},s={},n={};function i(a,i){if(a===undefined&&i.statusCode===200){o({message:"Response did not contain a valid OData result",response:i});return}function d(a,i){for(var o=0;o<e.parts.length;o++){if(e.parts[o].request._aborted){t._processAborted(e.parts[o].request,i)}else if(e.parts[o].fnSuccess){e.parts[o].fnSuccess(a,i)}}if(e.request.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,s);if(e.bRefreshAfterChange){t._refresh(false,undefined,r,n)}}}t._processSuccess(e.request,i,d,s,r,n);t._invalidatePathCache();t._setSessionContextIdHeader(t._getHeader("sap-contextid",i.headers))}function o(a){var r;if(a.message=="Request aborted"){for(r=0;r<e.parts.length;r++){t._processAborted(e.parts[r].request,a)}}else{for(r=0;r<e.parts.length;r++){t._processError(e.parts[r].request,a,e.parts[r].fnError)}}t._processAfterUpdate()}e.request.eventInfo={requests:e.parts,batch:false};a=this._submitRequest(e.request,i,o);return a};z.prototype._submitBatchRequest=function(e,t,a,r){var s=this,n={},i={},o={},d={};function u(e,t,a){var r,u,h;for(h=0;h<e.parts.length;h++){var f,c;if(a||e.parts[h].request._aborted){s._processAborted(e.parts[h].request,t)}else if(t.message){s._processError(e.parts[h].request,t,e.parts[h].fnError)}else{if(e.request.contentID){r=e.request.contentID;if(e.request.created||e.request.functionMetadata){u=s._getKey(t.data);i[r]={key:u,functionImport:!!e.request.functionMetadata,deepPath:e.request.deepPath.replace("('"+r+"')",u.slice(u.indexOf("(")))}}else{u=i[r].key;if(i[r].functionImport){f=e.request.deepPath;c=e.request.requestUri}e.request.requestUri=e.request.requestUri.replace("$"+r,u);e.request.deepPath=i[r].deepPath}}s._processSuccess(e.parts[h].request,t,e.parts[h].fnSuccess,o,n,d,false,undefined,i);if(c){e.request.deepPath=f;e.request.requestUri=c}}}}function h(r,i){if(r===undefined&&i.statusCode===200){f({message:"Response did not contain a valid OData batch result",response:i});return}var h,c,p,l=r.__batchResponses;if(l){var g,y;for(g=0;g<l.length;g++){h=l[g];if(Array.isArray(t[g])){if(h.message){for(y=0;y<t[g].length;y++){h.$reported=false;c=t[g][y];u(c,h);c.response=h}}else{p=h.__changeResponses;for(y=0;y<p.length;y++){var _=p[y];c=t[g][y];u(c,_);c.response=_}}}else{c=t[g];u(c,h);c.response=h}}s._invalidatePathCache();s.checkUpdate(false,false,o)}s._processSuccess(e,i,a,o,n,d,true,t);s._setSessionContextIdHeader(s._getHeader("sap-contextid",i.headers))}function f(a){var n=a.message=="Request aborted";a.$reported=true;c(t,function(e,t){if(Array.isArray(t)){t.forEach(function(e){u(e,a,n)})}else{u(t,a,n)}});s._processAfterUpdate();if(n){s._processAborted(e,a,true)}else{a.$reported=a.$ownReason||false;s._processError(e,a,r,true,t)}}e.eventInfo={requests:t,batch:true};var p=this._submitRequest(e,h,f);function l(e){var t;for(var a=0;a<e.parts.length;a++){t=e.parts[a].fnError;if(!e.parts[a].request._aborted&&t){t(z._createAbortedError())}}}var g={abort:function(e){c(t,function(e,t){if(Array.isArray(t)){t.forEach(function(e){l(e)})}else{l(t)}});if(r&&!e){r(z._createAbortedError())}p.abort()}};return g};z.prototype._invalidatePathCache=function(){var e=this,t;if(Object.keys(this.mInvalidatedPaths).length>0){Object.keys(this.mPathCache).forEach(function(a){for(var r in e.mInvalidatedPaths){t=a.indexOf(r);if(t>-1){if(t+r.length!==a.length){var s=a.substr(t+r.length);e.mPathCache[a].canonicalPath=e.mInvalidatedPaths[r]===null?null:e.mInvalidatedPaths[r]+s}else{e.mPathCache[a].canonicalPath=e.mInvalidatedPaths[r]}}}})}this.mInvalidatedPaths={}};z.prototype._createBatchRequest=function(e){var t,a,r={},s={},n="true";s.__batchRequests=e;for(var i in e){if(e[i]&&e[i].__changeRequests||e[i]&&e[i].headers&&e[i].headers["sap-cancel-on-close"]!=="true"){n="false";break}}t=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){t+="?"+this.aUrlParams.join("&")}p(r,this.mCustomHeaders,this.oHeaders);r["Accept"]="multipart/mixed";delete r["Content-Type"];r["sap-cancel-on-close"]=n;a={headers:r,requestUri:t,method:"POST",data:s,user:this.sUser,password:this.sPassword,async:true};a.withCredentials=this.bWithCredentials;return a};z.prototype.abortInternalRequest=function(e,t){var a=this.mRequests;var r,s;if(t){r=t.requestKey;s=t.path}if(e in this.mDeferredGroups){a=this.mDeferredRequests}var n=function(e){for(var t=0;t<e.parts.length;t++){e.parts[t].requestHandle.abort()}};var i=a[e];if(i){if(r in i.map){n(i.map[r])}else if(s){c(i.map,function(e,t){if(e.indexOf(s)>=0){n(t)}})}else if(e&&!t){c(i.map,function(e,t){n(t)})}}};z.prototype._pushToRequestQueue=function(e,t,a,r,s,n,i,o){var d,u=e[t],h=r.key?r.key:r.method+":"+r.requestUri;if(this.bWarmup){return}if(!u){u={};u.map={};u.requests=[];e[t]=u}if(h in u.map&&(r.key||r.method==="GET")){d=u.map[h];var f=d.request;r.deepPath=f.deepPath;if(d.bRefreshAfterChange===undefined){d.bRefreshAfterChange=o}if(!r.key){d.parts.push({request:r,fnSuccess:s,fnError:n,requestHandle:i})}if(r.method==="GET"){delete f.data}else{f.method=r.method;f.headers=r.headers;f.data=r.data;f.sideEffects=r.sideEffects;if(r.method===w.PUT){delete f.headers["x-http-method"]}if(f._aborted){delete f._aborted}}if(f.functionMetadata){f.requestUri=r.requestUri;f.functionTarget=r.functionTarget}}else{d={request:r,bRefreshAfterChange:o,parts:[{request:r,fnSuccess:s,fnError:n,requestHandle:i}]};if(r.method==="GET"){u.requests.push(d)}else{if(!u.changes){u.changes={}}var c=u.changes[a];if(!c){c=[];u.changes[a]=c}d.changeSetId=a;c.push(d)}u.map[h]=d}};z.prototype._collectChangedEntities=function(e,t,a){var r=this;if(e.changes){c(e.changes,function(e,s){for(var n=0;n<s.length;n++){if(s[n].bRefreshAfterChange){var i=s[n].request,o="/"+i.requestUri.split("?")[0],d,u;if(i.method==="POST"||i.method==="DELETE"){var h=r.oMetadata._getEntityTypeByPath(o);if(h){a[h.entityType]=true}}else{d=r._getObject(o);if(d){u=r._getKey(d)}else if(o.lastIndexOf("/")===0){u=r._getKey(o)}if(u){t[u]=true}}}}})}};z.prototype._processRequestQueue=function(e,t,a,r,s){var n=this,i,o=[];function d(e,t){for(var a=0;a<e.parts.length;a++){var r=e.parts[a];if(r.request._aborted){n._processAborted(e.request,null);e.parts.splice(a,1);a--}else if(t){r.request._handle=t;t.iRelevantRequests++}}}function u(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort(true);if(a){a({},undefined)}}}}}if(this.bUseBatch){c(e,function(e,a){if(e===t||!t){var r={},s={};n._collectChangedEntities(a,r,s);if(Object.keys(r).length||Object.keys(s).length){n.bIncludeInCurrentBatch=true;n._refresh(false,e,r,s);n.bIncludeInCurrentBatch=false}}});c(e,function(h,f){if(h===t||!t){var p=[],l=[],g,y;var _=u();if(f.changes){c(f.changes,function(t,a){var r,o,u;g={__changeRequests:[]};y=[];for(o=0;o<a.length;o++){r=a[o].request;q.extend(r.headers,s);i="/"+n.getKey(r.data);n.increaseLaundering(i,r.data);d(a[o],_);if(a[o].parts.length>0){n.removeInternalMetadata(r.data);g.__changeRequests.push(r);if(r.expandRequest){u=a[o].parts[0];n._pushToRequestQueue(e,h,undefined,r.expandRequest,u.fnSuccess,u.fnError,u.requestHandle,false)}y.push(a[o])}}if(g.__changeRequests&&g.__changeRequests.length>0){p.push(g);l.push(y)}})}if(f.requests){var m=f.requests;for(var v=0;v<m.length;v++){d(m[v],_);if(m[v].parts.length>0){p.push(m[v].request);l.push(m[v])}}}if(p.length>0){var b=n._createBatchRequest(p);_.oRequestHandle=n._submitBatchRequest(b,l,a,r);o.push(_.oRequestHandle)}delete e[h]}})}else{c(e,function(a,r){if(a===t||!t){if(r.changes){c(r.changes,function(e,t){for(var a=0;a<t.length;a++){var r=u();i="/"+n.getKey(t[a].request.data);n.increaseLaundering(i,t[a].request.data);d(t[a],r);if(t[a].parts.length>0){n.removeInternalMetadata(t[a].request.data);r.oRequestHandle=n._submitSingleRequest(t[a]);o.push(r.oRequestHandle)}}})}if(r.requests){var s=r.requests;for(var h=0;h<s.length;h++){var f=u();d(s[h],f);if(s[h].parts.length>0){f.oRequestHandle=n._submitSingleRequest(s[h]);o.push(f.oRequestHandle)}}}delete e[a]}})}this.checkDataState(this.mLaunderingState);return o.length==1?o[0]:o};z.prototype._processRequestQueueAsync=function(e){var t=this;if(!this.pCallAsync){this.pCallAsync=this.oMetadata.loaded().then(function(){return Promise.resolve().then(function(){t._processRequestQueue(e);t.pCallAsync=undefined})})}};z.prototype._processSuccess=function(e,t,a,r,s,n,i,d,u){var h,f,l,g,_,m,v,b,C,P,R,q,M,E={},S={},A=t.data,T=this;if(!i){f=!["204","205"].includes(String(t.statusCode));M=e.requestUri;R=M.replace(this.sServiceUrl,"");if(!R.startsWith("/")){R="/"+R}C=this._normalizePath(R);_=this.oMetadata._getEntityTypeByPath(C);b=_&&_.isFunction;R=this._normalizePath(R,undefined,!b);this.decreaseLaundering(R,e.data);this._decreaseDeferredRequestCount(e);if(e.functionMetadata){if(t.headers&&t.headers.location){m=t.headers.location;q=m.lastIndexOf(this.sServiceUrl);if(q>-1){h=k._normalizeKey(m.slice(q+this.sServiceUrl.length));if(e.functionTarget===h){l=this.getDeepPathForCanonicalPath(h);if(l){e.deepPath=l}}e.functionTarget=h}}if(e.adjustDeepPath){e.deepPath=e.adjustDeepPath({deepPath:l||e.functionTarget,response:y({},t)})}else if(!l){if(!m){l=this.getDeepPathForCanonicalPath(e.functionTarget)}e.deepPath=l||e.functionTarget}if(u&&e.contentID){u[e.contentID].deepPath=e.deepPath}}if(f&&A===undefined&&t){this._parseResponse(t,e);o.fatal(this+" - No data was retrieved by service: '"+t.requestUri+"'");T.fireRequestCompleted({url:t.requestUri,type:"GET",async:t.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false}if(A&&!A.__metadata&&A.results&&!Array.isArray(A.results)){A=A.results}if(!t._imported&&A&&(Array.isArray(A)||typeof A=="object")){v=y({},A);if(e.key||e.created){T._importData(v,S,t,e,undefined,undefined,undefined,b,undefined,e.sideEffects)}else{T._importData(v,S,t,e,R,e.deepPath,undefined,b,undefined,e.sideEffects)}t._imported=true}g=this._getEntity(e.key);if(g&&g.__metadata.created&&g.__metadata.created.functionImport){var x=[];var U=g["$result"];if(U&&U.__list){c(S,function(e){x.push(e)});U.__list=x}else if(U&&U.__ref){c(S,function(e){U.__ref=e})}}if(!f){P=R.split("/");if(P[1]){E[P[1]]=e;this._updateChangedEntity(P[1],e.data)}if(e.method==="DELETE"&&P[2]!=="$links"){this._removeEntity(P[1])}}if(f&&e.method==="POST"||e.functionMetadata){if(_){n[_.entityType]=true}if(e.key){if(e.created){this._removeEntity(e.key)}else{delete this.mChangedEntities[e.key]}}}if(!t.$reported){this._parseResponse(t,e,S,E);t.$reported=true}p(r,S);p(s,E);this._updateETag(e,t)}if(a){a(A,t)}var D=this._createEventInfo(e,t,d);if(i){this.fireBatchRequestCompleted(D)}else{this.fireRequestCompleted(D)}return true};z.prototype._cleanupAfterCreate=function(e,t){var a,r,s,n=this.getContext("/"+e.key),i=e.deepPath,o=this._getEntity(t);if(n.isTransient()&&i.endsWith(")")){e.deepPath=i.slice(0,i.lastIndexOf("("))+t.slice(t.indexOf("("))}this._updateContext(n,"/"+t,e.deepPath);n.setUpdated(true);this.callAfterUpdate(function(){n.setUpdated(false)});delete o.__metadata.created;a=this.mChangedEntities[e.key];if(a){r=this.oMetadata._getNavigationPropertyNames(this.oMetadata._getEntityTypeByPath(t));a=q.merge({},a);a.__metadata=q.merge({},o.__metadata);a.__metadata.deepPath=e.deepPath;for(s in e.data){if(q.deepEqual(e.data[s],a[s])||r.includes(s)){delete a[s]}}this.mChangedEntities[t]=a;this.abortInternalRequest(this._resolveGroup(e.key).groupId,{requestKey:e.key})}};z.prototype._processError=function(e,t,a,r,s){var n,i;if(e.functionMetadata){e.deepPath=e.functionTarget}n=this._handleError(t,e);if(!r){i="/"+this.getKey(e.data);this.decreaseLaundering(i,e.data);this._decreaseDeferredRequestCount(e)}if(a){a(n)}var o=this._createEventInfo(e,n,s);if(r){this.fireBatchRequestCompleted(o);this.fireBatchRequestFailed(o)}else{this.fireRequestCompleted(o);this.fireRequestFailed(o)}};z.prototype._processAborted=function(e,t,a){var r,s;if(!a){s="/"+this.getKey(e.data);this.decreaseLaundering(s,e.data);this._decreaseDeferredRequestCount(e)}if(t){r=this._createEventInfo(e,z._createAbortedError());r.success=false;if(a){this.fireBatchRequestCompleted(r)}else{this.fireRequestCompleted(r)}}};z.prototype._processAfterUpdate=function(){var e=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var t=0;t<e.length;t++){e[t]()}};z.prototype._processChange=function(e,t,a,r){var s,n,i,o,d,u,f,p,l,g,_,m,v,b,C,P="/"+e,R=this;d=this.oMetadata._getEntityTypeByPath(e);if(!r){r=this.sDefaultUpdateMethod}_=y({},this._getObject(P),t);o=_.__metadata.deepPath;i=_.__metadata.created;if(i){g=i.method?i.method:"POST";e=i.key;f=i.expandRequest;s=i.contentID;p=i.functionImport;if(p){i.urlParameters=this._createFunctionImportParameters(i.key,g,_);_=undefined}else{delete _.__metadata["uri"]}}else if(r===w.MERGE){g=w.MERGE;v=this._getEntity(e)}else{g=w.PUT}if(_&&_.__metadata){for(var q in _.__metadata){if(q!=="type"&&q!=="uri"&&q!=="etag"&&q!=="content_type"&&q!=="media_src"){delete _.__metadata[q]}}}if(_&&d){var M=this.oMetadata._getNavigationPropertyNames(d);M.forEach(function(e){delete _[e]})}if(g===w.MERGE&&d&&v){c(_,function(t,a){if(t!=="__metadata"){if(h(v[t],a)&&!R.isLaundering("/"+e+"/"+t)){delete _[t]}}});var E="/"+e,S;c(_,function(e,t){if(e!=="__metadata"){S=R.getProperty(E+"/"+e+"/#@sap:unit");if(S){if(_[S]===undefined){_[S]=v[S]}}}});if(v.__metadata.etag){_.__metadata.etag=v.__metadata.etag}}_=this._removeReferences(_);C=i&&i.urlParameters?k._createUrlParamsArray(i.urlParameters):undefined;l=i?this._getHeaders(i.headers):this._getHeaders();if(!p&&this._isTransitionMessagesOnly(a)){l["sap-messages"]="transientOnly"}u=i&&i.eTag?i.eTag:this.getETag(_);b=this._createRequestUrl("/"+e,null,C,this.bUseBatch);n=this.getContext(P);m=this._createRequest(b,o,g,l,_,u,undefined,true,n.hasSubContexts());if(i){if(f){m.expandRequest=f;m.contentID=s}if(p){m.functionTarget=this.oMetadata._getCanonicalPathOfFunctionImport(i.functionMetadata,i.urlParameters);m.functionMetadata=i.functionMetadata}else{m.created=true;this._addSubEntitiesToPayload(n,_)}}if(this.bUseBatch){m.requestUri=m.requestUri.replace(this.sServiceUrl+"/","")}return m};z.prototype._resolveGroup=function(e){var t,a,r,s,n,i,o=e.startsWith("/")?e:"/"+e;s=this._getObject(o);r=s&&s.__metadata&&s.__metadata.created;if(r){return{groupId:r.groupId,changeSetId:r.changeSetId}}n=this.oMetadata._getEntityTypeByPath(o);if(this.mChangeGroups[n.name]){t=this.mChangeGroups[n.name];i=t.groupId;a=t.single?_():t.changeSetId}else if(this.mChangeGroups["*"]){t=this.mChangeGroups["*"];i=t.groupId;a=t.single?_():t.changeSetId}return{groupId:i,changeSetId:a}};z.prototype._updateETag=function(e,t){var a,r,s;a=e.requestUri.replace(this.sServiceUrl+"/","");if(!a.startsWith("/")){a="/"+a}r=this._getObject(a.split("?")[0],undefined,true);s=this._getHeader("etag",t.headers);if(r&&r.__metadata&&s){r.__metadata.etag=s}};z.prototype._handleError=function(e,t,a){var r,s={message:e.message};if(e.response){if(!e.$reported){this._parseResponse(e.response,t);if(this.bTokenHandling){r=this._getHeader("x-csrf-token",e.response.headers);if(e.response.statusCode=="403"&&r&&r.toLowerCase()==="required"){this.resetSecurityToken()}}}s.statusCode=e.response.statusCode;s.statusText=e.response.statusText;s.headers=e.response.headers;s.responseText=e.response.body}else if(!e.$reported){o.error("The following problem occurred: "+e.message,e.stack,a||j)}e.$reported=true;return s};z.prototype.getReporter=function(e){var t=this;return function(a){t._handleError(a,undefined,e)}};z.prototype.getData=function(e,t,a){return this.getProperty(e,t,a)};z.prototype._getODataHandler=function(e){if(e.indexOf("$batch")>-1){return B.batchHandler}else if(e.indexOf("$count")>-1){return undefined}else if(this.bJSON){return B.jsonHandler}else{return B.atomHandler}};z.prototype.getETag=function(e,t,a){if(typeof e=="object"){a=e;e=""}return this._getETag(e,t,a)};z.prototype._getETag=function(e,t,a){if(!a||!a.__metadata){a=this._getObject(e,t)}if(a&&a.__metadata){return a.__metadata.etag}return null};z.prototype.forceEntityUpdate=function(e){var t=this.mChangedEntities[e];if(t&&t.__metadata){t.__metadata.etag="*"}else{o.error(this+" - Entity with key "+e+" does not exist or has no change")}};z.prototype._createRequest=function(e,t,a,r,s,n,i,d,u,h){var f;i=i!==false;if(n&&a!=="GET"){r["If-Match"]=n}if(!r["Content-Type"]&&a!=="DELETE"&&a!=="GET"){if(this.bJSON){r["Content-Type"]="application/json"}else{r["Content-Type"]="application/atom+xml"}}if(e.indexOf("$count")>-1){r["Accept"]="text/plain, */*;q=0.5"}if(a===w.MERGE&&!this.bUseBatch){r["x-http-method"]=w.MERGE;a="POST"}if(this.sMessageScope===x.BusinessObject&&r["sap-messages"]!=="transientOnly"){if(this.bIsMessageScopeSupported){r["sap-message-scope"]=this.sMessageScope}else{o.error("Message scope 'sap.ui.model.odata.MessageScope.BusinessObject' is not"+" supported by the service: "+this.sServiceUrl,undefined,j)}}d=d&&this.sMessageScope===x.BusinessObject&&this.bIsMessageScopeSupported;if(this.bUseBatch&&a!=="GET"&&a!=="HEAD"&&!r["Content-ID"]){r["Content-ID"]=_()}f={async:i,deepPath:t,headers:r,method:a,password:this.sPassword,requestUri:e,updateAggregatedMessages:d,user:this.sUser};if(u){f.sideEffects=true}if(h){f.fnRequest=h}if(s){f.data=s}if(this.bWithCredentials){f.withCredentials=this.bWithCredentials}f.requestID=this._createRequestID();return f};z.prototype._processRequest=function(e,t,a){var r,s,n=false,i=this;if(this.bWarmup){return{abort:function(){}}}if(a){this.iPendingDeferredRequests+=1}s={abort:function(){if(i.pRetryAfter){throw new Error("abort() during HTTP 503 'Retry-after' processing not supported")}if(a&&!n){i.iPendingDeferredRequests-=1}if(!n&&t){t(z._createAbortedError())}if(r){r._aborted=true;if(r._handle){r._handle.abort()}}n=true}};this.oMetadata.loaded().then(function(){r=e(s);if(r){r.deferred=!!a}i._processRequestQueueAsync(i.mRequests);if(n){s.abort()}});return s};z.prototype.update=function(e,t,a){var r,s,n,i,o,d,u,h,f,c,p,l,g,y,_,m=this,v,b,C;if(a){h=a.groupId||a.batchGroupId;f=a.changeSetId;o=a.context;r=a.success;s=a.error;d=a.eTag;p=a.headers;c=a.urlParameters;y=a.refreshAfterChange;C=a.canonicalRequest;if(a.merge!==undefined){l=a.merge?w.MERGE:w.PUT}}C=this._isCanonicalRequestNeeded(C);_=h in m.mDeferredGroups;y=this._getRefreshAfterChange(y,h);u=k._createUrlParamsArray(c);p=this._getHeaders(p);l=l?l:this.sDefaultUpdateMethod;d=d||this._getETag(e,o,t);v=this._normalizePath(e,o,C);b=this.resolveDeep(e,o);return this._processRequest(function(e){i=m._createRequestUrlWithNormalizedPath(v,u,m.bUseBatch);n=m._createRequest(i,b,l,p,t,d);g=m.mRequests;if(_){g=m.mDeferredRequests}m._pushToRequestQueue(g,h,f,n,r,s,e,y);return n},s,_)};z.prototype.create=function(e,t,a){var r,s,n,i,o,d,u,h,f,c,p,l,g,y,_,m=this,v,b,C;if(a){i=a.context;u=a.urlParameters;o=a.success;d=a.error;p=a.groupId||a.batchGroupId;g=a.changeSetId;f=a.headers;y=a.refreshAfterChange;C=a.canonicalRequest}C=this._isCanonicalRequestNeeded(C);y=this._getRefreshAfterChange(y,p);c=k._createUrlParamsArray(u);f=this._getHeaders(f);l="POST";_=p in m.mDeferredGroups;v=m._normalizePath(e,i,C);b=this.resolveDeep(e,i);return this._processRequest(function(e){s=m._createRequestUrlWithNormalizedPath(v,c,m.bUseBatch);r=m._createRequest(s,b,l,f,t);r.created=true;n=m.oMetadata._getEntityTypeByPath(v);r.entityTypes={};if(n){r.entityTypes[n.entityType]=true}h=m.mRequests;if(_){h=m.mDeferredRequests}m._pushToRequestQueue(h,p,g,r,o,d,e,y);return r},d,_)};z.prototype.remove=function(e,t){var a,r,s,n,i,o,d,u,h,f,c,p,l,g,y,_,m,v,b,C=this.bCanonicalRequests,P=this;if(t){u=t.groupId||t.batchGroupId;a=t.changeSetId;r=t.context;_=t.success;o=t.error;d=t.eTag;h=t.headers;b=t.urlParameters;l=t.refreshAfterChange;C=t.canonicalRequest}C=this._isCanonicalRequestNeeded(C);l=this._getRefreshAfterChange(l,u);v=k._createUrlParamsArray(b);h=this._getHeaders(h);c="DELETE";d=d||this._getETag(e,r);i=u in P.mDeferredGroups;p=this._normalizePath(e,r,C);n=this.resolveDeep(e,r);function R(e,t){P._removeEntity(f);if(s&&s.isTransient()===false){P.oCreatedContextsCache.findAndRemoveContext(s)}if(_){_(e,t)}}return this._processRequest(function(e){m=P._createRequestUrlWithNormalizedPath(p,v,P.bUseBatch);f=m.substr(m.lastIndexOf("/")+1);f=f.split("?")[0];s=P.mContexts["/"+f];g=P._createRequest(m,n,c,h,undefined,d,undefined,true);y=P.mRequests;if(i){y=P.mDeferredRequests}P._pushToRequestQueue(y,u,a,g,R,o,e,l);return g},o,i)};z.prototype.callFunction=function(e,t){var a,r,s,n,i,d,u,h,f,c,p,l,g,y,m=this;if(!e.startsWith("/")){o.fatal("callFunction: sFunctionName has to be absolute, but the given '"+e+"' is not absolute",this,j);return undefined}t=t||{};a=t.changeSetId;s=t.error;n=t.eTag;i=t.expand;d=t.groupId||t.batchGroupId;u=t.headers;h=t.method||"GET";f=t.refreshAfterChange;g=t.success;y=Object.assign({},t.urlParameters);if(i){if(!this.bUseBatch){throw new Error("Use 'expand' parameter only with 'useBatch' set to 'true'")}if(h!=="POST"){throw new Error("Use 'expand' parameter only with HTTP method 'POST'")}}f=this._getRefreshAfterChange(f,d);r=new Promise(function(e,t){l=e;c=t});p=this._processRequest(function(r){var p,v,b,C,P,R,q,M,E,S,A,T={},x=s,U=false,D=g;function I(){P=undefined;C=undefined;U=false}b=m.oMetadata._getFunctionImportMetadata(e,h);if(!b){o.error("Function '"+e+"' not found in the metadata",m,j);c();return undefined}if(b.entitySet||b.entitySetPath){T.$result={__list:[]};if(b.returnType&&!b.returnType.startsWith("Collection")){T.$result={__ref:{}}}}if(i&&(!T.$result||!T.$result.__ref)){c(new Error("Use 'expand' parameter only for functions returning a single"+" entity"));return undefined}if(b.parameter!=null){b.parameter.forEach(function(t){if(y[t.name]!==undefined){T[t.name]=y[t.name];y[t.name]=k.formatValue(y[t.name],t.type)}else{T[t.name]=undefined;o.warning("No value given for parameter '"+t.name+"' of function import '"+e+"'",m,j)}})}E=_();if(i){u=Object.assign({},u,{"Content-ID":E,"sap-messages":"transientOnly"});g=function(e,t){if(!P){P=e;C=t;return}if(D){e=Object.assign({},P,e);D(e,C)}I()};s=function(t){if(P){C.expandAfterFunctionCallFailed=true;t.expandAfterFunctionCallFailed=true;o.error("Function '"+e+"' was called successfully, but"+" expansion of navigation properties ("+i+") failed",t,j);if(D){D(P,C)}I();return}if(!U){U=true;if(x){x(t)}}else{t.expandAfterFunctionCallFailed=true;I()}}}T.__metadata={uri:m.sServiceUrl+e+"('"+E+"')",created:{changeSetId:a,error:s,eTag:n,functionImport:true,groupId:d,headers:Object.assign({},u),key:e.substring(1),method:h,success:g},deepPath:e};R=m._addEntity(T);p=m.getContext("/"+R);m._writePathCache("/"+R,"/"+R);l(p);A=k._createUrlParamsArray(y);S=m._createRequestUrlWithNormalizedPath(e,A,m.bUseBatch);q=m._createRequest(S,e,h,m._getHeaders(u),undefined,n,undefined,true);q.adjustDeepPath=t.adjustDeepPath;q.functionMetadata=b;T.__metadata.created.functionMetadata=b;q.functionTarget=m.oMetadata._getCanonicalPathOfFunctionImport(b,y);q.key=R;if(i){v=m._createRequest("$"+E+"?"+k._encodeURLParameters({$expand:i,$select:i}),"/$"+E,"GET",m._getHeaders(undefined,true),undefined,undefined,undefined,true);v.contentID=E;q.expandRequest=v;q.contentID=E;T.__metadata.created.expandRequest=v;T.__metadata.created.contentID=v.contentID}M=m.mRequests;if(d in m.mDeferredGroups){M=m.mDeferredRequests}m._pushToRequestQueue(M,d,a,q,g,s,r,f);return q},s);p.contextCreated=function(){return r};return p};z.prototype._createFunctionImportParameters=function(e,t,a){var r=f({},a);delete r.__metadata;delete r["$result"];var s=this.oMetadata._getFunctionImportMetadata(e,t);i(s,this+": Function "+e+" not found in the metadata !");if(!s){return undefined}if(s.parameter!=null){c(s.parameter,function(e,t){if(r&&r[t.name]!==undefined){r[t.name]=k.formatValue(r[t.name],t.type)}})}return r};z.prototype._getResourcePath=function(e,t,a,r){var s,n,i,o;if(!e){return this.resolve(a,r)}i=this.oMetadata._splitByLastNavigationProperty(t);n=i.pathBeforeLastNavigationProperty;s=i.lastNavigationProperty;if(s.includes("(")&&i.addressable){o=this.resolve(n+s,undefined,true);if(o){return o+i.pathAfterLastNavigationProperty}}o=this.resolve(n,undefined,true)||n;return o+s+i.pathAfterLastNavigationProperty};z.prototype.read=function(e,t){return this._read(e,t)};z.prototype._read=function(e,t,a,r){var s,n,i,o,d,u,h,f,c,p,l,g,y,_=this;if(t){s=t.canonicalRequest;n=t.context;i=t.error;o=t.filters;d=t.groupId||t.batchGroupId;u=t.headers;c=t.sorters;p=t.success;l=t.updateAggregatedMessages;y=t.urlParameters}s=this._isCanonicalRequestNeeded(s);if(e&&e.indexOf("?")!==-1){e=e.slice(0,e.indexOf("?"))}if(this.sRefreshGroupId){d=this.sRefreshGroupId}g=k._createUrlParamsArray(y);u=this._getHeaders(u,true);h="GET";var m={abort:function(){if(f){f._aborted=true}}};function v(t){var y,m,v,b,C,P,R=_.resolveDeep(e,n),q=_._getResourcePath(s,R,e,n);C=k.createSortParams(c);if(C){g.push(C)}y=_.oMetadata._getEntityTypeByPath(q);m=S.groupFilters(o);v=k.createFilterParams(m,_.oMetadata,y);if(v){g.push(v)}P=_._createRequestUrlWithNormalizedPath(q,g,_.bUseBatch);f=_._createRequest(P,R,h,u,null,undefined,undefined,l,a,r);b=_.mRequests;if(d in _.mDeferredGroups){b=_.mDeferredRequests}_._pushToRequestQueue(b,d,null,f,p,i,t,false);return f}if(this.bUseBatch&&this.bIncludeInCurrentBatch){f=v(m);return m}else{return this._processRequest(v,i)}};z.prototype.requestSideEffects=function(e,t){var a,r=this;t=t||{};for(a in t){if(!W.includes(a)){throw new Error("Parameter '"+a+"' is not supported")}}return new Promise(function(a,s){var n=new Set,i=[],o=t.urlParameters&&t.urlParameters["$expand"];r._read("",{context:e,error:s,groupId:t.groupId,success:function(){a(i)},updateAggregatedMessages:true,urlParameters:t.urlParameters},true);if(o){o.split(",").forEach(function(t){var a=r.oMetadata._getEntityTypeByPath(r.resolve(t,e));n.add(a)});r.getBindings().forEach(function(e){if(e.isA("sap.ui.model.odata.v2.ODataListBinding")){if(e._refreshForSideEffects(n,t.groupId)){i.push(e)}}})}})};z.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata()}return undefined};z.prototype.metadataLoaded=function(e){var t=this.oMetadata.loaded(e);if(this.bLoadAnnotationsJoined){if(e){return Promise.all([t,this.pAnnotationsLoaded])}var a=function(){return t};return this.pAnnotationsLoaded.then(a,a)}else{return t}};z.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded};z.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed()};z.prototype.getServiceAnnotations=function(){var e=this.oAnnotations.getData();return l(e)?null:e};z.prototype.onAnnotationsFailed=function(e){this.fireAnnotationsFailed(e.getParameters())};z.prototype.onAnnotationsLoaded=function(e){this.fireAnnotationsLoaded(e.getParameters())};z.prototype.addAnnotationUrl=function(e){var t=[].concat(e),a=[],r=[],s=[],n=this;t.forEach(function(e){var t=e.indexOf("$metadata");if(t>=0){e=n._createMetadataUrl(e);a.push(e)}else{r.push(e)}});return this.oMetadata._addUrl(a,this._request.bind(this)).then(function(e){return Promise.all(e.map(function(e){s=s.concat(e.entitySets);return n.oAnnotations.addSource({type:"xml",data:e["metadataString"]})}))}).then(function(){return n.oAnnotations.addSource(r)}).then(function(){return{annotations:n.oAnnotations.getData(),entitySets:s}})};z.prototype.addAnnotationXML=function(e,t){return this.oAnnotations.addSource({type:"xml",data:e})};z.prototype.submitChanges=function(e){return this.submitChangesWithChangeHeaders(e&&{batchGroupId:e.batchGroupId,error:e.error,groupId:e.groupId,merge:e.merge,success:e.success})};z.prototype.submitChangesWithChangeHeaders=function(e){var t,a,r,s,n,i,d,u,h=false,f=this.bRefreshAfterChange,p=this;e=e||{};r=e.groupId||e.batchGroupId;u=e.success;a=e.error;if(e.merge!==undefined){s=e.merge?w.MERGE:w.PUT}n=Object.keys(e.changeHeaders||{}).find(function(e){return p._isHeaderPrivate(e)});if(n){throw new Error("Must not use private header: "+n)}this.getBindings().forEach(function(e){if(e._submitChanges){var t=u||function(){},a={groupId:r};e._submitChanges(a);if(a.success){u=function(){t.apply(null,arguments);a.success.apply(null,arguments)}}}});if(r&&!this.mDeferredGroups[r]){o.fatal(this+' submitChanges: "'+r+'" is not a deferred group!')}t=y({},p.mChangedEntities);this.oMetadata.loaded().then(function(){var n,o,l,g,y,_;c(t,function(e,t){var a,n,i,o=p.getContext("/"+e),d=p._resolveGroup(e);if(o.hasTransientParent()||o.isInactive()){return}if(d.groupId===r||!r){n=p._processChange(e,t,d.groupId,s);n.key=e;a=t.__metadata&&t.__metadata.created?t.__metadata.created:{};i={abort:function(){n._aborted=true}};if(d.groupId in p.mDeferredGroups){p._pushToRequestQueue(p.mDeferredRequests,d.groupId,d.changeSetId,n,a.success,a.error,i,a.refreshAfterChange===undefined?f:a.refreshAfterChange)}}});for(y in p.mDeferredRequests){_=p.mDeferredRequests[y];for(l in _.changes){o=_.changes[l];for(g=o.length-1;g>=0;g--){n=o[g];if(n.bRefreshAfterChange===undefined){n.bRefreshAfterChange=f}}}}d=p._processRequestQueue(p.mDeferredRequests,r,u,a,e.changeHeaders);if(h){i.abort()}if(Array.isArray(d)&&d.length==0&&u){u({},undefined)}});i={abort:function(){if(p.pRetryAfter){throw new Error("abort() during HTTP 503 'Retry-after' processing not supported")}if(d){if(Array.isArray(d)){d.forEach(function(e){e.abort()})}else{d.abort()}}else{h=true}}};return i};z.prototype._updateChangedEntity=function(e,t){var a,r,s,n,i,o,d=this;function u(e,t,a){c(t,function(r){var n=a+"/"+r;if(g(t[r])&&g(e[r])){u(e[r],t[r],n);if(l(t[r])){delete t[r]}}else if(a.endsWith("__metadata")||h(t[r],e[r])&&!d.isLaundering(n)){delete t[r];if(a===o){s=d.oMetadata._getEntityTypeByPath(o);i=s&&d.oMetadata._getNavPropertyRefInfo(s,r);if(i&&t[i.name]){e[i.name]=t[i.name];delete t[i.name]}}}})}if(e in d.mChangedEntities){n=d._getObject("/"+e,null,true);a=d._getObject("/"+e);y(n,t);o="/"+e;r=d.removeInternalMetadata(a).deepPath;u(n,a,o);if(l(a)){delete d.mChangedEntities[e];d.abortInternalRequest(d._resolveGroup(e).groupId,{requestKey:e})}else{d.mChangedEntities[e]=a;a.__metadata={deepPath:r};p(a.__metadata,n.__metadata)}}};z.prototype._discardEntityChanges=function(e,t){var a,r,s=this._resolveGroup(e).groupId,n=this.oMetadata.loaded(),i=this;n.then(function(){i.abortInternalRequest(s,{requestKey:e})});if(t){a=this.getContext("/"+e);a.removeFromTransientParent();this.oCreatedContextsCache.findAndRemoveContext(a);r=this.mChangedEntities[e]&&this.mChangedEntities[e].__metadata.created;this._removeEntity(e);if(r&&r.abort){r.abort(z._createAbortedError())}}else{delete this.mChangedEntities[e]}v.removeMessages(this.getMessagesByEntity(e,true));return n};z.prototype.resetChanges=function(e,t,a){return this._resetChanges(e,t,a)};z.prototype.resetChangesWithoutUpdate=function(e,t,a){return this._resetChanges(e,t,a,false)};z.prototype._resetChanges=function(e,t,a,r){var s,n=this.oMetadata.loaded(),i=[],o=this;if(t){n.then(function(){c(o.mDeferredGroups,function(t){if(e){e.forEach(function(e){o.abortInternalRequest(t,{path:e.substring(1)})})}else{o.abortInternalRequest(t)}})})}if(e){c(e,function(e,t){var a,r,s,n,d,u={};if(o.getEntityByPath(t,null,u)){d=u.propertyPath.split("/");n=d[d.length-1];s=u.key;a=o.mChangedEntities[s];if(a){for(r=0;r<d.length-1;r+=1){if(a&&a.hasOwnProperty(d[r])){a=a[d[r]]}else{a=undefined;break}}if(a&&a.hasOwnProperty(n)){delete a[n]}a=o.mChangedEntities[s];if(z._isChangedEntityEmpty(a)||!u.propertyPath){i.push(s)}}}});s=i;i.forEach(function(e){s=s.concat(o.getContext("/"+e).getSubContextsAsKey(true))});new Set(s).forEach(function(e){o._discardEntityChanges(e,o.mChangedEntities[e].__metadata.created&&a)})}else{c(this.mChangedEntities,function(e,t){var r=o.getContext("/"+e).isInactive()?false:t.__metadata.created&&a;o._discardEntityChanges(e,r)})}this.getBindings().forEach(function(t){if(t._resetChanges){t._resetChanges(e)}});this.checkUpdate(r===undefined?true:r);return n};z.prototype.setProperty=function(e,t,a,r){var s,n,i,o,d,u,f,p,y,_,m,v,b,C,P,R,M,E,S,A,T,x,U,D,I,O={},k={},H=false,w=this;function B(e,t){c(t,function(a){if(g(t[a])&&g(e[a])){B(e[a],t[a]);if(l(t[a])){delete t[a]}}else if(h(t[a],e[a])){delete t[a]}})}I=this.resolve(e,a);o=this.resolveDeep(e,a);f=this.getEntityByPath(I,null,k);if(!f){return false}E=I.substring(I.lastIndexOf("/")+1);if(E.startsWith("@$ui5.")){throw new Error("Setting a value for an instance annotation starting with '@$ui5' is "+"not allowed: "+E)}m=k.key;C=this._getObject("/"+m,null,true);P=this._getObject(e,a,true);H=C.__metadata.created&&C.__metadata.created.functionImport;if(!this.mChangedEntities[m]){d=f.__metadata;f={};f.__metadata=Object.assign({},d);if(!H&&k.propertyPath.length>0){var L=o.lastIndexOf(k.propertyPath);f.__metadata.deepPath=o.substring(0,L-1)}this.mChangedEntities[m]=f}n=this.mChangedEntities[m];M=k.propertyPath.split("/");for(var F=0;F<M.length-1;F++){if(!n.hasOwnProperty(M[F])){n[M[F]]={}}n=n[M[F]]}n[E]=q.isPlainObject(t)?q.merge({},t):t;if(a&&a.hasTransientParent&&a.hasTransientParent()){O[m]=true;this.checkUpdate(false,r,O);return true}u=this.oMetadata._getEntityTypeByPath(k.key);b=u&&this.oMetadata._getNavPropertyRefInfo(u,E);_=b&&C[b.name]&&C[b.name].__ref;if(_&&b.keys.length===1&&this.oMetadata._getEntityTypeByPath(b.entitySet).key.propertyRef.length===1){if(t===null){S=null}else{v={};b.keys.forEach(function(e){v[e]=f[e]!==undefined?f[e]:C[e]});v[b.keys[0]]=t;S=this.createKey(b.entitySet,v)}n[b.name]={__ref:S}}D=this.oMetadata.loaded();if(f.__metadata.created&&!H){s=this.oCreatedContextsCache.findCreatedContext(I);if(s&&s.isInactive()){s.startActivation();D=Promise.all([D,s.fetchActivated()])}}if(h(t,P)&&!this.isLaundering("/"+m)&&!H){d=this.mChangedEntities[m].__metadata;i=d&&d.created;delete this.mChangedEntities[m].__metadata;if(!i){B(C,this.mChangedEntities[m])}if(l(this.mChangedEntities[m])){delete this.mChangedEntities[m];O[m]=true;this.checkUpdate(false,r,O);D.then(function(){w.abortInternalRequest(w._resolveGroup(m).groupId,{requestKey:m})});return true}this.mChangedEntities[m].__metadata=d}y=this._resolveGroup(m);p=y.groupId;x=this.mRequests;if(p in this.mDeferredGroups){x=this.mDeferredRequests}T=this._processChange(m,this._getObject("/"+m),p);T.key=m;R=n.__metadata&&n.__metadata.created?n.__metadata.created:{};A=this._getRefreshAfterChange(undefined,p);D.then(function(){U={abort:function(){T._aborted=true}};w._pushToRequestQueue(x,p,y.changeSetId,T,R.success,R.error,U,A);w._processRequestQueueAsync(w.mRequests)});O[m]=true;this.checkUpdate(false,r,O);return true};z.prototype._isHeaderPrivate=function(e){switch(e.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false}};z.prototype.setHeaders=function(e){var t={},a=this;this.mCustomHeaders={};if(e){c(e,function(e,r){if(a._isHeaderPrivate(e)){o.warning(this+" - modifying private header: '"+e+"' not allowed!")}else{t[e]=r}});this.mCustomHeaders=t}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders)}};z.prototype._getHeaders=function(e,t){var a={},r=this;if(e){c(e,function(e,t){if(r._isHeaderPrivate(e)){o.warning(this+" - modifying private header: '"+e+"' not allowed!")}else{a[e]=t}})}return p({"sap-cancel-on-close":String(!!t)},this.mCustomHeaders,a,this.oHeaders)};z.prototype.getHeaders=function(){return p({},this.mCustomHeaders,this.oHeaders)};z.prototype._getHeader=function(e,t){var a;for(a in t){if(a.toLowerCase()===e.toLowerCase()){return t[a]}}return null};z.prototype.hasPendingChanges=function(e){var t,a=Object.keys(this.mChangedEntities);t=this.getBindings().some(function(e){return e._hasPendingChanges&&e._hasPendingChanges(a)});t=t||a.length>0;if(!t&&e){t=this.iPendingDeferredRequests>0}return t};z.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0};z.prototype.getPendingChanges=function(){var e,t=q.merge({},this.mChangedEntities);this.getBindings().forEach(function(e){if(e._getPendingChanges){q.merge(t,e._getPendingChanges())}});for(e in t){if(!t[e]){delete t[e]}}return t};z.prototype.updateBindings=function(e){this.checkUpdate(e)};z.prototype.setTokenHandlingEnabled=function(e){this.bTokenHandling=e};z.prototype.setUseBatch=function(e){this.bUseBatch=e};z.prototype.formatValue=function(e,t){return k.formatValue(e,t)};z.prototype.deleteCreatedEntry=function(e){var t,a,r=this;if(e){a=e.getPath().substr(1);t=this._resolveGroup(a).groupId;r.oMetadata.loaded().then(function(){r.abortInternalRequest(t,{requestKey:a})});r._removeEntity(a);v.removeMessages(this.getMessagesByEntity(e.getPath(),true))}};z.prototype.createEntry=function(e,t){var a,r,s,n,d,u,h,f,c,p,l,g,v,b,C,P,R,q,M,E,S,A,T,x,U,D={},I="POST",O=this;function H(e){P=O._addEntity(y({},D));if(!b){O.mChangedEntities[P]=D}return O.getContext("/"+P,f,d,b,e)}function w(){var t;if(h){t=O.oMetadata._getEntityTypeByPath(s.getPath());if(!O.oMetadata._getNavigationPropertyNames(t).includes(e)){throw new Error("Cannot create entity; path '"+e+"' is not a navigation property of '"+t.name+"'")}if(!C){throw new Error("Cannot create entity; deep create on navigation property '"+e+"' with single cardinality is not supported")}}}function B(){var t,n,b,B,L,F,G,N,$,W,K,z,Q=false,V=p,J=A;a=O._isCanonicalRequestNeeded(a);v=Object.assign({},v);x=k._createUrlParamsArray(U);if(!e.startsWith("/")&&!s){e="/"+e}R=O._normalizePath(e,s,a);f=O.resolveDeep(e,s);C=O.oMetadata._isCollection(f);w();c=O.oMetadata._getEntityTypeByPath(R);if(!c){i(c,"No Metadata for collection "+R+" found");return undefined}D=h?{}:O.getForeignKeysFromReferentialConstraints(R);if(typeof q==="object"&&!Array.isArray(q)){D=y(D,q)}L=c.entityType;B=O.oMetadata._getEntitySetByType(c);z=_();P=B.name+"('"+z+"')";F=O.sServiceUrl+"/"+P;if(C){f=f+"('"+z+"')"}if(h){W=O._getObject(s.getPath());r=W.__metadata.created.changeSetId;g=W.__metadata.created.groupId;D.__metadata={type:L,uri:F,created:{changeSetId:r,groupId:g}};n=H(s);s.addSubContext(e,n,C);return n}if(l){v["Content-ID"]=z;A=function(e,a){if(!t){t=e;b=a;return}if(J){e=Object.assign({},t,e);J(e,b)}u()};p=function(e){if(t){b.expandAfterCreateFailed=true;e.expandAfterCreateFailed=true;o.error("Entity creation was successful but expansion of navigation"+" properties failed",e,j);if(J){J(t,b)}u();return}if(!Q){Q=true;if(V){V(e)}}else{e.expandAfterCreateFailed=true;Q=false}}}else{A=function(e,t){if(J){J(e,t)}u()}}$=O._resolveGroup(R);g=g||$.groupId;r=r||$.changeSetId;M=O._getRefreshAfterChange(M,g);K=O._isTransitionMessagesOnly(g);if(K||l){v["sap-messages"]="transientOnly"}D.__metadata={type:L,uri:F,created:{changeSetId:r,error:p,groupId:g,headers:v,key:R.substring(1),refreshAfterChange:M,success:A,urlParameters:U},deepPath:f};d=new m(function(e,t){u=function(){if(!O.oCreatedContextsCache.getCacheInfo(n)){n.resetCreatedPromise()}if(n.hasSubContexts()){O.resetChanges(n.getSubContextsAsPath(),undefined,true)}e()};D.__metadata.created.abort=t});d.catch(function(){});n=H();T=O._createRequestUrlWithNormalizedPath(R,x,O.bUseBatch);E=O._createRequest(T,f,I,v,D);if(l){G=O._getHeaders(undefined,true);if(K){G["sap-messages"]="transientOnly"}N=O._createRequest("$"+z+"?"+k._encodeURLParameters({$expand:l,$select:l}),"/$"+z,"GET",G,null,undefined,undefined,true);N.contentID=z;E.expandRequest=N;E.contentID=z;D.__metadata.created.expandRequest=N;D.__metadata.created.contentID=z}E.key=P;E.created=true;S=O.mRequests;if(g in O.mDeferredGroups){S=O.mDeferredRequests}O.oMetadata.loaded().then(function(){n.fetchActivated().then(function(){var e={abort:function(){if(E){E._aborted=true;if(E.expandRequest){E.expandRequest._aborted=true}}}};O._pushToRequestQueue(S,g,r,E,A,p,e,M);O._processRequestQueueAsync(O.mRequests)})});return n}if(t){q=t.properties;g=t.groupId||t.batchGroupId;r=t.changeSetId;s=e.startsWith("/")?undefined:t.context;A=t.success;p=t.error;n=t.created;v=t.headers;U=t.urlParameters;M=t.refreshAfterChange;a=t.canonicalRequest;l=t.expand;b=t.inactive}if(l&&!this.bUseBatch){throw new Error("The 'expand' parameter is only supported if batch mode is used")}h=s&&s.isTransient&&s.isTransient();if(h){Object.keys(t).forEach(function(e){if(!N.includes(e)){throw new Error("deep create, unsupported parameter: "+e)}});if(s.isInactive()){throw new Error("deep create, context must not be inactive")}}if(n){this.oMetadata.loaded().then(function(){n(B())})}else if(this.oMetadata.isLoaded()){return B()}else{o.error("Tried to use createEntry without created-callback, before metadata is "+"available!")}return undefined};z.prototype.getForeignKeysFromReferentialConstraints=function(e){const t=this.oMetadata._splitByLastNavigationProperty(e);if(t.lastNavigationProperty){const e=this.oMetadata._getEntityTypeByName(t.pathBeforeLastNavigationProperty);const a=this.oMetadata._getReferentialConstraintsMapping(e,t.lastNavigationProperty.slice(1));const r=this._getObject(t.pathBeforeLastNavigationProperty);if(r){return Object.keys(a).reduce((e,t)=>{if(r[t]){e[a[t]]=r[t]}return e},{})}}return{}};z.prototype._isCreatedEntity=function(e){return!!(e&&e.__metadata&&e.__metadata.created)};z.prototype._normalizePath=function(e,t,a){if(e&&e.indexOf("?")!==-1){e=e.substr(0,e.indexOf("?"))}if(!t&&!e.startsWith("/")){o.fatal(this+" path "+e+" must be absolute if no Context is set")}return this.resolve(e,t,a)||this.resolve(e,t)};z.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange};z.prototype.setRefreshAfterChange=function(e){this.bRefreshAfterChange=e};z.prototype.setRetryAfterHandler=function(e){this.fnRetryAfter=e};z.prototype.isList=function(e,t){e=this.resolve(e,t);return e&&e.substr(e.lastIndexOf("/")).indexOf("(")===-1};z.prototype._isMetadataPath=function(e){var t=false;if(e&&e.indexOf("/#")>-1){t=true}return t};z.prototype.isMetaModelPath=function(e){return e.indexOf("##")==0||e.indexOf("/##")>-1};z.prototype._request=function(e,t,a,r,s,n,i){var o;if(e.fnRequest){const i=e.fnRequest;delete e.fnRequest;return i(e,t,a,r,s,n,true)}if(this.bDestroyed){return{abort:function(){}}}var d=this;function u(e){return function(){if(d.aPendingRequestHandles){var t=d.aPendingRequestHandles.indexOf(o);if(t>-1){d.aPendingRequestHandles.splice(t,1)}}if(!(o&&o.bSuppressErrorHandlerCall)){e.apply(this,arguments)}}}function h(a){return function(u){if(d.checkAndProcessRetryAfterError(e,u,t,a,r,s,n,o,i)){return}a(u)}}if(this.pRetryAfter){o={abort(){}};this.pRetryAfter.then(()=>{o.abort=this._request(e,t,a,r,s,n,i).abort},e=>{this.onRetryAfterRejected(a,undefined,e)})}else{o=B.request(e,u(t||B.defaultSuccess),u(h(a||B.defaultError)),r,s,n);if(!i&&e.async!==false){this.aPendingRequestHandles.push(o)}}return o};z.prototype.destroy=function(){this.bDestroyed=true;A.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var e=this.aPendingRequestHandles.length-1;e>=0;e--){var t=this.aPendingRequestHandles[e];if(t&&t.abort){t.bSuppressErrorHandlerCall=true;t.abort()}}delete this.aPendingRequestHandles}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent)}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent)}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata}delete this.oMetadata;delete this.pMetadataLoaded}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded}if(this.oMessageParser){this.oMessageParser.destroy();delete this.oMessageParser}};z.prototype.setDeferredBatchGroups=function(e){this.setDeferredGroups(e)};z.prototype.setDeferredGroups=function(e){var t=this;this.mDeferredGroups={};c(e,function(e,a){t.mDeferredGroups[a]=a})};z.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups()};z.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups)};z.prototype.setChangeBatchGroups=function(e){c(e,function(e,t){t.groupId=t.batchGroupId});this.setChangeGroups(e)};z.prototype.setChangeGroups=function(e){this.mChangeGroups=e};z.prototype.getChangeBatchGroups=function(){return this.getChangeGroups()};z.prototype.getChangeGroups=function(){return this.mChangeGroups};z.prototype.setMessageParser=function(e){if(!(e instanceof C)){o.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this}e.setProcessor(this);this.oMessageParser=e;return this};z.prototype._parseResponse=function(e,t,a,r){try{if(!this.oMessageParser){this.oMessageParser=new I(this.sServiceUrl,this.oMetadata,!!this.bPersistTechnicalMessages);this.oMessageParser.setProcessor(this)}this.oMessageParser.parse(e,t,a,r,this.bIsMessageScopeSupported)}catch(e){o.error("Error parsing OData messages: "+e)}};z.prototype.callAfterUpdate=function(e){this.aCallAfterUpdate.push(e)};z.prototype.getMetaModel=function(){var e=this;if(!this.oMetaModel){this.oMetaModel=new D(this.oMetadata,this.oAnnotations,this);this.oMetaModel.loaded().then(function(){e.bMetaModelLoaded=true;e.checkUpdate(false,false,null,true)},function(e){var t=e.message,a;if(!t&&e.xmlDoc&&e.xmlDoc.parseError){t=e.xmlDoc.parseError.reason;a=e.xmlDoc.parseError.srcText}o.error("error in ODataMetaModel.loaded(): "+t,a,j)})}return this.oMetaModel};z.prototype.getOriginalProperty=function(e,t){return this._getObject(e,t,true)};z.prototype.getEntityByPath=function(e,t,a){var r,s=A.prototype.resolve.call(this,e,t);if(!s){return null}var n=s.split("/"),i=null,o=[];while(n.length>0){var d=n.join("/"),u=this._getObject(d);if(g(u)){r=this._getKey(u);if(r){i=u;break}}o.unshift(n.pop())}if(i){a.propertyPath=o.join("/");a.key=r;return i}return null};z.prototype.resolveFromCache=function(e){if(!this.mPathCache){return undefined}var t,a="",r,s,n;r=this.mPathCache[e]?this.mPathCache[e].canonicalPath:undefined;if(e&&r!==e){t=r||e;if(!r){n=t.lastIndexOf("/");a=t.substr(n);t=t.substr(0,n)}s=this.resolveFromCache(t);if(s&&s!==t){r=s+a}}return r};z.prototype.resolve=function(e,t,a){var r=A.prototype.resolve.call(this,e,t);if(r&&!this._isMetadataPath(r)&&a){var s=this.resolveFromCache(r);if(!s){s=this.oMetadata._calculateCanonicalPath(r);s=this.resolveFromCache(s)||s}this._writePathCache(r,s);return s}return r};z.prototype.resolveDeep=function(e,t){var a=A.prototype.resolve.call(this,e,t);if(e&&!e.startsWith("/")){a=t?t.sDeepPath+"/"+e:a}if(e===""){a=t?t.sDeepPath:a}return a};z.prototype.isLaundering=function(e,t){var a=this.resolve(e,t);return a in this.mLaunderingState&&this.mLaunderingState[a]>0};z.prototype.increaseLaundering=function(e,t){if(!g(t)){return}for(var a in t){if(a==="__metadata"){continue}var r=t[a];if(g(r)){this.increaseLaundering(e+"/"+a,r)}else{var s=e+"/"+a;if(!(s in this.mLaunderingState)){this.mLaunderingState[s]=0}this.mLaunderingState[s]++}}if(!(e in this.mLaunderingState)){this.mLaunderingState[e]=0}this.mLaunderingState[e]++};z.prototype.decreaseLaundering=function(e,t){if(!g(t)){return}for(var a in t){if(a==="__metadata"){continue}var r=t[a],s=e+"/"+a;if(g(r)){this.decreaseLaundering(s,r)}else if(s in this.mLaunderingState){this.mLaunderingState[s]--;if(this.mLaunderingState[s]===0){delete this.mLaunderingState[s]}}}this.mLaunderingState[e]--;if(this.mLaunderingState[e]===0){delete this.mLaunderingState[e]}};z.prototype._getRefreshAfterChange=function(e,t){if(e===undefined&&!(t in this.mDeferredGroups)){return this.bRefreshAfterChange}return e};z.prototype.getMessagesByEntity=function(e,t){var a=e,r=[],s;function n(e){var a=[];for(var r=0;r<e.length;r++){if(!t||t&&!e[r].persistent){a.push(e[r])}}return a}if(!a.startsWith("/")){a="/"+a}if(this.mMessages){for(s in this.mMessages){if(typeof a=="string"&&a.length>0&&s.startsWith(a)){r=r.concat(n(this.mMessages[s]))}}return r}return null};z.hasContextToken=function(e){const t=e.split("?")[1];return t?!!new URLSearchParams(t).get("sap-context-token"):false};z.isAnnotationsCacheable=function(e){return e.every(e=>z.hasContextToken(e)||K.test(e))};z.prototype._cacheSupported=function(e){const t=this.aAnnotationURIs;return z.hasContextToken(e)&&z.isAnnotationsCacheable(t)};z.prototype._getAnnotationCacheKey=function(e){var t=this.bSkipMetadataAnnotationParsing||this.bIgnoreAnnotationsFromMetadata,a;if(this.bUseCache){if(!t){a=e+"#annotations"}this.aAnnotationURIs=this.aAnnotationURIs.map(function(e){return e+"#annotations"});if(this.aAnnotationURIs.length){a=t?this.aAnnotationURIs.join("_"):a+"_"+this.aAnnotationURIs.join("_")}}return a};z.prototype.canonicalRequestsEnabled=function(){return this.bCanonicalRequests};z.prototype._decreaseDeferredRequestCount=function(e){if(e.deferred){this.iPendingDeferredRequests--}};z.prototype.enableCanonicalRequests=function(e){this.bCanonicalRequests=!!e};z.prototype.getMessageScope=function(){return this.sMessageScope};z.prototype.setMessageScope=function(e){if(e!==x.RequestedObjects&&e!==x.BusinessObject){throw new Error("Unsupported message scope: "+e)}this.sMessageScope=e};z.prototype.messageScopeSupported=function(){var e=this;return this.metadataLoaded().then(function(){return e.bIsMessageScopeSupported})};z.prototype.getContext=function(e,a,r,s,n){var i=this.mContexts[e];if(!i){i=this.mContexts[e]=new t(this,e,a,r,s,n)}else{i.setDeepPath(a||i.getDeepPath()||e)}return i};z.prototype.hasContext=function(e){return this.mContexts[e]};z.prototype.removeInternalMetadata=function(e){var t,a,r,s,n;if(e&&e.__metadata){t=e.__metadata.created;a=e.__metadata.deepPath;r=e.__metadata.invalid;delete e.__metadata.created;delete e.__metadata.deepPath;delete e.__metadata.invalid}for(s in e){n=e[s];if(Array.isArray(n)){n.forEach(z.prototype.removeInternalMetadata)}else if(typeof n==="object"){z.prototype.removeInternalMetadata(n)}}return{created:t,deepPath:a,invalid:r}};z.prototype._isCanonicalRequestNeeded=function(e){if(e!==undefined){return!!e}else{return!!this.bCanonicalRequests}};z.prototype.filterMatchingMessages=function(e,t){var a=this;return this.mMessages[e].filter(function(e){return a.isMessageMatching(e,t)})};z.prototype.isMessageMatching=function(e,t){var a=t.length;return e.aFullTargets.some(function(e){return e===t||e.startsWith(t)&&(t==="/"||e[a]==="/"||e[a]==="(")})};z.prototype.getMessages=function(e){return this.getMessagesByPath(e.sDeepPath,true).sort(b.compare)};z.prototype.getDeepPathForCanonicalPath=function(e){var t,a,n,i,o,d,u,h=e.slice(e.indexOf("("));o=this.aBindings.filter(function(e){return(e instanceof r||e instanceof s)&&e.isResolved()});for(d=0,u=o.length;d<u;d+=1){t=o[d];n=this.resolveDeep(t instanceof s?t.sPath+h:t.sPath,t.oContext);a=this.resolveFromCache(n);if(a===e){if(i&&i!==n){return undefined}i=n}}return i};z.prototype.getPersistTechnicalMessages=function(){return this.bPersistTechnicalMessages};z.prototype.setPersistTechnicalMessages=function(e){e=!!e;if(this.bPersistTechnicalMessages===e){return}if(this.bPersistTechnicalMessages!==undefined){o.warning("The flag whether technical messages should always be treated as persistent"+" has been overwritten to "+e,undefined,j)}this.bPersistTechnicalMessages=e;if(this.oMessageParser){this.oMessageParser._setPersistTechnicalMessages(e)}};z.prototype.createCodeListModelParameters=function(e){e=e||{};return{defaultCountMode:T.None,disableSoftStateHeader:true,headers:e.headers&&Object.assign({},e.headers),json:e.json,metadataUrlParams:e.metadataUrlParams&&Object.assign({},e.metadataUrlParams),persistTechnicalMessages:e.persistTechnicalMessages,serviceUrl:this.sServiceUrl,serviceUrlParams:e.serviceUrlParams&&Object.assign({},e.serviceUrlParams),tokenHandling:false,useBatch:false,warmupUrl:e.warmupUrl}};z.prototype.getCodeListModelParameters=function(){return this.mCodeListModelParams};z.prototype.getMetadataUrl=function(){return this.sMetadataUrl};z._createAbortedError=function(){return{aborted:true,headers:{},message:"Request aborted",responseText:"",statusCode:0,statusText:"abort",$rejected:true}};z.prototype._getCreatedContextsCache=function(){return this.oCreatedContextsCache};z._isChangedEntityEmpty=function(e){return Object.keys(e).every(function(e){return e==="__metadata"})};z.prototype._addSubEntitiesToPayload=function(e,t){var a,r,s,n,i=e.getSubContexts(),o=this;function d(e){var t=q.merge({},o._getObject(e.getPath()));delete t.__metadata;return t}for(r in i){s=i[r];if(Array.isArray(s)){t[r]=[];for(a=0;a<s.length;a+=1){n=d(s[a]);t[r].push(n);this._addSubEntitiesToPayload(s[a],n)}}else{n=d(s);t[r]=n;this._addSubEntitiesToPayload(s,n)}}};z.prototype._isTransitionMessagesOnly=function(e){return this.oTransitionMessagesOnlyGroups.has(e)};z.prototype.setTransitionMessagesOnlyForGroup=function(e,t){var a=t?"add":"delete";this.oTransitionMessagesOnlyGroups[a](e)};z.prototype.setAnnotationChangePromise=function(e){if(this.pAnnotationChanges){throw Error("Promise is set too late; an annotation change promise has already been set or the meta model"+" is already used")}this.pAnnotationChanges=e};z.prototype._requestAnnotationChanges=function(){this.pAnnotationChanges??=m.resolve();return this.pAnnotationChanges};const Q=z.extend;z.extend=function(){o.error("[FUTURE FATAL] sap.ui.model.odata.v2.ODataModel must not be extended");return Q.apply(this,arguments)};return z});
//# sourceMappingURL=ODataModel.js.map