/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataParentBinding","./lib/_AggregationCache","./lib/_AggregationHelper","./lib/_Cache","./lib/_GroupLock","./lib/_Helper","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/core/Messaging","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/OperationMode"],function(e,t,i,n,r,s,o,a,h,d,u,c,f,l,g,p,C,x,v){"use strict";var P="sap.ui.model.odata.v4.ODataListBinding",m={AggregatedDataStateChange:true,change:true,createActivate:true,createCompleted:true,createSent:true,dataReceived:true,dataRequested:true,DataStateChange:true,patchCompleted:true,patchSent:true,refresh:true,selectionChanged:true,separateReceived:true},y=C.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:E});function E(i,n,r,s,a,h){C.call(this,i,n);t.call(this);if(n.endsWith("/")){throw new Error("Invalid path: "+n)}h=o.clone(h)||{};this.checkBindingParameters(h,["$$aggregation","$$canonicalPath","$$clearSelectionOnFilter","$$getKeepAliveContext","$$groupId","$$operationMode","$$ownRequest","$$patchWithoutSideEffects","$$separate","$$sharedRequest","$$updateGroupId"]);const d=o.toArray(a);if(h.$$aggregation&&d[0]===f.NONE){throw new Error("Cannot combine Filter.NONE with $$aggregation")}this.iActiveContexts=0;this.aApplicationFilters=d;this.sChangeReason=i.bAutoExpandSelect&&!o.isDataAggregation(h)?"AddVirtualContext":undefined;this.iCreatedContexts=0;this.iDeletedContexts=0;this.oDiff=undefined;this.aFilters=[];this.sGroupId=h.$$groupId;this.bHasAnalyticalInfo=false;this.oHeaderContext=this.bRelative?null:e.createNewContext(i,this,n);this.sOperationMode=h.$$operationMode||i.sOperationMode;this.mPreviousContextsByPath={};this.aPreviousData=null;this.bRefreshKeptElements=false;this.sResumeAction=undefined;this.bResetViaSideEffects=undefined;this.bSharedRequest="$$sharedRequest"in h?h.$$sharedRequest:i.bSharedRequests;this.aSorters=o.toArray(s);this.sUpdateGroupId=h.$$updateGroupId;if(!this.sOperationMode&&(this.aSorters.length||this.aApplicationFilters.length)){throw new Error("Unsupported operation mode: "+this.sOperationMode)}this.applyParameters(h);if(!this.bRelative||r&&!r.fetchValue){this.createReadGroupLock(this.getGroupId(),true)}this.setContext(r);i.bindingCreated(this)}t(y.prototype);y.prototype._checkDataStateMessages=function(e,t){if(t){e.setModelMessages(this.oModel.getMessagesByPath(t,true))}};y.prototype._getAllExistingContexts=function(e){let t=this.aContexts??[];if(e){t=t.slice(this.iCreatedContexts)}return t.filter(function(e){return e}).concat(Object.values(this.mPreviousContextsByPath).filter(function(t){const i=t.isEffectivelyKeptAlive();return e?i&&!t.isOutOfPlace():i}))};y.prototype.adjustPredicate=function(e,i,n){var r=this;function s(e,t){var i=r.aPreviousData?.indexOf(e);if(i>=0){r.aPreviousData[i]=t}}if(n){n.adjustPredicate(e,i,s)}else{t.prototype.adjustPredicate.apply(this,arguments);if(this.mCacheQueryOptions&&!this.oContext.getPath().includes("($uid=")){this.fetchCache(this.oContext,true)}this.oHeaderContext.adjustPredicate(e,i);this.aContexts.forEach(function(t){t.adjustPredicate(e,i,s)})}};y.prototype.applyParameters=function(e,t,i){var r,s=this.mParameters&&this.mParameters.$$aggregation,o=this.mQueryOptions&&this.mQueryOptions.$apply;if("$$getKeepAliveContext"in e&&"$apply"in e){throw new Error("Cannot combine $$getKeepAliveContext and $apply")}if("$$aggregation"in e){if("$apply"in e){throw new Error("Cannot combine $$aggregation and $apply")}if(!t){n.validateAggregationAndSetPath(e.$$aggregation,this.oModel.bAutoExpandSelect,this.oModel.oInterface.fetchMetadata,this.getResolvedPath())}r=n.buildApply(e.$$aggregation).$apply}const a=this.mParameters?.$$clearSelectionOnFilter&&(i?.includes("$filter")||i?.includes("$search")||e.$$aggregation?.search!==this.mParameters.$$aggregation?.search);this.mQueryOptions=this.oModel.buildQueryOptions(e,true);this.oQueryOptionsPromise=undefined;this.mParameters=e;if(r){this.mQueryOptions.$apply=r}if(t===""){if(this.mQueryOptions.$apply===o&&(!this.mParameters.$$aggregation||!s||this.isUnchangedParameter("$$aggregation",s))){return}t=this.bHasAnalyticalInfo?c.Change:c.Filter}if(i){this.setResetViaSideEffects(i.every(e=>e==="$orderby"||e==="$filter"))}if(this.isRootBindingSuspended()){this.setResumeChangeReason(t);return}if(a){this.oHeaderContext?.setSelected(false)}this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(t);this.oHeaderContext?.checkUpdate()};y.prototype.attachCreateActivate=function(e,t){return this.attachEvent("createActivate",e,t)};y.prototype.attachCreateCompleted=function(e,t){return this.attachEvent("createCompleted",e,t)};y.prototype.attachCreateSent=function(e,t){return this.attachEvent("createSent",e,t)};y.prototype.attachEvent=function(e,t,i,n){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataListBinding#attachEvent")}return C.prototype.attachEvent.apply(this,arguments)};y.prototype.attachSelectionChanged=function(e,t){return this.attachEvent("selectionChanged",e,t)};y.prototype.attachSeparateReceived=function(e,t){return this.attachEvent("separateReceived",e,t)};y.prototype.checkDeepCreate=function(){if(!this.oModel.bAutoExpandSelect){throw new Error("Deep create is only supported with autoExpandSelect")}if(y.isBelowAggregation(this.oContext)){throw new Error("Deep create is not supported with data aggregation")}if(!this.oContext.isTransient()){throw new Error("Unexpected ODataContextBinding in deep create")}if(this.sPath.includes("/")){throw new Error("Invalid path '"+this.sPath+"' in deep create")}};y.prototype.checkKeepAlive=function(e,t){if(this.isRelative()&&!this.mParameters.$$ownRequest){throw new Error("Missing $$ownRequest at "+this)}if(e===this.oHeaderContext){throw new Error("Unsupported header context "+e)}if(o.isDataAggregation(this.mParameters)){throw new Error("Unsupported $$aggregation at "+this)}if(this.bSharedRequest){throw new Error("Unsupported $$sharedRequest at "+this)}if(!t&&e&&e.getIndex()===undefined&&e.isKeepAlive()&&!e.isDeleted()&&e.hasPendingChanges()){throw new Error("Not allowed due to pending changes: "+e)}};y.prototype.collapse=function(e,t,i,n){this.checkSuspended();if(this.aContexts[e.iIndex]!==e){throw new Error("Not currently part of the hierarchy: "+e)}if(t&&!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}n??=this.oCache.collapse(o.getRelativePath(e.getPath(),this.oHeaderContext.getPath()),t?this.lockGroup():undefined,i);if(n>0){const t=this.aContexts;const r=e.getModelIndex();t.splice(r+1,n).forEach(e=>{if(!e.created()){this.mPreviousContextsByPath[e.getPath()]=e}});for(let e=r+1;e<t.length;e+=1){if(t[e]){t[e].iIndex=e}}this.iMaxLength-=n;if(!i){this._fireChange({reason:c.Change})}}};y.prototype.create=function(t,i,n,r){var s=this.mParameters.$$aggregation,a,d,u=s?.createInPlace,f=this.fetchResourcePath(),l,g,p=this.getUpdateGroupId(),C,x=this.getResolvedPath(),v="($uid="+o.uid()+")",m=x+v,y=this;if(!x){throw new Error("Binding is unresolved: "+this)}this.checkSuspended();if(o.isDataAggregation(this.mParameters)){throw new Error("Cannot create in "+this+" when using data aggregation")}if(this.isTransient()){this.checkDeepCreate();if(r){throw new Error("Must not create an inactive context in a deep create: "+this)}}n=!!n;if(n&&!(this.bLengthFinal||this.mParameters.$count)){throw new Error("Must know the final length to create at the end. Consider setting $count")}if(this.bFirstCreateAtEnd&&!n){throw new Error("Cannot create at the start after creation at end")}if(r){if(this.isRelative()&&!this.mParameters.$$ownRequest){throw new Error("Missing $$ownRequest at "+this)}p="$inactive."+p}else if(!s){this.iActiveContexts+=1}if(this.bFirstCreateAtEnd===undefined){this.bFirstCreateAtEnd=n}g=o.publicClone(t,true)||{};let E;if(s){if(!i){throw new Error("Missing bSkipRefresh")}if(arguments.length>2){throw new Error("Only the parameters oInitialData and bSkipRefresh are supported")}const e=t?.["@$ui5.node.parent"];if(e){a=this.aContexts.indexOf(e)+1;if(a<=0){throw new Error("Invalid parent context: "+e)}if(e.isExpanded()===false){throw new Error("Unsupported collapsed parent: "+e)}g["@$ui5.node.parent"]=e.getCanonicalPath().slice(1);E=this.oCache.isRefreshNeededAfterCreate(e.iIndex)}else{a=0}}else{this.iCreatedContexts+=1}C=this.lockGroup(p,true,true,function(){if(!y.aContexts.includes(d)){y.mPreviousContextsByPath[d.getPath()]=d;y.destroyPreviousContextsLater([d.getPath()]);return}d.doSetSelected(false,true);y.removeCreated(d);return Promise.resolve().then(function(){y._fireChange({reason:c.Remove})})});l=this.createInCache(C,f,x,v,g,this.bFirstCreateAtEnd!==n,function(e){y.oModel.reportError("POST on '"+f+"' failed; will be repeated automatically",P,e);y.fireEvent("createCompleted",{context:d,success:false})},function(){y.fireEvent("createSent",{context:d})}).then(function(e){var t,n,r;r=o.getPrivateAnnotation(e,"predicate");if(r){y.adjustPredicate(v,r,d);y.oModel.checkMessages()}y.fireEvent("createCompleted",{context:d,success:true});if(u){const t=o.getPrivateAnnotation(e,"rank");d.iIndex=t;if(t===undefined||E){d.destroy();return}d.setPersisted(true);y.insertContext(d,t)}t=o.getPrivateAnnotation(e,"deepCreate");o.deletePrivateAnnotation(e,"deepCreate");n=y.getGroupId();if(y.oModel.isApiGroup(n)){n="$auto"}return i||t?d.updateAfterCreate(i,n):y.refreshSingle(d,y.lockGroup(n))},function(e){C.unlock(true);throw e});if(E){l=h.all([l,this.requestSideEffects(p,[""])])}const $=u?undefined:a??-this.iCreatedContexts;d=e.create(this.oModel,this,m,$,l,r);d.doSetSelected(this.oHeaderContext.isSelected());if(this.isTransient()){d.created().catch(this.oModel.getReporter())}if(u){return d}d.fetchValue().then(function(e){if(e){o.setPrivateAnnotation(e,"context",d);o.setPrivateAnnotation(e,"firstCreateAtEnd",y.bFirstCreateAtEnd)}});this.insertContext(d,a,n);return d};y.prototype.createContexts=function(t,i,n){var r=false,s,a,h=i.$count,d,u=this.bLengthFinal,c=this.oModel,f=this.getResolvedPath(),l,g=t>this.aContexts.length,p=this;function C(){var e=p.iMaxLength+p.iCreatedContexts;if(e>=p.aContexts.length){return}for(let t=e;t<p.aContexts.length;t+=1){if(p.aContexts[t]){p.aContexts[t].destroy()}}while(e>0&&!p.aContexts[e-1]){e-=1}p.aContexts.length=e;r=true}for(let n=0;n<i.length;n+=1){if(this.aContexts[t+n]===undefined&&i[n]){r=true;d=t+n-this.iCreatedContexts;l=o.getPrivateAnnotation(i[n],"predicate");a=f+(l||"/"+d);s=this.mPreviousContextsByPath[a];if(s&&(!s.created()||s.isEffectivelyKeptAlive()||this.mParameters.$$aggregation?.hierarchyQualifier)){delete this.mPreviousContextsByPath[a];s.iIndex=d;s.checkUpdate()}else if(o.hasPrivateAnnotation(i[n],"context")){s=o.getPrivateAnnotation(i[n],"context");s.iIndex=d;a=s.getPath();if(this.mPreviousContextsByPath[a]===s){delete this.mPreviousContextsByPath[a]}}else{s=e.create(c,this,a,d);s.doSetSelected(this.oHeaderContext.isSelected())}this.aContexts[t+n]=s}}if(n){return r}this.destroyPreviousContextsLater(Object.keys(this.mPreviousContextsByPath));if(h!==undefined){this.bLengthFinal=true;this.iMaxLength=h-this.iActiveContexts;C()}else{if(!i.length){this.iMaxLength=t-this.iCreatedContexts;C()}else if(this.aContexts.length>this.iMaxLength+this.iCreatedContexts){this.iMaxLength=Infinity}if(!(g&&i.length===0)){this.bLengthFinal=this.aContexts.length===this.iMaxLength+this.iCreatedContexts}}if(this.bLengthFinal!==u){r=true}return r};y.prototype.createContextsForCachedData=function(e,t){if(this.bFirstCreateAtEnd){e+=this.iCreatedContexts}this.withCache((i,n)=>{const r=i.getElements(n,e,e+t);if(r){this.createContexts(e,r,true)}},"",true)};y.prototype.delete=function(t,i,n,r,s,a){var h=false,d=this;if(n.isDeleted()){return n.oDeletePromise}const u=n.isExpanded();if(u){this.collapse(n,false,true)}const f=n.iIndex<0;const l=n.iIndex===undefined?o.getRelativePath(n.getPath(),this.oHeaderContext.getPath()):String(n.getModelIndex());this.iDeletedContexts+=1;return n.doDelete(t,i,l,r,this,function(e,i){if(e!==undefined){if(i>0){delete d.mPreviousContextsByPath[n.getPath()];d.aContexts.splice(e,0,n);a()}else{d.mPreviousContextsByPath[n.getPath()]=n;d.aContexts.splice(e,1);n.iIndex=undefined;Promise.resolve().then(function(){d._fireChange({reason:c.Remove})})}if(f){d.iCreatedContexts+=i;d.iActiveContexts+=i}else{d.iMaxLength+=i}d.aContexts.forEach(function(e,t){e.iIndex=t-d.iCreatedContexts})}else if(i>0){h=true;a()}else if(d.bLengthFinal&&!s){d.oCache.requestCount(t&&!d.oModel.isApiGroup(t.getGroupId())?t.getUnlockedCopy():d.lockGroup("$auto")).then(function(e){var t=d.iMaxLength;d.iMaxLength=e-d.iActiveContexts;if(t!==d.iMaxLength){d._fireChange({reason:c.Remove})}})}}).then(function(){d.iDeletedContexts-=1;if(!d.iDeletedContexts&&!d.iCreatedContexts){d.bFirstCreateAtEnd=undefined}n.resetKeepAlive();n.iIndex=e.VIRTUAL;d.destroyPreviousContextsLater([n.getPath()])},function(e){d.iDeletedContexts-=1;a();if(h){d.oCache.reset(d.getKeepAlivePredicates());d.reset(c.Change)}else{if(u){d.expand(n,1,true).unwrap()}d._fireChange({reason:c.Add})}throw e})};y.prototype.destroy=function(){if(this.bHasAnalyticalInfo&&this.aContexts===undefined){return}this.aContexts.forEach(function(e){e.destroy()});this.destroyPreviousContexts();if(this.oHeaderContext){this.oHeaderContext.destroy()}this.oModel.bindingDestroyed(this);this.aApplicationFilters=undefined;this.aContexts=undefined;this.oDiff=undefined;this.aFilters=undefined;this.oHeaderContext=undefined;this.mParameters=undefined;this.mPreviousContextsByPath=undefined;this.aPreviousData=undefined;this.mQueryOptions=undefined;this.oQueryOptionsPromise=undefined;this.aSorters=undefined;t.prototype.destroy.call(this);C.prototype.destroy.call(this)};y.prototype.destroyLater=function(e){if(this.iCurrentEnd){this.mPreviousContextsByPath[e.getPath()]=e}else{e.destroy()}};y.prototype.destroyPreviousContexts=function(e){var t=this.mPreviousContextsByPath,i=this;if(t){(e||Object.keys(t)).forEach(function(n){var r=t[n];if(r){if(e&&(r.isEffectivelyKeptAlive()||r.isOutOfPlace()||r.oDeletePromise?.isPending())){r.iIndex=undefined}else{if(!r.isTransient()){r.destroy();if(r.iIndex===undefined&&i.oCache){i.oCache.removeKeptElement(o.getRelativePath(n,i.oHeaderContext.getPath()))}}delete t[n]}}})}};y.prototype.destroyPreviousContextsLater=function(e){if(e.length){this.oModel.addPrerenderingTask(this.destroyPreviousContexts.bind(this,e))}};y.prototype.detachCreateActivate=function(e,t){return this.detachEvent("createActivate",e,t)};y.prototype.detachCreateCompleted=function(e,t){return this.detachEvent("createCompleted",e,t)};y.prototype.detachCreateSent=function(e,t){return this.detachEvent("createSent",e,t)};y.prototype.detachSelectionChanged=function(e,t){return this.detachEvent("selectionChanged",e,t)};y.prototype.detachSeparateReceived=function(e,t){return this.detachEvent("separateReceived",e,t)};y.prototype.doCreateCache=function(e,t,n,r,s,o,a){var h,d,u,c=this.bResetViaSideEffects;this.bResetViaSideEffects=undefined;if(a&&a.getResourcePath()===e&&a.$deepResourcePath===r){d=this.getKeepAlivePredicates();if(this.iCreatedContexts||this.iDeletedContexts||d.length||this.mParameters.$$aggregation?.hierarchyQualifier&&a instanceof i){if(c&&this.mParameters.$$aggregation?.hierarchyQualifier){s=this.getGroupId();o=true;a.resetOutOfPlace()}a.reset(d,o?s:undefined,t,this.mParameters.$$aggregation,this.isGrouped());this.validateSelection(a,s);return a}}t=this.inheritQueryOptions(t,n);h=this.getCacheAndMoveKeepAliveContexts(e,t);if(h&&this.mParameters.$$aggregation){u={};d=this.getKeepAlivePredicates();d.forEach(function(e){u[e]=h.getValue(e)});h.setActive(false);h=undefined}h??=i.create(this.oModel.oRequestor,e,r,t,this.mParameters.$$aggregation,this.oModel.bAutoExpandSelect||"$$separate"in this.mParameters,this.bSharedRequest,this.isGrouped());h.setSeparate?.(this.mParameters.$$separate);if(u){d.forEach(function(e){h.addKeptElement(u[e])})}else if(this.bSharedRequest){h.registerChangeListener("",this)}return h};y.prototype.doFetchOrGetQueryOptions=function(e){var t=e&&o.getMetaPath(e.getPath()),i=this;if(!(this.oQueryOptionsPromise&&this.oQueryOptionsPromise.$metaPath===t)){this.oQueryOptionsPromise=this.fetchResolvedQueryOptions(e).then(function(t){return i.fetchFilter(e,t.$filter).then(function(e){return o.mergeQueryOptions(t,i.getOrderby(t.$orderby),e)})});this.oQueryOptionsPromise.$metaPath=t}return this.oQueryOptionsPromise};y.prototype.doReplaceWith=function(t,i,n){var r=t.getModelIndex(),s,o=t.fnOnBeforeDestroy,a,h=this.oHeaderContext.getPath()+n,d=this.mPreviousContextsByPath[h];if(d){if(d===t){return d}if(d.iIndex!==undefined){throw new Error("Unexpected index: "+d)}d.iIndex=t.iIndex;delete this.mPreviousContextsByPath[h]}else{d=e.create(this.oModel,this,h,t.iIndex);s=true}if(r===undefined){this.mPreviousContextsByPath[h]=d;this.oCache.addKeptElement(i)}else{t.iIndex=undefined;this.aContexts[r]=d;this.oCache.doReplaceWith(r,i)}if(t.isKeepAlive()){this.mPreviousContextsByPath[t.getPath()]=t;if(s){if(o){a=(o.$original||o).bind(null,d);a.$original=o}d.setKeepAlive(true,a)}}else{this.destroyLater(t)}this._fireChange({reason:c.Change});return d};y.prototype.doSetProperty=function(){};y.prototype.expand=function(e,t,i){this.checkSuspended();if(this.aContexts[e.iIndex]!==e){throw new Error("Not currently part of the hierarchy: "+e)}if(t>1&&!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}let n=false;const r=o.getRelativePath(e.getPath(),this.oHeaderContext.getPath());return this.oCache.expand(this.lockGroup(),r,t,()=>{n=true;this.fireDataRequested()}).then(t=>{if(t<0){return this.requestSideEffects(this.getGroupId(),[""])}if(t){this.insertGap(e.getModelIndex(),t);if(!i){this._fireChange({reason:c.Change})}}if(n){this.fireDataReceived({})}},e=>{if(n){this.fireDataReceived({error:e})}throw e})};y.prototype.fetchContexts=function(e,t,i,n,r,s){var o,a=this;if(this.bFirstCreateAtEnd){e+=this.iCreatedContexts}if(!n){n=this.oReadGroupLock||this.lockGroup();this.oReadGroupLock=undefined}o=this.fetchData(e,t,i,n,s);if(r){o=Promise.resolve(o)}return o.then(function(t){var i;if(!a.aContexts){i=new Error("Binding already destroyed");i.canceled=true;throw i}if(t){t.$checkStillValid?.();return a.createContexts(e,t.value)}},function(e){n.unlock(true);throw e})};y.prototype.fetchData=function(e,t,i,n,r){var s=this.oContext,o=this;return this.oCachePromise.then(function(a){var h;if(o.bRelative&&s!==o.oContext){return undefined}if(a){if(!a.hasSentRequest()&&o.isRelative()&&y.isBelowCreated(s)){h=s.getAndRemoveCollection(o.sPath);if(h){a.setPersistedCollection(h)}}return a.read(e,t,i,n,r,undefined,o.fireSeparateReceived.bind(o)).then(function(e){e.$checkStillValid=o.checkSameCache.bind(o,a);return e})}n.unlock();return s.fetchValue(o.sReducedPath).then(function(i){var n;i??=[];n=i.$count;i=i.slice(e,e+t);i.$count=n;return{value:i}})})};y.prototype.fetchDownloadUrl=function(){var e=this.oModel.mUriParameters;this.checkTransient();if(!this.isResolved()){throw new Error("Binding is unresolved")}if(this.hasFilterNone()){return h.resolve(null)}const t=o.getMetaPath(this.getResolvedPath());const i={};for(const e in this.mChildPathsReducedToParent){const n=o.wrapChildQueryOptions(t,e,{},this.oModel.oInterface.fetchMetadata,true);o.aggregateExpandSelect(i,n)}return this.withCache(function(t,n){return t.getDownloadUrl(n,e,i)})};y.prototype.fetchFilter=function(e,t){let i;const r=this.oModel.getMetaModel();const s=r.getMetaContext(this.oModel.resolve(this.sPath,e));function a(e,t,n,r){var s,a,h,d;function u(e){return h?"tolower("+e+")":e}h=t==="Edm.String"&&e.isCaseSensitive()===false;a=r&&!i?.includes(e)?u(`$these/aggregate(${e.getPath()})`):u(decodeURIComponent(e.getPath()));d=u(o.formatLiteral(e.getValue1(),t));switch(e.getOperator()){case l.BT:s=a+" ge "+d+" and "+a+" le "+u(o.formatLiteral(e.getValue2(),t));break;case l.NB:s=c(a+" lt "+d+" or "+a+" gt "+u(o.formatLiteral(e.getValue2(),t)),n);break;case l.EQ:case l.GE:case l.GT:case l.LE:case l.LT:case l.NE:s=a+" "+e.getOperator().toLowerCase()+" "+d;break;case l.Contains:case l.EndsWith:case l.NotContains:case l.NotEndsWith:case l.NotStartsWith:case l.StartsWith:s=e.getOperator().toLowerCase().replace("not","not ")+"("+a+","+d+")";break;default:throw new Error("Unsupported operator: "+e.getOperator())}return s}function d(e,t,i,n){var o;if(!e){return h.resolve()}if(e.getFilters()){return h.all(e.getFilters().map(function(i){return d(i,t,e.isAnd(),n)})).then(function(t){return c(t.join(e.isAnd()?" and ":" or "),i&&!e.isAnd())})}o=r.resolve(u(e.getPath(),t),s);return r.fetchObject(o).then(function(r){var s,h,c;if(!r){throw new Error("Type cannot be determined, no metadata for path: "+o)}c=e.getOperator();if(c===l.All||c===l.Any){s=e.getCondition();h=e.getVariable();if(c===l.Any&&!s){return e.getPath()+"/any()"}t=Object.create(t);t[h]=u(e.getPath(),t);return d(s,t).then(function(t){return e.getPath()+"/"+e.getOperator().toLowerCase()+"("+h+":"+t+")"})}return a(e,r.$Type,i,n)})}function u(e,t){var i=e.split("/");i[0]=t[i[0]];return i[0]?i.join("/"):e}function c(e,t){return t?"("+e+")":e}const p=g.combineFilters(this.aFilters,this.aApplicationFilters);const C=o.isDataAggregation(this.mParameters)?r.fetchObject(s.getPath()+"/"):h.resolve();return C.then(e=>{const r=this.mParameters.$$aggregation;if(e){r.$leafLevelAggregated=!e.$Key?.every(e=>e in r.group||Object.keys(r.group).some(t=>r.group[t].additionally?.includes(e)))}if(!p){return[t]}if(p===f.NONE){return["false"]}const s=n.splitFilter(p,r);i=s[3];return h.all([d(s[0],{},t).then(e=>e&&t?e+" and ("+t+")":e||t),d(s[1],{}),d(s[2],{},undefined,true)])})};y.prototype.fetchOrGetParent=function(e,t){if(!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(this.aContexts[e.iIndex]!==e){throw new Error("Not currently part of a recursive hierarchy: "+e)}const i=this.oCache.getParentIndex(e.iIndex);if(i<0){return null}const n=e=>this.requestContexts(e,1).then(e=>e[0]);if(t){if(i===undefined){return this.oCache.fetchParentIndex(e.iIndex,this.lockGroup()).then(n)}return n(i)}return this.aContexts[i]};y.prototype.fetchOrGetSibling=function(e,t=+1,i=false){if(!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(t!==-1&&t!==+1){throw new Error("Unsupported offset: "+t)}if(e.isDeleted()||e.isTransient()||this.aContexts[e.iIndex]!==e){throw new Error("Unsupported context: "+e)}this.checkSuspended();let n;if(e.created()){if(t<0){return null}const r=e.getParent();if(r?.created()){return null}let s;let o;[n,s,o]=this.oCache.get1stInPlaceChildIndex(r?r.iIndex:-1);if(s){return i?this.requestContexts(n,1).then(e=>e[0]).then(e=>e.getProperty("@$ui5.node.level")===o?e:null):undefined}}else{n=this.oCache.getSiblingIndex(e.iIndex,t)}if(n<0){return null}if(n!==undefined){this.fetchContexts(n,1,0,s.$cached);return this.aContexts[n]}if(!i){return undefined}return this.oCache.requestSiblingIndex(e.iIndex,t,this.lockGroup()).then(e=>e<0?null:this.requestContexts(e,1).then(e=>e[0]))};y.prototype.fetchValue=function(e,t,i){var n=i&&this.oCache!==undefined?h.resolve(this.oCache):this.oCachePromise,r=this;return n.then(function(n){var o,a;if(n){o=i?s.$cached:r.lockGroup();a=r.getRelativePath(e);if(a!==undefined){return n.fetchValue(o,a,undefined,t)}}if(r.oContext){return r.oContext.fetchValue(e,t,i)}})};y.prototype.filter=function(e,t){var i=o.toArray(e);this.checkTransient();f.checkFilterNone(i);if(i[0]===f.NONE&&this.mParameters.$$aggregation){throw new Error("Cannot combine Filter.NONE with $$aggregation")}if(this.sOperationMode!==v.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server")}if(t===p.Control?o.deepEqual(i,this.aFilters):o.deepEqual(i,this.aApplicationFilters)){return this}if(this.hasPendingChanges(true)){throw new Error("Cannot filter due to pending changes")}if(t===p.Control){this.aFilters=i}else{this.aApplicationFilters=i}this.oQueryOptionsPromise=undefined;this.setResetViaSideEffects(true);if(this.isRootBindingSuspended()){this.setResumeChangeReason(c.Filter);return this}if(this.mParameters.$$clearSelectionOnFilter){this.oHeaderContext?.setSelected(false)}this.createReadGroupLock(this.getGroupId(),true);this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(c.Filter);this.oHeaderContext?.checkUpdate();return this};y.prototype.findContextForCanonicalPath=function(e){var t=Object.values(this.mPreviousContextsByPath).filter(function(e){return e.isEffectivelyKeptAlive()});function i(t){return t.find(function(t){var i;if(t){i=t.fetchCanonicalPath();i.caught();return i.getResult()===e}})}return i(t)||i(this.aContexts)};y.prototype.fireCreateActivate=function(e){if(this.fireEvent("createActivate",{context:e},true)){this.iActiveContexts+=1;return true}return false};y.prototype.fireSelectionChanged=function(e){this.fireEvent("selectionChanged",{context:e})};y.prototype.fireSeparateReceived=function(e,t,i,n){const r={property:e,start:t,length:i-t};if(n){r.errorMessage=this.oModel.reportTransitionMessages(o.extractMessages(n),n.resourcePath,true)[0]}const s=this.fireEvent("separateReceived",r,true);if(n&&s){d.updateMessages(undefined,[r.errorMessage])}};y.prototype.getAggregation=function(e){return o.clone(this.mParameters.$$aggregation,function(t,i){return t[0]==="$"&&!(e&&["$DistanceFromRoot","$DrillState","$NodeProperty"].includes(t))?undefined:i})};y.prototype.getAllCurrentContexts=function(){var e;this.withCache(function(t,i){e=t.getElements(i)},"",true);if(e&&this.createContexts(0,e,true)){this._fireChange({reason:c.Change})}return this._getAllExistingContexts()};y.prototype.getCacheAndMoveKeepAliveContexts=function(e,t){var i,n,r=this;if(!this.mParameters.$$getKeepAliveContext){return undefined}i=this.oModel.releaseKeepAliveBinding("/"+e);if(!i){return undefined}Object.keys(i.mParameters).concat(Object.keys(this.mParameters)).forEach(function(e){if((e[0]!=="$"||e==="$$patchWithoutSideEffects"||e==="$$updateGroupId")&&r.mParameters[e]!==i.mParameters[e]){throw new Error(r+": parameter does not match getKeepAliveContext: "+e)}});this.mLateQueryOptions=o.clone(t);o.aggregateExpandSelect(this.mLateQueryOptions,i.mLateQueryOptions);this.mPreviousContextsByPath=i.mPreviousContextsByPath;Object.values(this.mPreviousContextsByPath).forEach(function(e){e.oBinding=r});n=i.oCache;n.setQueryOptions(t);i.oCache=null;i.oCachePromise=h.resolve(null);i.mPreviousContextsByPath={};i.destroy();return n};y.prototype.getContexts=function(t=0,i,n,r){var s,o,h=false,d,u,f,l=!!this.sChangeReason,g=this.getResolvedPath(),p,C=this;a.debug(this+"#getContexts("+t+", "+i+", "+n+")",undefined,P);this.checkSuspended();if(t!==0&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" iStart must be 0 if extended change detection is enabled, but is "+t)}if(this.bUseExtendedChangeDetection){if(n!==undefined){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" iMaximumPrefetchSize must not be set if extended change detection is"+" enabled")}if(r){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" must not use bKeepCurrent if extended change detection is enabled")}}if(n&&r){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" must not use both iMaximumPrefetchSize and bKeepCurrent")}if(!this.isResolved()){this.aPreviousData=null;return[]}s=this.sChangeReason||c.Change;this.sChangeReason=undefined;if(s==="AddVirtualContext"){this.oModel.addPrerenderingTask(function(){var e=C.bUseExtendedChangeDetection;if(C.aContexts&&!C.isRootBindingSuspended()){C.bUseExtendedChangeDetection=false;C.getContexts(t,i,n);C.bUseExtendedChangeDetection=e}C.oModel.addPrerenderingTask(function(){if(!C.isRootBindingSuspended()){C.sChangeReason="RemoveVirtualContext";C._fireChange({detailedReason:"RemoveVirtualContext",reason:c.Change});C.reset(c.Refresh)}})},true);p=e.create(this.oModel,this,g+"/"+e.VIRTUAL,e.VIRTUAL);C.mPreviousContextsByPath[p.getPath()]=p;return[p]}if(s==="RemoveVirtualContext"||this.oContext&&this.oContext.iIndex===e.VIRTUAL){return[]}i||=this.oModel.iSizeLimit;if(!n||n<0){n=0}if(!this.oDiff){u=this.isRefreshWithoutBubbling();f=this.fetchContexts(t,i,n,undefined,l,function(){if(d===undefined){d=true;C.fireDataRequested(u)}});if(!l&&f.isPending()){this.createContextsForCachedData(t,i)}this.resolveRefreshPromise(f).then(function(e){if(C.bUseExtendedChangeDetection){C.oDiff={aDiff:C.getDiff(i),iLength:i}}if(h){if(e||C.oDiff&&C.oDiff.aDiff?.length){C._fireChange({reason:s})}else{C.oDiff=undefined}}if(d){C.fireDataReceived({data:{}},u)}d=false},function(e){if(d){C.fireDataReceived(e.canceled?{data:{}}:{error:e},u)}throw e}).catch(function(e){C.oModel.reportError("Failed to get contexts for "+C.oModel.sServiceUrl+g.slice(1)+" with start index "+t+" and length "+i,P,e)});h=true}if(!r){this.iCurrentBegin=t;this.iCurrentEnd=t+i}o=this.getContextsInViewOrder(t,i);o.bExpectMore=this._isExpectingMoreContexts(o,t,i);if(this.bUseExtendedChangeDetection){if(this.oDiff&&i!==this.oDiff.iLength){throw new Error("Extended change detection protocol violation: Expected "+"getContexts(0,"+this.oDiff.iLength+"), but got getContexts(0,"+i+")")}o.dataRequested=!this.oDiff;o.diff=this.oDiff?this.oDiff.aDiff:[]}this.oDiff=undefined;return o};y.prototype.getContextsInViewOrder=function(e,t){var i,n,r;if(this.bFirstCreateAtEnd){i=[];n=Math.min(t,this.getLength()-e);for(r=0;r<n;r+=1){i[r]=this.aContexts[this.getModelIndex(e+r)]}}else{i=this.aContexts.slice(e,e+t)}return i};y.prototype.getCount=function(){return this.getHeaderContext()?.getProperty("$count")};y.prototype.getCurrentContexts=function(){var e,t=Math.min(this.iCurrentEnd,this.iMaxLength+this.iCreatedContexts)-this.iCurrentBegin;e=this.getContextsInViewOrder(this.iCurrentBegin,t);if(t<Infinity){while(e.length<t){e.push(undefined)}}return e};y.prototype.getDependentBindings=function(){var e=this;return this.oModel.getDependentBindings(this).filter(function(t){return t.oContext.isEffectivelyKeptAlive()||!(t.oContext.getPath()in e.mPreviousContextsByPath)})};y.prototype.getDiff=function(e){var t=this.aPreviousData,i=this;this.aPreviousData=this.getContextsInViewOrder(0,e).map(function(e){return i.getContextData(e)});return t?this.diffData(t,this.aPreviousData):null};y.prototype.getDistinctValues=function(e){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues")};y.prototype.getDownloadUrl=o.createGetMethod("fetchDownloadUrl",true);y.prototype.getEntryData=function(e){return o.publicClone(e.getValue(),false,true)};y.prototype.getEntryKey=function(e){return e.getPath()};y.prototype.getFilterInfo=function(e){var t=g.combineFilters(this.aFilters,this.aApplicationFilters),i=null,n;if(t){i=t.getAST(e)}if(this.mQueryOptions.$filter){n={expression:this.mQueryOptions.$filter,syntax:"OData "+this.oModel.getODataVersion(),type:"Custom"};if(i){i={left:i,op:"&&",right:n,type:"Logical"}}else{i=n}}return i};y.prototype.getGeneration=function(){return this.oHeaderContext.getGeneration(true)||t.prototype.getGeneration.call(this)};y.prototype.getHeaderContext=function(){return this.isResolved()?this.oHeaderContext:null};y.prototype.getKeepAliveContext=function(t,i,n){var r=this.mPreviousContextsByPath[t]||this.aContexts.find(function(e){return e&&e.getPath()===t}),s=o.getPredicateIndex(t),a=this.getResolvedPath();this.checkKeepAlive();this.checkSuspended();this.checkTransient();o.checkGroupId(n);if(!r){if(!a){throw new Error("Binding is unresolved: "+this)}if(t.slice(0,s)!==a){throw new Error(this+": Not a valid context path: "+t)}r=e.create(this.oModel,this,t);this.mPreviousContextsByPath[t]=r;this.oCachePromise.then(function(e){var i={};o.setPrivateAnnotation(i,"predicate",t.slice(s));e.addKeptElement(i);if(n){o.setPrivateAnnotation(i,"groupId",n)}});this.oModel.getMetaModel().requestObject(o.getMetaPath(a)+"/").then(function(e){return r.requestProperty(e.$Key.map(function(e){return typeof e==="object"?Object.values(e)[0]:e}))}).catch(this.oModel.getReporter())}r.setKeepAlive(true,r.fnOnBeforeDestroy,i);return r};y.prototype.getKeepAlivePredicates=function(){var e;if(!this.getHeaderContext()){return[]}e=this.getHeaderContext().getPath();return Object.values(this.mPreviousContextsByPath).concat(this.aContexts).filter(function(e){return e.isEffectivelyKeptAlive()}).map(function(t){return o.getRelativePath(t.getPath(),e)})};y.prototype.getLength=function(){if(this.bLengthFinal){return this.iMaxLength+this.iCreatedContexts}return this.aContexts.length?this.aContexts.length+10:0};y.prototype.getModelIndex=function(e){if(!this.bFirstCreateAtEnd){return e}if(!this.bLengthFinal){return this.aContexts.length-e-1}return e<this.getLength()-this.iCreatedContexts?e+this.iCreatedContexts:this.getLength()-e-1};y.prototype.getOrderby=function(e){var t=[],i=this;this.aSorters.forEach(function(e){if(e instanceof x){t.push(e.getPath()+(e.isDescending()?" desc":""))}else{throw new Error("Unsupported sorter: "+e+" - "+i)}});if(e){t.push(e)}return t.join(",")};y.prototype.getQueryOptions=function(e){var t={},i=this;if(e){throw new Error("Unsupported parameter value: bWithSystemQueryOptions: "+e)}Object.keys(this.mQueryOptions).forEach(function(e){if(e[0]!=="$"){t[e]=o.clone(i.mQueryOptions[e])}});return t};y.prototype.getQueryOptionsFromParameters=function(){return this.mQueryOptions};y.prototype.getSelectionCount=function(){return this.getHeaderContext()?.getProperty("$selectionCount")};y.prototype.hasFilterNone=function(){return this.aFilters[0]===f.NONE||this.aApplicationFilters[0]===f.NONE};y.prototype.hasPendingChangesForPath=function(e,i){if(this.oCache===undefined){return!i&&this.iActiveContexts>0}return t.prototype.hasPendingChangesForPath.apply(this,arguments)};y.prototype.inheritQueryOptions=function(e,t){var i;if(o.isEmptyObject(this.mParameters)){i=this.getQueryOptionsForPath("",t);if(e.$orderby&&i.$orderby){e.$orderby+=","+i.$orderby}if(e.$filter&&i.$filter){e.$filter="("+e.$filter+") and ("+i.$filter+")"}e=o.merge({},i,e);o.aggregateExpandSelect(e,i)}return e};y.prototype.initialize=function(){if(this.isResolved()){this.checkDataState();if(this.isRootBindingSuspended()){this.sResumeChangeReason=this.sChangeReason==="AddVirtualContext"?c.Change:c.Refresh}else if(this.sChangeReason==="AddVirtualContext"){this._fireChange({detailedReason:"AddVirtualContext",reason:c.Change})}else{this.sChangeReason=c.Refresh;this._fireRefresh({reason:c.Refresh})}}};y.prototype.insertContext=function(e,t,i){if(t!==undefined){o.insert(this.aContexts,t,e);for(let e=this.aContexts.length-1;e>t;e-=1){if(this.aContexts[e]){this.aContexts[e].iIndex+=1}}this.iMaxLength+=1}else if(this.bFirstCreateAtEnd!==i){this.aContexts.splice(this.iCreatedContexts-1,0,e);for(let e=this.iCreatedContexts-1;e>=0;e-=1){this.aContexts[e].iIndex=e-this.iCreatedContexts}}else{this.aContexts.unshift(e)}this._fireChange({reason:c.Add})};y.prototype.insertGap=function(e,t){const i=this.aContexts;if(e>=i.length){throw new Error("Array index out of bounds: "+e)}else if(e===i.length-1){i.length+=t}else{for(let n=i.length-1;n>e;n-=1){const e=i[n];if(e){e.iIndex+=t;i[n+t]=e;delete i[n]}}}this.iMaxLength+=t};y.prototype.isAncestorOf=function(e,t){if(!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(!t){return false}[e,t].forEach(e=>{if(this.aContexts[e.iIndex]!==e){throw new Error("Not currently part of a recursive hierarchy: "+e)}});return this.oCache.isAncestorOf(e.iIndex,t.iIndex)};y.prototype.isFirstCreateAtEnd=function(){return this.bFirstCreateAtEnd};y.prototype.isKeepAliveBindingFor=function(e){return this.mParameters.$$getKeepAliveContext&&this.getResolvedPath()===e&&(!this.isRootBindingSuspended()||this.aContexts.length||!o.isEmptyObject(this.mPreviousContextsByPath))};y.prototype.isLengthFinal=function(){return this.bLengthFinal};y.prototype.isUnchangedParameter=function(e,i){if(e==="$$aggregation"){i=o.clone(i);n.buildApply(i);return o.deepEqual(o.cloneNo$(this.mParameters.$$aggregation),o.cloneNo$(i))}return t.prototype.isUnchangedParameter.apply(this,arguments)};y.prototype.keepOnlyVisibleContexts=function(){const e=this.aContexts.slice(0,this.iCreatedContexts);const t=e.concat(this.getCurrentContexts().filter(t=>t&&!e.includes(t)));Object.keys(this.mPreviousContextsByPath).forEach(e=>{var i=this.mPreviousContextsByPath[e];if(i.isEffectivelyKeptAlive()){t.push(i)}});let i=0;function n(e,n,r){if(n.created()){t.push(n);i=e+r+1}else{delete this.aContexts[e+r];this.destroyLater(n)}}this.aContexts.slice(this.iCreatedContexts,this.iCurrentBegin).forEach(n.bind(this,this.iCreatedContexts));if(this.aContexts.length>this.iCurrentEnd&&this.iCurrentEnd>=this.iCreatedContexts){this.aContexts.slice(this.iCurrentEnd).forEach(n.bind(this,this.iCurrentEnd));this.aContexts.length=Math.max(i,this.iCurrentEnd)}return t.filter(e=>!e.getProperty("@$ui5.context.isTransient"))};y.prototype.move=function(e,t,i,n){const r=(e,t)=>{if(e>t){[e,t]=[t,e]}for(let i=e;i<=t;i+=1){if(this.aContexts[i]){this.aContexts[i].iIndex=i}}};if(!this.mParameters.$$aggregation?.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}this.checkSuspended();const s=this.getUpdateGroupId();const a=this.lockGroup(s,true,true);const d=e.getCanonicalPath().slice(1);const u=t===null?null:t.getCanonicalPath().slice(1);const f=i===null?null:i?.getCanonicalPath().slice(1);const l=i===undefined?undefined:e.getPath().slice(1);const g=i?.isEffectivelyKeptAlive();const{promise:p,refresh:C}=this.oCache.move(a,d,u,f,l,g,n);if(C){return h.all([p,this.requestSideEffects(s,[""])]).then(([t])=>{const[r,s,o]=t();e.iIndex=r;if(g){i.iIndex=s}if(n){return o}})}return p.then(([i,n,s])=>{if(i>1){this.insertGap(t.getModelIndex(),i-1)}if(s){this.collapse(e,false,true,s)}const a=e.getModelIndex();this.aContexts.splice(a,1);o.insert(this.aContexts,n,e);r(a,n);if(s){this.expand(e,1).unwrap()}else{this._fireChange({reason:c.Change})}})};y.prototype.onChange=function(){var e,t=this;if(!this.oRefreshPromise){if(this.isRootBindingSuspended()){this.sResumeAction="onChange"}else{e=this.getDependentBindings();this.reset(c.Refresh);h.all(e.map(function(e){return e.refreshInternal("")})).then(function(){return t.oHeaderContext.checkUpdateInternal()}).catch(this.oModel.getReporter())}}};y.prototype.onKeepAliveChanged=function(e){if(!e.isDeleted()&&e.getPath()in this.mPreviousContextsByPath&&!e.isEffectivelyKeptAlive()){this.destroyPreviousContextsLater([e.getPath()])}};y.prototype.prepareDeepCreate=function(t,i){var n=this;if(!t){return!i}if(t.iIndex===e.VIRTUAL){return true}if(!t.getPath().includes("($uid=")){return!i}this.mCacheQueryOptions=i;if(!this.oModel.bAutoExpandSelect||y.isBelowAggregation(t)){return true}t.withCache(function(t,r){var s=t.addTransientCollection(r,i&&i.$select),a=n.getResolvedPath();n.aContexts=s.map(function(t,i){var r,h=o.getPrivateAnnotation(t,"transientPredicate"),d=o.getPrivateAnnotation(t,"promise");r=e.create(n.oModel,n,a+h,i-s.length,d,false,true);r.created().catch(n.oModel.getReporter());o.setPrivateAnnotation(t,"context",r);o.setPrivateAnnotation(t,"firstCreateAtEnd",false);o.deletePrivateAnnotation(t,"promise");return r});n.iCreatedContexts=n.iActiveContexts=n.aContexts.length;n.bFirstCreateAtEnd=false},this.sPath);return true};y.prototype.refreshInternal=function(e,t,i,n){var r=this;function s(i){return i.map(function(i){if(i.bIsBeingDestroyed||i.getContext().isEffectivelyKeptAlive()&&i.hasPendingChanges()){return}return i.refreshInternal(e,t,false,n)})}if(this.isRootBindingSuspended()){if(this.bSharedRequest){this.sResumeAction="resetCache"}else{this.refreshSuspended(t);this.bRefreshKeptElements=true}return h.all(s(r.getDependentBindings()))}this.createReadGroupLock(t,this.isRoot());return this.oCachePromise.then(function(i){var o=r.iActiveContexts,a=r.iCreatedContexts,d=r.aContexts.slice(0,a),u,f,l=r.oRefreshPromise;if(i&&!l){r.removeCachesAndMessages(e);if(r.bSharedRequest){l=r.createRefreshPromise();i.reset([])}else{r.fetchCache(r.oContext,false,true,t,n);f=r.refreshKeptElements(t,n);if(r.iCurrentEnd>0){l=r.createRefreshPromise(n).catch(function(e){if(!n||e.canceled){throw e}return r.fetchResourcePath(r.oContext).then(function(t){var n;if(!r.bRelative||i.getResourcePath()===t){if(r.oCache===i){i.restore(true)}else{i.setActive(true);r.oCache=i;r.oCachePromise=h.resolve(i)}r.iActiveContexts=o;r.iCreatedContexts=a;for(n=0;n<a;n+=1){d[n].iIndex=n-a;delete r.mPreviousContextsByPath[d[n].getPath()]}r.aContexts=d;r._fireChange({reason:c.Change})}throw e})}).finally(function(){if(i.restore){i.restore(false)}})}}}u=r.getDependentBindings();r.reset(c.Refresh,!i||(n?false:undefined),t);return h.all(s(u).concat(l,f)).then(function(){return r.oHeaderContext?.checkUpdateInternal()})})};y.prototype.refreshKeptElements=function(e,t){var i=this;return this.oCachePromise.then(function(n){return n.refreshKeptElements(i.lockGroup(e),function e(t,n){var r=n>=0?i.aContexts[n]:i.mPreviousContextsByPath[i.getResolvedPath()+t];r.resetKeepAlive();if(n>=0){i.removeCreated(r)}},t)}).catch(function(e){i.oModel.reportError("Failed to refresh kept-alive elements",P,e);throw e})};y.prototype.refreshSingle=function(e,t,i,n,r){var s=e.getPath(),a=s.slice(1),d=this;if(e===this.oHeaderContext){throw new Error("Unsupported header context: "+e)}if(i&&r){throw new Error("Unsupported: bAllowRemoval && bWithMessages")}return this.withCache(function(u,f,l){var g=false,p=false,C=e.getModelIndex(),x=o.getRelativePath(s,d.oHeaderContext.getPath()),v=[];function m(e){if(g){d.fireDataReceived(e)}}function y(){if(!n){g=true;d.fireDataRequested()}}function E(t){var i=e.getModelIndex(),n;if(e.iIndex<0){if(t){d.mPreviousContextsByPath[s]=e}else{e.resetKeepAlive();p=true}d.removeCreated(e)}else{if(i===undefined){delete d.mPreviousContextsByPath[s]}else{d.aContexts.splice(i,1);d.iMaxLength-=1;for(n=i;n<d.aContexts.length;n+=1){if(d.aContexts[n]){d.aContexts[n].iIndex-=1}}if(t){d.mPreviousContextsByPath[s]=e}}if(!t){p=true;e.doSetSelected(false,true);e.destroy()}}if(i!==undefined){d._fireChange({reason:c.Remove})}}if(C<0){throw new Error("Cannot refresh. Hint: Side-effects refresh in parallel? "+e)}v.push((i?u.refreshSingleWithRemove(t,f,C,x,e.isEffectivelyKeptAlive(),y,E):u.refreshSingle(t,f,C,x,e.isKeepAlive(),r,y)).then(function(){var r=[];m({data:{}});l.checkSameCache(u);if(!p){r.push(e.checkUpdateInternal());if(i){r.push(e.refreshDependentBindings(a,t.getGroupId(),false,n))}}return h.all(r)},function(e){m({error:e});throw e}).catch(function(i){t.unlock(true);d.oModel.reportError("Failed to refresh entity: "+e,P,i);if(!i.canceled){throw i}}));if(!i){v.push(e.refreshDependentBindings(a,t.getGroupId(),false,n))}return h.all(v)})};y.prototype.removeCreated=function(e){var t,i;if(this.mParameters.$$aggregation){this.iMaxLength-=1;t=this.aContexts.indexOf(e);for(i=this.aContexts.length-1;i>t;i-=1){if(this.aContexts[i]){this.aContexts[i].iIndex-=1}}}else{t=e.getModelIndex();this.iCreatedContexts-=1;if(!this.iCreatedContexts){this.bFirstCreateAtEnd=undefined}if(!e.isInactive()){this.iActiveContexts-=1}for(i=0;i<t;i+=1){this.aContexts[i].iIndex+=1}}this.aContexts.splice(t,1);e.iIndex=undefined;if(!e.isEffectivelyKeptAlive()){this.destroyLater(e)}};y.prototype.requestContexts=function(e=0,t,i){var n=this;if(!this.isResolved()){throw new Error("Unresolved binding: "+this.sPath)}this.checkSuspended();o.checkGroupId(i);t||=this.oModel.iSizeLimit;const r=i&&this.lockGroup(i,true);return Promise.resolve(this.fetchContexts(e,t,0,r)).then(function(i){if(i){n._fireChange({reason:c.Change})}return n.getContextsInViewOrder(e,t)},function(i){n.oModel.reportError("Failed to get contexts for "+n.oModel.sServiceUrl+n.getResolvedPath().slice(1)+" with start index "+e+" and length "+t,P,i);throw i})};y.prototype.requestDownloadUrl=o.createRequestMethod("fetchDownloadUrl");y.prototype.requestFilterForMessages=function(e){var t=this.oModel.getMetaModel(),i,n=this.oHeaderContext&&this.oHeaderContext.getPath(),r=this;this.checkTransient();if(!n){return Promise.resolve(null)}i=o.getMetaPath(n);return t.requestObject(i+"/").then(function(s){var a,h={},d=false;r.oModel.getMessagesByPath(n,true).filter(function(t){return!e||e(t)}).forEach(function(e){e.getTargets().forEach(function(e){var t=e.slice(n.length).split("/")[0];if(t){if(t.startsWith("($uid=")){d=true}else{h[t]=true}}})});a=Object.keys(h).map(function(e){return o.getFilterForPredicate(e,s,t,i)});if(a.length===0){return d?f.NONE:null}return a.length===1?a[0]:new f({filters:a})})};y.prototype.requestSelectedContexts=function(e){if(this.bSharedRequest){throw new Error("Unsupported $$sharedRequest at "+this)}if("$$aggregation"in this.mParameters){throw new Error("Unsupported $$aggregation at "+this)}this.checkSuspended();this.checkTransient();if(this.oHeaderContext.isSelected()){throw new Error('Unsupported "Select All": '+this.oHeaderContext)}if(this.hasPendingChanges()){throw new Error("Unsupported pending changes")}o.checkGroupId(e);const t={};const i=this.getResolvedPath().length;const n=this._getAllExistingContexts().filter(e=>e.isSelected()).map(e=>{t[e.getPath()]=e;return e.getPath().slice(i)});if(!n.length){return Promise.resolve([])}return this.oCache.requestFilteredOrderedPredicates(n,this.lockGroup(e)).then(e=>e.map(e=>t[this.oHeaderContext.getPath()+e]))};y.prototype.requestSideEffects=function(e,t,i){var r=this.oModel,s,a,d=i&&i!==this.oHeaderContext,u=this;function c(e){return e.catch(function(e){r.reportError("Failed to request side effects",P,e);if(!e.canceled){throw e}})}if(o.isDataAggregation(this.mParameters)){if(d){throw new Error("Must not request side effects when using data aggregation")}if(n.isAffected(this.mParameters.$$aggregation,this.aFilters.concat(this.aApplicationFilters),t)){return this.refreshInternal("",e,false,true)}return h.resolve()}if(!d&&this.oCache&&this.oCache.isDeletingInOtherGroup(e)){throw new Error("Must not request side effects when there is a pending delete in a"+" different batch group")}if(this.oCache&&this.oCache.getPendingRequestsPromise()){return h.resolve(this.oCache.getPendingRequestsPromise()).then(function(){return u.requestSideEffects(e,t,i)})}if(t.indexOf("")<0){s=o.getPredicates(d?[i]:this.keepOnlyVisibleContexts());if(s){a=this.oCache?[this.oCache.requestSideEffects(this.lockGroup(e),t,s,d,d)]:[];this.visitSideEffects(e,t,d?i:undefined,a);return h.all(a.map(c)).then(function(){return u.refreshDependentListBindingsWithoutCache()})}}if(d){r.withUnresolvedBindings("removeCachesAndMessages",i.getPath().slice(1));return this.refreshSingle(i,this.lockGroup(e),false,true,true)}if(this.iCurrentEnd===0){return h.resolve()}return this.refreshInternal("",e,false,true)};y.prototype.reset=function(e,t,i){var n=0,r=this.iCurrentEnd===0,s=i&&i!==this.getUpdateGroupId(),o,a=this;if(t===true){this.iActiveContexts=0;this.iCreatedContexts=0}if(this.aContexts){this.aContexts.slice(this.iCreatedContexts).forEach(function(e){a.mPreviousContextsByPath[e.getPath()]=e});for(o=0;o<this.iCreatedContexts;o+=1){const e=this.aContexts[o];if(t===false?s&&e.isTransient()||e.isInactive()!==undefined:e.isTransient()){this.aContexts[n]=e;n+=1}else{this.iActiveContexts-=1;this.mPreviousContextsByPath[e.getPath()]=e}}for(o=0;o<n;o+=1){this.aContexts[o].iIndex=o-n}this.aContexts.length=this.iCreatedContexts=n}else{this.aContexts=[]}if(!this.iCreatedContexts){this.bFirstCreateAtEnd=undefined}this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;if(e&&!(r&&e===c.Change)&&this.isResolved()){this.sChangeReason=e;this._fireRefresh({reason:e})}};y.prototype.resetKeepAlive=function(){var e=this.mPreviousContextsByPath;Object.keys(e).forEach(function(t){e[t].resetKeepAlive()});this.aContexts.forEach(function(e){e.resetKeepAlive()})};y.prototype.restoreCreated=function(){var e=this;this.withCache(function(t,i){if(e.aContexts.length){return}t.getCreatedElements(i).forEach(function(t,i){e.aContexts[i]=o.getPrivateAnnotation(t,"context");e.bFirstCreateAtEnd=o.getPrivateAnnotation(t,"firstCreateAtEnd");e.iCreatedContexts+=1;if(!t["@$ui5.context.isInactive"]){e.iActiveContexts+=1}})}).catch(this.oModel.getReporter())};y.prototype.resumeInternal=function(e,t){var i=this.sResumeAction,n=this.sResumeChangeReason,r=t||i||n;this.sResumeAction=undefined;this.sResumeChangeReason=undefined;if(r){if(this.mParameters.$$clearSelectionOnFilter&&n===c.Filter){this.oHeaderContext?.setSelected(false)}this.removeCachesAndMessages("");if(i==="onChange"){this.onChange();return}if(i==="resetCache"){this.oCache.reset([]);return}this.reset();this.fetchCache(this.oContext,!t);if(this.bRefreshKeptElements){this.bRefreshKeptElements=false;this.refreshKeptElements(this.getGroupId())}}this.getDependentBindings().forEach(function(e){e.resumeInternal(!r,!!n&&!e.oContext.isEffectivelyKeptAlive())});if(this.sChangeReason==="AddVirtualContext"){this._fireChange({detailedReason:"AddVirtualContext",reason:n})}else if(n){this._fireRefresh({reason:n})}else{this.removeReadGroupLock()}this.oHeaderContext.checkUpdate()};y.prototype.setAggregation=function(e){var t;function i(e){return e&&!!e.hierarchyQualifier}this.checkTransient();if(this.hasFilterNone()){throw new Error("Cannot combine Filter.NONE with $$aggregation")}if(this.hasPendingChanges()){throw new Error("Cannot set $$aggregation due to pending changes")}if(i(this.mParameters.$$aggregation)!==i(e)&&this.getKeepAlivePredicates().length){throw new Error("Cannot set $$aggregation due to a kept-alive context")}t=Object.assign({},this.mParameters);if(e===undefined){delete t.$$aggregation}else{t.$$aggregation=o.clone(e)}this.applyParameters(t,"")};y.prototype.setContext=function(t){var i;if(this.oContext!==t){if(this.bRelative){this.checkSuspended(true);this.reset(undefined,true);this.resetKeepAlive();this.fetchCache(t);if(t){this.restoreCreated();i=this.oModel.resolve(this.sPath,t);if(this.oHeaderContext&&this.oHeaderContext.getPath()!==i){this.oHeaderContext.doSetSelected(false);this.mPreviousContextsByPath[this.oHeaderContext.getPath()]=this.oHeaderContext;this.oHeaderContext=null}this.oHeaderContext??=e.create(this.oModel,this,i);if(this.mParameters.$$aggregation){n.setPath(this.mParameters.$$aggregation,i)}else if(!o.isEmptyObject(this.mChildPathsReducedToParent)&&this.oModel.bAutoExpandSelect){this.mCanUseCachePromiseByChildPath={};this.sChangeReason="AddVirtualContext"}if(t.getBinding&&t.getBinding().isRootBindingSuspended()){this.oContext=t;this.setResumeChangeReason(c.Context);return}}u.prototype.setContext.call(this,t,{detailedReason:this.sChangeReason})}else{this.oContext=t}}};y.prototype.setResetViaSideEffects=function(e){if(!e){this.bResetViaSideEffects=false}else if(this.bResetViaSideEffects===undefined){this.bResetViaSideEffects=true}};y.prototype.sort=function(e){var t=o.toArray(e);this.checkTransient();if(this.sOperationMode!==v.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server")}if(o.deepEqual(t,this.aSorters)){return this}if(this.hasPendingChanges(true)){throw new Error("Cannot sort due to pending changes")}this.aSorters=t;this.oQueryOptionsPromise=undefined;this.setResetViaSideEffects(true);if(this.isRootBindingSuspended()){this.setResumeChangeReason(c.Sort);return this}this.createReadGroupLock(this.getGroupId(),true);this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(c.Sort);if(this.oHeaderContext){this.oHeaderContext.checkUpdate()}return this};y.prototype.updateAfterCreate=function(e,i){var n,r,a=this;if(this.iCreatedContexts){if(e){this.reset(c.Change,true)}else{this.reset(undefined,true);r=this.fetchContexts(0,Infinity,0,s.$cached).then(function(){a.iCurrentEnd=a.aContexts.length;return a.requestSideEffects(i,o.getMissingPropertyPaths(a.fetchValue("",null,true).getResult(),a.mAggregatedQueryOptions))}).then(function(){a._fireChange({reason:c.Change})})}n=h.all([r,t.prototype.updateAfterCreate.apply(this,arguments)])}else{n=this.refreshInternal("",i)}return n};y.prototype.updateAnalyticalInfo=function(e){var t={aggregate:{},group:{},search:this.mParameters.$$aggregation&&this.mParameters.$$aggregation.search},i=false,n=this;e.forEach(function(e){var n={};if("total"in e){if("grouped"in e){throw new Error("Both dimension and measure: "+e.name)}if(e.as){n.name=e.name;t.aggregate[e.as]=n}else{t.aggregate[e.name]=n}if(e.min){n.min=true;i=true}if(e.max){n.max=true;i=true}if(e.with){n.with=e.with}}else if(!("grouped"in e)||e.inResult||e.visible){t.group[e.name]=n}});this.bHasAnalyticalInfo=true;this.setAggregation(t);if(i){return{measureRangePromise:Promise.resolve(this.getRootBindingResumePromise().then(function(){return n.oCachePromise}).then(function(e){return e.getMeasureRangePromise()}))}}};y.prototype.validateSelection=function(e,t){if(!this.mParameters.$$clearSelectionOnFilter||o.isDataAggregation(this.mParameters)||this.oHeaderContext.isSelected()){return}const i=this._getAllExistingContexts(true).filter(e=>e.isSelected());if(!i.length){return}const n=this.getResolvedPath().length;const r=i.map(e=>e.getPath().slice(n));e.requestFilteredOrderedPredicates(r,this.lockGroup(t),true).then(e=>{const t=new Set(e);i.forEach(e=>{if(!t.has(e.getPath().slice(n))){e.setSelected(false)}})},e=>{this.oModel.reportError("Failed to validate selection",P,e)})};y.isBelowAggregation=function(e){return!!e?.getBinding?.().getAggregation?.()};y.isBelowCreated=function(e){var t;if(!(e&&e.getBinding)){return false}if(e.isTransient()===false){return true}t=e.getBinding();return t&&t.isRelative()&&y.isBelowCreated(t.getContext())};return y});
//# sourceMappingURL=ODataListBinding.js.map