/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataBinding","./lib/_Helper","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/ChangeReason"],function(e,t,n,i,r,o){"use strict";function s(){t.call(this);this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.mCanUseCachePromiseByChildPath={};this.aChildCanUseCachePromises=[];this.mChildPathsReducedToParent={};this.iPatchCounter=0;this.bPatchSuccess=true;this.oReadGroupLock=undefined;this.oRefreshPromise=null;this.oResumePromise=undefined}t(s.prototype);var a="sap.ui.model.odata.v4.ODataParentBinding";s.prototype._findEmptyPathParentContext=function(e){if(this.sPath===""&&this.oContext.getBinding){return this.oContext.getBinding()._findEmptyPathParentContext(this.oContext)}return e};s.prototype._resume=function(e){var t=this;function n(){t.bSuspended=false;if(t.oResumePromise){t.resumeInternal(true);t.oResumePromise.$resolve();t.oResumePromise=undefined}}if(this.oOperation){throw new Error("Cannot resume an operation binding: "+this)}if(!this.isRoot()){throw new Error("Cannot resume a relative binding: "+this)}if(!this.bSuspended){throw new Error("Cannot resume a not suspended binding: "+this)}if(e){this.createReadGroupLock(this.getGroupId(),true,1);this.oModel.addPrerenderingTask(n)}else{this.createReadGroupLock(this.getGroupId(),true);n()}};s.prototype.aggregateQueryOptions=function(e,t,i,r){var o=n.clone(i&&this.mLateQueryOptions||this.mAggregatedQueryOptions),s=this;function a(e,t,n,o,h){function u(r){var o=!e.$expand[r],h=n+"/"+r;if(o){e.$expand[r]={};if(i&&s.oModel.getMetaModel().fetchObject(h).getResult().$isCollection){return false}}return a(e.$expand[r],t.$expand[r],h,true,o)}function c(t){if(!e.$select.includes(t)){e.$select.push(t)}return true}return(r||!o||Object.keys(e).every(function(e){return e in t||e==="$count"||e==="$expand"||e==="$select"}))&&Object.keys(t).every(function(n){switch(n){case"$count":if(t.$count){e.$count=true}return true;case"$expand":e.$expand??={};return Object.keys(t.$expand).every(u);case"$select":e.$select??=[];return t.$select.every(c);default:if(h){e[n]=t[n];return true}return t[n]===e[n]}})}if(a(o,e,t)){if(i){this.mLateQueryOptions=o}else{this.mAggregatedQueryOptions=o;if(this.mLateQueryOptions){a(this.mLateQueryOptions,e)}}return true}return false};s.prototype.attachPatchCompleted=function(e,t){return this.attachEvent("patchCompleted",e,t)};s.prototype.attachPatchSent=function(e,t){return this.attachEvent("patchSent",e,t)};s.prototype.changeParameters=function(e){var t=Object.assign({},this.mParameters),i,r=[],s,a=this;function h(n){if(a.oModel.bAutoExpandSelect&&(n==="$expand"||n==="$select")){throw new Error("Cannot change "+n+" parameter in auto-$expand/$select mode: "+JSON.stringify(e[n])+" !== "+JSON.stringify(t[n]))}if(n==="$filter"||n==="$search"){i=o.Filter}else if(n==="$orderby"&&i!==o.Filter){i=o.Sort}else{i??=o.Change}r.push(s)}this.checkTransient();if(!e){throw new Error("Missing map of binding parameters")}for(s in e){if(s.startsWith("$$")){if(this.isUnchangedParameter(s,e[s])){continue}throw new Error("Unsupported parameter: "+s)}if(e[s]===undefined&&t[s]!==undefined){h(s);delete t[s]}else if(t[s]!==e[s]){h(s);if(typeof e[s]==="object"){t[s]=n.clone(e[s])}else{t[s]=e[s]}}}if(i){if(this.hasPendingChanges(true)){throw new Error("Cannot change parameters due to pending changes")}this.applyParameters(t,i,r)}};s.prototype.checkUpdateInternal=function(e){var t=this;function n(){return r.all(t.getDependentBindings().map(function(e){return e.checkUpdateInternal()}))}if(e!==undefined){throw new Error("Unsupported operation: "+a+"#checkUpdateInternal must not"+" be called with parameters")}return this.oCachePromise.then(function(e){if(e&&t.bRelative){return t.fetchResourcePath(t.oContext).then(function(i){if(e.getResourcePath()===i){return n()}return t.refreshInternal("")})}return n()})};s.prototype.createInCache=function(e,t,i,r,o,s,a,h){var u=this;return this.oCachePromise.then(function(c){var d;if(c){d=n.getRelativePath(i,u.getResolvedPath());return c.create(e,t,d,r,o,s,a,h).then(function(e){if(u.mCacheByResourcePath){delete u.mCacheByResourcePath[c.getResourcePath()]}return e})}return u.oContext.getBinding().createInCache(e,t,i,r,o,s,a,h)})};s.prototype.createReadGroupLock=function(e,t,n){var r,o=this;function s(){o.oModel.addPrerenderingTask(function(){if(o.oReadGroupLock===r){n-=1;if(n>0){Promise.resolve().then(s)}else{i.debug("Timeout: unlocked "+r,null,a);o.removeReadGroupLock()}}})}this.removeReadGroupLock();this.oReadGroupLock=r=this.lockGroup(e,t);if(t){n=2+(n||0);s()}};s.prototype.createRefreshPromise=function(e){var t,n;t=new Promise(function(e){n=e});t.$preventBubbling=e;t.$resolve=n;this.oRefreshPromise=t;return t};s.prototype.deleteFromCache=function(e,t,n,i,r){return this.withCache(function(n,o){return n._delete(e,t,o,i,r)},n,true)};s.prototype.destroy=function(){this.mAggregatedQueryOptions=undefined;this.aChildCanUseCachePromises=[];this.mChildPathsReducedToParent={};this.removeReadGroupLock();this.oRefreshPromise=undefined;this.oResumePromise=undefined;this.mCanUseCachePromiseByChildPath=undefined;t.prototype.destroy.call(this)};s.prototype.detachPatchCompleted=function(e,t){return this.detachEvent("patchCompleted",e,t)};s.prototype.detachPatchSent=function(e,t){return this.detachEvent("patchSent",e,t)};s.prototype.doSuspend=function(){};s.prototype.fetchIfChildCanUseCache=function(t,o,s,h){var u=this.getBaseForPathReduction(),c,d,f,p=t.getPath().includes("(...)"),l=t.getIndex(),g=o[0]==="#",P=this.oModel.getMetaModel(),m=this.oContext,y,C=this.oModel.resolve(o,t),v=this;function R(){if(g){return P.fetchObject(c+"/")}return n.fetchPropertyAndType(v.oModel.oInterface.fetchMetadata,O(C))}function O(e){var t;e=n.getMetaPath(e);t=e.indexOf("@");return t>0?e.slice(0,t):e}if(p&&!C.includes("/$Parameter/")||this.isRootBindingSuspended()||n.isDataAggregation(this.mParameters)){return r.resolve(C)}f=this.mCanUseCachePromiseByChildPath[o];if(h&&this.oCache!==null&&f){return f.then(function(e){if(!e){return undefined}if(!o.includes("/")||n.getMetaPath(e)===n.getMetaPath(C)){return C}return P.getReducedPath(C,u)})}d=this.oCachePromise.isRejected()||l!==undefined&&l!==e.VIRTUAL||t.isEffectivelyKeptAlive()||this.oCache===null||this.oCache&&this.oCache.hasSentRequest();c=n.getMetaPath(t.getPath());y=[this.doFetchOrGetQueryOptions(m),R(),s];f=r.all(y).then(function(e){var t=e[2]||{},r,s=e[0],f=e[1],l,y;if(Array.isArray(f)){return undefined}y=P.getReducedPath(C,u);l=n.getRelativePath(O(y),c);if(l===undefined){v.mChildPathsReducedToParent[o]=true;return m.getBinding().fetchIfChildCanUseCache(m,n.getRelativePath(C,m.getPath()),t,h)}if(p||l==="$count"||l.endsWith("/$count")||l==="$selectionCount"){return y}if(v.bAggregatedQueryOptionsInitial){v.mAggregatedQueryOptions=n.clone(s);v.selectKeyProperties(v.mAggregatedQueryOptions,c);v.bAggregatedQueryOptionsInitial=false}if(g){r={$select:[l.slice(1)]};return v.aggregateQueryOptions(r,c,d,h)?y:undefined}if(l===""||f&&(f.$kind==="Property"||f.$kind==="NavigationProperty")){r=n.wrapChildQueryOptions(c,l,t,v.oModel.oInterface.fetchMetadata);if(r){return v.aggregateQueryOptions(r,c,d,h)?y:undefined}return undefined}if(l==="value"){return v.aggregateQueryOptions(t,c,d,h)?y:undefined}i.error("Failed to enhance query options for auto-$expand/$select as the path '"+C+"' does not point to a property",JSON.stringify(f),a);return undefined}).then(function(e){if(v.mLateQueryOptions&&!v.isTransient()){if(v.oCache){v.oCache.setLateQueryOptions(v.mLateQueryOptions)}else if(v.oCache===null){return m.getBinding().fetchIfChildCanUseCache(m,v.sPath,v.mLateQueryOptions).then(function(t){return t&&e})}}return e});if(h&&this.oCache!==null&&!t.getPath().includes("($uid=")){this.mCanUseCachePromiseByChildPath[o]=f}this.aChildCanUseCachePromises.push(f);const $=d?f:r.all([this.oCachePromise,f]).then(function(e){var i=e[0];if(i&&!i.hasSentRequest()&&!v.oOperation){if(v.bSharedRequest){i.setActive(false);i=v.createAndSetCache(v.mAggregatedQueryOptions,i.getResourcePath(),t)}else{i.setQueryOptions(n.merge({},v.oModel.mUriParameters,v.mAggregatedQueryOptions))}}return i});$.catch(function(e){v.oModel.reportError(v+": Failed to enhance query options for "+"auto-$expand/$select for child "+o,a,e)});if(!d){this.oCachePromise=$}return f};s.prototype.fetchResolvedQueryOptions=function(e){var t,i,o,s=this.oModel,a=this.getQueryOptionsFromParameters(),h=this;if(!(s.bAutoExpandSelect&&a.$select)){return r.resolve(a)}t=s.oInterface.fetchMetadata;o=n.getMetaPath(s.resolve(this.sPath,e));i=Object.assign({},n.clone(a),{$select:[]});return r.all(a.$select.map(function(e){var r=o+"/"+e;if(r.endsWith(".*")){r=r.slice(0,-1)}return n.fetchPropertyAndType(t,r).then(function(s){if(!s&&!r.endsWith("/*")){throw new Error("Invalid (navigation) property '"+e+"' in $select of "+h)}const a=n.wrapChildQueryOptions(o,e,{},t);if(a){n.aggregateExpandSelect(i,a)}else{n.addToSelect(i,[e])}})})).then(function(){return i})};s.prototype.firePatchCompleted=function(e){if(this.iPatchCounter===0){throw new Error("Completed more PATCH requests than sent")}this.iPatchCounter-=1;this.bPatchSuccess&&=e;if(this.iPatchCounter===0){this.fireEvent("patchCompleted",{success:this.bPatchSuccess});this.bPatchSuccess=true}};s.prototype.firePatchSent=function(){this.iPatchCounter+=1;if(this.iPatchCounter===1){this.fireEvent("patchSent")}};s.prototype.getBaseForPathReduction=function(){var e,t;if(!this.isRoot()){e=this.oContext.getBinding();t=e.getUpdateGroupId();if(t===this.getUpdateGroupId()||!this.oModel.isApiGroup(t)){return e.getBaseForPathReduction()}}return this.getResolvedPath()};s.prototype.getGeneration=function(){return this.bRelative&&this.oContext.getGeneration&&this.oContext.getGeneration()||0};s.prototype.getInheritableQueryOptions=function(){if(this.mLateQueryOptions){return n.merge({},this.mCacheQueryOptions,this.mLateQueryOptions)}return this.mCacheQueryOptions||n.getQueryOptionsForPath(this.oContext.getBinding().getInheritableQueryOptions(),this.sPath)};s.prototype.getQueryOptionsForPath=function(e,t){if(!n.isEmptyObject(this.mParameters)){return n.getQueryOptionsForPath(this.getQueryOptionsFromParameters(),e)}t??=this.oContext;if(!this.bRelative||!t.getQueryOptionsForPath){return{}}return t.getQueryOptionsForPath(n.buildPath(this.sPath,e))};s.prototype.getResumePromise=function(){return this.oResumePromise};s.prototype.hasPendingChangesInDependents=function(e,t){return this.getDependentBindings().some(function(n){var i=n.oCache,r,o=e;if(o){if(n.oContext.isEffectivelyKeptAlive()){return false}if(n.oContext.getIndex()!==undefined){o=false}}if(i!==undefined){if(i&&i.hasPendingChangesForPath("",false,o&&n.mParameters&&n.mParameters.$$ownRequest)){return true}}else if(n.hasPendingChangesForPath("")){return true}if(n.mCacheByResourcePath){r=Object.keys(n.mCacheByResourcePath).some(function(e){var r=n.mCacheByResourcePath[e];return(!t||e.startsWith(t.slice(1)))&&r!==i&&r.hasPendingChangesForPath("")});if(r){return true}}return n.hasPendingChangesInDependents(o,t)})||this.oModel.withUnresolvedBindings("hasPendingChangesInCaches",this.getResolvedPath().slice(1))};s.prototype.isMeta=function(){return false};s.prototype.isPatchWithoutSideEffects=function(){return this.mParameters.$$patchWithoutSideEffects||!this.isRoot()&&this.oContext&&this.oContext.getBinding().isPatchWithoutSideEffects()};s.prototype.isRefreshWithoutBubbling=function(){return this.oRefreshPromise&&this.oRefreshPromise.$preventBubbling};s.prototype.isUnchangedParameter=function(e,t){return this.mParameters[e]===t};s.prototype.onDelete=function(e){var t=this.findContextForCanonicalPath(e);if(t){this.resetChangesForPath(this.getRelativePath(t.getPath()),[]);this.oModel.getDependentBindings(t).forEach(function(e){e.resetChanges()});this.delete(null,e.slice(1),t)}};s.prototype.refreshDependentListBindingsWithoutCache=function(){return r.all(this.getDependentBindings().map(function(e){if(e.filter&&e.oCache===null){return e.refreshInternal("")}if(e.refreshDependentListBindingsWithoutCache){return e.refreshDependentListBindingsWithoutCache()}}))};s.prototype.removeReadGroupLock=function(){if(this.oReadGroupLock){this.oReadGroupLock.unlock(true);this.oReadGroupLock=undefined}};s.prototype.resetChangesInDependents=function(e,t){this.getDependentBindings().forEach(function(n){e.push(n.oCachePromise.then(function(e){if(e){e.resetChangesForPath("")}n.resetInvalidDataState()}).unwrap());if(n.mCacheByResourcePath){Object.keys(n.mCacheByResourcePath).forEach(function(e){if(!t||e.startsWith(t.slice(1))){n.mCacheByResourcePath[e].resetChangesForPath("")}})}n.resetChangesInDependents(e,t)})};s.prototype.resolveRefreshPromise=function(e){if(this.oRefreshPromise){this.oRefreshPromise.$resolve(e.catch(function(e){if(!e.canceled){throw e}}));this.oRefreshPromise=null}return e};s.prototype.resume=function(){this._resume(false)};s.prototype.resumeAsync=function(){this._resume(true);return Promise.resolve(this.oResumePromise)};s.prototype.selectKeyProperties=function(e,t){n.selectKeyProperties(e,this.oModel.getMetaModel().getObject(t+"/"))};s.prototype.suspend=function(){var e;if(this.oOperation){throw new Error("Cannot suspend an operation binding: "+this)}if(!this.isRoot()){throw new Error("Cannot suspend a relative binding: "+this)}if(this.bSuspended){throw new Error("Cannot suspend a suspended binding: "+this)}if(this.hasPendingChanges(true)){throw new Error("Cannot suspend a binding with pending changes: "+this)}this.bSuspended=true;this.oResumePromise=new r(function(t){e=t});this.oResumePromise.$resolve=e;this.removeReadGroupLock();this.doSuspend()};s.prototype.updateAfterCreate=function(e,t){return r.all(this.getDependentBindings().map(function(n){return n.updateAfterCreate(e,t)}))};s.prototype.updateAggregatedQueryOptions=function(e){var t=this.mAggregatedQueryOptions,n=Object.keys(e),i=this;if(t){n=n.concat(Object.keys(t));n.forEach(function(n){if(i.bAggregatedQueryOptionsInitial||n!=="$select"&&n!=="$expand"){if(e[n]===undefined){delete t[n]}else{t[n]=e[n]}}});if(t.$select&&!t.$select.length){t.$select=[Object.keys(t.$expand)[0]]}}};s.prototype.visitSideEffects=function(e,t,i,r,o){var s=i?this.oModel.getDependentBindings(i):this.getDependentBindings();s.forEach(function(i){var s=n.buildPath(o,i.oOperation?"":n.getMetaPath(i.getPath())),a;if(i.oCache){a=n.stripPathPrefix(s,t);if(a.length){r.push(i.requestSideEffects(e,a))}}else{i.visitSideEffects(e,t,null,r,s)}})};function h(e){if(this){s.apply(this,arguments)}else{Object.assign(e,s.prototype)}}["adjustPredicate","destroy","getGeneration","hasPendingChangesForPath","isUnchangedParameter","updateAfterCreate"].forEach(function(e){h.prototype[e]=s.prototype[e]});return h},false);
//# sourceMappingURL=ODataParentBinding.js.map